<!DOCTYPE html>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ page session="false" %>
<%@ include file="/common/taglibsT3.jsp" %>

<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>
<c:choose>
	<c:when test="${empty productName}">
		SAS&reg; Fraud Management
	</c:when>
	<c:otherwise>
		${fn:replace(fn:replace(productName, "<sup>", ""), "</sup>", "")}
	</c:otherwise>
</c:choose>
</title>
<script language="JavaScript" src="common/scripts/jquery.js" type="text/javascript"></script>
<script language="JavaScript" src="common/scripts/cf.js" type="text/javascript"></script>
<script language="JavaScript" src="common/scripts/sasSolutions.js" type="text/javascript"></script>
<script language="JavaScript">
function showBuildInfo()
{
	var applicationBuildID = "60.20.0.0";
	if(applicationBuildID.indexOf('@') > -1)
		applicationBuildID = "<unknown>";

	var lastModified = "6020001.20251118.0933";
	if(lastModified.indexOf('@') > -1)
		lastModified = "<unknown>";

	alert("<fmt:message key='creditfraud.application.buildInfo.txt' />:  " + applicationBuildID + "\n" +
			"<fmt:message key='creditfraud.application.lastPageModified.txt' />:  " + lastModified);
}
</script>

<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_base/fonts.css" type="text/css"/>
<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="resources/sas/hc/ui/commons/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="resources/sap/m/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="common/styles/sasStyles.css" type="text/css" media="SCREEN"/>
<link rel="stylesheet" href="common/styles/cf.css" type="text/css" media="SCREEN"/>
<link rel="stylesheet" href="common/styles/login.css" type="text/css">
</head>

<body marginheight="0" marginwidth="0" class="bg">

<c:choose>
<c:when test="${not empty loginError}">
	<c:set var="formURL" value="/commonAuthentication.action" />
	<c:set var="formUser" value="username" />
	<c:set var="formPass" value="password" />
</c:when>
<c:when test="${param.auth == 'jcheck'}">
	<c:set var="formURL" value="j_security_check" />
	<c:set var="formUser" value="j_username" />
	<c:set var="formPass" value="j_password" />
</c:when>
<c:when test="${param.auth == 'jerror'}">
	<c:set var="formURL" value="j_security_check" />
	<c:set var="formUser" value="j_username" />
	<c:set var="formPass" value="j_password" />
</c:when>
<c:otherwise>
	<c:set var="formURL" value="/commonAuthentication.action" />
	<c:set var="formUser" value="username" />
	<c:set var="formPass" value="password" />
</c:otherwise>
</c:choose>

<div id="loginbox">
<form action="<c:url value='${formURL}' />" method="post">
    <h1>
		<c:choose>
			<c:when test="${empty productName}">
				SAS&reg; Fraud Management
			</c:when>
			<c:otherwise>
				${productName}
			</c:otherwise>
		</c:choose>
    </h1>

	<c:choose>
		<c:when test="${not empty loginError}">
			<div class="logerror">
				<c:out value="${loginError}" />
			</div>
		</c:when>
		<c:when test="${param.auth == 'jerror'}">
			<div class="logerror">
				<fmt:message key='creditfraud.login.authenticationError.txt' />
			</div>
		</c:when>
	</c:choose>

	<c:if test="${URI != null}">
		<INPUT type="hidden" name="URI" value="<c:out value="${URI}" />" ID="Hidden1">
	<c:forEach var="parm" items="${parms}">
		<c:if test="${(parm.name!=formUser) && (parm.name != formPass)}">
			<INPUT type="hidden" name="<c:out value="${parm.name}" />"
				value="<c:out value="${parm.value}" />" ID="Hidden2">
		</c:if>
	</c:forEach>
	</c:if>
	<div class="labelDiv">
    <label for="${formUser}"><fmt:message key='creditfraud.login.username.txt' /></label>
    </div>
	<div>
    <input name="${formUser}" tabindex="3" id="username" autofocus="true" type="text" value="" autocomplete="off">
    </div>

	<div class="labelDiv">
    <label for="${formPass}"><fmt:message key='creditfraud.login.password.txt' /></label>
    </div>
	<div>
    <input name="${formPass}" tabindex="4" id="password" type="password" size="25" value="" autocomplete="off">
    </div>

	<div>
    	<button title="<fmt:message key='creditfraud.login.logon.txt' />" class="btn-submit" type="submit" onclick="this.form.submit();return false;"><fmt:message key='creditfraud.login.logon.txt' /></button>
    </div>

    <div class="aboutcontainer"> <!--about link-->
        <a title="About" class="about" onclick="showBuildInfo()" href="#">About</a>

		<div class="copyright"><!--copyright statement-->
			<fmt:message key="creditfraud.application.copyright.fmt.txt"><fmt:param>2025</fmt:param></fmt:message>
		</div>
    </div>
</form>
</div>

</body>
</html>
