<%@ page language="java" contentType="text/html; charset=UTF-8"
         pageEncoding="UTF-8"%>
<%@ taglib uri="http://www.sas.com/taglib/sas-html" prefix="sas-html" %>
<%@ taglib prefix="c"      uri="http://java.sun.com/jsp/jstl/core" %>
<%@ taglib prefix="fmt"    uri="http://java.sun.com/jsp/jstl/fmt" %>
<%@ taglib prefix="fn"     uri="http://java.sun.com/jsp/jstl/functions" %>
<%@ taglib prefix="esapi"  uri="/META-INF/tld/esapi.tld" %>

<!-- if enabled, this hides the erroneous date in the nonconfigurable HTML Commons splash footer 
<style type="text/css">
	#sas-hc-splash .SplashFooterInnerContainer .SplashFooter{
		visibility:hidden !important;
	}
</style>
-->

<c:set var="productTitle" value="SAS Fraud Management"/>
<c:if test="${not empty productName}">
<c:set var="productTitle" value="${productName}"/>
</c:if>
<c:if test="${not empty productType}">
<c:set var="productTitle" value="${productTitle} - ${productType}"/>
</c:if>

<c:set var="tabs" value="["/>
<c:if test="${empty popoutTab}">
<c:forEach var="tab" items="${tabList}">
	<c:set var="tabs" value="${tabs}{'name':'${fn:toUpperCase(fn:substring(tab.name, 0, 1))}${fn:substring(tab.name, 1,fn:length(tab.name))}', 'label':'${tab.label}'},"/>
</c:forEach>
</c:if>
<c:if test="${not empty popoutTab}">
	<c:set var="tabs" value="${tabs}{'name':'${fn:toUpperCase(fn:substring(popoutTab.name, 0, 1))}${fn:substring(popoutTab.name, 1,fn:length(popoutTab.name))}', 'label':'${popoutTab.label}'},"/>
	<!--  very important to remove from session after we have used it -->
	<c:remove var="popoutTab" scope="session" />
</c:if>
<c:set var="tabs" value="${tabs}]"/>

<c:set var="userLastLoginMsg">
<fmt:message key="creditfraud.banner.lastlogintime.txt" />: <fmt:formatDate value="${PRINCIPAL.lastLoginTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}"/>
</c:set>

<fmt:parseNumber var="intSessionTimeout" type="number" integerOnly="true" parseLocale="en-US" value="${pageContext.session.maxInactiveInterval}" />
<fmt:parseNumber var="intSessionTimeoutWarningDuration" type="number" integerOnly="true" parseLocale="en-US" value="${intSessionTimeout / 6}" />

<sas-html:Application
        applicationName="${productTitle}"
        applicationId="sas-fscf"
        jsViewClass="sas.fscf.Application"
        configFile="config.js">

    <!-- Application-specific config properties -->
    <sas-html:config-property name="sas.fscf" value="{}" quote="false" />
    <sas-html:config-property name="sas.fscf.userId" value="${esapi:encodeForHTML(PRINCIPAL.username)}" />
    <sas-html:config-property name="sas.fscf.userLastLoginMsg" value="${esapi:encodeForHTML(userLastLoginMsg)}" />
    <sas-html:config-property name="sas.fscf.tabs" value="${tabs}" quote="false" />
    <sas-html:config-property name="sas.fscf.dateFormat" value="${dateFormat}" />
    <sas-html:config-property name="sas.fscf.timeFormat" value="${timeFormat}" />
    <sas-html:config-property name="sas.fscf.dateTimeFormat" value="${dateTimeFormat}" />
    <sas-html:config-property name="sas.fscf.numericFormat" value="${numericFormat}" />
    <sas-html:config-property name="sas.fscf.decimalFormat" value="${decimalFormat}" />
    <sas-html:config-property name="sas.fscf.currencyFormat" value="${currencyFormat}" />    
    <sas-html:config-property name="sas.fscf.defaultAlertColumns" value="${defaultAlertColumns}" />
    <sas-html:config-property name="sas.fscf.defaultRelatedRowsColumns" value="${defaultRelatedRowsColumns}" />
    <sas-html:config-property name="sas.fscf.exploreDefaultRelatedRowsColumns" value="${exploreDefaultRelatedRowsColumns}" />
    <sas-html:config-property name="sas.fscf.exploreFields" value="${exploreFields}" />
    <sas-html:config-property name="sas.fscf.enableDynamicLookupLists" value="${enableDynamicLookupLists}" quote="false" />
    <sas-html:config-property name="sas.fscf.deployTestingRules" value="${deployTestingRules}" quote="false" />
    <sas-html:config-property name="sas.sas_fscf" value="{}" quote="false" />
    <sas-html:config-property name="sas.sas_fscf.help" value="{}" quote="false" />
    <sas-html:config-property name="sas.sas_fscf.help.productName" value="FRAUDAPPMID" />
    <sas-html:config-property name="sas.sas_fscf.help.macroVersion" value="4.4" />
    <sas-html:config-property name="sas.sas_fscf.help.defaultTopic" value="frmwbug.hlp/home.htm" />
    <sas-html:config-property name="sas.servicePlatform" value="WIP" />
    <sas-html:config-property name="sas.copyrightStartYear" value="2002" />
    <sas-html:config-property name="sas.copyrightEndYear" value="2025" />
    <sas-html:config-property name="sas.sessionMaxInActiveInterval" value="${intSessionTimeout}" quote="false" />
    <sas-html:config-property name="sas.sessionTimeoutWarningDuration" value="${intSessionTimeoutWarningDuration}" quote="false" />
    <sas-html:config-property name="sas.sessionTimeoutUrl" value="Logoff" />
</sas-html:Application>
