<%-- this file uses leading tabs; don't insert leading spaces --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>
<tiles:importAttribute ignore="true"/>

<% 
String separatorStr = String.valueOf((char)Integer.parseInt("1F", 16));
request.setAttribute("separatorStr", separatorStr);
%>

<c:set var="imageName" value="${messageSuccessImage}" />
<c:set var="className" value="confirmationMessage" />
<c:set var="rowspan" value="1"/>
<c:if test="${not empty errorMessage}">
	<c:set var="imageName" value="${messageErrorImage}" />
	<c:set var="className" value="errorMessage" />
	<c:set var="rowspan" value="2"/>
</c:if>

<c:set var="genericErrorMsg"><fmt:message key="creditfraud.application.error.txt" /></c:set>
<c:set var="genericErrorDetailMsg"><fmt:message key="creditfraud.application.error.details.txt" /></c:set>

<c:if test="${not empty confirmationMessage && empty errorMessage}">
	<div class="inlineMessage inlineMessageSuccess">
		<div class="inlineMessageIcon">
			<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf160;"></span>
		</div>

		<div class="inlineMessageMessage">
			<fmt:message key = "${esapi:encodeForHTML(confirmationMessage)}">
			<c:if test = "${not empty confirmationMsgParams}" >
				<c:forTokens var = 'msgParams' items='${confirmationMsgParams}' delims='${separatorStr}'>
					<fmt:param>${esapi:encodeForHTML(msgParams)}</fmt:param>
				</c:forTokens>
			</c:if>
			</fmt:message>
		</div>
		<div class="inlineMessageClose">
			<a href="#" title="<fmt:message key="creditfraud.common.systemMessages.close.txt"/>" onclick="this.parentNode.parentNode.style.display='none';">
				<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf10c;"></span>
			</a>
		</div>
	</div>
</c:if>

<c:if test="${not empty errorMessage}">
	<div class="inlineMessage inlineMessageError">
		<div class="inlineMessageIcon">
			<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf22f;"></span>
		</div>
		<div class="inlineMessageMessage">
			<c:if test="${not empty confirmationMessage}">
				<fmt:message key = "${esapi:encodeForHTML(confirmationMessage)}">
				<c:if test = "${not empty confirmationMsgParams}" >
					<c:forTokens var = 'msgParams' items='${confirmationMsgParams}' delims='${separatorStr}'>
						<fmt:param>${esapi:encodeForHTML(msgParams)}</fmt:param>
					</c:forTokens>
				</c:if>
				</fmt:message>
				<br/>
			</c:if>

			<c:if test="${not empty errorMessageList}">
				<c:forEach var="msg" items="${errorMessageList}">
  				${fn:escapeXml(msg)}
  				<br>
  			  </c:forEach>
			</c:if>
			<c:if test="${empty errorMessageList}">
				${esapi:encodeForHTML(sfmfn:alternative(errorMessage, genericErrorMsg))}
			</c:if>

			<c:if test="${not empty lockingError}">
				<br/><tiles:insertAttribute name="lockingErrorInformation"/>
			</c:if>
			<c:if test="${not empty errorDetails}">
				<div style="text-align:left">
				<c:forEach var="err" items="${errorDetails}">
					<br/>${esapi:encodeForHTML(sfmfn:alternative(err, genericErrorDetailMsg))}
				</c:forEach>
				</div>
			</c:if>
		</div>
		<div class="inlineMessageClose">
			<a href="#" title="<fmt:message key="creditfraud.common.systemMessages.close.txt"/>" onclick="this.parentNode.parentNode.style.display='none';">
				<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf10c;"></span>
			</a>
		</div>
	</div>
</c:if>

<c:if test="${not empty warningMessage || not empty warningMessageList}">
	<div class="inlineMessage inlineMessageWarning">
		<div class="inlineMessageIcon">
			<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf018;"></span>
		</div>
		<div class="inlineMessageMessage">
			<c:if test="${empty warningMessageList}">
				<fmt:message key="${esapi:encodeForHTML(warningMessage)}"/>
			</c:if>
			<c:if test="${not empty warningMessageList}">
			  <c:forEach var="msg" items="${warningMessageList}">
  				${fn:escapeXml(msg)}
  				<br>
  			  </c:forEach>
			</c:if>
		</div>
		<div class="inlineMessageClose">
			<a href="#" title="<fmt:message key="creditfraud.common.systemMessages.close.txt"/>" onclick="this.parentNode.parentNode.style.display='none';">
				<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf10c;"></span>
			</a>
		</div>
	</div>
</c:if>

