var DateUtil = new function()
{
	var isInitialized = false;

	var dateFormat = "MM/dd/yyyy";
	var timeFormat = "HH:mm:ss";
	var dateTimeFormat = dateFormat + " " + timeFormat;

	var MONTH_NAMES = null;
	var DAY_NAMES = null;
	var AMPM_NAMES = null;

	this.setMonthNames = function(value){if(value)MONTH_NAMES = value.split(',');}
	this.setDayNames = function(value){if(value)DAY_NAMES = value.split(',');}
	this.setAmPmNames = function(value) {if (value) AMPM_NAMES = value.split(',');}

	this.setDefaultDateFormat = function(format){ dateFormat = format; }
	this.setDefaultTimeFormat = function(format){ timeFormat = format; }
	this.setDefaultDateTimeFormat = function(format){ dateTimeFormat = format.replace('.SSS','.000'); }

	this.getDefaultDateFormat = function(){ return dateFormat; }
	this.getDefaultTimeFormat = function(){ return timeFormat; }
	this.getDefaultDateTimeFormat = function(){ return dateTimeFormat; }

	// copied here for local usage; so no dependencies on other js files
	this.LZ = function(x){ return(x<0||x>9?"":"0")+x }
	this._isInteger = function(val){var digits="1234567890";for(var i=0;i < val.length;i++){if(digits.indexOf(val.charAt(i))==-1){return false;}}return true;}
	this._getInt = function(str,i,minlength,maxlength){for(var x=maxlength;x>=minlength;x--){var token=str.substring(i,i+x);if(token.length < minlength){return null;}if(this._isInteger(token)){return token;}}return null;}
	// end local usage

	this.convertToString = function(date,format){ format=format+""; var result=""; var i_format=0; var c=""; var token=""; var y=date.getYear()+""; var M=date.getMonth()+1; var d=date.getDate(); var E=date.getDay(); var H=date.getHours(); var m=date.getMinutes(); var s=date.getSeconds(); var yyyy,yy,MMM,MM,dd,hh,h,mm,ss,ampm,HH,H,KK,K,kk,k,Z,z; var value=new Object(); if (y.length < 4) {y=""+(y-0+1900);} value["y"]=""+y; value["yyyy"]=y; value["yy"]=y.substring(2,4); value["M"]=M; value["MM"]=this.LZ(M); value["MMM"]=MONTH_NAMES[M+12]; value["MMMM"]=MONTH_NAMES[M-1]; value["d"]=d; value["dd"]=this.LZ(d); value["E"]=DAY_NAMES[E+7]; value["EE"]=DAY_NAMES[E+7]; value["EEE"]=DAY_NAMES[E+7]; value["EEEE"]=DAY_NAMES[E]; value["H"]=H; value["HH"]=this.LZ(H); if (H==0){value["h"]=12;} else if (H>12){value["h"]=H-12;} else {value["h"]=H;} value["hh"]=this.LZ(value["h"]); if (H>11){value["K"]=H-12;} else {value["K"]=H;} value["k"]=H+1; value["KK"]=this.LZ(value["K"]); value["kk"]=this.LZ(value["k"]); value["Z"]=value["ZZZZ"]=this.getLocalTimeZone('Z'); value["z"]=value["zz"]=value["zzz"]=value["zzzz"]=this.getLocalTimeZone('z');if (H > 11) { value["a"]=AMPM_NAMES[1]; } else { value["a"]=AMPM_NAMES[0]; } value["m"]=m; value["mm"]=this.LZ(m); value["s"]=s; value["ss"]=this.LZ(s); while (i_format < format.length) { c=format.charAt(i_format); token=""; while ((format.charAt(i_format)==c) && (i_format < format.length)) { token += format.charAt(i_format++); } if (value[token] != null) { result=result + value[token]; } else { result=result + token; } } return result; }
	this.formatDate 	  = function(date,format){ if(typeof(format) == "undefined") format = dateFormat; return this.convertToString(date,format);}
	this.formatTime 	  = function(date,format){ if(typeof(format) == "undefined") format = timeFormat; return this.convertToString(date,format);}
	this.formatDateTime = function(date,format){ if(typeof(format) == "undefined") format = dateTimeFormat; return this.convertToString(date,format);}

	this.convertToDate = function(value,format){ var val=value+"";format=format+"";var i_val=0;var i_format=0;var c="";var token="";var token2="";var x,y;var year=1970;var month=1;var date=1;var hh=0;var mm=0;var ss=0;var ampm="";while(i_format < format.length){c=format.charAt(i_format);token="";while((format.charAt(i_format)==c) &&(i_format < format.length)){token += format.charAt(i_format++);}if(token=="yyyy" || token=="yy" || token=="y"){if(token=="yyyy"){x=4;y=4;}if(token=="yy"){x=2;y=2;}if(token=="y"){x=2;y=4;}year=this._getInt(val,i_val,x,y);if(year==null){return new Date(0);}i_val += year.length;if(year.length==2){if(year > 70){year=1900+(year-0);}else{year=2000+(year-0);}}}else if(token=="MMMM"||token=="MMM"){month=0;for(var i=0;i<MONTH_NAMES.length;i++){var month_name=MONTH_NAMES[i];if (month_name.length>0){if(val.substring(i_val,i_val+month_name.length).toLowerCase()==month_name.toLowerCase()){if(i>12){month=i+1;if(month>13){month -= 13;}i_val += month_name.length;break;}}}}if((month < 1)||(month>13)){return new Date(0);}}else if(token=="EEEE"||token=="EEE"||token=="EE"||token=="E"){for(var i=0;i<DAY_NAMES.length;i++){var day_name=DAY_NAMES[i];if(val.substring(i_val,i_val+day_name.length).toLowerCase()==day_name.toLowerCase()){i_val += day_name.length;break;}}}else if(token=="MM"||token=="M"){month=this._getInt(val,i_val,token.length,2);if(month==null||(month<1)||(month>12)){return new Date(0);}i_val+=month.length;}else if(token=="dd"||token=="d"){date=this._getInt(val,i_val,token.length,2);if(date==null||(date<1)||(date>31)){return new Date(0);}i_val+=date.length;}else if(token=="hh"||token=="h"){hh=this._getInt(val,i_val,token.length,2);if(hh==null||(hh<1)||(hh>12)){return new Date(0);}i_val+=hh.length;}else if(token=="HH"||token=="H"){hh=this._getInt(val,i_val,token.length,2);if(hh==null||(hh<0)||(hh>23)){return new Date(0);}i_val+=hh.length;}else if(token=="KK"||token=="K"){hh=this._getInt(val,i_val,token.length,2);if(hh==null||(hh<0)||(hh>11)){return new Date(0);}i_val+=hh.length;}else if(token=="kk"||token=="k"){hh=this._getInt(val,i_val,token.length,2);if(hh==null||(hh<1)||(hh>24)){return new Date(0);}i_val+=hh.length;hh--;}else if(token=="mm"||token=="m"){mm=this._getInt(val,i_val,token.length,2);if(mm==null||(mm<0)||(mm>59)){return new Date(0);}i_val+=mm.length;}else if(token=="ss"||token=="s"){ss=this._getInt(val,i_val,token.length,2);if(ss==null||(ss<0)||(ss>59)){return new Date(0);}i_val+=ss.length;}else if(token=="a"){if(val.substring(i_val,i_val+2).toLowerCase()==AMPM_NAMES[0].toLowerCase()){ampm=AMPM_NAMES[0];}else if(val.substring(i_val,i_val+2).toLowerCase()==AMPM_NAMES[1].toLowerCase()){ampm=AMPM_NAMES[1];}else{return new Date(0);}i_val+=2;}/*stboyd start*/else if(token.match('Z+')){i_val+=5;}else if(token.match('z+')){val = val.replace(/GMT([+-]\d\d:\d\d)?/,'')}/*stboyd end*/else{if(val.substring(i_val,i_val+token.length)!=token){return new Date(0);}else{i_val+=token.length;}}}if(i_val != val.length){return new Date(0);}if(month==2){if( ((year%4==0)&&(year%100 != 0) ) ||(year%400==0) ){if(date > 29){return new Date(0);}}else{if(date > 28){return new Date(0);}}}if((month==4)||(month==6)||(month==9)||(month==11)){if(date > 30){return new Date(0);}}if(hh<12 && ampm==AMPM_NAMES[1]){hh=hh-0+12;}else if(hh>11 && ampm==AMPM_NAMES[0]){hh-=12;}var newdate=new Date(year,month-1,date,hh,mm,ss);return newdate;}
	this.parseDate 	 = function(value,format){ if(typeof(format) == "undefined") format = dateFormat; return this.convertToDate(value,format);}
	this.parseTime 	 = function(value,format){ if(typeof(format) == "undefined") format = timeFormat; return this.convertToDate(value,format);}
	this.parseDateTime = function(value,format){ if(typeof(format) == "undefined") format = dateTimeFormat; return this.convertToDate(value,format);}

	this.getLocalTime = function(ts)
	{
		var d = new Date(ts);
		var offset = d.getTimezoneOffset();
		d.setMinutes(d.getMinutes()-offset);
		return d;
	}

	this.getLocalTimeZone = function(tzFormat)
	{
		var offset = -1*new Date().getTimezoneOffset()/60.0; // hour offset
		var sign = (offset >= 0 ? "+" : "-");
		var hour = this.LZ(Math.abs(Math.floor(offset)));
		var min = this.LZ(Math.abs(offset*60%60));
		var gmt = "GMT";
		var dlm = ":";

		if(tzFormat && tzFormat.match('Z+'))
			gmt = dlm = "";
		return gmt + sign + hour + dlm + min;
	}
}