if(!window.console) console = { log: function(){} }

/**
 * Sets the cookie for a 24 hour period
 *
 */
function setCookie(name,value,expireDate)
{
	if(!value || value == '')
	{
		removeCookie(name,'');
		return;
	}

	var theDate;
	if(expireDate)
	{
		theDate = expireDate;
	}
	else
	{
		theDate = new Date();
		theDate.setDate(theDate.getDate()+1);
	}

	document.cookie = name + "=" + escape(value) + ";expires=" + theDate.toGMTString();
}

/**
 * Returns the cookie value if it exists. Otherwise, defaultValue is returned.
 */
function getCookie(name,defaultValue)
{
	if (name == "__sfmrt") {
		if (top.sas) {
			return top.sas.fscf.tokenValue();
		} else {
			return defaultValue;
		}
	}
	var cookies = document.cookie.split("; ");
	for(var i=0; i < cookies.length; i++)
	{
		var theCookie = cookies[i].split("=");
		if (name == theCookie[0])
			return unescape(theCookie[1]);
	}

	return defaultValue;
}

/**
 * Expires the cookie
 */
function removeCookie(name,value)
{
	var theDate = new Date();
	theDate.setDate(theDate.getDate()-1);
	document.cookie = name + "=" + escape(value) + ";expires=" + theDate.toGMTString();
}



/**
 * Sets the cookie for the tab (24 hour period)
 *
 */
function setCookieForTab(value,expireDate,suffix)
{
	var cookieName='cf_';
	if (top.sas.fscf.tabBar) {
		cookieName='cf_'+top.sas.fscf.tabBar.getSelectedKey();
	} else {
		cookieName="cf_ITab" + top.sas.config.get('fscf').tabs[0].name;
	}
	if (suffix) {
		cookieName+=suffix;
	}
    //console.log("set cookieName = " + cookieName + ", value = " + value);
  	setCookie(cookieName,	value,expireDate);
}

/**
 * Returns the cookie value for the tab if it exists.  Otherwise, defaultValue is returned.
 */
function getCookieForTab(defaultValue,suffix)
{
	if (!top.sas) {
		return defaultValue;
	}
	var cookieName='cf_';
	if (top.sas.fscf.tabBar) {
		cookieName='cf_'+top.sas.fscf.tabBar.getSelectedKey();
	} else {
		cookieName="cf_ITab" + top.sas.config.get('fscf').tabs[0].name;
	}
	if (suffix) {
		cookieName+=suffix;
	}

  //console.log("get cookieName = " + cookieName + ", value = " + getCookie(cookieName,	defaultValue));
  return getCookie(cookieName,	defaultValue);
}

/**
 * Gets the absolute top position of the element
 */
function getTopPosition(ele)
{
	if (! ele)
		return 0;

	var pt = ele.offsetParent;
	var top = ele.offsetTop;

	while (pt)
	{
		top += pt.offsetTop;
		if (pt.scrollTop) {
			top -= pt.scrollTop;
		}
		pt = pt.offsetParent;
	}

	return top;
}


/**
 * Gets the absolute bottom position of the element
 */
function getBottomPosition(ele)
{
	if (! ele)
		return 0;

	return (getTopPosition(ele) + ele.offsetHeight);
}


/**
 * Gets the absolute left position of the element
 */
function getLeftPosition(ele)
{
	if (! ele)
		return 0;

	var pt = ele.offsetParent;
	var left = ele.offsetLeft;

	while (pt)
	{
		left += pt.offsetLeft;
		if (pt.scrollLeft) {
			left -= pt.scrollLeft;
		}
		pt = pt.offsetParent;
	}

	return left;
}


/**
 * Gets the absolute right position of the element
 */
function getRightPosition(ele)
{
	if (! ele)
		return 0;

	return (getLeftPosition(ele) + ele.offsetWidth);
}

function setBusy(contentName)
{
	//console.log("setBusy " + new Date().getTime());
	if (top.sas && top.sas.fscf.getCurrentDetailView) {
		top.sas.fscf.getCurrentDetailView().setBusyIndicatorDelay(500).setBusy(true);
	}
}

function removeBusy(contentName)
{
	var windowObj = (top != self) ? top : self;

	if(!isDefined(contentName))
		contentName = "frameDiv";

	// Show the content
	var content = windowObj.document.getElementById(contentName);
	if (!content) {
		content = self.document.getElementById(contentName);
	}
	if (content) {
		$("#"+content.id).show();
	}

	if (top.sas && top.sas.fscf.getCurrentDetailView) {
		top.sas.fscf.getCurrentDetailView().setBusy(false);
	}
}


function scrollToSelectedNode(repeat)
{
	if (repeat==null)
		repeat=false;

	var windowObj = (top != self) ? top : self;
	if(windowObj.frames['overview'])
	{
		if (windowObj.frames['overview'].Tree && windowObj.frames['overview'].Tree.showSelectedAdminNode)
		{  // scroll to selected node
			if (repeat)
			{
				// had to do this because the scrolling must wait even after the Tree is loaded.
				window.setTimeout('scrollToSelectedNode()',50);
			}
			else
			{
				windowObj.frames['overview'].Tree.showSelectedAdminNode();
				windowObj.frames['overview'].document.body.scrollLeft = 0;
			}
		}
		else
		{
			window.setTimeout('scrollToSelectedNode(true)', 50);
		}
	}
}
/**
 * The two optional options are <i>topic</i> and <i>locale</i>.
 * If topic is missing, then a special global js variable is referenced, _thisUrl to capture the starting help file.
 * If locale is missing or empty string, then the default help files are used.
 * @param options
 * @return
 */
function openHelp(options)
{
	var w=screen.availWidth;
	var h=screen.availHeight;
	var l=(w-700)/2;
	var t=((h-500)/2)-24;

	var topic = options.topic;
	var locale = options.locale;

	if (!isDefined(topic))
	{
		var windowObj = (top != self) ? top : self;
		topic= windowObj._thisUrl;
  		topic = topic.substring(0, topic.lastIndexOf('.'));
  		topic= topic.toLowerCase();
  	}
	if(!isDefined(locale) || locale.length == 0)
	{
		locale="en_US";
	}
	fcmHelpWin=window.open("Director?_directive=webdocmd_Contents&selectedLocale="+locale+"&selectedProduct=FRAUDAPPMID&macroVersion=60.20&selectedTopic=frmrsug.hlp/"+topic+".htm",
				  "FCMHelpWin",
	           "height=500,width=700,status=no,toolbar=no,menubar=no,location=no,titlebar=no,resizable=yes,top="+t+",left="+l);
}

function logOut()
{
	if (window.name.match('FCMPopupWin.*'))
	{
		if(hasPopoutClosedProperly())
		{
			var popoutWin = findPopoutWindow();
			if(popoutWin.top.closeSpecial)
				popoutWin.top.closeSpecial();
			popoutWin.close();
		}

		// Does window have a special logout function?
		if(top.closeSpecial)
			top.closeSpecial();

		try {
			if (top.ruleWindowCache)
			{
				for (var w in top.ruleWindowCache)
				{
					var ruleWin = top.ruleWindowCache[w];
					if (ruleWin && !ruleWin.closed)
						ruleWin.close();
				}
			}
		}
		catch(e) { }
		if (top.fcmAlertDetailView) {
			if (!top.fcmAlertDetailView.closed) {
				top.fcmAlertDetailView.close();
			}
		}

		if (window.opener.closed)
		{
			window.top.location.href = "Logoff";
		}
		else
		{
			window.opener.parent.location.href = "Logoff";
			window.opener.parent.focus();
			window.close();
		}
	}
	else // not the Popup
	{
		try {
			if (top.ruleWindowCache)
			{
				for (var w in top.ruleWindowCache)
				{
					var ruleWin = top.ruleWindowCache[w];
					if (ruleWin && !ruleWin.closed)
						ruleWin.close();
				}
			}
		}
		catch(e) { }
		if (top.fcmAlertDetailView) {
			if (!top.fcmAlertDetailView.closed) {
				top.fcmAlertDetailView.close();
			}
		}

		// call the opener's logout
		if(opener && !opener.closed && opener.logOut)
		{
			opener.logOut();
		}
		else // opener not available
		{
			// Does window have a special logout function?
			if(top.closeSpecial)
				top.closeSpecial();
			top.location.href = "Logoff";
//			window.close();
		}
	}
}

/**
 *
 */
function pause(numberMillis)
{
	var dialogScript =
		'window.setTimeout(' +
		' function () { window.close(); }, ' + numberMillis + ');';
	var result =
	// For IE5.
	window.showModalDialog(
		'javascript:document.writeln(' +
		'"<script>' + dialogScript + '<' + '/script>")');

/* For NN6, but it requires a trusted script.
			openDialog(
				'javascript:document.writeln(' +
				'"<script>' + dialogScript + '<' + '/script>"',
				'pauseDialog', 'modal=1,width=10,height=10');
*/
}

/**
  * If a string contains escaped XML and it needs to be displayed
  * in a form element dynamically by javascript, then this method
  * should be called to convert the xml back to its ascii representation.
  * There are only five ascii characters escaped for html markup
  * to work:  1)amperstand 2) open angle bracket 3) close angle bracket
  * 4) single quote 5) double quote
  */
function unescapeXml(aString)
{
	return aString.replace(/&amp;/g, "&").
						replace(/&gt;/g,">").
						replace(/&lt;/g,"<").
						replace(/&#42668F;/g,"'").
						replace(/&quot;/g,"\"").
						replace(/&#034;/g,"\"");
}

// Escapes XML-sensitive characters in a string
function escapeXml( notEscaped )
{
  notEscaped = (notEscaped) ? notEscaped : "";
  var len = notEscaped.length;
  var escaped = "";
  for (var i=0; i<len; i++)
  {
      var c = notEscaped.charAt(i);
      switch (c)
      {
      case '<':
          escaped += "&lt;";
          break;
      case '>':
          escaped += "&gt;";
          break;
      case '&':
          escaped += "&amp;";
          break;
      case '\\':
          escaped += "&#92;";
          break;
      case '\'':     // apos is deprecated
          escaped += "&#" + c.charCodeAt() + ";";
          break;
      case '"':
          escaped += "&quot;";
          break;
      default:
          if (c.charCodeAt() >= 128)
              escaped += "&#" + c.charCodeAt() + ";";
          else
              escaped += c;
      }
  }
  return escaped;
}


function doRefresh() {
	var windowObj = (top != self) ? top : self;
	var thisUrl= windowObj._thisUrl;

	if(!thisUrl)
   	thisUrl="index.jsp";

	if(window.name === 'FCMPopoutWin')
	{
		location.href="refreshPopoutTab.action";
	}
	else
	{
		windowObj.location.href=thisUrl;
	}

  return false;
}


/**
  * Sets the forms on the page to read-only.  The user can only
  * view the current settings in the form.  Call this after the page
  * has loaded.  Fields with id matching the optional pattern are not disabled and
  * the presence of one in the form forestalls capturingKeyStrokes.
  *
  */
function setFormsReadOnly( exclusionPattern )
{
    // Loop through each form on this page
    for (var i = 0; i < document.forms.length; i++) {
        // Loop through each element in the form
        var form = document.forms[i];
        var allowedOne = false;
        for (var j = 0; j < form.length; j++) {
            // Disable each element unless its id matches the exclusion pattern
            var element = form.elements[j];
            if (exclusionPattern && element.id.match(exclusionPattern))
            {
                allowedOne = true;
            }
            else
            {
                // Change the textarea and text fields background color and borders
                // to hide the fact that they are input fields.  Then set them to readonly.
                if(element.type && (element.type.toLowerCase() == 'textarea' || element.type=='text'))
                {
                   element.readOnly = true;
                   element.style.backgroundColor="#f0f1f2";
                   //element.style.border="none";
                }
                // Keep listboxes enabled for scrolling.
                // Deactivate the clicking of the options
                else if(element.type && element.type.toLowerCase() == 'select-multiple')
                {
                   //allow scrolling
                   element.onfocus = disableOptionStateChange;
                   element.style.color="GrayText";
                   element.style.border="1px solid InactiveBorder";

                   for (var k=0; k<element.length; k++) {
				      var optionElement = element.options[k];
					  if (optionElement.className == 'famSelectOptionError')
					     optionElement.className = '';
				   }
                }
                else if(element.type && element.type.toLowerCase() == 'button' && element.id=='saveButton')
                {
                   element.style.display="none";
                }
                else // any other element should be disabled.
                {
                   element.disabled = true;
                }

                // disable anchors only within the forms.
                var anchors = form.getElementsByTagName("A");
                for (k = 0; k < anchors.length; k++) {
                     // Disable each element
                     var anchor = anchors[k];
                     if (exclusionPattern && anchor.id.match(exclusionPattern)) {
                        allowedOne = true;
                        continue;
                     }
                     anchor.disabled = true;
                     anchor.onclick=showReadOnlyWarning;
                }
            }
        }
        // Swallow all keypresses if all fields were disabled
        if (!allowedOne)
            form.onkeypress = form.onkeydown = captureKeyStrokes;
    }
}

/**
  * Generic message to alert the user that an action being requested
  * is not permitted since the form is read-only.
  *
  */
function showReadOnlyWarning(event)
{
   alert($i18n("creditfraud.application.js.showReadOnlyWarning.alert0.txt"));
   event.stopPropagation();
   return false;

}

/**
  * Used in conjuction with the read-only form. Since listboxes need
  * to scroll on the read-only form, they must be enabled.  However,
  * the user can change the highlighted options.  So this method alerts
  * the user that he cannot change the state of the listbox and then resets
  * the option to its original state.
  *
  */
function disableOptionStateChange()
{
   showReadOnlyWarning();

   var len = this.options.length;
   var opt;
   for(var k = 0; k < len; k++)
   {
      opt = this.options[k];
      if(opt)
         opt.selected = opt.defaultSelected;
   }
   this.blur();

   return false;
}

/**
  * Used in conjuction with the read-only form. It ignores any typing
  * that the user may attempt on the page.  The main purpose of this
  * method is to prevent the BackSpace key from executing its default
  * behavior which is equivalent to clicking the back button on the browser.
  *
  */
function captureKeyStrokes(evt)
{
   if(!evt) evt = window.event;

   /* non-IE specific browser */
   if(evt.preventDefault)
      evt.preventDefault();

   /* stop event propagation up the DOM tree */
   evt.cancelBubble = true;
   if(evt.stopPropagation)
      evt.stopPropagation();

   /* ignore the key pressed */
   return false;

}


function limitChars(field, max, showWarn)
{
	if (field.value.length > max)
	{
		field.value = field.value.substring(0, max);
		if (showWarn)
			alert($i18n("fcm.common.js.limitChars.alert0.fmt.txt", [max])) ;
	}
}

function setScrollableGridHeight(containerID, tableID, gridID)
{
	var containerObj = getElement(containerID);
   var gridObj = getElement(gridID);
   var tblObj = getElement(tableID);

   if(containerObj && tblObj && gridObj)
   {
   	var delta = getClientHeight() - getBottomPosition(containerObj);

      var maxHeight = getHeight(gridObj) + delta
      if(maxHeight < 50) maxHeight = 50;
      if(maxHeight > getHeight(tblObj)) // no need for scrolling
      {
      	gridObj.style.height = 'auto';
      	gridObj.parentNode.style.height = gridObj.style.height;
      }
   	else
   	{
   		gridObj.style.height = maxHeight;
      	gridObj.parentNode.style.height = gridObj.style.height;
   	}

   }

}

function resizeContent(contentId)
{
	var usedHeight = 0;
	$.each(arguments,function(i, val){
		if(i != 0) usedHeight += $(val).height();
	});
	var windowHeight = $(window).height();
	$(contentId).height(windowHeight - usedHeight);
}

/*function openPopout(tabName)
{
	$('#'+tabName+'SelectedTabContainer').hide();
	$('#'+tabName+'PopinTabContainer').show();
	$('#mainDiv').hide();

	window.open("popoutTab.action?tabName="+tabName, "FCMPopoutWin",
			"toolbar=no,location=no,menubar=no,scrollbars=yes,status=yes,"+
			"resizable=yes,copyhistory=no,left=0,top=0,width=925px,height=600px");
}*/

/**
 * This should only be called by the popout window itself.
 */
function closePopout()
{
	var url = "popinTab.action";
	if (window.name === 'FCMPopoutWin')
	{
		// is parent window still open?
		if(window.opener && !window.opener.closed)
		{
			// get the menu
			var $menu = $(window.opener.document).find("#primaryMenu");
			// a different tab has NOT been selected
			if(!$menu.find("td.tabSelected").is(":visible"))
			{
				// call popinTab in opener so that tab url is loaded there after cleanup
				window.opener.location.href = url;
			}
			else // another tab has been selected; cleanup session on server
			{
				// signals to opener that proper cleanup has been done
				$menu.find("#tabPopinIcon").hide();
				// set busy on the popout window
				setBusy('mainDiv');
				// call popin tab, but do not reload the tab url
				location.href = url + "?preventDefault=1";
			}
		}
		else
		{
			// no opener could be found
			// do not clean up session b/c if the opener is reopened before
			// close is called by the popout, it thinks the popout is still open
			// and will try to clean up the session which leads to an error
		}

		// always close the popout window when completed
		window.close();
	}
}

/**
 * Needed to handle cases where the user refreshes the tab on
 * the popup after the tab has been popped out into a separate window.
 */
function forcePopinTab()
{
	if(window.name.match("FCMPopupWin.*"))
	{
		popinTab(true);
	}
}

/**
 * This should only be called by the opener of the popout window
 */
function popinTab(force)
{
	if(hasPopoutClosedProperly() || force) // cleanup work is required
	{
		// close popout window
		var popout = findPopoutWindow();
		if(popout.top.closeSpecial)
			popout.top.closeSpecial();
		popout.close();
		// call popintab, which reloads the tab contents
		location.href = "popinTab.action";
		// prevent default href action of tab
		return false;
	}
	// popout has properly closed; allow default href action of tab
	return true;
}

function hasPopoutClosedProperly()
{
	// if icon is visible, then popout window has not been closed properly
	return $('#tabPopinIcon').is(":visible");
}

function findPopoutWindow(url)
{
	var thisURL = url ? url : "";
	return window.open(thisURL, "FCMPopoutWin","toolbar=no,location=no,menubar=no,scrollbars=yes,status=yes,"+
		"resizable=yes,copyhistory=no,left=0px,top=0px,width=1px,height=1px");
}


function csrf_init(tokenName, tokenValue)
{
	if(tokenName && tokenValue)
	{
		$.ajaxSetup({
		   beforeSend: function(xhr, settings){
//		     xhr.setRequestHeader(tokenName,tokenValue);
			  // wait until submission to get value from cookie
		     xhr.setRequestHeader(tokenName,getCookie(tokenName));
		   }
		 });

			$('form').each(function(i){
				var $form = $(this);
				var $tokenField = $form.children("input:hidden[name='"+tokenName+"']");
				if($tokenField.length === 0) // RAPTOR-2399
				{
					csrf_insertTokenField($form[0],tokenName, tokenValue);
				}
			});

			$('form').each(function(i){
				var $form = $(this);
				if ($form.on) { // RAPTOR-2399 form.live() removed
				    $form.on('submit',{name: tokenName, value: tokenValue}, csrf_addCSRFToken);
				}
			});

			$('body').each(function(i){
				var $body = $(this);
				$body.bind('unload', function(){
					$('form').each(function (i){
						var $form = $(this);
						if ($form.off) {  // RAPTOR-2399 form.die() removed
							$form.off('submit', csrf_addCSRFToken);
						}
					});
				});
			});

	}
}

function csrf_addCSRFToken(e)
{
	var $form = $(this);
	var $tokenField = $form.children("input:hidden[name='"+e.data.name+"']");
	// wait until submission to get value from cookie
	if($tokenField.length === 0) // RAPTOR-2399
		csrf_insertTokenField($form[0],e.data.name, getCookie(e.data.name));
//		csrf_insertTokenField($form[0],e.data.name, e.data.value);
	else
		$tokenField.val(getCookie(e.data.name)); // RAPTOR-2399
//		$tokenField.attr("value",e.data.value);
}

function csrf_insertTokenField(form, tokenName, tokenValue)
{
	var inputElm = document.createElement("input");
	inputElm.type="hidden";
	inputElm.name = tokenName;
	inputElm.value = tokenValue;
	form.appendChild(inputElm);
}

$(document).ready(function(){
	csrf_init("__sfmrt", getCookie("__sfmrt"));
});

var iconNameLookup = {
	"bang":"&#xf667;",
	"cancel":"&#xf159",
	"check":"&#xf15e;",
	"CheckGreen":"&#xf15e;",
	"Code":"&#xf113;",
	"CodeOpen":"&#xf113;",
	"collapsed":"&#xf06d;",
	"Copy":"&#xf141;",
	"deactivate":"&#xf711;",
	"deactivateOpen":"&#xf711;",
	"DebugBlue":"&#xf4ad;",
	"delete":"&#xf1a7;",
	"deleteOpen":"&#xf1a7;",
	"Deploy":"&#xf1b0;",
	"DeployedJob":"&#xf1b1;",
	"DeployedJobOpen":"&#xf1b1;",
	"download":"&#xf1c6;",
	"edit":"&#xf201;",
	"editOpen":"&#xf201;",
	"empty":"&#xf0c2;",
	"emptyOpen":"&#xf0c2;",
	"expanded":"&#xf06e;",
	"Edit":"&#xf201;",
	"EditOpen":"&#xf201;",
	"estimate0":"&#xf257;",
	"estimate0Open":"&#xf257;",
	"export":"&#xf227;",
	"File":"&#xf257;",
	"FileOpen":"&#xf257;",
	"folder":"&#xf26a;",
	"folderOpen":"&#xf4a2;",
	"hidden":"",
	"History":"&#xf2f3;",
	"model":"&#xf426;",
	"modelOpen":"&#xf426;",
	"new":"&#xf468;",
	"New":"&#xf468;",
	"Node":"&#xf62f;",
	"NodeOpen":"&#xf62f;",
	"NodeGroup":"&#xf690;",
	"NodeGroupOpen":"&#xf690;",
	"pause":"&#xf0a6;",
	"PerformanceMonitor":"&#xf4fe;",
	"PerformanceMonitorOpen":"&#xf4fe;",
	"printer":"&#xf522;",
	"query":"&#xf2a3;",
	"queryOpen":"&#xf2a3;",
	"record":"&#xf8ac;",
	"reorder":"&#xf588;",
	"report":"&#xf5b3;",
	"reportOpen":"&#xf5b3;",
	"reset":"&#xf5bc;",
	"Run":"&#xf513;",
	"RunningPerson":"&#xf671;",
	"RunningPersonOpen":"&#xf671;",
	"sasCode":"&#xf113;",
	"sasLog":"&#xf3ca;",
	"save":"&#xf60e;",
	"score":"&#xf15a;",
	"scoreOpen":"&#xf15a;",
	"status":"&#xf2a3;",
	"template":"&#xf257;",
	"templateOpen":"&#xf257;",
	"upload":"&#xf728;",
	"User":"&#xf72b;",
	"UserOpen":"&#xf72b;",
	"UserGroup":"&#xf72e;",
	"UserGroupOpen":"&#xf72e;",
	"UserRole":"&#xf735;",
	"UserRoleOpen":"&#xf735;"
};

//"Freeze" the table headers so that they are always visible
function repositionTHs(elem) {
	$(elem).find("th").css("top", elem.scrollTop + "px");
}