<%@ page contentType="text/html; charset=UTF-8"%>
<%@ page isErrorPage="true"	import="java.util.*,java.io.*,com.sas.finserv.common.*,com.sas.finserv.creditfraud.webapp.util.ApplicationDefaultExceptionHandler,com.sas.finserv.creditfraud.webapp.security.enforcement.*"%>
<%@ page language="java" session="false"%>
<%@ include file="/common/taglibsT3.jsp"%>
<tiles:importAttribute/>
<%--
In errorT3.jsp, ${hideErrorMessage} is set to TRUE for its JavaScript logic.
When using this page for JSPs, this variable does not need to be set.
--%>

<c:set var="genericErrorMsg"><fmt:message key="creditfraud.application.error.txt" /></c:set>

<div id="errorMessageDiv" style="display:${hideErrorMessage ? 'none' : 'block'}"><!-- Begin Error Information -->
	<h2	style="font-size: small; text-align: left; padding: 2px 2px 2px 12px; margin-bottom: 0px;">
		<fmt:message key="fcm.subtitle.error.txt" />
	</h2>
	<div style="padding: 20px 12px 20px 12px; background-color: #f0f1f2; overflow: auto;">
		<div align="left" style="width: 80%;">
			<img src="common/images/spacer.gif" border="0" height="300" width="1" align="left" alt="" />
<%
			//if controller threw exception, find it in the request
		 	Throwable cause = (Throwable) request.getAttribute(ApplicationDefaultExceptionHandler.WEBAPP_ERROR_KEY);
			if(cause == null) // must be a JSPException
			{
				cause = pageContext.getException(); // usually a JSPException wrapping the real one.
				if(cause != null)
				{
					ErrorMessageSanitizer.printStackTraceSafe(cause); // log the JSP exception just in case container didn't already do so.
					while(!(cause instanceof ApplicationException) && cause.getCause() != null)
					{
						cause = cause.getCause();
					}
				}
			}
			else
			{
				ErrorMessageSanitizer.printStackTraceSafe(cause);
			}

		 	if (cause instanceof ApplicationException) {
		 		ApplicationException ae = (ApplicationException) cause;
		 		request.setAttribute("aeErrorMsg", ae.getLocalizedMessage(Collections.list(request.getLocales())));
		 	}
%>
			<c:if test="${not empty aeErrorMsg}">
				${esapi:encodeForHTML(sfmfn:alternative(aeErrorMsg, genericErrorMsg))}
			</c:if>
			<c:if test="${empty aeErrorMsg}">${genericErrorMsg}</c:if>

		</div>
	</div>

	<!-- Buttons -->
	<table border="0" cellpadding="0" cellspacing="0" width="100%">
		<tr class="buttonBar" style="border-top: none">
			<td colspan="6">
				<img border="0" src="common/images/spacer.gif" height="6" alt="" />
			</td>
		</tr>
		<tr class="buttonBar" style="border-top: none">
			<td nowrap="nowrap" align="left" colspan="5">
				<img src="common/images/spacer.gif" width="17" height="1" border="0" alt="" />
				  <button class="sapMBarChild sapMBtn sapMBtnBase sasMButton" type="button" id="resumeButton" onclick="doRefresh();">
					<span class="sapMBtnDefault sapMBtnHoverable sapMBtnInner sapMBtnText sapMFocusable sapMIE">
			    		<span class="sapMBtnContent"><fmt:message key='creditfraud.button.resume.txt'/></span>
			    		<span class="sapMBtnFocusDiv"></span>
			  		</span>
				  </button>
			</td>
			<td width="100%">&nbsp;</td>
		</tr>
		<tr class="buttonBar" style="border-top: none">
			<td colspan="6">
				<img border="0" src="common/images/spacer.gif" height="6" alt="" />
			</td>
		</tr>
	</table>
</div>