<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>
<%@ taglib prefix="esapi2" uri="/META-INF/tld/sas-fin-svcs-fraud-json.tld" %>

<script>
	var _memos = new Array();
	var _memoOpts = new Array();
	_memos.push("");

<%--
	Only want to iterate through the memo list once, so
	let's create the option elements now
--%>
<c:forEach var="mt" items="${displayEntity.currentAlert.predefinedMemos}" >

	_memos.push("${esapi:encodeForJavaScript(mt.text)}");
	<c:choose>
		<c:when test="${fn:length(mt.name) > 50}">
			_memoOpts.push('<option value="${mt.id}"> ${esapi:encodeForHTML(fn:substring(mt.name,0,50))}....</option>');
		</c:when>
		<c:otherwise>
			_memoOpts.push('<option value="${mt.id}"> ${esapi:encodeForHTML(mt.name)}</option>');
		</c:otherwise>
	</c:choose>
</c:forEach>

$(document).ready(function() {
	$("#memoTemplateID").change(function() {
		var memo = _memos[event.target.selectedIndex];
		$("#memoText").text(memo).focus();
	});
});

</script>

<%--
    Preparing the call results along with the appropriate block codes
--%>
<script>
var crs = [];
crs.push ({
	id: "NOSELECTION",
	name: "NOSELECTION",
	label: " ",
	allowRerouteToEnabled: false,
	timestampEnabled: false,
	applySystemBlock: false,
	applyTransactionBlock: false,
	typeUnknown: false,
	typePositive: false,
	typeNegative: false
});
<c:forEach var="rs" items="${displayEntity.currentAlert.queue.callResultSettings}">
crs.push ({
	id: "${rs.id}",
	name: "${esapi:encodeForJavaScript(rs.callResult)}",
	label: "${esapi:encodeForJavaScript(rs.callResult)}",
	allowRerouteToEnabled: ${rs.allowRerouteToEnabled},
	timestampEnabled: ${rs.timestampEnabled},
	applySystemBlock: ${rs.applySystemBlock},
	applyTransactionBlock: ${rs.applyTransactionBlock},
	typeUnknown: ${rs.typeUnknown},
	typePositive: ${rs.typePositive},
	typeNegative: ${rs.typeNegative}
});
</c:forEach>


var allowRerouteTo = {};
<c:forEach var="rs" items="${displayEntity.currentAlert.queue.callResultSettings}">
	<c:if test="${rs.typeUnknown}">
		allowRerouteTo["${rs.id}"] = [];
		<c:forEach var="queue" items="${routingQueues}">
			<c:if test="${queue.id != displayEntity.currentAlert.queue.id}">
				<c:forEach var="allowRerouteTo" items="${rs.allowRerouteTo}">
					<c:if test="${fn:trim(allowRerouteTo) == queue.id}">
allowRerouteTo["${rs.id}"].push({
	id: "${queue.id}",
	label: "${esapi:encodeForJavaScript(queue.name)}",
	isAssigned: true
});
					</c:if>
				</c:forEach>
			</c:if>
		</c:forEach>
	</c:if>
</c:forEach>

var fraudTypes = {};
<c:forEach var="rs" items="${displayEntity.currentAlert.queue.callResultSettings}">
	<c:if test="${rs.typeNegative}">
		fraudTypes["${rs.id}"] = [];
		<c:forEach var="fraudType" items="${fraudTypes}">
			<c:forEach var="assignedFraudCode" items="${rs.fraudTypes}">
				<c:if test="${fn:trim(assignedFraudCode) == fraudType.fraudCode}">
fraudTypes["${rs.id}"].push({
	id: "${esapi:encodeForJavaScript(fraudType.fraudCode)}",
	label: "${esapi:encodeForJavaScript(fraudType.fraudName)}",
	isAssigned: true
});
				</c:if>
			</c:forEach>
		</c:forEach>
	</c:if>
</c:forEach>

</script>

<c:forEach var="crs" items="${displayEntity.currentAlert.queue.callResultSettings}" >
		<c:if test="${crs.applySystemBlock || crs.removeSystemBlock}">
			<div style="display:none;" id="systemBlock${crs.id}DIV" >
				<select name="systemBlock${crs.id}Select" class="famSelect" style="width:16em" onChange="handleSysBlock(this.options[this.selectedIndex].value)">
						<option value="" selected="selected" ><fmt:message key="fcm.alert.noChange.txt"/></option>
						<c:if test="${crs.removeSystemBlock && displayEntity.currentAlert.removeSystemBlock}">
							<option value="clearBlock" ><fmt:message key="fcm.alert.clearBlock.txt"/></option>
						</c:if>
						<c:if test="${crs.applySystemBlock }">
							<c:forEach var="bc" items="${crs.systemBlocks}">
								<c:if test="${displayEntity.systemBlock1.expired || displayEntity.systemBlock1.code != bc.blockCode}">
									<option value="${esapi:encodeForHTMLAttribute(bc.blockCode)}">${esapi:encodeForHTML(bc.blockLabel)}</option>
								</c:if>
							</c:forEach>
						</c:if>
				</select>
			</div>
		</c:if>
		<c:if test="${!displayEntity.dndContact}">
			<c:if test="${crs.applyTransactionBlock || crs.removeTransactionBlock}">
				<div style="display:none;" id="transactionBlock${crs.id}DIV">
					<select name="transactionBlock${crs.id}Select" class="famSelect" style="width:16em" onChange="handleTxnBlock(this.options[this.selectedIndex].value)">
							<option value="" selected="selected" ><fmt:message key="fcm.alert.noChange.txt"/></option>
							<c:if test="${crs.removeTransactionBlock && displayEntity.currentAlert.removeTransactionBlock}">
								<option value="clearBlock" ><fmt:message key="fcm.alert.clearBlock.txt"/></option>
							</c:if>
							<c:if test="${crs.applyTransactionBlock }">
								<c:forEach var="bc" items="${crs.transactionBlocks}">
									<c:if test="${displayEntity.transactionBlock.expired || displayEntity.transactionBlock.code != bc.blockCode}">
										<option value="${esapi:encodeForHTMLAttribute(bc.blockCode)}">${esapi:encodeForHTML(bc.blockLabel)}</OPTION>
									</c:if>
								</c:forEach>
							</c:if>
					</select>
				</div>
			</c:if>
		</c:if>
</c:forEach>

<%-- show wrapGrid --%>
<tiles:insertTemplate template="wrapGrid.jsp" />
<input type="hidden" name="dirty" value="false">
<input type="hidden" name="updateTransaction" value="false">
<input type="hidden" name="alertID" value="${displayEntity.currentAlert.id}">
<input type="hidden" name="alertVersion" value="${displayEntity.currentAlert.version}">
<input type="hidden" name="systemBlock" value="">
<input type="hidden" name="transactionBlock" value="">
<input type="hidden" name="analystTimeZone" value="">


<script language="javascript">document.alertForm.analystTimeZone.value=DateUtil.getLocalTimeZone();</script>

<div id="calendarDIV" style="position:absolute;visibility:hidden;background-color:white;"></div>

<c:if test="${enableTemplates=='true'}">
	<%-- begin letter fields div --%>
	<div id="letterFieldsDIV" class="templateFields"  draggable="true" ondragstart="drag(event)" >
		<table border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td style="font-weight:bold;background-color:#42668F;color:white;padding:4px;"><fmt:message key="fcm.alert.supplementaryLetterInformation.txt"/></td>
			</tr>
			<tr>
				<td>
					<table border="0" cellspacing="0" cellpadding="2" style="margin:12px">
						<tr>
							<td align="left"><fmt:message key="fcm.alert.template.txt"/>:</td>
							<td>
								<select name="letterTemplate" class="famSelect" style="width:433px">
									<c:forEach var="letter" items="${displayEntity.currentAlert.letterTemplates}" varStatus="loop">
										<c:set var="selAttr" value=""/>
										<c:if test="${displayEntity.currentAlert.queue.defaultLetter == letter.id}">
											<c:set var="selAttr" value="selected=\"selected\""/>
										</c:if>
										<option value="${letter.id}_${esapi:encodeForHTMLAttribute(letter.hostKey)}" ${selAttr}>${esapi:encodeForHTML(letter.name)}</option>
									</c:forEach>
								</select>
	<%--
	TODO: special handling for PF217 and HF217
	--%>
							</td>
						</tr>
						<tr>
							<td align="left"><fmt:message key="fcm.alert.name1.txt"/> :</td>
							<td><input name="altName1" type="text" class="famTextEntry" size="35" maxlength="40">
								&nbsp;<fmt:message key="fcm.alert.name2.txt"/> :
								<input name="altName2" type="text" class="famTextEntry" size="35" maxlength="40" style="margin-right:3px;">
							</td>
						</tr>
						<tr>
							<td align="left"><fmt:message key="fcm.alert.addressLine1.txt"/>:</td>
							<td><input name="altAddress1" type="text" class="famTextEntry" size="42" maxlength="40">
								&nbsp;<fmt:message key="fcm.alert.line2.txt"/>:
							<input name="altAddress2" type="text" class="famTextEntry" size="30" maxlength="40" /></td>
						</tr>
						<tr>
							<td align="left"><fmt:message key="fcm.alert.city.txt"/>:</td>
							<td><input name="altCity" type="text" class="famTextEntry" size="38" maxlength="40" style="margin-right:7px">
								<fmt:message key="fcm.alert.state.txt"/>:
								<input name="altStateProvinceCode" type="text" class="famTextEntry" size="4" maxlength="3" style="margin-right:5px">
								<fmt:message key="fcm.alert.postalCode.txt"/>:
								<input name="altPostalCode" type="text" class="famTextEntry" size="12" maxlength="10">
	<%--
								&nbsp;<fmt:message key="fcm.alert.country.txt"/>:
								<input name="countryCode" type="text" class="famTextEntry" size="4" maxlength="3" />
	--%>
							</td>
						</tr>
						<tr>
							<td align="left"><fmt:message key="fcm.alert.text1ProofOf.txt"/>:</td>
							<td>
								<select name="textProofCode1" class="famSelect" style="width:432px;">
									<OPTION value="" selected><fmt:message key="fcm.alert.selectTextProof.txt"/>...</OPTION>
								<c:forEach var="text" items="${textProofs}">
									<OPTION value="${esapi:encodeForHTMLAttribute(text.code)}" >${esapi:encodeForHTML(text.name)}</OPTION>
								</c:forEach>
								</select></td>
						</tr>
						<tr>
							<td align="left"><fmt:message key="fcm.alert.text2ProofOf.txt"/>:</td>
							<td>
								<select name="textProofCode2" class="famSelect" style="width:432px;">
									<OPTION value="" selected><fmt:message key="fcm.alert.selectTextProof.txt"/>...</OPTION>
								<c:forEach var="text" items="${textProofs}">
									<OPTION value="${esapi:encodeForHTMLAttribute(text.code)}" >${esapi:encodeForHTML(text.name)}</OPTION>
								</c:forEach>
								</select></td>
						</tr>
						<tr>
							<td align="left"><fmt:message key="fcm.alert.text3ProofOf.txt"/>:</td>
							<td>
								<select name="textProofCode3" class="famSelect" style="width:432px;">
									<OPTION value="" selected><fmt:message key="fcm.alert.selectTextProof.txt"/>...</OPTION>
								<c:forEach var="text" items="${textProofs}">
									<OPTION value="${esapi:encodeForHTMLAttribute(text.code)}" >${esapi:encodeForHTML(text.name)}</OPTION>
								</c:forEach>
								</select></td>
						</tr>
						<tr>
							<td colspan="2" align="center" style="padding-top:8px;"><input type="button" value="<fmt:message key="fcm.alert.ok.txt"/>" class="button" style="width:6em" onClick="validateLetter(this.form);"> &nbsp;
								<input type="button" value="<fmt:message key="fcm.alert.clear.txt"/>" class="button" style="width:6em" onClick="document.alertForm.altName1.value='';document.alertForm.altName2.value='';document.alertForm.altAddress1.value='';document.alertForm.altAddress2.value='';document.alertForm.altCity.value='';document.alertForm.altStateProvinceCode.value='';document.alertForm.altPostalCode.value='';document.alertForm.textProofCode1.selectedIndex=0;document.alertForm.textProofCode2.selectedIndex=0;document.alertForm.textProofCode3.selectedIndex=0;"></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
	<%-- end letter fields div --%>

	<%-- begin email fields div --%>
	<div id="emailFieldsDIV" class="templateFields"  draggable="true" ondragstart="drag(event)" >
		<table border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td style="font-weight:bold;background-color:#42668F;color:white;padding:4px;"><fmt:message key="fcm.alert.emailTemplate.txt"/></td>
			</tr>
			<tr>
				<td>
					<table border="0" cellspacing="0" cellpadding="2" style="margin:12px">
						<tr>
							<td><fmt:message key="fcm.alert.templateId.txt"/>:</td>
							<td align="right" style="padding-right:22px">
								<select name="emailTemplate" class="famSelect" style="width:200px">
								<c:forEach var="email" items="${displayEntity.currentAlert.emailTemplates}" varStatus="loop">
									<c:set var="selAttr" value=""/>
									<c:if test="${displayEntity.currentAlert.queue.defaultEmail == email.id}">
										<c:set var="selAttr" value="selected=\"selected\""/>
									</c:if>
									<option value="${email.id}_${esapi:encodeForHTMLAttribute(email.hostKey)}" ${selAttr}>${esapi:encodeForHTML(email.name)}</option>
								</c:forEach>
								</select>
							</td>
						</tr>
						<tr>
							<td colspan="2" align="center" style="padding-top:8px;"><input type="button" value="<fmt:message key="fcm.alert.ok.txt"/>" class="button" style="width:6em" onClick="$('#emailFieldsDIV').hide();"></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
	<%-- end email fields div --%>

	<%-- begin sms fields div --%>
	<div id="smsFieldsDIV" class="templateFields"  draggable="true" ondragstart="drag(event)" >
		<table border="0" cellspacing="0" cellpadding="0">
			<tr>
				<td style="font-weight:bold;background-color:#42668F;color:white;padding:4px;"><fmt:message key="fcm.alert.smsTemplate.txt"/></td>
			</tr>
			<tr>
				<td>
					<table border="0" cellspacing="0" cellpadding="2" style="margin:12px">
						<tr>
							<td><fmt:message key="fcm.alert.templateId.txt"/>:</td>
							<td align="right" style="padding-right:22px">
								<select name="smsTemplate" class="famSelect" style="width:200px">
								<c:forEach var="sms" items="${displayEntity.currentAlert.smsTemplates}" varStatus="loop">
									<c:set var="selAttr" value=""/>
									<c:if test="${displayEntity.currentAlert.queue.defaultSms == sms.id}">
										<c:set var="selAttr" value="selected=\"selected\""/>
									</c:if>
									<option value="${sms.id}_${esapi:encodeForHTMLAttribute(sms.hostKey)}" ${selAttr}>${esapi:encodeForHTML(sms.name)}</option>
								</c:forEach>
								</select>
							</td>
						</tr>
						<tr>
							<td colspan="2" align="center" style="padding-top:8px;"><input type="button" value="<fmt:message key="fcm.alert.ok.txt"/>" class="button" style="width:6em" onClick="$('#smsFieldsDIV').hide();"></td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
	<%-- end sms fields div --%>

	<%-- Extra Template Fulfillment Fields --%>
	<div id="genericFieldsDiv" style="position:relative;display:none;background-color:white;">
		<table>
			<tr>
				<td><fmt:message key="fcm.alert.fulfillment.transactionsStartDate.txt"/></td>
				<td>
					<input type="text" id="calTarget5" name="transactionsStartDateStr" class="famTextEntry" value="" readonly="readonly" style="vertical-align:middle"/>
					<a href="#" id="calAnchor5"><img src="analyst/images/calendarIcon.gif" class="icon" width="16" height="15"/></a>
				</td>
			</tr>
			<tr>
				<td><fmt:message key="fcm.alert.fulfillment.transactionsEndDate.txt"/></td>
				<td>
					<input type="text" id="calTarget6" name="transactionsEndDateStr" class="famTextEntry" value="" readonly="readonly" style="vertical-align:middle"/>
					<a href="#" id="calAnchor6"><img src="analyst/images/calendarIcon.gif" class="icon" width="16" height="15"/></a>
				</td>
			</tr>
			<tr>
				<td><fmt:message key="fcm.alert.fulfillment.transactionTotalAmount.txt"/></td>
				<td>
					<input name="totalTransactionAmount" type="text" class="famTextEntry" value="" maxlength="21"/>
				</td>
			</tr>
			<tr>
				<td><fmt:message key="fcm.alert.fulfillment.merchantCountryNames.txt"/></td>
				<td><input name="merchantCountryNames" type="text" class="famTextEntry" value="" maxlength="250"/></td>
			</tr>
			<tr>
				<td><fmt:message key="fcm.alert.fulfillment.notes.txt"/></td>
				<td><input name="notes" type="text" class="famTextEntry" value="" maxlength="250"/></td>
			</tr>
		</table>
	</div>

</c:if>

<%-- Alert creation from transaction - alert type selection prompt--%>
<div id="alertTypePromptFromTransactions" style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F; display: none"  draggable="true" ondragstart="drag(event)" >
	<table cellpadding="4" cellspacing="0" border="0">
		<tbody>
			<tr>
				<td id="alertTypePromptFromTransactionsLabel" style="font-weight:bold; background-color: #42668F;color:#FFF" colspan="2">
					<fmt:message key="fcm.alert.createAlertOnTransaction.txt"/>
				</td>
			</tr>
			<tr>
				<td align="left">
					<fmt:message key="fcm.alert.alertType.txt"/>
				</td>
				<td align="left">
					<select id="alertTypePromptFromTransactionsSelect" class="famSelect">
					</select>
					<select id="userAlertTypes" style="display:none">
					<c:forEach var="alertType" items="${userAlertTypes}">
						<option value="${esapi:encodeForHTMLAttribute(alertType)}"><esapi:encodeForHTML><fmt:message key="${alertType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTML></option>
					</c:forEach>
					</select>
					<img id="alertTypePromptFromTransactionsSpinner" src="common/images/spinner16.gif" border="0" class="icon" width="16" height="16" style="display:none"/>
				</td>
			</tr>
			<tr>
				<td align="left">
					<fmt:message key="fcm.alert.alertReason.txt"/>
				</td>
				<td align="left">
					<input type="text" name="alertReason" value="" size="50" maxlength="255"/>
				</td>
			</tr>
			<tr>
				<td align="center" nowrap colspan="2">
					<input type="button" id="alertTypePromptFromTransactionsContinue" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.createAlertOnTransactionContinue.txt"/></esapi:encodeForHTMLAttribute>">
					<input type="button" onclick="$('#alertTypePromptFromTransactions,#alertTypePromptFromTransactionsSpinner').hide()" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.createAlertOnTransactionCancel.txt"/></esapi:encodeForHTMLAttribute>">
				</td>
			</tr>
		</tbody>
	</table>
</div>

<%-- Alert creation from transaction - alert creation result prompt--%>
<div id="alertCreatedPromptFromTransactions" style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F;display: none"  draggable="true" ondragstart="drag(event)" >
	<table cellpadding="5" cellspacing="0" border="0">
		<tbody>
			<tr>
				<td style="background-color: #42668F;color:#FFF">
					<fmt:message key="fcm.alert.createAlertOnTransactionAlert.txt"/>
				</td>
			</tr>
			<tr>
				<td id="alertCreatedPromptFromTransactionsResult" align="center" nowrap>
				</td>
			</tr>
			<tr>
				<td align="left" nowrap>
					<ul id="alertCreatedPromptFromTransactionsResultActions" style="list-style:none; margin:0;background-color:#fff;">
					<li style="display:none;cursor:pointer" name="isCurrentAlert" onclick="$('#alertCreatedPromptFromTransactions').hide();"><fmt:message key="fcm.alert.createAlert.result.isCurrentAlert.txt"/></li>
					<li style="display:none;cursor:pointer" name="addToCurrentList" onclick="refreshURL();"><fmt:message key="fcm.alert.createAlert.result.addToCurrentList.txt"/></li>
					<li style="display:none;cursor:pointer" name="openAlert"><fmt:message key="fcm.alert.createAlert.result.openAlert.txt"/></li>
					<li style="display:none;cursor:pointer" name="goToAlert"><fmt:message key="fcm.alert.createAlert.result.goToAlert.txt"/></li>
					<li style="display:none;cursor:pointer" name="addToWorkList"><fmt:message key="fcm.alert.createAlert.result.addToWorkList.txt"/></li>
					</ul>
				</td>
			</tr>
			<tr>
				<td align="center" nowrap>
					<input type="button" onclick="$('#alertCreatedPromptFromTransactions').hide();" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.createAlertOnTransactionClose.txt"/></esapi:encodeForHTMLAttribute>">
				</td>
			</tr>
		</tbody>
	</table>
</div>


<%-- The menu of transaction based actions--%>

<div id="txnMenu" style="min-height:1.5em;white-space: nowrap;padding:2px;position:absolute; z-index:100; border:2px outset #c6cad0; background-color:white; display:none;"  onmouseleave="$(this).hide();">
<c:if test="${displayType eq 'updateAlert' && updateAlerts}">
	<ul style="list-style:none; margin:0;background-color:#fff;">
		<c:if test="${manualAlerts && enableCreateAlertOnTrans}">
		<li onclick="showAlertTypeSelection();">
			<a href="#" onclick="return false;"><img src="common/images/PlusGreen.gif" class="icon" width="16" height="16"/> <fmt:message key="fcm.alert.tran.menu.createAlertOnTransaction.txt"/> </a>
		</li>
		</c:if>

		<c:if test="${addDataToLists}">
		<li id="txnMenuAddDataToLists" onclick="showAnalystListItems('ADD');">
			<a href="#" onclick="return false;"><img src="common/images/PlusGreen.gif" class="icon" width="16" height="16"/> <fmt:message key="fcm.alert.tran.menu.addDataToAnalystLists.txt"/></a>
		</li>
		</c:if>

		<c:if test="${removeDataFromLists}">
		<li id="txnMenuRemoveDataFromLists" style="display:none" onclick="showAnalystListItems('REMOVE');">
			<a href="#" onclick="return false;"><img src="analyst/images/Remove.gif" class="icon" width="16" height="16"/> <fmt:message key="fcm.alert.tran.menu.removeDataFromAnalystLists.txt"/></a>
		</li>
		</c:if>

		<c:if test="${ !(manualAlerts || addDataToLists || removeDataFromLists) }">
		<li id="txnMenuNoRequiredPrivileges" style="display:none">
			<fmt:message key="fcm.alert.tran.menu.noRequiredPrivileges.txt"/>
		</li>
		</c:if>
	</ul>
</c:if>
</div>

<%-- The prompt of updating analyst list(s) from selected transaction --%>

<div id="tranAnalystList"  style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F; padding-bottom:5px; display:none" draggable="true" ondragstart="drag(event)" >
<form>
	<table border="0" cellspacing="0" cellpadding="5" width="100%" >
	<tr><td style="font-weight:bold; background-color: #42668F;padding:4px;color:#FFF">
		<span id="tranAnalystListTitleAdd" style="display:none"> <fmt:message key="fcm.alert.tran.menu.addDataToAnalystLists.txt"/></span>
		<span id="tranAnalystListTitleRemove" style="display:none"> <fmt:message key="fcm.alert.tran.menu.removeDataFromAnalystLists.txt"/></span>
	</td></tr>
	<tr><td>
	<table border="0" cellspacing="0" cellpadding="2" width="100%" class="mainTable txn-data-table" >
		<thead>
			<tr id="tranAnalystListField">
			</tr>
		</thead>
		<tbody>
			<tr id="tranAnalystListValue">
			</tr>
			<tr id="tranAnalystListResult">
			</tr>
		</tbody>
	</table>
	</td></tr>
	<tr><td align="center">
			<input type="hidden" name="txnAcronym"/>
			<input type="hidden" name="tranID"/>
			<input type="hidden" name="updateType"/>
			<input type="button" name="ok" onclick="updateAnalystLists();" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.tran.updateAnalystList.ok.txt"/></esapi:encodeForHTMLAttribute>"/>
			<input type="button" name="cancel" onclick="clearTranAnalystListPropmt(); return false;" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.tran.updateAnalystList.cancel.txt"/></esapi:encodeForHTMLAttribute>"/>
			<input type="button" name="close" onclick="clearTranAnalystListPropmt(); return false;" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.tran.updateAnalystList.close.txt"/></esapi:encodeForHTMLAttribute>"/>
	</td></tr>
	</table>
</form>
</div>


<script>

<%-- Variables used by transaction menu event handlers and transaction based actions handlers in analyst.js --%>
var $row=null;
var txnID, txnAcronym;
var offset = null;

<c:set var="currentAlert" value="${checkoutManager.currentAlert}"/>

var currAlert = {
	"alertID":"${esapi2:encodeForJSON(currentAlert.id)}",
	"alertValue":"<sfmmsk:maskData value="${currentAlert.entityID}" maskType="ID" />",
	"alertType":"${esapi2:encodeForJSON(currentAlert.alertType)}",
	"alertStatus":"${esapi2:encodeForJSON(currentAlert.alertStatus)}",
	"callResultID":"${esapi2:encodeForJSON(currentAlert.lastCallResultId)}",
	"strategy":"${esapi2:encodeForJSON(currentAlert.strategyDescription)}",
	"queue":"${esapi2:encodeForJSON(currentAlert.queue.name)}",
	"alertVersion":"${esapi2:encodeForJSON(currentAlert.version)}",
	"checkoutUser":"${esapi2:encodeForJSON(currentAlert.checkoutUser)}",
	"suspendUser":"${esapi2:encodeForJSON(currentAlert.suspendUser)}",
	"entityObj":<sfmfmt:entityToJSON entity="${currentAlert.entity}" useDoubleQuotes="true"/>
	};


function clearTranAnalystListPropmt()
{
	$("#tranAnalystList").hide().find(":input[type='hidden']").val("");
	$("#tranAnalystListField,#tranAnalystListValue,#tranAnalystListResult").empty();
}

</script>

