<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<%-- Push component attributes in page context --%>
<tiles:importAttribute/>

<c:set var="scrollableGrid" value="scrollableGrid" />
<c:set var="scrollableDiv"  value="workListDiv" />

<!-- Begin Work List -->
<table class="mainTable minWidthTable"  cellpadding="0" cellspacing="0" border="0" style="margin-top:12px;">
	<tr class="tableColumnHeaderRow">
		<th class="tableHeader" style="border-right:none;border-top:none;color:#353535;font-weight:bold;">
			${esapi:encodeForHTML(username)} <fmt:message key="fcm.workList.txt" />
		</th>
	</tr>
<c:if test="${not empty workList}">
	<tr>
	<td style="padding:0px;">
		<div id="${scrollableDiv}" class="${scrollableGrid}" style="height:11.6em" onscroll="repositionTHs(this)">
		<table id="workList" cellpadding="0" cellspacing="0" border="0">
			<thead>
			<tr bgcolor="#FFFFFFF">
				<th class="tableHeader" style="border-top:none;border-right:none;padding-left:3px"><fmt:message key="fcm.inboundSearch.results.id.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;"><fmt:message key="fcm.inboundSearch.results.alertStatus.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;"><fmt:message key="fcm.inboundSearch.results.strategy.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;"><fmt:message key="fcm.inboundSearch.results.queue.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;"><fmt:message key="fcm.inboundSearch.results.contactName.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;"><fmt:message key="fcm.inboundSearch.results.phone.txt" /></th>
				<th class="tableHeader" style="border-top:none;border-right:none;"><fmt:message key="fcm.inboundSearch.results.address.txt" /></th>
			</tr>
			</thead>
			<tbody>
			<c:forEach var="entity" items="${workList}">
				<tr>
					<td align="left" style="padding:3px; white-space: nowrap">
				  <a href="#" onclick="WorkList('REMOVE',<sfmfmt:entityToJSON entity="${entity}"/>)"><img src="analyst/images/Remove.gif" class="icon" /></a>
		            <img src="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
					<c:choose>
						<c:when test="${!viewAlerts || entity.alertId == null}">
							<a href="#" onclick="viewEntity(<sfmfmt:entityToJSON entity="${entity}"/>)"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
						</c:when>
						<c:when test="${fn:trim(entity.alertStatus) == 'CLOSED'}">
							<a href="#" onclick="viewAlert('${entity.alertId}')"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
						</c:when>
						<c:otherwise>
							<a href="#" onclick="viewAlert('${entity.alertId}')"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
						</c:otherwise>
					</c:choose>
					</td>
					<td align="left"><sfmfmt:formatAlertStatus value="${entity}"/></td>
					<td align="left">${esapi:encodeForHTML(entity.strategy)}</td>
					<td align="left">${esapi:encodeForHTML(entity.queue)}</td>
					<td align="left">${esapi:encodeForHTML(entity.memberName)}</td>
					<td align="left"> <sfmmsk:maskData value="${entity.memberHomePhone}" maskType="PHN" /> </td>
					<td align="left">${esapi:encodeForHTML(entity.addressLine1)}</td>
				</tr>
			</c:forEach>
			</tbody>
		</table>
	</div>
</td></tr>
</c:if>

</table>

<!-- End Work List -->
