<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>
<%-- Begin transactions table --%>
<c:set var="maxTabs" value="8"/>

<table id="transactions" class="minWidthTable" border="0" cellspacing="0" cellpadding="0" style="margin-top:6px;table-layout: fixed">
<tr>
<td>
<div id="transactionTabs" class="tabs">
<ul>
<c:set var="firstTabIndexWithData" value="-1"/>
<c:set var="iterator" value="${txns:getTransactionsIterator(entityTransactions,showEmptyGrids)}"/>
<c:forEach var="txnData" items="${iterator}" begin="0" end="${maxTabs-1}" varStatus="loop">
<c:set var="hasRows" value="${txnData.totalRowCount>0}"/>
<c:if test="${hasRows && firstTabIndexWithData == -1}">
<c:set var="firstTabIndexWithData" value="${loop.count}"/>
</c:if>
<c:set var="currClassName" value="${loop.count == firstTabIndexWithData ? ' current ' : ''}"/>
<c:set var="disabledClassName" value="${not hasRows ? ' disabled ' : ''}"/>
<li id="${esapi:encodeForHTMLAttribute(txnData.acronym)}Tab" class="txn-data-rows-${hasRows} txn-data-last-tab-${loop.last} ${currClassName} ${disabledClassName}" ><a href="javascript:" onclick="lazyLoadTransactions('${txnData.acronym}');"><span>${esapi:encodeForHTML(txnData.label)}</span></a></li>
</c:forEach>
<c:set var="showMoreTab" value="${txns:hasNext(iterator)}"/>
<c:if test="${showMoreTab}">
<li id="moreTab"><a href="javascript:;" onclick="return overlay(this, 'moreSubcontent')" style="background:none"><span style="background:none"><fmt:message key="fcm.alert.more.txt"/> <img src="common/images/menu/dropBlue.gif" class="icon" style="margin-left:3px" width="7" height="4"/></span></a></li>
</c:if>
<li id="transactionFilterTab" style="text-align:right;float:right;display:none" ><a href="javascript:;" style="background:none" title="<fmt:message key="fcm.alert.transactions.filterBy.txt"/>" ><span style="background:none"></span></a></li>
</ul>
</div></td>
</tr>
<tr>
<td><tiles:insertTemplate template="trans/transType.jsp" flush="true" /></td>
</tr>
</table>
<c:if test="${showMoreTab}">
<div id="moreSubcontent" style="position:absolute; z-index:99; border:1px solid #c6cad0; background-color:white; display:none; margin-top:1.8em;">
<div id="more">
<ul style="list-style:none; margin:0;">
<c:forEach var="txnData" items="${iterator}">
<c:if test="${txnData.totalRowCount>0}">
<li id="${esapi:encodeForHTMLAttribute(txnData.acronym)}Tab" class="txn-data-rows-true txn-data-last-tab-true"><a class="moreAnchor" href="javascript:" onclick="lazyLoadTransactions('${txnData.acronym}');"><span>${esapi:encodeForHTML(txnData.label)}</span></a></li>
</c:if>
</c:forEach>
</ul>
</div>
</div>
</c:if>

<span id="markAllConfirmedFraud" style="display:none"><fmt:message key="fcm.analyst.markAllConfirmedFraud.txt"/></span>
<span id="markAllVerifiedOK" style="display:none"><fmt:message key="fcm.analyst.markAllVerifiedOK.txt"/></span>

