<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

    <jsp:useBean id="timestamp" class="java.util.Date" />

	<c:choose>
	<c:when test="${directOutbound}">
		<table class="mainTable minWidthTable" style="margin-top:12px">
			<thead>
				<tr class="tableColumnHeaderRow">
					<th class="tableHeader" style="border-top:none;border-right:none;color:#353535;font-weight:bold;">
						<fmt:message key="fcm.strategiesList.strategies.asOfTime.fmt.txt"><fmt:param><fmt:formatDate value="${timestamp}" pattern="${timeFormat}" timeZone="${userTimeZone}"/></fmt:param></fmt:message>
						<c:if test="${showManualRefresh}">
						<span onclick="refreshStrategyList();" style="padding-left:10px; padding-right:10px; cursor:pointer;"> <img src="analyst/images/refresh.gif" class="icon" width="16" height="16"/> <fmt:message key='fcm.alert.refresh.txt'/></span>
						</c:if>
						<img id="strategyListSpinner" src="common/images/spinner16.gif" border="0" class="icon" width="16" height="16" style="display:none"/>
					</th>
					<th class="tableHeader" style="border-top:none;border-right:none;font-weight:bold;padding-right:8px;"><div align="right">

					<c:if test="${priorityOutbound}">
						<a href="#" onclick="priorityOutbound()"><img src="analyst/images/go.gif" class="icon" /> <fmt:message key="fcm.strategiesList.priorityServicingButton.txt" /> (${priorityCount})</a>
					</c:if>

					</div></th>
				</tr>
			</thead>
		  	<tbody>
				<tr>
					<td colspan="2" style="padding:0px">
						<div class="scrollableGrid" style="height:11.6em" onscroll="repositionTHs(this)">
							<table cellspacing="0" cellpadding="0" border="0">
								<thead>
									<tr bgcolor="#FFFFFF">
										<th class="tableHeader" style="border-top:none;border-right:none;"> <fmt:message key="fcm.strategiesList.strategy.txt" /> </th>
										<th class="tableHeader" style="border-top:none;border-right:none;"> <fmt:message key="fcm.strategiesList.type.txt" /> </th>
										<%--th> <fmt:message key="fcm.strategiesList.agents.txt" /> </th--%>
										<th class="centeredTableHeader" style="border-top:none;border-right:none;"> <fmt:message key="fcm.strategiesList.suspendedAlerts.txt" /> </th>
										<th class="centeredTableHeader" style="border-top:none;border-right:none;"> <fmt:message key="fcm.strategiesList.alerts.txt" /> </th>
									</tr>
								</thead>
								<tbody>
								<c:if test="${not empty strategyList}">
									<c:forEach var="strategy" items="${strategyList}" varStatus="loop">
										<c:choose>
											<c:when test="${loop.count % 2 == 0}">
									<tr class="dataRow1_tableRow">
											</c:when>
											<c:otherwise>
									<tr class="dataRow2_tableRow">
											</c:otherwise>
										</c:choose>
										<td class="tableCell"><a href="#" onclick="directOutbound(${strategy.id})">${esapi:encodeForHTML(strategy.name)}</a></td>
										<%--td class="tableCell">${strategy.type}</td--%>
										<td class="tableCell"><fmt:message key="fcm.strategiesList.outbound.txt" /></td>
										<td class="imageTableCell lastCol">${esapi:encodeForHTML(strategy.numberOfSuspendedAlerts)}</td>
										<td class="imageTableCell lastCol">${esapi:encodeForHTML(strategy.numberOfAlerts)}</td>
									</tr>
									</c:forEach>
								</c:if>
								<c:if test="${empty strategyList}">
									<tr class="dataRow2_tableRow">
										<td class="tableCell" colspan="4"><fmt:message key="fcm.strategiesList.noAssignedStrategies.txt" /></td>
									</tr>
								</c:if>
								</tbody>
							</table>
						</div>
					</td>
				</tr>
		  	</tbody>
		</table>
	</c:when>
	<c:when test="${priorityOutbound}">
		<table class="mainTable minWidthTable" style="margin-top:12px" >
			<tbody>
				<tr class="tableColumnHeaderRow">
					<td class="tableHeader" style="border-top:none;border-right:none;font-weight:bold;padding-right:8px;">
						<a href="#" onclick="priorityOutbound()"><img src="analyst/images/go.gif" class="icon" /> <fmt:message key="fcm.strategiesList.priorityServicingButton.txt" /></a>
						(<fmt:message key="fcm.strategiesList.alerts.asOfTime.fmt.txt"><fmt:param value="${priorityCount}"/><fmt:param><fmt:formatDate value="${timestamp}" pattern="${timeFormat}" timeZone="${userTimeZone}"/></fmt:param></fmt:message>)
						<c:if test="${showManualRefresh}">
						<span onclick="refreshStrategyList();" style="padding-left:10px; padding-right:10px; cursor:pointer;"> <img src="analyst/images/refresh.gif" class="icon" width="16" height="16"/> <fmt:message key='fcm.alert.refresh.txt'/></span>
						</c:if>
						<img id="strategyListSpinner" src="common/images/spinner16.gif" border="0" class="icon" width="16" height="16" style="display:none"/>
					</td>
				</tr>
			</tbody>
		</table>
	</c:when>
 </c:choose>
