<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<%-- Push component attributes in page context --%>
<tiles:importAttribute/>

<c:set var="scrollableGrid" value="scrollableGrid" />
<c:set var="scrollableDiv"  value="searchResultsDiv" />

<c:if test="${not empty searchResultsList}">
<script type="text/javascript">
	$(document).ready(function(){
		updateViewState({
			keepSearchResults: 'true'
		});
	});
</script>
<table class="mainTable" cellpadding="0" cellspacing="0" border="0" width="100%" style="border-top:none;border-bottom:none;">
	<tr class="tableColumnHeaderRow">
		<th class="tableHeader" style="border-top:none;border-right:none;color:#353535;font-weight:bold;"><fmt:message key="fcm.inboundSearch.searchResults.txt"/>
		</th>
		<th class="tableHeader" style="border-top:none;color:#999;text-align:right;font-style:italic">
			<c:if test="${fn:length(searchResultsList)>50}">
			<span style="font-weight:normal"><fmt:message key="fcm.inboundSearch.onlyFirst50.txt"/></span>
			</c:if>
		</th>
	</tr>
</table>

<table class="mainTable" cellpadding="0" cellspacing="0" border="0" width="100%" style="border-top:none;">
	<tr><td style="padding:0px"><div id="${scrollableDiv}" class="${scrollableGrid}" style="height:11.6em" onscroll="repositionTHs(this)" >
		<table id="searchResults" cellpadding="0" cellspacing="0" border="0">
		<thead>
		<tr>
			<th class="tableHeader" style="border-right:none;border-top:none;padding-left:3px"><fmt:message key="fcm.inboundSearch.results.id.txt" /></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.alertId.txt" /></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.alertStatus.txt" /></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.strategy.txt"/></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.queue.txt"/></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.contactName.txt" /></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.phone.txt" /></th>
			<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.address.txt" /></th>
			<c:if test="${callCenterType eq 'T'}">
				<th class="tableHeader" style="border-right:none;border-top:none;"><fmt:message key="fcm.inboundSearch.results.multiorg.txt" /></th>
			</c:if>
		</tr>
		</thead>
		<tbody>
		<c:forEach var="entity" items="${searchResultsList}" end="49">
			<tr>
			<td align="left" style="padding:3px;white-space: nowrap">
            <img src="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
			<c:choose>
				<c:when test="${!viewAlerts || entity.alertId == null}">
               <a href="#" onclick="viewEntity(<sfmfmt:entityToJSON entity="${entity}"/>)"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
				</c:when>
				<c:when test="${fn:trim(entity.alertStatus) == 'CLOSED'}">
					<a href="#" onclick="viewAlert('${entity.alertId}')"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
				</c:when>
				<c:otherwise>
					<a href="#" onclick="viewAlert('${entity.alertId}')"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
					<c:if test='${inbound && updateAlerts}'>
					  <c:choose>
						  <c:when test='${fn:trim(entity.alertStatus) == "ACTIVE" && checkoutManager.checkoutAvailable && empty entity.suspendUser}'>
							  <a href="#" onclick="checkout('${entity.alertId}','${entity.alertVersion}')"><img src="analyst/images/CheckOut.gif" class="icon" /></a>
						  </c:when>
						  <c:when test='${fn:trim(entity.alertStatus) == "CHECKOUT" && username==fn:trim(entity.checkoutUser)}'>
							  <a href="#" onclick="modifyAlert('${entity.alertId}','${entity.alertVersion}')"><img src="analyst/images/go.gif" class="icon" /></a>
						 </c:when>
						  <c:when test='${fn:trim(entity.alertStatus) == "CHECKOUT" && checkoutManager.checkoutAvailable && entity.disableForceCheckout=="false" && entity.suspendUserCheckouts <= 1}'>
							  <a href="#" onclick="forceCheckout('${entity.alertId}','${entity.alertVersion}')"><img src="analyst/images/ForceCheckOut.gif" class="icon" /></a>
						 </c:when>
					  </c:choose>
					</c:if>
				</c:otherwise>
			</c:choose>
			</td>
			<td align="left">${esapi:encodeForHTML(entity.alertId)}</td>
			<td align="left"><sfmfmt:formatAlertStatus value="${entity}"/></td>
			<td align="left">${esapi:encodeForHTML(entity.strategy)}</td>
			<td align="left">${esapi:encodeForHTML(entity.queue)}</td>
			<td align="left">${esapi:encodeForHTML(entity.cardmember1FullName)}</td>
			<td align="left"> <sfmmsk:maskData value="${entity.cardmember1HomePhone}" maskType="PHN" /> </td>
			<td align="left">${esapi:encodeForHTML(entity.addressLine1)}</td>
			<c:if test="${callCenterType eq 'T'}">
				<td align="left">${esapi:encodeForHTML(entity.tenantOrgNodeLabel)}</td>
			</c:if>
		 </tr>
		</c:forEach>
		</tbody></table></div></td></tr>
</table>

</c:if>
