jQuery.fn.positionTemplateFields = function()
{
	this.css('top', $.getWindowHeight()/3*2 - this.height()/2);
	this.css('left', 452 - this.width()/2);
	return this;
};

var minWidth=881;
var sizeAdjustment=1;

function onLoadHandler()
{
	var errorLabel = $("#dataPopErrorLabel").text();
	var errorMessage = $("#dataPopErrorMessage").text();

//	$(document.body).data('activeTab',['entity','alertActivity']);
//	$(document.body).data('activeTab',['entities','entity'])';
	if ($("#entitiesGrid").length > 0)
		$(document.body).data('activeTab',['entities','alertActivity']);
	else
		$(document.body).data('activeTab',['entity','alertActivity']);

	$(document.body)
//	.data('cfTransactionFlags',new TransactionFraudFlags(16000))
//	.data('okTransactionFlags',new TransactionFraudFlags(16000))
	.data('dataPop',new DataPop({'errLabel': errorLabel,'errMessage': errorMessage}));

	var windowWidth = $.getWindowWidth() - $.getScrollBarWidth() - 17;
	if(windowWidth > minWidth)
	{
		$('#transactions').css('width',windowWidth+'px');
//		$('#alertActivityGrid').css('width',(windowWidth-2)+'px');
//		$('#relatedGrid').css('width',(windowWidth-2)+'px');
	}

	$("#linkedEntitiesByCustSubcontent,#linkedEntitiesByAcctSubcontent,#secSubcontent").mousedown(mDown);

	i18n.init();
	initCalendars();
	handleInitialCallResult();

	// init alert activity queue display
	initAlertActivityQueueDisplay();
	//setGridBorders('alertActivity');
	initTxnGrids();
	//swapGridContents('alertActivity',2);
}

function enableSendEmail()
{
	enableEmailSent();
	document.getElementById('emailImg').src = "analyst/images/email.gif";
	document.getElementById('emailAnchor').href = '#';

	$(document).ready(function(){
		$("#emailImg").click(function(evt){
			$('div.templateFields').hide();
			if ($('#genericFieldsPlaceholderEmail').length == 0)
				$("#emailFieldsDIV table table tr:last").before('<tr><td id="genericFieldsPlaceholderEmail" colspan="2"></td></tr>');
			$('#genericFieldsDiv').appendTo($('#genericFieldsPlaceholderEmail'));
			$('#genericFieldsDiv').show();
			$('#emailFieldsDIV').positionTemplateFields().toggle();
		});
	});
}

function enableEmailSent()
{
	document.getElementById('sendEmail').disabled = false;
	document.getElementById('sendEmailLabel').disabled = false;
}

function enableSendSms()
{
	enableSmsSent();
	document.getElementById('smsImg').src = "analyst/images/sms.gif";
	document.getElementById('smsAnchor').href = '#';

	$(document).ready(function(){
		$("#smsImg").click(function(evt){
			if($('#sendSms').is(':disabled')) return;
			$('div.templateFields').hide();
			if ($('#genericFieldsPlaceholderSMS').length == 0)
				$("#smsFieldsDIV table table tr:last").before('<tr><td id="genericFieldsPlaceholderSMS" colspan="2"></td></tr>');
			$('#genericFieldsDiv').appendTo($('#genericFieldsPlaceholderSMS'));
			$('#genericFieldsDiv').show();
			$('#smsFieldsDIV').positionTemplateFields().toggle();
		});
	});
}

function enableSmsSent()
{
	document.getElementById('sendSms').disabled = false;
	document.getElementById('sendSmsLabel').disabled = false;
}

function enableSendLetter()
{
	enableLetterSent();
	document.getElementById('letterImg').src = "analyst/images/altAddress.gif";
	document.getElementById('letterAnchor').href = '#';

	$(document).ready(function(){
		$("#letterImg").click(function(evt){
			$('div.templateFields').hide();
			if ($('#genericFieldsPlaceholderLetter').length == 0)
				$("#letterFieldsDIV table table tr:last").before('<tr><td id="genericFieldsPlaceholderLetter" colspan="2"></td></tr>');
			$('#genericFieldsDiv').appendTo($('#genericFieldsPlaceholderLetter'));
			$('#genericFieldsDiv').show();
			$('#letterFieldsDIV').positionTemplateFields().toggle();
		});
	});
}

function enableLetterSent()
{
	document.getElementById('sendLetter').disabled = false;
	document.getElementById('sendLetterLabel').disabled = false;
}

function validateLetter(f)
{
	if (trim(f.altName1.value).length>0 || trim(f.altAddress1.value).length>0 || trim(f.altCity.value).length>0 ||
	    trim(f.altStateProvinceCode.value).length>0 || trim(f.altPostalCode.value).length>0)
	{
		if (trim(f.altName1.value).length==0 || trim(f.altAddress1.value).length==0 || trim(f.altCity.value).length==0 ||
		    trim(f.altStateProvinceCode.value).length==0 || trim(f.altPostalCode.value).length==0)
		{
			alert($i18n("fcm.alert.js.validateLetter.alert0.txt"));
			return false;
		}
	}
	if ((f.textProofCode1.selectedIndex==f.textProofCode2.selectedIndex && f.textProofCode1.selectedIndex !=0) ||
		 (f.textProofCode2.selectedIndex==f.textProofCode3.selectedIndex && f.textProofCode2.selectedIndex !=0) ||
		 (f.textProofCode1.selectedIndex==f.textProofCode3.selectedIndex && f.textProofCode2.selectedIndex !=0))
	{
		alert($i18n("fcm.alert.js.validateLetter.alert1.txt"));
		return false;
	}

	$('#letterFieldsDIV').hide();
}




// Parameters:
//    e:  event
function sortTable(e,dataType,colDiff)
{
	closeAllDataForTxn();

	var target = $.event.fix(e).target;
	var cell = target.parentNode;
	var tableID = cell.parentNode.parentNode.parentNode.id;
	var col = cell.cellIndex;

	var $table = $("#"+tableID);

	if ($table.data('moreRows')) // server sort
	{
		// sort by relative position in the query
		if (!(colDiff === undefined))
			col+=colDiff;

		var sortColumns = $table.data('sortColumns');

		var prevSortColumn;
		var prevSortOrder;
		var sortOrder = "ASC";

		var sortColumnsArray = sortColumns.split(',');
		for (var i=0; i<sortColumnsArray.length; i++)
		{
			var column = sortColumnsArray[i];
			var colOrderSplit = column.indexOf(' ');
			prevSortColumn = +column.substring(0, colOrderSplit);
			prevSortOrder = column.substring(colOrderSplit+1);

			if (prevSortColumn === col)
			{
				if (dataType.toUpperCase() == 'TXNDATETIME')
					sortColumnsArray.splice(i+1, 1);
				sortColumnsArray.splice(i, 1);

				sortOrder = (prevSortOrder === "DESC") ? "ASC" : "DESC";
			}
		}

		if (sortColumnsArray.length > 2)
			sortColumnsArray.splice(2, 1);

		if (dataType.toUpperCase() === 'TXNDATETIME')
			sortColumnsArray.unshift((col+1) + ' ' + sortOrder);

		sortColumnsArray.unshift(col + ' ' + sortOrder);
		sortColumns = sortColumnsArray.join(',');
		$table.data('sortColumns', sortColumns);

		scrollTransactions($table.data('acronym'), 0, '');
		return;
	}

//	var start = new Date().getTime();
	// client sort
	var table = $table[0];

	var tBody = table.tBodies[0];
	var rowCount = $table.data("totalRows");
	var newTRs = [];
	var childNodes = tBody.getElementsByTagName("tr");
	for (var i=0; i < rowCount; i++)
	{
		//newTRs.push(tBody.rows[i]);
		var row = childNodes[i];
		var allCells = row.getElementsByTagName("td")
		var obj = {};
		obj.row = row;
		if(dataType.toUpperCase() === 'TXNDATETIME')
		{
			obj.value = convert(allCells[col],"DATE");
			obj.value2 = convert(allCells[col+1],"TIME");
		}
		else
		{
			obj.value = convert(allCells[col],dataType);
		}
		newTRs[i] = obj;
	}
	childNodes = null;

//	var end = new Date().getTime();
	//$.log("Storing array:  "+ (end-start));
//	start = new Date().getTime();
	if (table.sortCol == col)
	{
		newTRs.reverse();
	}
	else
	{
		if (dataType.toUpperCase() === 'TXNDATETIME')
		{
			newTRs.sort(comparator2);
			newTRs.sort(comparator);
		}
		else
		{
			newTRs.sort(comparator);
		}
	}
//	end = new Date().getTime();
//	$.log("Sorting array:  "+ (end-start));

	var startRow = $table.data('startRow');
	if (startRow == undefined)
		startRow = 1;
//	var start,end;
//	start = new Date();
	var fragment = document.createDocumentFragment();
	fragment.appendChild($('<tbody/>')[0]);
	var newTBody = fragment.childNodes[0];
	for (var i=0; i < rowCount; i++)
	{
		var row = newTRs[i].row.cloneNode(true);
		var allCellsClone = row.getElementsByTagName("td");
		row.className = (i % 2) ? 'dataRow2_tableRow' : 'dataRow1_tableRow';
		allCellsClone[0].firstChild.nodeValue = (startRow + i);

		var checkBox = newTRs[i].row.getElementsByTagName("input");
		if(checkBox && checkBox.length)
		{
			allCellsClone[2].firstChild.checked = checkBox[0].checked;
		}
		newTBody.appendChild(row);
	}
	newTRs = null;
//	end = new Date();
//	$.log("appending rows to fragment:  "+ (end-start));

//	start = new Date();

	table.replaceChild(fragment,tBody);

//	end = new Date();
//	$.log("appending fragment to table:  "+ (end-start));

	table.sortCol = col;



}

function comparator(tr1, tr2)
{
	var value1 = tr1.value;
	var value2 = tr2.value;

	if (value1 < value2)
	{
		return -1;
	}
	else if (value1 > value2)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

function comparator2(tr1, tr2)
{
	var value1 = tr1.value2;
	var value2 = tr2.value2;

	if (value1 < value2)
	{
		return -1;
	}
	else if (value1 > value2)
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

function convert(sortCell, dataType)
{
	var value = sortCell.hasChildNodes() ? sortCell.firstChild.nodeValue : '';
	switch(dataType.toUpperCase())
	{
		case "NUMERIC":
			return parseFloat(value.replace(/[^\d]/g,''));
		case "CURRENCY":
			return parseFloat(value.replace(/[^\d]/g,''));
		case "DATE":
			return DateUtil.parseDate(value.replace(/\s+$/,'')).getTime();
		case "TIME":
			return DateUtil.parseTime(value.replace(/\s+$/,'')).getTime();
		case "DATETIME":
			return DateUtil.parseDateTime(value.replace(/\s+$/,'')).getTime();
		default:
			return value.toString();
	}
}

function initTxnGrids()
{
	var dataPop = $(document.body).data('dataPop');
	var $tables = $("#entityTransactionsContainer").find("table.txn-data-table")

	dataPop.setDataPopsByTable($tables);

	// Disable Tabs with no data
	//$("#transactionTabs li.txn-data-rows-false a, #moreSubcontent li.txn-data-rows-false a")
	$("#transactionTabs, #moreSubcontent").find("li.txn-data-rows-false a")
		.mousedown(function(){return false})
		.prop("disabled",true);

	var $transactionTabs = $("#transactionTabs").find("li");
	var tabsWithData = $transactionTabs.filter("li.txn-data-rows-true");

	if(tabsWithData.length > 0) // RAPTOR-2399
	{
		tabsWithData.filter(":not(li.txn-data-last-tab-true)").mousedown(swapTxnGrids);
		var currentTab = tabsWithData.eq(0);
		var idValue = currentTab.attr("id");
		var acronym = idValue.substr(0,idValue.length-3);

		setGridBorders(acronym, true);

		toggleGridHeight(acronym,false);
	}
	//only enable mousedown if there is data in last tab
	$transactionTabs.filter("li.txn-data-last-tab-true.txn-data-rows-true").mousedown(swapLastTxnTab);

	$transactionTabs.filter("li.txn-data-last-tab-true").data("pos",0);
	$('#moreSubcontent').bind('mouseleave', function() { $(this).hide(); })
		.find("li.txn-data-rows-true").mousedown(swapLastTxnTab).each(function(i){
			$this = $(this);
			$this.data("pos",(i+1));
		});

	insertTransactionFilter();
}
function swapTxnGrids(e)
{
	closeAllDataForTxn();
	e.stopPropagation();

	var $selectedTab = $(this);
	var idValue = $selectedTab.attr("id");//.search(_txnIdExp);
	var selectedId = idValue.substr(0,idValue.length - 3);//RegExp.$1;
	if(!$selectedTab.is(".current"))
	{
		var $currentTab = $selectedTab.parent().find("li.current");
		$currentTab.removeClass("current");

		$selectedTab.addClass("current");


		$("#"+selectedId+"Grid").show();
		setGridBorders(selectedId, true);
		// RAPTOR-2399
		if($currentTab.length == 1)//make sure one is current
		{
			idValue = $currentTab.attr("id");//.search(_txnIdExp);
			var currentId = idValue.substr(0,idValue.length - 3);//RegExp.$1;
			$("#"+currentId+"Grid").hide();
		}


		toggleGridHeight(selectedId,false);
	}
	else toggleGridHeight(selectedId, true);

}

function swapGridContents(gridName,gridNum){
		var activeTab = $(document.body).data("activeTab");
		var prev=activeTab[gridNum-1];

		if(prev!="" && prev != gridName){
			closeAllDataForTxn();
			$('#'+prev + "Tab").removeClass("current");
			//display desired content
			var grid=document.getElementById(gridName+"Grid");
			if(!grid) return;

			grid.style.display = "";
			$('#'+prev + "Grid").hide();
			activeTab[gridNum-1]=gridName;
			//select and save this tab
			$('#'+gridName + "Tab").addClass("current");
		}
		else if(gridName == 'alertActivity')
		{
			toggleAlertActivityHeight();
		}

		if (gridNum!=1 && gridName != 'wrap')
		{
//			setGridBorders(gridName);
		}
		if(gridNum == 1)
		{
			var maxWidth = Math.max($('#'+gridName+'Grid').outerWidth(),$('#contactInfo').data('originalWidth'));
			$('#'+gridName+'Grid').width(maxWidth);
			$('#contactInfo').width(maxWidth);
		}

}

function showHide(allValues,showVal)
{
	var cnt = allValues.length;
	for (var i=0;i<cnt;i++) {
		if (allValues[i].value!='')
		hideDiv(allValues[i].value);
	}
		showDiv(showVal);
}

function doSubmit() {
	setBusy('mainDiv');
	document.alertForm.submit();
}

function doSave(optional) {
	var callResult = crs[document.alertForm.callResult.selectedIndex];
	//something went wrong, no submit
	if (!callResult) return;

	// assessment is not optional
	if (!optional && callResult.id == 'NOSELECTION')
	{
		alert($i18n("fcm.alert.js.doSave.alert0.txt"));
	}
	else if (callResult.typeUnknown && callResult.timestampEnabled && document.alertForm.resurfaceStr.value=='')
	{
		alert($i18n("fcm.alert.js.doSave.alert1.txt"));
	}
	else if (callResult.typeUnknown && callResult.allowRerouteToEnabled && document.alertForm.rerouteToQueue.selectedIndex==0)
	{
		alert($i18n("fcm.alert.js.doSave.alert2.txt"));
	}
	else if (callResult.typeNegative && document.alertForm.fraudType.selectedIndex==0)
	{
		alert($i18n("fcm.alert.js.doSave.alert3.txt"));
	}
	else if (document.alertForm.memoText.value.length>document.alertForm.memoText.maxLength)
	{
		alert($i18n("fcm.alert.js.doSave.alert4.fmt.txt", [document.alertForm.memoText.value.length, document.alertForm.memoText.maxLength]));
	}
	else if (document.alertForm.memoText.value.length>0
		&& (/<\/?script[\w\W]*>/i).test (document.alertForm.memoText.value))
	{
		alert($i18n("fcm.alert.js.doSave.alert9.txt"));
	}
	else if(!validateTime(callResult)){
	}
	else
	{
		if (callResult.typeNegative && $("#systemBlockDIV").length == 1 && $("#systemBlockDIV").length == 1)
		{
			var sysVal=document.alertForm.systemBlock.value;
			var txnVal=document.alertForm.transactionBlock.value;
			if(callResult.applySystemBlock && (sysVal=='' || sysVal =='clearBlock')){
				if (!confirm($i18n("fcm.alert.js.doSave.confirm0.txt")))
				return;
			}
			if(callResult.applyTransactionBlock && sysVal=='' && (txnVal=='' || txnVal =='clearBlock')){
				if (!confirm($i18n("fcm.alert.js.doSave.confirm1.txt")))
				return;
			}
		}

//		if(isSaveAllConfirmedFraudTxnFields() === false)
//			return;
//
//		setConfirmedFraudAndNonFraudTxnFields();
		doSubmit();
	}
}

function cloneArray(fromArray) {
		newArray = new Array();
		for (i=0;i<fromArray.length;i++) {
			newArray.push(fromArray[i]);
		}
		return newArray;
}
function copyArray(toArray,fromArray) {
		for (i=0;i<fromArray.length;i++) {
			toArray[i]=fromArray[i];
		}
}

function clearArray(a,fromIndex) {
		for (i=fromIndex;i<a.length;) {
			a[i]=null;
		}
}

function reloadList(selectId, arrayList)
{
	if (!arrayList) return;

   var $selectTag = $('#'+selectId);
   // if zero or more than one select tag, there is a problem
   if($selectTag.length !== 1) return; // RAPTOR-2399

   for(var i = 0, len = arrayList.length; i < len; i++)
   {
	  $selectTag[0].options.add( new Option(arrayList[i].label, arrayList[i].id) );
   }
}

function handleCallResult(selectedIndex) {

	//reset the state
	$("span[id^='QCR_']").css("display", "none");
	$("#rerouteToQueue")[0].options.length = 1;
	$("#calTarget1")[0].value = "";
	$("#fraudType")[0].options.length = 1;

	var cr = crs[selectedIndex];
	// something was wrong, return
	if ( !cr ) return;

	var callResultVal = "" + cr.id;
	if (callResultVal != 'NOSELECTION')
	{
		if (cr.typeUnknown)
		{
			if (cr.allowRerouteToEnabled){
				reloadList("rerouteToQueue", allowRerouteTo[callResultVal]);
				$("#QCR_REROUTE_QUEUES").css("display", "inline");
			}
			if (cr.timestampEnabled){
				$("#QCR_RESURFACE_TIMESTAMP").css("display", "inline");
			}

		}
		else if (cr.typeNegative)
		{
			reloadList("fraudType", fraudTypes[callResultVal]);
			$("#QCR_FRAUD_TYPES").css("display", "");
		}
	}

	var na = $i18n("fcm.alert.na.txt");
	var sysBlockDiv=getElement('systemBlockDIV');
	var txnBlockDiv=getElement('transactionBlockDIV');
	if (sysBlockDiv!=null && txnBlockDiv!=null)
	{
		if (callResultVal!='NOSELECTION')
		{
			var txnBlockContnts=getElement('transactionBlock'+callResultVal+'DIV');

			if (txnBlockContnts)
			{
				txnBlockDiv.innerHTML=txnBlockContnts.innerHTML;
			}
			else
			{
				txnBlockDiv.innerHTML=na;
			}

			var sysBlockContnts=getElement('systemBlock'+callResultVal+'DIV');
			if (sysBlockContnts)
			{
				sysBlockDiv.innerHTML=sysBlockContnts.innerHTML;
			}

			else
			{
				sysBlockDiv.innerHTML=na;
			}
		}
		else
		{
			txnBlockDiv.innerHTML=na;
			sysBlockDiv.innerHTML=na;
		}

		var txnDT=getElement('transactionBlockDateDIV')
		if (txnDT!=null)
			txnDT.style.display = "none";

		var sysDT=getElement('systemBlockDateDIV')
		if (sysDT!=null)
				sysDT.style.display = "none";
	}

	document.alertForm.systemBlock.value='';
	document.alertForm.transactionBlock.value='';
}

function handleInitialCallResult()
{
	var form = document.alertForm;
	if (form && form.callResult)
	{
		var callResult = form.callResult;

		//populate call results dropdown
		for (var i=0; i < crs.length; i++)
			callResult.options.add( new Option(crs[i].label, crs[i].name) );

		handleCallResult(callResult.selectedIndex);
	}
}

function handleSysBlock(blockVal) {
	document.alertForm.systemBlock.value=blockVal;
	var sysDT=getElement('systemBlockDateDIV')
	if (sysDT==null)
			return;
	if (blockVal=='' || blockVal == 'clearBlock')
		sysDT.style.display = "none";
	else
		sysDT.style.display = "";
}

function handleTxnBlock(blockVal) {
	document.alertForm.transactionBlock.value=blockVal;
	var txnDT=getElement('transactionBlockDateDIV')
	if (txnDT==null)
		return;
	if (blockVal=='' || blockVal == 'clearBlock')
		txnDT.style.display = "none";
	else
		txnDT.style.display = "";
}

function setGridBorders(name,isTxnGrid)
{
	var $grd = $("#"+name+"Grid");

	if($grd.length === 0 || $grd.data("bordersSet")) return;

	var $tbl = $("#"+name+"Table");
	var $overflowContainer = isTxnGrid ? $grd.children(":first") : $grd;

	var viewHeight = $overflowContainer[0].clientHeight;
	var viewWidth = $overflowContainer[0].clientWidth;
	var sbarSize = $.getScrollBarWidth();
	var actualWidth = $tbl.width();
	var actualHeight = $tbl.height();
	$tbl.data("height",actualHeight);

	var delta = actualWidth - viewWidth - sbarSize ;
	if(delta === 0)
	{
		$tbl.data("adjustedWidth",viewWidth).css('width',viewWidth+'px');
	}
	else
	{
		if(delta > 0 && name === 'alertActivity')
		{// make cells wrap to reduce hscrolling as much as possible
			$tbl.find('td.allowWrapping').css('white-space','normal');
		}
		else if (actualWidth == viewWidth)
		{
			$tbl.css('width',(viewWidth-sizeAdjustment)+'px');
		}
		else if (delta < 0)
		{
			$tbl.css('width',viewWidth+'px');
		}
		// get new height
		actualHeight = $tbl.height();
	}

	if(viewHeight > actualHeight)
	{
		var adjustedHeight = ((delta > 0) ? (actualHeight+sbarSize) : (actualHeight))+sizeAdjustment;
		$overflowContainer.css('height',adjustedHeight+'px');

		$overflowContainer.data("originalHeight",adjustedHeight);
		$overflowContainer.data("hbar",(delta > 0));
	}
	else
	{
		$overflowContainer.data("originalHeight",$overflowContainer.height());//12.1em
		$overflowContainer.data("hbar",(delta>0));
	}

	$grd.data("bordersSet",true);
}

function viewCallScript(callScriptURI)
{
	w=screen.availWidth;
	popupW = 520;
	popupH = 540;
	h=screen.availHeight;
	l=(w-popupW)/2;
	t=((h-popupH)/2)-24;
	callScriptaWin=window.open(callScriptURI,"FCMcallScriptWin",
				"height=" + popupH + "," + "width=" + popupW + "," + "status=yes,toolbar=no,menubar=no,location=no,titlebar=no,scrollbars=yes,resizable=yes,top="+t+",left="+l);
	callScriptaWin.focus();
}



/***********************************************
* Drop Down/ Overlapping Content- � Dynamic Drive (www.dynamicdrive.com)
* This notice must stay intact for legal use.
* Visit http://www.dynamicdrive.com/ for full source code
***********************************************/

function getposOffset(overlay, offsettype){
	var totaloffset=(offsettype=="left")? overlay.offsetLeft : overlay.offsetTop;
	var parentEl=overlay.offsetParent;
	while (parentEl!=null){
		totaloffset=(offsettype=="left")? totaloffset+parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
		parentEl=parentEl.offsetParent;
	}
	return totaloffset;
}

function overlay(curobj, subobjstr, opt_position){

	if (document.getElementById){
		var subobj=document.getElementById(subobjstr);
		subobj.style.display=(subobj.style.display!="block")? "block" : "none";
		var xpos=getposOffset(curobj, "left")+((typeof opt_position!="undefined" && opt_position.indexOf("right")!=-1)? -(subobj.offsetWidth-curobj.offsetWidth) : 0) ;
		var ypos=getposOffset(curobj, "top")+((typeof opt_position!="undefined" && opt_position.indexOf("bottom")!=-1)? curobj.offsetHeight : 0);
		xpos = xpos - document.body.scrollLeft;
		ypos = ypos - document.body.scrollTop;
		subobj.style.left=xpos+"px";
		subobj.style.top=ypos+"px";
		subobj.style.zIndex="99";
		return false;
	}
	else
		return true;
}

/*mDown***********************************************************************/
// jquery event is passed in
function mDown(e){
	e.stopPropagation();

	//define position of mouse (posx,posy)
	var posx = e.pageX;
	var posy = e.pageY;

	//define target
	var target = e.currentTarget;
	//define dragee
	var $dragee = $(target);
	var offset = $dragee.offset();
	var offX = posx - offset.left;
	var offY = posy - offset.top;
	var width = $dragee.width();

	var oldZ = $dragee.css('zIndex');
	$dragee.css('zIndex','100');

	//set onmousemove and onmouseup event handler
	var data = {dragee:$dragee,oldZ:oldZ,offX:offX,offY:offY,width:width};
	$(document).bind('mouseup',data,mUp).bind('mousemove',data,doDrag);
}
/*mUp*************************************************************************/
function mUp(e){
	//stop dragging
	e.stopPropagation();
	var $dragee = e.data.dragee;
	$(document).unbind('mouseup').unbind('mousemove');

	var oldZ = e.data.oldZ;
	if(oldZ){
		$dragee.css('zIndex',oldZ);
	}
}
/*doDrag**********************************************************************/
function doDrag(e){
	e.stopPropagation();

	var $dragee = e.data.dragee;

	//define position of mouse
	var posx = e.pageX;
	var posy = e.pageY;

	var tempLeft = posx - e.data.offX;
	var tempTop = posy - e.data.offY;

	if(tempLeft<0)tempLeft=0;

//		else if(tempLeft>=(winWidth-dragee.width))tempLeft=(winWidth-dragee.width);
	if(tempTop<0)tempTop=0;
	//else if(tempTop>=winHeight-dragee.height)tempTop=(winHeight-dragee.height);
	$dragee.css({left:tempLeft, top:tempTop, width: e.data.width});
//		window.status='current topleft position: ( '+((tempLeft<10)?'000':(tempLeft<100)?'00':(tempLeft<1000)?'0':'')+tempLeft+', '+((tempTop<10)?'000':(tempTop<100)?'00':(tempTop<1000)?'0':'')+tempTop+' )';

	return false;
}

function toggleGridHeight(gridname, changeMode)
{
	var txnExpandedMode = $(document.body).data('txnExpandedMode');
	if(txnExpandedMode == null)
		txnExpandedMode = true;

	txnExpandedMode = txnExpandedMode != changeMode;
	$(document.body).data('txnExpandedMode',txnExpandedMode);

	var $overflowContainer = $("#"+gridname+"OverflowContainer");
	var $table = $overflowContainer.children(":first");

	var originalHeight = $overflowContainer.data("originalHeight");
	var expandedHeight = $overflowContainer.data("expandedHeight");

	var thisExpandedMode = $overflowContainer.data("txnExpandedMode");
	if(txnExpandedMode != thisExpandedMode)
	{
		if(txnExpandedMode)
		{
			if(!expandedHeight)
			{
				var $grid = $overflowContainer.parent();
				var totalsGridHeight = $overflowContainer.next().height();
//				var tableHeight = $table.data("height") + sizeAdjustment;
				var tableHeight = $table.height() + sizeAdjustment;
				var tableWidth = $table.data("adjustedWidth");
				var availSpace = $.getWindowHeight() - $grid.offset().top - totalsGridHeight - 5;
				var hbar = $overflowContainer.data("hbar");
				var expandedHeight = (availSpace > tableHeight) ? ((hbar) ? (tableHeight + $.getScrollBarWidth()) : tableHeight) : availSpace;
				if(expandedHeight !== availSpace && tableWidth)
				{
					$table.data('expandedWidth',(tableWidth + $.getScrollBarWidth()))
					$table.data("collapsedWidth", tableWidth);
				}
				$overflowContainer.data("expandedHeight",expandedHeight);
			}

			var width = $table.data("expandedWidth");
			if(width)
				$table.css('width',width+"px");
			$overflowContainer.height(expandedHeight);
		}
		else
		{
			$overflowContainer.height(originalHeight);
			var width = $table.data("collapsedWidth");
			if(width)
				$table.css('width',width+"px");
		}

		$overflowContainer.data("txnExpandedMode",txnExpandedMode);
	}

}
//TODO: make generic for other table usage.
function toggleAlertActivityHeight()
{
	var $overflowContainer = $("#alertActivityGrid");
	var $table = $("#alertActivityTable");

	var originalHeight = $overflowContainer.data("originalHeight");
	var expandedHeight = $overflowContainer.data("expandedHeight");

	var txnExpandedMode = $overflowContainer.data("txnExpandedMode");
	if(txnExpandedMode == null) txnExpandedMode = true;

	if(txnExpandedMode)
	{
		if(!expandedHeight)
		{
//			var tableHeight = $table.data("height") + sizeAdjustment;
			var tableHeight = $table.height() + sizeAdjustment;
			var tableWidth = $table.data("adjustedWidth");
			var availSpace = $.getWindowHeight() - $overflowContainer.offset().top;
			var expandedHeight = (availSpace > tableHeight) ? tableHeight : availSpace;
			if(expandedHeight !== availSpace && tableWidth)
			{
				$table.data('expandedWidth',(tableWidth + $.getScrollBarWidth()))
				$table.data("collapsedWidth", tableWidth);
			}
			var hbar = $overflowContainer.data("hbar");
			if(hbar) expandedHeight+=$.getScrollBarWidth()-2;
			$overflowContainer.data("expandedHeight",expandedHeight);
		}
		var width = $table.data("expandedWidth");
		if(width)
			$table.css('width',width+"px");
		$overflowContainer.height(expandedHeight);
	}
	else
	{
		$overflowContainer.height(originalHeight);
		var width = $table.data("collapsedWidth");
		if(width)
			$table.css('width',width+"px");
	}

	$overflowContainer.data("txnExpandedMode",!txnExpandedMode);
}

function swapLastTxnTab(e)
{
	var $selectedTab = $(this);
	var $lastTab = $("#transactionTabs").find("li.txn-data-last-tab-true");

	// Is this best way to check equality?
	if($selectedTab.attr("id") != $lastTab.attr("id"))
	{//swap $lastTab with $selectedTab
		$selectedTabClone = $selectedTab.clone(true);
		$selectedTabClone.data("pos",0);
		$selectedTabClone.children().removeClass("moreAnchor");

		var $moreSubcontent = $('#moreSubcontent');
		$moreSubcontent.hide();
		$selectedTabClone.insertAfter($lastTab);

		if ($lastTab.is(".txn-data-rows-true"))
		{
			$lastTabClone = $lastTab.clone(true);

			if ($lastTabClone.is(".current"))
			{
				var idValue = $lastTabClone.attr("id");//.search(_txnIdExp);
				var id = idValue.substr(0,idValue.length-3);
				$("#"+id+"Grid").hide();
				$lastTabClone.removeClass("current");
			}

			$lastTabClone.children().addClass('moreAnchor');

			var pos = $selectedTab.data("pos");
			$lastTabClone.data("pos",pos);

			$lastTabClone.insertBefore($selectedTab);
		}

		$lastTab.remove();
		$selectedTab.remove();
		$selectedTab = $selectedTabClone;

		//load transactions if not yet loaded
		$selectedTab.find("a").click();

	}
	swapTxnGrids.call($selectedTab[0],e);
}

function isSaveAllConfirmedFraudTxnFields()
{
	// Get all txn tables but the ALL table
	var txnTables = $('table.txn-data-table').filter(':not([id^="ALL"])');

	var bodyTag = $(document.body);
	var cfTransactionFlags = bodyTag.data('cfTransactionFlags');

	for(var ii = 0; ii < txnTables.length; ii++) // RAPTOR-2399
	{
		var txnTable = txnTables.get(ii);
		var inputs = txnTable.getElementsByTagName("input");
		var numInputs = inputs.length;
		for(var i = 0; i < numInputs; i++)
		{
			var input = inputs[i];
			if(input.checked)
			{
				var baseID = input.id;
				var acronym = baseID.substr(0, 4);
				var tranID = baseID.substr(5);
				var added = cfTransactionFlags.addTrans(acronym, tranID);
				// if transaction could not be added notify the user
				if(!added)
				{
					// continue saving without adding anymore transactions if users requests
					var continueSaving = confirm( $i18n("fcm.alert.js.maxTransactionMarked.txt") )
					if(!continueSaving)
						return false;
				}
			}
		}
	}
	return true;
}

function checkAllTransactions(link, acronymName, isAllPages)
{
	var totalRows = $('#'+acronymName+'Table').data("totalRows");
	var confirmedFraudCount = $('#'+acronymName+'Table').data("confirmedFraudCount");

	if(totalRows > confirmedFraudCount)
	{
		var table = document.getElementById(acronymName+'Table');
		var inputs = table.getElementsByTagName("input");
		var numInputs = inputs.length;
		var checkboxes = [];
		for(var i = 0, j = 0; i < numInputs; i++)
		{
			var input = inputs[i];
			if(!input.checked)
			{
				input.checked = true;
				checkboxes[j++] = input;
			}
		}
		transClicked2(checkboxes,acronymName, true)
	}
	else
	{
		var table = document.getElementById(acronymName+'Table');
		var inputs = table.getElementsByTagName("input");
		var numInputs = inputs.length;
		var checkboxes = [];
		for(var i = 0, j = 0; i < numInputs; i++)
		{
			var input = inputs[i];
			if(input.checked)
			{
				input.checked = false;
				checkboxes[j++] = input;
			}
		}
		transClicked2(checkboxes,acronymName, false)
	}


}

function transClicked(chkbox,acronymName)
{
	return transClicked2([chkbox],acronymName,chkbox.checked);
}

function transClicked2(checkboxes, acronymName, checkedValue)
{
	var isAllTab = (acronymName==='ALL');
	var bodyTag = $(document.body);
	var cfTransactionFlags = bodyTag.data('cfTransactionFlags');
	var okTransactionFlags = bodyTag.data('okTransactionFlags');

	//ID=[ALL_]XXXX_DDDDDDDDD
	var index = (isAllTab ? 4 : 0);
	var size = checkboxes.length;
	var counters = {};
	counters[acronymName] = 0;

	var dupedCheckBoxes = {};
	for(var ii = 0; ii < size; ii++)
	{
		var chkbox = checkboxes[ii];
		var idValue = chkbox.id;
		var baseID = index ? idValue.substr(index) : idValue;
		var acronym = baseID.substr(0, 4);
		var tranID = baseID.substr(5);

		if(checkedValue != chkbox.defaultChecked)
		{
			if(checkedValue)
			{
				var added = cfTransactionFlags.addTrans(acronym,tranID);
				if(!added)
				{
					chkbox.checked = !checkedValue;
					break;
				}
			}
			else
			{
				var added = okTransactionFlags.addTrans(acronym,tranID);
				if(!added)
				{
					chkbox.checked = !checkedValue;
					break;
				}
			}
		}
		else
		{
			if(!checkedValue)
			{
				cfTransactionFlags.removeTrans(acronym,tranID);

			}
			else
			{
				okTransactionFlags.removeTrans(acronym,tranID);
			}
		}

		counters[acronymName]++;

		var dupedChkboxID = isAllTab ? baseID : "ALL_"+baseID;
		var chkboxAcronym = isAllTab ? acronym : "ALL";
		var checkBoxIDs = dupedCheckBoxes[chkboxAcronym] || {}
		checkBoxIDs[dupedChkboxID] = dupedChkboxID;
		if(!dupedCheckBoxes[chkboxAcronym])
			dupedCheckBoxes[chkboxAcronym] = checkBoxIDs;

	}

	for(var chkboxAcronym in dupedCheckBoxes)
	{
		// Get potential duplicate checkboxes
		var table = document.getElementById(chkboxAcronym+"Table");
		if(table)
		{
			var dupInputs = table.getElementsByTagName("input");
			var dupInputsSize = dupInputs.length;
			var checkBoxIDs = dupedCheckBoxes[chkboxAcronym];
			for(var ii=0; ii<dupInputsSize; ii++)
			{
				var input = dupInputs[ii];
				if(checkBoxIDs[input.id])
				{
					input.checked = checkedValue;
					counters[chkboxAcronym] ? counters[chkboxAcronym]++ : (counters[chkboxAcronym] = 1);
				}
			}
		}
	}

	for(var counterName in counters)
	{
		updateTransactionCFCount($("#"+counterName+"Table"),counterName,checkedValue, counters[counterName]);
	}

	if(counters[acronymName] !== size)
	{
		alert(checkedValue ? $i18n("fcm.alert.js.maxTransactionMarked.txt") : $i18n("fcm.alert.js.maxTransactionUnmarked.txt"));
	}


	return true;
}

function updateTransactionCFCount($table, acronymName, checked, num)
{
	var counter = $table.data("confirmedFraudCount");
	var totalRows = $table.data("totalRows");

	if(checked)
		counter += num;
	else
		counter -= num;

	$table.data("confirmedFraudCount", counter);

	if(checked && totalRows == counter)
		$("#"+acronymName+"CheckAllTransactions").text($('#markAllVerifiedOK').text());
	else if(!checked && (totalRows == counter+num))
		$("#"+acronymName+"CheckAllTransactions").text($('#markAllConfirmedFraud').text());
}

function remarkTransactions()
{
	var cfTransactionFlags = $(document.body).data('cfTransactionFlags');
	var okTransactionFlags = $(document.body).data('okTransactionFlags');

	var acronymNames = cfTransactionFlags.getAcronymNames();
	var len = acronymNames.length
	for(var i = 0; i < len; i++)
	{
		var acronymName = acronymNames[i];
		var tranIDs = cfTransactionFlags.getTranIDs(acronymName);
		var tranIDsLength = tranIDs.length;
		for(var j = 0; j < tranIDsLength; j++)
		{
			$('#'+acronymName+'_'+tranIDs[j]+',#ALL_'+acronymName+'_'+tranIDs[j]).prop('checked',true);
		}
	}

	acronymNames = okTransactionFlags.getAcronymNames();
	len = acronymNames.length
	for(var i = 0; i < len; i++)
	{
		var acronymName = acronymNames[i];
		var tranIDs = okTransactionFlags.getTranIDs(acronymName);
		var tranIDsLength = tranIDs.length;
		for(var j = 0; j < tranIDsLength; j++)
		{
			$('#'+acronymName+'_'+tranIDs[j]+',#ALL_'+acronymName+'_'+tranIDs[j]).prop('checked',false);
		}
	}
}

// return the current transaction markings in string
function getCurrentMarkingsStr()
{
	return "cfTransactionFlags="+ $(document.body).data('cfTransactionFlags') + ";okTransactionFlags=" + $(document.body).data('okTransactionFlags');
}

// Requires 2 hidden fields to be created per transaction type
// to store the ids for form submission.
// <input type="hidden" name="cfTrans(grid-name)"/>
// <input type="hidden" name="okTrans(grid-name)"/>
function setConfirmedFraudAndNonFraudTxnFields()
{
	var cfTransactionFlags = $(document.body).data('cfTransactionFlags');
	var okTransactionFlags = $(document.body).data('okTransactionFlags');

	var $alertForm = $(document.alertForm);

	// ex: trans(RUAC_1234567)-> RE.$1=RUAC RE.$2=1234567
	var re = /^([a-zA-Z0-9]+)_([0-9]+)$/;

	var acronymNames = cfTransactionFlags.getAcronymNames();
	var len = acronymNames.length
	for(var i = 0; i < len; i++)
	{
		var acronymName = acronymNames[i];
		var tranIDs = cfTransactionFlags.getTranIDs(acronymName);
		$alertForm.append('<input type="hidden" name="cfTrans('+acronymName+')" value="'+tranIDs.join(',')+'"/>');
	}

	acronymNames = okTransactionFlags.getAcronymNames();
	var len = acronymNames.length
	for(var i = 0; i < len; i++)
	{
		var acronymName = acronymNames[i];
		var tranIDs = okTransactionFlags.getTranIDs(acronymName);
		$alertForm.append('<input type="hidden" name="okTrans('+acronymName+')" value="'+tranIDs.join(',')+'"/>');
	}

}

function validateTime(callResult){

	var today=new Date();
	var flag=true;

	if (callResult.typeUnknown && callResult.timestampEnabled)
	{
		var reschedule=document.alertForm.resurfaceStr.value;
		if(reschedule!=''){
			reschedule=DateUtil.parseDateTime(reschedule);
			if (reschedule<today){
				if (!callResult.allowRerouteToEnabled)
					alert($i18n("fcm.alert.js.doSave.alert5.txt"));
				else
					alert($i18n("fcm.alert.js.doSave.alert6.txt"));
				flag=false;
			}
		}
	}

	if(document.alertForm.systemBlockUntilStr){
		var systemBlockUntil=document.alertForm.systemBlockUntilStr.value;
		var sysDT=getElement('systemBlockDateDIV')
		if(systemBlockUntil!='' && sysDT.style.display!='none'){
			systemBlockUntil=DateUtil.parseDateTime(systemBlockUntil);
			if(systemBlockUntil<today){
				alert($i18n("fcm.alert.js.doSave.alert7.txt"));
				flag=false;
			}
		}
	}

	if(document.alertForm.transactionBlockUntilStr){
		var transactionBlockUntil=document.alertForm.transactionBlockUntilStr.value;
		var transDT=getElement('transactionBlockDateDIV')
		if(transactionBlockUntil!=''&& transDT.style.display!='none'){
			transactionBlockUntil=DateUtil.parseDateTime(transactionBlockUntil);
			if(transactionBlockUntil<today){
				alert($i18n("fcm.alert.js.doSave.alert8.txt"));
				flag=false;
			}
		}
	}
	return flag;

}
function verify(type, objName, compVal){
	var obj=$('#'+objName);
	var x= obj.val().toUpperCase();

	if(obj.css('display') != 'none'){
		if(type=='date'){

			x=DateUtil.parseDate(x);
			x=DateUtil.getLocalTime(x).getTime();
		}
		var hash = hex_md5(""+x);
		if(hash==compVal){
			obj.hide();
			var icon=$('#'+objName+"Icon");
			var cal = $('#'+objName+"Cal");
			cal.hide();
			icon.attr('src','admin/images/CheckGreen.gif');
			icon.parent().css('cursor','default').unbind('click');
		}

		else{
			if(type=='date') obj.css('color','red');
			else
			{
				obj.val('');
			}

		}
	}
}
/**
 * Reloads the transaction grids based on the selected entity's identifiers
 * @param caller - the DOM element that initiated the call
 * @param entityObj - an object of identifiers {entityID: xxx, entityType: CARD|ACCOUNT|CUSTOMER|PHONE_USER_ID|ONLINE_USER_ID,customerNumber: yyy}
 * @param gridID - the grid ID currently in use
 */
function viewEntityTransactions(caller, entityObj, gridID, displayType)
{
	$('#linkedEntityTransactionFilter').hide();
	closeAllDataForTxn();

	var className = 'selectedTxnFilter';
	var $this = $(caller);
//	if($this.hasClass(className))
//		return;

	$this.siblings().removeClass(className);
	$this.addClass(className);

	var $cntr = $('#entityTransactionsContainer');
	var $reqIcon = $('#entityTransactionsRequestIcon');
	var offset = $cntr.children(':first').offset();

	offset.left = 440 - $reqIcon.width()/2;
	offset.top += ($cntr.height()/2 - $reqIcon.height()/2);
	$cntr.css('visibility','hidden');
	offset.top = offset.top - document.body.scrollTop;
	offset.left = offset.left - document.body.scrollLeft;
	$reqIcon.css(offset).show();

	var form = new DynaForm('viewEntityTransactionsForm');
	form.setAction('viewEntityTransactions.action')
		.setEnableAjax(true)
		.setCallback(replaceTransactions)
		.setParam('method','viewEntityTransactions')
		.setParam('gridID',gridID)
		.setParam('displayType',displayType)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(entityObj)
		.doSubmit();
}

/**
 * AJAX callback function which replaces the transaction grids with the
 * newly generated tranaction grids.
 *
 * @param data - html representing the new transaction grids
 */
function replaceTransactions(data)
{
	var $txCtnr = $('#entityTransactionsContainer');
	var $tables = $txCtnr.find("table.txn-data-table");

	var dataPop = $(document.body).data('dataPop');
	dataPop.reset($tables);

	$('#moreSubcontent,#transactionTabs').unbind().find("li,a").unbind();
	$('#transactionFilterTab').unbind();

	var txCtnr = $txCtnr[0];
	var newCtnr = txCtnr.cloneNode(false);
	newCtnr.style.visibility='visible'; // set to visible before replacing in DOM
	var html = [];
	var scripts = [];
	var cursor = 0;
	var len = data.length;
	while(cursor < len)
	{
		var end = data.indexOf("</script>",cursor);
		var tab = (end != -1) ? data.substring(cursor, end+9) : data.substring(cursor);
		var index = tab.indexOf("<script>");
		if(index > 0)
		{
			html.push(tab.substring(0,index));
			scripts.push(tab.substring(index));
		}
		else
		{
			html.push(tab);
		}

		cursor = (end != -1) ? (end + 9) : (len);
	}

	newCtnr.innerHTML = html.join('');
	
	// RAPTOR-2399
	// Refactored the code to attach the script section at the transTable.jsp.  
	// After the jQuery upgrade the scripts wouldn't run with the old way
	scripts.forEach(function (script) {
		const newScript = document.createElement("script");
		const inlineScript = document.createTextNode(getScriptBody(script));
		
		newScript.appendChild(inlineScript);
		newCtnr.appendChild(newScript);
	} );

	txCtnr.parentNode.replaceChild(newCtnr,txCtnr);

	$('#entityTransactionsRequestIcon').hide();

	var windowWidth = $.getWindowWidth() - $.getScrollBarWidth() - 17;
	if(windowWidth > minWidth)
	{
		$('#transactions').css('width',windowWidth+'px');
	}
	else
	{
		$('#transactions').css('width',minWidth+'px');
	}

	initTxnGrids();

//	remarkTransactions();
}

// RAPTOR-2399
// Extract the script body from the param script, which is a string with the <script> and </script> tags.
function getScriptBody(script) {
	const scriptOpenTag = "<script>";
	const myScript = script.trim();
	
	return myScript.substring(scriptOpenTag.length, (myScript.length - (scriptOpenTag.length+1)));
}

/**
 * Initializes the transaction filter if linked entities exist.
 */
function insertTransactionFilter()
{
	var $linkedEntityTransactionFilter = $('#linkedEntityTransactionFilter');
	var $li = $linkedEntityTransactionFilter.find("li");
	if($li.length > 1) // RAPTOR-2399
	{
		$linkedEntityTransactionFilter.bind('mouseleave',hideTransactionFilterSelections);
		var arrowImg = '<img src="common/images/menu/dropBlue.gif" class="icon" width="7" height="4"/>';
		var $selectedLi =  $li.filter("li.selectedTxnFilter");
		var $entityImg = $selectedLi.find('img');
		var value = $selectedLi.find('a').text();

		$('#transactionFilterTab').mousedown(showTransactionFilterSelections)
									.show()
									.find('span')
									.append($entityImg.clone())
									.append(' '+value+' ')
									.append(arrowImg);
	}
}
/**
 * Shows the Selections for the Transaction Filter
 * @return
 */
function showTransactionFilterSelections(e)
{
	var $this = $(this);
	var offset = $this.offset();
	offset.top = offset.top + $this.height() - 2 - document.body.scrollTop;
	offset.left = offset.left - document.body.scrollLeft;
	var $txnFilter = $('#linkedEntityTransactionFilter');

	// line up right edges
	offset.left = offset.left + ($this.width() - $txnFilter.width()) - 6;
	$txnFilter.css(offset);
	$txnFilter.show().removeHScrollBar();

	return false;
}
/**
 * Hides the Selections for the Transaction Filter
 * @return
 */
function hideTransactionFilterSelections()
{
	$('#linkedEntityTransactionFilter').hide();
	return false;
}

function toggleLinkedEntityContainer(e)
{
	e.stopPropagation();
	if(e.data.expand)
		expandLinkedEntityContainer(e)
	else
		collapseLinkedEntityContainer(e)

	e.data.expand = !e.data.expand;
}

function expandLinkedEntityContainer(e)
{
	var divName = e.data.divName;
	$(e.currentTarget).find('img:eq(0)').hide();
	$(e.currentTarget).find('img:eq(1)').show();
	$('#'+divName)
	.width('auto')
	.find('#'+divName+'Table')
	.find('th.addl,td.addl')
	.show();
}

function collapseLinkedEntityContainer(e)
{
	var divName = e.data.divName;
	$(e.currentTarget).find('img:eq(1)').hide();
	$(e.currentTarget).find('img:eq(0)').show();
	$('#'+divName)
	.find('#'+divName+'Table')
	.find('th.addl,td.addl')
	.hide();
	$('#'+divName).width('auto');
}

/**
 * Pages transaction table backward or forward
 * @param acronym - the accountType and activityType or ALL
 * @param start - row number
 * @param direction - PREV or NEXT
 */
function scrollTransactions(acronym, start, direction)
{
	var $table = $('#'+acronym+'Table');
	var gridID = $table.data('gridID');
	var sortOrder = 'ASC';

	var $cntr = $('#entityTransactionsContainer');
	var $reqIcon = $('#entityTransactionsRequestIcon');
	var offset = $cntr.children(':first').offset();

	offset.left = 440 - $reqIcon.width()/2;
	offset.top += ($cntr.height()/2 - $reqIcon.height()/2);

	$cntr.css('visibility','hidden');
	$reqIcon.css(offset).show();

	var form = new DynaForm('viewEntityTransactionsForm');
	form.setAction('viewEntityTransactionActivity.action')
		.setEnableAjax(true)
		.setCallback(replaceTransTable)
		.setParam('method','viewEntityTransactionActivity')
		.setParam('gridID',gridID)
		.setParam('displayType', $table.data('displayType'))
		.setParam('acronym',acronym)
		.setParam('startRow',start)
		.setParam('direction',direction)
		.setParam('sortColumns',$table.data('sortColumns'))
		.setParam('timeWindow',$table.data('timeWindow'))
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams($table.data('entityObj'))
		.doSubmit();
}
/**
 * AJAX callback function which replaces data in a transaction table
 *
 * @param data - html representing the new transaction table
 */
function replaceTransTable(data)
{
	var dataPop = $(document.body).data('dataPop');
	var idValue = $('#transactionTabs').find('li.current').attr('id');
	var acronym = idValue.substr(0,idValue.length - 3);
	var $txCtnr = $('#transTableContainer');
	var $table = $("#"+acronym+"Table");
	dataPop.reset($table);

	//$("#"+acronym+"Grid").data("bordersSet", null).html(data);
	var scriptIndex = data.indexOf("<script>");

	var grid = document.getElementById(acronym+"Grid");
	var newGrid = grid.cloneNode(false);
	newGrid.innerHTML = data.substring(0,scriptIndex);
	grid.parentNode.replaceChild(newGrid,grid);
	$(newGrid).data("bordersSet", false).append(data.substring(scriptIndex));

	$table = $("#"+acronym+"Table");
	setGridBorders(acronym, true);
	toggleGridHeight(acronym,false);
	dataPop.setDataPopsByTable($table);

	$('#entityTransactionsContainer').css('visibility','visible');
	$('#entityTransactionsRequestIcon').hide();

//	remarkTransactions();
}

/**
 * Load the specified transaction table if not loaded yet
 *
 * @param acronym - the transaction table to be loaded
 */
function lazyLoadTransactions (acronym)
{
	var $table = $("#"+acronym+"Table");
	if ($table.data('initLoaded'))
		return;

	scrollTransactions(acronym,0,'FIRST');
}

function highlightDatapop(event)
{
	var $e = $.event.fix(event);
	$e.stopPropagation();

	var $target = $($e.target);
	if($target.is(".data-pop-cell"))
	{
		$target.css({'background-color': '#ddddee','color': '#3300CC','cursor': 'pointer'});
	}
}

function unhighlightDatapop(event)
{
	var $e = $.event.fix(event);
	$e.stopPropagation();

	var $target = $($e.target);
	if($target.is(".data-pop-cell"))
	{
		$target.css({'background-color': '','color': '','cursor': ''});
	}
}

/**
 * Fetches and displays the fraud alerts for a given transaction.
 *
 * @param event - native event object
 * @param alertIDs - a comma delimited list of alert ids
 */
function getTxnFraudAlerts(event, alertIDs)
{
	var txnFraudAlertsParams = {
		method: 'getTxnFraudAlerts',
		alertIDs: alertIDs
	};

	getDataForTxn(event,{
		containerID: 'txnFraudAlerts',
		iconURL: 'analyst/images/fraudTxnInd.gif',
		action: 'getTxnFraudAlerts.action',
		params: txnFraudAlertsParams
	});
}
/**
 * Fetches the rules that fired for the given transaction
 * @param event - native event object
 * @param ruleFiredParams - the list of parameters to pass to find the rules that fired
 */
function getRulesFired(event, ruleFiredParams)
{
	/* add method parameter */
	ruleFiredParams.method = 'getRulesFired';

	getDataForTxn(event,{
		containerID: 'rulesFired',
		iconURL: 'analyst/images/Rules.gif',
		action: 'getRulesFired.action',
		params: ruleFiredParams
	});
}

/**
 * Calls the server using ajax requesting information to be displayed. The event target is expected to
 * be on an img tag using the following html path 'tr/td/a/img'.  Currently, this function was designed to
 * be called from the transaction grids.
 *
 * @param event - the javascript event (jquery Event or native browser event)
 * @param options - a json object containing the following properties:
 * 	<ul>
 * 		<li> containerID - the DOM element ID where the information is inserted
 * 		<li> iconURL - the src URL for the icon to display when the data has finished loading
 * 		<li> action - the form action to post the request to
 * 		<li> params - a json object that contains the key/value parameters to include in the request.
 * 	</ul>
 */
function getDataForTxn(event, options)
{
	var containerID = '#'+options.containerID;
	var iconURL = options.iconURL;
	var action = options.action;
	var params = options.params;

	var $e = $.event.fix(event);
	var $icon = $($e.target);
	var $row = $icon.parent().parent().parent();

	var $container = $(containerID);
	var $prevRow = $container.data('$row');

	// Check if a previous row was selected for the container
	if($prevRow)
	{
		// the same row was clicked so no need to refetch data or
		// adjust position on UI.
		if( $prevRow.is($row) )
		{
			showDataForTxn($container)
			return;
		}

		// close the container
		closeDataForTxn(options.containerID);
	}

	var rowOffset = $row.offset();
	var cellOffset = $icon.parent().parent().offset();
	$container.data('pageX',cellOffset.left + $icon.parent().parent().outerWidth(true) )
		.data('pageY',rowOffset.top + $row.outerHeight(true))
		.data('rowHeight',$row.outerHeight(true))
		.data('$icon',$icon)
		.data('$row',$row)
		.data('iconURL',iconURL);
	var form = new DynaForm('getDataForTxn');
	form.setAction(action)
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(params)
		.setCallback(function(data){loadDataForTxn(containerID, data)})
		.doSubmit();

	$icon.attr('src','common/images/spinner16.gif');
}

/**
 * A ajax callback that appends the HTML data in the container.  This function
 * also tries to fit the container on the screen below or above the transaction affected
 * to reduce scrolling or shifting of the page.
 *
 * The container is expected to have a xxxTitle and xxxTableBody.  The Title has the
 * transaction number inserted into it.  The TableBody has the data parameter appended to it.
 *
 * @param containerID - the jQuery selector for the DOM element ID where the information is inserted
 * @param data - partial HTML to be appended in the container
 */
function loadDataForTxn(containerID, data)
{
	var $container = $(containerID)

	var containers = $(document.body).data('dataForTxnContainerIDs')||{};
	// remove '#' from the containerID.
	containers[containerID.slice(1)] = '1';
	$(document.body).data('dataForTxnContainerIDs', containers);

	var x = $container.data('pageX');
	var y = $container.data('pageY');
	var $row = $container.data('$row');

	// Replace Row Index in Title, default value is 0
	var title = $(containerID+'Title').text();
	title = title.replace(/\d+/,$row.attr('rowIndex'));
	$(containerID+'Title').text(title);

	$(containerID+'TableBody').children().remove();
	$(containerID+'TableBody').append(data);

	showDataForTxn($container)

	var width = $container.outerWidth();
	var height = $container.outerHeight(true);

	x = x - width;
	if(x < 5)
		x = 5;

	if(y + height > $(window).height())
		y = y - height - $container.data('rowHeight');

	x = x - document.body.scrollLeft;
	y = y - document.body.scrollTop;
	$container.css('top',y).css('left',x);

	var $icon = $container.data('$icon');
	var iconURL = $container.data('iconURL');
	$icon.attr('src',iconURL);
}

/**
 * Shows the container and sets some tracking data
 * @param $container
 */
function showDataForTxn($container)
{
	if(!$container.is(':visible'))
	{
		$container.show();
		var $row = $container.data('$row');
		var activeCount = ($row.data('activeCnt.dataForTxn') || 0);
		activeCount += 1;
		$row.data('activeCnt.dataForTxn',activeCount);
		$row.css({'background-color': '#ddddee'});
	}
}


/**
 * Closes the container.  It also resets the background color of the affected txn.
 * @param containerID - the html DOM element ID
 */
function closeDataForTxn(containerID)
{
	var $container = $('#'+containerID);
	if($container.is(':visible'))
	{
		var $row = $container.data('$row');
		var $prevIcon = $container.data('$icon');
		var iconURL = $container.data('iconURL');

		// Reset icon image just in case it didn't fetch the data in time
		$prevIcon.attr('src',iconURL);

		var activeCount = $row.data('activeCnt.dataForTxn') - 1;
		$row.data('activeCnt.dataForTxn',activeCount);

		if($row && !activeCount)
		{
			$row.css({'background-color': ''});
		}
		$container.hide();
	}
}

/**
 * Closes all containers currently open for the given transaction.  This is useful
 * in cases where the transactions grids are reloaded via ajax.
 */
function closeAllDataForTxn()
{
	var containers = $(document.body).data('dataForTxnContainerIDs')||{}
	for(id in containers)
		closeDataForTxn(id);
}

function switchTransactionTimeWindow(acronym, newTimeWindow)
{
	var $table = $('#'+acronym+'Table');
	$table.data('timeWindow', newTimeWindow);

	scrollTransactions(acronym, 0, '');
}


/*****************************************************************************
 * functions and event handlers for Manage Displayed Entity on Analyst Lists *
 *****************************************************************************/

// disable ADD/REMOVE button if no data selected
function handleEntityAnalystListsSelection()
{
	var hasSelection =  $("#entityAnalystLists :checked").length > 0;

	$("#entityAnalystLists input[name='add']").prop("disabled", !hasSelection);    // RAPTOR-2399
	$("#entityAnalystLists input[name='remove']").prop("disabled", !hasSelection); // RAPTOR-2399
}

function getEntityAnalystLists(dataKey)
{
	var entityParams = {};
	entityParams.dataKey=dataKey;
	entityParams.method = "getEntityAnalystLists";

	// submit an ajax form
	var form = new DynaForm('getEntityAnalystLists');
	form.setAction('getEntityAnalystLists.action')
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(entityParams)
		.setCallback(function (data) {loadResultForGetEntityAnalystLists(data)})
		.doSubmit();

	// show op in progress

	var $result = $("#entityAnalystListResult");
	$result.prevAll().remove();
	$result.find("td").html("<img src='common/images/spinner16.gif'/>").show();

	var $popup = $("#entityAnalystLists");
	$popup.find("input[type='button']").hide();
	$popup.find("input[name='cancel']").show();
	$popup.show();
}



/**
 * Displays the results of entity on live analyst list(s).
 * @param data - JSON data returned (hashmap)
 *
 * depends on following arrays from current page
 * var i18nResults =[];
 * var i18nResultMsgs =[];
 * var resultStyles =[];
 */
function loadResultForGetEntityAnalystLists(data)
{
	var $popup = $("#entityAnalystLists");
	var $result = $("#entityAnalystListResult");

	$popup.find("input[type='button']").hide();

	if (data.length)
	{
		// data is a hashmap
		if (data.length > 0)
		{
			$result.find("td").empty().hide();

			for (var i=0; i < data.length; i++ )
			{
				$result.before('<tr class="' + (i%2==0 ? "dataRow1_tableRow" : "dataRow2_tableRow") + '"><td class="textTableCell"><input type="checkbox" name="listIDs"/></td><td class="textTableCell"/><td class="textTableCell"/><td class="textTableCell"/><td class="textTableCell"/></tr>');
				var $cols = $result.prev().children();
				$cols.find(":checkbox").val(data[i].LIST_ID).click(handleEntityAnalystListsSelection);
				$cols.eq(1).text(data[i].LIST_NAME).attr("title", data[i].LIST_DESC);
				if( data[i].CREATE_TIMESTAMP )
				{
					var date = new Date(data[i].CREATE_TIMESTAMP);
					$cols.eq(2).text(DateUtil.formatDateTime(date));
				}
				if( data[i].CREATE_USER )
					$cols.eq(3).text(data[i].CREATE_USER);
			}

			$popup.find("input[name='add']").show().prop("disabled", true);    // RAPTOR-2399
			$popup.find("input[name='remove']").show().prop("disabled", true); // RAPTOR-2399
			$popup.find("input[name='cancel']").show();
		}
		else
		{
			$result.find("td").html($i18n("fcm.alert.noApplicableEntityAnalystLists.txt")).css(resultStyles[0]);
			$popup.find("input[name='cancel']").show();
		}
	}
	else if (data.errMsg)
	{
		$result.find("td").html(data.errMsg).css(resultStyles[1]);
		$popup.find("input[name='close']").show();
	}
}

/**
 * Send the request to the server to ADD or REMOVE selected data from analyst list(s)
 */
function updateEntityAnalystLists(dataKey, updateType)
{
	if ($("#entityAnalystLists :checked").length ==0)
	{
		alert ($i18n("fcm.alert.manageEntityOnAnalystLists.mustSelectList.txt"));
		return;
	}

	var entityParams = {};
	entityParams.dataKey=dataKey;
	entityParams.updateType=updateType;
	entityParams.listIDs="";

	$("#entityAnalystLists :checked").each(function () {
		entityParams.listIDs += $(this).val() + ",";
	});

	/* add method parameter */
	entityParams.method = "updateEntityAnalystLists";

	// submit an ajax form
	var form = new DynaForm('updateEntityAnalystLists');
	form.setAction('updateEntityAnalystLists.action')
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(entityParams)
		.setCallback(function (data) {loadResultForUpdateEntityAnalystLists(data, updateType)})
		.doSubmit();

	// show op in progress

	var $result = $("#entityAnalystListResult");
	$result.find("td").html("<img src='common/images/spinner16.gif'/>").show();

	var $popup = $("#entityAnalystLists");
	$popup.find("input[type='button']").hide();
	$popup.find("input[name='close']").show();
	$popup.show();
}


/**
 * Displays the results of updating analyst list(s) from the transaction.
 * @param data - JSON data returned (AnalystListUpdateStatus)
 *
 * depends on following arrays from current page
 * var i18nResults =[];
 * var i18nResultMsgs =[];
 * var resultStyles =[];
 */
function loadResultForUpdateEntityAnalystLists(data, opType)
{
	var $popup = $("#entityAnalystLists");
	var $result = $("#entityAnalystListResult");

	if (data.length)
	{
		//data is array of AnalystListUpdateStatus
		if (data.length > 0)
		{
			$result.find("td").empty().hide();

			for (var i=0; i < data.length; i++ )
			{
				var returnCode = data[i].returnCode;

				var $row = $("#entityAnalystLists :checkbox[value='" + data[i].listID + "']").parent().parent();
				if (returnCode==0)
				{
					if (opType=="ADD")
					{
						var date = new Date(data[i].updateTimestamp);
						$row.children().eq(2).text(DateUtil.formatDateTime(date)).end().eq(3).text(data[i].updateUser);
					}
					else if (opType=="REMOVE")
					{
						$row.children().eq(2).html("").end().eq(3).html("");
					}
				}
				$row.children().last().html(i18nResults[returnCode]).attr("title", i18nResultMsgs[returnCode]).css(resultStyles[returnCode]);
			}
		}
	}
	else if (data.errMsg)
	{
		$result.find("td").html(data.errMsg).css(resultStyles[1]).show();
	}
}


//DIV popup: drag-and-drop event handlers

function allowDrop(ev) {
    ev.preventDefault();
}
function drag(ev) {
	var offset = $(ev.target).offset();
	var target = ev.target;
	while (target && target.tagName != "DIV")
		target = target.parentElement;
	var data = {"id": target.id, "offsetX": ev.clientX-offset.left, "offsetY": ev.clientY-offset.top }
    ev.dataTransfer.setData("text", JSON.stringify(data));
}

function drop(ev) {
    ev.preventDefault();
    var data = JSON.parse(ev.dataTransfer.getData("text"));
    $("#" + data.id).offset({top:ev.clientY-data.offsetY,left:ev.clientX-data.offsetX});
    ev.dataTransfer.clearData();
}