(function($){

DataPop = function(i18nConfig){
//	var _i18nConfig = i18nConfig||{errLabel:"ERROR",errMessage:"Unable to load data"};
	var _i18nConfig = i18nConfig||{errLabelKey:"fcm.datapop.default.error.label.txt",errMessageKey:"fcm.datapop.default.error.message.txt"};

	var _handleInternalResponse;
	var window = this;
	// assoc. array to store data pop values
	var _dpCache = {};
	// assoc. array to store data pop values for codes that have a parent
	var _dpPVCache = {};
	// holds datapop info by table id
	var _divID = "dataPopDiv";

	var _contents = ['<div id="'+_divID+'" style="display:none">',
	                 '<div class="dataPopDivTop"><span></span></div>',
	                 '<div class="dataPopDivMiddle"><span id="dataPopTitle"></span><br/><span id="dataPopSpan"></span></div>',
	                 '<div class="dataPopDivBottom"></div>',
	                 '</div>'].join('');

	$(document).ready(function(){
		$(document.body).append(_contents);
		$dpContainer = $("#"+_divID);
		$(document).mousedown(function(){$dpContainer.hide()});
	});

	var handleDataPop = function(e){
		var tgtElem = e.target;
		var $tgt = $(tgtElem);
		if($tgt.is(".data-pop-cell:not(:empty)"))
		{
			e.stopPropagation();
			var dataPopInfo = $(this).data("txnTableDataPops");
			var dpi = dataPopInfo[tgtElem.cellIndex]
			if(dpi)
			{
				dpi.code = $.trim($tgt.text());
				dpi.parentCode = null;
				if(dpi.pVarIndex)
					dpi.parentCode = $.trim($tgt.parent().find("td[dpIdxCol='true']:eq("+dpi.pVarIndex+")").text());

				loadDataPop(dpi, getOffset($(this).parent(),$tgt));
			}
		}
	};

	var getOffset = function(container,cell){
		var offset = cell.offset();
		var y = (offset.top - document.body.scrollTop);
		var x = (offset.left + cell.width()/2 - 100 - document.body.scrollLeft);
		return {top:y, left:x};
	};

	var loadDataPop = function(dpi, offset){
		$('#dataPopTitle').text(dpi.label+": "+ dpi.code);
		var desc;

		if(dpi.parentCode != null) // parent variable
		{
			desc = _dpPVCache[dpi.variable + ":" + $.trim(dpi.parentCode) + "~" + $.trim(dpi.code)];
		}
		else  // no dependency on a parent variable
		{
			desc = _dpCache[dpi.variable + ':' + $.trim(dpi.code)];
		}

		if (desc)
		{
			showDataPop(dpi, offset, desc);
		}
		else
		{
			_handleInternalResponse = function(data){showDataPop(dpi,offset,data.desc,data.errMsg);};
			remoteGet(dpi.variable, dpi.parentCode, dpi.code);
		}
	};

	var showDataPop = function(dpi, offset, desc, errMsg){

		window.status = '';
		// avoid going back to server if we don't have a value
		if (!desc)
			desc = $i18n("fcm.datapop.dataUndefined.txt");

		if (dpi.parentCode)
			_dpPVCache[dpi.variable + ':' + $.trim(dpi.parentCode) + '~' + $.trim(dpi.code)] = desc;
		else
			_dpCache[dpi.variable + ':' + $.trim(dpi.code)] = desc;

		if (errMsg)
		{
			$('#dataPopTitle').text(_i18nConfig.errLabelKey ? $i18n(_i18nConfig.errLabelKey) : _i18nConfig.errLabel);
			$('#dataPopSpan').text( errMsg );
		}
		else
			$('#dataPopSpan').text(desc);

		$dpContainer.show();

		$dpContainer.css('left',offset.left);
		$dpContainer.css('top',offset.top - $dpContainer.height() + 7);


	};

	var remoteGet = function(variable, parentCode, code){

		$dpContainer.hide();

		var url = "getCodeDescription.action";
		var params = {method:'getCodeDescription', type:variable, code:code};

		if (variable == 'rrr_action_info')
		{
			if (typeof _cardOrg !== 'undefined' && _cardOrg == '100')
				parentCode = '100';
			else
				parentCode = 'not_100';
		}

		if (parentCode)
			params["parentCode"] = parentCode;

		var i18nErrMsg = _i18nConfig.errMessageKey ? $i18n(_i18nConfig.errMessageKey) : _i18nConfig.errMessage;

		$.ajax({
			async:true,
			type: "POST",
			url: url,
			data: params,
			dataType: "json",
			success: _handleInternalResponse,
			error: function(){_handleInternalResponse({desc:'', errMsg: i18nErrMsg})}
		});


	};

	this.setDataPopsByTable = function($tables){
		this.reset($tables);
		$tables.bind('mousedown',handleDataPop);
	};

	this.reset = function($tables){
		$tables.unbind('mousedown');
	};
}
})(jQuery);