/*if (!window.name.match('FCMPopupWin.*') && window.name!=='FCMAlertDetailView' && window.name!=='FCMPopoutWin')
{
	location.href="analystIntro.sj";
}*/

var disabledTabActions = {};

function disableTab(tabName)
{
	var $tab = $("#" + tabName + "Tab");
	$tab.addClass('disabled');
	var $aTag  = $tab.find("A");
	$aTag.prop("disabled", true); // RAPTOR-2399

	var tab = document.getElementById(tabName + 'Tab');
	var aTag  = tab.getElementsByTagName("A")[0];
	disabledTabActions[tabName] = aTag.onmousedown;
	aTag.onmousedown=alwaysReturnFalse;
}

// TODO: remove
function enableTab(tabName)
{
	var $tab = $("#" + tabName + "Tab");
	$tab.removeClass('disabled');
	var $aTag  = $tab.find("A");
	$aTag.prop("disabled", false); // RAPTOR-2399

	var tab = document.getElementById(tabName + 'Tab');
	var aTag  = tab.getElementsByTagName("A")[0];
	if (disabledTabActions[tabName]) {
		aTag.onmousedown=disabledTabActions[tabName];
		delete disabledTabActions[tabName];
	}
}

function openMapWin()
{
	w=screen.availWidth;
	h=screen.availHeight;
	l=(w-880)/2;
	t=((h-587)/2)-24;

	mapWin=window.open("viewMaps.action?method=viewMaps","mapWin",
				"height=545,width=820,status=no,toolbar=no,menubar=no,location=no,titlebar=no,scrollbars=yes,resizable=yes,top="+t+",left="+l);
	mapWin.focus();
}

function updateViewState(props)
{
	if(!props) return;

	var viewState =  getViewState();

	$(document.body).data('viewState', $.extend(viewState,props));
}

function getViewState()
{
	return $(document.body).data('viewState') || {
		keepSearchResults: 'false',
		relatedToAlert: '',
		relatedToEntityObj: {}
	};
}

function getSearchParam()
{
		var searchParam = '';
		var keepSearchResults = getViewState().keepSearchResults;
		if(isDefined(keepSearchResults) && keepSearchResults == 'true')
		{
			searchParam  = '&keepSearchResults=true';
		}
		return searchParam;

}

function revealSensitiveData()
{
	setBusy('mainDiv');
	location.href="viewAnalystMain.action?mask=false" + getSearchParam();
}

function viewEntity(entityObj, mask)
{
	setBusy('mainDiv');

	var viewState = getViewState();

	var form = new DynaForm('viewEntityForm');
	form.setAction('viewEntity.action')
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParam('method','view')
		.setParam('keepSearchResults',viewState.keepSearchResults)
		.setParam('relatedToAlert',viewState.relatedToAlert)
		.setParam('mask', mask)
		.setParams(viewState.relatedToEntityObj)
		.setParams(entityObj)
		.doSubmit();
}

function viewAlert(alertID, mask)
{
	setBusy('mainDiv');

	var viewState = getViewState();

	var form = new DynaForm('viewAlertForm');
	form.setAction('viewAlert.action')
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParam('method','view')
		.setParam('alert',alertID)
		.setParam('keepSearchResults',viewState.keepSearchResults)
		.setParam('relatedToAlert',viewState.relatedToAlert)
		.setParam('mask', mask)
		.setParams(viewState.relatedToEntityObj)
		.doSubmit();
}

function modifyAlert(alertID, version) {

	if ((alertID!=null) && (alertID!=''))
	{
		setBusy('mainDiv');
		var action = "modifyAlert.action?__sfmrt=" + getCookie("__sfmrt") + "&method=modify&alert="+alertID+"&version="+version + getSearchParam();
		$df.postURL(action);
	}
}

function createManual(form)
{
	var inputs = $(form).find(":input") // form inputs
						.not("input[name='acct']") // minus the non-essential
						.not("input[name='alertReason']")
						.filter(function(){
							// RAPTOR-2399
							return ($(this).val() === ''); // find missing values of required fields
						});
	// RAPTOR-2399
	if(inputs.length == 0) // all required input has values
	{
		if(confirm($i18n("fcm.alert.js.createManual.confirm.txt")))
		{
			setBusy('mainDiv');
			form.submit();
		}
	}
	else // missing required parameters
	{
		alert($i18n("fcm.alert.js.createManual.missing.required.fields.txt"));
	}
}

function forceCheckout(alertID, version) {
	if ((alertID!=null) && (alertID!=''))
	{
		if(confirm($i18n("fcm.alert.js.forceCheckout.confirm0.txt")))
		{
			setBusy('mainDiv');
			var action = "checkoutAlert.action?__sfmrt=" + getCookie("__sfmrt") + "&method=checkout&force=true&alert="+alertID+"&version="+version + getSearchParam();
			$df.postURL(action);
		}
	}
}
function checkout(alertID, version){
	if ((alertID!=null) && (alertID!=''))
	{
		setBusy('mainDiv');
		var action="checkoutAlert.action?__sfmrt=" + getCookie("__sfmrt") + "&method=checkout&force=false&alert="+alertID+"&version="+version + getSearchParam();
		$df.postURL(action);
	}
}


function reloadEntity(alertID, version, mask){

	setBusy('mainDiv');

	var viewState = getViewState();

	var form = new DynaForm('reloadEntity');
	form.setAction('reloadEntity.action')
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParam('method','reloadEntity')
		.setParam('alert',alertID)
		.setParam('version',version)
		.setParam('keepSearchResults',viewState.keepSearchResults)
		.setParam('relatedToAlert',viewState.relatedToAlert)
		.setParam('mask',mask)
		.setParams(viewState.relatedToEntityObj)
		.doSubmit();
}


function goToMain() {

	location.href="viewAnalystMain.action?" + getSearchParam();
}

function copyToClipboard(txt)
{
	function handler (event){
        event.clipboardData.setData('text/plain', txt);
        event.preventDefault();
		window.status = $i18n("fcm.alert.js.number.copied.clipboard.txt");
        document.removeEventListener('copy', handler, true);
    }
    document.addEventListener('copy', handler, true);
    document.execCommand('copy');
}

function trim(txt)
{
	if (txt)
		return txt.replace(/^\s+/g, '').replace(/\s+$/g, '');
	else
		return "";
}

var fcmExpireWin;

function gotoExpireWin()
{
if (fcmExpireWin)
{
	if (!fcmExpireWin.closed)
		fcmExpireWin.focus();
	else
		window.top.onfocus = "";
}
return false;
}

function isEmpty(fieldvalue)
{
	var re = /\s/g; //Match any white space including space, tab, form-feed, etc.
	RegExp.multiline = true; // IE support
	var str = fieldvalue.replace(re, "");
	if (str.length == 0)
	{
		return true;
	}
	else
	{
		return false;
	}
}

 function pauseStats(alertId)
 {
   var lnk= "pauseAlert.action?__sfmrt=" + getCookie("__sfmrt") + "&method=pause";
	if(isDefined(alertId) && alertId != '')
	{
		lnk = lnk + "&alert="+ escape(alertId) ;
	}
	$df.postURL(lnk);
 }

function unpauseStats()
{
	 setBusy('msg');
	 document.unpauseStatsForm.submit();
}

function addZero(num)
{
	 var numStr = "" + num;
	 if (numStr.length < 2)
		 numStr = "0" + num;
	 return numStr;
}

function WorkList(action,entityObj,memberName,memberHomePhone,addressLine1,cityName,stateProvinceName,postalCode,country,alertId,alertStatus,checkoutUser,suspendUser,alertVersion,lastCallResultId,strategy,queue)
{

	if (action=='ADD')
	{
//		if(isDefined(entityObj) && isDefined(entityObj.entityID) && entityObj.entityID != '')
		{
		  	if(confirm($i18n("fcm.alert.js.workList.confirm0.txt")))
		  	{
		  		var form = new DynaForm('addToWorkList');
		  		form.setAction('addToWorkList.action')
		  			.setEnableAjax(true)
					.setParam('method','addToWorkList')
					.setParam('memberName',memberName)
					.setParam('memberHomePhone',memberHomePhone)
					.setParam('addressLine1',addressLine1)
					.setParam('cityName',cityName)
					.setParam('stateProvinceName',stateProvinceName)
					.setParam('postalCode',postalCode)
					.setParam('country',country)
					.setParam('alertId',alertId)
					.setParam('alertStatus',alertStatus)
					.setParam('checkoutUser',checkoutUser)
					.setParam('suspendUser',suspendUser)
					.setParam('alertVersion',alertVersion)
					.setParam('lastCallResultId',lastCallResultId)
					.setParam('strategy',strategy)
					.setParam('queue',queue)
					.setParam('__sfmrt',getCookie("__sfmrt"))
					.setParams(entityObj)
					.doSubmit();
		  	}
		}
//		else {
//			alert($i18n("fcm.alert.js.workList.alert0.txt"));
//		}
	}
	else if (action=='REMOVE')
	{
//		if(isDefined(entityObj) && isDefined(entityObj.entityID) && entityObj.entityID != '')
		{
		  	if(confirm($i18n("fcm.alert.js.workList.confirm1.fmt.txt",[trim(entityObj.entityID)])))
		  	{
		  		setBusy('mainDiv');
		  		var form = new DynaForm('removeFromWorkList');
		  		form.setAction('removeFromWorkList.action')
					.setParam('method','removeFromWorkList')
					.setParam('__sfmrt',getCookie("__sfmrt"))
					.setParams(entityObj)
					.doSubmit();
		  	}
		}
//		else {
//			alert($i18n("fcm.alert.js.workList.alert1.txt"));
//		}
	}
}

function createCalDiv(suffix)
{
	$(document.body).append('<div id="calDiv'+ suffix + '" style="position:absolute;visibility:hidden;background-color:white;z-index:99"></div>');
}

function initCalendars()
{
	var days = 0;
	var rescheduleCalendarDays = $("#calAnchor1").attr("data");

	if ( parseInt(rescheduleCalendarDays) > 0 )
		days = parseInt(rescheduleCalendarDays);

	var d;
	var selectedDate;
	// Verify DOB 1
	// Reschedule datetime
	if($("#calAnchor1").length == 1) // RAPTOR-2399
	{
		var cal1 = CalendarTime.newPopup("1",true,false);
		cal1.setCssPrefix("FCM");
		d = new Date();
		d.setDate(d.getDate() - 1);
		cal1.addDisabledDates(null,DateUtil.formatDate(d));
		selectedDate = new Date();
		selectedDate.setDate(selectedDate.getDate()+days);
		selectedDate.setMinutes(0);
		selectedDate.setSeconds(0);
		cal1.setSelectedDate(selectedDate);
		$("#calAnchor1").click(function(){cal1.open();});
	}
	// Reroute datetime
	if($("#calAnchor2").length == 1) // RAPTOR-2399
	{
		var cal2 = CalendarTime.newPopup("2",true,false);
		cal2.setCssPrefix("FCM");
		d = new Date();
		d.setDate(d.getDate() - 1);
		cal2.addDisabledDates(null,DateUtil.formatDate(d));
		selectedDate = new Date();
		selectedDate.setDate(selectedDate.getDate()+days);
		selectedDate.setMinutes(0);
		selectedDate.setSeconds(0);
		cal2.setSelectedDate(selectedDate);
		$("#calAnchor2").click(function(){cal2.open()});
	}

	// System block datetime
	if($("#calAnchor3").length == 1) // RAPTOR-2399
	{
		var maxDays = parseInt($("#calAnchor3").attr("data"));

		var cal3 = CalendarTime.newPopup("3",true,false);
		cal3.setCssPrefix("FCM");
		d = new Date();
		d.setDate(d.getDate() - 1);
		cal3.addDisabledDates(null,DateUtil.formatDate(d));
		d = new Date();
		d.setDate(d.getDate() + maxDays + 1);  // disable dates after max
		cal3.addDisabledDates(DateUtil.formatDate(d), null);
		$("#calAnchor3").click(function(){cal3.open()});
	}

	// Transaction block datetime
	if($("#calAnchor4").length == 1) // RAPTOR-2399
	{
		var maxDays = parseInt($("#calAnchor4").attr("data"));

		var cal4 = CalendarTime.newPopup("4",true,false);
		cal4.setCssPrefix("FCM");
		d = new Date();
		d.setDate(d.getDate() - 1);
		cal4.addDisabledDates(null,DateUtil.formatDate(d));
		d = new Date();
		d.setDate(d.getDate() + maxDays + 1);  // disable dates after max
		cal4.addDisabledDates(DateUtil.formatDate(d), null);
		$("#calAnchor4").click(function(){cal4.open()});
	}

	// Fulfillment transaction start date
	if($("#calAnchor5").length == 1) // RAPTOR-2399
	{
		createCalDiv("5");
		var cal5 = CalendarTime.newPopup("5",false,true);
		cal5.setCssPrefix("FCM");
		d = new Date();
		d.setDate(d.getDate()+1);
		cal5.addDisabledDates(DateUtil.formatDate(d), null);
		$("#calAnchor5").click(function(){cal5.open();
			if (document.body.scrollTop) calDiv5.style.top=parseInt(calDiv5.style.top)+document.body.scrollTop+"px";
			if (document.body.scrollLeft) calDiv5.style.left=parseInt(calDiv5.style.left)+document.body.scrollLeft+"px";
		});
	}

	// Fulfillment transaction end date
	if($("#calAnchor6").length == 1) // RAPTOR-2399
	{
		createCalDiv("6");
		var cal6 = CalendarTime.newPopup("6",false,true);
		cal6.setCssPrefix("FCM");
		d = new Date();
		d.setDate(d.getDate()+1);
		cal6.addDisabledDates(DateUtil.formatDate(d), null);
		$("#calAnchor6").click(function(){cal6.open();
			if (document.body.scrollTop) calDiv6.style.top=parseInt(calDiv6.style.top)+document.body.scrollTop+"px";
			if (document.body.scrollLeft) calDiv6.style.left=parseInt(calDiv6.style.left)+document.body.scrollLeft+"px";
		});
	}
}

function initAlertActivityQueueDisplay()
{
	var $targets = $('#alertActivityTable img.queueMovementImage');
	if($targets.length > 0)
	{
		$('#alertActivityTable img.queueMovementImageSpacer').show();
		var $content = $('#alertActivityQueueContent');

		if($content.length == 0)// create it
		{
			$(document.body).append('<div id="alertActivityQueueContent"/>');
			$content = $('#alertActivityQueueContent');
		}

		var params = {
			$obj: $content,
			delay: 2000,
			callee: fadeOutAlertActivityQueue
		};

		// Auto hide it
		$content.bind('mouseleave',params,hideAlertActivityQueue);
		$content.bind('mouseenter',params,cancelHideAlertActivityQueue);

		$targets.bind('mouseleave',params,hideAlertActivityQueue);
		$targets.bind('mouseenter',params,cancelHideAlertActivityQueue);
	}
}
// function is bound in JSP because text parameter is known at time of rendering
function showAlertActivityQueue(event,text)
{
	var $e = $.event.fix(event);
	$e.stopPropagation();

	var $target = $($e.target);
	var tgtOffset = $target.offset();
	var offset = {top: tgtOffset.top, left:(tgtOffset.left + $target.width())};
	var $content = $('#alertActivityQueueContent');

	if($content.data.timeout)
		clearTimeout($content.data.timeout);

	$content.text(text).css(offset).show();
}

function hideAlertActivityQueue(e)
{
	var $obj = e.data.$obj;
	var delay = e.data.delay;
//S1403028	var f = e.data.callee;
	$obj.data.timeout = setTimeout(fadeOutAlertActivityQueue,delay)
}

function cancelHideAlertActivityQueue(e)
{
	if(e.data.$obj)
	{
		var $obj = e.data.$obj;
		clearTimeout($obj.data.timeout);
	}
}

function fadeOutAlertActivityQueue()
{
	$('#alertActivityQueueContent').fadeOut();
}

function directOutbound(strategy)
{
	var $form = $('form[name="directServicingForm"]');
	$form.find('input:hidden[name="strategy"]').val(strategy); // RAPTOR-2399
	setBusy('mainDiv');
	$form.submit();
}
function priorityOutbound()
{
	setBusy('mainDiv');
	document.priorityServicingForm.submit();
}

//"Freeze" the table headers so that they are always visible
function repositionTHs(elem) {
	$(elem).find("th").css("top", elem.scrollTop + "px");
}

/**
 * Display the transaction menu for transaction based actions
 *
 * @param txnID1
 * @prarm txnAcronym1
 * @param tableName
 *
 * Transaction based actions rely on following variable on current page
 * var $row=null;
 * var txnID, txnAcronym;
 * var offset = null;
 */

function showTxnMenu (event, txnID1, txnAcronym1, tableName)
{
	if ($("#txnMenu").css("display") != "none")
	{
		$("#txnMenu").hide();
		return;
	}

	var $e = $.event.fix(event);
	$row = $($e.target).parent().parent();
	txnID = txnID1;
	txnAcronym = txnAcronym1;

	var $table = $("#"+tableName);

	if ($table.data('hasAnalystLists'))
	{
		$("#txnMenuAddDataToLists").show();
		$("#txnMenuRemoveDataFromLists").show();
	}
	else
	{
		$("#txnMenuAddDataToLists").hide();
		$("#txnMenuRemoveDataFromLists").hide();
	}

	offset = $row.offset();
	offset.top += $row.height(); // show div right below the transaction row
	offset.top = offset.top - document.body.scrollTop - 30;
	offset.left = offset.left - document.body.scrollLeft + 20;

	$("#txnMenu").css(offset).show();
}


/**
 * Shows the div that prompts the user for the alert type to create on the given transaction.
 */
function showAlertTypeSelection()
{
	$("#txnMenu").hide();

	$('#alertTypePromptFromTransactionsContinue').show();
	$('#alertTypePromptFromTransactionsSpinner').hide();

	// Get supported alert types for the given transaction
	var alertTypeArray = $('#'+txnAcronym+'Grid').attr('supportedAlertTypes').split(' ');

	// Get the user's alert types
	var $userAlertTypeOptions = $('#userAlertTypes').find('option');
	var filterExpr = "";
	// keep user alert types that match the transaction's
	$.each(alertTypeArray, function(index,value){
		filterExpr += '[value="'+value+'"],';
	});

	// apply filter
	// RAPTOR-2399
	$userAlertTypeOptions = $userAlertTypeOptions
		.filter(function () {
			return alertTypeArray.indexOf($(this).val()) !== -1;
		} )
		.clone();

	// alert user that he is not allowed to create alerts on this transaction
	if($userAlertTypeOptions.length === 0){ // RAPTOR-2399
		alert($i18n("fcm.alert.createAlertOnTransactionNoType.txt"));
		return;
	}

	// remove options and add the filtered user alert type options
	$('#alertTypePromptFromTransactionsSelect').children().remove()
		.addBack().append($userAlertTypeOptions); // RAPTOR-2399

	//clear alert reason
	$('#alertTypePromptFromTransactions').find("input[name='alertReason']").val("");

	// update the label with the transaction #
	var label = $('#alertTypePromptFromTransactionsLabel').text();
	label = label.replace(/\d+/, $row.children().first().text());
	$('#alertTypePromptFromTransactionsLabel').text(label);

	// Show the div
	$('#alertTypePromptFromTransactions').css(offset).show();

	// Add a mousedown event to the "Continue" button
	// Remove the old one if it hasn't been used.
	$('#alertTypePromptFromTransactionsContinue').unbind('mousedown').one('mousedown', function(){
		// show spinner so that user knows work is being done
		$('#alertTypePromptFromTransactionsContinue').hide();
		$('#alertTypePromptFromTransactionsSpinner').show();

		// Get the alert type selected by the user
		var alertTypeSelected = $('#alertTypePromptFromTransactionsSelect').find(":selected").val();
		var alertReason = $('#alertTypePromptFromTransactions').find("input[name='alertReason']").val();
		createAlertFromTransaction(txnID, txnAcronym, alertTypeSelected, alertReason, offset);
	});
}

/**
 * Send the request to the server to create or fetch the alert type selected
 * based on the transaction alert key field values.
 *
 * @param txnID - the transaction ID
 * @param txnAcronym - the transaction acronym
 * @param alertType - the alert type to create on the transaction
 * @param offset - the position to display the result div
 */
function createAlertFromTransaction(txnID, txnAcronym, alertType, alertReason, offset)
{
	// find source alert ID and version
	var sourceAlert = {
			sourceAlertID : $(':hidden[name="alertID"]').val(),
			sourceAlertVersion : $(':hidden[name="alertVersion"]').val()
	};
	// create/get alert
	var form = new DynaForm('createAlertFromTransaction');
	form.setAction('createAlertFromTransaction.action')
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParam('method','createAlertFromTransaction')
		.setParam('txnAcronym',txnAcronym)
		.setParam('txnID',txnID)
		.setParam('alertType',alertType)
		.setParam('alertReason', alertReason)
		.setParams(sourceAlert)
		.setEnableAjax(true)
		.setCallback(function(data){
			createAlertFromTransactionResult(data,offset)
		})
		.doSubmit();
}

/**
 * Displays the results of creating the alert from the transaction.
 * @param data - JSON data returned
 * @param offset - position to display the result
 *
 * It depends on following variables from current page
 * var currAlert = {};
 */
function createAlertFromTransactionResult(data, offset)
{
	// hide the prompt and spinner for future usage
	$('#alertTypePromptFromTransactions, #alertTypePromptFromTransactionsSpinner').hide();

	// empty result from previous calls
	var $result = $('#alertCreatedPromptFromTransactionsResult').empty();
	var $actions = $('#alertCreatedPromptFromTransactionsResultActions li').css("display", "none");

	// if alert data returned, no exceptions occured
	if(data.alertID)
	{
		$result.append(data.displayType).append(" : ").append(data.alertValue).append(" : ").append(data.displayStatus);

		// this is current alert
		if (currAlert.alertID == data.alertID)
		{
			$actions.filter("[name='isCurrentAlert']").css("display", "");
		}
		// this alert is already in entity navigation list
		else if ($("#entitiesGrid tr[alertID='"+ data.alertID +"']").length > 0)
		{
			$actions.filter("[name='openAlert']").css("display", "").one("click", data, function(event){
				$("#entitiesGrid tr[alertID='"+ event.data.alertID +"']").find("a").first().click();
			});
		}
		// this is a new alert
		else
		{
			// this alert has same contact as current alert
			if (data.isSameContact)
			{
				if ( data.checkoutUser || data.suspendUser )
				{
					$actions.filter("[name='openAlert']").css("display", "").one("click", data, function(event){
						viewAlert(event.data.alertID);
					});
				}
				else
				{
					$actions.filter("[name='openAlert']").css("display", "").one("click", data, function(event){
						checkout(event.data.alertID);
					});
				}

				$actions.filter("[name='addToCurrentList']").css("display", "");
			}

			// this alert has a different contact
			else
			{
				if ( !data.isCheckoutAvailable || data.checkoutUser || data.suspendUser )
				{
					$actions.filter("[name='goToAlert']").css("display", "").one("click", data, function(event){
						viewAlert(event.data.alertID);
					});
				}
				else
				{
					$actions.filter("[name='goToAlert']").css("display", "").one("click", data, function(event){
						checkout(event.data.alertID);
					});
				}

				$actions.filter("[name='addToWorkList']").css("display", "").one("click", data, function(event){
					var data = event.data;
					$('#alertCreatedPromptFromTransactions').hide();
					WorkList('ADD',data.entityObj,'','','','','','','',data.alertID,data.alertStatus,data.checkoutUser,data.suspendUser,data.alertVersion,data.lastCallResultId,data.strategy,data.queue);
				});
			}
		}
	}
	else // must be an error
	{
		$('#alertCreatedPromptFromTransactionsResult').append(data.errMsg);
	}

	// display the result
	$('#alertCreatedPromptFromTransactions').css(offset).show();
}

/*
 * Shows the div that prompts the user for analyst list update from given transaction.
 *
 * @param updateType - specify the type of update: ADD | REMOVE
 */
function showAnalystListItems(updateType)
{
	$("#txnMenu").hide();
	if (updateType=="ADD")
	{
		$("#tranAnalystListTitleRemove").hide();
		$("#tranAnalystListTitleAdd").show();
	}
	else if (updateType=="REMOVE")
	{
		$("#tranAnalystListTitleAdd").hide();
		$("#tranAnalystListTitleRemove").show();
	}
	// invalid option, do nothing
	else return;

	$("#tranAnalystListField,#tranAnalystListValue,#tranAnalystListResult").empty();

	$("#tranAnalystListField").append($row.parent().parent().find("th[hotlist]").clone());

	$("#tranAnalystListValue").append($row.find("td[hotlist]").clone().css("background-color", "white").each(function () {
		if ( !isEmpty($(this).html()) ) $(this).prepend(" <input name='listIDs' type='checkbox' onclick='handleDataSelection();' checked/> "); })
	);

	$("#tranAnalystList input[name='txnAcronym']").val(txnAcronym);
	$("#tranAnalystList input[name='tranID']").val(txnID);
	$("#tranAnalystList input[name='updateType']").val(updateType);

	$("#tranAnalystList input[name='ok']").show();
	$("#tranAnalystList input[name='cancel']").show();
	$("#tranAnalystList input[name='close']").hide();

	$("#tranAnalystList").css(offset).show();
}

// disable OK button if no data selected
function handleDataSelection()
{
	var hasSelection =  $("#tranAnalystList :checked").length > 0;

	$("#tranAnalystList input[name='ok']").prop("disabled", !hasSelection); // RAPTOR-2399
}

/**
 * Send the request to the server to ADD or REMOVE selected data from analyst list(s)
 */
function updateAnalystLists()
{
	var tranParams = {};
	tranParams.txnAcronym=$("#tranAnalystList input[name='txnAcronym']").val();
	tranParams.tranID=$("#tranAnalystList input[name='tranID']").val();
	tranParams.updateType=$("#tranAnalystList input[name='updateType']").val();
	tranParams.listIDs="";

	$("#tranAnalystList input[name='listIDs']").each(function () {
		if ( $(this).prop("checked") == true )
			tranParams.listIDs += $(this).parent().attr("hotlist") + ",";
	});

	if (isEmpty(tranParams.listIDs))
	{
		alert ($i18n("fcm.alert.tran.updateAnalystList.mustSelectData.txt"));
		return;
	}

	/* add method parameter */
	tranParams.method = 'updateAnalystLists';

	// submit an ajax form
	var form = new DynaForm('getDataForAlert');
	form.setAction('updateAnalystLists.action')
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(tranParams)
		.setCallback(function (data) {loadDataForUpdateAnalystLists(data)})
		.doSubmit();

	// show op in progress
	var n = $row.find("td[hotlist]").length;
	$("#tranAnalystListResult").append("<td align='center' colspan='" + n + "'><img src='common/images/spinner16.gif'/></td>");

	$("#tranAnalystList input[name='ok']").hide();
	$("#tranAnalystList input[name='cancel']").hide();
	$("#tranAnalystList input[name='close']").show();
}


/**
 * Displays the results of updating analyst list(s) from the transaction.
 * @param data - JSON data returned
 *
 * depends on following arrays from current page
 * var i18nResults =[];
 * var i18nResultMsgs =[];
 * var resultStyles =[];
 */
function loadDataForUpdateAnalystLists(data)
{
	if (data.length && data.length > 0)
	{
		$("#tranAnalystListResult").empty();
		$("#tranAnalystListResult").append($row.find("td[hotlist]").clone().empty());
		for (var i=0; i < data.length; i++ )
		{
			var returnCode = data[i].returnCode;
			$("#tranAnalystListResult > td[hotlist='" + data[i].listID + "']").html(i18nResults[returnCode]).attr("title", i18nResultMsgs[returnCode]).css(resultStyles[returnCode]);
			if ( returnCode == 0 )
			{
				var compositeValue= $("#tranAnalystListValue > td[hotlist='" + data[i].listID + "'] > img[name='compositeValue']").data("composite-value");
				var weight = ($("#tranAnalystList input[name='updateType']").val() == "ADD") ? "bold" : "normal";
				$("#entityTransactionsContainer").find("td[hotlist='" + data[i].listID + "'] > img[name='compositeValue']").each(function (){
					if ($(this).data("composite-value") == compositeValue)
						$(this).parent().css("font-weight", weight);
				});
			}
		}
	}
	else if (data.errMsg)
	{
		$("#tranAnalystListResult > td").html(data.errMsg).css(resultStyles[1]);
	}
}
 
function getDataForAlert (event, options, callbackHandler)
{
	var containerID = options.containerID;
	var action = options.action;
	var params = options.params;

	var $e = $.event.fix(event);
	var $icon = $($e.target);
	var $cell = $icon.parent();
//	var $cell = $icon.parent().parent();

	$container = $(containerID);
	// store info for later user
	var cellOffset = $cell.offset();
	$container.data('pageX',cellOffset.left)
		.data('pageY',cellOffset.top )
		.data('$icon',$icon)
		.data('$cell',$cell)
		.data('iconURL',$icon.attr('src'));

	// submit an ajax form
	var form = new DynaForm('getDataForAlert');
	form.setAction(action)
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(params)
		.setCallback(callbackHandler)
		.doSubmit();

	// show op in progress
	$icon.attr('src','common/images/spinner16.gif');
}


/**
 * instant save of transaction CF marking/un-marking
 */
function getDataForTransMarking (event, options, callbackHandler)
{
	var containerID = options.containerID;
	var action = options.action;
	var params = options.params;

	// show op in progress
	var $e = $.event.fix(event);
	var $cell = $($e.target).parent();

	$container = $(containerID);
	var cellOffset = $cell.offset();

	var x = cellOffset.left;
	var y = cellOffset.top;

	x = x - document.body.scrollLeft;
	y = y - document.body.scrollTop;
	$container.css('top',y).css('left',x);
	$container.html("<img src='common/images/spinner16.gif'>").show();

	// submit an ajax form
	var form = new DynaForm('getDataForAlert');
	form.setAction(action)
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(params)
		.setCallback(callbackHandler)
		.doSubmit();
}


// clicked single CF checkbox
function markTransaction(chkbox, acronymName) {

	//id=[ALL|ONE]_ACRONYM_TRANID_TRANTIME
	var id = chkbox.id;
	var params = id.split("_");

	saveAnalystMarking(event, id, acronymName, {acronym: params[1], tranID: params[2], tranTime: params[3], fraudMarking: chkbox.checked});
}


function saveAnalystMarking(event, id, acronymName, tranParams)
{
	/* add method parameter */
	tranParams.method = 'saveAnalystMarking';

	getDataForTransMarking(event, {
		containerID: '#alertData',
		action: 'saveAnalystMarking.action',
		params: tranParams
		},
		function (data) {loadDataForAnalystMarking(id, acronymName, data)}
	);
}

function loadDataForAnalystMarking(id, acronymName, data)
{
	if (data.errMsg)
	{
		// failed, reverse the checkbox checked state

		var $chkbox = $("#" + id);
		$chkbox[0].checked = !$chkbox[0].checked;

		$("#alertData").html("<img src='common/images/closeX.gif'> " + data.errMsg).show();
	}
	else
	{
		$("#alertData").hide();

		//update corresponding checkbox in ALL or Acronym tab if exists
		checkOtherCF (id, $("#" + id)[0].checked);
	}

	switchMarkAllLink(acronymName);
}


// clicked the Mark All link
function markAllTransactions(link, acronymName, marking) {
	var chkboxIDs = [];
	var tranIDs = [];
	var $chkboxes = $("#"+acronymName+"Table").find(":checkbox").each(function (){
		if ($(this).prop("checked") != marking)
		{
			//id=[ALL|ONE]_ACRONYM_TRANID
			chkboxIDs.push($(this).attr("id"));
			tranIDs.push($(this).attr("id").substring(4));
		}
	});

	// checkboxes will be marked accordingly if succeeded
	if (chkboxIDs.length > 0)
		saveAnalystMarkings(event, chkboxIDs, acronymName, marking, {tranIDs: tranIDs.join(","), fraudMarking: marking});
	else
		switchMarkAllLink(acronymName);
}


function saveAnalystMarkings(event, ids, acronymName, marking, tranParams)
{
	/* add method parameter */
	tranParams.method = 'saveAnalystMarkings';

	getDataForTransMarking(event, {
		containerID: '#alertData',
		action: 'saveAnalystMarkings.action',
		params: tranParams
		},
		function (data) {loadDataForAnalystMarkings(ids, acronymName, marking, data)}
	);

	hideMarkAllLinks(acronymName)
}

function loadDataForAnalystMarkings(ids, acronymName, marking, data)
{
	if (data.errMsg)
	{
		 $("#alertData").html("<img src='common/images/closeX.gif'> " + data.errMsg).show();
	}
	else
	{
		$("#alertData").hide();

		// mark checkboxes accordingly
		for (var i =0; i < ids.length; i++ )
		{
			var $chkbox = $("#" + ids[i]);
			$chkbox[0].checked = marking;

			checkOtherCF (ids[i], marking);
		}
	}

	switchMarkAllLink(acronymName);
}

//update corresponding checkbox in ALL or Acronym tab if exists
function checkOtherCF (id, marking)
{
	var s = id.split("_");
	s[0] = (s[0]=="ALL" ? "ONE" : "ALL");
	var $chkbox = $("#" + s.join("_"));
	if ($chkbox.length == 1)
	{
		$chkbox[0].checked = marking;
	}
}

function hideMarkAllLinks(acronymName)
{
	$("#" + acronymName + "CheckAllTransactionsFraud").css("display", "none");
	$("#" + acronymName + "CheckAllTransactionsOK").css("display", "none");
}

function switchMarkAllLink(acronymName)
{
	if ( $("#" + acronymName + "CheckAllTransactionsFraud").length ==0)
		return;

	var allChecked = true;
	var $chkboxes = $("#"+acronymName+"Table").find(":checkbox").each(function (){
		if ($(this).prop("checked") != true)
		{
			allChecked = false;
		}
	});

	if (allChecked)
	{
		$("#" + acronymName + "CheckAllTransactionsFraud").css("display", "none");
		$("#" + acronymName + "CheckAllTransactionsOK").css("display", "");
	}
	else
	{
		$("#" + acronymName + "CheckAllTransactionsOK").css("display", "none");
		$("#" + acronymName + "CheckAllTransactionsFraud").css("display", "");
	}
}

/**
 * Popup window: alertActivityPrompt
 * depends on following variable from current page
 * var actionMemos=[];
 */

function addActionMemo(actionId, memoSize, previewSize)
{
	if (memoSize > previewSize)
		actionMemos["a" + actionId] = {actionId: actionId, size: memoSize, content: null};
}

function getActionMemo(actionId)
{
	return actionMemos["a" + actionId];
}

// actionId : id of the action that the memo was added
// retrieveOption = {threshold: 100000, maxCount: 10}
// displayOption = {threshold: 100..99999, asHTML: true|false}
function viewActionMemoContent(actionId, retrieveOption, displayOption)
{
	$("#alertActivityPrompt").hide();

	var memo = getActionMemo(actionId);
	if (!memo)
	{
		alert ($i18n("fcm.alert.js.actionMemos.memo.noMoreContent.txt"));
		$(event.target).hide();
		return;
	}

	if (memo.content)
	{
		var $cell = $(event.target).parent();
		showFullMemo(memo, $cell, displayOption);
		return;
	}

	getActionMemoContents(memo, retrieveOption, displayOption);
}

function getActionMemoContents(actionMemo, retrieveOption, displayOption)
{
	var actionIds = [];
	actionIds.push(actionMemo.actionId);
	var totalSize = actionMemo.size;

	if (totalSize < retrieveOption.threshold)
	{
		for (var index in actionMemos)
		{
			var memo = actionMemos[index];
			if (memo.actionId != actionMemo.actionId && !memo.content)
			{
				if ( totalSize + memo.size <= retrieveOption.threshold)
				{
					actionIds.push(memo.actionId);
					totalSize += memo.size;

					if (actionIds.length > retrieveOption.maxCount)
						break;
				}

			}
		}
	}

	/* add method parameter */
	var params = {actionIds: actionIds.join(","), method: "getActionMemoContents"};

	getDataForAlert(event, {
		containerID: '#alertActivityGrid',
		action: 'getActionMemoContents.action',
		params: params
		},
		function (data) {loadActionMemoContents(actionMemo.actionId, data, displayOption)}
	);
}

function loadActionMemoContents(actionId, data, displayOption)
{
	var $container =  $("#alertActivityGrid");

	if (data.errMsg)
	{
		$container.data('$icon').attr("src", "common/images/messageError.gif").attr("title", data.errMsg);
		return;
	}

	var actionMemo=null;
	for (var index in data)
	{
		var item = data[index];
	 	var memo = getActionMemo(item.actionId);
	 	if (memo)
	 	{
	 		memo.content = item.memoContent;
			if (memo.actionId == actionId)
				actionMemo = memo;
		}
	}

	if ( actionMemo )
	{
		$container.data('$icon').attr("src", $container.data('iconURL'));
		showFullMemo (actionMemo, $container.data('$cell'), displayOption);
	}
	else
	{
		$container.data('$icon').hide();
	}
}

function showFullMemo(memo, $cell, displayOption)
{
	if ( displayOption.asHTML && !isSecurityRisk(memo.content) )
	{
		var hrefs = /^(https?|mailto|tel):/i;
		$("#alertActivityPromptMemo").html(memo.content);
		$("#alertActivityPromptMemo a").attr("target", "_blank").each(function (){
			if ( hrefs.test($(this).attr("href")) )
				$(this).css("font-weight", "bold").append("<img src='common/images/PopOut.gif'/>");
			else
				$(this).attr("href", "#");
		});
		$("#alertActivityPromptMemo *").unbind();
	}
	else
	{
		$("#alertActivityPromptMemo").text(memo.content);
	}

	var textLen = $("#alertActivityPromptMemo").text().length;

	if (textLen <= displayOption.threshold)
	{
		//show memo in cell
		var $grid= $("#alertActivityGrid");
		var topBefore =  $cell.offset().top;
		var width = $cell.width();
		var height = $cell.height();

		$cell.empty().append($("#alertActivityPromptMemo").contents()).width(width);

		// remove possible scroll bars caused by cell height change
		height += $grid.find("> table > thead").height() + $.getScrollBarWidth();
		if ( $grid.height() < height )
		{
			$grid.height($grid.find("> table").height());
		}

		var scrollY = $grid.scrollTop() + $cell.offset().top - topBefore;
		$grid.scrollTop(scrollY);
	}
	else
	{
		//show memo in the popup
		var x = $cell.offset().left- document.body.scrollLeft;
		var y = $cell.offset().top - document.body.scrollTop;

		$("#alertActivityPrompt").css({width: $cell.width(), top: y, left: x}).show();
	}
}

function isSecurityRisk(content)
{
	var scriptTag = /<script[\s\n\f\r]*>|<\/script[\s\n\f\r]*>/im;
	if (scriptTag.test(content))
		return true;

//	var scheme = /href[\s\n\f\r]*=[\s\n\f\r]*['"](\w+):\w+['"]/igm;
//	var matches = scheme.exec(content);

	return false;
}

/**
 * Popup window: alertActivityDisplayOptionPrompt
 * depends on:
 * var activityDisplayOption = {showHistory: true|false, threshold: 100..99999, asHTML: true|false}
 */

function showActivityDisplayOption()
{
	var $e = $.event.fix(event);
	$e.stopPropagation();

	var offset = $($e.target).offset();
	offset.left -= document.body.scrollLeft;
	offset.top -= document.body.scrollTop;
	$("#alertActivityDisplayOptionPrompt").css(offset).show();
}

function changeActivityDisplayOption(ctrl)
{
	// expires in one year
	var expireDate = new Date();
	expireDate.setFullYear(expireDate.getFullYear()+1);

	if (ctrl.type=="text")
	{
		var size = parseInt(ctrl.value);
		if (isNaN(size) || size < 100)
		{
			alert ($i18n("fcm.alert.js.actionMemos.memoSizeThreshold.notNumberOrTooSmall.txt"));
			ctrl.value= activityDisplayOption.threshold;
			return;
		}

		activityDisplayOption.threshold = size;
		setCookie('activityDisplayOption.threshold',activityDisplayOption.threshold,expireDate);
	}
	else if (ctrl.type=="checkbox")
	{
		activityDisplayOption.showHistory = ctrl.checked;
		setCookie('activityDisplayOption.showHistory',activityDisplayOption.showHistory,expireDate);
	}
}