<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<fmt:setBundle var="alertTypeLabelResourceBundle" scope="request" basename="com.sas.finserv.creditfraud.fcm.util.AlertTypeLabelResourceBundle" />
<fmt:setBundle var="alertTypeImageResourceBundle" scope="request" basename="com.sas.finserv.creditfraud.fcm.util.AlertTypeImageResourceBundle" />

<%-- needed by context-sensitive help if there are no tabs --%>
<script>var _thisUrl="viewAnalystMain.action";</script>

<%-- TODO:  Need to determine best place for this --%>
<script type="text/javascript">
	setBusy();

	DateUtil.setDefaultDateTimeFormat('${esapi:encodeForJavaScript(dateTimeFormat)}');
	DateUtil.setDefaultDateFormat('${esapi:encodeForJavaScript(dateFormat)}');
	DateUtil.setDefaultTimeFormat('${esapi:encodeForJavaScript(timeFormat)}');
   DateUtil.setMonthNames('${calendarMonthNames},${calendarShortMonthNames}'); <%-- do not html encode --%>
   DateUtil.setDayNames('${calendarFullDayNames},${calendarDayNames}'); <%-- do not html encode --%>
   DateUtil.setAmPmNames('${calendarAmPm}'); <%--  do not html encode --%>

	CalendarTime.setDateFormat('${esapi:encodeForJavaScript(dateFormat)}');
	CalendarTime.setMonthNames('${calendarMonthNames}'); <%-- do not html encode --%>
	CalendarTime.setDayNames('${calendarDayNames}'); <%-- do not html encode --%>
	CalendarTime.setShowMonthAfterYear(${esapi:encodeForJavaScript(calendarShowMonthAfterYear)});
	CalendarTime.setWeekStartDay(${esapi:encodeForJavaScript(calendarFirstDayOfWeek)});

$(document).ready(function(){

	i18n.init();

	var srRows = $("#searchResults tbody");
	srRows.find("tr:nth-child(even)").addClass("dataRow2_tableRow");
	srRows.find("tr:nth-child(odd)").addClass("dataRow1_tableRow");

	srRows = $("#workList tbody");
	srRows.find("tr:nth-child(even)").addClass("dataRow2_tableRow");
	srRows.find("tr:nth-child(odd)").addClass("dataRow1_tableRow");
	srRows = null;

	initSearch();

	removeBusy('mainDiv');

	$("div.scrollableGrid").adjustTableWidthForVScrollBar();

});

parent.sas.fscf.banner.removeAllExtraButtons();
</script>

<!-- Main Content -->

<!-- Begin outer container div -->
<div id="mainDiv" style="margin-left:12px;margin-top:12px;text-align:left;display:none">
	<%-- Begin Reveal Sensitive Data Section --%>
	<tiles:insertTemplate template="/common/displayRevealLinkT3.jsp" flush="true">
		<tiles:putAttribute name="revealFunction" value="revealSensitiveData()" />
	</tiles:insertTemplate>


	<%-- End Reveal Sensitive Data Section --%>
	<tiles:insertTemplate template="fraudNotifications.jsp" />

	<!-- ********************************** Confirmation Message *********************************** -->
	<c:if test="${not empty confirmationMessage}">

		<div style="display:block;margin:24px 12px 0px 0px;" align="left">
			<tiles:insertDefinition name="fcmSystemMessages" flush="true">
				<tiles:putAttribute name="messageSuccessImage" value="common/images/MessageInform_24.gif"/>
			</tiles:insertDefinition>
		</div>
	</c:if>


	<c:choose>
		<c:when test="${viewAlerts && not empty checkedOutAlerts}">
			<tiles:insertTemplate template="checkedOutAlerts.jsp" />
		</c:when>
		<c:otherwise>
			<c:if test="${updateAlerts && (priorityOutbound || directOutbound)}">
				<form name="priorityServicingForm" action="outboundAlert.action" method="post">
					<input type="hidden" name="method" value="outbound"/>
					<input type="hidden" name="sasfcmServiceType" value="priorityBased"/>
				</form>
				<form name="directServicingForm" action="outboundAlert.action" method="post">
					<input type="hidden" name="method" value="outbound"/>
					<input type="hidden" name="sasfcmServiceType" value="directService"/>
					<input type="hidden" name="strategy"/>
				</form>

<c:if test="${strategiesRefreshInterval > 0 or showManualRefresh}">
<script>

function refreshStrategyList()
{
	$("#strategyListSpinner").show();

	var params = {};
	params.method = 'refreshStrategyList';

	var form = new DynaForm('getDataForStrategyList');
	form.setAction("refreshStrategyList.action")
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParams(params)
		.setCallback(loadDataForStrategyList)
		.doSubmit();
}

function loadDataForStrategyList(data)
{
	$("#stratgyList").empty().html(data);
	$("div.scrollableGrid").adjustTableWidthForVScrollBar();
}

<c:if test="${strategiesRefreshInterval > 0}">
$(document).ready(function(){
setInterval(refreshStrategyList, ${strategiesRefreshInterval*1000});
});
</c:if>
</script>
</c:if>
				<div id="stratgyList">
				<tiles:insertTemplate template="strategyList.jsp" />
				</div>
			</c:if>
		</c:otherwise>
	</c:choose>

	<tiles:insertTemplate template="inboundSearch.jsp" />

	<c:if test="${viewAlerts && not empty alertsServicedList}">
		<tiles:insertTemplate template="alertsServiced.jsp" />
	</c:if>

	<c:if test="${not empty workList}">
		<tiles:insertTemplate template="workList.jsp" />
	</c:if>

</div>
<br>
<!-- End outer container div -->