<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<%-- Push component attributes in page context --%>
<tiles:importAttribute/>

<table class="mainTable minWidthTable" border="0" cellspacing="0" cellpadding="0">
	<thead>
		<tr class="tableColumnHeaderRow" >
			<th class="tableHeader" style="border-top:none;border-right:none;color:#353535;font-weight:bold;">
			   <fmt:message key="fcm.fraudNotifications.title.txt" />
			</th>
		</tr>
	</thead>
	<tbody>
		<tr>
			<td style="padding:0px">
				<div class="scrollableGrid" style="height:11.6em" onscroll="repositionTHs(this)">
				<table style="border-collapse:separate;" border="0" cellspacing="0" cellpadding="0">
					<thead>
						<tr class="tableColumnHeaderRow">
							<th class="tableHeader" style="border-right:none;border-top:none;">&nbsp;</th>
							<th class="tableHeader" style="border-right:none;border-top:none;"> <fmt:message key="fcm.fraudNotifications.from.txt" /> </th>
							<th class="tableHeader" style="border-right:none;border-top:none;"> <fmt:message key="fcm.fraudNotifications.message.txt" /> </th>
							<th class="tableHeader" style="border-right:none;border-top:none;"> <fmt:message key="fcm.fraudNotifications.date.txt" /> </th>
							<th class="tableHeader" style="border-right:none;border-top:none;"> <fmt:message key="fcm.fraudNotifications.time.txt" /> </th>
							<th class="tableHeader" style="border-right:none;border-top:none;">&nbsp;</th>
						</tr>
					</thead>
					<tbody>
						<c:choose>
							<c:when test="${not empty notifications}">
								<c:forEach var="notification" items="${notifications}" varStatus="loop">
									<c:choose>
										<c:when test="${loop.count % 2 == 0}">
									<tr class="dataRow1_tableRow">
										</c:when>
										<c:otherwise>
									<tr class="dataRow2_tableRow">
										</c:otherwise>
									</c:choose>
										<td valign="top"> ${loop.count} </td>
										<td valign="top">${esapi:encodeForHTML(notification.lastUpdateUser)}</td>
										<td valign="top" style="white-space:normal;">${esapi:encodeForHTML(notification.messageText)}</td>
										<td valign="top"><esapi:encodeForHTML><fmt:formatDate value="${notification.lastUpdateTimestamp}" pattern="${dateFormat}" timeZone="${userTimeZone}"/></esapi:encodeForHTML></td>
										<td valign="top"><esapi:encodeForHTML><fmt:formatDate value="${notification.lastUpdateTimestamp}" pattern="${timeFormat}" timeZone="${userTimeZone}"/></esapi:encodeForHTML></td>
										<td valign="top">&nbsp;</td>
									</tr>
								</c:forEach>
							</c:when>
							<c:otherwise>
									<tr class="dataRow1_tableRow">
										<td valign="top" align="center" colspan="6"><fmt:message key="fcm.fraudNotifications.noFraudNotificationsExist.txt"/></td>
									</tr>
							</c:otherwise>
						</c:choose>

					</tbody>
				</table>
				</div>
			</td>
		</tr>
	</tbody>
</table>