<%-- this file uses leading tabs; don't insert leading spaces --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<tiles:importAttribute/>

<div id="entitiesGrid" class="scrollableGrid u-border" onscroll="repositionTHs(this)">

	<table class="mainTable"  cellspacing="0" cellpadding="2" style="border: 0px; width: 100%; height: 160px; vertical-align:top;">
		<thead>
			<tr>
				<th class="tableHeader" width="18"> </th>
				<th class="tableHeader" nowrap>
					<select id="alertsFilter">
					<!--	<option value="3"><fmt:message key='fcm.alert.filter.focal.list.txt'/></option> -->
						<option value="1"><fmt:message key='fcm.alert.filter.pending.alerts.txt'/></option>
						<option value="2"><fmt:message key='fcm.alert.filter.serviced.alerts.txt'/></option>
						<option value="0"><fmt:message key='fcm.alert.filter.all.alerts.txt'/></option>
						<option value="-1"><fmt:message key='fcm.alert.filter.all.entities.txt'/></option>
					</select>
					<img id="defaultViewSetting" src="analyst/images/defaultView.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.setDefaultView.txt'/></esapi:encodeForHTMLAttribute>"/>
				</th>
				<th class="tableHeader" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.amount.title.txt'/></esapi:encodeForHTMLAttribute>" nowrap><fmt:message key='fcm.alert.amount.txt'/></th>
				<th class="tableHeader" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.expirationTime.title.txt'/></esapi:encodeForHTMLAttribute>" nowrap><fmt:message key='fcm.alert.expirationTime.txt'/> <fmt:message key='fcm.alert.expirationTime.inHourMin.txt'/></th>
				<th class="tableHeader" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.status.title.txt'/></esapi:encodeForHTMLAttribute>"><fmt:message key='fcm.alert.status.txt'/></th>
				<th class="tableHeader" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.servicedAt.title.txt'/></esapi:encodeForHTMLAttribute>"><fmt:message key='fcm.alert.servicedAt.txt'/></th>
				<th class="tableHeader lastCol" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.servicedBy.title.txt'/></esapi:encodeForHTMLAttribute>"><fmt:message key='fcm.alert.servicedBy.txt'/></th>
			</tr>
		</thead>
		<tbody>
			<c:set var="serviceState" value="0"/> <%-- 0: no service to be done or being doen; 1: pending for service; 2: serviced --%>
			<c:set var="checkoutable" value="0"/> <%-- 0: not checkoutable; 1: checked out by this user in pending;  2: free to checkout in pending; 3: checked out serviced toady's item; 4: serviced toady's item; 5: checked out serviced in past; 6: serviced  in past; 7: available for steal (force checkout); 8: non-stealable (checked out or suspended);--%>
			<c:set var="isDisplayEntity" value="false"/>
			<c:set var="isCheckoutAllowed" value="${updateAlerts and not checkoutManager.preServiceMode}"/>
			<c:set var="isSameContact" value="false"/>

			<c:forEach var="entity" items="${displayEntity.linkedEntities}" varStatus="loop">
				<c:set var="isPrimaryContact" value="${checkoutManager.isGroupedByPrimaryContact(entity)}"/>
				<c:set var="isSameContact" value="${not empty displayEntity.contactID and displayEntity.contactType eq entity.contactType and displayEntity.contactID eq entity.contactID}"/>
				<c:set var="isDisplayEntity" value="${displayEntity.entityType eq entity.entityType and displayEntity.entityID eq entity.entityID}"/>
				<c:set var="rowInFocus"><c:if test="${isDisplayEntity}">id="currentEntity"</c:if></c:set>
				<c:set var="navIdAttr">
					<c:choose>
						<c:when test="${isDisplayEntity}"> id="nav_self" </c:when>
						<c:when test="${entity.entityID eq displayEntity.parentEntityID and entity.entityType eq displayEntity.parentEntityType}"> id="nav_parent" </c:when>
						<c:when test="${entity.entityID eq displayEntity.contactID and entity.entityType eq displayEntity.contactType}"> id="nav_contact" </c:when>
					</c:choose>
				</c:set>

			<c:if test='${not empty entity.alertId}'>
				<c:set var="alertStatus" value="${entity.alertStatus}"/>
				<c:set var="checkoutUser" value="${entity.checkoutUser}"/>
				<c:set var="lastCallResult" value="${entity.lastCallResult}"/>
				<c:set var="alertServiceable" value="${not sfmfn:isFutureTime(entity.nextServiceTimestamp)}"/>
				<c:set var="isFocalAlert" value="${sfmfn:isPresentTime(entity.lastDispositionTimestamp, 12*3600000)}"/>

				<c:choose>
					<c:when test="${alertStatus eq 'CHECKOUT' and checkoutUser ne username}"><c:set var="serviceState" value="0"/></c:when>
					<c:when test="${alertStatus eq 'ACTIVE' and not empty entity.suspendUser}"><c:set var="serviceState" value="0"/></c:when>
					<c:when test="${(alertStatus eq 'ACTIVE' or alertStatus eq 'CHECKOUT') and (alertServiceable or empty lastCallResult)}"><c:set var="serviceState" value="1"/></c:when>
					<c:when test="${(alertStatus eq 'ACTIVE' or alertStatus eq 'CHECKOUT')}"><c:set var="serviceState" value="2"/></c:when>
					<c:otherwise><c:set var="serviceState" value="0"/></c:otherwise>
				</c:choose>
				<c:choose>
					<c:when test="${serviceState eq 1 and checkoutUser eq username}"><c:set var="checkoutable" value="1"/></c:when>
					<c:when test="${serviceState eq 1}"><c:set var="checkoutable" value="2"/></c:when>
					<c:when test="${serviceState eq 2 and checkoutUser eq username and isFocalAlert}"><c:set var="checkoutable" value="3"/></c:when>
					<c:when test="${serviceState eq 2 and isFocalAlert}"><c:set var="checkoutable" value="4"/></c:when>
					<c:when test="${serviceState eq 2 and checkoutUser eq username}"><c:set var="checkoutable" value="5"/></c:when>
					<c:when test="${serviceState eq 2}"><c:set var="checkoutable" value="6"/></c:when>
					<c:when test="${serviceState eq 0 and (not empty checkoutUser and entity.suspendUserCheckouts eq 1 or not empty entity.suspendUser and entity.suspendUserCheckouts eq 0)}"><c:set var="checkoutable" value="7"/></c:when>
					<c:when test="${serviceState eq 0 and (not empty checkoutUser or not empty entity.suspendUser)}"><c:set var="checkoutable" value="8"/></c:when>
					<c:otherwise><c:set var="checkoutable" value="0"/></c:otherwise>
				</c:choose>

				<c:set var="otherContactID"><c:if test="${not isSameContact}"><sfmmsk:maskData value="${entity.contactID}" maskType="ID" /></c:if></c:set>
				<c:set var="cssStyle"><c:if test="${checkoutable eq 0 or checkoutable ge 6}">color:grey;font-style:italic;</c:if></c:set>
				<tr class="dataRow1_tableRow" ${rowInFocus} serviceState="${serviceState}" checkoutable="${checkoutable}" style="${cssStyle}" alertID="${entity.alertId}">
					<td class="txnTableHeader" style="width:16px">
						<c:choose>
							<c:when test="${checkoutable eq 1 or checkoutable eq 2}">
								<c:choose>
									<c:when test="${isSameContact or isPrimaryContact}"><img src="analyst/images/attention.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.requiresAssessment.txt"/></esapi:encodeForHTMLAttribute>"/></c:when>
									<c:otherwise><img src="common/images/Link.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.optionalAssessment.fmt.txt"><fmt:param>${otherContactID}</fmt:param></fmt:message></esapi:encodeForHTMLAttribute>"/></c:otherwise>
								</c:choose>
							</c:when>
							<c:when test="${checkoutable eq 3 or checkoutable eq 4}"><img src="analyst/images/done.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.providedAssessment.txt"/></esapi:encodeForHTMLAttribute>"/></c:when>
							<c:when test="${checkoutable eq 7}"><img src="analyst/images/Lock.gif" title="<esapi:encodeForHTMLAttribute><sfmfmt:formatAlertStatus value='${entity}'/></esapi:encodeForHTMLAttribute>"/></c:when>
							<c:when test="${checkoutable eq 8}"><img src="analyst/images/LockDisabled.gif" title="<esapi:encodeForHTMLAttribute><sfmfmt:formatAlertStatus value='${entity}'/></esapi:encodeForHTMLAttribute>"/></c:when>
						</c:choose>
					</td>
					<td style="white-space:nowrap" class="textTableCell"> <c:if test="${__debug__}"> <span>[S=${serviceState}, C=${checkoutable}, SCO=${entity.suspendUserCheckouts}]</span></c:if>
						<img src="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
						<c:choose>
						<c:when test="${empty alertAdminRequest}">
							<a ${navIdAttr} style="color: rgb(40, 126, 171);" href="#" onclick="switchAlert(${isCheckoutAllowed}, '${checkoutable}', '${entity.alertId}')"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /></a>
						</c:when>
						<c:otherwise>
							<a ${navIdAttr} style="color: rgb(40, 126, 171);" href="#" onclick="viewAlert('${entity.alertId}')"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
						</c:otherwise>
						</c:choose>
						<c:if test="${not isSameContact}">
							<img src="common/images/ContactsRoles.gif" title="<esapi:encodeForHTMLAttribute>${otherContactID}</esapi:encodeForHTMLAttribute>"  class="icon" width="13" height="13"/>
						</c:if>
					</td>
					<td style="white-space:nowrap" class="textTableCell"><sfmfmt:formatData value="${entity.transactionAmt}" dataType="currency" /></td>
					<td style="white-space:nowrap" class="textTableCell"><sfmfmt:formatAlertExpiration value="${entity}" id="${entity.alertId}" /></td>
					<td style="white-space:nowrap" class="textTableCell">
					<c:choose>
						<c:when test="${serviceState eq 0}">
							<a style="color: rgb(40, 126, 171);" href="#" onclick="WorkList('ADD',<sfmfmt:entityToJSON entity="${entity}"/>,'${esapi:encodeForJavaScript(contactDetails.fullName)}','${esapi:encodeForJavaScript(contactDetails.homePhone1)}','${esapi:encodeForJavaScript(contactDetails.addressLine1)}','${esapi:encodeForJavaScript(contactDetails.city)}','${esapi:encodeForJavaScript(contactDetails.stateProvinceName)}','${esapi:encodeForJavaScript(contactDetails.postalCode)}','${esapi:encodeForJavaScript(contactDetails.country)}','${esapi:encodeForJavaScript(entity.alertId)}','${esapi:encodeForJavaScript(entity.alertStatus)}','${esapi:encodeForJavaScript(entity.checkoutUser)}','${esapi:encodeForJavaScript(entity.suspendUser)}','${esapi:encodeForJavaScript(entity.alertVersion)}','${esapi:encodeForJavaScript(entity.lastCallResultId)}','${esapi:encodeForJavaScript(entity.alertStrategy)}','${esapi:encodeForJavaScript(entity.alertQueue)}');">
								<img src="common/images/PlusGreen.gif" border="0" class="icon" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.clickToAddToWorkList.txt"/></esapi:encodeForHTMLAttribute>" width="16" height="16"/></a>
						</c:when>
 						<c:otherwise>
							<img src="common/images/spacer.gif" width="12" height="12"/>
						</c:otherwise>
					</c:choose>
						<sfmfmt:formatAlertStatus value="${entity}" excludeCheckout="true"/></td>
					<td style="white-space:nowrap" class="textTableCell"> <esapi:encodeForHTML><fmt:formatDate value="${entity.lastDispositionTimestamp}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}"/></esapi:encodeForHTML></td>
					<td style="white-space:nowrap" class="textTableCell lastCol"> ${esapi:encodeForHTML(entity.lastDispositionUser)}</td>
				</tr>
			</c:if>

			<c:if test='${empty entity.alertId}'>
				<c:set var="cssStyle">color:grey;font-style:italic;</c:set>

				<tr class="dataRow1_tableRow" ${rowInFocus} style="${cssStyle}">
					<td class="txnTableHeader" style="width:16px">
<%--						<c:if test="${isDisplayEntity}"><img src="analyst/images/viewEntity.gif"/></c:if> --%>
						&nbsp;
					</td>
					<td style="white-space:nowrap" class="textTableCell">
						<img src="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
						<a ${navIdAttr} style="color: rgb(40, 126, 171);" href="#" onclick="switchEntity(<sfmfmt:entityToJSON entity="${entity}"/>)"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
						<c:if test="${not isSameContact}">
							<img src="common/images/ContactsRoles.gif" title="<esapi:encodeForHTMLAttribute>${otherContactID}</esapi:encodeForHTMLAttribute>"  class="icon" width="13" height="13"/>
						</c:if>
					</td>
					<td style="white-space:nowrap" class="textTableCell"> </td>
					<td style="white-space:nowrap" class="textTableCell"> </td>
					<td style="white-space:nowrap" class="textTableCell">
						<a href="#" style="color: rgb(40, 126, 171);" onclick="WorkList('ADD',<sfmfmt:entityToJSON entity="${entity}"/>,'${esapi:encodeForJavaScript(contactDetails.fullName)}','${esapi:encodeForJavaScript(contactDetails.homePhone1)}','${esapi:encodeForJavaScript(contactDetails.addressLine1)}','${esapi:encodeForJavaScript(contactDetails.city)}','${esapi:encodeForJavaScript(contactDetails.stateProvinceName)}','${esapi:encodeForJavaScript(contactDetails.postalCode)}','${esapi:encodeForJavaScript(contactDetails.country)}','${esapi:encodeForJavaScript(entity.alertId)}','${esapi:encodeForJavaScript(entity.alertStatus)}','${esapi:encodeForJavaScript(entity.checkoutUser)}','${esapi:encodeForJavaScript(entity.suspendUser)}','${esapi:encodeForJavaScript(entity.alertVersion)}','${esapi:encodeForJavaScript(entity.lastCallResultId)}','${esapi:encodeForJavaScript(entity.alertStrategy)}','${esapi:encodeForJavaScript(entity.alertQueue)}');">
							<img src="common/images/PlusGreen.gif" border="0" class="icon" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.clickToAddToWorkList.txt"/></esapi:encodeForHTMLAttribute>" width="16" height="16"/></a>
						<sfmfmt:formatAlertStatus value="${entity}"/></td>
					<td style="white-space:nowrap" class="textTableCell"> </td>
					<td style="white-space:nowrap" class="textTableCell lastCol"> </td>
				</tr>
			</c:if>


			</c:forEach>


			<tr class="dataRow1_tableRow" data="no">
				<td class="txnTableHeader" style="width:16px">&nbsp;</td>
				<td colspan="6" class="textTableCell lastCol" style="text-align:center; font-style: italic;"><fmt:message key='fcm.alert.filter.result.noData.txt'/></td>
			</tr>
			<c:forEach begin="0" end="3">
			<tr class="dataRow1_tableRow" data="no">
				<td class="txnTableHeader" style="width:16px">&nbsp;</td>
				<td style="white-space:nowrap" class="textTableCell"> </td>
				<td style="white-space:nowrap" class="textTableCell"> </td>
				<td style="white-space:nowrap" class="textTableCell"> </td>
				<td style="white-space:nowrap" class="textTableCell"> </td>
				<td style="white-space:nowrap" class="textTableCell"> </td>
				<td style="white-space:nowrap" class="textTableCell lastCol"> </td>
			</tr>
			</c:forEach>
		</tbody>
	</table>
</div>


<script type="text/javascript">
	$(document).ready(function(){
		<c:choose>
			<c:when test="${not empty displayEntity.currentAlert}">
				$("#alertsFilter").val(getCookie('alertsFilter', '0'));
			</c:when>
			<c:otherwise>
				$("#alertsFilter").val(getCookie('alertsFilter', '-1'));
			</c:otherwise>
		</c:choose>

		// remember filter selection
		$("#alertsFilter").change(function() {
//			setCookie('alertsFilter',this.value);
			if (this.value == getCookie('alertsFilter'))
				$("#defaultViewSetting").css("opacity", 0.5);
			else
				$("#defaultViewSetting").css("opacity", 1);
		});

		$("#defaultViewSetting").click(function() {
			// expires in one year
			var expireDate = new Date();
			expireDate.setFullYear(expireDate.getFullYear()+1);

			setCookie('alertsFilter',$('#alertsFilter').val(),expireDate);
			$(this).css('opacity', 0.5);
		});

		$("#alertsFilter").change(function() {
		 	var nodata = $("#entitiesGrid > table > tbody > tr[data]");

			var rows = $("#entitiesGrid > table > tbody > tr");
			$(rows).css("display", "none").attr("class", "dataRow1_tableRow");

			if (this.value == '-1')
			{
				$(rows).filter(":even").attr("class", "dataRow2_tableRow").end().css("display", "");
				$(nodata).css("display", "none").attr("class", "dataRow1_tableRow");
			}
			else if (this.value=='0')
			{
				$(rows).filter("[serviceState]").filter(":even").attr("class", "dataRow2_tableRow").end().css("display", "");
			}
			else if (this.value=='3')
			{
				$(rows).filter("[serviceState]").filter(function () { return $(this).attr('checkoutable') >= 1 &&  $(this).attr('checkoutable') <= 5;}).filter(":even").attr("class", "dataRow2_tableRow").end().css("display", "");
			}
			else
			{
				$(rows).filter("[serviceState='" + this.value + "']").filter(":even").attr("class", "dataRow2_tableRow").end().css("display", "");
			}

//			if ($(rows).filter(":visible").length == 0)
//				$(nodata).css("display", "");

			var numVisibleRows = $(rows).filter(":visible").length;
			if (numVisibleRows < 5)
			{
				$(nodata).slice(numVisibleRows).filter(numVisibleRows%2 ==0 ? ":even" : ":odd").attr("class", "dataRow2_tableRow").end().css("display", "");
			}

			if ($("#entitiesGrid > table").height() > refSize.height)
			{
				$("#entitiesGrid").height(refSize.height);
				$("#entitiesGrid > table").width($("#entitiesGrid").width()-17); //scroll bar width
				$("#entitiesGrid > table").width($("#entitiesGrid").width()-17); //needed for 1st time
			}
			else
			{
				$("#entitiesGrid").height($("#entitiesGrid > table").height()+2);
				$("#entitiesGrid > table").width($("#entitiesGrid").width());
			}

			// scroll the selected row to the middle of the grid
			var row = $("#currentEntity");
			if (row.length > 0 && row.css("display") != "none")
			{
				$("#entitiesGrid").scrollTop(row.offset().top - $("#entitiesGrid").offset().top - $("#entitiesGrid").height()/2 );
			}
		}).change();

		// ====================================================================================
		// setup the timers:
		// show hh:mm within 24 hours, otherwise display # of days
		// ticks every minute, change to orange color within 10 minutes, to red when expired
		// Define timer: <sapn id="timer_XYZ" count="# minutes of countdown"/>
		// ====================================================================================

		function padNumber( num )
		{
			return (num < 10 ? ("0"+num) : num);
		}

		// return zero padded hh:mm
		function formatTimerDisplay(count)
		{
			var hours = Math.floor( count / 60 );
			var mins =  Math.floor( count % 60 );
			return padNumber( hours ) + ":" + padNumber( mins );
		}

		// initiate timers
		$("span[id^='timer']").each(function () {
			var count = $(this).attr("count");
			if (count && count > 0 )
			{
				$(this).attr("class", (count > 10 ? "timerNormal" : "timerWarning")).html(formatTimerDisplay(count));
			}
		});

		// bind event "tick" handler
		$("span[id^='timer']").bind("tick", function () {
			var count = $(this).attr("count");
			if (count > 0)
			{
				$(this).attr("count", --count).html(formatTimerDisplay(count));
				if (count <= 10)
				{
					$(this).attr("class", count==0 ? "timerExpired" : "timerWarning");
				}
			}
		});

		// setup tick event every 1 min
		var timer=setInterval(timeout, 60000);
		function timeout()
		{
			// RAPTOR-2399
			const $timerSpans = $("span[id^='timer_']").filter(function () {
	    		return $(this).attr("count") > 0;
	 		} );
			$timerSpans.trigger("tick");
			if ($timerSpans.length === 0) {
				clearInterval(timer);
			};		
		}

	});

<!-- viewAlert(alertId) -->
<!-- viewEntity(entity) -->
<!-- modifyAlert(alertId) -->
<!-- checkout(alertId) -->

function switchAlert(authUpdate, checkoutable, alertID) {

	if ($mainForm.isDirty())
	{
		var rc = confirm ($i18n("fcm.alert.js.navigate.unsavedData.txt"));
		if (!rc) return;
	}

	if (authUpdate)
	{
		if (checkoutable=="1" || checkoutable=="3" || checkoutable=="5")
		{
			// checked out to me, work on it
			modifyAlert(alertID);
		}
		else if (checkoutable=="2" || checkoutable=="4" || checkoutable=="6")
		{
			// not checked out, check it out
			checkout(alertID);
		}
		else
		{
			viewAlert(alertID);
		}
	}
	else
	{
		viewAlert(alertID);
	}
}

function switchEntity(entity) {

	if ($mainForm.isDirty())
	{
		var rc = confirm ($i18n("fcm.alert.js.navigate.unsavedData.txt"));
		if (!rc) return;
	}

	viewEntity(entity);
}
</script>
