<!DOCTYPE html>
<%-- use leading tabs only, no spaces please --%>
<%@ page contentType="text/html; charset=UTF-8" errorPage="/common/errorMessage.jsp"%>
<%@ include file="/common/taglibsT3.jsp" %>

<fmt:setBundle var="alertTypeLabelResourceBundle" scope="request" basename="com.sas.finserv.creditfraud.fcm.util.AlertTypeLabelResourceBundle" />
<fmt:setBundle var="alertTypeImageResourceBundle" scope="request" basename="com.sas.finserv.creditfraud.fcm.util.AlertTypeImageResourceBundle" />

<c:set var="__debug__" value="false" scope="request"/>

<c:set var="contactDetails" value="${displayEntity.contactDetails.detailMap}" scope="request"/>
<fmt:setBundle var="entityDetailsResourceBundle" scope="request" basename="com.sas.finserv.creditfraud.fcm.util.EntityDetailsResourceBundle" />

<c:set var="displayType" scope="request">
	<c:choose>
		<c:when test="${empty displayEntity.currentAlert}">viewEntity</c:when>
		<c:when test="${displayEntity.currentAlert.alertStatus eq 'CHECKOUT' and displayEntity.currentAlert.checkoutUser eq username}">updateAlert</c:when>
		<c:otherwise>viewAlert</c:otherwise>
	</c:choose>
</c:set>
<%--c:set var="alertInfoPanelDisplay" scope="request" value="FIRST_TAB"/--%>

<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title>
<c:choose>
	<c:when test="${empty productName}">
		SAS&reg; Fraud Management
	</c:when>
	<c:otherwise>
		${fn:replace(fn:replace(productName, "<sup>", ""), "</sup>", "")}
	</c:otherwise>
</c:choose>
- <fmt:message key="fcm.alert.entity.txt" /></title>

<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_base/fonts.css" type="text/css"/>
<link rel="stylesheet" href="resources/sap/ui/core/themes/sas_corporate/library.css" type="text/css">
<link rel="stylesheet" href="resources/sap/ui/commons/themes/sas_corporate/library.css" type="text/css">
<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="resources/sas/hc/ui/commons/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="resources/sap/m/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="common/styles/calendar.css" type="text/css"/>
<link rel='stylesheet' href='analyst/styles/entity.css' type='text/css'/>
<%--<link rel="stylesheet" href="common/styles/sasStyles.css" type="text/css"/>--%>
<link rel="stylesheet" href="common/styles/cf.css" type="text/css"/>
<%--<link rel="stylesheet" href="analyst/styles/analystPrint.css" type="text/css" media="print"/>--%>

<script src="common/scripts/jquery.js" type="text/javascript"></script>
<script src="common/scripts/sasSolutions.js" type="text/javascript"></script>
<script src="common/scripts/i18n.js" type="text/javascript"></script>
<script src="common/scripts/cf.js" type="text/javascript"></script>
<script src="common/scripts/dateUtil.js" type="text/javascript"></script>
<script src="common/scripts/calendar.js" type="text/javascript"></script>
<script src="common/scripts/calendarTime.js" type="text/javascript"></script>
<script src="common/scripts/jquery.fcm.dynaform.js" type="text/javascript"></script>
<script src="analyst/scripts/analyst.js" type="text/javascript"></script>
<script src="analyst/scripts/entity.js" type="text/javascript"></script>
<script src="analyst/scripts/dataPop.js" type="text/javascript"></script>
<script src="analyst/scripts/transactionFraudFlags.js" type="text/javascript"></script>
<script src="analyst/scripts/md5.js" type="text/javascript"></script>
<script src="analyst/scripts/jquery.fcm.scrollbars.js" type="text/javascript"></script>
<script type="text/javascript">

	DateUtil.setDefaultDateTimeFormat('${esapi:encodeForJavaScript(dateTimeFormat)}');
	DateUtil.setDefaultDateFormat('${esapi:encodeForJavaScript(dateFormat)}');
	DateUtil.setDefaultTimeFormat('${esapi:encodeForJavaScript(timeFormat)}');
   DateUtil.setMonthNames('${calendarMonthNames},${calendarShortMonthNames}'); <%-- do not html encode --%>
   DateUtil.setDayNames('${calendarFullDayNames},${calendarDayNames}'); <%-- do not html encode --%>
   DateUtil.setAmPmNames('${calendarAmPm}'); <%--  do not html encode --%>

	CalendarTime.setDateFormat('${esapi:encodeForJavaScript(dateTimeFormat)}');
	CalendarTime.setMonthNames('${calendarMonthNames}'); <%-- do not html encode --%>
	CalendarTime.setDayNames('${calendarDayNames}'); <%-- do not html encode --%>
	CalendarTime.setShowMonthAfterYear(${esapi:encodeForJavaScript(calendarShowMonthAfterYear)});
	CalendarTime.setWeekStartDay(${esapi:encodeForJavaScript(calendarFirstDayOfWeek)});
	<%-- Time-related labels --%>
	CalendarTime.setButtonLabel('${esapi:encodeForJavaScript(esapi:encodeForHTML(calendarButtonLabel))}');
	CalendarTime.setTimeLabel('${esapi:encodeForJavaScript(esapi:encodeForHTML(calendarTimeLabel))}');
	CalendarTime.setHoursLabel('${esapi:encodeForJavaScript(esapi:encodeForHTML(calendarHoursLabel))}');
	CalendarTime.setMinutesLabel('${esapi:encodeForJavaScript(esapi:encodeForHTML(calendarMinutesLabel))}');

	CalendarTime.addValidator(
		(function(date)
			{
				var now = new Date();
				if(date.getTime() < now.getTime()){
					now.setSeconds(0);
					now.setMilliseconds(0);
					alert("<fmt:message key='fcm.alert.pickADateOnOrAfter.txt'/> '"+DateUtil.formatDateTime(now)+"'");
					return false;
				}
				return true;
			}
		)
	);
	$(document).ready(function(){
		removeBusy('mainDiv');
	});
  $(document).ready(onLoadHandler);

	var refSize = {"width": 0, "height": 0};

	// adjust min table width according to the window size
	$(document).ready(function(){

 		winWidth = $.getWindowWidth();

		var maxScreenWidth = 1920;
		var scrollBarsWidth = 38;
		var spaceWidth = 5;

<c:if test="${alertInfoPanelDisplay eq 'SPLIT'}">
		var entityGridMinWidth = 300;

		if ($("#entityGrid").width() == entityGridMinWidth)
		{
			var entityGridTargetWidth = Math.floor(winWidth * 0.3 / 10 ) * 10;
			if (entityGridTargetWidth <= entityGridMinWidth)
				entityGridTargetWidth = entityGridMinWidth;
			else
				$("#entityGrid").width(entityGridTargetWidth);

	 		minWidth = (winWidth >=maxScreenWidth ? maxScreenWidth- scrollBarsWidth: winWidth >= 1227 ?  winWidth - scrollBarsWidth : 1191) - (entityGridTargetWidth + spaceWidth * 2);
	 		$(".minWidthTableX").css("min-width", (minWidth-scrollBarsWidth) + "px").css("width", minWidth + "px");

	 		minWidth += entityGridTargetWidth + spaceWidth;
			$("#wrapGrid > table,#warningTable,#alertActivityGrid").css("min-width", minWidth + "px").css("width", minWidth + "px");
			setGridBorders('alertActivity');
		}
		else
		{
	 		minWidth = (winWidth >=maxScreenWidth ? maxScreenWidth- scrollBarsWidth : winWidth >= 1227 ?  winWidth - scrollBarsWidth : 1191);

	 		$(".minWidthTableX").css("min-width", minWidth + "px").css("width", minWidth + "px");
		}
</c:if>

<c:if test="${alertInfoPanelDisplay ne 'SPLIT'}">
		{
	 		minWidth = (winWidth >=maxScreenWidth ? maxScreenWidth- scrollBarsWidth : winWidth >= 1227 ?  winWidth - scrollBarsWidth : 1191);

	 		$(".minWidthTableX").css("min-width", minWidth + "px").css("width", minWidth + "px");
		}
</c:if>

		<c:if test="${__debug__}">
	 	$("#debugInfo")
		 	.append($.getWindowWidth() + " x " + $.getWindowHeight()).append(" : " + minWidth)
		 	.append(" : checkoutUser=" + "${displayEntity.currentAlert.checkoutUser}")
		 	.append(" : suspendUser=" + "${displayEntity.currentAlert.suspendUser}")
		 	.append(" : checkouts=" + "${displayEntity.currentAlert.suspendUserCheckouts}")
		 	.append(" : checkoutAvailable=" + "${checkoutManager.checkoutAvailable}")
		 	.show();
		</c:if>

		refSize = {"width": minWidth, "height": $("#entityGrid").height()};

	});

	// allow a text field to behave normally (focus/delete/select) inside a draggable div
	$(document).ready(function(){

		$('div[draggable] :text, #genericFieldsDiv :text')
		    .bind('focus', function(e) {
		        $(this).closest('div[draggable]').attr("draggable", false);
	//	        console.log("focus");
		    })
		    .bind('blur', function(e) {
		        $(this).closest('div[draggable]').attr("draggable", true);
	//	        console.log("blur");
		    })
		    ;
	});


<c:if test="${addDataToLists || removeDataFromLists}">

var i18nResults =[];
i18nResults[0] = "<img width=16 height=16 src='common/images/messageOK.gif'/> <esapi:encodeForJavaScript><fmt:message key="fcm.alert.tran.updateAnalystList.result.success.txt"/></esapi:encodeForJavaScript>";
i18nResults[1] = "<img width=16 height=16 src='common/images/messageError.gif'/> <esapi:encodeForJavaScript><fmt:message key="fcm.alert.tran.updateAnalystList.result.failure.txt"/></esapi:encodeForJavaScript>";
i18nResults[2] = "<img width=16 height=16 src='common/images/messageWarning.gif'/> <esapi:encodeForJavaScript><fmt:message key="fcm.alert.tran.updateAnalystList.result.retry.txt"/></esapi:encodeForJavaScript>";

var i18nResultMsgs =[];
i18nResultMsgs[0] = "<esapi:encodeForJavaScript><fmt:message key="fcm.alert.tran.updateAnalystList.result.success.txt"/></esapi:encodeForJavaScript>";
i18nResultMsgs[1] = "<esapi:encodeForJavaScript><fmt:message key="fcm.alert.tran.updateAnalystList.systemError.txt"/></esapi:encodeForJavaScript>";
i18nResultMsgs[2] = "<esapi:encodeForJavaScript><fmt:message key="fcm.alert.tran.updateAnalystList.systemBusy.txt"/></esapi:encodeForJavaScript>";

var resultStyles =[];
resultStyles[0] = {"color": "black"};
resultStyles[1] = {"color": "red"};
resultStyles[2] = {"color": "orange"};

</c:if>

</script>
</head>

<body class="sapUiBody sapUiSizeCompact" style="overflow:auto" ondrop="drop(event)" ondragover="allowDrop(event)">

<div id="debugInfo" style="display:none;text-alignment:left;"> -${checkoutManager.serviceMode}- : -${displayType}- : -${displayEntity.currentAlert.alertStatus}- : -${username}- </div>

<div id="top" style="display:none; float:right;text-align:right;padding-left:10px;padding-right:5px"> <a href="#bottom"><fmt:message key="fcm.alert.goToBottom.txt"/></a></div>

<span id="dataPopErrorLabel" style="display:none"><fmt:message key="fcm.datapop.default.error.label.txt"/></span>
<span id="dataPopErrorMessage" style="display:none"><fmt:message key="fcm.datapop.default.error.message.txt"/></span>

<!-- begin extra banner buttons -->
<c:if test="${displayType != 'viewEntity' && displayType != 'viewAlert'}">
<tiles:insertTemplate template="callScriptVariables.jsp" flush="true" />
</c:if>

<script type="text/javascript">
parent.sas.fscf.banner.removeAllExtraButtons();

parent.sas.fscf.banner.addExtraButton("<fmt:message key="fcm.alert.timeZoneMaps.txt"/>", "maps", "frames[\'detail\'].openMapWin()", "&#xf2b6;");

<c:if test="${displayType != 'viewEntity' && displayType != 'viewAlert'}">
parent.sas.fscf.banner.addExtraButton("<fmt:message key="fcm.alert.pauseStats.txt"/>", "pause", "frames[\'detail\'].pauseStats(\'${displayEntity.currentAlert.id}\');sas.fscf.banner.removeAllExtraButtons()", "&#xf0a6;", "0.8rem");
parent.sas.fscf.banner.addExtraButton("<fmt:message key="fcm.alert.callScript.txt"/>", "call-script", "frames[\'detail\'].viewCallScript(\'viewCallScripts.action?method=viewCallScripts&alert=${displayEntity.currentAlert.id}\')", "&#xf257;", "0.8rem");
</c:if>

<c:if test="${empty alertAdminRequest}">
parent.sas.fscf.banner.addExtraButton("<fmt:message key='fcm.alert.summary.txt' />", "summary", "frames[\'detail\'].goToMain();sas.fscf.banner.removeAllExtraButtons()", "&#xf043;");
</c:if>

</script>
<!-- end extra banner buttons -->

<%-- ----------------------- Begin mainDiv ----------------------- --%>
<div id="mainDiv" style="display:none">

	<!-- Poll for new notifications, load this iframe after the account page is displayed -->
	<div align="left">
		<iframe name="pollNotificationsIframe" id="pollNotificationsIframe" src="blank.html"
			width="100%" height="0" frameborder="0" marginheight="0" marginwidth="0">
		</iframe>
	</div>
	<!-- Begin outer container div -->
	<div style="margin-left: 12px; margin-top: 12px; text-align: left;">

	<!-- ********************************** Confirmation Message *********************************** -->
	<c:if test="${not empty confirmationMessage and empty errorMessage}">
		<div style="display: block; margin: 10px 12px 10px 0px;" align="left">
			<tiles:insertDefinition name="fcmSystemMessages" flush="true">
				<tiles:putAttribute name="messageSuccessImage" value="common/images/MessageInform_24.gif"/>
			</tiles:insertDefinition>			
		</div>
	</c:if>
	<c:if test="${not empty confirmationMessage and not empty errorMessage}">
		<div style="display: block; margin: 10px 12px 10px 0px;" align="left">
			<tiles:insertDefinition name="fcmSystemMessages" flush="true"/>
		</div>
	</c:if>
	<c:if test="${not empty displayEntity.currentAlert and not empty displayEntity.currentAlert.warningMessage}">
		<div style="display: block; margin: 10px 12px 10px 0px;" align="left">
			<tiles:insertDefinition name="fcmSystemMessages" flush="true">
				<tiles:putAttribute name="warningMessage" value="${displayEntity.currentAlert.warningMessage}"/>
			</tiles:insertDefinition>
		</div>
	</c:if>

<%--
	"back to orignial entity" was removed, so remove the code of relatedEntityObj
	"back to original alert" is now managed by checkout manager

	viewState still references relatedToEntity and relatedToAlert, so create stub here for now
--%>
		<c:set var="relatedToEntity" value="{}" scope="request" />
		<c:set var="relatedToAlert" value="" scope="request" />


	<script type="text/javascript">
		$(document).ready(function(){
			updateViewState({
				keepSearchResults: '${esapi:encodeForJavaScript(param.keepSearchResults)}',
				relatedToAlert: '${relatedToAlert}',
				relatedToEntityObj: ${relatedToEntity}
			});
		});
	</script>

	<c:if test="${empty alertAdminRequest}">
		<script type="text/javascript">
			if (window.name=='FCMAlertDetailView') document.write('<div style="display:none">');
		</script>

		<c:if test="${updateAlerts  && checkoutManager.checkoutAvailable}">

			<c:if test="${inbound && displayType == 'viewAlert' && displayEntity.currentAlert.alertStatus == 'ACTIVE' and empty displayEntity.currentAlert.suspendUser}">
				<div style="margin-bottom:6px">
					<a href="#" onclick="checkout('${displayEntity.currentAlert.id}','${displayEntity.currentAlert.version}');">
						<img src="analyst/images/CheckOut.gif" style="vertical-align:middle;border:none" /> <fmt:message key="fcm.alert.checkOutThisAlert.txt"/>
					</a>
				</div>
			</c:if>
			<c:if test="${displayEntity.currentAlert.queue.disableForceCheckout==false}">
				<c:if test="${not empty displayEntity.currentAlert.checkoutUser and displayEntity.currentAlert.checkoutUser ne username and displayEntity.currentAlert.suspendUserCheckouts ==1
								or not empty displayEntity.currentAlert.suspendUser and displayEntity.currentAlert.suspendUser ne username and displayEntity.currentAlert.suspendUserCheckouts == 0}">
				<div style="margin-bottom:6px">
					<a href="#" onclick="forceCheckout('${displayEntity.currentAlert.id}','${displayEntity.currentAlert.version}')">
						<img src="analyst/images/ForceCheckOut.gif" style="vertical-align:middle;border:none" /> <fmt:message key="fcm.alert.forceCheckoutThisAlert.txt"/>
					</a>
				</div>
				</c:if>
			</c:if>

			<%-- permissions: can create manual and can update alerts --%>
			<c:if test="${manualAlerts && (displayType == 'viewEntity' || displayType == 'viewAlert' && displayEntity.currentAlert.alertStatus == 'CLOSED')}">
				<tiles:insertTemplate template="manualAlerts.jsp" flush="true"/>
			</c:if>
		</c:if>

			<c:if test="${addDataToLists || removeDataFromLists}">
				<c:if test="${not existEntityAnalystLists}">
				 	<div style="margin-bottom:6px">
						<fmt:message key="fcm.alert.noApplicableEntityAnalystLists.txt"/>
					</div>
				</c:if>
				<c:if test="${existEntityAnalystLists}">
				 	<div style="margin-bottom:6px">
						<a style="color: rgb(40, 126, 171);" href="#" onclick="getEntityAnalystLists('<esapi:encodeForHTMLAttribute><sfmfmt:getSensitiveDataKey entity="${displayEntity}"/></esapi:encodeForHTMLAttribute>');"><fmt:message key="fcm.alert.manageEntityOnAnalystLists.txt"/></a>
					</div>

<%-- Popup of Manage Displayed Entity On Analyst Lists --%>

<div id="entityAnalystLists"  style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F; padding-bottom:5px; display:none" draggable="true" ondragstart="drag(event)" >
<form>
	<table border="0" cellspacing="0" cellpadding="5" width="100%" >
	<tr><td style="font-weight:bold; background-color: #42668F;padding:4px;color:#FFF">
		<fmt:message key="fcm.alert.manageEntityOnAnalystLists.title.fmt.txt"><fmt:param><sfmmsk:maskData value="${displayEntity.entityID}" maskType="ID" /></fmt:param></fmt:message>
	</td></tr>
	<tr><td>
	<table cellspacing="0" cellpadding="2" width="100%" class="mainTable txn-data-table" style="border-bottom: 2px solid;">
		<thead>
			<tr>
				<th class="tableHeader"><fmt:message key="fcm.alert.manageEntityOnAnalystLists.select.txt"/></th>
				<th class="tableHeader"><fmt:message key="fcm.alert.manageEntityOnAnalystLists.listName.txt"/></th>
				<th class="tableHeader"><fmt:message key="fcm.alert.manageEntityOnAnalystLists.addedAt.txt"/></th>
				<th class="tableHeader"><fmt:message key="fcm.alert.manageEntityOnAnalystLists.addedBy.txt"/></th>
				<th class="tableHeader"><fmt:message key="fcm.alert.manageEntityOnAnalystLists.result.txt"/></th>
			</tr>
		</thead>
		<tbody>
			<tr id="entityAnalystListResult"><td align='center' colspan='5'><img src='common/images/spinner16.gif'/></td>
			</tr>
		</tbody>
	</table>
	</td></tr>
	<tr><td align="center">
			<c:if test="${addDataToLists}">
				<input type="button" name="add" onclick="return updateEntityAnalystLists('<esapi:encodeForHTMLAttribute><sfmfmt:getSensitiveDataKey entity="${displayEntity}"/></esapi:encodeForHTMLAttribute>', 'ADD');" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.manageEntityOnAnalystLists.add.txt"/></esapi:encodeForHTMLAttribute>"/>
			</c:if>
			<c:if test="${removeDataFromLists}">
				<input type="button" name="remove" onclick="return updateEntityAnalystLists('<esapi:encodeForHTMLAttribute><sfmfmt:getSensitiveDataKey entity="${displayEntity}"/></esapi:encodeForHTMLAttribute>', 'REMOVE');" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.manageEntityOnAnalystLists.remove.txt"/></esapi:encodeForHTMLAttribute>"/>
			</c:if>
			<input type="button" name="cancel" onclick="$('#entityAnalystLists').hide(); return false;" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.tran.updateAnalystList.cancel.txt"/></esapi:encodeForHTMLAttribute>"/>
			<input type="button" name="close" onclick="$('#entityAnalystLists').hide(); return false;" value="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.tran.updateAnalystList.close.txt"/></esapi:encodeForHTMLAttribute>"/>
	</td></tr>
	</table>
</form>
</div>

				</c:if>
			</c:if>


		<script type="text/javascript">
			if (window.name=='FCMAlertDetailView') document.write('</div>');
		</script>

	</c:if>

	<%-- Begin Reveal Sensitive Data Section --%>
	<tiles:insertTemplate template="/common/displayRevealLinkT3.jsp" flush="true">
		<tiles:putAttribute name="revealFunction" value="refreshURL('false')" />
	</tiles:insertTemplate>
	<%-- End Reveal Sensitive Data Section --%>


<c:set var="refreshURL" value="refreshURL(true)" scope="request"/>
<script type="text/javascript">
function refreshURL(mask)
{
<c:choose>
	<c:when test="${displayType == 'viewEntity'}">
		viewEntity(<sfmfmt:entityToJSON entity="${displayEntity}"/>,mask);
	</c:when>
	<c:otherwise>
		reloadEntity('${displayEntity.currentAlert.id}','${displayEntity.currentAlert.version}',mask);
	</c:otherwise>
</c:choose>
}
</script>



	<table id="warningTable" class="minWidthTableX" border="0" cellspacing="0" cellpadding="0" style="display:none; margin-top: 6px;">
		<tr>
			<td width="99%"><div class="tabs">
				<ul>
					<span onclick="${refreshURL}" style="padding-right:10px; cursor:pointer;"> <img src="analyst/images/refresh.gif" class="icon" width="16" height="16"/> <fmt:message key='fcm.alert.refresh.txt'/></span>

					<c:if test="${updateAlerts and not checkoutManager.isGroupedByPrimaryContact(displayEntity)}">
						<span onclick="switchAlert(true, '${checkoutManager.checkoutContains(checkoutManager.primaryAlert.id) ? 1 : 2}', '${checkoutManager.primaryAlert.id}')" style="padding-right:10px; cursor:pointer;" >
							<img src="analyst/images/PointerLeft.gif" class="icon"/> <fmt:message key="fcm.alert.backToOriginalAlert.txt"/>
						</span>
					</c:if>

					<c:if test="${displayEntity.externalMemos}">
						<li style="float:right;padding-left:2px;"><span><img src="analyst/images/externalMemos.gif" class="icon" border="0" width="16" height="16" title="<fmt:message key="fcm.alert.externalMemosExist.txt"/>"/></span></li>
					</c:if>
					<c:if test="${displayEntity.realTime and showWarning}">
						<li style="float:right;padding-top:2px;"><span class='highRiskWarning' style="padding-left: 12px; width: 100%;text-align: right;">${esapi:encodeForHTML(displayEntity.currentAlert.queue.warningMsg)}</span></li>
					</c:if>

					<c:if test="${!displayEntity.realTime and realTimeDemographicsEnabled}">
						<li style="float:right;padding-top:2px;"><span style="padding-left: 12px; width: 100%; color: #E00; text-align: right;"><fmt:message key="fcm.alert.unableToRetrieve.txt"/></span></li>
					</c:if>

					<li id="ws" style="float:right;padding-top:2px;"></li>
					</ul>
				</div>
			</td>
		</tr>
	</table>

<table border="0" cellspacing="0" cellpadding="0" style="margin-top: 6px;margin-bottom: 6px; width: 100%;">
<tr>
	<td style="padding-right:6px;vertical-align:top; width: 100%;">

	<%-- ********************************** BEGIN FIRST TAB GROUP *********************************** --%>
<form>
	<table border="0" cellspacing="0" cellpadding="0" style="width: 100%;">
		<thead>
			<tr>
				<td><div id="entityTabs" class="tabs" >
						<ul>
						<c:set var="hasContactOrParent" value="${not empty displayEntity.contactID or not empty displayEntity.parentEntityID}"/>

						<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'FIRST_TAB'}">
							<li id="entityTab" class="current">
							<a href="javascript:;" onmousedown="swapGridContents('entity',1);"><span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>">
							<img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/> : <sfmmsk:maskData value="${displayEntity.entityID}" maskType="ID" /></span></a>
							</li>
						</c:if>

						<c:choose>
						<c:when test="${not empty displayEntity.contactID}">
							<li  id="entitiesTab" class="current"><a href="javascript:;" onmousedown="swapGridContents('entities',1);">
							<span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>"><img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.contactType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.contactType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.contactType.type}" bundle="${alertTypeLabelResourceBundle}"/>	: <sfmmsk:maskData value="${displayEntity.contactID}" maskType="ID" /></span>
							</a></li>
						</c:when>
						<c:when test="${not empty displayEntity.parentEntityID}">
							<li  id="entitiesTab" class="current"><a href="javascript:;" onmousedown="swapGridContents('entities',1);">
							<span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>"><img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.parentEntityType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.parentEntityType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.parentEntityType.type}" bundle="${alertTypeLabelResourceBundle}"/> : <sfmmsk:maskData value="${displayEntity.parentEntityID}" maskType="ID" /></span>
							</a></li>
						</c:when>
						<c:otherwise>
							<li id="entityTab" class="current"><a href="javascript:;" onmousedown="swapGridContents('entity',1);">
							<span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>"><img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/> : <sfmmsk:maskData value="${displayEntity.entityID}" maskType="ID" /></span>
							</a></li>
						</c:otherwise>
						</c:choose>

						<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'SECOND_TAB'}">
							<li id="entityTab">
							<a href="javascript:;"  onmousedown="swapGridContents('entity',1);"><span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>">
							<img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/> : <sfmmsk:maskData value="${displayEntity.entityID}" maskType="ID" /></span></a>
							</li>
						</c:if>

						<c:if test="${not empty displayEntity.contactDetails}">
							<li id="contactTab"><a href="javascript:;" onmousedown="swapGridContents('contact',1);">
							<span><fmt:message key="fcm.alert.contact.txt"/></span></a></li>
						</c:if>
						<c:if test="${not empty displayEntity.demographics}">
							<li id="demographicsTab"><a href="javascript:;" onmousedown="swapGridContents('demographics',1);">
							<span><fmt:message key="fcm.alert.demographics.txt"/></span></a></li>
						</c:if>

						<c:if test="${not empty displayEntity.verifications}">
							<li id="verificationTab"><a href="javascript:;" onmousedown="swapGridContents('verification',1);">
							<span><fmt:message key="fcm.alert.verification.txt"/></span></a></li>
						</c:if>
						<c:if test="${not empty displayEntity.relatedContacts}">
							<li id="relatedTab"><a href="javascript:;" onmousedown="swapGridContents('related',1);" ><span><fmt:message key="fcm.alert.relatedContacts.txt"/></span></a></li>
						</c:if>

						<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'LAST_TAB'}">
							<li id="entityTab">
							<a href="javascript:;"  onmousedown="swapGridContents('entity',1);"><span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>">
							<img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/> : <sfmmsk:maskData value="${displayEntity.entityID}" maskType="ID" /></span></a>
							</li>
						</c:if>

						</ul>
					</div></td>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>
				<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'FIRST_TAB'}">
					<tiles:insertTemplate template="alertInfoWide.jsp" flush="true" />
				</c:if>

				<c:choose>
					<c:when test="${not empty displayEntity.contactID}">
						<tiles:insertTemplate template="entityList.jsp" flush="true" />
					</c:when>
					<c:when test="${not empty displayEntity.parentEntityID}">
						<tiles:insertTemplate template="entityList.jsp" flush="true" />
					</c:when>
					<c:otherwise>
						<tiles:insertTemplate template="alertInfoWide.jsp" flush="true"/>
					</c:otherwise>
				</c:choose>

				<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'SECOND_TAB'}">
					<tiles:insertTemplate template="alertInfoWide.jsp" flush="true" />
				</c:if>

					<c:if test="${not empty displayEntity.contactDetails}">
						<tiles:insertTemplate template="contactDetails.jsp" flush="true"/>
					</c:if>
					<c:if test="${not empty displayEntity.demographics}">
						<tiles:insertTemplate template="demographics.jsp" flush="true" />
					</c:if>
					<c:if test="${not empty displayEntity.verifications}">
						<tiles:insertTemplate template="verification.jsp" flush="true" />
					</c:if>
					<c:if test="${not empty displayEntity.relatedContacts}">
						<tiles:insertTemplate template="relatedContacts.jsp" flush="true"/>
					</c:if>

					<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'LAST_TAB'}">
						<tiles:insertTemplate template="alertInfoWide.jsp" flush="true" />
					</c:if>

				</td>
			</tr>
		</tbody>
	</table>
</form>
</td>
<td>
	<c:if test="${hasContactOrParent and alertInfoPanelDisplay eq 'SPLIT'}">
	<table border="0" cellspacing="0" cellpadding="0">
		<thead>
			<tr>
				<th style="margin:0px;padding:0px;border:0px" nowrap>
					<div class="tabs">
						<ul><li id="entityTab" class="current">
							<a href="javascript:;" ><span onclick="copyToClipboard($(this).text().substr($(this).text().indexOf(': ')+2))" title="<fmt:message key='fcm.alert.clickToCopy.txt'/>">
							<img style="margin-top:-1px" src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
							<fmt:message key="${displayEntity.entityType.type}" bundle="${alertTypeLabelResourceBundle}"/> : <sfmmsk:maskData value="${displayEntity.entityID}" maskType="ID" /></span></a>
							</li>
						</ul>
					</div>
				</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>
					<tiles:insertTemplate template="alertInfo.jsp" flush="true"/>
				</td>
			</tr>
		<tbody>
	</table>
	</c:if>

</td></tr>
</table>
	<%-- *********************************** END FIRST TAB GROUP ************************************ --%>

	<%-- ********************************** BEGIN SECOND TAB GROUP ********************************** --%>
	<form name="alertForm" action="wrapupAlert.action" method="post"><%-- TODO: margin:0px --%>

		<div id="linkedEntityTransactionFilter" style="overflow:auto;height:12.1em;white-space: nowrap;padding:2px;position:absolute; z-index:99; border:2px outset #c6cad0; background-color:white; display:none;">
			<ul style="list-style:none; margin:0;background-color:#fff;">
				<li id="${displayEntity.entityType}_self" class="selectedTxnFilter" onclick="viewEntityTransactions(this,<sfmfmt:entityToJSON entity="${displayEntity}"/>,${displayEntity.gridTemplateId},'${displayType}');">
				<img src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
					<a href="#" onclick="return false;"><fmt:message key="fcm.alert.transactions.current.txt"/></a>
				</li>
			<c:forEach var="entity" items="${displayEntity.linkedEntities}">
				<c:if test="${entity.entityID ne displayEntity.entityID or entity.entityType ne displayEntity.entityType}">
					<c:set var="tranFilterIdAttr">
						<c:choose>
							<c:when test="${entity.entityID eq displayEntity.parentEntityID and entity.entityType eq displayEntity.parentEntityType}"> id="${entity.entityType}_parent" </c:when>
							<c:when test="${entity.entityID eq displayEntity.contactID and entity.entityType eq displayEntity.contactType}"> id="${entity.entityType}_contact" </c:when>
						</c:choose>
					</c:set>
					<li ${tranFilterIdAttr} onclick="viewEntityTransactions(this,<sfmfmt:entityToJSON entity="${entity}"/>,${displayEntity.gridTemplateId},'${displayType}');">
					<img src="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${entity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
						<a href="#" onclick="return false;"> <sfmmsk:maskData value="${entity.entityID}" maskType="ID" /> </a>
					</li>
				</c:if>
			</c:forEach>
			</ul>
		</div>

		<div id="entityTransactionsContainer" style="margin-top: 6px;">
<%-- load transactions later based on the displayEntity.entityType.tranViewAlertType
			<c:set var="entityTransactions" value="${displayEntity.transactions}" scope="request"/>
--%>
			<tiles:insertTemplate template="trans.jsp" flush="true"/>
		</div>

		<div id="entityTransactionsRequestIcon" style="display:none;position:absolute;">
			<img src="common/images/spinner16.gif" border="0" height="16" width="16" class="icon" />
			<fmt:message key="fcm.entity.loading.transactions.txt"/>
		</div>

		<div id="rulesFired" style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F; top: 0px; display: none">
			<table cellpadding="0" cellspacing="0" border="0">
				<tr><td id="rulesFiredTitle" style="font-weight: bold; background-color: #42668F; color: white; padding: 4px;"><fmt:message key="fcm.alert.rulesFiredTitle.txt"/></td>
					<td style="background-color: #42668F;padding: 4px;" align="right"><img src="common/images/closeX.gif" onmousedown="closeDataForTxn('rulesFired'); return false" style="cursor:pointer" alt="" width="16" height="16"/></td></tr>
				<tr><td colspan="2" style="padding:4px">
						<div class="scrollableGrid" onscroll="repositionTHs(this)" >
							<table id="rulesFiredTable" cellpadding="2" cellspacing="0" border="0">
								<thead>
									<tr>
										<%--<th style="background-color: #fff">&nbsp;</th> --%>
										<th style="background-color: #fff"><fmt:message key="fcm.alert.rulesFiredName.txt"/></th>
										<th style="background-color: #fff"><fmt:message key="fcm.alert.rulesFiredReason.txt"/></th>
									</tr>
								</thead>
								<tbody id="rulesFiredTableBody">
								</tbody>
							</table>
						</div>
					</td>
				</tr>
			</table>
		</div>

		<div id="txnFraudAlerts" style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F; top: 0px; display: none">
			<table cellpadding="0" cellspacing="0" border="0">
				<tr><td id="txnFraudAlertsTitle" style="font-weight: bold; background-color: #42668F; color: white; padding: 4px;"><fmt:message key="fcm.alert.txnFraudAlertsTitle.txt"/></td>
					<td style="background-color: #42668F;padding: 4px;" align="right"><img src="common/images/closeX.gif" onmousedown="closeDataForTxn('txnFraudAlerts'); return false" style="cursor:pointer" alt="" width="16" height="16"/></td></tr>
				<tr><td colspan="2" style="padding:4px">
						<div class="scrollableGrid" onscroll="repositionTHs(this)" >
							<table id="txnFraudAlertsTable" cellpadding="2" cellspacing="0" border="0">
								<thead>
									<tr>
										<th style="background-color: #fff"></th><%-- holds the Add to Worklist image --%>
										<th style="background-color: #fff"><fmt:message key="fcm.alert.txnFraudAlertsValue.txt"/></th>
									</tr>
								</thead>
								<tbody id="txnFraudAlertsTableBody">
								</tbody>
							</table>
						</div>
					</td>
				</tr>
			</table>
		</div>

	<%-- *********************************** END SECOND TAB GROUP *********************************** --%>

<c:if test="${displayType != 'viewEntity'}">
<div>
	<table class="minWidthTableX" border="0" cellspacing="0" cellpadding="0" style="margin-top:6px;" width="100%">
		<thead>
			<tr>
				<th style="margin:0px;padding:0px;border:0px" nowrap>
					<div id="wrapUpTabs" class="tabs">
						<ul>
							<c:if test="${displayType == 'updateAlert'}">
								<li id="wrapTab"><a href="javascript:;" onmousedown="swapGridContents('wrap',2);"><span><fmt:message key="fcm.alert.callWrapUp.txt"/></span></a></li>
							</c:if>
							<li id="alertActivityTab" class="current" style="float:left;padding-top:2px;"><a href="javascript:;" onmousedown="swapGridContents('alertActivity',2);"><span><fmt:message key="fcm.alert.alertActivity.history.txt"/></span></a>
							</li>
							<li style="float:left;padding-top:2px;"><img src="analyst/images/defaultView.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key='fcm.alert.setActivityDisplayDefault.txt'/></esapi:encodeForHTMLAttribute>" onclick="showActivityDisplayOption();"/>
							</li>
						</ul>
					</div>
				</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td>
					<c:if test="${updateAlerts && displayType == 'updateAlert'}">
						<tiles:insertTemplate template="wrapUp.jsp" flush="true"/>
					</c:if>
					<tiles:insertTemplate template="alertActivity.jsp" flush="true"/>
				</td>
			</tr>
	</table>

	<script>
		$(document).ready(function(){
			if ($("#wrapTab").length > 0)
				swapGridContents('wrap',2);
			if (activityDisplayOption.showHistory)
				swapGridContents('alertActivity',2);

			<c:if test="${empty displayEntity.currentAlert.alertActivity}">
			disableTab('alertActivity');
			</c:if>
		});
	</script>
</div>
</c:if>

<div id="bottom" style="float:right;text-align:right;padding-right:5px" > <a href="#warningTable"><fmt:message key="fcm.alert.backToTop.txt"/></a></div>

	<!-- End outer container div -->
	<table width="100%" cellpadding="0" cellspacing="0" style="margin-top: 12px;">
		<tr id="logon_footer" class="logon_footer">
			<td colspan="2"><img src="common/images/spacer.gif" height="18" width="1" alt=""/></td>
		</tr>
	</table>
</form>


<div id="alertData" class="errorMessage" style="display:none;position:absolute;padding:1px;" onclick="$(this).hide();">
	<img src="common/images/closeX.gif" border="0" height="16" width="16" class="icon" />
</div>

<%-- ----------------------- End mainDiv ----------------------- --%>

<script type="text/javascript">
<%-- Load the notifications polling iframe --%>
	frames[ "pollNotificationsIframe" ].location.href = '<c:url value="/pollNotifications.action"/>';
</script>

<script type="text/javascript">

	var $mainForm = $(document.alertForm);
	var isAdminView = ${not empty alertAdminRequest};

	$(document).ready(function(){

		<c:choose>
			<c:when test="${hasContactOrParent and alertInfoPanelDisplay eq 'SECOND_TAB'}">
				$("#entityGrid").hide();
			</c:when>
			<c:when test="${hasContactOrParent and alertInfoPanelDisplay eq 'LAST_TAB'}">
				$("#entityGrid").hide();
			</c:when>
			<c:otherwise>
				$("#entityTabs li > a").first().mousedown();
			</c:otherwise>
		</c:choose>

		if ( $("#warningTable li").length > 0) $("#warningTable").show();
		// show default view of transactions
		<c:choose>

		<c:when test="${displayEntity.entityType.tranViewAlertType eq displayEntity.entityType.type}">
			$('#${displayEntity.entityType}_self').click();
		</c:when>
		<c:when test="${displayEntity.entityType.tranViewAlertType eq displayEntity.entityType.contactType and not empty displayEntity.contactID}">
			$('#${displayEntity.contactType}_contact').click();
		</c:when>
		<c:when test="${displayEntity.entityType.tranViewAlertType eq displayEntity.entityType.parentType and not empty displayEntity.parentEntityID}">
			$('#${displayEntity.parentEntityType}_parent').click();
		</c:when>
		<c:otherwise>
			$('#${displayEntity.entityType}_self').click();
		</c:otherwise>
		</c:choose>

		// save $mainForm initial values and attach isDirty method
		var initForm = $mainForm.serialize();
		var initMarkings = getCurrentMarkingsStr();
		$mainForm.isDirty = function () {
			return (initForm != $(this).serialize() || initMarkings != getCurrentMarkingsStr());
		};
	});
</script>
</body>
</html>