<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>
<c:set var="demographics" value="${displayEntity.demographics.details}"/>
<c:set var="group" value="${displayEntity.demographics.name}"/>

<%-- begin demographics grid --%>
<div id="demographicsGrid"  style="display:none; border: 0px none; overflow-x: hidden; overflow-y: auto;">

<table class="mainTable minWidthTableX" border="0" cellspacing="0" cellpadding="2" style="border-top: none; width:100%;">
	<c:set var="rows" value="5" />
	<c:set var="cols" value="3" />
	<c:set var="cells" value="${fn:length(demographics)}" />

	<c:if test="${cells gt 15}">
		<c:set var="rows" value="${sfmfn:ceil(cells/cols)}"/>
	</c:if>
<%--
	<c:if test="${cells gt 15 and cells le 30}">
		<c:set var="cols" value="${sfmfn:ceil(cells/rows)}"/>
	</c:if>
	<c:if test="${cells gt 30}">
		<c:set var="cols" value="6" />
		<c:set var="rows" value="${sfmfn:ceil(cells/cols)}"/>
	</c:if>
--%>


	<c:forEach var="i" begin="0" end="${rows-1}">
		<c:set var="cssClass" value="dataRow2_tableRow" />
		<c:if test="${i%2 eq 1}">
			<c:set var="cssClass" value="dataRow1_tableRow" />
		</c:if>

		<tr class="${cssClass}">
			<c:set var="j" value="${i * cols}"/>
			<c:set var="num" value="0"/>
			<c:forEach begin="${j}" end="${j + cols - 1}" var="detail" items="${demographics}" varStatus="loop">
				<c:if test="${loop.last}">
					<c:set var="num" value="${loop.count}"/>
				</c:if>
				<td style="white-space:nowrap">
					<c:set var="demoLabel"><fmt:message key="${group}.${detail.name}" bundle="${entityDetailsResourceBundle}" /></c:set>
					${esapi:encodeForHTML(demoLabel)}
				</td>
				<td style="white-space:nowrap" class="textTableCell ${loop.count == cols ? 'lastCol' : ''}"><sfmfmt:formatDetail detail="${detail}"  timeZone="${userTimeZone}" /></td>
			</c:forEach>
			<c:forEach begin="${num}" end="${cols-1}" varStatus="loop2">
				<td style="white-space:nowrap">&nbsp;</td>
				<td style="white-space:nowrap" class="textTableCell ${loop2.last ? 'lastCol' : ''}">&nbsp;</td>
			</c:forEach>
		</tr>
	</c:forEach>
</table>
</div>
<script type="text/javascript">
	$(document).ready(function(){

		if ($("#demographicsGrid").height() > refSize.height)
		{
			$("#demographicsGrid").height( refSize.height );
		}
	});
</script>

