<!DOCTYPE html>
<%-- use leading tabs only, no spaces please --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<%-- TODO: strange currency characters without this --%>
<%-- fmt:setLocale value="en_US"/ --%>
<html>
<head>
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<title><fmt:message key="fcm.alert.alertCallScripts.txt" /></title>

<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_base/fonts.css" type="text/css"/>
<link rel="stylesheet" href="resources/sap/ui/core/themes/sas_corporate/library.css" type="text/css">
<link rel="stylesheet" href="resources/sap/ui/commons/themes/sas_corporate/library.css" type="text/css">
<link rel="stylesheet" href="resources/sas/hc/ui/core/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="resources/sas/hc/ui/commons/themes/sas_corporate/library.css" type="text/css"/>
<link rel="stylesheet" href="resources/sap/m/themes/sas_corporate/library.css" type="text/css"/>
<link rel='stylesheet' href='analyst/styles/entity.css' type='text/css'/>
<style type='text/css'>@import 'admin/styles/admin.css';</style><%-- TODO: we shouldn't be using admin.css here --%>

<script language='JavaScript' src='common/scripts/jquery.js'></script>
<script language='JavaScript' src='common/scripts/sasSolutions.js'></script>
<script language='JavaScript' src='common/scripts/cf.js'></script>
</head>
<body>

<script language="JavaScript">
	var _scripts = [];
	<c:forEach var="callScript" items="${alertCallScripts}" >
		_scripts.push('${esapi:encodeForJavaScript(callScript.text)}');
	</c:forEach>

	// Dynamic call script
	function getScriptVariableValue(variable)
	{
		var value = opener.callScriptVariables[variable];

		if(!isDefined(value))// this is not a call script variable
			return null;

		// trim trailing spaces
		value = value.replace(/\s+$/,'');
		if(value.length == 0) // no value exists
			return '???'+variable+'???';
		else
			return value;
	}

	function showCallScript(index)
	{
		var scriptElement = document.getElementById('scriptText');
		if(!scriptElement) return;

		var re = /(^|\W)&(\w+)/g;
		var variableMap = {};

		while(re.test(_scripts[index]) == true)
		{
			var variable = RegExp.$1 + "&" + RegExp.$2;
			if(!variableMap[variable]) //lookup value if not already found
			{
				var value = getScriptVariableValue(RegExp.$2);
				if(value != null) // a value was found
				{
					variableMap[variable] = RegExp.$1 + value;
				}
			}
		}

		// Do global subsitution
		for(var variable in variableMap)
		{
			_scripts[index] = _scripts[index].replace(new RegExp(variable,"g"),variableMap[variable]);
		}

		// Since this may contain HTML escapes set to innerHTML
		scriptElement.innerHTML = _scripts[index].replace(/\n/g, "<br/>");
	}

$(document).ready(function(){
	$("#callScriptSelect").change();
});
</script>

	<table class="mainTable" border="2" cellspacing="0" cellpadding="0" width="100%" height="100%">
		<c:if test="${empty alertCallScripts}" >
			<tr class="configurationTableDataRow" >
				<th class="configurationTableTitle" style="padding-right:6px;" align="left"><fmt:message key="fcm.alert.noCallscripts.txt" /></th>
			</tr>
			<tr class="configurationTableDataRow">
				<td style="height:100%">&nbsp;</td>
			</tr>
		</c:if>
		<c:if test="${not empty alertCallScripts}" >
			<tr class="configurationTableDataRow" >
				<th class="configurationTableTitle" style="padding-right:6px;" align="left" nowrap>
					<fmt:message key="fcm.alert.callScript2.txt" /> &nbsp;
					<select id="callScriptSelect" class="famSelect" onChange="showCallScript(this.selectedIndex)">
						<c:forEach var="callScript" items="${alertCallScripts}" >
							<c:set var="selAttr" value=""/>
							<c:if test="${defaultCallScript == callScript.id}">
								<c:set var="selAttr" value="selected=\"selected\""/>
							</c:if>
							<c:if test="${fn:length(callScript.name) > 50}">
								<option value="${callScript.id}" ${selAttr}>${esapi:encodeForHTML(fn:substring(callScript.name,0,50))} ....</option>
							</c:if>
							<c:if test="${fn:length(callScript.name) <= 50}">
								<option value="${callScript.id}" ${selAttr}>${esapi:encodeForHTML(callScript.name)}</option>
							</c:if>
						</c:forEach>
					</select>
				</th>
			</tr>
			<tr class="configurationTableDataRow">
				<td style="height:100%">
					<div id="scriptText" style="text-align:left;vertical-align: top;text-valign:left;height:100%;overflow:auto;"></div>
				</td>
			</tr>
		</c:if>
	</table>
</body>
</html>