<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

	<!-- ********************************** Begin Alert Info *********************************** -->
	<c:if test="${not empty displayEntity.systemBlock1.label && displayEntity.systemBlock1.label != ' '}">
		<c:set var="primaryBlockClassStr" value="class='primaryBlock'" />
	</c:if>
	<c:if test="${not empty displayEntity.systemBlock2.label && displayEntity.systemBlock2.label != ' '}">
		<c:set var="secondaryBlockClassStr" value="class='secondaryBlock'" />
	</c:if>
	<c:if test="${not empty displayEntity.transactionBlock.label && displayEntity.transactionBlock.label != ''}">
		<c:set var="transactionBlockClassStr" value="class='transactionBlock'" />
	</c:if>

<div id="entityGrid" class="u-border" style="width:300px; height:11.5em;overflow-x:hidden;overflow-y: auto;">

	<table border="0" cellspacing="0" cellpadding="0" width="100%">
		<tbody>
			<c:if test="${displayType ne 'viewEntity'}">
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.alertReason.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">${esapi:encodeForHTML(displayEntity.currentAlert.alertReason)} &nbsp;</td>
				</tr>
				<c:choose>
					<c:when test="${changedStrategy=='true'}">
					<tr class="dataRow2_tableRow">
						<td style="color:#E00"><fmt:message key="fcm.alert.strategy.txt"/>***: (<fmt:message key="fcm.alert.changed.txt"/>)</td>
					</tr>
					<tr class="dataRow1_tableRow">
						<td class="textTableCell wrapable" color="red">${esapi:encodeForHTML(displayEntity.currentAlert.strategyDescription)} &nbsp;</td>
					</tr>
					</c:when>
					<c:otherwise>
					<tr class="dataRow2_tableRow">
						<td class="textTableCell wrapable"><fmt:message key="fcm.alert.strategy.txt"/>:</td>
					</tr>
					<tr class="dataRow1_tableRow">
						<td class="textTableCell wrapable">${esapi:encodeForHTML(displayEntity.currentAlert.strategyDescription)}&nbsp;</td>
					</tr>
					</c:otherwise>
				</c:choose>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.queue.txt"/></td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">${esapi:encodeForHTML(displayEntity.currentAlert.queue.name)} &nbsp;</td>
				</tr>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.alertId.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">${displayEntity.currentAlert.id} &nbsp;</td>
				</tr>

			</c:if>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.transactionBlock.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td  class="textTableCell wrapable">
						<span ${transactionBlockClassStr}>${esapi:encodeForHTML(displayEntity.transactionBlock.label)}</span> &nbsp;
						<c:if test="${not empty displayEntity.transactionBlock.creationDateTime}">
							<br><fmt:message key="fcm.alert.blockSince.txt"/>: <esapi:encodeForHTML><fmt:formatDate value="${displayEntity.transactionBlock.creationDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
						</c:if>
						<c:if test="${not empty displayEntity.transactionBlock.expirationDateTime}">
							<br><fmt:message key="fcm.alert.expiration.txt"/>: <esapi:encodeForHTML><fmt:formatDate value="${displayEntity.transactionBlock.expirationDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
						</c:if>
					</td>
				</tr>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.systemBlock1.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td  class="textTableCell wrapable"><span ${primaryBlockClassStr}>${esapi:encodeForHTML(displayEntity.systemBlock1.label)}</span> &nbsp;
						<c:if test="${not empty displayEntity.systemBlock1.creationDateTime}">
							<br><fmt:message key="fcm.alert.blockSince.txt"/>: <esapi:encodeForHTML><fmt:formatDate value="${displayEntity.systemBlock1.creationDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
						</c:if>
						<c:if test="${not empty displayEntity.systemBlock1.expirationDateTime}">
							<br><fmt:message key="fcm.alert.expiration.txt"/>: <esapi:encodeForHTML><fmt:formatDate value="${displayEntity.systemBlock1.expirationDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
						</c:if>
					</td>
				</tr>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.systemBlock2.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td  class="textTableCell wrapable"><span ${secondaryBlockClassStr}>${esapi:encodeForHTML(displayEntity.systemBlock2.label)}</span> &nbsp;
						<c:if test="${not empty displayEntity.systemBlock2.creationDateTime}">
							<br><fmt:message key="fcm.alert.blockSince.txt"/>: <esapi:encodeForHTML><fmt:formatDate value="${displayEntity.systemBlock1.creationDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
						</c:if>
						<c:if test="${not empty displayEntity.systemBlock2.expirationDateTime}">
							<br><fmt:message key="fcm.alert.expiration.txt"/>: <esapi:encodeForHTML><fmt:formatDate value="${displayEntity.systemBlock1.expirationDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
						</c:if>
					</td>
				</tr>
				<tr class="dataRow2_tableRow">
					<td  class="textTableCell wrapable"><fmt:message key="fcm.alert.multiOrg.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">
					<c:choose>
						<c:when test="${(callCenterType eq 'P') or (displayEntity.currentAlert.tenantType eq 'P') or (displayEntity.currentAlert.tenantOrgNodeId eq displayEntity.currentAlert.orgNodeId)}">${esapi:encodeForHTML(displayEntity.currentAlert.orgNodeLabel)}</c:when>
						<c:otherwise>${esapi:encodeForHTML(displayEntity.currentAlert.tenantOrgNodeLabel)} : ${esapi:encodeForHTML(displayEntity.currentAlert.orgNodeLabel )}</c:otherwise>
					</c:choose>
					&nbsp;
					</td>
				</tr>

			<%-- it's an alert, show additional alert info --%>
			<c:if test="${displayType ne 'viewEntity'}">
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.alertCreation.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable"><esapi:encodeForHTML><fmt:formatDate value="${displayEntity.currentAlert.creationTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML> &nbsp;</td>
				</tr>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.lastAction.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable"><esapi:encodeForHTML><fmt:formatDate value="${displayEntity.currentAlert.lastService}" pattern="${dateFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML> &nbsp;</td>
				</tr>
				<tr class="dataRow2_tableRow">
					<td class="textTableCell wrapable"><fmt:message key="fcm.alert.alertStatus.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable"><sfmfmt:formatAlertStatus value="${displayEntity.currentAlert}"/> &nbsp;</td>
				</tr>
			</c:if>

				<tr class="dataRow2_tableRow">
					<td><fmt:message key="fcm.alert.blockGroupAssigner.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">${esapi:encodeForHTML(displayEntity.blockGroupCode)} &nbsp;</td>
				</tr>

			<c:if test="${not empty displayEntity.parentEntityID}">
				<tr class="dataRow2_tableRow">
					<td  class="textTableCell wrapable"><fmt:message key="fcm.alert.parentEntity.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">
						<img src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.parentEntityType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.entityType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
						<a href="#" onclick="$('#nav_parent').click();"> <sfmmsk:maskData value="${displayEntity.parentEntityID}" maskType="ID" /></a>
					&nbsp;
					</td>
				</tr>
			</c:if>

			<c:if test="${not empty displayEntity.contactID and displayEntity.contactID ne displayEntity.entityID and displayEntity.contactType ne displayEntity.entityType}">
				<tr class="dataRow2_tableRow">
					<td  class="textTableCell wrapable"><fmt:message key="fcm.alert.contactEntity.txt"/>:</td>
				</tr>
				<tr class="dataRow1_tableRow">
					<td class="textTableCell wrapable">
						<img src="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.contactType}" bundle="${alertTypeImageResourceBundle}"/></esapi:encodeForHTMLAttribute>" alt="<esapi:encodeForHTMLAttribute><fmt:message key="${displayEntity.contactType}" bundle="${alertTypeLabelResourceBundle}"/></esapi:encodeForHTMLAttribute>" class="icon" width="16" height="16"/>
						<a href="#" onclick="$('#nav_contact').click();"> <sfmmsk:maskData value="${displayEntity.contactID}" maskType="ID" /></a>
					&nbsp;
					</td>
				</tr>
			</c:if>

		</tbody>
	</table>
</div>
	<%-- ********************************** End Alert Info *********************************** --%>
