<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<script>
var actionMemos = [];
<c:forEach var="activityHolder" items="${alertActivityHolderList}" varStatus="loop">
	<c:set var="activity" value="${activityHolder.activity}"/>
	 addActionMemo(${activity.actionId}, ${activity.memoSize}, ${fn:length(activity.memoPreview)});
</c:forEach>

var memoRetrieveOption = {threshold: 100000, maxCount: 10};
var activityDisplayOption = {};
activityDisplayOption.showHistory=Boolean(getCookie('activityDisplayOption.showHistory', false));
activityDisplayOption.threshold = getCookie('activityDisplayOption.threshold', 500);
activityDisplayOption.asHTML= ${enableHTML};

$(document).ready(function(){
	$("#alertActivityDisplayOptionPrompt").find(":checkbox").prop("checked", activityDisplayOption.showHistory);
	$("#alertActivityDisplayOptionPrompt").find(":text").val(activityDisplayOption.threshold);
});



</script>

<div id="alertActivityGrid" class="scrollableGridHistory u-border-alertActivityGrid" onscroll="repositionTHs(this)" style="">
<table class="mainTable minWidthTableX" id="alertActivityTable" border="0" cellspacing="0" cellpadding="2" style="width:100%;border-width:0px;border-collapse:separate;">
	<thead>
		<tr class="tableColumnHeaderRow">
			<th class="centeredTableHeader"></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.date.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.time.txt"/></th>
			<th nowrap class="centeredTableHeader"><fmt:message key="fcm.alert.userId.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.result.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.systemBlock.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.transactionBlock.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.memo.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.home.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.work.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.mobile.txt"/></th>
			<th nowrap class="centeredTableHeader"><fmt:message key="fcm.alert.email.txt"/></th>
			<th class="centeredTableHeader"><fmt:message key="fcm.alert.letter.txt"/></th>
			<th class="centeredTableHeader lastCol"><fmt:message key="fcm.alert.sms.txt"/></th>
		</tr>
	</thead>
	<tbody>
		<c:set var="alertActivityListSize" value="${fn:length(displayEntity.currentAlert.alertActivity)}"/>
		<c:forEach var="activityHolder" items="${alertActivityHolderList}" varStatus="loop">
			<c:set var="activity" value="${activityHolder.activity}"/>
			<c:set var="activityCount" value="${alertActivityListSize-loop.count+1}"/>
		<tr class="dataRow${(loop.count-1)%2+1}_tableRow">
			<td class="imageTableCell">${activityCount}</td>
			<td nowrap class="textTableCell"><esapi:encodeForHTML><fmt:formatDate value="${activity.actionTimestamp}" pattern="${dateFormat}" timeZone="${userTimeZone}"/></esapi:encodeForHTML></td>
			<td nowrap class="textTableCell"><esapi:encodeForHTML><fmt:formatDate value="${activity.actionTimestamp}" pattern="${timeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML></td>
			<td class="textTableCell">${esapi:encodeForHTML(activity.actionUser)}</td>
			<td class="textTableCell allowWrapping">
		<c:choose>
			<c:when test="${activityHolder.lastActivityForQueue}">
				<c:set var="lines" value="${(activityCount-activityHolder.queueActivityCount+1)}-${activityCount}"/>
				<c:if test="${(activityCount-activityHolder.queueActivityCount+1) eq activityCount}">
					<c:set var="lines" value="${activityCount}"/>
				</c:if>
				<img src="analyst/images/QueueMovementShow.gif" style="cursor:pointer;" border="0" height="16" width="16" class="icon queueMovementImage" onclick="showAlertActivityQueue(event,'<esapi:encodeForJavaScript><fmt:message key="fcm.alert.alertActivity.movedFromQueue.fmt.txt"><fmt:param>#${lines}</fmt:param></img><fmt:param>${activity.strategyName}</fmt:param><fmt:param>${activity.queueName}</fmt:param></fmt:message></esapi:encodeForJavaScript>'); return false;"/>
			</c:when>
			<c:otherwise>
				<img src="common/images/spacer.gif" border="0" height="16" width="16" class="icon queueMovementImageSpacer"/>
			</c:otherwise>
		</c:choose>
			<c:if test="${activity.callResultId ne 0}">${esapi:encodeForHTML(activity.callResult)}</c:if>
					<%--<c:if test="${not empty activity.rerouteToQueue}">
						(${activity.rerouteToQueue})
					</c:if>--%>
					<c:if test="${not empty activity.resurfaceDateTime}">
						<esapi:encodeForHTML><fmt:formatDate value="${activity.resurfaceDateTime}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}" /></esapi:encodeForHTML>
					</c:if>
					<c:if test="${not empty activity.fraudTypeCode}">
						(${esapi:encodeForHTML(activity.fraudTypeCode)})
					</c:if></td>
			<td class="textTableCell allowWrapping">
				<c:choose>
					<c:when test="${activity.systemBlockAction == 'NC'}">
					  <fmt:message key="fcm.alert.noChange.txt"/>
					</c:when>
					<c:when test="${activity.systemBlockAction == 'AD'}">
						<esapi:encodeForHTML>
						<fmt:message key="fcm.alert.apply.fmt.txt">
							<fmt:param value="${activity.systemBlock}"/>
							<fmt:param><fmt:formatDate value="${activity.systemBlockUntilTimestamp}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}"/></fmt:param>
						</fmt:message>
						</esapi:encodeForHTML>
					</c:when>
					<c:when test="${activity.systemBlockAction == 'RM'}">
						<c:choose>
							<c:when test="${not empty activity.previousSystemBlock}">
								<esapi:encodeForHTML>
								<fmt:message key="fcm.alert.clear.fmt.txt">
							  		<fmt:param value="${activity.previousSystemBlock}"/>
						  		</fmt:message>
						  		</esapi:encodeForHTML>
							</c:when>
							<c:otherwise>
								 <fmt:message key="fcm.alert.clearBlock.txt"/>
							</c:otherwise>
						</c:choose>
					</c:when>
				</c:choose>
			</td>
			<td class="textTableCell allowWrapping">
				<c:choose>
					<c:when test="${activity.transactionBlockAction == 'NC'}">
					  <fmt:message key="fcm.alert.noChange.txt"/>
					</c:when>
					<c:when test="${activity.transactionBlockAction == 'AD'}">
						<esapi:encodeForHTML>
						<fmt:message key="fcm.alert.apply.fmt.txt">
							<fmt:param value="${activity.transactionBlock}"/>
							<fmt:param><fmt:formatDate value="${activity.transactionBlockUntilTimestamp}" pattern="${dateTimeFormat}" timeZone="${userTimeZone}"/></fmt:param>
						</fmt:message>
						</esapi:encodeForHTML>
					</c:when>
					<c:when test="${activity.transactionBlockAction == 'RM'}">
					  <fmt:message key="fcm.alert.clearBlock.txt"/>
					</c:when>
				</c:choose>
			</td>
			<td class="textTableCell allowWrapping">
				 ${esapi:encodeForHTML(activity.memoPreview)} <c:if test="${activity.memoSize gt fn:length(activity.memoPreview)}">
				 	<img src="analyst/images/Ellipsis.gif" style="vertical-align: bottom" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.actionMemos.viewFullMemo.txt"/></esapi:encodeForHTMLAttribute>"
				 		onclick="viewActionMemoContent(${activity.actionId}, memoRetrieveOption, activityDisplayOption);"></c:if>
			</td>
			<td class="imageTableCell">
				<c:if test="${activity.contactHomePhoneInd}"><img src="analyst/images/check.gif" width="10" height="8"></c:if>
			</td>
			<td class="imageTableCell">
				<c:if test="${activity.contactWorkPhoneInd}"><img src="analyst/images/check.gif" width="10" height="8"></c:if>
			</td>
			<td class="imageTableCell">
				<c:if test="${activity.contactMobilePhoneInd}"><img src="analyst/images/check.gif" width="10" height="8"></c:if>
			</td>
			<td class="imageTableCell">
				<c:if test="${activity.sentEmailInd}"><img src="analyst/images/check.gif" width="10" height="8"></c:if>
			</td>
			<td class="imageTableCell">
				<c:if test="${activity.sentLetterInd}"><img src="analyst/images/check.gif" width="10" height="8"></c:if>
			</td>
			<td class="imageTableCell lastCol">
				<c:if test="${activity.sentSMSInd}"><img src="analyst/images/check.gif" width="10" height="8"></c:if>
			</td>
		</tr>
		</c:forEach>
	</tbody>
</table>
</div>

<div id="alertActivityPrompt" style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F;display:none;overflow:auto;min-width:300px;max-width:1200px;max-height:600px;"  draggable="true" ondragstart="drag(event)" >
	<table cellpadding="5" cellspacing="0" border="0" width="100%">
		<tbody>
			<tr>
				<td id="alertActivityPromptMemo" align="left"></td>
				<td width="20" valign="top" nowrap>
					<img src="common/images/Maximize.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.actionMemos.expand.txt"/></esapi:encodeForHTMLAttribute>" onclick="$('#alertActivityPrompt').css({width:window.innerWidth*.8}).position({of: $(document), collision:'none'});" />
					<img src="common/images/closeX.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.actionMemos.close.txt"/></esapi:encodeForHTMLAttribute>" onclick="$('#alertActivityPrompt').hide();" />
				</td>
			</tr>
		</tbody>
	</table>
</div>

<div id="alertActivityDisplayOptionPrompt" style="position:absolute;z-index: 99;background-color:white; border: 1px solid #42668F;display:none;"  draggable="true" ondragstart="drag(event)">
	<table cellpadding="5" cellspacing="0" border="0" width="100%" nowrap>
		<tbody>
			<tr>
				<td align="left"><fmt:message key="fcm.alert.actionMemos.showHistoryTab.txt"/></td>
				<td align="left"><input type="checkbox" onclick="changeActivityDisplayOption(this);"/></td>
				<td width="20" valign="top">
					<img src="common/images/closeX.gif" title="<esapi:encodeForHTMLAttribute><fmt:message key="fcm.alert.actionMemos.close.txt"/></esapi:encodeForHTMLAttribute>" onclick="$('#alertActivityDisplayOptionPrompt').hide();" />
				</td>
			</tr>
			<tr>
				<td align="left"><fmt:message key="fcm.alert.actionMemos.showLongMemoInPopup.txt"/></td>
				<td align="left"><input type="text" size="5" maxLength="5" onChange="changeActivityDisplayOption(this);"/></td>
				<td width="20" valign="top">&nbsp;</td>
				</td>
			</tr>
		</tbody>
	</table>
</div>
