<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<fmt:setBundle var="alertTypeLabelResourceBundle" scope="request" basename="com.sas.finserv.creditfraud.fcm.util.AlertTypeLabelResourceBundle" />
<!-- new MO -->
<!-- include jQuery and jQueryUI libraries -->
<script type="text/javascript"	src="common/scripts/jquery.js"></script> <!-- RAPTOR-2399 -->
<script type="text/javascript"	src="common/scripts/jquery-ui.js"></script>

<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="admin/scripts/users.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<!-- include plugin -->
<script type="text/javascript" src="admin/scripts/jquery.tree.js"></script>
<link rel="stylesheet" type="text/css" href="admin/styles/jquery.tree.css" />

<!-- initialize checkboxTree plugin -->
<script type="text/javascript">
    //<!--
    $(document).ready(function() {
    	var multiOrgs = [];
		var tenantMultiOrgs = [];
		
		//generate multiorg tree asynchronously
		<c:set var="userId" value="${user.id}"/>
		<c:if test="${copiedUserId!=null}">
		        <c:set var="userId" value="${copiedUserId}"/>
		</c:if>
		var urlString='getUserMultiOrgs.action?userId=${userId}';
		var requestType='POST';
		var userMO=$.ajax({url:urlString, type: requestType});
		$.when(userMO).done(function(){
			populateMultiOrgs(userMO.responseText);
			urlString='getMultiOrgNodes.action';			
			var moNodes=$.ajax({url:urlString, type: requestType});
			$.when(moNodes).done(function(){
				outputTree(moNodes.responseText);
			});
			$.when(moNodes).fail(function(oObj,textStatus,errorThrown){
				console.log("getMultiOrgNodes failed");
			});
			
		});
		$.when(userMO).fail(function(oObj,textStatus,errorThrown){
			console.log("getUserMultiOrgs failed")
		});
		
		function populateMultiOrgs(userMO){	
			userMOArr=userMO.split(",");
			for(i=0;i<userMOArr.length;i++){
				multiOrgs.push("#mo"+userMOArr[i]);
			}
		}
		
		function outputTree(moTree){
			$('#tree').html(moTree);
			$('#tree').tree({
	  			nodesInitUrl: null,
	  			onCheck : {
	  				descendants : 'check',
	  				ancestors : '',
	  				node : 'expand'
	  			},
	  			onUncheck : {
	  				ancestors : '',
	  				descendants : ''
	  			}
	  		  });
			//check saved multiOrgs	  
			$(multiOrgs.join(',')).prop("checked", true).change();
			//determine if select all should be checked
			var numberOfChecked = $('input[name="multiOrgSels"]:checkbox:checked').length;
			var totalCheckboxes = $('input[name="multiOrgSels"]:checkbox').length;
			var numberNotChecked = totalCheckboxes - numberOfChecked;
			//alert(  "total: " +totalCheckboxes + " checked: "  +numberOfChecked +"unchecked:" +numberNotChecked);
			if (numberNotChecked == 0)
				$('#moSelectAll').prop('checked', true);

			$('#moSelectAll').change(function() {

				if (this.checked) {
					$('#tree').tree('checkAll');
				} else {
					$('#tree').tree('uncheckAll');
					$('.orgLevel2 input').prop("disabled", false);
				}

				$(this).parent().bind('click', function(e) {
					e.stopPropagation()
				});
			});
			$('#orgLevel1 input').bind('click', function() {
				$('#moSelectAll').prop('checked', false);
			});
		}
	
	$('#iemail').blur( function () {
		warnEmailAddress(this);
	});

	var userRoles = [];
	var businessUnits = [];
	var alertTypes = [];
	<%-- Create userRoles array with role ids --%>
	<c:forEach var="userRole" items="${user.roles}">userRoles.push("#r${esapi:encodeForJavaScript(userRole)}");</c:forEach>
	<c:forEach var="userAT" items="${user.alertTypes}">alertTypes.push("#at${esapi:encodeForJavaScript(userAT)}");</c:forEach>
	<c:forEach var="userBU" items="${user.businessUnits}">businessUnits.push("#bu${esapi:encodeForJavaScript(userBU)}");</c:forEach>

	<%-- Check all currently assigned roles --%>
	$(userRoles.join(',')).prop("checked",true);
	$(alertTypes.join(',')).prop("checked",true);
	$(businessUnits.join(',')).prop("checked",true);

	<%-- Select the current team of user --%>
	<c:if test="${not empty user.teamId}">
	$("form select[name='team'] option[value^='${esapi:encodeForJavaScript(user.teamId)}']").prop("selected",true);
	</c:if>

	<%-- Check the current status --%>
	$('form :radio[name="status"][value="${esapi:encodeForJavaScript(user.status)}"]').prop("checked",true);

	initSelectAllCheckboxes("#atSelectAll","alertTypeSels",${fn:length(alertTypes)});
	initSelectAllCheckboxes("#buSelectAll","businessUnitSels",${fn:length(businessUnits)});
	initSelectAllCheckboxes("#rSelectAll","roleSels", ${fn:length(roles)});

 	<c:if test="${not empty updateUsers && !updateUsers}">
    setFormsReadOnly();
	</c:if>

    $("#iteam").cascade($("input[name='businessUnitSels']"),{
		list: teams,
		template: commonTemplate,
		event:"click",
		getParentValue:getCheckboxValues,
		match: function(selectedValue) {
			var when = this.When;
			var matches = false;
			jQuery.each(jQuery.makeArray(selectedValue),function(index){
				if(this == when) {
					matches = true;
					return false;
				}
			});

			return matches;
		}
	});
});
 
</script>
<!-- new MO -->

   <script language="JavaScript">
   //<!--

   function isSystemUser()
   {
   	return ${user.systemUser};
   }

   function shiftCheck(e)
    {
	    var items = e.data.boxes;
	    var allBox = e.data.allBox;
        var total = e.data.total;

    	// if checking with shift key
    	if(this.checked && e.shiftKey)
        {
            var itemIdx = items.index(this);
            var prevItems = items.slice(0,itemIdx);
            for(var ii = prevItems.length-2; ii >=0;  ii--)//don't need to check immediate sibling
            {
                var prevItem = prevItems[ii];
                if(prevItem.checked) //found first checked box
                {
                	prevItems.slice(ii).prop("checked",true);
                	break;
                }
            }
        }

        if(!this.checked) // user unchecked a box, uncheck allBox too
            allBox.prop("checked",false);
        else // user checked a box, must count total checked
        {
			var num = items.filter(":checked").length;
			var on = (num == total);
    		allBox.prop("checked", on );
         }
    }

   function initSelectAllCheckboxes(toggleId, checkBoxesName, totalCount)
   {
	   // search
		var allBox = $(toggleId);
		var boxes = $(":checkbox[name='"+checkBoxesName+"']");

		// determine whether to check the allBox
		var numChecked = boxes.filter(":checked").length;
		var allSelected = totalCount == numChecked;
		allBox.prop("checked", allSelected );

		//Un/Check all related boxes if allBox is un/checked
		allBox.bind('click',function(e){
				boxes.prop("checked",this.checked);
				//trigger click event for cascading
				$("form :checkbox[name='"+checkBoxesName+"'][value=-1]").trigger('click');
				//global business unit must always remain checked
				$("form :checkbox[name='"+checkBoxesName+"'][value=-1]").prop("checked",true);

	        e.stopPropagation();
		});

		// stop label from propagating
		allBox.parent().bind('click',function(e){e.stopPropagation()});

		//Bind related boxes to enable shift click
		boxes.bind('click',
				{ allBox:allBox, boxes:boxes, total:totalCount },
				shiftCheck);
   }


    var teams = [
    		{'When':'','Value':'','Text':'&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'},
    		<c:forEach var="team" items="${allTeams}">
    			{'When':'${esapi:encodeForJavaScript(team.businessUnit)}','Value':'${team.id}:${team.version}','Text':'${esapi:encodeForJavaScript(esapi:encodeForHTML(team.name))}'},
    		</c:forEach>
    	        ];

    	function commonTemplate(item) {

    		if (item.Value==$("#iteam").val() ) {
    		return "<option value='" + item.Value + "' selected>" + item.Text + "</option>";
    		}
    		else return "<option value='" + item.Value + "'>" + item.Text + "</option>";
    	};

    	function commonMatch(selectedValue) {
    		return this.When == selectedValue;
	};
	function getCheckboxValues(parent) {
		var arr=$(parent).fieldArray();
		arr.push("");
		return arr;
	}


   //-->
   </script>

<div>
   <%-- Error handling code --%>
	<c:url var="reloadURL" value="/listUserTree.action?treeSelectedUser=${user.id}" />
	<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
		<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
		<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
		<tiles:putAttribute name="objectTypeName" value="user" />
	</tiles:insertTemplate>

   <form id ="userDefForm" action="<c:url value='/saveUser.action'/>" method="post" onsubmit="return submitUserForm(this);">
         <input type="hidden" name="method" value="saveUser">
    <c:if test="${user != null}">
         <input type="hidden" name="id" value="${user.id}">
         <input type="hidden" name="version" value="${user.version}">
         <input type="hidden" name="oldTeamId" value="${user.teamId}">
         <input type="hidden" name="oldTeamVersion" value="${user.teamVersion}">
      </c:if>

<div id="mainContent" style="width:600px;margin-left:5px;">
	<div id="generalProperties" onclick="showDiv($('#generalPropertiesImg')[0], 'generalPropertiesBlock');" class="configurationSectionTitle" >
		<div class="configuration-section-title-left">
<!--			<img id="generalPropertiesImg" src="admin/images/sprite_arrow_down_light.png" align="middle" /> -->
            <span id="generalPropertiesImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06e;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.users.user.definition.txt" />
		</div>
	</div>
	<%-- Override the height and overflow of configurationSection --%>
	<div id="generalPropertiesBlock" style="height:auto;overflow:none;">
		<div class="configurationSection" style="height:auto; overflow:none; padding:5px;">
		<table>
			<tr>
				<td><fmt:message key="fcm.users.user.userid.txt" /></td>
				<td>${user.id}</td>
			</tr>
			<tr>
				<td><label for="iusername"><fmt:message key="fcm.users.user.username.txt" /></label></td>
				<td>
				<c:choose>
					<c:when test="${user.status == 'ACTIVE' && empty errorMessage}">
                            	<span id="iusername">${esapi:encodeForHTML(user.username)}</span>
                           	<input name="username" type="hidden" value="${esapi:encodeForHTMLAttribute(user.username)}">
					</c:when>
					<c:otherwise>
						<input id="iusername" name="username" type="text" class="famTextEntry" value="${esapi:encodeForHTMLAttribute(user.username)}" size="30" maxlength="20">
					</c:otherwise>
				</c:choose>
				</td>
			</tr>
               <tr>
				<td><label class="first" for="ilastName"><fmt:message key="fcm.users.user.lastName.txt" /></label></td>
				<td><input id="ilastName" name="lastName" type="text" class="famTextEntry" value="${esapi:encodeForHTMLAttribute(user.lastName)}" size="30" maxlength="20" /></td>
			</tr>
			<tr>
				<td><label class="first" for="ifirstName"><fmt:message key="fcm.users.user.firstName.txt" /></label></td>
				<td><input id="ifirstName" name="firstName" type="text" class="famTextEntry" value="${esapi:encodeForHTMLAttribute(user.firstName)}" size="30" maxlength="20"/></td>
			</tr>
			<tr>
				<td><label class="first"><fmt:message key="fcm.users.user.status.txt" /></label></td>
				<td><input id="activeStatus" name="status" type="radio" value="ACTIVE"/> <label for="activeStatus"><fmt:message key="fcm.users.user.active.txt" /></label>
                	<input id="inactiveStatus" name="status" type="radio" value="INACTIVE"/><label for="inactiveStatus"><fmt:message key="fcm.users.user.inactive.txt" /></label></td>
			</tr>
          	<tr>
           		<td><label class="first" for="iemail"><fmt:message key="fcm.users.user.emailAddress.txt" /></label></td>
           		<td><input id="iemail" name="emailAddress" class="famTextEntry" type="text" value="${esapi:encodeForHTMLAttribute(user.emailAddress)}" style="width:400px" maxlength="255" />
           			<div id="emailAddressWarn" class="formFieldDesc" style="display:none"><img src="admin/images/WarningStatus.gif" style="vertical-align:bottom;" width="11" height="11"/> <fmt:message key="fcm.users.user.emailAddress.warning.txt" /></div>
           		</td>
			</tr>
         	<tr>
         		<td><label class="first" for="iphone"><fmt:message key="fcm.users.user.phoneNumber.txt" /></label></td>
           		<td><input id="iphone" name="phoneNumber" class="famTextEntry" type="text" value="${esapi:encodeForHTMLAttribute(user.phoneNumber)}" size="30" maxlength="15" /></td>
			</tr>
<xams:hide>
      <tr>
           		<td><label class="first" for="iteam"><fmt:message key="fcm.users.user.team.txt" /></label></td>
               <td><select id="iteam" name="team" class="famSelect" style="width:250">
               		<option value="">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</option>
                 <c:forEach var="team" items="${allTeams}" varStatus="status">
                 	<c:forEach var="bu" items="${user.businessUnits}">
                 		<c:if test="${team.businessUnit==bu}">
                 			<option value="${team.id}:${team.version}">${esapi:encodeForHTML(team.name)}</option>
                 		</c:if>
                 	</c:forEach>
                  </c:forEach>
                </select>
                </td>
         </tr>
</xams:hide>

		</table>
		</div>
	</div>


	<div id="alertTypes" class="configurationSectionTitle"  onclick="showDiv($('#alertTypeImg')[0], 'alertTypeBlock');">
		<div class="configuration-section-title-left">
<!--			<img id="alertTypeImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="alertTypeImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.users.user.alertAccess.header.txt" />
		</div>
		<div class="configuration-section-title-right"><label><fmt:message key="fcm.users.selectAll.txt"/><input id="atSelectAll" type="checkbox"/></label></div>
	</div>

  <div id="alertTypeBlock" style="height:auto; overflow:none; display:none;">
	<div class="configurationSection" style="height:auto; overflow:none; padding:5px;">

		<ul class="item-list-container">
		<c:forEach var="at" items="${alertTypes}">
			<li class="item-list"><div><label><input id="at${at}" type="checkbox" name="alertTypeSels" value="${at}"/><fmt:message key="${at}" bundle="${alertTypeLabelResourceBundle}"/></label></div></li>
		</c:forEach>
		</ul>
	</div>
  </div>

	<div id="multiOrgs" onclick="showDiv($('#multiOrgImg')[0], 'multiOrgBlock');" class="configurationSectionTitle">
		<div class="configuration-section-title-left">
<!--			<img id="multiOrgImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="multiOrgImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.users.user.multiOrg.header.txt" />
		</div>
		<div class="configuration-section-title-right"><label><fmt:message key="fcm.users.selectAll.txt"/> <input id="moSelectAll" type="checkbox"/></label></div>
	</div>


<script language="javascript">
//<!--
	function initCheckboxes(toggleId, checkBoxesName, id, totalCount)
	{
	// search
		var allBox = $(toggleId);
		var boxes = $(":checkbox[name='"+toggleId+"']");

		// determine whether to check the allBox
		var numChecked = boxes.filter(":checked").length;
		var allSelected = totalCount == numChecked;
		allBox.prop("checked", allSelected );

		//Un/Check all related boxes if allBox is un/checked
		allBox.bind('click',function(e){

		if (allBox.prop("checked") == true)
		{
			$("form :checkbox[name='"+checkBoxesName+"'][value=-1]").prop("checked",true);
			$("form :checkbox[name='"+checkBoxesName+"'][value='"+id+"']").prop("checked",true);
		}

		e.stopPropagation();
		});

		// stop label from propagating
		allBox.parent().bind('click',function(e){e.stopPropagation()});

		//Bind related boxes to enable shift click
		boxes.bind('click',
		{ allBox:allBox, boxes:boxes, total:totalCount },
		shiftCheck);
	}
// -->
</script>

<div id="multiOrgBlock" style="height:auto;display:none;overflow:none;">
	<div id="tree" class="configurationSection"	style="border: none; background-color: #f0f1f2; background-image: none; height: auto; overflow: none; padding: 5px;">
	</div>
</div>

<script>
//document.getElementById("${tenantDivElement}").style.fontWeight='bold';
</script>

	<div id="businessUnits" class="configurationSectionTitle" onclick="showDiv($('#businessUnitImg')[0], 'businessUnitBlock');">
		<div class="configuration-section-title-left">
<!--			<img id="businessUnitImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="businessUnitImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.users.user.businessUnit.header.txt" />
		</div>
		<div class="configuration-section-title-right"><label><fmt:message key="fcm.users.selectAll.txt"/> <input id="buSelectAll" type="checkbox"/></label></div>
	</div>
  <div id="businessUnitBlock" style="height:auto;overflow:none; display:none;">
	<div class="configurationSection" style="height:auto;overflow:none; padding:5px;">

		<ul class="item-list-container">
		<c:forEach var="bu" items="${businessUnits}">
			<li class="item-list"><div><label><input id="bu${bu.id}" type="checkbox" name="businessUnitSels" value="${bu.id}" <c:if test="${bu.id==-1}"> disabled="disabled"</c:if>/>${esapi:encodeForHTML(bu.name)}</label></div></li>
		</c:forEach>
		</ul>
	</div>
  </div>
<xams:hide>
</xams:hide>
	<div id="roles" class="configurationSectionTitle" onclick="showDiv($('#roleImg')[0], 'roleBlock');">
		<div class="configuration-section-title-left">
<!--			<img id="roleImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="roleImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.users.user.roles.txt" />
		</div>
		<div class="configuration-section-title-right"><label><fmt:message key="fcm.users.selectAll.txt"/> <input id="rSelectAll" type="checkbox"/></label></div>
	</div>
  <div id="roleBlock" style="height:auto;overflow:none; display:none;">
	<div class="configurationSection" style="height:auto;overflow:none; padding:5px;">
		<ul class="item-list-container">
		<c:forEach var="role" items="${roles}">
			<li class="item-list"><div><label><input id="r${role.id}" type="checkbox" name="roleSels" value="${role.id}"/>${esapi:encodeForHTML(role.name)}</label></div></li>
		</c:forEach>
		</ul>
	</div>
  </div>

</div>

   </form>

</div>

