<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<style type="text/css">
@import "admin/styles/preference.css";
</style>

<script language="JavaScript" src="admin/scripts/dynamicRows.js" type="text/javascript"></script>
<script type="text/javascript" src="common/scripts/jquery.js"></script>
<script type="text/javascript" src="common/scripts/jquery-ui.js"></script>
<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<script type="text/javascript">

// debugger;
    var segmentList = [];
    var segmentFieldMap = {};
    var masterFields = {};
    var tenantPrefixList = {};

	var modifiedFieldList = {};	 // list of fields being modified

    var fieldNameParams = [];

    // common segments
    <c:set var="tenantOrgNodeId" value="-1"/>
	tenantPrefixList["${tenantOrgNodeId}"] = "";
	segmentList.push({section: "S${tenantOrgNodeId}", desc: "<fmt:message key="fcm.preferences.gridTemplate.allFieldsOfSystem.txt" />"});
    <c:forEach var="segment" items="${systemSegments}">
    	segmentList.push({section: "S${tenantOrgNodeId}", id: "${segment.id}", desc: "${segment.acronym} - ${esapi:encodeForJavaScript(segment.description)}"});
    	segmentFieldMap["${segment.id}"] = [];
    </c:forEach>

	<c:set var="tenant" value=""/>
    <c:forEach var="segment" items="${flexSegments}">
    	<c:if test="${callCenterType == 'T'}">
    		<c:set var="tenant" value="[${esapi:encodeForJavaScript(segment.tenantOrgNodeLabel)}] "/>
     	</c:if>
    	<c:if test="${tenantOrgNodeId ne segment.tenantOrgNodeId}">
	    	tenantPrefixList["${segment.tenantOrgNodeId}"] = "${tenant}";
	    	<c:choose>
	    	<c:when test="${callCenterType == 'P'}">
		 		segmentList.push({section: "S${segment.tenantOrgNodeId}", desc: "<fmt:message key="fcm.preferences.gridTemplate.allFieldsOfTenant.txt"/>"});
	     	</c:when>
	    	<c:when test="${callCenterType == 'T'}">
		 		segmentList.push({section: "S${segment.tenantOrgNodeId}", desc: "<fmt:message key="fcm.preferences.gridTemplate.allFieldsOfTenant.txt.fmt"><fmt:param>${tenant}</fmt:param></fmt:message>"});
	     	</c:when>
	     	</c:choose>
	    	<c:set var="tenantOrgNodeId" value="${segment.tenantOrgNodeId}"/>
 		</c:if>

    	segmentList.push({section: "S${tenantOrgNodeId}", id: "${segment.id}", desc: "${tenant}${segment.prefixAlt} - ${esapi:encodeForJavaScript(segment.description)}"});
    	segmentFieldMap["${segment.id}"] = [];
    </c:forEach>

    <c:forEach var="fieldDef" items="${transDataMaskTypes}">
    segmentFieldMap["${fieldDef.segmentId}"].push("f${fieldDef.id}");
    masterFields["f${fieldDef.id}"] = {
      	  id: ${fieldDef.id},
           segmentId: ${fieldDef.segmentId},
           name: "${esapi:encodeForJavaScript(fieldDef.practicalName)}",
           desc: "${esapi:encodeForJavaScript(fieldDef.desc)}",
           label: "${esapi:encodeForJavaScript(fieldDef.label)}",
           maskingType: "${esapi:encodeForJavaScript(fieldDef.maskingType)}",
           hyperlinkTemplate: "${esapi:encodeForJavaScript(fieldDef.hyperlinkTemplate)}",
           version: ${fieldDef.version},
           supInfo: "<sfmfmt:formatGridFieldSupplementalInfo value="${fieldDef}" timeZone="${userTimeZone}" />",
           tenantOrgNodeId: ${fieldDef.tenantOrgNodeId ==null ? -1 : fieldDef.tenantOrgNodeId}
    };
    fieldNameParams.push("{" + "${esapi:encodeForJavaScript(fieldDef.practicalName)}" + "}");
    </c:forEach>

    $(document).ready(function(){
    	// populate the segment dropdown
    	var $s = $("#segmentFilter");
        for(var i=0; i < segmentList.length; i++)
        {
        	if ( segmentList[i].id )
        		$s.append($("<option>").attr("value", segmentList[i].id).text(segmentList[i].desc));
        	else
        		$s.append($("<option>").attr("value", segmentList[i].section).text(segmentList[i].desc).css("font-weight", "bold"));
        }
	    $s.prop("selectedIndex", 1).change();

		//setup field name selection menu
		$("#param").autocomplete({source: fieldNameParams, disabled: false, minLength:2, delay:0})
			.bind("autocompleteselect", function( event, ui) {
				$(this).data("target").trigger("setparam", ui.item.value);
			});

		$("#infoPop").hide();
		$("#hyperlinkInfo").mouseover(function(event) {
			var xSpace = $(window).width() - event.pageX - 30;
			var xOffset = xSpace - $("#infoPop").outerWidth();
			var xpos = ( xOffset >=0 ) ? event.pageX : event.pageX + xOffset;
			$("#infoPop").css({top: event.pageY, left: xpos}).show();
		}).mouseout(function(){
			$("#infoPop").hide();
		});

    });
</script>

<style>
/* override the UL style of autocomplete input dropdown */
UL {
	list-style-type: none;
	text-align:left;
	width:200px;
}
</style>

<%-- template row of transaction field display configuration --%>
<div style="display:none">
<input id="param" style="display:none" type="text"/>

<table>
	<tr id="rowClone" class="dataRow1_tableRow">
		<td class="imageTableCell"></td> <%--loop.count--%>
		<td class="textTableCell"><span onclick="copyToClipboard('{'+$(this).text()+'}');" title="<fmt:message key='fcm.preferences.dataMasking.clickToCopy.txt'/>"></span></td> <%--transDataMaskType.name --%>
		<td class="textTableCell"></td> <%--transDataMaskType.label--%>
		<td class="textTableCell"></td> <%--transDataMaskType.desc--%>

        <td class="textTableCell">
        	<select name="maskingTypes"  style="margin:4px;" class="famSelect" onchange="saveDisplayConfigChange(this);">
        		<option value="" > <fmt:message key="fcm.preferences.dataMasking.transaction.maskingTypeNone.txt" /> </option>
        		<c:forEach var="dataMaskingObj" items="${dataMaskingObjs}" varStatus="tloop">
        			<option value="${esapi:encodeForHTML(dataMaskingObj.maskingType)}"> ${esapi:encodeForHTML(dataMaskingObj.maskingName)}</option>
        		</c:forEach>
        	</select>
        </td>
		<td class="textTableCell lastCol">
			<input type="text" name="hyperlinkTemplates" size="25" maxlength="500" onchange="saveDisplayConfigChange(this);"/> <%--transDataMaskType.hyperlinkTemplate--%>
		</td>
	</tr>
</table>
</div>


<script type="text/javascript">
function saveDisplayConfigChange (ctrl)
{
	var $row = $(ctrl).parent().parent();
	var fieldID = $row.attr("id");
	var field = masterFields[fieldID];

	if (field)
	{
		field.maskingType = $row.find("select").val();
        field.hyperlinkTemplate = $row.find("input").val();

		modifiedFieldList[fieldID] = field;
	}
//	console.log (field);
}

function submitModifiedFields(form)
{
	form.addInput = function (name, value) {
		$(this).append($("<input>").attr("type", "hidden").attr("name", name).attr("value", value));
	};

	for (var index in modifiedFieldList)
	{
		var field = modifiedFieldList[index];

		form.addInput("ids", field.id);
		form.addInput("versions",  field.version);
		form.addInput("names", field.practicalName);
		form.addInput("maskingTypes", field.maskingType);
		form.addInput("hyperlinkTemplates", field.hyperlinkTemplate);
	}

	return true;
}

function loadTableBySegmentId($tbody, segmentId, list, count)
{
    var $row = $("#rowClone");
    var numRows = 0;
    var fieldIDs = list[segmentId];
    for (var i=0; i < fieldIDs.length; i++)
    {
   		var fieldID = fieldIDs[i];
   		var field = masterFields[fieldID];

		numRows++;
  		var $newRow = $row.clone(true);
  		$newRow.addClass(count % 2 ? 'dataRow1_tableRow' : 'dataRow2_tableRow');
  		$newRow.attr('id','f'+field.id);

  		var $cell = $newRow.find('td:eq(0)');
     	$cell.text(count);

		$cell = $cell.next();
		$cell.find("span").text(field.name);

		$cell = $cell.next();
		$cell.text(field.label);

		$cell = $cell.next();
		$cell.text(field.desc);

		$cell = $cell.next();
		$cell.find("select").prop("value", field.maskingType);

		$cell = $cell.next();
		$cell.find("input[name='hyperlinkTemplates']").prop("value", field.hyperlinkTemplate)
			.bind("focus", function (event) { $("#param").data("target", $(this)); })
			.bind("keypress", function( event) { //console.log(String.fromCharCode(event.keyCode));
				var keyCode = event.which || event.keyCode;
				if (keyCode == 123) {	// key: {
					$(this).data( "search", "{");
					$("#param").autocomplete("option", "position", { my: "left top", at: "left bottom", collision: "none", of: $(this)} );
				}
				else if (keyCode == 125) { // key: }
					$(this).data( "search", null); $("#param").autocomplete("close"); }
				else {
					var s = $(this).data("search");
					if (s && s.length > 0) { s += String.fromCharCode(event.keyCode);  $(this).data("search",s); $("#param").autocomplete("search", s); }
				}
			})
			.bind("keyup", function( event) {
				if ((event.which || event.keyCode) == 8) { // key: backspace
					var s = $(this).data("search");
					if (s && s.length > 0) {
						s=s.slice(0, s.length-1);
						$(this).data("search", s);
						if (s.length>0) $("#param").autocomplete("search", s);
						else $("#param").autocomplete("close");
					}
				}
			})
			.bind("setparam", function (event, param) {
				var val = $(this).val();
				var part1 = val.slice(0, event.target.selectionStart-$(this).data("search").length);
				var part2 = val.slice(event.target.selectionEnd);
				$(this).val(part1 + param + part2).change();
				$(this).data("search", null);
			});

        $tbody.append($newRow);
        count++;
    }
    return numRows;
}

function showFieldsBySegment(tableId, selectedSegmentId, list, segList)
{
    var count = 1;
    var $tbody = $("#" + tableId + " > tbody").empty();

    if(selectedSegmentId === "NONE")     // show all segments/fields
    {
        for (var j=0; j< segList.length; j++) {
        	if (segList[j].id)
        	{
            	var segmentId = segList[j].id;
            	count += loadTableBySegmentId($tbody,segmentId, list, count);
            }
        }
    } else if (selectedSegmentId.charAt(0) == "S")
    {
         for (var j=0; j< segList.length; j++) {
        	if (segList[j].section == selectedSegmentId && segList[j].id)
        	{
            	var segmentId = segList[j].id;
            	count += loadTableBySegmentId($tbody,segmentId, list, count);
            }
        }
    }
    else {
        count = loadTableBySegmentId($tbody, selectedSegmentId, list, count);
    }
}
</script>


<div id="transactionDataMaskingContentDiv">
<%-- TODO: Error handling code --%>
<c:url var="reloadURL" value="/viewPreferencesTree.action?treeSelectedItemId=${esapi:encodeForURL(transDataMaskingNodeId)}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="Transaction Data Masking Configuration" />
</tiles:insertTemplate>


<form id="transactionDataMaskForm" name="transactionDataMaskForm" action="<c:url value='/saveTransactionDataMaskTypes.action'/>" method="post" onsubmit="submitModifiedFields(this);">
	<input type="hidden" name="method" value="saveTransactionDataMaskTypes">
	<input type="hidden" name="transDataMaskingNodeId" value="M1">
</form>

<!-- main content header -->
<table class="mainTable" cellpadding="0" cellspacing="0" border="0" style="width:98%;margin:5px" >
	<tr align="left" valign="top" >
		<td class="configurationTableSectionNoHover" style="padding:5px;"><fmt:message key="fcm.preferences.dataMasking.transaction.configure.title.txt" /></td>
	</tr>
	<tr>
		<th align="left" valign="top" class="configurationTableTitle" style="margin-top:20px;white-space:nowrap">
			<span style="white-space:nowrap"><fmt:message key="fcm.preferences.dataMasking.transaction.filterBySegment.txt"/></span>
            <select id="segmentFilter" name="segments" class="famSelect" onChange="showFieldsBySegment('transactionDataMaskingTable', this.value, segmentFieldMap, segmentList);" style="margin:2px;">
            </select>
		</th>
	</tr>
	<tr>
		<td style="padding: 0px;" >
			<div id="transactionDataMaskingDiv" class="preferencesGrid" onscroll="repositionTHs(this)">

			<%-- main content header --%>
			<table id="transactionDataMaskingTable" cellspacing="0"  cellpadding="0"  class="mainTable"  style="border: none; border-collapse: separate;" >
				<thead>
					<tr class="tableColumnHeaderRow">
						<th nowrap width="5%" class="centeredTableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.content.count.header.title" /> </th>
						<th nowrap width="15%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.dataMasking.transaction.fieldName.title" /> &nbsp;</th>
						<th nowrap width="15%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.dataMasking.transaction.fieldBusinessName.title" /> &nbsp;</th>
						<th nowrap width="35%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.dataMasking.transaction.fieldDesc.title" /> &nbsp;</th>
						<th nowrap width="10%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.dataMasking.type.header.title" /> &nbsp;</th>
						<th nowrap width="20%" class="tableHeader" style="border-top: none; border-right: none"><fmt:message key="fcm.preferences.dataMasking.transaction.hyperlink.title.txt" />
							<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" id="hyperlinkInfo" style="font-family: sas-icons; font-size: 1rem; vertical-align: middle;" data-sap-ui-icon-content=""></span>
						</th>
					</tr>
				</thead>

				<tbody >
				<%-- transaction fields go here id="transactionDataMaskingTableBody"  --%>
				</tbody>
			</table>
			<%-- end main content --%>

			</div>
		</td>
	</tr>
</table>
<!-- end main content header -->

</div>

<div id="infoPop" class="infoPop" style="text-align:left;width:500px">
	<p><fmt:message key="fcm.preferences.dataMasking.transaction.hyperlink.instruction.1.txt" /></p>
	<p><fmt:message key="fcm.preferences.dataMasking.transaction.hyperlink.instruction.2.txt" /></p>
	<p><fmt:message key="fcm.preferences.dataMasking.transaction.hyperlink.instruction.3.txt" /></p>
</div>

<c:if test="${not empty updateAdmins && !updateAdmins}">
	<script language="JavaScript" type="text/javascript">
    	setFormsReadOnly();
  	</script>
</c:if>
