<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<script language="JavaScript" src="admin/scripts/groups.js"></script>
<script language="JavaScript" src="admin/scripts/listboxAssignments.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<script type="text/javascript">
<!--
	$(document).ready(function(){
		var users = $("#unassignedUsersId");
		var assignedUsers = $("#assignedUsersId");
		<c:forEach var="userid" items="${team.users}">
			var user = users.find("option[value=${userid.id}]");
			assignedUsers.append(user);
		</c:forEach>

		users.change(function(){
			$("#assignedUsersId").get(0).selectedIndex = -1;
		});

		assignedUsers.change(function(){
			$("#unassignedUsersId").get(0).selectedIndex = -1;
		});

		$("a#assignUsersAction").click(function(){
			$("#unassignedUsersId").find(":selected").appendTo("#assignedUsersId");
			return false;
		});
		$("a#assignAllUsersAction").click(function(){
			$("#unassignedUsersId").find("option").prop("selected",true).appendTo("#assignedUsersId");
			return false;
		});
		$("a#unassignUsersAction").click(function(){
			$("#assignedUsersId").find(":selected").appendTo("#unassignedUsersId");
			return false;
		});
		$("a#unassignAllUsersAction").click(function(){
			$("#assignedUsersId").find("option").prop("selected",true).appendTo("#unassignedUsersId");
			return false;
		});
	});

//-->
</script>

<div>
<%-- Error handling code --%>
<c:url var="reloadURL" value="listBusinessUnits.action?treeSelectedGroupTeam=T${team.id}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="team" />
</tiles:insertTemplate>

<%-- form name="teamForm" id="teamForm"  action="<c:url value='/a_teamDefinition.sj'/>" method="post" onsubmit="return submitTeamForm(this)" --%>
<form name="teamForm" id="teamForm"  action="<c:url value='/saveTeam.action'/>" method="post" onsubmit="return submitTeamForm(this)">

<input type="hidden" name="method" value="saveTeam">
<input type="hidden" name="userList" id="userList" value="">
<c:choose>
<c:when test="${team != null}">
   <input type="hidden" name="id" value="${team.id}">
   <input type="hidden" name="version" value="${team.version}">
   <input type="hidden" id="businessUnit" name="businessUnit" value="${team.businessUnit}">
   <input type="hidden" name="msgKey" value="">
</c:when>
<c:otherwise>
   <input type="hidden" name="groupId" id="groupId" value="${groupId}">
</c:otherwise>
</c:choose>

<table id="teamDefinitionTable" class="configurationTable"
   style="width:600px;margin-left:5px;"
   border="0" cellspacing="0" cellpadding="0">

    <tr align="left" valign="top" >
      <td colspan="3" class="configurationTableSectionNoHover" style="padding:5px;"><fmt:message key="fcm.groups.team.definition.txt" /></td>
    </tr>

   <!-- <tr class="configurationTableDataRow" ><td colspan="2">&nbsp;</td</tr> -->
   <tr class="configurationTableDataRow" valign="top">
      <td scope="col"><fmt:message key="fcm.groups.team.id.txt" />:</td>
      <td  valign="middle" scope="col">${team.id}</td>
   </tr>
   <tr class="configurationTableDataRow" valign="top">
      <td scope="col"><fmt:message key="fcm.groups.team.name.txt" />:</td>
      <td valign="middle" scope="col"><input class="famTextEntry" name="name" type="text" value="${esapi:encodeForHTMLAttribute(team.name)}" style="width:460px" maxlength="50" /></td>
   </tr>
   <tr class="configurationTableDataRow" valign="top">
      <td scope="col"><fmt:message key="fcm.groups.team.desc.txt" />:</td>
      <td valign="middle" scope="col"><textarea class="famTextEntry" name="desc" rows="4" style="width:460px" wrap="PHYSICAL" onKeyDown="limitChars(this,100);" onKeyUp="limitChars(this,100,true);" >${esapi:encodeForHTML(team.desc)}</textarea>
      &nbsp;
      </td>
   </tr>

   <tr class="configurationTableDataRow" valign="top">
      <td><fmt:message key="fcm.groups.team.parent.txt" />:</td>
      <td colspan="1">
         <select id="groupId" name="groupId" class="famSelect" onChange="">
            <c:forEach var="group" items="${groups}" varStatus="status">
            <c:choose>
               <c:when test="${team.groupId == group.id}">
                  <c:set var="selected" value="selected" />
               </c:when>
               <c:otherwise>
                  <c:set var="selected" value="" />
               </c:otherwise>
            </c:choose>
               <option ${selected} value="${group.id}">
                  ${group.name}
               </option>
            </c:forEach>
         </select>
         &nbsp;
      </td>
   </tr>

   <tr class="configurationTableDataRow" valign="top">
      <td><fmt:message key="fcm.groups.team.supervisor.txt" />:</td>
      <td colspan="1">
         <select id="supervisor" name="supervisor" class="famSelect" onChange="">
            <c:set var="supervisorExists" value="" />
            <c:forEach var="user" items="${supervisors}" varStatus="status">
            <c:choose>
               <c:when test="${team.supervisor == user.id}">
                  <c:set var="selected" value="selected" />
                  <c:set var="supervisorExists" value="true" />
               </c:when>
               <c:otherwise>
                  <c:set var="selected" value="" />
               </c:otherwise>
            </c:choose>
               <option ${selected} value="${user.id}">
                  ${esapi:encodeForHTML(user.lastName)}, ${esapi:encodeForHTML(user.firstName)}
               </option>
            </c:forEach>
            <c:if test="${empty supervisorExists }" >
               <option selected value="-1"><fmt:message key="fcm.groups.selectSupervisor.txt" /></option>
            </c:if>
         </select>
         <br>&nbsp;
      </td>
   </tr>

   <tr>
      <td align="left" valign="top" colspan="2" class="configurationTableSectionNoHover" style="padding:5px;"> <fmt:message key="fcm.groups.team.userAssignment.txt" />: </td>
   </tr>

   <tr class="configurationTableDataRow" align="left" valign="top">
      <td colspan="2">
       <div id="repGrid" style="display:block">
         <table width="100%" border="0" cellpadding="0" cellspacing="0" >
            <tr class="configurationTableDataRow">
               <td align="left" valign="bottom" width="10%" >
                  <b style="margin:2px;"><fmt:message key="fcm.groups.group.repSelect.txt" />: </b><br/>
                  <div id="unassignedUsersContainer" style="display:inline;">
                     <select id="unassignedUsersId" class="famSelect" size="15" style="width:17em;margin:2px;"
                        multiple="true">
			<c:forEach var="user" items="${activeUsers}">
				<option value="${user.id}">${esapi:encodeForHTML(user.lastName)}, ${esapi:encodeForHTML(user.firstName)}</option>
			</c:forEach>
                     </select>
                  </div>
               </td>
               <td valign="middle" width="5%">
                  <p align="center"><br/>
                     <a id="assignUsersAction"  href="javascript:void()"  title="">
<!--                     	<img src="common/images/ArrowRightAdd.gif" border="0"> -->
                      	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf039;"></span>
                     </a>
                     <br />
                     <a id="assignAllUsersAction" href="javascript:void()" title="">
<!--                     	<img src="common/images/ArrowRightAddAll.gif"  border="0"> -->
                      	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf038;"></span>
                     </a>
                     <br/>
                     <br />
                     <a id="unassignUsersAction" href="javascript:void()"title="">
<!--                     	<img src="common/images/ArrowLeftRemove.gif" border="0"> -->
                      	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf037;"></span>
                     </a>
                     <br />
                     <a id="unassignAllUsersAction" href="javascript:void()" title="">
<!--                     	<img src="common/images/ArrowLeftRemoveAll.gif" border="0"> -->
                      	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf036;"></span>
                     </a>
                     <br/>
                     <br />
                  </p>
               </td>
               <td align="left" valign="top" width="*">
                  <b style="margin:2px;"><fmt:message key="fcm.groups.team.repAssign.txt" />: </b><br/>
                 <div id="assignedUsersContainer" style="display:inline">
                     <select id="assignedUsersId" class="famSelect" size="15" style="width:17em;margin:2px;"
                        multiple="true"  >
                     </select>
                  </div>

               </td>
            </tr>

         </table>
       </div>
    </td></tr>

    <tr class="configurationTableDataRow" ><td colspan="2">&nbsp;</td></tr>

</TABLE>
<%@ include file="descriptionWindow.html" %>
<script>
   document.getElementById("descriptionWindowTextArea").style.height="200px";
   document.getElementById("descriptionWindowTextArea").style.width="120px";
</script>

</form>
</div>

<c:if test="${not empty updateGroups && !updateGroups}">
  <script language="JavaScript">
  //<!--
    setFormsReadOnly();
  //-->
  </script>
</c:if>

