<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<style type="text/css">
@import "admin/styles/preference.css";
</style>

<script language="JavaScript" src="admin/scripts/dynamicRows.js" type="text/javascript"></script>
<script language="JavaScript" src="admin/scripts/preference.js" type="text/javascript"></script>
<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<div id="propertyContentDiv">
<%-- TODO: Error handling code --%>
<c:url var="reloadURL" value="/viewPreferencesTree.action?treeSelectedItemId=${esapi:encodeForURL(propertyType)}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="System Properties Configuration" />
</tiles:insertTemplate>

<form id="propertyForm" name="propertyForm" action="<c:url value='saveSystemProperties.action'/>" method="post"  onsubmit="return submitPropertyForm(this, '${esapi:encodeForJavaScript(propertySubTypeLabel)}');">

<input type="hidden" name="method" value="saveProperties">
<input type="hidden" name="propertyType" value="${esapi:encodeForURL(propertyType)}">
<input type="hidden" name="propertySubType" value="${esapi:encodeForURL(propertySubType)}">
<input type="hidden" name="isSubTypeNode" value="${esapi:encodeForURL(isSubTypeNode)}">

<c:if test="${isSubTypeNode == true}">
				<fmt:message key="fcm.preferences.property.subtype.name.txt"/>&nbsp;&nbsp;
				<input id="subTypeLabel" name="propertySubTypeLabel" type="text" class="famTextEntry" value="${esapi:encodeForHTMLAttribute(propertySubTypeLabel)}" size="40" maxlength="100" onKeyDown="limitChars2(this,60,1);" onKeyUp="limitChars2(this,60,1,true, '${esapi:encodeForJavaScript(propertySubTypeLabel)}' );" />&nbsp; <br>
    		</c:if>
    		<c:if test="${isSubTypeNode == false}">
    			<input id="subTypeLabel" type="hidden" name="propertySubTypeLabel" value="${esapi:encodeForHTMLAttribute(propertySubTypeLabel)}">
    		</c:if>

<!-- main content header -->
<table class="mainTable" cellpadding="0" cellspacing="0" border="0" style="width:98%;margin:5px">

	<tr align="left" valign="top" >
		<td colspan="2" class="configurationTableSectionNoHover" style="padding:5px;"><fmt:message key="fcm.preferences.property.type.${esapi:encodeForHTMLAttribute(propertyType)}.txt" /></td>
	</tr>

	<tr>
		<td colspan="2" style="padding: 0px;" >

			<div id="propertyDiv" class="preferencesGrid" onscroll="repositionTHs(this)">

			<!-- main content header -->
			<table id="propertyTable"  cellspacing="0"  cellpadding="0"  class="mainTable"  style="border: none; border-collapse: separate;">
				<thead>
					<tr class="tableColumnHeaderRow">
						<th nowrap width="4%" class="centeredTableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.content.count.header.title" /> </th>
						<th nowrap width="15%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.property.name.header.title" /> &nbsp;</th>
						<th nowrap width="30%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.property.value.header.title" /> &nbsp;</th>

						<th nowrap width="15%" class="tableHeader" style="border-top: none;"><fmt:message key="fcm.preferences.property.label.header.title" /> &nbsp;</th>
						<th nowrap width="35%" class="tableHeader" style="border-top: none; border-right: none"><fmt:message key="fcm.preferences.property.description.header.title" /> &nbsp;</th>

					</tr>
				</thead>

				<tbody id="propertyTableBody">

				<c:forEach var="property" items="${properties}" varStatus="loop">

					<tr id='${loop.count}' class="dataRow${(loop.count-1)%2+1}_tableRow">
						<td class="imageTableCell" > ${loop.count} </td>
						<td class="textTableCell">${esapi:encodeForHTML(property.name)} </td>

						<td class="textTableCell"  onmousedown="highlightRowById(this.parentNode, 'rowSelected');">
                            <c:choose>
                                <c:when test="${property.editable}">
									<textarea class="famTextEntry" name="properties[${loop.index}].value" rows="4" wrap="soft" onkeydown="limitChars(this,1020);" onkeyup="limitChars(this,1020,true);">${esapi:encodeForHTML(property.value)}</textarea>&nbsp;&nbsp;
                                    <input type='hidden' name='properties[${loop.index}].name' value='${esapi:encodeForHTMLAttribute(property.name)}'>
                                </c:when>
                                <c:otherwise>
                                    <textarea class="famTextEntry" rows="4" wrap="soft" disabled="disabled" onkeydown="limitChars(this,1020);" onkeyup="limitChars(this,1020,true);">${esapi:encodeForHTML(property.value)}</textarea>&nbsp;&nbsp;
                                    <input type='hidden' name='properties[${loop.index}].value' value='${esapi:encodeForHTMLAttribute(property.value)}'>
                                    <input type='hidden' name='properties[${loop.index}].name' value='${esapi:encodeForHTMLAttribute(property.name)}'>
                                </c:otherwise>
                            </c:choose>
						</td>

						<td class="textTableCell">${esapi:encodeForHTML(property.label)}  </td>
						<td class="textTableCell lastCol">${esapi:encodeForHTML(property.description)}  </td>

					</tr>

				</c:forEach>

				</tbody>
			</table>
			<%-- end main content --%>

			</div>

			<%-- end main content -- up/down and content --%>

		</td>
	</tr>
</table>
<!-- end main content header -->

</form>

</div>

<c:if test="${not empty updateAdmins && !updateAdmins}">
	<script language="JavaScript" type="text/javascript">
    	setFormsReadOnly();
  	</script>
</c:if>

