<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<script language="JavaScript" src="admin/scripts/strategies.js"></script>
<script language="JavaScript" src="admin/scripts/listboxAssignments.js"></script>

<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>
<script language="JavaScript" src="admin/scripts/strategyTreeActions.js"></script>

<c:set var="currentlyAssignedToStrategyTxt"><fmt:message key='fcm.sq.strategy.currentlyAssignedToStrategy.txt'/></c:set>
<c:set var="notCurrentlyAssignedToAStrategyTxt"><fmt:message key="fcm.sq.strategy.notCurrentlyAssignedToAStrategy.txt"/></c:set>
<c:set var="memberOfTeamTxt"><fmt:message key='fcm.sq.strategy.memberOfTeam.txt'/></c:set>
<c:set var="notAssignedToATeamTxt"><fmt:message key='fcm.sq.strategy.notAssignedToATeam.txt'/></c:set>
<c:set var="analystKeyFieldName"><fmt:message key='fcm.sq.strategy.analystKeyFieldName.txt'/></c:set>

<script language="JavaScript">
//<!--
i18n.init();

var groupList= new Array();
var groupData= new Array();

<c:forEach var="group" items="${groups}">
	var group = new Object();
	group.id=${group.id};
	group.name="${esapi:encodeForJavaScript(group.name)}";
	group.bu=${group.businessUnit};
	group.isSelected = ${sa_strategy.groupId == group.id};
	groupList.push(group);
</c:forEach>

var teamList = new Array();
var teamHashMap = new Array();

//use optgroups instead???

var team=new Object();
team.id=-1;
team.label="- <fmt:message key="fcm.sq.strategy.allRepresentatives.txt"/> -";
teamList.push(team);
<c:forEach var="team" items="${teams}">
      var team=new Object();
      team.id=${team.id};
      team.label="${esapi:encodeForJavaScript(esapi:encodeForHTML(team.groupName))}-${esapi:encodeForJavaScript(esapi:encodeForHTML(team.name))}";
      team.bu=${team.businessUnit};
      teamList.push(team);
      teamHashMap["T${team.id}"] = "${esapi:encodeForJavaScript(team.name)}";
</c:forEach>

var analystListMap = [];
<c:forEach var="gridTemplate" items="${gridTemplates}">
//  alert("gridTemplateId 1: " + ${gridTemplate.id});
    <c:if test="${gridAnalystMap.containsKey(gridTemplate.id)}">
        var analystList = [];
        var keyFieldList = [];
        <c:forEach var="analyst" items="${gridAnalystMap[gridTemplate.id]}" >

        	<c:set var="buId">${analyst.businessUnitId}</c:set>
         	<c:set var="tenant" value="${buTenants[buId]}"/>
        	<c:set var="tenantPrefix" value=""/>
       		<c:set var="tenantLabel" value=""/>
			<c:if test="${callCenterType == 'T'}">
				<c:set var="tenantPrefix" value="[${tenant.label}] "/>
				<c:set var="tenantLabel" value="${tenant.label}"/>
			</c:if>
        	<c:set var="label">${tenantPrefix}${analyst.name} (${analyst.analystColumn.name})</c:set>
			<c:set var="label">${esapi:encodeForJavaScript(esapi:encodeForHTML(label))}</c:set>

            var analyst = new Object();
            analyst.id = ${analyst.id};
            analyst.name  = "${label}";
            analyst.label = "${label}";
            analyst.keyField = "${esapi:encodeForJavaScript(esapi:encodeForHTML(analyst.analystColumn.name))}";
            analyst.isAssigned = false;
            analyst.isDuplicated = false;
            analyst.tenantId = "${tenant.id}";
            analyst.tenantLabel = "${esapi:encodeForJavaScript(tenantLabel)}";

            <c:forEach var="assignedAnalystId" items="${sa_strategy.analystListIds}" >
                <c:if test="${analyst.id==assignedAnalystId}">
                    analyst.isAssigned = true;
                    keyFieldList.push(analyst.keyField);
                </c:if>
            </c:forEach>

            if(analyst.isAssigned)
            {
                analyst.text = "${esapi:encodeForJavaScript(analystKeyFieldName)} " + " ${esapi:encodeForJavaScript(esapi:encodeForHTML(analyst.analystColumn.name))}";
            } else {
                analyst.text = "${esapi:encodeForJavaScript(analystKeyFieldName)} " + " ${esapi:encodeForJavaScript(esapi:encodeForHTML(analyst.analystColumn.name))}";
            }
            analystList.push(analyst);
        </c:forEach>

        for(var i = 0, len = analystList.length; i < len; i++)
        {
            var analyst = analystList[i];
            if(!analyst.isAssigned)
            {
                var idx = keyFieldList.indexOf(analyst.keyField);
                if(idx != -1)
                {
                    analystList[i].isDuplicated = true;
                    analystList[i].label = "* " + analyst.name;
                }
            }
        }
        analystListMap["T${gridTemplate.id}"] = analystList;
    </c:if>
</c:forEach>

var analystList = [];
if(analystListMap["T${sa_strategy.gridTemplate}"] != undefined && analystListMap["T${sa_strategy.gridTemplate}"].length!= 0 )
{
    analystList = analystListMap["T${sa_strategy.gridTemplate}"];
    //alert("analystListMap: "+ analystListMap["T${sa_strategy.gridTemplate}"][0].id);
}

var queueList = new Array();
<c:forEach var="queue" items="${queues}" >
      var queue = new Object();
      queue.id = ${queue.id};
      queue.label = "${esapi:encodeForJavaScript(esapi:encodeForHTML(queue.name))}";
      <c:if test="${not empty queue.strategyId}">
         queue.text = "${esapi:encodeForJavaScript(currentlyAssignedToStrategyTxt)} - ${esapi:encodeForJavaScript(queue.strategyName)}";
         queue.isAssigned = (${queue.strategyId==sa_strategy.id});
         if(!queue.isAssigned) queue.label = "* "+queue.label;
      </c:if>
      <c:if test="${empty queue.strategyId}">
         queue.text = "${esapi:encodeForJavaScript(notCurrentlyAssignedToAStrategyTxt)}";
         queue.isAssigned = false;
      </c:if>
      queueList.push(queue);
</c:forEach>

var userList = new Array()
<c:forEach var="user" items="${users}">
      var user = new Object();
           user.id = ${user.id};
           user.label = "${esapi:encodeForJavaScript(esapi:encodeForHTML(user.lastName))}, ${esapi:encodeForJavaScript(esapi:encodeForHTML(user.firstName))}";
           user.bu=${user.businessUnits}
           user.isAssigned = (${assignedUsers[user.id]==true});
           tm = null;
        <c:if test="${user.teamId gt 0}">
           tm = teamHashMap["T${user.teamId}"];
           user.teamId = ${user.teamId};
        </c:if>
           if(tm)
           {
              user.text = "(${esapi:encodeForJavaScript(esapi:encodeForHTML(user.username))}) ${esapi:encodeForJavaScript(memberOfTeamTxt)} - " + tm;
           }
           else
           {
     			user.label = "- "+user.label;
     			user.text = "(${esapi:encodeForJavaScript(esapi:encodeForHTML(user.username))}) ${esapi:encodeForJavaScript(notAssignedToATeamTxt)}";
     }
     userList.push(user);
</c:forEach>
teamHashMap = undefined;

var scriptList = new Array();
<c:forEach var="scripts" items="${callScripts}" varStatus="status">
   var script = new Object();
   script.id = ${scripts.id};
   script.label = "${esapi:encodeForJavaScript(esapi:encodeForHTML(scripts.name))}";
   script.text = "${esapi:encodeForJavaScript(esapi:encodeForHTML(fn:substring(scripts.text,0,100)))}";
   script.bu= ${scripts.businessUnit};
   script.isAssigned = (${assignedScripts[scripts.id]==true});
   script.isDefault = ${scripts.id == sa_strategy.defaultCallScript};
   scriptList.push(script);
</c:forEach>

var memoList = new Array();
<c:forEach var="memos" items="${predefinedMemos}" varStatus="status">
   var memo = new Object();
   memo.id = ${memos.id};
   memo.label = "${esapi:encodeForJavaScript(esapi:encodeForHTML(memos.name))}";
   memo.text = "${esapi:encodeForJavaScript(esapi:encodeForHTML(fn:substring(memos.text,0,100)))}"
   memo.bu=${memos.businessUnit};
	memo.isAssigned = (${esapi:encodeForJavaScript(assignedMemos[memos.id]==true)});
	memo.isDefault = ${memos.id == sa_strategy.defaultPredefinedMemo}
   memoList.push(memo);
</c:forEach>

<%--
var blockCodeList = new Array();
<c:forEach var="blockCode" items="${blockCodes}">
   var blockCode = new Object();
   blockCode.id = "${esapi:encodeForJavaScript(blockCode)}";
   blockCode.isAssigned = (${assignedBlockCodes[blockCode]==true});
   blockCodeList.push(blockCode);
</c:forEach>
--%>

var teamData=new Array();
for(var i = 0; i < teamList.length; i++){
	if(teamList[i].bu===undefined)teamData.push(teamList[i]);//for all representatives
	if(teamList[i].bu === ${sa_strategy.businessUnit}){
	   teamData.push(teamList[i]);
	}
}

var userData= new Array();
for(var i = 0; i < userList.length; i++){
	for(var j=0;j<userList[i].bu.length;j++){
		if(userList[i].bu[j] === ${sa_strategy.businessUnit}){
		   userData.push(userList[i]);
		}
	}
}
var scriptData= new Array();
for(var i = 0; i < scriptList.length; i++){
	if(scriptList[i].bu === ${sa_strategy.businessUnit}){
	   scriptData.push(scriptList[i]);
	   if(scriptList[i].isDefault)
		   _defaultTemplateIds[_callScriptType] = scriptData.length-1;
	}

}

var memoData= new Array();

for(var i = 0; i < memoList.length; i++){
	if(memoList[i].bu === ${sa_strategy.businessUnit}){
	   memoData.push(memoList[i]);
	   if(memoList[i].isDefault)
		   _defaultTemplateIds[_memoType] = memoData.length-1;
	}

}
//-->
</script>
<!-- Main Content -->

<DIV>
<%-- Error handling code --%>
<c:url var="reloadURL" value="/listStrategyTree.action?sa_strategyId=${sa_strategy.id}"/>
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="user" />
</tiles:insertTemplate>

<form id="strategyForm" name="strategyForm" action="<c:url value='/saveStrategy.action'/>" method="post" onsubmit="return submitStrategyForm(this)">
<input type="hidden" name="method" value="save">
<input type="hidden" name="id" value="${sa_strategy.id}">
<input type="hidden" name="version" value="${sa_strategy.version}">
<input type="hidden" name="serviceMode">
<input type="hidden" name="oldBusinessUnit" value="${esapi:encodeForHTMLAttribute(sa_strategy.oldBusinessUnit)}">
<input type="hidden" name="defaultCallScript" id="defaultCallScript" value="${esapi:encodeForHTMLAttribute(sa_strategy.defaultCallScript)}">
<input type="hidden" name="defaultPredefinedMemo" id="defaultPredefinedMemo" value="${esapi:encodeForHTMLAttribute(sa_strategy.defaultPredefinedMemo)}">

<TABLE id="strategyDefinitionTable" class="configurationTable" style="width:600px;margin-left:5px" cellspacing="0" cellpadding="2" border="0" >

    <tr align="left" valign="top" onclick="showDiv($('#generalPropertiesImg')[0], 'generalPropertiesBlock');">
      <td colspan="3" class="configurationTableSection" style="padding:5px;">
<!--      	<img id="generalPropertiesImg" src="admin/images/sprite_arrow_down_light.png" align="middle" /> -->
		<span id="generalPropertiesImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06e;"></span>
      	&nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.definition.txt" />
      </td>
    </tr>

<tr id="generalPropertiesBlock" class="configurationTableDataRow" valign="top">
<td colspan="2">
<table class="minimalPadding" cellpadding="0" cellspacing="0" border="0">
    <tr class="configurationTableDataRow" valign="top">
      <td scope="col"><fmt:message key="fcm.sq.strategy.id.txt" />:</td>
      <td  valign="middle" scope="col">${sa_strategy.id}</td>
    </tr>
    <tr class="configurationTableDataRow" valign="top">
      <td scope="col"><fmt:message key="fcm.details.name.txt" />:</td>
      <td  valign="middle" scope="col"><input class="famTextEntry" name="name" type="text" value="${esapi:encodeForHTMLAttribute(sa_strategy.name)}" size="61" maxLength="50" /></td>
    </tr>
    <tr class="configurationTableDataRow" valign="top">
      <td><fmt:message key="fcm.details.description.txt" />: </td>
      <td valign="middle" scope="col"><textarea class="famTextEntry" name="description" cols="60" rows="4" wrap="PHYSICAL" onKeyDown="limitChars(this,100);" onKeyUp="limitChars(this,100,true);">${esapi:encodeForHTML(sa_strategy.description)}</textarea></td>
    </tr>

    <tr class="configurationTableDataRow" valign="middle">
      <td><fmt:message key="fcm.details.bu.txt" />: </td>
      <td valign="middle" scope="col">
        <select name="businessUnit" id="buId" class="famSelect" onchange="modifySelectionChoices(this,'<esapi:encodeForJavaScript><fmt:message key="fcm.sq.strategy.js.alert0.txt"/></esapi:encodeForJavaScript>');">
         <c:forEach var="businessUnit" items="${businessUnits}">
            <c:set var="sltd" value=""/>
            <c:if test="${sa_strategy.businessUnit == businessUnit.id}">
               <c:set var="sltd" value="SELECTED"/>
            </c:if>
            <option value="${businessUnit.id}" ${sltd}>${esapi:encodeForHTML(businessUnit.name)}</option>
         </c:forEach>
        </select>
      </td>
    </tr>
    <tr class="configurationTableDataRow" valign="middle">
          <td><fmt:message key="fcm.details.gridTemplate.txt" />: </td>
          <td valign="middle" scope="col">
            <select name="gridTemplate" id="gridTemplateId" class="famSelect" onchange="modifyAnalystSelection(this, analystListMap, '<esapi:encodeForJavaScript><fmt:message key="fcm.sq.strategy.js.alert1.txt"/></esapi:encodeForJavaScript>');">
             <c:forEach var="gridTemplate" items="${gridTemplates}">
                <c:set var="sltd" value=""/>
                <c:if test="${sa_strategy.gridTemplate == gridTemplate.id}">
                   <c:set var="sltd" value="SELECTED"/>
                </c:if>
                <option value="${gridTemplate.id}" ${sltd}>${esapi:encodeForHTML(gridTemplate.name)}</option>
             </c:forEach>
            </select>
          </td>
    </tr>

    <tr class="configurationTableDataRow" valign="middle">
      <td><fmt:message key="fcm.sq.strategy.groupOwner.txt" />:</td>
      <td valign="middle" scope="col"><select name="groupId" id="groupId" class="famSelect">
         <option value=""><fmt:message key="fcm.sq.strategy.noneSelected.txt"/></option>
         <c:forEach var="group" items="${groups}">
            <c:set var="sltd" value=""/>
            <c:if test="${sa_strategy.groupId == group.id}">
               <c:set var="sltd" value="SELECTED"/>
            </c:if>
            <c:if test="${sa_strategy.businessUnit == group.businessUnit}">
            	<option value="${group.id}" ${sltd}>${esapi:encodeForHTML(group.name)}</option>
            </c:if>
         </c:forEach>

        </select>
      </td>
    </tr>
<%--
    <tr class="configurationTableDataRow" valign="middle">
      <td valign="top" ><fmt:message key="fcm.sq.strategy.blockCodes.txt" />:</td>
      <td valign="top" scope="col"><select name="blockCodesSelected" class="famSelect" size="2" multiple="true" >
          <script>
               for(var i = 0; i < blockCodeList.length; i++)
               {
                  var blockCodeObj = blockCodeList[i];
                  var assigned = blockCodeObj.isAssigned?"SELECTED":"";
                  document.write('<option value="'+blockCodeObj.id+'" '+ assigned  +' >'+blockCodeObj.id+'&nbsp;&nbsp;&nbsp;</option>');
               }
            </script>
        </select>
      </td>
    </tr>
--%>
    <tr class="configurationTableDataRow" valign="middle">
      <td><fmt:message key="fcm.sq.status.txt" />:</td>
      <td valign="middle" scope="col">

         <input name="status" type="radio" value="ACTIVE"    /><fmt:message key="fcm.sq.status.active.txt" />&nbsp;&nbsp;
         <input name="status" type="radio" value="INACTIVE"  /><fmt:message key="fcm.sq.status.inactive.txt" />&nbsp;&nbsp;

         <script>

            <c:choose>
               <c:when test="${fn:contains(sa_strategy.status,'INACTIVE')}">
                  document.strategyForm.status[1].checked = true;
               </c:when>
               <c:otherwise>
                  document.strategyForm.status[0].checked = true;
               </c:otherwise>

            </c:choose>

         </script>
      </td>
    </tr>
    <tr class="configurationTableDataRow" valign="middle">
      <td><fmt:message key="fcm.sq.strategy.type.txt" />:</td>
      <td valign="middle" scope="col">

         <select name="type" class="famSelect" onchange="enableOutboundProperties(document.strategyForm,this)">
            <option value="EML"><fmt:message key="fcm.sq.strategy.email.txt"/></option>
            <option value="LTR"><fmt:message key="fcm.sq.strategy.letter.txt"/></option>
            <option value="OUT"><fmt:message key="fcm.sq.strategy.outbound.txt"/></option>
            <option value="SMS"><fmt:message key="fcm.sq.strategy.sms.txt"/></option>
         </select>

         <script>

            <c:choose>
               <c:when test="${sa_strategy.type == 'EML'}">
                  document.strategyForm.type[0].selected = true;
               </c:when>
               <c:when test="${sa_strategy.type == 'LTR'}">
                  document.strategyForm.type[1].selected = true;
               </c:when>
               <c:when test="${sa_strategy.type == 'OUT'}">
                  document.strategyForm.type[2].selected = true;
               </c:when>
               <c:when test="${sa_strategy.type == 'SMS'}">
                  document.strategyForm.type[3].selected = true;
               </c:when>
            </c:choose>

         </script>
      </td>
    </tr>
    <tr class="configurationTableDataRow" valign="top">
      <td><fmt:message key="fcm.sq.strategy.alertRouting.txt" />: </td>
      <td valign="top" scope="col">
          <input type="checkbox" name="priorityServiceMode" value="P" /><fmt:message key="fcm.sq.strategy.priorityBasedServicing.txt"/><br />
             &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.routeAlertsToNextAvailableRepresentative.txt"/><br />
             <br />
          <input type="checkbox" name="directServiceMode" value="D"  /><fmt:message key="fcm.sq.strategy.directServicing.txt"/><br />
             &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.allowAuthorizedRepresentatives.txt"/><br /><br />
          <script>
            <c:choose>
               <c:when test="${sa_strategy.serviceMode == 'D'}">
                  document.strategyForm.directServiceMode.checked = true;
               </c:when>
               <c:when test="${sa_strategy.serviceMode == 'P'}">
                  document.strategyForm.priorityServiceMode.checked = true;
               </c:when>
               <c:when test="${sa_strategy.serviceMode == 'A'}">
                  document.strategyForm.directServiceMode.checked = true;
                  document.strategyForm.priorityServiceMode.checked = true;
               </c:when>
            </c:choose>

         </script>
      </td>
    </tr>
</table><br/>&nbsp;
</td>
</tr>

    <!-- Analyst's List Assignment Selection -->

    <tr onclick="showDiv($('#analystAssignmentImg')[0], 'analystAssignmentBlock');dismissPopup('addAnalysts');">
      <td style="padding:5px; colspan="2" class="configurationTableSection" >
         <span id="analystAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
         &nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.analystAssignment.txt" />
      </td>
   </tr>

   <tr id="analystAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>
   <tr class="configurationTableDataRow">
     <td colspan="2" nowrap><br>
       <a id="addAnalystsAnchor" class="menuItemButton" onClick="showDropDownMenu('addAnalysts',[document.strategyForm.assignedAnalystsListbox]);return false;" href="#">
          <fmt:message key="fcm.details.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
       </a>
       &nbsp;
       <a id="removeAnalystsAnchor" class="menuItemButton" onClick="moveSelectedOptionsAnalyst(document.strategyForm.assignedAnalystsListbox,document.strategyForm.unassignedAnalystsListbox,false,analystList);return false;" href="#">
         <fmt:message key="fcm.details.remove.txt"/>
       </a>
     </td>
   </tr>
   <tr class="configurationTableDataRow">
     <td colspan="2" >
        <div id="assignedAnalystsContainer" style="display:inline">
           <select name="assignedAnalystsListbox" class="famSelect" style="width:25em" size="6" multiple onChange="hideDescription()">
           </select>
           <a style="vertical-align:top" onClick="showDescription(this,'analystList',document.strategyForm.assignedAnalystsListbox);return false;" href="#">
             <span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf330;" title="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>"></span>
           </a>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(analystList,'assignedAnalystsContainer',true);
         //-->
        </script>
     <br></td>
   </tr>
</table>
</td>
</tr>

    <!-- Queue Assignment Selection -->

    <tr onclick="showDiv($('#queueAssignmentImg')[0], 'queueAssignmentBlock');dismissPopup('addQueues');">
      <td style="padding:5px; colspan="2" class="configurationTableSection" >
		 <span id="queueAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
      	 &nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.queueAssignment.txt" />
      </td>
   </tr>

   <tr id="queueAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>

   <tr class="configurationTableDataRow">
     <td colspan="2" nowrap><br>
       <a id="addQueuesAnchor" class="menuItemButton" onClick="showDropDownMenu('addQueues',[document.strategyForm.assignedQueuesListbox]);return false;" href="#">
          <fmt:message key="fcm.details.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
       </a>
       <%--S1315396: Unable to remove a queue from Strategy->Queue Assignment
       &nbsp;
       <a id="removeQueuesAnchor" class="menuItemButton" onClick="moveSelectedOptions(document.strategyForm.assignedQueuesListbox,document.strategyForm.unassignedQueuesListbox,false,queueList);return false;" href="#">
         <fmt:message key="fcm.details.remove.txt"/>
       </a>
       --%>
     </td>
   </tr>
   <tr class="configurationTableDataRow">
     <td colspan="2" >
        <div id="assignedQueuesContainer" style="display:inline">
           <select name="assignedQueuesListbox" class="famSelect" style="width:25em" size="6" multiple onChange="hideDescription()">
           </select>
           <a style="vertical-align:top" onClick="showDescription(this,'queueList',document.strategyForm.assignedQueuesListbox);return false;" href="#">
           <!--         <img src="common/images/infoBlue.gif" alt="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>" border="0" width="16" height="16" align="top" /> -->
           	 <span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf330;" title="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>"></span>
           </a>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(queueList,'assignedQueuesContainer',true);
         //-->
        </script>
     </td>
   </tr>

   </table>
</td>
</tr>

   <!-- User Assignment Selection -->
    <tr onclick="showDiv($('#repAssignmentImg')[0], 'repAssignmentBlock');dismissPopup('addUsers');">
      <td style="padding:5px;" id="configAddUsersLabel" colspan="2" class="configurationTableSection">
<!--         <img id="repAssignmentImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
		 <span id="repAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
         &nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.repAssignment.txt" />
      </td>
   </tr>

<tr id="repAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>

   <tr class="configurationTableDataRow">
     <td colspan="2" nowrap><br>
       <a id="addUsersAnchor" class="menuItemButton" onClick="showDropDownMenu('addUsers',[document.strategyForm.assignedUsersListbox]);return false;" href="#">
          <fmt:message key="fcm.details.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
       </a>
       &nbsp;
       <a id="removeUsersAnchor" class="menuItemButton" onClick="moveSelectedOptions(document.strategyForm.assignedUsersListbox,document.strategyForm.unassignedUsersListbox,false,userData);return false;" href="#">
         <fmt:message key="fcm.details.remove.txt"/>
       </a>
     </td>
   </tr>
   <tr class="configurationTableDataRow">
     <td colspan="2" >
        <div id="assignedUsersContainer" style="display:inline">
           <select name="assignedUsersListbox" class="famSelect" style="width:25em" size="6" multiple onChange="hideDescription()">
           </select>
           <a style="vertical-align:top" id="helpUsersAnchor" onClick="showDescription(this,'userData',document.strategyForm.assignedUsersListbox);return false;" href="#">
           <!--         <img src="common/images/infoBlue.gif" alt="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>" border="0" width="16" height="16" align="top" /> -->
           	 <span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf330;" title="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>"></span>
           </a>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(userData,'assignedUsersContainer',true);
         //-->
        </script>
     </td>
   </tr>

</table>
</td>
</tr>

   <!-- Call Script Assignment Selection -->
    <tr onclick="showDiv($('#scriptAssignmentImg')[0], 'scriptAssignmentBlock');dismissPopup('addCallScripts');">
      <td style="padding:5px;" id="configAddCallScriptsLabel" colspan="2" class="configurationTableSection">
<!--         <img id="scriptAssignmentImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
		 <span id="scriptAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
         &nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.scriptAssignment.txt" />
      </td>
   </tr>

   <tr id="scriptAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>

   <tr class="configurationTableDataRow">
     <td colspan="2" nowrap><br>
       <a id="addCallScriptsAnchor" class="menuItemButton" onClick="showDropDownMenu('addCallScripts',[document.strategyForm.assignedCallScriptsListbox]);selectDefaultItem(event,'assignedCallScriptsListbox');return false;" href="#">
          <fmt:message key="fcm.details.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
       </a>
       &nbsp;
       <a id="removeCallScriptsAnchor" class="menuItemButton" onClick="moveSelectedOptions(document.strategyForm.assignedCallScriptsListbox,document.strategyForm.unassignedCallScriptsListbox,false,scriptData);selectDefaultItem(event,'assignedCallScriptsListbox');return false;" href="#">
         <fmt:message key="fcm.details.remove.txt"/>
       </a>
       &nbsp;
       <a id="setDefaultCallScriptsAnchor" class="menuItemButton" onClick="setAsDefaultItem(event,'assignedCallScriptsListbox');return false;" href="#">
         <fmt:message key="fcm.sq.queue.setAsDefault.txt"/>
       </a>
     </td>
   </tr>
   <tr class="configurationTableDataRow">
     <td colspan="2" >
        <div id="assignedCallScriptsContainer" style="display:inline">
           <select name="assignedCallScriptsListbox" class="famSelect" style="width:25em" size="6" multiple  onChange="hideDescription()">
           </select>
           <a style="vertical-align:top" id="helpCallScriptsAnchor" onClick="showDescription(this,'scriptData',document.strategyForm.assignedCallScriptsListbox);return false;" href="#">
           <!--         <img src="common/images/infoBlue.gif" alt="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>" border="0" width="16" height="16" align="top" /> -->
           	 <span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf330;" title="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>"></span>
           </a>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(scriptData,'assignedCallScriptsContainer',true);
         //-->
        </script>
        <div>
        	<b><fmt:message key="fcm.sq.queue.default.txt"/></b>:  <label id="defaultCallScriptDisplay"/>
        </div>
     </td>
   </tr>

   </table>
</td>
</tr>

   <!-- Memo Assignment Selection -->
    <tr onclick="showDiv($('#memoAssignmentImg')[0], 'memoAssignmentBlock');dismissPopup('addMemos');">
      <td style="padding:5px;" colspan="2" class="configurationTableSection">
<!--         <img id="memoAssignmentImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
		 <span id="memoAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
         &nbsp;&nbsp;<fmt:message key="fcm.sq.strategy.memoAssignment.txt" />
      </td>
   </tr>

   <tr id="memoAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>

   <tr class="configurationTableDataRow">
     <td colspan="2" nowrap><br>
       <a id="addMemosAnchor" class="menuItemButton" onClick="showDropDownMenu('addMemos',[document.strategyForm.assignedMemosListbox]);return false;" href="#">
          <fmt:message key="fcm.details.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
       </a>
       &nbsp;
       <a id="removeMemosAnchor" class="menuItemButton" onClick="moveSelectedOptions(document.strategyForm.assignedMemosListbox,document.strategyForm.unassignedMemosListbox,false,memoData);selectDefaultItem(event,'assignedMemosListbox');return false;" href="#">
         <fmt:message key="fcm.details.remove.txt"/>
       </a>
       &nbsp;
       <a id="setDefaultMemosAnchor" class="menuItemButton" onClick="setAsDefaultItem(event,'assignedMemosListbox');return false;" href="#">
         <fmt:message key="fcm.sq.queue.setAsDefault.txt"/>
       </a>

     </td>
   </tr>
   <tr class="configurationTableDataRow">
     <td colspan="2" >
        <div id="assignedMemosContainer" style="display:inline">
            <select name="assignedMemosListbox" class="famSelect" style="width:25em" size="6" multiple  onChange="hideDescription()">
            </select>
            <a style="vertical-align:top" onClick="showDescription(this,'memoData',document.strategyForm.assignedMemosListbox);return false;" href="#">
            <!--         <img src="common/images/infoBlue.gif" alt="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>" border="0" width="16" height="16" align="top" /> -->
            	 <span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf330;" title="<fmt:message key='fcm.application.highlightItemForDescription.txt'/>"></span>
            </a>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(memoData,'assignedMemosContainer',true);
         //-->
        </script>
        <div>
        	<b><fmt:message key="fcm.sq.queue.default.txt"/></b>:  <label id="defaultMemoDisplay"/>
        </div>
     </td>
   </tr>

   </table>
</td>
</tr>

</table><!-- end strategy definition table -->

<!-- Description Window for items in the assignment listboxes -->
<%@ include file="descriptionWindow.html" %>

<!-- End Description Window for items in the assignment listboxes -->

<!-- Hidden menus -->
<!-- Analysts -->
<div id="addAnalystsDiv" style="visibility:hidden;position:absolute;z-index:30;">
 <table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
   <tr>
     <td align="left">
        <div id="unassignedAnalystsContainer" style="display:inline">
           <select name="unassignedAnalystsListbox" class="famSelect" style="width:25em" size="6" multiple onChange="hideDescription()">
           </select>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(analystList,'unassignedAnalystsContainer',false);
         //-->
        </script>
        <br>
        [*] <fmt:message key="fcm.sq.strategy.indicatesAnalystIsAlreadyAssigned.txt"/>
     </td>
   </tr>
   <tr>
     <td align="left" >
        <input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onClick="moveSelectedOptionsAnalyst(document.strategyForm.unassignedAnalystsListbox,document.strategyForm.assignedAnalystsListbox,true,analystList);hideDropDownMenu('addAnalysts',[document.strategyForm.assignedAnalystsListbox])">
        <input id="addAnalystsClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onClick="hideDropDownMenu('addAnalysts',[document.strategyForm.assignedAnalystsListbox])">
     </td>
   </tr>
  </table>
</div>

<!-- Queues -->
<div id="addQueuesDiv" style="visibility:hidden;position:absolute;z-index:30;">
 <table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
   <tr>
     <td align="left">
        <div id="unassignedQueuesContainer" style="display:inline">
           <select name="unassignedQueuesListbox" class="famSelect" style="width:25em" size="6" multiple onChange="hideDescription()">
           </select>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(queueList,'unassignedQueuesContainer',false);
         //-->
        </script>
        <br>
        [*] <fmt:message key="fcm.sq.strategy.indicatesQueueIsAlreadyAssigned.txt"/>
     </td>
   </tr>
   <tr>
     <td align="left" >
        <input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onClick="moveSelectedOptions(document.strategyForm.unassignedQueuesListbox,document.strategyForm.assignedQueuesListbox,true,queueList);hideDropDownMenu('addQueues',[document.strategyForm.assignedQueuesListbox])">
        <input id="addQueuesClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onClick="hideDropDownMenu('addQueues',[document.strategyForm.assignedQueuesListbox])">
     </td>
   </tr>
  </table>
</div>

<!-- Users -->
<div id="addUsersDiv" style="visibility:hidden;position:absolute;z-index:30;">
 <table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
   <tr>
      <td align="left">
         <fmt:message key="fcm.sq.strategy.filterAvailableRepresentativesBy.txt"/>:<br>
	 <select name="teams" id="teams" class="famSelect" onChange="showUnassignedRepsByTeam(document.strategyForm.unassignedUsersListbox,document.strategyForm.teams.options[document.strategyForm.teams.selectedIndex].value);">
	 </select>
         <script>
         	loadSelectBox(teamData,'teams');
         </script>
      </td>
   </tr>
   <tr>
     <td align="left">
        <div id="unassignedUsersContainer" style="display:inline">
           <select name="unassignedUsersListbox" class="famSelect" style="width:25em" size="3" multiple onChange="hideDescription()">
           </select>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(userData,'unassignedUsersContainer',false);
         //-->
        </script>
        <br>
        [-] <fmt:message key="fcm.sq.strategy.indicatesUserNotAssigned.txt"/>
     </td>
   </tr>
   <tr>
     <td align="left" >
        <input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onClick="moveSelectedOptions(document.strategyForm.unassignedUsersListbox,document.strategyForm.assignedUsersListbox,true,userData);hideDropDownMenu('addUsers',[document.strategyForm.assignedUsersListbox]);resetTeamSelection(document.strategyForm.teams,document.strategyForm.unassignedUsersListbox)">
        <input id="addUsersClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onClick="hideDropDownMenu('addUsers',[document.strategyForm.assignedUsersListbox]);resetTeamSelection(document.strategyForm.teams,document.strategyForm.unassignedUsersListbox)">
     </td>
   </tr>
  </table>
</div>

<!-- Scripts -->
<div id="addCallScriptsDiv" style="visibility:hidden;position:absolute;z-index:30;">
 <table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
   <tr>
     <td align="left">
        <div id="unassignedCallScriptsContainer" style="display:inline">
           <select name="unassignedCallScriptsListbox" class="famSelect" style="width:25em" size="6" multiple onChange="hideDescription()">
           </select>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(scriptData,'unassignedCallScriptsContainer',false);
         //-->
        </script>
     </td>
   </tr>
   <tr>
     <td align="left" >
        <input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onClick="moveSelectedOptions(document.strategyForm.unassignedCallScriptsListbox,document.strategyForm.assignedCallScriptsListbox,true,scriptData);hideDropDownMenu('addCallScripts',[document.strategyForm.assignedCallScriptsListbox]);selectDefaultItem(event,'assignedCallScriptsListbox');">
        <input id="addCallScriptsClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onClick="hideDropDownMenu('addCallScripts',[document.strategyForm.assignedCallScriptsListbox])">
     </td>
   </tr>
  </table>
</div>

<!-- Memos -->
<div id="addMemosDiv" style="visibility:hidden;position:absolute;z-index:30;">
 <table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
   <tr>
     <td align="left">
        <div id="unassignedMemosContainer" style="display:inline">
           <select name="unassignedMemosListbox" class="famSelect" style="width:25em" size="6" multiple  onChange="hideDescription()">
           </select>
        </div>
        <script>
         //<!--
            loadListboxByAssignment(memoData,'unassignedMemosContainer',false);
         //-->
        </script>
     </td>
   </tr>
   <tr>
     <td align="left" >
        <input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onClick="moveSelectedOptions(document.strategyForm.unassignedMemosListbox,document.strategyForm.assignedMemosListbox,true,memoData);hideDropDownMenu('addMemos',[document.strategyForm.assignedMemosListbox]);selectDefaultItem(event,'assignedMemosListbox');">
        <input id="addMemosClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onClick="hideDropDownMenu('addMemos',[document.strategyForm.assignedMemosListbox])">
     </td>
   </tr>
  </table>
</div>
<!-- End Hidden menus -->

   <script>
      enableOutboundProperties(document.strategyForm,document.strategyForm.type);
   </script>
</form>
</DIV>

<script>
selectDefaultItem(event,'assignedCallScriptsListbox');
selectDefaultItem(event,'assignedMemosListbox');
<c:if test="${not empty updateStrategies && !updateStrategies }">
//<!--
setFormsReadOnly();
//-->
</c:if>

</script>
