

function submitTemplateForm(formObj)
{
	var pattern = /<\/?script[\w\W]*>/i;
	if ( pattern.test(formObj.text.value) )
	{
		alert($i18n("fcm.templates.js.submitTemplateForm.hasScript.txt"));
		formObj.text.select();
		formObj.text.focus();
		return false;
	}

   var maxSize = formObj.text.maxLength;
   var currSize = formObj.text.value.length;
   if(!validateDescriptionLength(formObj.text.value, maxSize))
   {
      alert($i18n("fcm.templates.js.submitTemplateForm.overMaxSize.fmt.txt", [currSize, maxSize]));
      formObj.text.select();
      formObj.text.focus();
      return false;
   }

   setBusy();
   return true;
}

function doTemplateAction(userAction)
{
  // alert("Inside template action: " + userAction);
  if(userAction == 'newMemo' || userAction == 'newCallScript' || userAction == 'newEML' || userAction == 'newSMS' || userAction == 'newLTR' )
  {
      doNewAction(userAction);
  }
  else if(userAction == 'save' )
  {
      doTemplateSaveAction(userAction);
  }
  else if(userAction == 'delete' || userAction == 'copy' )
  {
      if(userAction == 'delete'){
    	  var associatedStrategies = document.getElementById("associatedStrategies");
    	  var associatedQueues = document.getElementById("associatedQueues");

    	  if(associatedStrategies!=null){
    		  if(associatedStrategies.value=="true"){
    			  alert($i18n("fcm.templates.js.doTemplateAction.alert1.txt"));
    		  }else{
            	  doDeleteOrCopyAction(userAction);
    		  }
    	  }
    	  if(associatedQueues!=null){
    		  if(associatedQueues.value=="true"){
    			  alert($i18n("fcm.templates.js.doTemplateAction.alert2.txt"));
    		  }else{
            	  doDeleteOrCopyAction(userAction);
    		  }
          }
      }else{
    	  doDeleteOrCopyAction(userAction);
      }
  }
  else if(userAction == 'showDetail')
  {
      doModifyAction(userAction);
  }
  else
  {
      alert($i18n("fcm.templates.js.doTemplateAction.alert0.fmt.txt",[userAction]));
  }
}

function doNewAction(userAction)
{
   var method = '';
   var selectedNodes = parent.frames['overview']._tree.getSelectedNodes();

   if(isDefined(selectedNodes[0]) && selectedNodes[0].getMark() == parent.frames["overview"].MARKS[0]){
   	var businessUnit='?businessUnit='+ selectedNodes[0].parameters[0];
   }
   else{
   	alert($i18n("fcm.templates.js.doNewAction.alert0.txt"));
   	  return;
   }
   
   if(userAction == 'newMemo')
   {
      method = 'createMemo.action';

   }
   else if(userAction == 'newCallScript')
   {
      method = 'createCallScript.action';
   }
   else if(userAction == 'newLTR')
   {
      method = 'createLetter.action';
   }
   else if(userAction == 'newSMS')
   {
      method = 'createSMS.action';
   }
   else if(userAction == 'newEML')
   {
      method = 'createEmail.action';
   }
   var action = method + businessUnit + '&__sfmrt=' + getCookie("__sfmrt");
   setBusy();
   $df.postURL("overview",action);
}

function doTemplateSaveAction(userAction)
{
	var MARKS = parent.frames['overview'].MARKS;
	var selectedNodes = parent.frames['overview']._tree.getSelectedNodes();

	if(selectedNodes[0].getMark()==MARKS[1])
	{
		$("#callScriptDefForm").submit();
	}
	else if(selectedNodes[0].getMark()==MARKS[2])
	{
		$("#memoDefForm").submit();
	}
	else if(selectedNodes[0].getMark()==MARKS[3] ||
			selectedNodes[0].getMark()==MARKS[4] ||
			selectedNodes[0].getMark()==MARKS[5])
	{
		$("#extTemplateForm").submit();
	}

}

function doDeleteOrCopyAction(userAction)
{
	var MARKS = parent.frames['overview'].MARKS;
  selectedNodes = parent.frames['overview']._tree.getSelectedNodes();

  if(selectedNodes[0].getMark() == MARKS[0]){
	    //alert("toHTML: " + toHTML.un(selectedNodes[0].getTitle()));
		if(userAction == 'delete') alert($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.alert0.txt",[toHTML.un(selectedNodes[0].getTitle())]));
		if(userAction == 'copy') alert($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.alert3.txt",[toHTML.un(selectedNodes[0].getTitle())]));
      		return;
  }
  if(!isDefined(selectedNodes[0].nodeId) || selectedNodes.length != 1
     || selectedNodes[0].nodeId < 0)
  {
     alert($i18n("fcm.templates.js.doDeleteOrCopyAction.alert1.txt"));
     return;
  }
  if(userAction == 'delete')
  {
    if(!confirm($i18n("fcm.templates.js.doDeleteOrCopyAction.confirm0.txt")))
        return;

         var nodeId=selectedNodes[0].parentId;//
         setCookieForTab(nodeId);

  }
  var node = selectedNodes[0];
  // alert(node.nodeId + "  " + node.title);
  var method = '';
  var messageId = '?messageId=';
  var messageVersion = '&messageVersion=';
  var messageName = '&messageName=';
  var businessUnit = '&businessUnit=';
  if(node.getMark()==MARKS[1])
  {
     var scriptMap = parent.frames["overview"]._scriptMap;
     method         += (userAction == 'copy') ? 'copyCallScript' : 'deleteCallScript';
     messageId      += scriptMap[node.nodeId].id;
     messageVersion += scriptMap[node.nodeId].version;
     messageName    += scriptMap[node.nodeId].name;
	 businessUnit   += scriptMap[node.nodeId].businessUnit;
  }
  else if(node.getMark()==MARKS[2])
  {
     var memoMap = parent.frames["overview"]._memoMap;
     method += (userAction == 'copy') ? 'copyMemo' : 'deleteMemo';
     messageId += memoMap[node.nodeId].id;
     messageVersion += memoMap[node.nodeId].version;
     messageName    += memoMap[node.nodeId].name;
	 businessUnit   += memoMap[node.nodeId].businessUnit;
  }
  else if(node.getMark()==MARKS[3])
  {
     var smsMap = parent.frames["overview"]._smsMap;
     method += (userAction == 'copy') ? 'copySMS' : 'deleteSMS';
     messageId += smsMap[node.nodeId].id;
     messageVersion += smsMap[node.nodeId].version;
     messageName    += smsMap[node.nodeId].name;
	 businessUnit   += smsMap[node.nodeId].businessUnit;
  }
  else if(node.getMark()==MARKS[4])
  {
     var emlMap = parent.frames["overview"]._emlMap;
     method += (userAction == 'copy') ? 'copyEmail' : 'deleteEmail';
     messageId += emlMap[node.nodeId].id;
     messageVersion += emlMap[node.nodeId].version;
     messageName    += emlMap[node.nodeId].name;
	 businessUnit   += emlMap[node.nodeId].businessUnit;
  }
  else if(node.getMark()==MARKS[5])
  {
     var ltrMap = parent.frames["overview"]._ltrMap;
     method += (userAction == 'copy') ? 'copyLetter' : 'deleteLetter';
     messageId += ltrMap[node.nodeId].id;
     messageVersion += ltrMap[node.nodeId].version;
     messageName    += ltrMap[node.nodeId].name;
	 businessUnit   += ltrMap[node.nodeId].businessUnit;
  }
  else
  {
     alert($i18n("fcm.templates.js.doDeleteOrCopyAction.alert2.txt"));
  }
  method += '.action';
  var action = method + messageId + messageVersion + messageName + businessUnit + '&__sfmrt=' + getCookie("__sfmrt");
  setBusy();
  $df.postURL("overview",action);
}

// The frame semantics are a little different
// since this is invoked from the overview frame
function doModifyAction(userAction)
{
  var MARKS = parent.frames['overview'].MARKS;
  // alert(_tree.data );
  var selectedNodes = _tree.getSelectedNodes();

  if(selectedNodes.length != 1 || (selectedNodes.length == 1 && selectedNodes[0].getId().indexOf('C')==-1 && selectedNodes[0].getId().indexOf('M')==-1
	 && selectedNodes[0].getId().indexOf('S')==-1 && selectedNodes[0].getId().indexOf('E')==-1 && selectedNodes[0].getId().indexOf('L')==-1 ))
  {
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
    parent.frames[ "detail" ].location.href = 'common/blank.html';
    if (selectedNodes.length > 0) {
        setCookieForTab(selectedNodes[0].getId());
    }
    return;
  }

  var node = selectedNodes[0];
  setCookieForTab(node.getId());
  var method = '';
  var id = '';
  var version = '';
  var name = '';
  var templateName = '';


  if(node.getMark()==MARKS[1])
  {
      method         += 'modifyCallScript';
      id             += '?messageId=' + _scriptMap[node.nodeId].id;
  }
  else if(node.getMark()==MARKS[2])
  {
      method         += 'modifyMemo';
      id             += '?messageId=' + _memoMap[node.nodeId].id;
  }
  else if(node.getMark()==MARKS[3])
  {
      method         += 'modifySMS';
      id             += '?messageId=' + _smsMap[node.nodeId].id;
  }
   else if(node.getMark()==MARKS[4])
  {
      method         += 'modifyEmail';
      id             += '?messageId=' + _emlMap[node.nodeId].id;
  }
   else if(node.getMark()==MARKS[5])
  {
      method         += 'modifyLetter';
      id             += '?messageId=' + _ltrMap[node.nodeId].id;
  }
  else
  {
	  parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
      parent.frames[ "detail" ].location.href = 'common/blank.html';
      return;
  }
  parent.sas.fscf.getCurrentDetailToolbar().setContentFor('any', parent.frames["overview"]._canModify);
  var action = method + '.action' + id;
  setBusyDetail();
  parent.frames[ "detail" ].location.href = action;

}
// Call script functions
function captureCursorPosition(textArea)
{
  if (document.selection)
  {
//	  var range = document.selection.createRange();
//	  var dupRange = range.duplicate();
//	  dupRange.moveToElementText(textArea);
//	  dupRange.setEndPoint('EndToEnd',range);
//	  textArea.selectionStart = dupRange.text.length - range.text.length;
//	  textArea.selectionEnd = textArea.selectionStart + range.text.length;

	  textArea.textRange = document.selection.createRange();
  }
}

function setCursorPosition(textArea, cursorPos)
{
	if(document.selection) // IE
	{
		var range = textArea.createTextRange();
		range.moveEnd('character',-(range.text.length - cursorPos));
		range.moveStart('character',cursorPos);
		range.select();
	}
	else
	{
		textArea.selectionStart = textArea.selectionEnd = cursorPos;
	}
}

function insertAtCursor(textArea, selectElm)
{
	var insertText = selectElm.options[selectElm.selectedIndex].value;

	if(textArea.textRange)
	{
		textArea.textRange.text = insertText;
		textArea.textRange.select();
		return;
	}

    var cursorPos = (textArea.selectionStart !== undefined) ? textArea.selectionStart : textArea.value.length;
    var data = getInsertionData(textArea.value, insertText, cursorPos);
	textArea.value = data.prologue + data.insertText + data.epilogue;
	setCursorPosition(textArea, data.cursorPos);
    limitChars(textArea,1300,true);
    textArea.focus();

}
function getInsertionData(originalText, insertText, cursorPos)
{
	var endsWithNoSpace = /\S$/;
	var startsWithNoSpace = /^\S/;

	var prologue = originalText.substr(0, cursorPos);
	var epilogue = cursorPos > 0 ? originalText.substr(cursorPos) : originalText;
	var spacedText = insertText;
	if(endsWithNoSpace.test(prologue))
		spacedText = ' ' + spacedText;
	if(startsWithNoSpace.test(epilogue))
		spacedText += ' ';

	return {
			prologue: prologue,
			insertText: spacedText,
			epilogue: epilogue,
			cursorPos: cursorPos + spacedText.length
	};
}