/* Loads the Detail Page for Strategy and Queue Definitions */
var _INB_STRATEGY_ = null;
var _INB_QUEUE_ = null;
var _hasQueues = [];
function showStrategyQueueDetail(targetFrame, methodName)
{
   var nodes = parent.frames['overview'].strategyTree.getSelectedNodes();
   if(nodes.length == 1 && nodes[0].getId().indexOf('BU')==-1)
   {

      var node = nodes[0];
      var version = '';
      var dummy = "&d=";
      var action;


      if(parent.frames['detail'] && parent.frames['detail'].getVersion)
      {
         version = parent.frames['detail'].getVersion();
      }
      else
      {
         dummy = '';
      }

  	  parent.sas.fscf.getCurrentDetailToolbar().setContentFor('any', parent.frames["overview"]._canModify);
      action = node.parameters.join('&');
      action = action.replace('#version#',version).replace('#methodName#',methodName).replace("#d#",dummy);
      action += '&__sfmrt=' + getCookie("__sfmrt");
//      frames[targetFrame].location.href = action;
      $df.postURL(targetFrame, action);
//      $.post(action,parent.frames["overview"].location.reload(true));
   }
   else
   {
	  parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
      parent.frames[targetFrame].location.href = "common/blank.html";
   }
}

function doStrategyAction(action)
{
   if(action == 'copy' || action == 'delete' )
   {
      doStrategyActionOnTreeNode('overview',action);
   }
   else if(action == 'save' )
   {
       doStrategySaveAction(action);
   }
   else if(action == 'modify')
   {
      var nodes = parent.frames['overview'].strategyTree.getSelectedNodes();
      if(nodes.length > 0)
         setCookieForTab(nodes[0].getId());
      doStrategyActionOnTreeNode('detail',action);
   }

   else
   {
      setBusyDetail();
      parent.frames['overview'].location.href = action;
   }

}


function createStrategy()
{
	var businessUnitId = "";
	var nodes = parent.frames['overview'].strategyTree.getSelectedNodes();

	if(nodes.length == 0 || nodes[0].getMark() != parent.frames['overview'].MARKS[0])
	{
		alert($i18n("fcm.sq.strategy.js.createStrategy.alert0.txt"));
		return;
	}

	if(parent.frames['overview'] && parent.frames['overview'].getBusinessUnitId)
   	{
   	businessUnitId = parent.frames['overview'].getBusinessUnitId(nodes[0]);
   	}

	var action = 'createStrategy.action?businessUnitId=' + businessUnitId + '&__sfmrt=' + getCookie("__sfmrt");
	setBusyDetail();
//	frames['overview'].location.href = action;
	$df.postURL("overview", action);
//	$.post(action, parent.frames["overview"].location.reload(true));
}

function createQueue()
{
	var strategyId = "";
	var nodes = parent.frames['overview'].strategyTree.getSelectedNodes();
	if(nodes.length == 0 || nodes[0].getMark() != parent.frames['overview'].MARKS[1])
	{
		alert($i18n("fcm.sq.strategy.js.createQueue.alert0.txt"));
		return;
	}
	if(strategyId == -1)
   {
   	alert($i18n("fcm.sq.strategy.js.createQueue.alert1.txt"));
   	return;
   }

   if(parent.frames['overview'] && parent.frames['overview'].getStrategyId)
   {
   	strategyId = parent.frames['overview'].getStrategyId(nodes[0]);
   }

    var action = 'createQueue.action?strategyId=' + strategyId + '&__sfmrt=' + getCookie("__sfmrt");
	setBusyDetail();
//	frames['overview'].location.href = action;
	$df.postURL("overview", action);
	//$.post(action, parent.frames["overview"].location.reload(true));
}

function prioritizeStrategies()
{
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor('prioritize');
	parent.frames['detail'].location.href = 'viewStrategyPriorityList.action';
}

function prioritizeQueues()
{
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor('prioritize');
	parent.frames['detail'].location.href = 'viewQueuePriorityList.action';
}

function showAlertsInQueue(queueId)
{
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor('alertsInQueue');
	parent.frames['detail'].location.href = 'listAlerts.action?queueId=' + queueId;
	parent.frames['detail'].document.body.outerHTML = "<body ><img src='common/images/blank.gif' onload='top.sas.fscf.getCurrentDetailView().setBusyIndicatorDelay(500).setBusy(true);'/></body>";

}

function doStrategySaveAction(action)
{
	var MARKS = parent.frames['overview'].MARKS;
	var selectedNodes = parent.frames['overview'].strategyTree.getSelectedNodes();

	if(selectedNodes[0].getMark()==MARKS[1])
	{
		$("#strategyForm").submit();
	}
	else if(selectedNodes[0].getMark()==MARKS[2])
	{
		$("#queueForm").submit();
	}

}

function doStrategyActionOnTreeNode(targetFrame,action)
{
   var MARKS = parent.frames['overview'].MARKS;
   var tree = parent.frames['overview'].strategyTree;
   var nodes = tree.getSelectedNodes();
   if(action=='delete')
   {
      if(nodes.length > 0)
      {
      	var node = nodes[0];
      	var nodeId = node.getId();

      	if(nodeId == _INB_STRATEGY_ || nodeId == _INB_QUEUE_ || node.getMark() == MARKS[0])
      	{
      		//alert("toHTML: " + toHTML.un(node.getTitle()));
      		alert($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.alert0.fmt.txt",[convertToHTML.un(node.getTitle())]));
      		return;
      	}
      	if(node.getMark() == MARKS[1] && tree.hasChildren(node))
      	{
      		alert($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.alert1.txt"));
      		return;
      	}
      	if(node.getMark() == MARKS[2]) // warn user that it won't be deleted if alerts are found in it
      	{

				if(isDefined(parent.frames['detail']._isEligibleForDeletion) && !parent.frames['detail']._isEligibleForDeletion)
				{
					alert($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.alert2.txt"));
					return;
				}

      	}
      	//confirm delete
      	if(action==='delete'){
      		var agree=confirm($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.confirm0.fmt.txt",[convertToHTML.un(node.getTitle())]));

      		if (agree===false)return false;
      	}
/*
         var idx = nodeId.lastIndexOf("L");
         var num;
         if(idx >= 0)
            num = parseInt(nodeId.substring(idx+1));
         if(num > 1) // select the node right above this one
         {
            num--;
            nodeId = nodeId.substring(0,idx+1) + num;
         }

         else if(tree.getIndex(nodeId.substring(0,idx+1) + (num+1)) == -1)
         {
            // this is the last node to be deleted, then select the parent
            nodeId = nodeId.substring(0,idx);
         }
         setCookieForTab(nodeId);
*/
        var nextNode = tree.getNextSibling(node);
        if ( nextNode == null )
       	 	nextNode = tree.getPreviousSibling(node);
   	 	setCookieForTab(nextNode ? nextNode.nodeId : node.parentId);
      }
   }
	else if(action ==='copy')
	{
      if(nodes.length > 0)
      {
      	var node = nodes[0];
      	var nodeId = node.getId();

      	if(nodeId == _INB_STRATEGY_ || nodeId == _INB_QUEUE_ || node.getMark() == MARKS[0])
      	{
      		alert($i18n("fcm.sq.strategy.js.doStrategyActionOnTreeNode.alert3.fmt.txt",[convertToHTML.un(node.getTitle())]));
      		return;
      	}
		}
	}

   setBusyDetail();
   showStrategyQueueDetail(targetFrame, action);

}

var convertToHTML = {
		on: function(str) {
		var a = [],
		i = 0;
		for (; i < str.length;) a[i] = str.charCodeAt(i++);
		return "&#" + a.join(";&#") + ";"
		},

		un: function(str) {
		return str.replace(/&#(x)?([^&]{1,5});?/g,
		function(a, b, c) {
		return String.fromCharCode(parseInt(c, b ? 16 : 10))
		})
		}
};
