// returns the prefix of indexed fields of a call result 
function indexedFieldPrefix(index) {
	return "callResults[" + index + "]."; 
}

function saveQueueForm(formObj)
{
	if(!validateName(formObj.name.value))
	{
		alert($i18n("fcm.sq.queue.js.saveQueueForm.alert0.txt"));
		formObj.name.select();
		formObj.name.focus();
		return false;
	}

	if(!validateDescription(formObj.description.value))
	{
		alert($i18n("fcm.sq.queue.js.saveQueueForm.alert1.txt"));
		formObj.description.select();
		formObj.description.focus();
		return false;
	}

	// Inactive status check
	if(formObj.status[1].checked)
	{
		var statusValue = formObj.status[1].nextSibling.nodeValue;
		statusValue = statusValue.replace(/\s+$/,"");// remove spaces from end of text node.
		if(!confirm($i18n("fcm.sq.queue.js.saveQueueForm.confirm.txt")))
			return false;
	}

	if(parseInt(formObj.callLowerBound.value) > parseInt(formObj.callUpperBound.value))
	{
		alert($i18n("fcm.sq.queue.js.saveQueueForm.alert2.0.txt")+"\n"+
		      $i18n("fcm.sq.queue.js.saveQueueForm.alert2.1.fmt.txt",[formObj.callLowerBound.options[formObj.callLowerBound.selectedIndex].text,formObj.callUpperBound.options[formObj.callUpperBound.selectedIndex].text]));


		formObj.callLowerBound.focus();
		return false;
	}

	var atLeastOnePicked = $(":checkbox[name$='.id']").filter(":checked").length > 0 ;
	if(!atLeastOnePicked)
	{
		alert($i18n("fcm.sq.queue.js.saveQueueForm.alert3.txt"));
		return false;
	}

	if(!validateCallResultSettings(formObj))
		return false;


	if(isDefined(formObj.autoCloseNewAlert)){
		var days = parseInt(formObj.autoCloseNewAlert.value);
		if(isNaN(formObj.autoCloseNewAlert.value) || days != parseFloat(formObj.autoCloseNewAlert.value))
		{
			alert($i18n("fcm.sq.queue.js.saveQueueForm.alert4.txt"));
			formObj.autoCloseNewAlert.focus();
			formObj.autoCloseNewAlert.select();
			return false;
		}
		if(days < 0 || days > 360)
		{
			alert($i18n("fcm.sq.queue.js.saveQueueForm.alert5.txt"));
			formObj.autoCloseNewAlert.focus();
			formObj.autoCloseNewAlert.select();
			return false;
		}
	}
	if(isDefined(formObj.systemBlockDays)){
		var days = parseInt(formObj.systemBlockDays.value);
		if(isNaN(formObj.systemBlockDays.value) || days != parseFloat(formObj.systemBlockDays.value))
		{
			alert($i18n("fcm.sq.queue.js.saveQueueForm.alert6.txt"));
			formObj.systemBlockDays.focus();
			formObj.systemBlockDays.select();
			return false;
		}
		if(days < 0 || days > 360)
		{
			alert($i18n("fcm.sq.queue.js.saveQueueForm.alert7.txt"));
			formObj.systemBlockDays.focus();
			formObj.systemBlockDays.select();
			return false;
		}
	}
	if(isDefined(formObj.transactionBlockDays)){
		var days = parseInt(formObj.transactionBlockDays.value);
		if(isNaN(formObj.transactionBlockDays.value) || days != parseFloat(formObj.transactionBlockDays.value))
		{
			alert($i18n("fcm.sq.queue.js.saveQueueForm.alert8.txt"));
			formObj.transactionBlockDays.focus();
			formObj.transactionBlockDays.select();
			return false;
		}
		if(days < 0 || days > 360)
		{
			alert($i18n("fcm.sq.queue.js.saveQueueForm.alert9.txt"));
			formObj.transactionBlockDays.focus();
			formObj.transactionBlockDays.select();
			return false;
		}
	}
	//High Risk Combo
	if(isDefined(document.getElementById("comboListbox"))){
		if(document.getElementById("comboListbox").options.length>0){
			if(isDefined(formObj.warningMsg)){
				if(formObj.warningMsg.value==""){
					alert($i18n("fcm.sq.queue.js.saveQueueForm.alert10.txt"));
					formObj.warningMsg.focus();
					formObj.warningMsg.select();
					return false;
				}
			}
		}
	}

	//getElement("saveButton").disabled = true;
	
	addNewPriorities(formObj);

	comboListAssignment();
	postAssignment(emailList,'emailsStr');
	postAssignment(letterList,'lettersStr');
	postAssignment(smsList,'smssStr');

	formObj.callSuperseded.value = (formObj.callSupersededCheckbox.checked?"0":"1");
	formObj.stickyQueue.value = (formObj.stickyQueueCheckbox.checked?"1":"0");
	formObj.method.value="save";

	postResurfaceTimes(formObj);
	postArdCodes(formObj);
	postPosCodes(formObj);
	postFraudTypes(formObj);
	postAllowRerouteTo(formObj);
	postSystemBlocks(formObj);
	postTransactionBlocks(formObj);
	postSicCodes(formObj);
	postMerchantCodes(formObj);

	$(":checkbox[name$='suppressAutoFulfill']").prop("disabled", false);

	// cleanup form data 
	disableUnselectedCallResults(formObj);
	disableTemplateFields();
	
	setBusy();
}

function disableUnselectedCallResults(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);

		if (cr.isAssigned)
		{
			var crChk = formObj.elements[idp+"id"];
			if(isDefined(crChk) && !crChk.checked)
			{
				$("[name^='" + idp + "']").prop("disabled", true);
			}
		}
	}
}

function disableTemplateFields() {
	var idp = indexedFieldPrefix("_INDEX_");
	$("[name^='" + idp + "']").prop("disabled", true);
}

function postAssignment(arrayList,eleName)
{
	var assignedElement = document.createElement("input");
	assignedElement.type = "hidden";
	assignedElement.name = eleName;
	assignedElement.value = "";

	for (var i = 0, len = arrayList.length; i < len; i++)
	{
		var item = arrayList[i];
		if(item.isAssigned)
		{
			assignedElement.value += item.id+":";
		}

	}

	if(assignedElement.value.length > 0)
		document.queueForm.appendChild(assignedElement);

}


function postResurfaceTimes(formObj) {
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);

		if (cr.isAssigned && cr.typeUnknown)
		{
			var crChk = formObj.elements[idp+"id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var timeChk = formObj.elements[idp + "resurfaceAtTime"];
				if (timeChk.checked)
				{
					var timeOption = $(":radio[name='"+ idp + "timeOption']").filter(":checked");
	
					if (timeOption.length > 0)
					{
						// convert to minutes if unit is hour
						if (timeOption[0].value == "1") {
							var elem = formObj.elements[idp + "minutes"];
							var unit = formObj.elements[idp + "minutesUnit"];
							if (unit.value == "hr") {
								var minutes = parseInt(elem.value) * 60;
								elem.value= minutes;
								unit.disabled = true;
							}
						}
					}
	
				} // end time conversion

			}
		}
	}
}

function postArdCodes(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);

		if (cr.isAssigned && (cr.typeUnknown || cr.typePositive))
		{
			var crChk = formObj.elements[idp+"id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var ardChk = formObj.elements[idp+"ardEnabled"];
				if(ardChk && !ardChk.checked)
				{
					var obj=formObj.elements[idp+"ardCodes"];
					for (var i=0; i<obj.length; i++){
						obj[i].checked=false;
					}
			    }
			}
		}
	}
}

function postPosCodes(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned && (cr.typeUnknown || cr.typePositive))
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var posChk = formObj.elements[idp + "posEnabled"];
				var elem = formObj.elements[idp + "posCodes"];
				var posCodes = "";

				if(posChk.checked)
				{
					for (var i =0; i < posCodesByCallResult[""+cr.id].length; i++)
					{
						if(posCodesByCallResult[""+cr.id][i].isAssigned)
						{
							posCodes += posCodesByCallResult[""+cr.id][i].id + ",";
						}
					}
					elem.value = posCodes.slice(0, -1);
					if(elem.value.length > 0) elem.disabled = false;
			    }
			}
		}
	}
}

function postAllowRerouteTo(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned && cr.typeUnknown )
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var rerouteChk=formObj.elements[idp + "allowRerouteToEnabled"];
				var elem = formObj.elements[idp + "allowRerouteTo"];
				var allowRerouteToStr = "";

				if(rerouteChk.checked)
				{
					for (var i =0; i < allowRerouteTo[""+cr.id].length; i++)
					{
						if(allowRerouteTo[""+cr.id][i].isAssigned)
						{
							allowRerouteToStr += allowRerouteTo[""+cr.id][i].id + ",";
						}
					}
					elem.value = allowRerouteToStr.slice(0, -1);
					if(elem.value.length > 0) elem.disabled = false;
			    }
			}
		}
	}
}

function postFraudTypes(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned && cr.typeNegative)
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var elem = formObj.elements[idp + "fraudTypes"];
				var fraudTypesStr = "";

				for (var i =0; i < fraudTypes[""+cr.id].length; i++)
				{
					if(fraudTypes[""+cr.id][i].isAssigned)
					{
						fraudTypesStr += fraudTypes[""+cr.id][i].id + ",";
					}
				}
				elem.value = fraudTypesStr.slice(0, -1);
				if(elem.value.length > 0) elem.disabled = false;
			}
		}
	}
}

function postSystemBlocks(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned)
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var sysBlockChk=formObj.elements[idp + "applySystemBlock"];
				var elem = formObj.elements[idp + "systemBlocksStr"];
				var systemBlocksStr = "";

				if(sysBlockChk.checked)
				{
					for (var i =0; i < sysBlocksByCallResult[""+cr.id].length; i++)
					{
						if(sysBlocksByCallResult[""+cr.id][i].isAssigned)
						{
							systemBlocksStr += sysBlocksByCallResult[""+cr.id][i].id + ",";
						}
					}
					elem.value = systemBlocksStr.slice(0, -1);
					if(elem.value.length > 0) elem.disabled = false;
			    }
			}
		}
	}
}


function postTransactionBlocks(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned)
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				var transBlockChk=formObj.elements[idp + "applyTransactionBlock"];
				var elem = formObj.elements[idp + "transactionBlocksStr"];
				var transactionBlocksStr = "";

				if(transBlockChk.checked )
				{
					for (var i =0; i < txnBlocksByCallResult[""+cr.id].length; i++)
					{
						if(txnBlocksByCallResult[""+cr.id][i].isAssigned)
						{
							transactionBlocksStr += txnBlocksByCallResult[""+cr.id][i].id + ",";
						}
					}
					elem.value = transactionBlocksStr.slice(0, -1);
					if(elem.value.length > 0) elem.disabled = false;
				}
			}
		}
	}
}

function postSicCodes(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned && cr.typeUnknown )
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				replaceValueSeparators(formObj, idp + "sicCodes");
				replaceValueSeparators(formObj, idp + "notSicCodes");			    		    
			}
		}
	}
}

function postMerchantCodes(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		if (cr.isAssigned && cr.typeUnknown )
		{
			var crChk = formObj.elements[idp + "id"];
			if(isDefined(crChk) && crChk.checked)
			{
				replaceValueSeparators(formObj, idp + "merchantCountryCodes");
				replaceValueSeparators(formObj, idp + "notMerchantCountryCodes");			    		    
			}
		}
	}
}

function replaceValueSeparators(formObj, name) {
	var chk=formObj.elements[name.replace("Codes", "Enabled")];
	var elem = formObj.elements[name];

	if(chk.checked)
	{
		elem.value = elem.value.replace(/[;:]/g, ",").replace(/ /g, "");
		elem.disabled = false;
    }
}

function isInteger(chk,ipt)
{

	if(isDefined(chk) && chk.checked)
	{
		return isIntegerValue(ipt.value);
	}
	return true;
}

function isIntegerValue(valueStr)
{
	if(valueStr.length > 0 && valueStr.indexOf('.') < 0 && !isNaN(valueStr))
		return !isNaN(parseInt(valueStr));
	return false;
}

function isFloat(chk,ipt)
{
	if(isDefined(chk) && chk.checked)
	{
		var valueStr = ipt.value;
		if(valueStr.length > 0 && !isNaN(valueStr))
			return !isNaN(parseFloat(valueStr));
		return false;
	}
	return true;
}

function isEmpty(ipt)
{
	if(isDefined(ipt))
	{
		var valueStr = ipt.value.replace(/\s/g, "");
		return (valueStr.length == 0);
	}
	return true;
}

function showCallResultsBlock() {
	if (document.getElementById('callResultBlock').style.display == 'none') {
		showDiv($('#callResultImg')[0], 'callResultBlock');
	}
}

function validateCallResultSettings(formObj)
{

	if(!isDefined(formObj))
	{
		alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert0.txt"));
		return false;
	}

	var ipt, chk;

	for (var i = 0; i < crs.length; i++)
	{
		if (!crs[i].isAssigned) continue;

		var cr = crs[i];
		var label = cr.name;		
		var idp = indexedFieldPrefix(i);

		var crChk =formObj.elements[idp + "id"];

		if(!crChk.checked) continue;

		// validate auto close days
		ipt = formObj.elements[idp + "autoClose"];
		if(!isInteger(crChk,ipt))
		{
			alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert4.txt"));
			showCallResultsBlock();
			ipt.focus();
			ipt.select();
			return false;
		}

		// only allow values between 0 and 360
		var days = parseInt(ipt.value);
		if(days < 0 || days > 360)
		{
			alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert5.txt"));
			showCallResultsBlock();
			ipt.focus();
			ipt.select();
			return false;
		}

		var rerouteChecked = false;
		var timeOptionSelected = false;
		var transOptionSelected = false;

		// validate reroute and time based resurface selection
		if (cr.typeUnknown) {

			//validate reroute selection
			chk = formObj.elements[idp + "allowRerouteToEnabled"];
			rerouteChecked = chk.checked;
			if (rerouteChecked){
				ipt=formObj.elements[idp + "selectedAllowRerouteTo"];
				if(!ipt.options.length>0) {
					alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert22.fmt.txt",[label]));
					showCallResultsBlock();
					ipt.focus();
					return false;
				}
			}

			//validate time selection
			var timeChk = formObj.elements[idp + "resurfaceAtTime"];
			if (timeChk.checked)
			{
				var timeOption;
				if (rerouteChecked){
					timeOption = $(":radio[name='"+ idp + "timeOption']").filter(":checked");
				}
				else {
					timeOption = $(":radio[name='"+ idp + "timeOption'][value!='0']").filter(":checked");
				}

				if (timeOption.length > 0)
				{
					timeOptionSelected = true;

					// same day option selected, validate the minutes
					if (timeOption[0].value == "1") {
						chk = timeOption[0];
						ipt = formObj.elements[idp + "minutes"];
						if(!isInteger(chk,ipt))
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert1.txt"));
							showCallResultsBlock();
							ipt.focus();
							ipt.select();
							return false;
						}

						// values between 1 minute and 10 hours
						var unitValue = formObj.elements[idp + "minutesUnit"].value;
						var timeValue = parseInt(ipt.value);

						if(unitValue == 'min' && timeValue < 1) // data entry limited to two digits
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert2.txt"));
							showCallResultsBlock();
							ipt.focus();
							ipt.select();
							return false;
						}
						else if(unitValue == 'hr' && (timeValue < 1 || timeValue > 10))
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert3.txt"));
							showCallResultsBlock();
							ipt.focus();
							ipt.select();
							return false;
						}
					}
				}

				//checked but no time option selected
				if (!timeOptionSelected) {
					alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert17.fmt.txt",[label]));
					showCallResultsBlock();
					timeChk.focus();
					return false;
				}

			} // end time validation

			// reroute must company with a time based resurface condition
			if (rerouteChecked && !timeOptionSelected)
			{
				alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert24.fmt.txt",[label]));
				showCallResultsBlock();
				timeChk.focus();
				return false;
			}

		} // end type = UNKNOWN

		// validate transaction based resurface selection
		if (cr.typeUnknown || cr.typePositive) {
			var transChk = formObj.elements[idp + "resurfaceWhenTrans"];
			if (transChk.checked) {

				chk = formObj.elements[idp + "scoreIncreaseEnabled"];
				var ipt1 = formObj.elements[idp + "score1Increase"];
				var ipt2 = formObj.elements[idp + "score2Increase"];
				var ipt3 = formObj.elements[idp + "score3Increase"];
				var ipt4 = formObj.elements[idp + "score4Increase"];
				if(chk && chk.checked) {
					transOptionSelected = true;
					if (isEmpty(ipt1) && isEmpty(ipt2) && isEmpty(ipt3) && isEmpty(ipt4))
					{
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert6.0.txt"));
						showCallResultsBlock();
						ipt1.focus();
						ipt1.select();
						return false;
					}
					else
					{

						if (!isEmpty(ipt1) && !isInteger(chk,ipt1))
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert6.1.txt"));
							showCallResultsBlock();
							ipt1.focus();
							ipt1.select();
							return false;
						}

						if (!isEmpty(ipt2) && !isInteger(chk,ipt2))
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert6.1.txt"));
							showCallResultsBlock();
							ipt2.focus();
							ipt2.select();
							return false;
						}

						if (!isEmpty(ipt3) && !isInteger(chk,ipt3))
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert6.1.txt"));
							showCallResultsBlock();
							ipt3.focus();
							ipt3.select();
							return false;
						}

						if (!isEmpty(ipt4) && !isInteger(chk,ipt4))
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert6.1.txt"));
							showCallResultsBlock();
							ipt4.focus();
							ipt4.select();
							return false;
						}
					}
				}

				chk  = formObj.elements[idp + "scoreEnabled"];
				ipt1 = formObj.elements[idp + "score1"];
				ipt2 = formObj.elements[idp + "score2"];
				ipt3 = formObj.elements[idp + "score3"];
				ipt4 = formObj.elements[idp + "score4"];
				if(chk && chk.checked)	{
					transOptionSelected = true;
					if (isEmpty(ipt1) && isEmpty(ipt2) && isEmpty(ipt3) && isEmpty(ipt4))
					{
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert7.0.txt"));
						showCallResultsBlock();
						ipt1.focus();
						ipt1.select();
						return false;
					}
					else
					{
						if ( !isEmpty(ipt1) && !isInteger(chk,ipt1) )
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert7.1.txt"));
							showCallResultsBlock();
							ipt1.focus();
							ipt1.select();
							return false;
						}
						if ( !isEmpty(ipt2) && !isInteger(chk,ipt2) )
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert7.1.txt"));
							showCallResultsBlock();
							ipt2.focus();
							ipt2.select();
							return false;
						}
						if ( !isEmpty(ipt3) && !isInteger(chk,ipt3) )
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert7.1.txt"));
							showCallResultsBlock();
							ipt3.focus();
							ipt3.select();
							return false;
						}

						if ( !isEmpty(ipt4) && !isInteger(chk,ipt4) )
						{
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert7.1.txt"));
							showCallResultsBlock();
							ipt4.focus();
							ipt4.select();
							return false;
						}
					}
				}

				chk = formObj.elements[idp + "amountEnabled"];
				ipt = formObj.elements[idp + "amount"];
				if(chk && chk.checked) transOptionSelected = true;
				if(!isFloat(chk,ipt))
				{
					alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert8.txt"));
					showCallResultsBlock();
					ipt.focus();
					ipt.select();
					return false;
				}

				chk = formObj.elements[idp + "merchantCountryEnabled"];
				if(chk && chk.checked) {
					transOptionSelected = true;
					ipt=formObj.elements[idp + "merchantCountryCodes"];
					if(ipt.value==''){
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert9.fmt.txt",[label]));
						showCallResultsBlock();
						ipt.focus();
						ipt.select();
						return false;
					}
					var notChk=formObj.elements[idp + "notMerchantCountryEnabled"];
					if(notChk && notChk.checked){
						var notIn=formObj.elements[idp + "notMerchantCountryCodes"].value.split(";");
						var both="";
						for (var z=0;z<notIn.length;z++){
							if(notIn!=''){
								if(ipt.value.indexOf(notIn[z])>-1){
									both+=notIn[z] + "\n\t ";
								}
							}
						}
						if(both!=""){
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert10.fmt.txt",[both]));
							showCallResultsBlock();
							ipt.focus();
							ipt.select();
							return false;
						}
					}
				}

				chk = formObj.elements[idp + "notMerchantCountryEnabled"];
				if(chk && chk.checked) {
					transOptionSelected = true;
					ipt=formObj.elements[idp + "notMerchantCountryCodes"];
					if(ipt.value==''){
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert11.fmt.txt",[label]));
						showCallResultsBlock();
						ipt.focus();
						ipt.select();
						return false;
					}
				}

				chk = formObj.elements[idp + "sicEnabled"];
				if(chk && chk.checked) {
					transOptionSelected= true;
					ipt=formObj.elements[idp + "sicCodes"];
					if(ipt.value==''){
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert12.fmt.txt",[label]));
						showCallResultsBlock();
						ipt.focus();
						ipt.select();
						return false;
					}
					var notChk=formObj.elements[idp + "notSicEnabled"];
					if(notChk && notChk.checked){
						var notIn=formObj.elements[idp + "notSicCodes"].value.split(";");
						var both="";
						for (var z=0;z<notIn.length;z++){
							if(notIn!=''){
								if(ipt.value.indexOf(notIn[z])>-1){
									both+=notIn[z] + "\n\t ";
								}
							}
						}
						if(both!=""){
							alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert13.fmt.txt",[both]));
							showCallResultsBlock();
							ipt.focus();
							ipt.select();
							return false;
						}
					}
				}

				chk = formObj.elements[idp + "notSic"];
				if(chk && chk.checked) {
					transOptionSelected = true;
					ipt=formObj.elements[idp + "notSicCodes"];
					if(ipt.value==''){
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert14.fmt.txt",[label]));
						showCallResultsBlock();
						ipt.focus();
						ipt.select();
						return false;
					}
				}

				chk = formObj.elements[idp + "ardEnabled"];
				if(chk && chk.checked) {
					transOptionSelected = true;
					var ardSelected=false;
					var obj=formObj.elements[idp + "ardCodes"];
					for (var j=0; j<obj.length; j++){
						if (obj[j].checked)
							ardSelected=true;
					}
					if(!ardSelected){
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert15.fmt.txt",[label]));
						return false;
					}
				}
				if(chk && !chk.checked){
					var obj=formObj.elements[idp + "ardCodes"];
					for (var j=0; j<obj.length; j++){
						obj[j].checked=false;
					}
				}

				chk = formObj.elements[idp + "posEnabled"];
				if(chk && chk.checked) {
					transOptionSelected = true;
					var obj=formObj.elements[idp + "selectedPosCodes"].options;
					ipt=formObj.elements[idp + "selectedPosCodes"];
					if(!obj.length>0) {
						alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert16.fmt.txt",[label]));
						showCallResultsBlock();
						ipt.focus();
						return false;
					}
				}

				if (!transOptionSelected) {
					alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert18.fmt.txt",[label]));
					showCallResultsBlock();
					transChk.focus();
					return false;
				}

			} // end of transaction validation
		} // end type = UNKNOWN | POSITIVE

//		if (cr.typeUnknown) {
//			if(!timeOptionSelected && !transOptionSelected)
//			{
//				alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert19.fmt.txt",[label]));
//				crChk.focus();
//				return false;
//			}
//		}

		// validate block code selections
		chk = formObj.elements[idp + "applyTransactionBlock"];
		if(chk && chk.checked) {
			var applyTransactionBlockSelected=false;
			var obj=formObj.elements[idp + "selectedTransactionBlocks"].options;
			ipt=formObj.elements[idp + "selectedTransactionBlocks"];
			if(obj.length>0) {
				applyTransactionBlockSelected=true;
			}
			if(!applyTransactionBlockSelected){
				alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert20.fmt.txt",[label]));
				showCallResultsBlock();
				ipt.focus();
				return false;
			}

		}
		chk = formObj.elements[idp + "applySystemBlock"];
		if(chk && chk.checked) {
			var applySystemBlockSelected=false;
			var obj=formObj.elements[idp + "selectedSystemBlocks"].options;
			ipt=formObj.elements[idp + "selectedSystemBlocks"];
			if(obj.length>0) {
				applySystemBlockSelected=true;
			}
			if(!applySystemBlockSelected){
				alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert21.fmt.txt",[label]));
				showCallResultsBlock();
				ipt.focus();
				return false;
			}
		}

		if(cr.typeNegative){
			ipt=formObj.elements[idp + "selectedFraudTypes"];
			if(!ipt.options.length>0) {
				alert($i18n("fcm.sq.queue.js.validateCallResultSettings.alert23.fmt.txt",[label]));
				showCallResultsBlock();
				ipt.focus();
				return false;
			}
		}

	}//end forloop

	return true;
}


function toggleConfiguration(chkbx,linkName, divName)
{
	if(chkbx.checked)
	{
		hideDiv(linkName);
		showDiv(divName);
	}
	else
	{
		showDiv(linkName);
		hideDiv(divName);
	}
}

function disableCallResultOptions(prefix,isDisabled)
{
	elms = document.queueForm.elements;

	for (var i = 0; i < elms.length; i++)
	{
		if(isDefined(elms[i].id) && elms[i].id.indexOf(prefix) == 0)
		{
			elms[i].disabled = isDisabled;
		}

	}

}

function enableElements(crIndex,elemNameList,isDisabled)
{

	for (var i = 0; i < elemNameList.length; i++)
	{
		var idp = indexedFieldPrefix(crIndex);
		
		var elem = document.queueForm.elements[idp + elemNameList[i]];

		if(isDefined(elem))
		{
			// array elements, but not a "select"
			if (elem.length && !isDefined(elem.type))
			{
				for (var j = 0; j < elem.length; j++)
					enableElement(elem[j], isDisabled);
			}
			else
			{
				enableElement(elem, isDisabled)
			}
		}
	}
}

function enableElement(elem, isDisabled)
{
	if(elem.checked) elem.click();
	if(isDefined(isDisabled)){
		elem.disabled = isDisabled;
	}
}

function setStickySetting(chkbx,stickyChkbx)
{
	if(chkbx.checked)
	{
		stickyChkbx.checked = true;
		stickyChkbx.disabled = true;
	}
	else
	{
		stickyChkbx.disabled = false;
	}
}

function activate(chkbox,txtFldName)
{
	txtFld = document.queueForm[txtFldName];

	txtFld.disabled = !chkbox.checked;
	txtFld.disabled == true ? txtFld.blur() : txtFld.focus();

}
function showQueuePriorityList()
{
	doHide(document.queueForm.callLowerBound)
	doHide(document.queueForm.callUpperBound);
	doHide(document.queueForm.sortField);
	doHide(document.queueForm.sortOrder);
//	doHide(document.queueForm.queueTypeCode);

	var aTag = getElement('queueRelativePriority')
	var srcRowIndex = parseInt(aTag.innerHTML);
	var tableRef = getElement('queuePriorityTable');
	var qpList = getElement('queuePriorityList');
	qpList.style.top = getTopPosition(aTag);
	qpList.style.left = getLeftPosition(aTag);

	showDiv('','queuePriorityList');

	for (var i = 0,scrollTop = 0; i < srcRowIndex-2; i++)
	{
		scrollTop += tableRef.rows[i].offsetHeight;
	}
	qpList.scrollTop = scrollTop;
}

function setQueuePriority(rowRef)
{

	srcRowIndex = parseInt(getElement('queueRelativePriority').innerHTML) - 1;
	tgtRowIndex = rowRef.rowIndex - 1;

	tableRef = getElement('queuePriorityTableBody');
	if(srcRowIndex != tgtRowIndex)
	{
		newRow = moveRow(tableRef,srcRowIndex,tgtRowIndex);
		swapItemPriority(srcRowIndex,tgtRowIndex);
		swapItemLocation(srcRowIndex, tgtRowIndex);
		highlightRow(newRow,'rowSelected');

		// reset relative priorities value for all rows
		numRows = tableRef.getElementsByTagName("TR").length;
		for (var i = 0; i < numRows; i++)
		{
			tableRef.rows[i].cells[0].innerHTML = (i+1);
		}
	}

	getElement('queueRelativePriority').innerHTML=(tgtRowIndex+1)+" ";
	hideQueuePriorityList();
}

function hideQueuePriorityList()
{
	doShow(document.queueForm.callLowerBound)
	doShow(document.queueForm.callUpperBound);
	doShow(document.queueForm.sortField);
	doShow(document.queueForm.sortOrder);
	hideDiv('queuePriorityList');
}

var _emailType = 0;
var _letterType = 1;
var _smsType = 2;
var _defaultTemplateIds = ["-101","-101","-101"];

function populateDefaultFields(templateType, defaultItem){


	//CHANGE THE COLOR OF THE OPTION TO INDICATE IT IS DEFAULT
	defaultItem.className = "defaultTemplateItem";

	if(templateType==0){
		var arrayList = emailList;
		var item = arrayList[defaultItem.value];
		if(item.isAssigned)
		document.queueForm.defaultEmail.value=item.id;
		$('#defaultEmailDisplay').text(defaultItem.text);

	}
	else if(templateType==1){
		var arrayList = letterList;
		var item = arrayList[defaultItem.value];
		document.queueForm.defaultLetter.value=item.id;
		$('#defaultLetterDisplay').text(defaultItem.text);

	}
	else if(templateType==2){
		var arrayList = smsList;
		var item = arrayList[defaultItem.value];
		document.queueForm.defaultSms.value=item.id;
		$('#defaultSmsDisplay').text(defaultItem.text);
	}
}

function setAsDefaultItem(evt, listBoxName)
{
	//DETERMINE THE TEMPLATE TYPE
	if (listBoxName.indexOf("Emails")>0) var templateType=_emailType;
	else if (listBoxName.indexOf("Letters")>0) var templateType=_letterType;
	else var templateType=_smsType;

	//DETERMINE WHICH LISTBOX IS MAKING THE CALL
	var caller = document.getElementsByName(listBoxName)[0];
	//IF NO SELECTIONS ARE MADE RETURN
	if(caller.selectedIndex == -1) return;

	for (var i = 0; i < caller.options.length; i++)
	{
		//DETERMINE THE POSITION OF THE OPTION
		var defaultItem = caller.options[i];
		//IF OPTION IS THE SELECTED OPTION
		if(i == caller.selectedIndex)
		{
			//POPULATE _defaultTemplateIds[templateType] WITH THE POSITION OF THE SELECTED OPTION
			_defaultTemplateIds[templateType] = defaultItem.value;

			//POPULATE THE HIDDEN FIELD defaultEmail with the templateId-THIS WILL BE SAVED IN THE queueForm
			//DISPLAY THE DEFAULT TEMPLATE WITH THE TEMPLATE NAME
			populateDefaultFields(templateType, defaultItem);

		}
		//TURN THE PREVIOUS DEFAULT TO REGULAR COLOR
		else if(defaultItem.className == "defaultTemplateItem")
		{
			defaultItem.className = "";

		}
	}
	//DESELECT ALL OPTIONS
	caller.selectedIndex = -1;
}

//CALLED WHEN A USER ASSIGNS NEW TEMPLATES OR REMOVES TEMPLATES
function selectDefaultItem(evt,listBoxName)
{

	//DETERMINE THE TEMPLATE TYPE
	if (listBoxName.indexOf("Emails")>0) var templateType=_emailType;
	else if (listBoxName.indexOf("Letters")>0) var templateType=_letterType;
	else var templateType=_smsType;

	//DETERMINE WHICH LISTBOX IS MAKING THE CALL
	var caller = document.getElementsByName(listBoxName)[0];
	//INITIALIZE EXISTS FLAG TO FALSE
	var exists = false;

	//LOOP THROUGH ALL THE LISTBOX OPTIONS
	for (var i = 0; i < caller.options.length; i++)
	{
		var defaultItem = caller.options[i];
		var len=caller.options.length;
		defaultItem.className=="";

		//IF WE HAD ALREADY SAVED A DEFAULT
		//OR
		//IF THE POSITION OF THE CURRENT OPTION IS THE SAME AS THE PREVIOUS DEFAULT TEMPLATE
		if(defaultItem.value == _defaultTemplateIds[templateType] ){

			//alert("THE PREVIOUS DEFAULT TEMPLATE STILL EXISTS: " + defaultItem.value);

			//CHANGE THE THE DEFAULT FIELDS
			populateDefaultFields(templateType, defaultItem);

			//SET THE EXIST VALUE TO TRUE
			exists = true;
		}
		if(!exists && _defaultTemplateIds[templateType]>=0){//THE PREVIOUS DEFAULT TEMPLATE HAS BEEN REMOVED
			if(_defaultTemplateIds[templateType]<defaultItem.value || i==len-1){
				//alert("THE DEFAULT DOES NOT EXIST ANYMORE.  TAKE THE OPTION THAT WAS IN THE PREVIOUS DEFAULTS POSITION OR IF IT DOESN'T EXIST TAKE THE LAST ONE: " + defaultItem.value);

				_defaultTemplateIds[templateType]=defaultItem.value;

				//SET NEW DEFAULT VALUES
				populateDefaultFields(templateType, defaultItem);

				//STOP LOOPING
				break;
			}
		}
	}
	if(!exists){//NO PREVIOUS DEFAULT OR NO OPTIONS IN LISTBOX

		if (len>0){//THERE ARE OPTIONS IN THE LISTBOX
			//NO PREVIOUS DEFAULT TEMPLATE, SO WE SET DEFAULT TO THE FIRST OPTION ON THE LIST
			if(_defaultTemplateIds[templateType]<0){
				//alert("THERE WAS NO PREVIOUS DEFAULT TEMPLATE SO WE SET IT TO THE FIRST ONE ON THE LIST");
				var defaultItem=caller.options[0];
				_defaultTemplateIds[templateType] = defaultItem.value;
				populateDefaultFields(templateType,defaultItem);
			}


		}
		else{//THERE ARE NO OPTIONS IN THE LISTBOX
			//alert("THERE ARE NO OPTIONS IN THE LISTBOX");
			_defaultTemplateIds[templateType]="-101";
			if(templateType==0){
				document.queueForm.defaultEmail.value="";
				document.getElementById('defaultEmailDisplay').innerHTML ="";
			}
			if(templateType==1){
				document.queueForm.defaultLetter.value="";
				document.getElementById('defaultLetterDisplay').innerHTML ="";
			}
			if(templateType==2){
				document.queueForm.defaultSms.value="";
				document.getElementById('defaultSmsDisplay').innerHTML ="";
			}

		}
	}
}



/****NEW BBW***/

//maximum number of allowed checked boxes
var maxChecks=4;

function limitSelections(obj){

	var checkCount= $(":checkbox[name='" + obj.name + "']").filter(":checked").length;

	//if they checked a 5th box, uncheck the box, then decrement checkcount and pop alert
	if (checkCount>maxChecks){
		alert($i18n("fcm.sq.queue.js.limitSelections.alert0.fmt.txt",[maxChecks]));
		obj.checked=false;
	}
}


function maxSel(form, max){
	var ctr = 0;
	for (var i=0; i<form.options.length; i++)
	{
		if (form.options[i].selected==true)
			ctr++;
			if(ctr>max){
				form.options[i].selected=false;
			}
	}

	if (ctr>max)
	{
		alert($i18n("fcm.sq.queue.js.maxSel.alert0.fmt.txt",[max]));
		return false;
	}

	return true;
}

function showHideBlock(divName){
	if(document.getElementById(divName).style.display=='none') {
		document.getElementById(divName).style.display='inline';
	}
	else {
		document.getElementById(divName).style.display='none';
	}
}


/***********************************************
* Drop Down/ Overlapping Content- � Dynamic Drive (www.dynamicdrive.com)
* This notice must stay intact for legal use.
* Visit http://www.dynamicdrive.com/ for full source code
***********************************************/

function getposOffset(overlay, offsettype){
	var totaloffset=(offsettype=="left")? overlay.offsetLeft : overlay.offsetTop;
	var parentEl=overlay.offsetParent;
	while (parentEl!=null){
		totaloffset=(offsettype=="left")? totaloffset+parentEl.offsetLeft : totaloffset+parentEl.offsetTop;
		parentEl=parentEl.offsetParent;
	}
	totaloffset=(offsettype=="left")? totaloffset-document.body.scrollLeft : totaloffset-document.body.scrollTop;
	return totaloffset;
}

function overlay(curobj, subobjstr, opt_position){


	if(curobj.disabled)return false;

//	highlightSelections();

	if (document.getElementById){
		var subobj=document.getElementById(subobjstr);
		subobj.style.display=(subobj.style.display!="block")? "block" : "none";
		var xpos=getposOffset(curobj, "left")+((typeof opt_position!="undefined" && opt_position.indexOf("right")!=-1)? -(subobj.offsetWidth-curobj.offsetWidth) : 0);
		var ypos=getposOffset(curobj, "top")+((typeof opt_position!="undefined" && opt_position.indexOf("bottom")!=-1)? curobj.offsetHeight : 0);

		// make sure it's not off the right & bottom edges of the window
		var ww = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
		if (xpos + subobj.offsetWidth > ww) {
			xpos -= ((xpos + subobj.offsetWidth) - ww);
			xpos = Math.max(xpos, 0);
		}
		var wh = window.innerHeight	|| document.documentElement.clientHeight || document.body.clientHeight;
		if (ypos + subobj.offsetHeight > wh) {
			ypos -= ((ypos + subobj.offsetHeight) - wh);
			ypos = Math.max(ypos, 0);
		}

		subobj.style.left=xpos+"px";
		subobj.style.top=ypos+"px";
		return false;
	}
	else
	{
		return true;
	}
}


function enableLookup(elemName){

	elem=document.getElementById(elemName);
	var isDisabled=!elem.disabled;
	if(isDefined(elem)){
		if(isDefined(isDisabled)){
			elem.disabled=isDisabled;
		}
	}

}

// fieldName - 'callResults[index].sicCodes'
function extractPropertyName(fieldName){

	var start=fieldName.indexOf('.');
	return fieldName.substring(start+1);
}

function extractPropertyPrefix(fieldName){

	var end=fieldName.indexOf('.');
	return fieldName.substring(0, end+1);
}

function notInBoth(fieldName, valid){

	var n=extractPropertyName(fieldName);
	var idp=extractPropertyPrefix(fieldName);
	
	var allowableLength=3;
	var m;
	if(n.indexOf('Country')>-1){
		m= (n!='merchantCountryCodes') ? "merchantCountryCodes" : "notMerchantCountryCodes";
	}
	else {
		m= (n!='sicCodes') ? "sicCodes" : "notSicCodes";
		allowableLength=4;
	}
	
	var mFieldName = idp + m;	
	var mField = document.queueForm.elements[mFieldName]
	var mLabel =(m.indexOf('not')>-1) ? "NOT IN" : "IN";
	
	var rmv = mField.value;
	var rmvArr=valid.split(";");
	var codesInBoth='';

	for (var z=0;z<rmvArr.length;z++){
		if(rmv!='' && trim(rmvArr[z]).length==allowableLength && rmv.indexOf(trim(rmvArr[z].toString()))>-1){
			rmv=rmv.replace(trim(rmvArr[z].toString()),' ');
			if(codesInBoth=='') codesInBoth=trim(rmvArr[z]);
			else codesInBoth+=" ; " + trim(rmvArr[z]) ;
		}
	}

	if(codesInBoth!=''  && mField.disabled==false)
		alert($i18n("fcm.sq.queue.js.notInBoth.alert0.0.txt")+"\n"+
		$i18n("fcm.sq.queue.js.notInBoth.alert0.1.fmt.txt",[mLabel])+"\n\n"+
		$i18n("fcm.sq.queue.js.notInBoth.alert0.2.fmt.txt",[codesInBoth]));


	rmv=rmv.replace(/[ ;,]/g,'');

	var newRmv='';
	if(rmv.length>=allowableLength){
		var z=0;
		for (var i=allowableLength;i<=rmv.length;i=i+allowableLength){
			if(newRmv=='')newRmv=rmv.substring(z,i);
			else newRmv+=" ; "+rmv.substring(z,i);
			z=z+allowableLength;
		}
	}

	// update the other field of the pair
	processCodeDescription(newRmv, '', mFieldName, false);
	window.status='';

}

function processCodeDescription(valid, invalid, fieldName, notInBothChk) {

	if(!invalid==''){
		alert($i18n("fcm.sq.queue.js.processCodeDescription.alert0.fmt.txt", [invalid]));
		return false;
	}

	//country and sic codes cannot exist in both in and not in conditions
	if(notInBothChk){
		notInBoth(fieldName,valid);
 	}

	var validArr=valid.split(";");
	if (validArr.length>10){
		valid='';
		for (var i=0;i<10;i++){
			if(valid=='')valid+=validArr[i];
			else valid+=" ; "+validArr[i];
		}
		alert($i18n("fcm.sq.queue.js.processCodeDescription.alert1.txt"));
	}
	document.queueForm.elements[fieldName].value=valid;
	document.queueForm.elements[fieldName].style.color="green";

	window.status = '';

}

// fieldName e.g. callResults[_INDEX_].notSicCodes
function prepareCodesLookupPopup(fieldName)
{
	var idp = extractPropertyPrefix(fieldName);
	
	$("#divCodesLookup").data("fieldName", fieldName);
	$("#sortByName").prop("checked", true);

	var typeSIC = (fieldName.toLowerCase().indexOf("sic") !=-1);

	var title = typeSIC? $i18n("fcm.sq.queue.merchantSICCodes.txt") : $i18n("fcm.sq.queue.merchantCountryCodes.txt");
	$("#divCodesLookupTitle").text(title);

	var selectionFieldName = idp + (typeSIC ? 'sicCodes' : 'merchantCountryCodes');
	var notSelectionFieldName = idp + (typeSIC ? 'notSicCodes' : 'notMerchantCountryCodes');

	var selections=(""+$("input[name='" + selectionFieldName + "']").val()).split(" ; ");
	var notSelections=(""+$("input[name='" + notSelectionFieldName + "']").val()).split(" ; ");

	var codes = typeSIC? _sicCodes : _countryCodes;
	$("#selCodes").empty();
	for (var i in codes)
	{
		var option = document.createElement("OPTION");
		var code = codes[i].code;
		var title = ""+codes[i].name;
		var label = code + "-" + (title.length <= 50 ? title : title.substr(0,50)+"...");
		option.value=code;
		option.title=title;
		option.text=label;

		if (selections.indexOf(code) != -1)
			option.style.color="green";
		else if (notSelections.indexOf(code) != -1)
			option.style.color="red";

		$("#selCodes").append(option);
	}
}


function sortLookupCodesByName()
{
	var fieldName = $("#divCodesLookup").data("fieldName");
	var typeSIC = (fieldName.toLowerCase().indexOf("sic") !=-1);
	var sortedList = typeSIC ? _sicCodes : _countryCodes;

	var options=[];
	$("#selCodes").children().each(function(){ options[""+this.value] = this;});
	$("#selCodes").empty();
	for (var i=0; i < sortedList.length ; i++)
	{
		$("#selCodes").append(options[sortedList[i].code]);
	}
}

function sortLookupCodesByCode()
{
	var fieldName = $("#divCodesLookup").data("fieldName");

	var typeSIC = (fieldName.toLowerCase().indexOf("sic") !=-1);
	var sortedList = typeSIC ? _sicCodesSorted : _countryCodesSorted;

	var options=[];
	$("#selCodes").children().each(function(){ options[""+this.value] = this;});
	$("#selCodes").empty();
	for (var i=0; i < sortedList.length ; i++)
	{
		$("#selCodes").append(options[sortedList[i]]);
	}
}

function populateCodesSelectionText()
{
	var fieldName = $("#divCodesLookup").data("fieldName");
	var $field = $("input[name='" + fieldName + "']");

	var selValues='';
	var cntr=0;
	var existingValues=""+$field.val();
	var existingValuesArray = existingValues.split(" ; ");
	if(existingValues!='') cntr=existingValuesArray.length;

	var obj=document.getElementById("selCodes");

	for (var i=0;i<obj.options.length;i++){
		if(obj.options[i].selected==true){
			cntr++;
			if(cntr<11){
				if(selValues!='') selValues=selValues+" ; "+obj.options[i].value;
				else {
					if(existingValues!='') existingValues=existingValues+" ; ";
					selValues=obj.options[i].value;
				}
			}
			else{
				alert($i18n("fcm.sq.queue.js.populateText.alert0.txt"));
				return false;
			}
			obj.options[i].selected=false;
		}
	}

	$field.val(existingValues+selValues).focus();
}

function validateCodesSelection(obj, notInBothChk)
{
	var typeSIC = (obj.name.toLowerCase().indexOf("sic") !=-1);

	var codes = typeSIC ? _sicCodes : _countryCodes;

	var selections = obj.value;
 	selections=RegExp.escape(selections);

 	selections = selections.replace(/['"]/g,"");
	selections = selections.replace(/[ ,]/g, ";");
	var manyCodes=selections.split(";");
	var valid="";
	var invalid="";
	var flag=false;
	var max=manyCodes.length;

	for (var i=0; i<max;i++){
		for (var j=0;j< codes.length;j++){
			if(trim(manyCodes[i])== codes[j].code){
				flag=true;
				break;
			}
		}
		var re= RegExp(trim(manyCodes[i]));
		if(flag){
			if(!valid.match(re)){
				if(valid=="")valid=trim(manyCodes[i]);
				else valid+=" ; " + trim(manyCodes[i]);
			}
		}
		else{
			if(!invalid.match(re)){
				if(invalid=="")invalid=trim(manyCodes[i]);
				else invalid+= " ; " + trim(manyCodes[i]);
			}
		}
		flag=false;
	}

	if(!processCodeDescription(valid, invalid, obj.name, notInBothChk)){
		return;
	}
}


function trim(txt)
{
	if (txt)
		return txt.replace(/^\s+/g, '').replace(/\s+$/g, '');
	else
		return "";
}

RegExp.escape = (function() {
	var specials = ['^','!','@','#','%','&','-','_','=',':','>','<','`','~','$','/', '.', '*', '+', '?', '|','(', ')', '[', ']', '{', '}', '\\' ];

	sRE = new RegExp('(\\' + specials.join('|\\') + ')', 'g');

	return function(text) {
		return text.replace(sRE, '');
	}
})();

function comboListAssignment(){

	var $arrayList=$('#comboListbox option');
	var assignedElement = document.createElement("input");

	assignedElement.type = "hidden";
	assignedElement.name = "warningComboStr";
	assignedElement.id = "warningComboStr";
	assignedElement.value = "";

	$arrayList.each(function(i){
		assignedElement.value += $(this).val()+":";
	});

	if(assignedElement.value.length>0){
		document.queueForm.appendChild(assignedElement);
	}


}
function addComboToListbox(blockCodeSelector,groupCodeSelector,comboListbox){

	var blockCodeValue=$('#blockCodeSelector option:selected').val();
	var groupCodeValue=$('#groupCodeSelector option:selected').val();

	var blockCodeText=$('#blockCodeSelector option:selected').html();
	var groupCodeText=$('#groupCodeSelector option:selected').html();

	if(blockCodeValue=='all' || groupCodeValue =='all'){
			if(blockCodeValue =='all' && groupCodeValue !='all'){

				$('#blockCodeSelector option').each(function(i){
					if(i!=0){
						var comboValue=$(this).val() + "~" +groupCodeValue;
						var comboText=$(this).html() + " & " +groupCodeText;
						addIfDoesntExist(comboListbox,comboValue,comboText);
					}
				});
			}
			else if(blockCodeValue !='all' && groupCodeValue =='all'){
				$('#groupCodeSelector option').each(function(i){
					if(i!=0){
						var comboValue=blockCodeValue + "~" +$(this).val();
						var comboText=blockCodeText + " & " +$(this).html();
						addIfDoesntExist(comboListbox,comboValue,comboText);
					}
				});
			}
			else{
				var $comboListbox = $('#'+comboListbox);
				$comboListbox.find('option').remove();
				var options = [];
				var $blockOptions = $('#blockCodeSelector option:gt(0)');
				var $groupOptions = $('#groupCodeSelector option:gt(0)');
				$blockOptions.each(function(i,blockOption){
					$groupOptions.each(function(j,groupOption){
							var comboValue=$(blockOption).val() + "~" +$(groupOption).val() ;
							var comboText=$(blockOption).html() + " & " +$(groupOption).html();
							options.push('<option value="'+comboValue+'">'+comboText+'</option>');
					});
				});
				$comboListbox.append(options.join(''));
			}
	}
	else{
		var comboValue=blockCodeValue+ "~" +groupCodeValue;
		var comboText=blockCodeText+" & " +groupCodeText;
		addIfDoesntExist(comboListbox,comboValue,comboText);
	}

	if($('#comboListbox option').length>0) // RAPTOR-2399
		document.getElementById("removeCombosAnchor").disabled=false;
}
function addIfDoesntExist(comboListbox,comboValue,comboText){
	var $comboListbox  = $('#'+comboListbox);
	var $option = $comboListbox.find('option[value="'+comboValue+'"]');
	if($option.length == 0){ // RAPTOR-2399
		$comboListbox.append('<option value="'+comboValue+'">'+comboText+'</option>');
    }
}


function removeOptions(selectbox)
{
	var $selectbox=$('#'+selectbox);
	$($selectbox).find('option:selected').remove();
	if($selectbox.find('option').length==0) // RAPTOR-2399
		$('#removeCombosAnchor').prop("disabled",true);
}


function populateCallResultsSelection()
{
	var ctrl = $("#availableCallResults")[0];
	for (var i = 0; i < crs.length; i++)
		if (!crs[i].isAssigned)
			ctrl.options.add( new Option(crs[i].name, i) );

	if (ctrl.options.length > 1)
		$("#addCallResultSection").css("display", "");

}

function populateSelectedCallResults()
{
	for (var i=0; i<crs.length; i++)
	{
		var cr = crs[i];
		if (cr.isAssigned == true)
		{
			$("#addCallResultSection").before($("#qcrTemplate" + cr.type).html().replace(/_CRID_/g, cr.id).replace(/_INDEX_/g, i));
			$(":checkbox[name='callResults["+i+"].id']")[0].click();
		}
	}
}

function createQCRSection()
{
	var ctrl = $("#availableCallResults")[0];
	if ( ctrl.selectedIndex > 0 )
	{
		var index= ctrl.value;
		var cr = crs[ctrl.value];
		var setting = crSettings[ctrl.value];

		$("#addCallResultSection").before($("#qcrTemplate" + cr.type).html().replace(/_CRID_/g, cr.id).replace(/_INDEX_/g, index));
		$(":checkbox[name='callResults[" + index + "].id']")[0].click();
		cr.isAssigned = true;
		ctrl.remove(ctrl.selectedIndex);
	}
	if (ctrl.options.length <= 1)
		$("#addCallResultSection").css("display", "none");

}

function initializeQCRSection(index)
{
	var cr = crs[index];
	var setting = crSettings[index];
	
	var ids = "" + cr.id;
	var idp = indexedFieldPrefix(index);

	var common = $("#callResult" + cr.id);
	var ext = $("#callResult" + cr.id + "Ext");

	// common
	$(common).find("#callResultName" + cr.id).text(cr.name);
	if (setting.status == 'INACTIVE')
		$(common).find("#callResultName" + cr.id).css("color", "orange").attr("title", setting.status);

	$(common).find("input[name='" + idp + "callResult']")[0].value = cr.name;

	if (setting.autoClose != null)
		$(common).find("input[name='" + idp + "autoClose']")[0].value = setting.autoClose;

	if (cr.typeUnknown)
		$(common).find(":checkbox[name='" + idp + "suppressAutoFulfill']")[0].checked = setting.suppressAutoFulfill;
	else
		$(common).find(":checkbox[name='" + idp + "suppressAutoFulfill']")[0].checked = true;

	var sortOrder = $("#callResultBlock > td > table").length / 2 - 1;
	$(common).find("input[name='" + idp + "sortOrder']").val(sortOrder).change(function () {
		crRow = $("#callResult" + ids);
		nextPos = $(this).val();
		if (!isIntegerValue(nextPos)) {
			$(this).val(($(crRow).index() + 1) / 2);
			return;
		}
		nextPos = nextPos * 2;
		moveCallResultRow(nextPos, crRow);
	});

	// block codes
	loadListboxByAssignment(txnBlocksByCallResult[ids], "availableTransactionBlocksContainer" + cr.id, false);
	loadListboxByAssignment(txnBlocksByCallResult[ids], "selectedTransactionBlocksContainer" + cr.id, true);

	loadListboxByAssignment(sysBlocksByCallResult[ids], "availableSystemBlocksContainer" + cr.id, false);
	loadListboxByAssignment(sysBlocksByCallResult[ids], "selectedSystemBlocksContainer" + cr.id, true);

	if (setting.applyTransactionBlock)
		$(ext).find(":checkbox[name='" + idp + "applyTransactionBlock']")[0].click();
	if (setting.applySystemBlock)
		$(ext).find(":checkbox[name='" + idp + "applySystemBlock']")[0].click();
	$(ext).find(":checkbox[name='" + idp + "removeTransactionBlock']")[0].checked = setting.removeTransactionBlock;
	$(ext).find(":checkbox[name='" + idp + "removeSystemBlock']")[0].checked = setting.removeSystemBlock;

	if (cr.typeUnknown)
	{
		// reroute
		loadListboxByAssignment(allowRerouteTo[ids], "availableAllowRerouteToContainer" + cr.id, false);
		loadListboxByAssignment(allowRerouteTo[ids], "selectedAllowRerouteToContainer" + cr.id, true);

		if (setting.allowRerouteToEnabled)
			$(ext).find(":checkbox[name='" + idp + "allowRerouteToEnabled']")[0].click();

		$(ext).find(":checkbox[name='" + idp + "allowRerouteToEnabled']").click(function() {
			if ( $(this).prop("checked") ) // RAPTOR-2399
			{
				var chkAtTime = $(":checkbox[name='" + idp + "resurfaceAtTime']")[0];
				if (!chkAtTime.checked)
				{
					chkAtTime.click();
					$(":radio[name='" + idp + "timeOption'][value='0']")[0].click();
				}
			}
		});

		// time based criteria

		if (setting.immediatelyEnabled || setting.minutesEnabled || setting.nextDayEnabled || setting.timestampEnabled )
			$(ext).find(":checkbox[name='" + idp + "resurfaceAtTime']")[0].click();

		if (setting.immediatelyEnabled )
			$(ext).find(":radio[name='" + idp + "timeOption'][value='0']")[0].click();

		if (setting.minutesEnabled )
		{
			$(ext).find(":radio[name='" + idp + "timeOption'][value='1']")[0].click();
			if(setting.minutes > 59){
				$(ext).find("input[name='" + idp + "minutes']")[0].value = setting.minutes/60;
				$(ext).find("select[name='" + idp + "minutesUnit']")[0].selectedIndex = 1; // hours
			}
			else{
				$(ext).find("input[name='" + idp + "minutes']")[0].value = setting.minutes;
				$(ext).find("select[name='" + idp + "minutesUnit']")[0].selectedIndex = 0; // hours
			}
		}
		if (setting.nextDayEnabled )
			$(ext).find(":radio[name='" + idp + "timeOption'][value='2']")[0].click();
		if (setting.timestampEnabled )
			$(ext).find(":radio[name='" + idp + "timeOption'][value='3']")[0].click();
	}

	if (cr.typeUnknown || cr.typePositive )
	{
		// transaction based criteria

		loadListboxByAssignment(posCodesByCallResult[ids], "availablePosCodesContainer" + cr.id, false);
		loadListboxByAssignment(posCodesByCallResult[ids], "selectedPosCodesContainer" + cr.id, true);

		if (setting.anyScoreIncreaseEnabled || setting.anyScoreEnabled || setting.amountEnabled || setting.ardEnabled ||
				setting.merchantCountryEnabled || setting.notMerchantCountryEnabled || setting.sicEnabled || setting.notSicEnabled || setting.posEnabled )
			$(ext).find(":checkbox[name='" + idp + "resurfaceWhenTrans']")[0].click();

		if (setting.merchantCountryEnabled || setting.notMerchantCountryEnabled || setting.sicEnabled || setting.notSicEnabled || setting.posEnabled )
		{
			if ($(ext).find("#ccBBWSection" + ids).css("display") == "none")
				$(ext).find("#ccBBWBar" + ids)[0].click();
		}
		else {
			if ($(ext).find("#ccBBWSection" + ids).css("display") != "none")
				$(ext).find("#ccBBWBar" + ids)[0].click();
		}

		if (setting.anyScoreIncreaseEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "scoreIncreaseEnabled']")[0].click();
			if (setting.score1Increase != null)
				$(ext).find(":text[name='" + idp + "score1Increase']")[0].value = setting.score1Increase;
			if (setting.score2Increase != null)
				$(ext).find(":text[name='" + idp + "score2Increase']")[0].value = setting.score2Increase;
			if (setting.score3Increase != null)
				$(ext).find(":text[name='" + idp + "score3Increase']")[0].value = setting.score3Increase;
			if (setting.score4Increase != null)
				$(ext).find(":text[name='" + idp + "score4Increase']")[0].value = setting.score4Increase;
		}
		if (setting.anyScoreEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "scoreEnabled']")[0].click();
			if (setting.score1 != null)
				$(ext).find(":text[name='" + idp + "score1']")[0].value = setting.score1;
			if (setting.score2 != null)
				$(ext).find(":text[name='" + idp + "score2']")[0].value = setting.score2;
			if (setting.score3 != null)
				$(ext).find(":text[name='" + idp + "score3']")[0].value = setting.score3;
			if (setting.score4 != null)
				$(ext).find(":text[name='" + idp + "score4']")[0].value = setting.score4;
		}

		if (setting.amountEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "amountEnabled']")[0].click();
			if (setting.amount != null)
				$(ext).find(":text[name='" + idp + "amount']")[0].value = setting.amount;
		}

		if (setting.ardEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "ardEnabled']")[0].click();
			for (var i=0; i < setting.ardCodes.length; i++)
			{
				$(ext).find(":checkbox[name='" + idp + "ardCodes'][value='" + setting.ardCodes[i]+ "']").click();
			}
		}

		if (setting.merchantCountryEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "merchantCountryEnabled']")[0].click();
			$(ext).find(":text[name='" + idp + "merchantCountryCodes']")[0].value = setting.merchantCountryCodes.join(" ; ");
		}
		if (setting.notMerchantCountryEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "notMerchantCountryEnabled']")[0].click();
			$(ext).find(":text[name='" + idp + "notMerchantCountryCodes']")[0].value = setting.notMerchantCountryCodes.join(" ; ");
		}
		if (setting.sicEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "sicEnabled']")[0].click();
			$(ext).find(":text[name='" + idp + "sicCodes']")[0].value = setting.sicCodes.join(" ; ");
		}
		if (setting.notSicEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "notSicEnabled']")[0].click();
			$(ext).find(":text[name='" + idp + "notSicCodes']")[0].value = setting.notSicCodes.join(" ; ");
		}
		if (setting.posEnabled)
		{
			$(ext).find(":checkbox[name='" + idp + "posEnabled']")[0].click();
		}
	}

	if (cr.typeNegative)
	{
		// fraud type
		loadListboxByAssignment(fraudTypes[ids], "availableFraudTypesContainer" + cr.id, false);
		loadListboxByAssignment(fraudTypes[ids], "selectedFraudTypesContainer" + cr.id, true);
	}
}


function resetQCRSection(index)
{
	var cr = crs[index];
	var ids = "" + cr.id;
	var idp = indexedFieldPrefix(index);

	var ext = $("#callResult" + cr.id + "Ext");

	for (var i = 0; i < txnBlocksByCallResult[ids].length; i++ ){
		txnBlocksByCallResult[ids][i].isAssigned = txnBlocksByCallResult[ids][i].isInitAssigned;
	}
	for (var i = 0; i < sysBlocksByCallResult[ids].length; i++ ){
		sysBlocksByCallResult[ids][i].isAssigned = sysBlocksByCallResult[ids][i].isInitAssigned;
	}

	if (cr.typeUnknown)
	{
		$(ext).find(":checkbox[name='" + idp + "allowRerouteToEnabled']").unbind();
		for (var i = 0; i < allowRerouteTo[ids].length; i++ ){
			allowRerouteTo[ids][i].isAssigned = allowRerouteTo[ids][i].isInitAssigned;
		}

		$(ext).find(":text[name='" + idp + "minutes']").prop("disabled", true);
		$(ext).find("select[name='" + idp + "minutesUnit']").prop("disabled", true);
		$(ext).find(":radio[name='" + idp + "timeOption']").prop("checked", false);
	}

	if (cr.typeUnknown || cr.typePositive)
	{
		for (var i = 0; i < posCodesByCallResult[ids].length; i++ ){
			posCodesByCallResult[ids][i].isAssigned = posCodesByCallResult[ids][i].isInitAssigned;
		}

		if ($(ext).find("#ccBBWSection" + ids).css("display") != "none")
			$(ext).find("#ccBBWBar" + ids)[0].click();

	}

	if (cr.typeNegative)
	{
		for (var i = 0; i < fraudTypes[ids].length; i++ ){
			fraudTypes[ids][i].isAssigned = fraudTypes[ids][i].isInitAssigned;
		}
	}

	$(":checkbox[name^='" + idp + "']").prop("checked", false);
	$(":text[name^='" + idp + "']").prop("value", "");
}

function reinitQCRSection(qcrCtrl)
{
	for (var i=0; i<crs.length; i++)
	{
		if (crs[i].id == qcrCtrl.value)
		{
			if (qcrCtrl.checked)
				initializeQCRSection(i);
			else
				resetQCRSection(i);
			return;
		}
	}
}

function moveCallResultRow(nextPos, crRow)
{
	crExtRow = $(crRow).next();
	children = $(crRow).parent().children();

	currPos = $(crRow).index();
	total = $(children).length;
	if (nextPos <= 0) nextPos = 2;
	else if (nextPos >= total-1) nextPos = total - 2;
	delta = nextPos - currPos;

	if (delta == 0 ) return;

	if (delta > 0) {
		$(children).filter(":eq(" + nextPos +")").after($(crRow));
	}else{
		$(children).filter(":eq(" + (nextPos - 1) +")").before($(crRow));
	}
	$(crRow).after($(crExtRow));
	updateSortOrders();
}

function updateSortOrders()
{
	$("#callResultBlock :text[name$='sortOrder']").each(function (index) {$(this).val(index+1)});
}


