var _highlightedRow = undefined;
var _hasAccounts = [];
var _hasActivitys =[];
// var _DEFAULT_GRID_TEMPLATE_ = null;
var maxGridFieldsValue;
var value;
$.ajax({
	async:false,
	type: "GET",
	url: getUrl(),
	dataType: "json"
}).done(function(response){
	value = response;
	maxGridFieldsValue = value.maxGridFields;
}).fail(function(){
	console.log("Error getting 'webapp_max_grid_fields' value.");
});

function getUrl()
{
	var url= new URL(this.location.href);
	var parts = url.pathname.split("/");
	parts.pop();
	parts.push("/getMaxGridFields.action");
	url.pathname = parts.join("/");
	return url;
}

function highlightRowById(row,classNameValue)
{
    if(_highlightedRow)
    {
        if (_highlightedRow != row) {
            $(_highlightedRow).removeClass(classNameValue);
        }
    }

     _highlightedRow = row;
    $(_highlightedRow).addClass(classNameValue);

}

/* *************************************************** */
/*   Loads the Detail Page from Tree for Preferences   */
/* *************************************************** */

function doPreferenceAction(action)
{
    if(action == 'save' || action == 'copy' || action == 'delete' )  {
   		doPreferenceActionOnTreeNode('overview',action);

    } else if(action == 'modify') {
     	var selectedNodes = parent.frames['overview'].preferenceTree.getSelectedNodes();

        if(selectedNodes.length > 0)
        {
            setCookieForTab(selectedNodes[0].nodeId);

            if (selectedNodes[0].nodeId == "-1" || selectedNodes[0].nodeId == "-2" || selectedNodes[0].nodeId == "-4" || selectedNodes[0].nodeId == "-5" || selectedNodes[0].nodeId == "-6" )
            {
            	parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
                parent.frames[ "detail" ].location.href = "common/blank.html";
            }
            else
            {
                if(selectedNodes.length == 1) {
                    var action = selectedNodes[0].parameters.join('&');
                    setBusyDetail();
                    var toolbarType = 'any';
                    if ((selectedNodes[0].mark == parent.frames['overview'].MARKS[1] || selectedNodes[0].mark == parent.frames['overview'].MARKS[8]) &&
                    	selectedNodes[0].nodeId.indexOf('SG') != 0) {
                    	toolbarType = 'grid';
                    } else if (selectedNodes[0].mark == parent.frames['overview'].MARKS[6]){
                    	toolbarType = 'alert';
                    }

                	parent.sas.fscf.getCurrentDetailToolbar().setContentFor(toolbarType, parent.frames["overview"]._canModify);
                    parent.frames['detail'].location.href = action;
                }
                else
                {
                	parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
                    parent.frames[ "detail" ].location.href = "common/blank.html";
                }
            }
        } else {
        	setCookieForTab("-1");
        	parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
        	parent.frames[ "detail" ].location.href = "common/blank.html";
        }
    } else if (action == 'refreshCache') {
		if (confirm($i18n("fcm.preferences.js.refreshGridCache.txt")))
		{
			parent.sas.fscf.getCurrentOverviewToolbar().getContent()[1].setEnabled(false);
			doRefreshCache();
		}
    } else {
         setBusy();
         action += '&__sfmrt=' + getCookie("__sfmrt");
   	     $df.postURL("overview",action);
    }
}

function doRefreshCache()
{
	// submit an ajax form
	var form = new DynaForm('refreshGridCache');
	form.setAction("refreshGridCache.action")
		.setEnableAjax(true)
		.setParam('__sfmrt',getCookie("__sfmrt"))
		.setParam('method','refreshGridCache')
		.setCallback(function(data){alert(data.status)})
		.doSubmit();
}


function doPreferenceActionOnTreeNode(targetFrame,action)
{
    var tree = parent.frames['overview'].preferenceTree;
    var nodes = tree.getSelectedNodes();

    if(action=='save')
    {
        var node = nodes[0];
        var MARKS = parent.frames['overview'].MARKS;
        if(node.getMark() == MARKS[0]){
        	doSubmitTransactionDataMaskForm();
        }
        else if(node.getMark() == MARKS[1] || node.getMark() == MARKS[8]){
        	doSubmitGridTemplateForm();
	    }
	    else if(node.getMark() == MARKS[2]){
	    	doSubmitAccountTypeForm();
	    }
	    else if(node.getMark() == MARKS[3]){
	    	doSubmitActivityTypeForm();
	    }
	    else if(node.getMark() == MARKS[4]){
	    	doSubmitCallResultsForm();
	    }
	    else if(node.getMark() == MARKS[5]){
	    	doSubmitCaseMgtEventsForm();
	    }
	    else if(node.getMark() == MARKS[7]){
	    	doSubmitSystemPropertyForm();
	    }
    }
    else if(action=='delete')
    {
        if(nodes.length > 0)
        {
            var node = nodes[0];
      	    var nodeId = node.getId();
            var num;

            if (node.getMark() == parent.frames['overview'].MARKS[8])
            {
      		    alert($i18n("fcm.preferences.js.deleteGridTemplate.notDeleted.txt"));
      		    return;
            }

            if(node.getMark() == parent.frames['overview'].MARKS[1]) // warn user that grid template won't be deleted if assigned strategy are found for it
            {
                if(isDefined(parent.frames['detail'].hasAssignedStrategy) && parent.frames['detail'].hasAssignedStrategy)
                {
                    alert($i18n("fcm.preferences.js.deleteGridTemplate.notDeleted2.txt"));
                    return;
                }
                var idx = nodeId.indexOf("G");
                var idx1 = nodeId.indexOf("A");

                if(idx == 0 && idx1 < 0 )
                {
                    num = parseInt(nodeId.substring(1));
    	            if(num > 1) // select the node right above this one
    	               nodeId = "G" + (num-1);
                    else	// this is the first node or we have only one  node to be deleted, then select the parent
                       nodeId = -1;
                } else if (idx == 0 && idx1 > 0 ) {
                    alert($i18n("fcm.preferences.overview.delete.confirm0.txt"));
                    return;
                } else {
                    alert($i18n("fcm.preferences.overview.delete.confirm0.txt"));
                    return;
                }
                //confirm delete
                var agree=confirm($i18n("fcm.preferences.overview.delete.confirm.txt"));
                if (agree==false)return false;

                setCookieForTab(nodeId);

                action = node.parameters.join('&');
                action = action.replace('viewGridTemplate','deleteGridTemplate');
                action += '&__sfmrt=' + getCookie("__sfmrt");
            }
            setBusy();
            $df.postURL(targetFrame, action);
        }
   } else if(action=='copy')
   {
      if(nodes.length > 0)
      {
          var node = nodes[0];
          var nodeId = node.getId();

          if (nodeId.substr(0,2) == 'G0'){
    		    alert($i18n("fcm.preferences.js.copyMaskingType.notCopied.txt"));
    		    return;
    	  } else if (nodeId.substr(0,2) == 'SG'){
    		  	alert($i18n("fcm.preferences.js.copySystemGrid.notCopied.txt"));
      		    return;
      	  }

          var idx = nodeId.indexOf("G");
          var idx1 = nodeId.indexOf("A");
          var num;

          if(idx == 0 && idx1 < 0 ) {
              setCookieForTab(nodeId);

              action = node.parameters.join('&');
              action = action.replace('viewGridTemplate','copyGridTemplate');
              action += '&__sfmrt=' + getCookie("__sfmrt");
//              frames[targetFrame].location.href = action;
              setBusy();
              $df.postURL(targetFrame, action);

          } else if (idx < 0 ) {
              alert($i18n("fcm.preferences.overview.copy.confirm0.txt"));
              return;
          } else {
              alert($i18n("fcm.preferences.overview.copy.confirm0.txt"));
              return;
          }
      }
   }
   // setBusyDetail();
}

/* **************************************************** */
/*    Handling actions in the SubmitGridActivity page          */
/* **************************************************** */

function gridOnLoadHandler()
{
	setGridHeight('account', '320');
	setGridHeight('activity', '320');
}

function onLoadHandler()
{
	setGridHeight('available', '320');
	setGridHeight('selected', '320');
}

function onLoadHandler2(namePrefix)
{
	// Get the ContentDiv
	var contentDiv = getElement(namePrefix+'ContentDiv');
	// Calculate the difference in height between the content and screen
	// Negative means shrink, positive means stretch
	var delta = getClientHeight() - getBottomPosition(contentDiv);
	// add the delta to the scrollable div height since this is the piece that can adjust its height
	var newHeight = getHeight(namePrefix+'Div') + delta;
	// make sure newHeight is at least 50px
	setGridHeight(namePrefix, (newHeight < 50 ? 50 : newHeight));
}

function setGridHeight(namePrefix, grdHeight)	// availableDiv , selectedDiv, availableTable, selectedTable
{
	var grd = document.getElementById(namePrefix + 'Div');
	var tbl = document.getElementById(namePrefix + 'Table');
	var tblHeight = tbl.offsetHeight;

	var	grdStyl = grd.style;
	var	tblStyl = tbl.style;


	if (tblHeight < grdHeight)
	{
	   grdStyl.height = tblHeight;
	   tblStyl.width = grdStyl.width;
	}
	else
	{	tblStyl.width = 'auto'
	   grdStyl.height = grdHeight + 'px';
	}

}

function alternateRowClassNames(tableId, oddClass, evenClass)
{
   var table = document.getElementById(tableId);
   var rows = table.tBodies[0].rows;
   for (var i=0; i<rows.length; i++)
   {
      if(i%2)
	   {
		   rows[i].className = evenClass;
		   for(var j=1; j<rows[i].cells.length; j++)
		   {
			   switch (rows[i].cells[j].className)
			   {
					case 'textCell':
					   rows[i].cells[j].childNodes[1].className = 'textCell2';
					   break;
					case 'tableTextCell':
					   rows[i].cells[j].childNodes[1].className = 'textCell2';
					   break;
			   }
		   }
	   } else
	   {
		   rows[i].className = oddClass;
		   for(var j=1; j<rows[i].cells.length; j++)
		   {
			   switch (rows[i].cells[j].className)
			   {
					case 'textCell':
					   rows[i].cells[j].childNodes[1].className = 'textCell1';
					   break;
					case 'tableTextCell':
					   rows[i].cells[j].childNodes[1].className = 'textCell1';
					   break;
			   }
		   }
	   }
   }
}

function limitChars2(field, max, min, showWarn, previousvalue)
{
    if (field.value.length > max)
    {
        field.value = field.value.substring(0, max);
        if (showWarn)
            alert($i18n("fcm.common.js.limitChars.alert0.fmt.txt", [max])) ;
    }
    if (field.value.length < min)
    {
        if (showWarn){
            alert($i18n("fcm.preferences.js.limitChars2.alert.fmt.txt", [min])) ;
            if (previousvalue.length == 0) {
                previousvalue = $i18n("fcm.preferences.js.limitChars2.msg.txt");
            }
            field.value = previousvalue;
        }
    }
}

function saveModifiedField (field)
{
	modifiedFieldList["m"+field.id] = field;
//	console.log(field);
}

// ctrl is either a row object or a form control object
function saveModifiedFieldChange (ctrl)
{
	var $row = (ctrl instanceof jQuery) ? ctrl : $(ctrl).parent().parent();
	var fieldID = $row.attr("id");
	var field = masterFields[fieldID];

	if (field)
	{
	   	if(templateType === 'ANALYST'){
			field.order= $row.find('td:eq(0)').text();
			field.alignment= $row.find('select[name="alignment"] option:selected').val();
			field.dataPopEnabled= $row.find('input[name="datapop"]').prop('checked');
			field.label= $row.find('td:eq(6)').text();
			field.labelDesc= $row.find('td:eq(7)').text();
		}
		else
		{
			field.order= $row.find('td:eq(0)').text();
	        field.label= $row.find('td:eq(4)').text()
		}
		saveModifiedField(field);
	}
//	console.log(field);
}

function selectFieldHandler(event)
{
	var $target = $(event.target);
	if($target.attr('name') === 'moveField')
	{
		// get the row to move
		 var $row = $target.parent().parent();

		 // increment row # on source table
		 var $nextRow = $row.next();
		 var count = $row.find('td:eq(0)').text();
		 while($nextRow.length) // RAPTOR-2399
		 {
			 $nextRow.find('td:eq(0)').text(count++);
			 $nextRow = $nextRow.next();
		 }

		 // remove it from the source table
		 $row.remove();
		 // add it to the destination table
		 _highlightedRow = selectField($row[0], 'selectedTableBody', event.data.templateType);

		 alternateRowClassNames('availableTable', 'dataRow1_tableRow', 'dataRow2_tableRow');

	    setGridHeight('available', '320');
	    setGridHeight('selected', '320');

	    _highlightedRow.scrollIntoView();
		 event.stopPropagation();
	}

}

function unselectFieldHandler(event)
{
	var $target = $(event.target);
	if($target.attr('name') === 'moveField')
	{
		var $row = $target.parent().parent();
		 var $nextRow = $row.next();
		 var count = $row.find('td:eq(0)').text();
		 while($nextRow.length) // RAPTOR-2399
		 {
			 $nextRow.find('td:eq(0)').text(count++);
			 $nextRow = $nextRow.next();
		 }

		 $row.remove();

		 _highlightedRow = unselectField($row[0], 'availableTableBody', event.data.templateType);
		 alternateRowClassNames('selectedTable', 'dataRow1_tableRow', 'dataRow2_tableRow');

		 setGridHeight('available', '320');
	    setGridHeight('selected', '320');

	    if(_highlightedRow)
	   	 _highlightedRow.scrollIntoView();
	    event.stopPropagation();
	}

}

function selectField(curRow, dstTableId, templateType)
{
    var $curRow = $(curRow);
    var $newRow = $curRow.clone(true);

    var $dstTable = $('#'+dstTableId);
    var rowNum = $dstTable.find('tr').length + 1; // RAPTOR-2399
    var classNames = {
   		 '0':'dataRow1_tableRow',
   		 '1':'dataRow2_tableRow'
    };
    $newRow.removeClass(classNames[(rowNum+1)%2]).addClass(classNames[rowNum%2]);
    var segmentId = $.trim($curRow.find('td:eq(1)').text());

    var field = masterFields[$curRow.attr('id')];
    field.selected = true;
    field.order = rowNum;

	saveModifiedField (field);

    $newRow.find('td:eq(0)').text(rowNum);
    if(templateType === 'ANALYST')
	 {
   	 // Add drop down box for alignment
   	 var $alignmentCell = $newRow.find('td:eq(4)');
   	 var value = $alignmentCell.text().trim().toLowerCase();

   	 // alert($alignmentCell.html());
   	 var alignCellText = "<select name='alignment' class='famSelect' onchange='saveModifiedFieldChange(this);'><option value='left'>" + $i18n("fcm.preferences.gridTemplate.fieldAlignment.left.txt");
	 alignCellText += "</option><option value='center'> " + $i18n("fcm.preferences.gridTemplate.fieldAlignment.center.txt");
	 alignCellText += "</option><option value='right'>" + $i18n("fcm.preferences.gridTemplate.fieldAlignment.right.txt") + "</option></select>";
	 $alignmentCell.html(alignCellText);
	 // alert($alignmentCell.html());

   	 $alignmentCell.find('option[value="'+value+'"]').prop('selected',true);

   	 //enable datapop
   	 if (field.dataPopAvailable)
   	 	$newRow.find('input[name="datapop"]').prop('disabled',false);
	 }

    $newRow.find('img[name="moveField"]').attr('src','admin/images/arrowUpRemove.gif');
    $newRow.find('img[name="moveField"]').attr('alt', $i18n("fcm.preferences.content.remove.txt") );
    $dstTable.append($newRow);

    return $newRow[0];
}

function unselectField(curRow, dstTableId, templateType)
{
	 var $curRow = $(curRow);

    var segmentId = $.trim($curRow.find('td:eq(1)').text());
    var field = masterFields[$curRow.attr('id')];
	field.selected = false;
	field.order = 0;
	if(templateType === 'ANALYST'){
		field.alignment = $curRow.find('select[name="alignment"] option:selected').val();
		field.dataPopEnabled = $curRow.find('input[name="datapop"]').prop('checked');
		field.label = $curRow.find('td:eq(6)').text();
		field.labelDesc = $curRow.find('td:eq(7)').text();
	}
	else{
		field.label = $curRow.find('td:eq(4)').text();
	}

	saveModifiedField (field);

	 var selectedSegmentId = $('#segmentFilter option:selected').val();
    if(selectedSegmentId !== "NONE" && selectedSegmentId !== segmentId)
		 return null;

    var $newRow = $curRow.clone(true);
    var $dstTable = $('#'+dstTableId);

    var rowNum = $dstTable.find('tr').length + 1; // RAPTOR-2399
    var classNames = {
   		 '0':'dataRow1_tableRow',
   		 '1':'dataRow2_tableRow'
    };
    $newRow.removeClass(classNames[(rowNum+1)%2]).addClass(classNames[rowNum%2]);

    $newRow.find('td:eq(0)').text(rowNum);
    if(templateType === 'ANALYST')
	 {
   	 // removing drop down box for alignment
   	 var $alignmentCell = $newRow.find('td:eq(4)')
   	 var alignment = $alignmentCell.find('select[name="alignment"] option:selected').text();
   	 $alignmentCell.children().remove();
   	 $alignmentCell.text(alignment);

   	 //disable datapop
   	 $newRow.find('input[name="datapop"]').prop('disabled',true);
	 }
    // Change image
	 $newRow.find('img[name="moveField"]').attr('src','admin/images/arrowDownAdd.gif');
	 $newRow.find('img[name="moveField"]').attr('alt',$i18n("fcm.preferences.content.select.txt") );

	 $dstTable.append($newRow);

	 return $newRow[0];
}

function selectAllFields(templateType)
{
	var $rows = $('#availableTableBody').find('tr');
   var size = $rows.length; // RAPTOR-2399
   var rowArray = [];
   // Remove rows from bottom to top for performance gains
	 for(var i = size-1; i>=0; i--)
    {
		 var $row = $rows.eq(i);
		 $row.remove();
		 rowArray[rowArray.length] = $row[0];
    }

	 // Add rows in the original order
	 size = rowArray.length;
	 for(var i = size-1; i>=0; i--)
    {
		 selectField(rowArray[i], 'selectedTableBody', templateType);
    }

	 setGridHeight('available', '320');
    setGridHeight('selected', '320');

}

function unselectAllFields(templateType)
{
	var $rows = $('#selectedTableBody').find('tr');
   var size = $rows.length; // RAPTOR-2399

   var rowArray = [];
   // Remove rows from bottom to top for performance gains
	 for(i = size-1; i>=0; i--)
    {
		 var $row = $rows.eq(i);
		 if($row.find('img[name="moveField"]').css('display') != 'none'){
			 $row.remove();
			 rowArray[rowArray.length] = $row[0];
		 }
    }

	 // Add rows in the original order
	 size = rowArray.length;
	 for(var i = size-1; i>=0; i--)
    {
		 unselectField(rowArray[i], 'availableTableBody', templateType);
    }

	 //alternateRowClassNames('availableTable', 'dataRow1_tableRow', 'dataRow2_tableRow');

	 setGridHeight('available', '320');
    setGridHeight('selected', '320');
}

function customMove(divRef,tableId,startIndex,dir)
{
	// No row has been highlighted
    if(!_highlightedRow) {
        alert($i18n("fcm.preferences.js.customMove.alert0.txt"));
        return;
    }

    var $row = $(_highlightedRow);
    // highlighted row is not in the selected table
    if(!$row.parents('#'+tableId).length) // RAPTOR-2399
    {
   	 alert($i18n("fcm.preferences.js.customMove.alert0.txt"));
       return;
    }

    if($row[0].rowIndex + 1 < startIndex)
  	 {
   	 return;
  	 }

    var rowIndex = $row[0].rowIndex;
    var newRowIndex = rowIndex;
    var $siblings = $row.siblings();
    var endIndex = $siblings.length; // RAPTOR-2399
    if((dir == 'up' || dir == 'top') && startIndex < rowIndex)
    {
   	 var $swapRow = (dir == 'up') ? $row.prev() : $siblings.eq(startIndex-1);
   	 newRowIndex = $swapRow[0].rowIndex;
   	 $row.insertBefore($swapRow);

   	 // re-order
   	 var $rows = $row.parent().find('tr');
   	 for(var i = newRowIndex; i <= rowIndex; i++)
      {
   	   	 $rows.eq(i-1).find("td:eq(0)").text(i);
   	   	 if(i%2)
   	   		 $rows.eq(i-1).removeClass('dataRow2_tableRow').addClass('dataRow1_tableRow');
   	   	 else
   	   		 $rows.eq(i-1).removeClass('dataRow1_tableRow').addClass('dataRow2_tableRow');

   	   	 saveModifiedFieldChange ($rows.eq(i-1));
   	  }

    }
    else if((dir == 'down' || dir == 'bottom') && endIndex >= rowIndex)
    {
   	 var $swapRow = (dir == 'down') ? $row.next() : $siblings.eq(endIndex-1);
   	 newRowIndex = $swapRow[0].rowIndex;
   	 $row.insertAfter($swapRow);
   	 //re-order
   	 var $rows = $row.parent().find('tr');
   	 for(var i = rowIndex; i <= newRowIndex; i++)
   	   {
   	   	 $rows.eq(i-1).find("td:eq(0)").text(i);
   	   	 if(i%2)
   	   		 $rows.eq(i-1).removeClass('dataRow2_tableRow').addClass('dataRow1_tableRow');
   	   	 else
   	   		 $rows.eq(i-1).removeClass('dataRow1_tableRow').addClass('dataRow2_tableRow');

   	   	 saveModifiedFieldChange ($rows.eq(i-1));
   	  }
    }

    //scroll to moved row
    var top = $row.position().top;
    var rowHeight = $row.height();
    var $div = $('#'+divRef);
    var scrollTop = $div.scrollTop();
    if(top < 25)
   	 $div.scrollTop(scrollTop - 25 - (0-top))
    else if(top+rowHeight > $div.height())
   	 $div.scrollTop(scrollTop + top - 25)
}

function showDiv(img, collapseDivId)
{
   var divElement = document.getElementById(collapseDivId);

   if (divElement.style.display == 'none') {
	  if (divElement.tagName == "TR") {
	      divElement.style.display = "table-row";
	  } else if (divElement.tagName == "TABLE") {
	      divElement.style.display = "table";
	  } else if (divElement.tagName == "DIV") {
	      divElement.style.display = "block";
	  } else {
	      divElement.style.display = "inline";
	  }
      var show = "yes";
//      img.src = "admin/images/sprite_arrow_down_light.png";
      if(img!=''){
    	  img.setAttribute("data-sap-ui-icon-content", $("<div/>").html(iconNameLookup["expanded"]).text());
      }
   } else {
      divElement.style.display = "none";
      var show = "no";
//      img.src = "admin/images/sprite_arrow_right_light.png";
      if(img!=''){
    	  img.setAttribute("data-sap-ui-icon-content", $("<div/>").html(iconNameLookup["collapsed"]).text());
      }
   }
}

/* **************************************************** */
/*    Submit Forms in Grid Template Definition pages    */
/* **************************************************** */

function isIntegerValue(valueStr)
{
	if(valueStr.length > 0 && valueStr.indexOf('.') < 0 && !isNaN(valueStr))
		return !isNaN(parseInt(valueStr));
	return false;
}

function validateGridTemplateForm()
{
	var $form = $(document.gridTemplateForm);
	var $fieldLookBackDays =  $form.find('input[name="lookBackDays"]');

	var lookBackDays = $fieldLookBackDays.val();
	if (!isIntegerValue(lookBackDays) || lookBackDays <1 || lookBackDays > 365)
	{
		alert ($i18n("fcm.preferences.gridTemplate.lookBackDays.alert.txt"));
		$fieldLookBackDays.focus().select();
		return false;
	}

	var $fieldHistoryDays =  $form.find('input[name="historyDays"]');
	if ( $fieldHistoryDays.length > 0 )
	{
		var historyDays = $fieldHistoryDays.val();
		if (!isIntegerValue(historyDays) || historyDays <0 || historyDays > 365 || parseInt(historyDays) + parseInt(lookBackDays) > 365)
		{
			alert ($i18n("fcm.preferences.gridTemplate.historyDays.alert.txt"));
			$fieldHistoryDays.focus().select();
			return false;
		}
	}
	return true;
}

function submitGridTemplateForm(formObj, accountTypes, activityTypes)
{
	setBusy();

   var $form = $(document.gridTemplateForm);
   var $checkboxes = $form.find('input[name="accountCheckbox"]');

   var size = $checkboxes.length; // RAPTOR-2399
   var fragment = document.createDocumentFragment();
   var ele;
   var activityIndex=0;
   for(var i = 0; i < size; i++)
   {
   	var $checkbox = $checkboxes.eq(i);
   	var selected = $checkbox.prop('checked');
   	var accountTypeId = $checkbox.attr('id').slice(4);
      obj = accountTypes[$checkbox.attr('id')];
      
      var idp = "gridAccounts["+i+"].";
	
      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idp + "accountTypeId";
      ele.value = accountTypeId;
      fragment.appendChild(ele);

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idp + "accountSelected";
      ele.value = selected;
      fragment.appendChild(ele);

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idp + "accountOrder";
      ele.value = i+1;
      fragment.appendChild(ele);

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idp + "version";
      ele.value = obj.version;
      fragment.appendChild(ele);

      // Send activity information for account type
      var activityIDs = activityTypesByAccountType[$checkbox.attr('id')];
      for(var j = 0; j < activityIDs.length; j++)
      {
        var idx = "gridActivities["+ activityIndex++ +"].";
      
      	var activityID = activityIDs[j];
      	$checkbox = $('#'+activityID);
      	var selected = $checkbox.length==1 ? $checkbox.prop('checked') : false;
         obj = activityTypes[activityID];

         // = activity123
         var id = activityID.slice(8);

         ele = document.createElement("input");
         ele.type = "hidden";
         ele.name = idx + "transActivityId";
         ele.value = id;
         fragment.appendChild(ele);
         
         ele = document.createElement("input");
         ele.type = "hidden";
         ele.name = idx + "activitySelected";
         ele.value = selected;
         fragment.appendChild(ele);

         var $row = $('#activityRow'+id)
         // get the order from the checkbox row num
         var order = $row.length ? $row.find('td:eq(0)').text() : "0"; // RAPTOR-2399
         ele = document.createElement("input");
         ele.type = "hidden";
         ele.name = idx + "activityOrder";
         ele.value = order;
         fragment.appendChild(ele);

         ele = document.createElement("input");
         ele.type = "hidden";
         ele.name = idx + "accountTypeId";
         ele.value = obj.accountTypeId;
         fragment.appendChild(ele);

         ele = document.createElement("input");
         ele.type = "hidden";
         ele.name = idx + "version";
         ele.value = obj.version;
         fragment.appendChild(ele);
      }
   }

   $form.append(fragment);
}

function submitGridAccountTypeForm(formObj, activityVersions)
{
	setBusy();

	var $form = $(formObj);
   var $checkboxes = $form.find('input[name="activityCheckbox"]');
   var accountTypeID = $form.find('input[name="id"]').val();

   var size = $checkboxes.length; // RAPTOR-2399
   var fragment = document.createDocumentFragment();
   var ele;
   for(var i = 0; i < size; i++)
   {
   	var $checkbox = $checkboxes.eq(i);
   	var selected = $checkbox.prop('checked');
   	var activityID = $checkbox.attr('id').slice(1);
      var version = activityVersions[$checkbox.attr('id')].version;

      var idx = "gridActivities["+i+"].";

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idx + "transActivityId";
      ele.value = activityID;
      fragment.appendChild(ele);
     
      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idx + "activitySelected";
      ele.value = selected;
      fragment.appendChild(ele);

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idx + "activityOrder";
      ele.value = i+1;
      fragment.appendChild(ele);

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idx + "version";
      ele.value = version;
      fragment.appendChild(ele);

      ele = document.createElement("input");
      ele.type = "hidden";
      ele.name = idx + "accountTypeId";
      ele.value = accountTypeID;
      fragment.appendChild(ele);

   }

   $form.append(fragment);
}

function submitGridActivityTypeForm(formObj)
{
	setBusy();
	console.log("begin:" + new Date());

	// save edits and all selections if change scope is beyond the activity
	$('#selectedTableBody').mousedown();
	if (!formObj.fieldPropagationPolicy[2].checked)
	{
		$('#selectedTableBody > tr').each(function () {
			saveModifiedField (masterFields[$(this).attr("id")]);
		});
	}

	// var capitalize = function(s){return s.charAt(0).toUpperCase() +s.slice(1);}
	var props = ['id', 'alignment','dataPopEnabled','label','labelDesc','selected','order','version','tenantOrgNodeId']
	var propNames = ['gridFieldId','fieldAlignment','dataPopEnabledInd','gridFieldHeader','gridFieldHeaderDesc','fieldSelected','fieldOrder','version','tenantOrgNodeId']

	formObj.addInput = function (name, value) {
		$(this).append($("<input>").attr("type", "hidden").attr("name", name).attr("value", value));
	};

	var i=0;
	for (var x in modifiedFieldList)
	{
	    var idp = "gridFields["+ i++ +"].";	   	
		var field = modifiedFieldList[x];
	   	for(var j = 0; j < props.length; j++){
	   		var prop = props[j];
	   		var propName = propNames[j];
	   		formObj.addInput(idp + propName, field[prop]);
	   	}
	}
	if (i > maxGridFieldsValue) {
		alert($i18n("fcm.preferences.overview.warning.grid.max.fields.txt", [i, maxGridFieldsValue]));
		this.location.reload();
		console.log("end:" + new Date());
		return false;
	}
	console.log("end:" + new Date());
}

function submitPropertyForm(formObj, previousSubTypeLabel)
{
	if (formObj.elements.isSubTypeNode.value == "true") {
	    var labelInput = document.getElementById("subTypeLabel");
	    var inputValue = labelInput.value;
	
		if (inputValue == "") {
			alert($i18n("fcm.preferences.js.submitPropertyForm.alert.txt"));
	
			labelInput.value = previousSubTypeLabel;
			labelInput.select();
			labelInput.focus();
	
		    return false;
	     }
	}

   	setBusy();
}

function submitDataMaskingForm(formObj)
{
   	setBusy();
}

function doSubmitTransactionDataMaskForm()
{
   	setBusy();
   	$("#transactionDataMaskForm").submit();
}

function doSubmitGridTemplateForm()
{
	if ( validateGridTemplateForm() ) {
	   	setBusy();
	   	$("#gridTemplateForm").submit();
	}
}

function doSubmitAccountTypeForm()
{
   	setBusy();
   	$("#gridAccountTypeForm").submit();
}

function doSubmitActivityTypeForm()
{
   	setBusy();
   	// submit activity is so slow, set a brief delay so that the setBusy will display
   	// setBusy does not display without a delay for some reason
   	setTimeout(function() {
   	   	$("#gridActivityTypeForm").submit();
   	}, 750);
}

function doSubmitSystemPropertyForm()
{
	// setBusy();
	$("#propertyForm").submit();
}

function submitEntityDataMaskingForm(formObj)
{
   	setBusy();
}

 function loadSelectedFieldsTable(list, templateType)
{
    var fragment = document.getElementById("selectedTableBody");

    var $row = $('#selectedRowClone');
    var count = 1;
    for (var i=0; i < list.length; i++)
    {
   	   var field = masterFields[list[i]];
        if (field.selected)
        {
      	  var $newRow = $row.clone(true);
      	  $newRow.addClass(count % 2 ? 'dataRow1_tableRow' : 'dataRow2_tableRow');
      	  $newRow.attr('id','f'+field.id);

      	  var $cell = $newRow.find('td:eq(0)');
           $cell.text(count);

         $cell = $cell.next();
			$cell.text(field.segmentId);

			$cell = $cell.next();
			$cell.html(tenantPrefixList[""+field.tenantOrgNodeId]+field.name+field.supInfo);

			$cell = $cell.next();
			$cell.text(field.desc);

			if(templateType === 'ANALYST')
			{
				$cell = $cell.next();
				$cell.find('select').prop('value',field.alignment);

				$cell = $cell.next();
				if (field.dataPopAvailable)
					$cell.find('input[name="datapop"]').prop('checked',field.dataPopEnabled);
				else
					$cell.find('input[name="datapop"]').prop('disabled', true);

				$cell = $cell.next();
				$cell.text(field.label);

				$cell = $cell.next();
				$cell.text(field.labelDesc);

				$cell = $cell.next();
				var imgSelector= (field.permanentSelected ? 'img[name="noMoveField"]' : 'img[name="moveField"]');
				$cell.find(imgSelector).css('display', '');
			}
			else
			{
				$cell = $cell.next();
				$cell.text(field.label);

				$cell = $cell.next();
				var imgSelector= 'img[name="moveField"]';
				$cell.find(imgSelector).css('display', '');
			}

            fragment.appendChild($newRow[0]);
            count++;
        }
    }
    return --count;
}


function loadTableBySegmentId(fragment, segmentId, list, count, templateType)
{
    var $row = $('#availableRowClone');
    var numRows = 0;
    var fieldIDs = list[segmentId];
    for (var i=0; i < fieldIDs.length; i++)
    {
   	   var fieldID = fieldIDs[i];
   	   var field = masterFields[fieldID];
        if (!field.selected)
        {
      	  numRows++;
      	  var $newRow = $row.clone(true);
      	  $newRow.addClass(count % 2 ? 'dataRow1_tableRow' : 'dataRow2_tableRow');
      	  $newRow.attr('id','f'+field.id);


      	  var $cell = $newRow.find('td:eq(0)');
           $cell.text(count);

         $cell = $cell.next();
			$cell.text(field.segmentId);

			$cell = $cell.next();
			$cell.html(tenantPrefixList[""+field.tenantOrgNodeId]+field.name+field.supInfo);

			$cell = $cell.next();
			$cell.text(field.desc);

			if(templateType === 'ANALYST')
			{
				$cell = $cell.next();
				// alert("aligment: "+ field.alignment);
				if (field.alignment === 'right')
				{
					$cell.text($i18n("fcm.preferences.gridTemplate.fieldAlignment.right.txt"));
				} else if (field.alignment === 'center')
				{
					$cell.text($i18n("fcm.preferences.gridTemplate.fieldAlignment.center.txt"));
				} else if (field.alignment === 'left')
				{
					$cell.text($i18n("fcm.preferences.gridTemplate.fieldAlignment.left.txt"));
				}

				$cell = $cell.next();
				if (field.dataPopAvailable)
					$cell.find('input[name="datapop"]').prop('checked',field.dataPopEnabled);
				else
					$cell.find('input[name="datapop"]').prop('disabled', true);

				$cell = $cell.next();
				$cell.text(field.label);

				$cell = $cell.next();
				$cell.text(field.labelDesc);
			}
			else
			{
				$cell = $cell.next();
				$cell.text(field.label);
			}

            fragment.appendChild($newRow[0]);
            count++;
        }
    }
    return numRows;
}

function showAvailableFieldsBySegment(tableId, selectedSegmentId, list, segList, templateType)
{
    var table = document.getElementById(tableId);
    var count = 1;
    var tBody = table.tBodies[0];
    var newTBody = document.createElement('tbody');
    newTBody.id = tBody.id;
    var fragment = document.createDocumentFragment();
    if(selectedSegmentId === "NONE")     // show all unselected segments/fields
    {
        for (var j=0; j< segList.length; j++) {
        	if (segList[j].id)
        	{
            	var segmentId = segList[j].id;
            	count += loadTableBySegmentId(fragment,segmentId, list, count, templateType);
            }
        }
    } else if (selectedSegmentId.charAt(0) == "S")
    {
         for (var j=0; j< segList.length; j++) {
        	if (segList[j].section == selectedSegmentId && segList[j].id)
        	{
            	var segmentId = segList[j].id;
            	count += loadTableBySegmentId(fragment,segmentId, list, count, templateType);
            }
        }
    }
    else {
        count = loadTableBySegmentId(fragment, selectedSegmentId, list, count, templateType);
    }
    newTBody.appendChild(fragment);
    table.replaceChild(newTBody,tBody);

    setGridHeight('available', '320');
}

function makeEditable(event)
{
	var $listener = $(event.currentTarget);
	var $target = $(event.target);
	if(!$target.is('.editable'))
		return;

	if($listener.data('currentEdit'))
		return;

	var text = $target.text();
	$target.text('');
	if(event.data[$target[0].cellIndex] === 'textarea')
	{
		$target.append('<textarea class="famTextEntry editable" cols="32" rows="3" wrap="PHYSICAL" onfocus="this.select()" onKeyDown="limitChars(this,255)">'+text+'</textarea>')
		$target.find('textarea').focus();
	}
	else if(event.data[$target[0].cellIndex] === 'textfield')
	{
		$target.append('<input class="famTextEntry editable" type="text" maxLength="25" onfocus="this.select()" value="'+text+'" onKeyDown="limitChars(this,25)" />');
		$target.find('input').focus();
	}

	$target.data('originalText',text);
	$listener.data('currentEdit',event.target);
}

function saveEdits(event)
{
	var $listener = $(event.currentTarget);
	var $target = $(event.target);

	if($listener.data('currentEdit') && ($listener.data('currentEdit') === $target[0] ||
			$listener.data('currentEdit') === $target.parent()[0] ))
		return;

	var $currentEdit = $($listener.data('currentEdit'));
	if(!$currentEdit.length) // RAPTOR-2399
		return;

	var text = "";
	var index = $currentEdit[0].cellIndex;
	if(event.data[index] === 'textarea')
	{
		text = $currentEdit.find('textarea').val();
	}
	else if(event.data[index] === 'textfield')
	{
		text = $currentEdit.find('input').val();
	}
	if($.trim(text).length < 1)
		text = $currentEdit.data('originalText');

	$currentEdit.children().remove();
	$currentEdit.text(text);
	$listener.data('currentEdit',null);

	saveModifiedFieldChange($currentEdit.parent());
}

function validateAllAccountSelection()
{
	var activitiesSelectedCount = $('input[id!="activity-1"][name="activityCheckbox"]:checked').length; // RAPTOR-2399

	if(!activitiesSelectedCount)
	{
		// Remove all activity
		$('#activityRow-1').remove();
		// Uncheck all account
		$('#acct-1').prop('checked',false).prop('disabled',true);
		// reorder the existing activities
		$('input[name="activityCheckbox"]').each(function(count){
			//input > td -> get first td in row
			$(this).parent().siblings().eq(0).text(count+1);
		});

		alternateRowClassNames('activityTable', 'dataRow1_tableRow', 'dataRow2_tableRow');
		setGridHeight('activity', '320');
	}
	else
	{
		$('#acct-1').prop('disabled',false);
	}

}

function showActivitiesByAccount(checkbox)
{
	var selected = checkbox.checked;
	var activityTypeIDs = activityTypesByAccountType[checkbox.id]

	if(!selected)
	{
		var ids = "";

		// check to see if only -1 account type is selected or
		// if no other account type is selected
		var $selectedAccountTypes = $('input[id!="acct-1"][name="accountCheckbox"]:checked');
		if(!$selectedAccountTypes.length){ // RAPTOR-2399

			$('#acct-1').prop('checked',false).prop('disabled',true);
			ids += '#activityRow-1,';
		}

		// activityTypeIDs start with t followed by number
		// rows to delete start with r followed by number
		for(var i = 0; i < activityTypeIDs.length; i++)
			ids += '#activityRow'+activityTypeIDs[i].slice(8)+",";
		$(ids).remove();

		var $selectedActivityTypes = $('input[id!="activity-1"][name="activityCheckbox"]:checked');
		if(!$selectedActivityTypes.length){ // RAPTOR-2399

			$('#acct-1').prop('checked',false).prop('disabled',true);
			$('#activityRow-1').remove();
		}

		// reorder the existing activities
		$('input[name="activityCheckbox"]').each(function(count){
			//input > td -> get first td in row
			$(this).parent().siblings().eq(0).text(count+1);
		});
		//move scrolling div back to top
		$('#activityDiv').scrollTop(0);
	}
	else{

		var $selectedActivityTypes = $('input[id!="activity-1"][name="activityCheckbox"]:checked');
		if(!$selectedActivityTypes.length){ // RAPTOR-2399

			$('#acct-1').prop('checked',false).prop('disabled',true);
			$('#activityRow-1').remove();
		}
		else{
			// enable the all account if it exists
			$('#acct-1').prop('disabled',false);
		}

		var $table = $('#activityTableBody');
		var fragment = document.createDocumentFragment();
		var $activityRow = $('#activityRowClone');
		var count = $table.find('tr').length+1; // RAPTOR-2399
		// insert the activity type
		for(var i = 0; i < activityTypeIDs.length; i++){
			var activityType = activityTypes[activityTypeIDs[i]];
			var $row = $activityRow.clone(true);
			$row.attr('id','activityRow'+activityTypeIDs[i].slice(8))
			$row.find('td:eq(0)').text(count++);
			$row.find(':checkbox')
					.attr('id',activityTypeIDs[i])
					.prop('checked',activityType.selected);
			$row.find('td:eq(2)').text(activityType.accountName);
			$row.find('td:eq(3)').text(activityType.activityName);
			$row.find('td:eq(4)').text(activityType.activityDesc);
			fragment.appendChild($row[0]);
		}
		$table.append(fragment);
		alternateRowClassNames('activityTable', 'dataRow1_tableRow', 'dataRow2_tableRow');

		//find first new row; highlight and scroll into view
		var $row = $('#activityRow'+activityTypeIDs[0].slice(8))
		if($row.length){ // RAPTOR-2399
			highlightRowById($row.get(0),'rowSelected');
			$row.get(0).scrollIntoView();
		}
	}
    setGridHeight('activity', '320');
}

// "Freeze" the table headers so that they are always visible
function repositionTHs(elem) {
	$(elem).find("th").css("top", elem.scrollTop + "px");
}