/**
 * save new model in cookie
 * 
 */

  var today = new Date();
  var expiry = new Date(today.getTime() + 1 * 1 * 3600 * 1000); // plus 1 hour

  function setCookie(name, value)
  {
    document.cookie=name + "=" + escape(value) + "; path=/; expires=" + expiry.toGMTString();
  }
  var expired = new Date(today.getTime() - 1 * 3600 * 1000); // less than 1 hour

  function deleteCookie(name)
  {
	  document.cookie=name + "=null; path=/; expires=" + expired.toGMTString();
  }

//The setCookie function is called by the form using the following function:


  function storeValues(modelScoreForm)  
  {
    setCookie("label", modelScoreForm.label.value);
    setCookie("model", modelScoreForm.model.value);
    
    if(modelScoreForm.scoreId_1!=undefined)
        setCookie("scoreId_1", modelScoreForm.scoreId_1.value);
    if(modelScoreForm.scoreId_2!=undefined)
        setCookie("scoreId_2", modelScoreForm.scoreId_2.value);
    if(modelScoreForm.scoreId_3!=undefined)
        setCookie("scoreId_3", modelScoreForm.scoreId_3.value);
    if(modelScoreForm.scoreId_4!=undefined)
        setCookie("scoreId_3", modelScoreForm.scoreId_4.value);
    $('li input:checkbox', parent.frames["detail"].document).each(function() {
    	setCookie($(this).attr("id"),$(this).is(":checked"));
    });
    return true;
  }


function submitModelForm()
{
   if(document.getElementById("id").value!="-1"){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm0.txt")))
		   return;
   }
   var formObj = document.modelScoreForm;
   var nameEl = document.getElementById('label');
   if(nameEl!=null){
	   var modelName = nameEl.value;

	   // alert("Before trim:" + modelName);
	   if(modelName.replace(/\s/g,"") == "")
	   {
	       alert($i18n("fcm.models.js.submitModelForm.alert0.txt"));
	       return;
	   }
	   modelName = modelName.replace(/^\s+/, '');
	   modelName = modelName.replace(/\s+$/, '');
	   document.getElementById('label').value = modelName;
   }
   var packnameEl = document.getElementById('model');
   var packName =  packnameEl.value;
   if(packName.replace(/\s/g,"") == "")
   {
          alert($i18n("fcm.models.js.submitModelForm.alert1.txt"));
          return;
   }
   if($("input[type='checkbox']:checked").length == 0 ){
	   alert($i18n("fcm.models.js.submitModelForm.alert2.txt"));
	   return;
   }
   packName = packName.replace(/^\s+/, '');
   packName = packName.replace(/\s+$/, '');
   packName = packName.replace(/\W/g, '');	//remove non-word character. A word character is a character from a-z, A-Z, 0-9, and underscore character.
   document.getElementById('model').value = packName;

   if(document.getElementById('scoreId_1')!=null){
	   var scoreId=document.getElementById('scoreId_1').value;
	   if(scoreId==""){
		   alert($i18n("fcm.models.js.submitModelForm.alert3.txt"));
		   return;
	   }
   }

   subForm(formObj);

}

function trim(s)
{
    var l=0; var r=s.length -1;
    while(l < s.length && s[l] == ' ')
    {     l++; }
    while(r > l && s[r] == ' ')
    {     r-=1;     }
    alert(l + "-" + r+1);
    return s.substring(l, r+1);
}

function doMultiOrgAction(userAction)
{
  if(userAction == 'newModel')
  {
	  doNewModelAction();
  }
  else if(userAction == 'deleteModel' )
  {
      doDeleteModelAction(userAction);
  }
  else if(userAction == 'showDetail')
  {
      //if model is new and not saved save in session
	  var modelScoreForm=parent.frames["detail"].document.modelScoreForm;
	  if(modelScoreForm!=undefined){
		  if(modelScoreForm.id.value =="-1"){
			  storeValues(modelScoreForm);
		  }
	  }
	  
	  doModifyAction(userAction);
  }
  else
  {
      alert($i18n("fcm.models.js.doModelsAction.alert0.fmt.txt",[userAction]));
  }
}
function deleteCookies(){
	deleteCookie("label");
	deleteCookie("model");	
	
	if(getCookie("scoreId_1")!=undefined)
		deleteCookie("scoreId_1");
	if(getCookie("scoreId_2")!=undefined)
		deleteCookie("scoreId_2");
	if(getCookie("scoreId_3")!=undefined)
		deleteCookie("scoreId_3");
	if(getCookie("scoreId_4")!=undefined)
		deleteCookie("scoreId_4");
	$('li input:checkbox', parent.frames["detail"].document).each(function(){
	   deleteCookie($(this).attr("id"));
	});
}

function doNewModelAction()
{
   deleteCookies();
   var action = 'createModel.action?__sfmrt=' + getCookie("__sfmrt");
   $df.postURL("overview", action);
}

function doDeleteModelAction(userAction)
{
  selectedNodes = parent.frames['overview']._modelScoreTree.getSelectedNodes();
  if(!isDefined(selectedNodes[0].nodeId) || selectedNodes.length != 1
     || selectedNodes[0].nodeId.indexOf("MULTIORG") == 0)
  {
     alert($i18n("fcm.models.js.doDeleteModelAction.alert0.txt"));
     return;
  }
  else
  {
     var node = selectedNodes[0];
     var modelScoreMap = parent.frames["overview"]._modelScoreMap;
     if(prodRulesAssigned){
    	 alert($i18n("fcm.models.js.doDeleteModelAction.alert1.txt"));
    	 return;
     }


     if(userAction!="cancel"){
    	 if(!confirm($i18n("fcm.models.js.doDeleteModelAction.confirm0.txt")))
    		 return;
     }


     var tree = parent.frames["overview"]._modelScoreTree;
     var nextNode = tree.getNextSibling(node);
     if ( nextNode == null )
    	 	nextNode = tree.getPreviousSibling(node);
	 setCookieForTab(nextNode ? nextNode.nodeId : node.parentId);

     var method = '';
     var id = '';
     var version = '';
     var label = '';
     method         += 'deleteModel.action';
     id             += '&id=' + modelScoreMap[node.nodeId].id;
     label          += '&label=' + modelScoreMap[node.nodeId].label;

     var action = method + '?__sfmrt=' + getCookie("__sfmrt") + id + version + label;
     removeCookie('fam_mod_multiorg',node.nodeId);
     $df.postURL("overview", action);
   }
}

// The frame semantics are a little different
// since this is invoked from the overview frame
function doModifyAction(userAction)
{
  selectedNodes = _modelScoreTree.getSelectedNodes();

  var node = selectedNodes[0];
  if(node!=undefined)
	  setCookieForTab(node.nodeId);
  var method = '';
  var id = '';
  var version = '';
  var label = '';
  if(node==undefined){
	  parent.sas.fscf.getCurrentDetailToolbar().setContentFor();
      parent.frames[ "detail" ].location.href = 'common/blank.html';
      return;
  }else{
 	method         += 'modifyModel.action';
  	id             += '?id=' + _modelScoreMap[node.nodeId].id;
	parent.sas.fscf.getCurrentDetailToolbar().setContentFor('model', parent.frames["overview"]._canModify,_modelScoreMap[node.nodeId].canDelete);
  }

  var action = method + id;
  setBusyDetail();
  parent.frames[ "detail" ].location.href = action;

}

function isNumeric(sText)
{
   var ValidChars = "0123456789";
   var IsNumber=true;
   var Char;


   for (i = 0; i < sText.length && IsNumber == true; i++)
      {
      Char = sText.charAt(i);
      if (ValidChars.indexOf(Char) == -1)
         {
         IsNumber = false;
         }
      }
   return IsNumber;
}

function onLoadHandler(namePrefix)
{
	setGridHeight(namePrefix, '240');
}
/**************************************************************RULE SELECTIONS**************************************************************/
function printRules(){
	setSelectedRules();
	var allowAll=false;
	if(selectedRuleIds.length == 0) {
		if (!allowAll || !confirm($i18n("rules.ruleAction.js.selectAllRules.confirm.txt"))) {
			alert($i18n("rules.ruleAction.js.selectRules.alert.txt"));
	        return;
		}
	}

	var link = "printRules.action?idList=" + selectedRuleIds +
		"&lockVersionList=" + selectedRuleLockVersions +
		"&workflow=" + selectedRuleState + "&showAll=false";
	var printWindowName = "PrintableRule" + new Date().valueOf();
	var w = window.open("common/blank.html", printWindowName, "menubar,toolbar,resizable=1, scrollbars=1, status=1, width=800, height=600");
	$df.postURL(printWindowName, link);
	w.focus();
}
function handleRuleSelection(id, baseRuleId, name, description, version, lockVersion, state, blockingRules_coding, blockingRules_testing,row, className, event)
{
    var rule = new Object();
    rule.id = id;
    rule.baseRuleId = baseRuleId;
    rule.name = name;
    rule.description = description;
    rule.version = version;
    rule.lockVersion = lockVersion;
    rule.state = state;
    rule.blockingRuleCnt_coding=blockingRules_coding;
    rule.blockingRuleCnt_testing=blockingRules_testing;
    rule.position = getPositionOfTableRow(row);
    highlightRow(row, className, event, rule);
}

//for single select
var selectedRuleId = '';
var selectedBaseRuleId = '';
var selectedRuleName = '';
var selectedRuleDescription = '';
var selectedRuleVersion = '';
var selectedRuleLockVersion = '';
var selectedRuleState = '';
var selectedRuleBlockingRuleCnt_coding='';
var selectedRuleBlockingRuleCnt_testing='';

// for multi select
var selectedRuleIds = '';
var selectedBaseRuleIds = '';
var selectedRuleNames = '';
var selectedRuleDescriptions = '';
var selectedRuleVersions = '';
var selectedRuleLockVersions = '';
var selectedRuleBlockingRuleCnts_coding='';
var selectedRuleBlockingRuleCnts_testing='';

var blockedRules_coding='';
var blockedRules_testing='';


function setSelectedRules()
{
	blockedRules_coding='';
	blockedRules_testing='';

	var selectedRuleIdList = new Array();
    var selectedBaseRuleIdList = new Array();
    var selectedRuleNameList = new Array();
    var selectedRuleDescriptionList = new Array();
    var selectedRuleVersionList = new Array();
    var selectedRuleLockVersionList = new Array();
    var selectedRuleStateList = new Array();
    var selectedRuleBlockingRuleCntList_coding=new Array();
    var selectedRuleBlockingRuleCntList_testing=new Array();


    selectedRuleId = '';
    selectedBaseRuleId = '';
    selectedRuleName = '';
    selectedRuleDescription = '';
    selectedRuleVersion = '';
    selectedRuleLockVersion = '';
    selectedRuleState = '';
    selectedRuleBlockingRuleCnt_coding ='';
    selectedRuleBlockingRuleCnt_testing ='';

    // iterate through keys in hashmap
    for(var i in _highlightedRowMap)
    {
        var selection = _highlightedRowMap[i];
        if(selection != null && isDefined(selection))
        {
          var rule = selection.mappedObject;
          var p = rule.position;
          selectedRuleIdList[p] = rule.id;
          selectedBaseRuleIdList[p] = rule.baseRuleId;
          selectedRuleNameList[p] = rule.name;
          selectedRuleDescriptionList[p] = rule.description.replace(/,/g,"%2C");
          selectedRuleVersionList[p] = rule.version;
          selectedRuleLockVersionList[p] = rule.lockVersion;
          selectedRuleStateList[p] = rule.state;
          selectedRuleBlockingRuleCntList_coding[p]=rule.blockingRuleCnt_coding;
          selectedRuleBlockingRuleCntList_testing[p]=rule.blockingRuleCnt_testing;

          if(rule.blockingRuleCnt_coding>0){
        	  //alert(blockedRules_coding);
        	  blockedRules_coding+="\n\t-"+rule.name;
          }
          if(rule.blockingRuleCnt_testing>0){
        	  //alert(blockedRules_testing);
        	  blockedRules_testing+="\n\t-"+rule.name;
          }

        }
    }

    // Assign values in their displayed order (trim multi, leading, and trailing commas)
    selectedRuleIds = selectedRuleIdList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedBaseRuleIds = selectedBaseRuleIdList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleNames = selectedRuleNameList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleDescriptions = selectedRuleDescriptionList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleVersions = selectedRuleVersionList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleLockVersions = selectedRuleLockVersionList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleStates = selectedRuleStateList.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleBlockingRuleCnts_coding=selectedRuleBlockingRuleCntList_coding.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");
    selectedRuleBlockingRuleCnts_testing=selectedRuleBlockingRuleCntList_testing.join(",").replace(/^,*|,*$/g,"").replace(/,+/g,",");

    // Show single selection if only one selected
    if (selectedRuleIds.split(',').length == 1)
    {
      selectedRuleId = selectedRuleIds.split(',')[0];
      selectedBaseRuleId = selectedBaseRuleIds.split(',')[0];
      selectedRuleName = selectedRuleNames.split(',')[0];
      selectedRuleDescription = selectedRuleDescriptions.split(',')[0];
      selectedRuleVersion = selectedRuleVersions.split(',')[0];
      selectedRuleLockVersion = selectedRuleLockVersions.split(',')[0];
      selectedRuleState = selectedRuleStates.split(',')[0];
      selectedRuleBlockingRuleCnt_coding=selectedRuleBlockingRuleCnts_coding.split(',')[0];
      selectedRuleBlockingRuleCnt_testing=selectedRuleBlockingRuleCnts_testing.split(',')[0];

   }
}

function processMultiSelectRequest()
{
   setSelectedRules();
   if(selectedRuleIds.length == 0)
   {
      selectedRuleIds=document.getElementById("allRuleIds").value.split(',');
      selectedRuleLockVersions=document.getElementById("allRuleLockVersions").value.split(',');

      var allRuleBlockingRules_coding=[];
      if(document.getElementById("allRuleBlockingRules_coding").value!=''){
    	  allRuleBlockingRules_coding=document.getElementById("allRuleBlockingRules_coding").value.split(",");
      }
      for(i=0;i<allRuleBlockingRules_coding.length;i++){
    	 if(allRuleBlockingRules_coding[i]!='') blockedRules_coding+="\n\t-"+allRuleBlockingRules_coding[i];
      }
      var allRuleBlockingRules_testing=[];
      if(document.getElementById("allRuleBlockingRules_testing").value!=''){
    	  allRuleBlockingRules_testing=document.getElementById("allRuleBlockingRules_testing").value.split(",");
      }
      for(i=0;i<allRuleBlockingRules_testing.length;i++){
    	  if(allRuleBlockingRules_testing[i]!='')blockedRules_testing+="\n\t-"+allRuleBlockingRules_testing[i];
      }

	   if (!confirm($i18n("rules.ruleAction.js.selectAllRules.confirm.txt"))) {
         alert($i18n("rules.ruleAction.js.selectRules.alert.txt"));
         return;
      }
   }
   if(blockedRules_coding!='' && blockedRules_testing!=''){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm1.fmt.txt",[blockedRules_coding, blockedRules_testing]))){
		return;
	   }
   }
   if(blockedRules_coding!='' && blockedRules_testing==''){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm2.fmt.txt",[blockedRules_coding]))){
		return;
	   }
   }
   if(blockedRules_coding=='' && blockedRules_testing!=''){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm3.fmt.txt",[blockedRules_testing]))){
		return;
	   }
   }
   // escape # character
   selectedRuleNames = selectedRuleNames.replace(/#/g, '%23').replace(/%/g, '%25');

   var method="moveModelRules.action";
   var oldModelId=document.getElementById("id").value;
   var newModelId=document.getElementById("newModelId").value;

   if (!window.userId)
      userId = "";

   link = method + "?idList=" + selectedRuleIds +
                 "&lockVersionList=" + selectedRuleLockVersions +
                 "&userId=" + userId+"&oldModelId="+oldModelId+"&newModelId="+newModelId;


   link += "&workflow=" + selectedRuleStates.split(",")[0];
   selectedRuleIds = '';

   if(blockedRules_coding!=''||blockedRules_testing!=''){
	   link +="&replaceExisting=y";
   }

   // Send the request to a new window (if so requested and not already open)
   setBusyDetail();
   //parent.frames[ "detail" ].location.href = link;
   link += '&__sfmrt=' + getCookie("__sfmrt");
	  $df.postURL("detail", link);
}
// Invokes a detail view of the previously-established rule (optional: destWorkflow, newWindow)
function processRequest()
{
   setSelectedRules();
   var method="moveModelRules.action";
   if (selectedRuleId == '')
   {
      alert($i18n("rules.ruleAction.js.selectSingleRule.alert.txt"));
      return;
   }
   if(blockedRules_coding!='' && blockedRules_testing!=''){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm1.fmt.txt",[blockedRules_coding, blockedRules_testing]))){
		return;
	   }
   }
   if(blockedRules_coding!='' && blockedRules_testing==''){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm2.fmt.txt",[blockedRules_coding]))){
		return;
	   }
   }
   if(blockedRules_coding=='' && blockedRules_testing!=''){
	   if(!confirm($i18n("fcm.models.js.submitModelForm.confirm3.fmt.txt",[blockedRules_testing]))){
		return;
	   }
   }


   // escape # character
   selectedRuleName = selectedRuleName.replace(/#/g, '%23').replace(/%/g, '%25');

   var link =  method + "?id=" + selectedRuleId + "&baseRuleId=" + selectedBaseRuleId +
              "&version=" + selectedRuleVersion + "&name=" + selectedRuleName +
              "&lockVersion=" + selectedRuleLockVersion + "&workflow=" + selectedRuleState;
   if(blockedRules_coding!='' || blockedRules_testing!=''){
	   link +="&replaceExisting=y";
   }

   setBusyDetail();
   link += '&__sfmrt=' + getCookie("__sfmrt");
   $df.postURL("detail", link);
}



