var _itemPriorityUpdated = false;
var _itemPriorityList = new Array();
function move(tableRef,startIndex,dir,amt,classNameValue)
{

   if(!isDefined(amt)) amt = 1;

   tbody = getElement(tableRef);
   // this is necessary for Firefox.  It embedes child #text nodes in the <TBODY>
   // so you have to count the <TR> children only.
   numRows = tbody.getElementsByTagName("TR").length;

   if(isDefined(_highlightedRow) == false ||
      (_highlightedRow.parentNode.id!=tableRef &&
         _highlightedRow.parentNode.parentNode.id!=tableRef))
   {
      alert($i18n("fcm.sq.prioritize.queue.js.move.alert0.txt"));
      return;
   }

   if((dir == 'up' || dir == 'top') && _highlightedRow.rowIndex == startIndex)
   {
      alert($i18n("fcm.sq.prioritize.queue.js.move.alert1.txt"));
     return;
   }

   if((dir == 'down' || dir=='bottom') && _highlightedRow.rowIndex == numRows-1)
   {
     alert($i18n("fcm.sq.prioritize.queue.js.move.alert2.txt"));
     return;
   }

   // used for index into _strategyList array
   srcRowIndex = _highlightedRow.rowIndex - startIndex;

   // internally the index is 0-based, but the rowIndex is 1-based
   curPos = _highlightedRow.rowIndex ;

   if     (dir == 'up'  ) newPos = curPos - amt;
   else if(dir == 'down') newPos = curPos + amt;
   else if(dir == 'top' ) newPos = startIndex;
   else   /* bottom */    newPos = numRows - 1;

   if(newPos < startIndex) newPos = startIndex;
   if(newPos > numRows -1) newPos = numRows - 1;

   newRow = moveRow(tbody,curPos,newPos);

   // used for index into _strategyList array
   tgtRowIndex = newRow.rowIndex - startIndex ;

   swapItemPriority(srcRowIndex,tgtRowIndex);

   swapItemLocation(srcRowIndex, tgtRowIndex);

   highlightRow(newRow,classNameValue);

   _itemPriorityUpdated = isItemPriorityUpdated();
   //showItemPriorityList();

}

function showItemPriorityList()
{
   list = "";
   for(i = 0; i < _itemPriorityList.length; i++)
   {
      obj = _itemPriorityList[i];
      list += "{id="+obj.id+",op="+obj.priority+",np="+obj.newPriority+"}\n";
   }
   alert(list);
}

function isItemPriorityUpdated(){
   for(i = 0; i < _itemPriorityList.length; i++)
   {
      obj = _itemPriorityList[i];
      if(obj.priority != obj.newPriority) return true;
   }

   return false;
}


function swapItemPriority(srcRowIndex, tgtRowIndex){

   if(srcRowIndex > tgtRowIndex)
   {//moved up
      pri = _itemPriorityList[tgtRowIndex].newPriority;
      for(i = tgtRowIndex; i < srcRowIndex; i++)
      {
         _itemPriorityList[i].newPriority = _itemPriorityList[i+1].newPriority;
      }
      _itemPriorityList[srcRowIndex].newPriority = pri;
   }
   else
   {//moved down
      pri = _itemPriorityList[tgtRowIndex].newPriority;
      for(i = tgtRowIndex; i > srcRowIndex; i--)
      {
         _itemPriorityList[i].newPriority = _itemPriorityList[i-1].newPriority;
      }
      _itemPriorityList[srcRowIndex].newPriority = pri;
   }

}

function swapItemLocation(srcRowIndex, tgtRowIndex){

  if(srcRowIndex > tgtRowIndex)
  {//moved up
      src = _itemPriorityList[srcRowIndex];
      for(i = srcRowIndex; i > tgtRowIndex; i--)
      {
         _itemPriorityList[i] = _itemPriorityList[i-1];
      }
      _itemPriorityList[tgtRowIndex] = src;
   }
   else
   {//moved down
      src = _itemPriorityList[srcRowIndex];
      for(i = srcRowIndex; i < tgtRowIndex; i++)
      {
         _itemPriorityList[i] = _itemPriorityList[i+1];
      }
      _itemPriorityList[tgtRowIndex] = src;
   }

}

//"Freeze" the table headers so that they are always visible
function repositionTHs(elem) {
	$(elem).find("th").css("top", elem.scrollTop + "px");
}

// add priority changes to the form
function addNewPriorities (formElem) {
	for (var i = 0, j=0; i < _itemPriorityList.length; i++)
	{
		obj = _itemPriorityList[i];
		// don't pass loaded queue in
		if(obj.priority != obj.newPriority)
		{	
			// A new priority
			ele = document.createElement("input");
			ele.type = "hidden";
			ele.name = "priorities[" + j + "].id";
			ele.value = obj.id; 
			formElem.appendChild(ele);
			 
			ele = document.createElement("input");
			ele.type = "hidden";
			ele.name = "priorities[" + j + "].version";
			ele.value = obj.version;
			formElem.appendChild(ele);
			 
			ele = document.createElement("input");
			ele.type = "hidden";
			ele.name = "priorities[" + j + "].priority";
			ele.value = obj.newPriority;
			formElem.appendChild(ele);
			 
			j++;
		}
	}
}