
function submitBusinessUnitForm(formObj)
{
   if(!validateName(formObj.name.value))
   {
      alert($i18n("fcm.groups.js.submitBusinessUnitForm.alert0.txt"));
      formObj.name.select();
      formObj.name.focus();
      return false;
   }

   if(!validateDescriptionLength(formObj.desc.value, 100))
   {
      alert($i18n("fcm.groups.js.submitBusinessUnitForm.alert1.txt"));
      formObj.desc.select();
      formObj.desc.focus();
      return false;
   }
   // Add users in assigned listbox to hidden form elements
         $("#assignedUsersId option").each(function(){
      	   $("form").append('<input type="hidden" name="assignedUsers" value="'+this.value+'"/>');
	});

   setBusyDetail();
}
function submitGroupForm(formObj)
{
   if(!validateName(formObj.name.value))
   {
      alert($i18n("fcm.groups.js.submitGroupForm.alert0.txt"));
      formObj.name.select();
      formObj.name.focus();
      return false;
   }

   if(!validateDescriptionLength(formObj.desc.value, 100))
   {
      alert($i18n("fcm.groups.js.submitGroupForm.alert1.txt"));
      formObj.desc.select();
      formObj.desc.focus();
      return false;
   }

   setBusyDetail();
}

function submitTeamForm(formObj)
{
   if(!validateName(formObj.name.value))
   {
      alert($i18n("fcm.groups.js.submitTeamForm.alert0.txt"));
      formObj.name.select();
      formObj.name.focus();
      return false;
   }

   if(!validateDescriptionLength(formObj.desc.value, 100))
   {
      alert($i18n("fcm.groups.js.submitTeamForm.alert1.txt"));
      formObj.desc.select();
      formObj.desc.focus();
      return false;
   }
   // Add users in assigned listbox to hidden form elements
      $("#assignedUsersId option").each(function(){
   	   $("form").append('<input type="hidden" name="assignedUsers" value="'+this.value+'"/>');
	});

   setBusyDetail();
}

function doGroupAction(userAction)
{
 //alert("Inside group action: " + userAction);
  if(userAction=='getUsers')
  {
	  doGetUserAction(userAction);
  }
  else if(userAction=='getBusinessUnits')
  {
	  doGetBusinessUnitAction(userAction);
  }
  else if(userAction=='newBusinessUnit' || userAction == 'newGroup' || userAction == 'newTeam')
  {
      doNewAction(userAction);
  }
  else if(userAction == 'delete' )
  {
      doDeleteUnitAction(userAction);
  }
  else if(userAction == 'showDetail')
  {
      doModifyAction(userAction);
  }
  else if(userAction == 'saveBusinessUnit')
  {
      doSaveBusinessUnitAction(userAction);
  }
  else if(userAction == 'saveTeam')
  {
      doSaveTeamAction(userAction);
  }
  else if(userAction == 'saveGroup')
  {
      doSaveGroupAction(userAction);
  }
  else
  {
      alert($i18n("fcm.groups.js.doGroupAction.alert0.fmt.txt",[userAction]));
  }
}

function doSaveBusinessUnitAction(userAction)
{
	$("#businessUnitDefForm").submit();
}
function doSaveTeamAction(userAction)
{
       $("#teamForm").submit();
}

function doSaveGroupAction(userAction)
{
	$("#groupForm").submit();
}

function doGetUserAction(userAction)
{
	var action = 'listUserTree.action';
	$df.postURL("detail", action);
}

function doGetBusinessUnitAction(userAction)
{
	var action = "listBusinessUnits.action";
	$df.postURL("overview", action);
}

function doNewAction(userAction)
{
   var action = "";
   // var method = '';
   var groupId = '';
   var businessUnitId='';

   var MARKS = parent.frames['overview'].MARKS;

   setBusy();
   if(userAction=='newBusinessUnit'){
	   // method = 'method=createBusinessUnit';
	   action = 'createBusinessUnit.action';
   }
   else if(userAction == 'newGroup')
   {
             selectedNodes = parent.frames['overview']._businessUnitTree.getSelectedNodes();
              if(selectedNodes.length != 1 || !isDefined(selectedNodes[0].nodeId)
                 || selectedNodes[0].nodeId < 0 ||  selectedNodes[0].getMark() != MARKS[0])
              {
                 alert($i18n("fcm.groups.js.doNewAction.alert1.txt"));
                 return;
              }
              else
              {
                 var node = selectedNodes[0];
                 businessUnitId = '&businessUnitId=' +  parent.frames['overview']._businessUnitMap[node.nodeId].id;
              }
      // method = 'method=createGroup';
      action = 'createGroup.action';
   }
   else if(userAction == 'saveUnitAndCreateGroup')
   {
             selectedNodes = parent.frames['overview']._businessUnitTree.getSelectedNodes();
              if(selectedNodes.length != 1 || !isDefined(selectedNodes[0].nodeId)
                 || selectedNodes[0].nodeId < 0 ||  selectedNodes[0].getMark() != MARKS[0])
              {
                 alert($i18n("fcm.groups.js.doNewAction.alert1.txt"));
                 return;
              }
              else
              {
                 var node = selectedNodes[0];
                 businessUnitId = '&businessUnitId=' +  parent.frames['overview']._businessUnitMap[node.nodeId].id;
              }
      var msgKey = 'SaveCreateGroup';
      // method = 'method=createGroup';
	  action = 'createGroup.action';
      $("#businessUnitDefForm").submit();
   }
   else if(userAction == 'newTeam')
   {

       selectedNodes = parent.frames['overview']._businessUnitTree.getSelectedNodes();
        if(selectedNodes.length != 1 || !isDefined(selectedNodes[0].nodeId)
           || selectedNodes[0].nodeId < 0 ||  selectedNodes[0].getMark() != MARKS[1])
        {
           alert($i18n("fcm.groups.js.doNewAction.alert0.txt"));
           return;
        }
        else
        {
           var node = selectedNodes[0];
           groupId = '&groupId=' +  parent.frames['overview']._groupMap[node.nodeId].id;
           businessUnitId = '&businessUnitId=' +  parent.frames['overview']._groupMap[node.nodeId].businessUnit;

        }
	
		// method = 'method=createTeam';
      	action = "createTeam.action";
   }

   else if(userAction == 'saveGroupAndCreateTeam')
   {

       	selectedNodes = parent.frames['overview']._businessUnitTree.getSelectedNodes();
        if(selectedNodes.length != 1 || !isDefined(selectedNodes[0].nodeId)
           || selectedNodes[0].nodeId < 0 ||  selectedNodes[0].getMark() != MARKS[1])
        {
           alert($i18n("fcm.groups.js.doNewAction.alert0.txt"));
           return;
        }
        else
        {
           var node = selectedNodes[0];
           groupId = '&groupId=' +  parent.frames['overview']._groupMap[node.nodeId].id;
           businessUnitId = '&businessUnitId=' +  parent.frames['overview']._groupMap[node.nodeId].businessUnit;

        }
      var msgKey = 'SaveCreateTeam';
      // method = 'method=createTeam';
 	  action = 'createTeam.action';
      $("#groupForm").submit();
   }
   else if(userAction == 'createAnotherGroup')
   {
       selectedNodes = parent.frames['overview']._businessUnitTree.getSelectedNodes();
       var node = selectedNodes[0];

	   var groupId = '&groupId=' + parent.frames['detail'].document.getElementById("id").value;

	    var businessUnitId = '&businessUnitId=' + parent.frames['overview']._groupMap[node.nodeId].businessUnit;

	    // method = 'method=createGroup';
	    action = 'createGroup.action';
   }
   else if(userAction == 'createAnotherTeam')
   {
	   var groupId = '&groupId=' + parent.frames['detail'].document.getElementById("groupId").value;

	    var businessUnitId = '&businessUnitId=' + parent.frames['detail'].document.getElementById("businessUnit").value;

	    // method = 'method=createTeam';
      	action = "createTeam.action";
   }
   
   // var action = 'a_groups.sj?' + method + businessUnitId + groupId + '&__sfmrt=' + getCookie("__sfmrt");

	action += "?" + businessUnitId + groupId + '&__sfmrt=' + getCookie("__sfmrt");
	$df.postURL("overview", action);
}

function doDeleteUnitAction(userAction)
{
  var MARKS = parent.frames['overview'].MARKS;

  selectedNodes = parent.frames['overview']._businessUnitTree.getSelectedNodes();
  if(!isDefined(selectedNodes[0].nodeId) || selectedNodes.length != 1
     || selectedNodes[0].nodeId < 0)
  {
     alert($i18n("fcm.groups.js.doDeleteAction.alert0.txt"));
     return;
  }
  else
  {

     var node = selectedNodes[0];
     // alert(node.nodeId + "  " + node.title);
     var businessUnitMap = parent.frames["overview"]._businessUnitMap;
     var groupMap = parent.frames["overview"]._groupMap;

     if(node.getMark() == MARKS[0]){
     	//default business unit may not be deleted
     	if(businessUnitMap[node.nodeId].id==-1){
     		alert($i18n("fcm.groups.js.doDeleteAction.alert3.txt"));
     		return;
     	}
     	var hasBusinessUnits = parent.frames["overview"]._hasBusinessUnits;
     	if(isDefined(hasBusinessUnits[businessUnitMap[node.nodeId].id])){
     		alert($i18n("fcm.groups.js.doDeleteAction.alert2.txt"));
     		return;
     	}
     	else if(!confirm($i18n("fcm.groups.js.doDeleteAction.confirm1.txt")))
     	return;
     }
     else if(node.getMark() == MARKS[1]){
          	var hasGroups = parent.frames["overview"]._hasGroups;
          	if(isDefined(hasGroups[groupMap[node.nodeId].id])){
          		alert($i18n("fcm.groups.js.doDeleteAction.alert4.txt"));
          		return;
          	}
          	else if(!confirm($i18n("fcm.groups.js.doDeleteAction.confirm3.txt")))
          	return;
     }
     else if(!confirm($i18n("fcm.groups.js.doDeleteAction.confirm0.txt")))
        return;

     // var method = '';
     var action = "";
     var id = '';
     var version = '';
     var name = '';
     var groupName = '';
     var groupId = '';
     var businessUnitId = '';

     if(node.getMark() == MARKS[0])
     {

		 // method         += 'method=deleteBusinessUnit';
		 action 		+= "deleteBusinessUnit.action";
		 id             += 'id=' + businessUnitMap[node.nodeId].id;
		 version        += '&version=' + businessUnitMap[node.nodeId].version;
         name           += '&name=' + businessUnitMap[node.nodeId].name;
     }
     else if(node.getMark() == MARKS[1])
     {
         var groupMap = parent.frames["overview"]._groupMap;
         // method         += 'method=deleteGroup';
		 action 		+= "deleteGroup.action";
         id             += 'id=' + groupMap[node.nodeId].id;
         version        += '&version=' + groupMap[node.nodeId].version;
         name           += '&name=' + groupMap[node.nodeId].name;
         businessUnitId += '&businessUnit='+groupMap[node.nodeId].businessUnit;
     }
     else if(node.getMark() == MARKS[2])
     {
         var teamMap = parent.frames["overview"]._teamMap;
         // method         += 'method=deleteTeam';
 	 	 action 		+= "deleteTeam.action";
         id             += 'id=' + teamMap[node.nodeId].id;
         version        += '&version=' + teamMap[node.nodeId].version;
         name           += '&name=' + teamMap[node.nodeId].name;
         groupName      += '&groupName=' + teamMap[node.nodeId].groupName;
         groupId        += '&groupId=' + teamMap[node.nodeId].groupId;
         businessUnitId += '&businessUnit='+teamMap[node.nodeId].businessUnit;
     }
     else
     {
         alert($i18n("fcm.groups.js.doDeleteAction.alert1.txt"));
     }
	 //     var action = 'a_groups.sj?' + method + id + version + name + groupName + groupId + businessUnitId + '&__sfmrt=' + getCookie("__sfmrt");
	 action += "?" + id + version + name + groupName + groupId + businessUnitId + '&__sfmrt=' + getCookie("__sfmrt");
     
     var nextNode = parent.frames["overview"]._businessUnitTree.getNextSibling(node);
     if ( nextNode == null )
    	 nextNode = parent.frames["overview"]._businessUnitTree.getPreviousSibling(node);
	 setCookieForTab(nextNode ? nextNode.nodeId : node.parentId);

     //removeCookie('fam_mod_groups',node.nodeId);
     //frames[ "overview" ].location.href = action;
     $df.postURL("overview", action);
   }
}

// The frame semantics are a little different
// since this is invoked from the overview frame
function doModifyAction(userAction)
{
	  var MARKS = parent.frames['overview'].MARKS;

	  //selectedNodes = _groupTree.getSelectedNodes();
  selectedNodes = _businessUnitTree.getSelectedNodes();
  if(selectedNodes.length != 1)
  {
	parent.sas.fscf.getCurrentDetailToolbar().removeAllContent();
    parent.frames[ "detail" ].location.href = 'common/blank.html';
    return;
  }
  var node = selectedNodes[0];
  setCookieForTab(node.getId());
  // var method = '';
  var action = '';
  var id = '';
  var version = '';
  var name = '';
  var groupName = '';
  var action;
  if(node.getMark() == MARKS[0]){
  	var businessUnitMap = _businessUnitMap;
        // method       += 'method=modifyBusinessUnit';
        action			+= "modifyBusinessUnit.action";
        id             	+= 'id=' + businessUnitMap[node.nodeId].id;
    	parent.sas.fscf.getCurrentDetailToolbar().setContentFor('businessUnit', parent.frames["overview"]._canModify, false, _canNewGroup);

  }
  else if(node.getMark() == MARKS[1])
  {
      var groupMap = _groupMap;
      // method         += 'method=modifyGroup';
      action			+="modifyGroup.action";
      id            	+= 'id=' + groupMap[node.nodeId].id;
      // alert(id);
   	  var hasGroups = parent.frames["overview"]._hasGroups;
      parent.sas.fscf.getCurrentDetailToolbar().setContentFor('group', parent.frames["overview"]._canModify, !isDefined(hasGroups[groupMap[node.nodeId].id]));
  }
  else if(node.getMark() == MARKS[2])
  {
      var teamMap = _teamMap;
      // method         += 'method=modifyTeam';
      action			+="modifyTeam.action";
      id             	+= 'id=' + teamMap[node.nodeId].id;
      parent.sas.fscf.getCurrentDetailToolbar().setContentFor('team', parent.frames["overview"]._canModify, true);
  }
  else
  {
      alert($i18n("fcm.groups.js.doModifyAction.alert0.txt"));
  }
  
  // var  	action = 'a_groups.sj?' + method + id;
  action += "?" + id;

  // alert(action);
  setBusyDetail();
  parent.frames[ "detail" ].location.href = action;
}

// Reset selection on the listbox which was previously selected
// E.g. if the user picked an option on the right listbox the left side
// selection is cleared
function resetSelectionAndDesc(listBoxToReset)
{
   listBoxToReset.selectedIndex = -1;
   hideDescription();
}


// descriptions are lazy loaded from the overview frame
var _descriptionsLoaded = false;
function showDescriptionLocal(anchor, srcArrayListName )
{
   // Load descriptions the first time
   // the selected list could be either from unassigned or assigned users
   // try them both
   loadDescriptions();
   var assignedUsers = document.getElementById('assignedUsers');
   showDescription(anchor, srcArrayListName, assignedUsers);
   var unassignedUsers = document.getElementById('unassignedUsers');
   showDescription(anchor, srcArrayListName, unassignedUsers);

}

function loadDescriptions()
{
   if(_descriptionsLoaded)
      return;
   for(var i=0; i < _users.length; i++)
   {
      var user = _users[i];
      if(user.teamId != '')
      {
         var teamNodeId = parent.frames["overview"]._teamNodeMap[user.teamId];
         var userTeam = parent.frames["overview"]._teamMap[teamNodeId];
         if(isDefined(userTeam))
         {
            user.text += " Member of the " + userTeam.groupName + " - " + userTeam.name;
            // user.text = "Member of " + userTeam.name;
         }
         else
         {
            user.text += ' Not a member of any group/team';
         }
      }
      else
      {
         user.teamId = '';
         user.text += ' Not a member of any group/team';
      }
    }
    _descriptionsLoaded = true;
}

