function indexedFieldPrefix(index) {
	return "caseMgtEvents[" + index + "]."; 
}

function doSubmitCaseMgtEventsForm()
{
	$("#caseMgtEventsForm").submit();
}

function saveCaseMgtEventsForm( cmeForm )
{
	//check names: not empty and unique
	if (! validateCaseMgtEventsNames())
		return false;

	setBusy();
	return true;
}

function validateCaseMgtEventsNames() {
	var retVal = true;
	$("#caseMgtEventsTableBody :text[name$='eventName']:enabled").each( function () {
		var name = trim( $(this).val() );
		$(this).val(name);
		if (name.length == 0) {
			retVal = false;
	        alert($i18n("fcm.preferences.caseMgtEvents.js.validateCaseMgtEvents.alert0.txt"));
			$(this).select().focus();
			return false;
		}
	});
	return retVal;
}

function populateCaseMgtEvents()
{
	var count = 0;
	for (var i=0; i<cmEvents.length; i++)
	{
		var cme = cmEvents[i];

    	$("#caseMgtEventsTableBody").append($("#cmeTemplateCOMMON").children(0).html().replace(/_CRID_/g, cme.id).replace(/_INDEX_/g, i));
        count++;
        initializeCMESection(i, count);    // sortOrder -->count
	}
}

function initializeCMESection(index, count)
{
	var cme = cmEvents[index];

	var ids = "" + cme.id;
	var idp =  indexedFieldPrefix(index);

	var section = $("#cmEvent" + cme.id);
	if (count % 2 == 0 )
		$(section).attr("class", "dataRow2_tableRow");

	$(section).find("#count" + ids).append(count);
	$(section).find("#callResultName" + ids).append(cme.callResult);

	$(section).find("input[name='" + idp + "id']")[0].value = cme.id;
	$(section).find("input[name='" + idp + "version']")[0].value = cme.version;
	$(section).find("input[name='" + idp + "eventType']")[0].value = cme.eventType;

	$(section).find(":checkbox[name='" + idp + "sendEcm']")[0].checked = cme.sendEcm;
	$(section).find(":checkbox[name='" + idp + "sendEcm']")[0].value = chkbValue(cme.sendEcm);

	if (cme.sendEcm){
		$(section).find(":checkbox[name='" + idp + "sendAction']")[0].disabled = false;
		$(section).find(":checkbox[name='" + idp + "sendTran']")[0].disabled = false;

		$(section).find(":checkbox[name='" + idp + "sendAction']")[0].checked = cme.sendAction;
		$(section).find(":checkbox[name='" + idp + "sendAction']")[0].value = chkbValue(cme.sendAction);

		$(section).find(":checkbox[name='" + idp + "sendTran']")[0].checked = cme.sendTran;
		$(section).find(":checkbox[name='" + idp + "sendTran']")[0].value = chkbValue(cme.sendTran);
	}else {
		$(section).find(":checkbox[name='" + idp + "sendAction']")[0].disabled = true;
		$(section).find(":checkbox[name='" + idp + "sendTran']")[0].disabled = true;

		$(section).find(":checkbox[name='" + idp + "sendAction']")[0].checked = false;
		$(section).find(":checkbox[name='" + idp + "sendAction']")[0].value = 0;

		$(section).find(":checkbox[name='" + idp + "sendTran']")[0].checked = false;
		$(section).find(":checkbox[name='" + idp + "sendTran']")[0].value = 0;
	}

	$(section).find(":checkbox[name='" + idp + "sendEcm']").click(function (){
		$(":checkbox[name='" + idp + "sendEcm']")[0].value = chkbValue($(this).prop("checked"));

		if (!$(this).prop("checked")){
			$(":checkbox[name='" + idp + "sendAction']")[0].checked = false;
			$(":checkbox[name='" + idp + "sendAction']")[0].value = 0;

			$(":checkbox[name='" + idp + "sendTran']")[0].checked = false;
			$(":checkbox[name='" + idp + "sendTran']")[0].value = 0;
		}

		$(":checkbox[name='" + idp + "sendAction']")[0].disabled = ! $(this).prop("checked");
	    $(":checkbox[name='" + idp + "sendTran']")[0].disabled = ! $(this).prop("checked");
	});

	$(section).find(":checkbox[name='" + idp + "sendAction']").click(function (){

		$(":checkbox[name='" + idp + "sendAction']")[0].value = chkbValue($(this).prop("checked"));
	});

	$(section).find(":checkbox[name='" + idp + "sendTran']").click(function (){

		$(":checkbox[name='" + idp + "sendTran']")[0].value = chkbValue($(this).prop("checked"));
	});

	if (cme.eventType == "CHECKOUT" || cme.eventType == "CHECKIN" && !cme.callResult){
        $(section).find("input[name='" + idp + "eventName']").val(cme.eventName).prop("readOnly", true).css("background-color", "#e0e2e5"); // RAPTOR-2399
	} else {
	    $(section).find("input[name='" + idp + "eventName']").val(cme.eventName);
	}
}

function chkbValue(bool){
	if(bool)
		return 1;
	return 0;
}

function chkbValue2(el){
	if(el.is(':checked'))
		return 1;
	return 0;
}

function isInteger(valueStr)
{
    if(valueStr.length > 0 && valueStr.indexOf('.') < 0 && !isNaN(valueStr))
    {
    	return !isNaN(parseInt(valueStr));
    }
    return false;
}

function trim(txt)
{
	if (txt)
		return txt.replace(/^\s+/g, '').replace(/\s+$/g, '');
	else
		return "";
}