// external variable 
// var newCRIndex = 1;

const NewCRPrefix = "NEW_";

// returns the prefix of indexed fields of a call result 
function indexedFieldPrefix(index) {
	return "callResults[" + index + "]."; 
}

function doSubmitCallResultsForm()
{
	$("#callResultsForm").submit();
}

function saveCallResultsForm( crForm )
{
	//check names: not empty and unique
	if (! validateCallResultNames())
		return false;

	//check auto close days: integer < 360
	if (! validateAutoCloseDays() )
		return false;

	//check amount and scores: integer or empty
	if (! validateAmountsAndScores() )
		return false;

	postNewCallResults(crForm);
	postResurfaceTimes(crForm);
	postTransactionBlocks(crForm);
	postSystemBlocks(crForm);

	setBusy();
	return true;
}

function validateCallResultNames() {
	var names =[];
	var retVal = true;
	$("#callResultsTableBody input[name$='callResult']").each( function () {
		var name = trim( $(this).val() );
		$(this).val(name);
		if (name.length == 0 || name == nameInstruction) {
			retVal = false;
	        alert($i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert0.txt"));
			$(this).select().focus();
			return false;
		}
		else if ( names[name] == 1 )
		{
			retVal = false;
			alert ( $i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert1.txt") );
			$(this).select().focus();
			return false;
		}
		names[name] = 1;
	});
	return retVal;
}

function validateAutoCloseDays() {
	var retVal = true;
	$("#callResultsTableBody :text[name$='autoClose']").each( function () {
        var valueStr = $(this).val();
        if(!isInteger(valueStr))
        {
			retVal = false;
            alert($i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert2.txt"));
            $(this).select().focus();
            return false;
        }

        // only allow values between 0 and 360
        var days = parseInt(valueStr);
        if(days < 0 || days > 360)
        {
			retVal = false;
            alert($i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert3.txt"));
            $(this).select().focus();
            return false;
        }
    });
	return retVal;
}

function validateAmountsAndScores()
{
	var retVal = true;
	$("#callResultsTableBody :text[name$='amount']:enabled").each( function () {
        var valueStr = trim($(this).val());
        if( valueStr.length > 0 && !isInteger(valueStr) )
        {
			retVal = false;
            var p = $(this).parents().filter("table[id^='additionalCRSection']")
            if ($(p).css("display") == "none" )
            	$(p).parent().find("[id^='additionalCRSectionTitleBar']").click();

            alert($i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert4.txt"));
            $(this).select().focus();
            return false;
        }
    });
	if (retVal == false) return false;

	$("#callResultsTableBody :text[name*='.score']:enabled").each( function () {
        var valueStr = trim($(this).val());
        if( valueStr.length > 0 && !isInteger(valueStr) )
        {
			retVal = false;
            var p = $(this).parents().filter("table[id^='additionalCRSection']")
            if ($(p).css("display") == "none" )
            	$(p).parent().find("[id^='additionalCRSectionTitleBar']").click();

            alert($i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert4.txt"));
            $(this).select().focus();
            return false;
        }
    });

	return retVal;
}

function postNewCallResults(formObj) 
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var ids = "" + cr.id;				
		if (!cr.isDeleted && ids.startsWith(NewCRPrefix))
		{
			var idp = indexedFieldPrefix(j);
			var elem = formObj.elements[idp + "id"];
			elem.value = -1;
		}
	}
}

function postResurfaceTimes(formObj) {
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);

		if (!cr.isDeleted && cr.typeUnknown)
		{
			var timeChk = formObj.elements[idp + "resurfaceAtTime"];
			if (timeChk.checked)
			{
				var timeOption = $(":radio[name='"+ idp + "timeOption']").filter(":checked");

				if (timeOption.length > 0)
				{
					// convert to minutes if unit is hour
					if (timeOption[0].value == "1") {
						var elem = formObj.elements[idp + "minutes"];
						var unit = formObj.elements[idp + "minutesUnit"];
						if (unit.value == "hr") {
							var minutes = parseInt(elem.value) * 60;
							elem.value= minutes;
							unit.disabled=true;
						}
					}
				}

			} // end time conversion

		}
	}
}


function postSystemBlocks(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);
		
		if (!cr.isDeleted)
		{
			var sysBlockChk=formObj.elements[idp + "applySystemBlock"];
			var elem = formObj.elements[idp + "systemBlocksStr"];
			var systemBlocksStr = "";

			if(sysBlockChk.checked)
			{
				for (var i =0; i < sysBlocksByCallResult[""+cr.id].length; i++)
				{
					if(sysBlocksByCallResult[""+cr.id][i].isAssigned)
					{
						systemBlocksStr += sysBlocksByCallResult[""+cr.id][i].id + ",";
					}
				}
				elem.value = systemBlocksStr.slice(0, -1);
				if(elem.value.length > 0) elem.disabled = false;
		    }
		}
	}
}


function postTransactionBlocks(formObj)
{
	for (var j=0; j< crs.length; j++)
	{
		var cr = crs[j];
		var idp = indexedFieldPrefix(j);

		if (!cr.isDeleted)
		{
			var transBlockChk=formObj.elements[idp + "applyTransactionBlock"];
			var elem = formObj.elements[idp + "transactionBlocksStr"];
			var transactionBlocksStr = "";

			if(transBlockChk.checked )
			{
				for (var i =0; i < txnBlocksByCallResult[""+cr.id].length; i++)
				{
					if(txnBlocksByCallResult[""+cr.id][i].isAssigned)
					{
						transactionBlocksStr += txnBlocksByCallResult[""+cr.id][i].id + ",";
					}
				}
				elem.value = transactionBlocksStr.slice(0, -1);
				if(elem.value.length > 0) elem.disabled = false;
			}
		}
	}
}



function populateCallResults()
{
	for (var i=0; i<crs.length; i++)
	{
		var cr = crs[i];

		$("#callResultsTableBody").append($("#crTemplateCOMMON").children(0).html().replace(/_CRID_/g, cr.id).replace(/_INDEX_/g, i));
		$("#additionalCRSectionContainer" + cr.id).append($("#crTemplate" + cr.type).html().replace(/_CRID_/g, cr.id).replace(/_INDEX_/g, i));
		$("#initCallResult" + cr.id)[0].click();
		var sortOrder = $("#callResultsTableBody")[0].rows.length / 2;
		initializeCRSection(i, sortOrder);
	}
}


function initializeCRSection(index, sortOrder)
{
	var cr = crs[index];
	var setting = crSettings[index];
	
	var ids = "" + cr.id;
	var idp = indexedFieldPrefix(index);

	var common = $("#callResult" + cr.id);
	var ext = $("#callResult" + cr.id + "Ext");

	// common settings
	$(common).find("input[name='" + idp + "id']")[0].value = cr.id;
	$(common).find("input[name='" + idp + "version']")[0].value = setting.version;
	$(common).find("input[name='" + idp + "type']")[0].value = cr.type;
	$(common).find("input[name='" + idp + "type']").after(callResultTypes[cr.type].label);
	$(common).find("input[name='" + idp + "autoClose']")[0].value = setting.autoClose;

	$(common).find(":checkbox[name='" + idp + "newQueueDefault']")[0].checked = setting.newQueueDefault;
	$(common).find(":radio[name='" + idp + "status'][value='" + setting.status +"']")[0].click();

	$(common).find("input[name='" + idp + "callResult']").val(cr.name).change(function (event) {
		if ( !isUniqueName ($(this).val()) ) {
			event.stopPropagation();
			alert ( $i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert1.txt") );
			$(this).css("background-color", "yellow");
		} else if ($(this).css("background-color") == "yellow")
			$(this).css("background-color", "");
	});

	$(common).find("input[name='" + idp + "sortOrder']").val(setting.sortOrder).change(function () {
		crRow = $("#callResult" + ids);
		nextPos = $(this).val();
		if (!isInteger(nextPos)) {
			$(this).val($(crRow).index() / 2 + 1);
			return;
		}
		nextPos = nextPos * 2 - 1;
		moveCallResultRow(nextPos, crRow);
	});

	// enable delete button if no references by queue and alert
	var usage = crUsageCounts[ids];
	if ( (usage.alertCount + usage.queueCount) == 0 )
	{
		//can be deleted
		$(common).find("#delete" + ids).attr("src", "admin/images/DeleteRed.gif").click(function () {
			if (confirm ( $i18n("fcm.preferences.callResults.js.deleteCallResult.msg.txt") ) ) {
				$("#callResult" + ids + "Ext").remove(); $("#callResult" + ids).remove();
				ctrl = $("input[name='deletions']");
				if ($(ctrl).val().length > 0)
					$(ctrl).val( $(ctrl).val()+ "," + ids );
				else 
					$(ctrl).val( ids );
				for (var i=0; i<crs.length; i++)
					if (crs[i].id == ids) { crs[i].isDeleted = true; break; }
				updateSortOrders();
			}
		});
	}
	else
	{
		// make name readonly if referenced by a queue
		if (usage.queueCount > 0)
		{
			$(common).find("input[name='" + idp + "callResult']").attr("readOnly", true).css("background-color", "#e0e2e5");
		}

		//cannot be deleted, show the usage info
		$(common).find("#info" + ids).css("display", "").mouseover(function(event){
			var usage = crUsageCounts[ids];
			var infoText = $i18n("fcm.preferences.callResults.js.info.summary.fmt.txt", [usage.alertCount, usage.queueCount, usage.strategyCount]) + "<br/><br/>";
			if (usage.queueCount > 0)
			{
				infoText += $i18n("fcm.preferences.callResults.js.info.details.header.txt");
				var detailsText = "";
				for (var i=0; i < usage.details.length; i++ )
					detailsText += "<li>" + usage.details[i].businessUnitName + " > " + usage.details[i].strategyName + " > " + usage.details[i].queueName + "</li>\n";
				$("#infoPop > ul").html(detailsText);
			}
			$("#infoPop > div").html(infoText);
			var availHeight = $(window).height() - event.pageY;
			var yposOffset =  $("#infoPop").outerHeight() - availHeight;
			var ypos = event.pageY - yposOffset - 10;
			if (yposOffset < 0 ){
				$("#infoPop").css("top",event.pageY).css("left",event.pageX).css("display", "block");
			} else {
				$("#infoPop").css("top",ypos).css("left",event.pageX).css("display", "block");
			}
			// alert("availHeight: " + event.pageY + " : " + $("#infoPop").outerHeight() + " : " + yposOffset + " : " + ypos);
		}).mouseout(function(){
			$("#infoPop").css("display", "none");
		});
	}

	// extended settings

	// block codes
	loadListboxByAssignment(txnBlocksByCallResult[ids], "availableTransactionBlocksContainer" + cr.id, false);
	loadListboxByAssignment(txnBlocksByCallResult[ids], "selectedTransactionBlocksContainer" + cr.id, true);

	loadListboxByAssignment(sysBlocksByCallResult[ids], "availableSystemBlocksContainer" + cr.id, false);
	loadListboxByAssignment(sysBlocksByCallResult[ids], "selectedSystemBlocksContainer" + cr.id, true);

	if (setting.applyTransactionBlock)
		$(ext).find("input[name='" + idp + "applyTransactionBlock']")[0].click();
	if (setting.applySystemBlock)
		$(ext).find("input[name='" + idp + "applySystemBlock']")[0].click();
	$(ext).find("input[name='" + idp + "removeTransactionBlock']")[0].checked = setting.removeTransactionBlock;
	$(ext).find("input[name='" + idp + "removeSystemBlock']")[0].checked = setting.removeSystemBlock;

	if (cr.typeUnknown)
	{
		// reroute
		if (setting.allowRerouteToEnabled)
			$(ext).find("input[name='" + idp + "allowRerouteToEnabled']")[0].click();

		// time based criteria

		if (setting.immediatelyEnabled || setting.minutesEnabled || setting.nextDayEnabled || setting.timestampEnabled )
			$(ext).find("input[name='" + idp + "resurfaceAtTime']")[0].click();

		if (setting.immediatelyEnabled )
			$(ext).find("input[name='" + idp + "timeOption'][value='0']")[0].click();

		if (setting.minutesEnabled )
		{
			$(ext).find("input[name='" + idp + "timeOption'][value='1']")[0].click();
			if(setting.minutes > 59){
				$(ext).find("input[name='" + idp + "minutes']")[0].value = setting.minutes/60;
				$(ext).find("select[name='" + idp + "minutesUnit']")[0].selectedIndex = 1; // hours
			}
			else{
				$(ext).find("input[name='" + idp + "minutes']")[0].value = setting.minutes;
				$(ext).find("select[name='" + idp + "minutesUnit']")[0].selectedIndex = 0; // hours
			}
		}
		if (setting.nextDayEnabled )
			$(ext).find("input[name='" + idp + "timeOption'][value='2']")[0].click();
		if (setting.timestampEnabled )
			$(ext).find("input[name='" + idp + "timeOption'][value='3']")[0].click();
	}

	if (cr.typeUnknown || cr.typePositive )
	{
		// transaction based criteria

		if (setting.anyScoreIncreaseEnabled || setting.anyScoreEnabled || setting.amountEnabled )
			$(ext).find("input[name='" + idp + "resurfaceWhenTrans']")[0].click();

		if (setting.anyScoreIncreaseEnabled)
		{
			$(ext).find("input[name='" + idp + "scoreIncreaseEnabled']")[0].click();
			if (setting.score1Increase != null)
				$(ext).find("input[name='" + idp + "score1Increase']")[0].value = setting.score1Increase;
			if (setting.score2Increase != null)
				$(ext).find("input[name='" + idp + "score2Increase']")[0].value = setting.score2Increase;
			if (setting.score3Increase != null)
				$(ext).find("input[name='" + idp + "score3Increase']")[0].value = setting.score3Increase;
			if (setting.score4Increase != null)
				$(ext).find("input[name='" + idp + "score4Increase']")[0].value = setting.score4Increase;
		}
		if (setting.anyScoreEnabled)
		{
			$(ext).find("input[name='" + idp + "scoreEnabled']")[0].click();
			if (setting.score1 != null)
				$(ext).find("input[name='" + idp + "score1']")[0].value = setting.score1;
			if (setting.score2 != null)
				$(ext).find("input[name='" + idp + "score2']")[0].value = setting.score2;
			if (setting.score3 != null)
				$(ext).find("input[name='" + idp + "score3']")[0].value = setting.score3;
			if (setting.score4 != null)
				$(ext).find("input[name='" + idp + "score4']")[0].value = setting.score4;
		}

		if (setting.amountEnabled)
		{
			$(ext).find("input[name='" + idp + "amountEnabled']")[0].click();
			if (setting.amount != null)
				$(ext).find("input[name='" + idp + "amount']")[0].value = setting.amount;
		}
	}
}

function createCallResult(ctrl)
{
	if ( ctrl.selectedIndex > 0 )
	{
		var crType = callResultTypes[ctrl.value];

		var cr = { id: NewCRPrefix + newCRIndex++,
				type: crType.type,
				name: nameInstruction,
				typeUnknown: crType.typeUnknown,
				typePositive: crType.typePositive,
				typeNegative: crType.typeNegative,
				isDeleted: false
			};
			
		var index = crs.push(cr) - 1; // append the new at the end
		$("#callResultsTableBody").append($("#crTemplateCOMMON").children(0).html().replace(/_CRID_/g, cr.id).replace(/_INDEX_/g, index));
		$("#additionalCRSectionContainer" + cr.id).append($("#crTemplate" + ctrl.value).html().replace(/_CRID_/g, cr.id).replace(/_CRID_/g, cr.id).replace(/_INDEX_/g, index));
		$("#initCallResult" + cr.id)[0].click();

		var sortOrder = $("#callResultsTableBody")[0].rows.length / 2;
		setDefaultCRSection(index, crType, sortOrder);

		// reset selection
		ctrl.selectedIndex = 0;
	}
}

function setDefaultCRSection(index, crType, sortOrder)
{
	var cr = crs[index];
	
	var ids = "" + cr.id;
	var idp = indexedFieldPrefix(index);

	var common = $("#callResult" + cr.id);

	// common
	$(common).find("input[name='" + idp + "id']")[0].value = cr.id;
	$(common).find("input[name='" + idp + "version']")[0].value = 0;
	$(common).find("input[name='" + idp + "autoClose']")[0].value = crType.autoCloseDefault;
	$(common).find(":checkbox[name='" + idp + "newQueueDefault']")[0].checked = true;
	$(common).find(":radio[name='" + idp + "status'][value='INACTIVE']")[0].click();
	$(common).find("input[name='" + idp + "type']")[0].value = crType.type;
	$(common).find("input[name='" + idp + "type']").after(crType.label);

	$(common).find("input[name='" + idp + "callResult']").val(cr.name).change(function (event) {
		if ( !isUniqueName ($(this).val()) ) {
			event.stopPropagation();
			alert ( $i18n("fcm.preferences.callResults.js.validateCallResultSettings.alert1.txt") );
			$(this).css("background-color", "yellow");
		} else if ($(this).css("background-color") == "yellow")
			$(this).css("background-color", "");
	});

	$(common).find("input[name='" + idp + "sortOrder']").val(sortOrder).change(function () {
		crRow = $("#callResult" + ids);
		nextPos = $(this).val();
		if (!isInteger(nextPos)) {
			$(this).val($(crRow).index() / 2 + 1);
			return;
		}
		nextPos = nextPos * 2 - 1;
		moveCallResultRow(nextPos, crRow);
	});

	// delete button
	$(common).find("#delete" + ids).attr("src", "admin/images/DeleteRed.gif").click(function () {
			$("#callResult" + ids + "Ext").remove(); $("#callResult" + ids).remove();
			for (var i=crs.length-1; i>=0; i--)
				if (crs[i].id == ids) {
					crs[i].isDeleted = true; 
					// crs.splice(i, 1); 
					break; 
				}
			updateSortOrders();
		});

	// block codes
	txnBlocksByCallResult[ids] = copy(txnBlocks);
	sysBlocksByCallResult[ids] = copy(sysBlocks);
	loadListboxByAssignment(txnBlocksByCallResult[ids], "availableTransactionBlocksContainer" + cr.id, false);
	loadListboxByAssignment(sysBlocksByCallResult[ids], "availableSystemBlocksContainer" + cr.id, false);

	$(common).find("input[name='" + idp + "callResult']").select().focus();
}

function isUniqueName ( name )
{
	name = trim(name);
	var matchCount = 0;
	$("#callResultsTableBody input[name^='callResult']").each( function () {
		if (trim($(this).val()) == name)
			matchCount++;
	});
	return (matchCount <= 1);
}


function moveCallResultRow(nextPos, crRow)
{
	crExtRow = $(crRow).next();
	children = $(crRow).parent().children();

	currPos = $(crRow).index()+ 1;
	total = $(children).length;
	if (nextPos <= 0) nextPos = 1;
	else if (nextPos >= total) nextPos = total -1;
	delta = nextPos - currPos;
//	alert(nextPos + ":" + currPos + ":" + total);

	if (delta == 0 ) return;

	if (delta > 0) {
		$(children).filter(":eq(" + nextPos +")").after($(crRow));
	}else{
		$(children).filter(":eq(" + (nextPos - 1) +")").before($(crRow));
	}
	$(crRow).after($(crExtRow));
	updateSortOrders();
}

function updateSortOrders()
{
	$("#callResultsTableBody :text[name$='sortOrder']").each(function (index) {$(this).val(index+1)});
}

function copy(obj)
{
	return $.extend(true, (obj instanceof Array ? [] : {}), obj);
}


function enableElements(crIndex,elemNameList,isDisabled)
{
	for (var i = 0; i < elemNameList.length; i++)
	{
		var idp = indexedFieldPrefix(crIndex);
		
		var elem = document.callResultsForm.elements[idp + elemNameList[i]];

		if(isDefined(elem))
		{
			// array elements, but not a "select"
			if (elem.length && !isDefined(elem.type))
			{
				for (var j = 0; j < elem.length; j++)
					enableElement(elem[j], isDisabled);
			}
			else
			{
				enableElement(elem, isDisabled)
			}
		}
	}
}

function enableElement(elem, isDisabled)
{
	if(elem.checked) elem.click();
	if(isDefined(isDisabled)){
		elem.disabled = isDisabled;
	}
}

function showHideBlock(divName){
	if(document.getElementById(divName).style.display=='none') {
		document.getElementById(divName).style.display='inline';
	}
	else {
		document.getElementById(divName).style.display='none';
	}
}

function isInteger(valueStr)
{
    if(valueStr.length > 0 && valueStr.indexOf('.') < 0 && !isNaN(valueStr))
    {
    	return !isNaN(parseInt(valueStr));
    }
    return false;
}


function trim(txt)
{
	if (txt)
		return txt.replace(/^\s+/g, '').replace(/\s+$/g, '');
	else
		return "";
}