var _moveAllFlag = false;
var _domObjReferences = new Object();
var _strategyOptions = new Array();
var fcmAlertDetailView = null;

function loadPageElements() {
	loadDomReferences();
	configureStatusBar();
	populateListBoxes();
	populateCheckboxesFromHiddenField(5);
	displayAlertSelections();
	loadDynamicElements();
	localizeLabels();
	return true;
}
// ==========================================================================
// FUNCTION: populateCheckboxesFromHiddenField()
// DESCRIPTION:  This function cycles through all checkbox objects and
//    tries to match a substring of the checkbox name to the hidden field
//    value.  If found, the checkbox is checked.  This is typically executed
//    on a body tag's onload method.
// PARAMETERS:
//    (1) startIdx:   Starting index for substring of checkbox name where
//                    the alert ID and version info.
//    (2) hiddenFieldName: Name of hidden field to populate
//        - the hidden field stores its selections in the format
//          #alertId_alertVersion#.  All selections are comma-separated.
//		(3) formName: 			Name of HTML form
// ==========================================================================
function populateCheckboxesFromHiddenField(startIdx) {
	var formElements = _domObjReferences.form_adminForm.elements;
	var checkedItems = _domObjReferences.hidden_alertSelections.value;
	if(checkedItems.length > 0) {
		for(jj=0; jj<formElements.length; jj++) {
			if(formElements[jj].type == "checkbox") {
				var nameToSearch = '#' + formElements[jj].id.substring(startIdx) + '#';
				var rx = new RegExp(nameToSearch,'g');
				if(checkedItems.match(rx)) {
					formElements[jj].checked = true;
				}
			}
		}
	}
	return true;
}

// ==========================================================================
//
//
// ==========================================================================
function addOrRemoveItem(chkBoxId,startIdx) {
	var chkBoxObject = document.getElementById(chkBoxId);
	var previouslySelectedItems = _domObjReferences.hidden_alertSelections.value;
	var itemArray = new Array();
	var nameToSearch = '#' + chkBoxObject.id.substring(startIdx) + '#';
	if(chkBoxObject.checked) {
		if(previouslySelectedItems.indexOf(nameToSearch) == -1) {
			if(previouslySelectedItems.length == 0) {
				previouslySelectedItems += nameToSearch;
				_domObjReferences.hidden_alertSelections.value = previouslySelectedItems;
			}
			else {
				itemArray = previouslySelectedItems.split(',');
				itemArray[itemArray.length] = nameToSearch;
				_domObjReferences.hidden_alertSelections.value = itemArray.join();
			}
		}
		else {
			// Nothing to do...item already in list of selected items.
		}
	} // <<END: chkbox selected>>
	else {
	// --------------------------------------------------------------------------
	//	The following code takes the comma-separated string of selected items and
	//   (i) removes the comma,
	//   (ii) removes the item that was unchecked, and
	//   (iii) replaces the comma delimiter
	// --------------------------------------------------------------------------
		var juxtElementsNoComma = '##';
		var removeItemStr = '';
		var juxtElementsWithComma = '#,#';
		var rx1 = new RegExp(juxtElementsWithComma,'g');
		var rx2 = new RegExp(nameToSearch,'g');
		var rx3 = new RegExp(juxtElementsNoComma,'g');
		var result = previouslySelectedItems.replace(rx1,juxtElementsNoComma).replace(rx2,removeItemStr).replace(rx3,juxtElementsWithComma);
		_domObjReferences.hidden_alertSelections.value = result;
	} // <<END: chkbox not selected>>

	return true;
}

function verifyMove() {
	var adminForm = document.getElementById('alertAdminForm');
	var moveDialog = document.getElementById('moveDialog');
	errorMsg = getTargetQueueSelectionMsg();
	if(_moveAllFlag) {
		if(errorMsg == "") {
			if(confirm($i18n("fcm.alert.alertAdmin.js.verifyMove.confirm0.txt"))) {
				_domObjReferences.form_adminForm.method.value='moveall';
				_domObjReferences.form_adminForm.action='moveAllAlerts.action';
				moveDialog.style.visibility = 'hidden';
				setBusy();
				_domObjReferences.form_adminForm.submit();
			}
			return;
		}
	}
	else {
		errorMsg += getAlertSelectionsMsg();
		if(errorMsg == "") {
			if(confirm($i18n("fcm.alert.alertAdmin.js.verifyMove.confirm1.txt"))) {
				_domObjReferences.form_adminForm.method.value='move';
				_domObjReferences.form_adminForm.action='moveAlerts.action';
				moveDialog.style.visibility = 'hidden';
				setBusy();
				_domObjReferences.form_adminForm.submit();
			}
			return;
		}
	}
	alert($i18n("fcm.alert.alertAdmin.js.verifyMove.alert0.fmt.txt", [errorMsg]));
	return;
}

function verifyCloseAlerts(closeAllFlag) {
	if(closeAllFlag) {
		if(confirm($i18n("fcm.alert.alertAdmin.js.verifyCloseAlerts.confirm0.txt"))) {
			_domObjReferences.form_adminForm.method.value='closeall';
			_domObjReferences.form_adminForm.action='closeAllAlerts.action';
			setBusy();
			_domObjReferences.form_adminForm.submit();
		}
	}
	else {
		errorMsg = getAlertSelectionsMsg();
		if(errorMsg == "") {
			if(confirm($i18n("fcm.alert.alertAdmin.js.verifyCloseAlerts.confirm1.txt"))) {
				_domObjReferences.form_adminForm.method.value='close';
				_domObjReferences.form_adminForm.action='closeAlerts.action';
				setBusy();
				_domObjReferences.form_adminForm.submit();
			}
		}
		else {
			alert($i18n("fcm.alert.alertAdmin.js.verifyCloseAlerts.alert0.fmt.txt",[errorMsg]));
		}
	}
	return;
}

function getAlertSelectionsMsg() {
	if (_domObjReferences.hidden_alertSelections.value == "") {
		return $i18n("fcm.alert.alertAdmin.js.noAlertSelected.txt");
	}
	return "";
}

function getTargetQueueSelectionMsg() {
	if(document.getElementById('targetQueueId').selectedIndex == -1) {
		return $i18n("fcm.alert.alertAdmin.js.noTargetQueueSelected.txt");
	}
	return "";
}

function chkAllAlertsOnPage(checkFlag) {
	var formElements = _domObjReferences.form_adminForm.elements;
	for(jj=0; jj<formElements.length; jj++) {
		if(formElements[jj].type == "checkbox" && formElements[jj].id.indexOf('alert') != -1) {
			if(formElements[jj].checked != checkFlag) {
				formElements[jj].checked = checkFlag;
				addOrRemoveItem(formElements[jj].id,5);
			}
		}
	}
	displayAlertSelections();
}

function clearAllSelections() {
	chkAllAlertsOnPage(false);
	_domObjReferences.hidden_alertSelections.value="";
	displayAlertSelections();
}

function displayAlertSelections() {
	if(_domObjReferences.span_alertSelectionsNumber) {
		var alertSelections = _domObjReferences.hidden_alertSelections.value;
		if(alertSelections.length > 0) {
			_domObjReferences.span_alertSelectionsNumber.innerHTML = alertSelections.split(',').length;
		}
		else _domObjReferences.span_alertSelectionsNumber.innerHTML = '0';
	}
}

function showDialog(mvAllBoolean,clickedElementName,dialogDivName) {
	if ( _strategyOptions.length == 0 )
	{
		alert($i18n("fcm.alert.alertAdmin.js.showDialog.alert1.txt"));
		return;
	}

	if(!mvAllBoolean) {
		if (_domObjReferences.hidden_alertSelections.value == "") {
			alert($i18n("fcm.alert.alertAdmin.js.showDialog.alert0.txt"));
			return;
		}
	}
	var clickedElement = document.getElementById(clickedElementName);
	var dialogDiv = document.getElementById(dialogDivName);
	_moveAllFlag = mvAllBoolean;
	dialogDiv.style.top = getBottomPosition(clickedElement) + "px";
	dialogDiv.style.left = getLeftPosition(clickedElement) + "px";
	dialogDiv.style.visibility = 'visible';
	return;
}
// Total Alerts Selected $i18n("fcm.sq.queue.alertsInQueue.totalAlertsSelected.txt")
function configureStatusBar() {
	// tableButtons div will only be on the page if alert administrative functions are active
	if(_domObjReferences.td_eXtremeTableStatusBar && _domObjReferences.div_tableButtons) {
		// Force the centering of the text in the status bar
		_domObjReferences.td_eXtremeTableStatusBar.style.textAlign = 'center';
		_domObjReferences.td_eXtremeTableStatusBar.style.backgroundColor = '#eee';
		_domObjReferences.td_eXtremeTableStatusBar.style.borderBottom = '1px solid #ccc';

		// Build table menu with alert selections status
		_domObjReferences.td_eXtremeTableStatusBar.innerHTML =
			_domObjReferences.div_tableButtons.innerHTML +
			_domObjReferences.td_eXtremeTableStatusBar.innerHTML +
			'&nbsp;&nbsp;&nbsp;&#8226;&nbsp;&#8226;&nbsp;&#8226;&nbsp;&nbsp;&nbsp;' +
			'<span id=\'totalAlertsSelected\'>$i18n("fcm.sq.queue.alertsInQueue.totalAlertsSelected.txt")</span>:<span id="alertSelectionsNumber" style="font-weight:bold;padding:2px;"></span>';

		// Grab a reference to the dynamically generated 'alertSelectionsNumber' span tag
		_domObjReferences.span_alertSelectionsNumber = document.getElementById('alertSelectionsNumber');
	}
}

function loadDomReferences() {
	_domObjReferences.div_moveDialog = document.getElementById('moveDialog');
	_domObjReferences.form_adminForm = document.getElementById('alertAdminForm');
	_domObjReferences.hidden_alertSelections = document.getElementById('alertSelections');
	_domObjReferences.div_tableButtons = document.getElementById('tableButtons');
	_domObjReferences.opts_targetQueue = _domObjReferences.form_adminForm.targetQueueId.options;
	_domObjReferences.opts_strategy = _domObjReferences.form_adminForm.strategyFilter.options;
	// Get a handle to the extreme table status bar
	var tdElems = document.getElementsByTagName('td');
	var spanElems = document.getElementsByTagName('span');
	var currElem = null;
	for(jj=0;jj<tdElems.length;jj++) {
		currElem = tdElems[jj];
		if(currElem.className == 'statusBar') {
			_domObjReferences.td_eXtremeTableStatusBar = currElem;
			break;
		}
	}
	for(jj=0;jj<spanElems.length;jj++) {
		currElem = spanElems[jj];
		if(currElem.className == 'title') {
			_domObjReferences.span_eXtremeTableTitle = currElem;
			break;
		}
	}
}

function populateListBoxes() {
	// Clear out the strategy listbox and default to select
	//   the strategy of the currently selected queue (if other queues exist).
	_domObjReferences.opts_strategy.length = 0;
	if (_strategyOptions.length > 0)
	{
		var selectedStrategy = _strategyOptions[0];
		selectedStrategy.selected = true;
		for(jj=0;jj<_strategyOptions.length;jj++) {
			_domObjReferences.opts_strategy[jj] = _strategyOptions[jj];
			if(_strategyOptions[jj].value == _selectedQueue.strategyId) {
				_strategyOptions[jj].selected = true;
				selectedStrategy = _strategyOptions[jj];
			}
		}
		populateQueueListBox();
	}
}

function populateQueueListBox() {
	// Clear out the queues listbox and populate only with the
	//   the queues in currently selected strategy. If the
	//   filterBySortField checkbox is checked, display only queues
	//   with sort field matching the selected queue's sort field
	_domObjReferences.opts_targetQueue.length = 0;
	var selectedStrategyOption = _strategyOptions[_domObjReferences.opts_strategy.selectedIndex];
	var queueIdx = 0;
	for(jj=0;jj<selectedStrategyOption.queues.length;jj++) {
		if(!_domObjReferences.form_adminForm.filterBySortField.checked ||
				(_domObjReferences.form_adminForm.filterBySortField.checked &&
				selectedStrategyOption.queues[jj].sortField == _selectedQueue.sortField)
			) {
				_domObjReferences.opts_targetQueue[queueIdx] = selectedStrategyOption.queues[jj];
				queueIdx++;
		}
	}
}

function openAlertDetail(alertId)
{
	var w=screen.availWidth;
	var h=screen.availHeight;
	var l=(w-920)/2;
	var t=((h-500)/2)-24;
	fcmAlertDetailView=window.open("viewAlertDetail.action?alert="+alertId,"FCMAlertDetailView",
	           "height=800,width=1280,status=no,toolbar=no,menubar=no,location=no,titlebar=no,resizable=yes,top="+t+",left="+l);
}

// This function is called from the body tag's onLoad event handler.  It is meant to be replaced by a function uses data
//   obtained dynamically from a JSP.
function loadDynamicElements() {}