

/**
  * Validated that a field value Sets is not null or empty
  * and alerts the user to change the field;
  *
  */

function validateNotEmpty(fieldname,fieldvalue)
{
    var re = /\s/g; //Match any white space including space, tab, form-feed, etc.
    RegExp.multiline = true; // IE support
    var str = fieldvalue.replace(re, "");
    if (str.length == 0)
    {
      alert($i18n("fcm.admin.js.validateNotEmpty.alert0.fmt.txt", [fieldname]));
      return false;
    }
    else
    {
      return true;
    }
}

/**
  * Restricts length of description
  */
function validateDescription(name)
{
   return validateDescriptionLength(name, 255);
}

/**
  * Restricts length of description
  */
function validateDescriptionLength(name, length)
{
   return !(jQuery.trim(name).length > length);
}


/**
  * Sets the forms on the page to read-only.  The user can only
  * view the current settings in the form.  Call this after the page
  * has loaded.
  *
  *
function setFormsReadOnly()
{
    // Loop through each form on this page
    for (var i = 0; i < document.forms.length; i++) {
        // Loop through each element in the form
        var form = document.forms[i];

        form.onkeypress = form.onkeydown = captureKeyStrokes;

        for (var j = 0; j < form.length; j++) {
            // Disable each element
            var element = form.elements[j];

            // Change the textarea and text fields background color and borders
            // to hide the fact that they are input fields.  Then set them to readonly.
            if(element.type && (element.type == 'textarea' || element.type=='text'))
            {
               element.readOnly = true;
               element.style.backgroundColor="#f0f1f2";
               //element.style.border="none";
            }
            // Keep listboxes enabled for scrolling.
            // Deactivate the clicking of the options
            else if(element.type && element.type == 'select-multiple')
            {
               //allow scrolling
               element.onfocus = disableOptionStateChange;
               element.style.color="GrayText";
               element.style.border="1px solid InactiveBorder";
            }
            else if(element.type && element.type == 'button' && element.id=='saveButton')
            {
               element.style.display="none";
            }
            else // any other element should be disabled.
            {
               element.disabled = true;
            }

            // disable anchors only within the forms.
            var anchors = form.getElementsByTagName("A");
            for (k = 0; k < anchors.length; k++) {
                 // Disable each element
                 var anchor = anchors[k];
                 anchor.disabled = true;
                 anchor.onclick=showReadOnlyWarning;

             }
        }
    }

}
*/


/**
  * For those nodes that change that don't affect the structure
  * of the tree, the name can be reset if changed for a save.
  *
  */
function setTreeNodeTitle(treeObj,title)
{
   var nodes = treeObj.getSelectedNodes();
   if(nodes.length == 1)
   {
      var node = nodes[0];
      var nodeTitle = node.getTitle();
      if(nodeTitle != title)
         node.setTitle(title);
   }

}

/**
  * Restricts certain characters
  */
function validateName(name)
{
   return !(jQuery.trim(name).length == 0);
}

/**
  * Shows progress bar and then submits form
  */
function subForm(form)
{
   setBusy();
   form.submit();
}

function setBusyDetail()
{
	setBusy();
}

function animate(id,color0,color1,duration){
    //public attributes
    this.elem = document.getElementById(id);
    //private attributes
    var r0= parseInt(color0.substring(0,2),16);
    var g0= parseInt(color0.substring(2,4),16);
    var b0= parseInt(color0.substring(4,6),16);
    var r1= parseInt(color1.substring(0,2),16);
    var g1= parseInt(color1.substring(2,4),16);
    var b1= parseInt(color1.substring(4,6),16);
    var wait = 100; //100ms
    var steps = duration/wait;
    var rstep = (r1 - r0) / (steps);
    var gstep = (g1 - g0) / (steps);
    var bstep = (b1 - b0) / (steps);
    var self = this;
    //public functions
    this.step  = function() {
        steps--;
        if ( steps>0 ) {
            r0 = Math.floor(r0 + rstep);
            g0 = Math.floor(g0 + gstep);
            b0 = Math.floor(b0 + bstep);
            elem.style.color = 'rgb('+r0+','+g0+','+b0+')';
            //alert(steps + ' ; ' + elem.style.backgroundColor);
            window.setTimeout(function(){self.step();}, wait);
        } else {
            elem.style.color = '#'+color1;
        }
    }
    step();
    //alert(this.r0);
}

function copyToClipboard(txt)
{
	function handler (event){
        event.clipboardData.setData('text/plain', txt);
        event.preventDefault();
		window.status = $i18n("fcm.admin.js.content.copied.clipboard.txt");
        document.removeEventListener('copy', handler, true);
    }
    document.addEventListener('copy', handler, true);
    document.execCommand('copy');
}

//-->



