<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<%-- Main Content --%>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="common/scripts/cf.js"></script>

<script language="JavaScript" src="admin/scripts/queues.js"></script>
<script language="JavaScript" src="admin/scripts/dynamicRows.js"></script>
<script language="JavaScript" src="admin/scripts/itemPriorityList.js"></script>
<script language="JavaScript" src="admin/scripts/listboxAssignments.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>

<script language="JavaScript" src="admin/scripts/strategyTreeActions.js"></script>

<script type="text/javascript">

var isAutoAction = ${sa_strategy.autoActionStrategy};

var crs = [];
<c:forEach var="resultSetting" items="${initQueueCallResultSettings}">
crs.push ({
	id: ${resultSetting.id},
	type: "${esapi:encodeForJavaScript(resultSetting.type)}",
	name: "${esapi:encodeForJavaScript(resultSetting.callResult)}",
	typeUnknown: ${resultSetting.typeUnknown},
	typePositive: ${resultSetting.typePositive},
	typeNegative: ${resultSetting.typeNegative},
	isAssigned: ${resultSetting.queueId != -1}
});
</c:forEach>

var crSettings = ${initQueueCallResultSettings_JSON};

<%-- POS CODES --%>
var posCodesByCallResult = {};
<c:forEach var="rs" items="${qa_callResults}">
	posCodesByCallResult["${rs.id}"] = [];
	<c:forEach var="posCodes" items="${POSCodes}">
		<c:set var="posAssigned" value="false"/>
		<c:set var="index" value="qcr${rs.id}"/>
		<c:forEach var="posCode" items="${initQueueCallResultSettings_Map[index].posCodes}">
			<c:if test="${fn:trim(posCode) == posCodes.posCode}">
				<c:set var="posAssigned" value="true"/>
			</c:if>
		</c:forEach>
		posCodesByCallResult["${rs.id}"].push({
			id: "${esapi:encodeForJavaScript(posCodes.posCode)}",
			label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(posCodes.posName))}",
			isAssigned: ${posAssigned},
			isInitAssigned: ${posAssigned}
		});
	</c:forEach>
</c:forEach>

<%-- ALLOW REROUTE TO --%>
var allowRerouteTo = {};
<c:forEach var="rs" items="${qa_callResults}">
	<c:if test="${rs.type == 'UNKNOWN'}">
		allowRerouteTo["${rs.id}"] = [];
		<c:forEach var="queue" items="${routingQueues}">
			<c:if test="${queue.id != qa_queue.id}">
				<c:set var="queueAssigned" value="false"/>
				<c:set var="index" value="qcr${rs.id}"/>
				<c:forEach var="allowRerouteTo" items="${initQueueCallResultSettings_Map[index].allowRerouteTo}">
					<c:if test="${fn:trim(allowRerouteTo) == queue.id}">
						<c:set var="queueAssigned" value="true"/>
					</c:if>
				</c:forEach>
			allowRerouteTo["${rs.id}"].push({
				id: "${queue.id}",
				label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(queue.name))}",
				isAssigned: ${queueAssigned},
				isInitAssigned: ${queueAssigned}
			});
			</c:if>
		</c:forEach>
	</c:if>
</c:forEach>

<%-- FRAUD TYPES --%>
var fraudTypes = {};
<c:forEach var="rs" items="${qa_callResults}">
	<c:if test="${rs.type == 'NEGATIVE'}">
		fraudTypes["${rs.id}"] = [];
		<c:forEach var="fraudType" items="${fraudTypes}">
			<c:set var="fraudTypeAssigned" value="false"/>
			<c:set var="index" value="qcr${rs.id}"/>
			<c:forEach var="assignedFraudCode" items="${initQueueCallResultSettings_Map[index].fraudTypes}">
				<c:if test="${fn:trim(assignedFraudCode) == fraudType.fraudCode}">
					<c:set var="fraudTypeAssigned" value="true"/>
				</c:if>
			</c:forEach>
			fraudTypes["${rs.id}"].push({
				id: "${esapi:encodeForJavaScript(fraudType.fraudCode)}",
				label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(fraudType.fraudName))}",
				isAssigned: ${fraudTypeAssigned},
				isInitAssigned: ${fraudTypeAssigned}
			});
		</c:forEach>
	</c:if>
</c:forEach>

<%-- SYSTEM BLOCKS --%>
var sysBlocksByCallResult = {};
<c:forEach var="rs" items="${qa_callResults}">
	sysBlocksByCallResult["${rs.id}"] = [];
	<c:forEach var="systemBlock" items="${systemBlocks}">
		<c:set var="sysBlockAssigned" value="false"/>
		<c:set var="index" value="qcr${rs.id}"/>
		<c:forEach var="sysBlock" items="${initQueueCallResultSettings_Map[index].systemBlocks}">
			<c:if test="${fn:trim(sysBlock.blockCode) == systemBlock.blockCode}">
			<c:set var="sysBlockAssigned" value="true"/>
			</c:if>
		</c:forEach>
		sysBlocksByCallResult["${rs.id}"].push({
			id: "${esapi:encodeForJavaScript(systemBlock.blockCode)}",
			label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(systemBlock.blockLabel))}",
			isAssigned: ${sysBlockAssigned},
			isInitAssigned: ${sysBlockAssigned}
		});
	</c:forEach>
</c:forEach>

<%-- Transaction BLOCKS --%>
var txnBlocksByCallResult = {};
<c:forEach var="rs" items="${qa_callResults}">
	txnBlocksByCallResult["${rs.id}"] = [];
	<c:forEach var="transactionBlock" items="${transactionBlocks}">
		<c:set var="txnBlockAssigned" value="false"/>
		<c:set var="index" value="qcr${rs.id}"/>
		<c:forEach var="txnBlock" items="${initQueueCallResultSettings_Map[index].transactionBlocks}">
			<c:if test="${fn:trim(txnBlock.blockCode) == transactionBlock.blockCode}">
			<c:set var="txnBlockAssigned" value="true"/>
			</c:if>
		</c:forEach>
		txnBlocksByCallResult["${rs.id}"].push({
			id: "${esapi:encodeForJavaScript(transactionBlock.blockCode)}",
			label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(transactionBlock.blockLabel))}",
			isAssigned: ${txnBlockAssigned},
			isInitAssigned: ${txnBlockAssigned}
		});
	</c:forEach>
</c:forEach>

var _countryCodes=[];		//sorted by name
var _countryCodesSorted=[];	//sorted by code

<c:forEach var="country" items="${countries}">
_countryCodes.push({code: "${esapi:encodeForJavaScript(country.countryCode)}", name: "${esapi:encodeForJavaScript(country.countryName)}" });
_countryCodesSorted.push("${esapi:encodeForJavaScript(country.countryCode)}");
</c:forEach>
_countryCodesSorted.sort();

var _sicCodes=[];
var _sicCodesSorted=[];
<c:forEach var="code" items="${SICCodes}">
_sicCodes.push({code: "${esapi:encodeForJavaScript(code.sicCode)}", name: "${esapi:encodeForJavaScript(code.sicName)}" });
_sicCodesSorted.push("${esapi:encodeForJavaScript(code.sicCode)}");
</c:forEach>
_sicCodesSorted.sort();

var _isEligibleForDeletion = ${isEligibleForDeletion};

var emailList = [];
var letterList = [];
var smsList = [];

<c:forEach var="email" items="${emailTemplates}" varStatus="status">
	emailList.push({
		id: ${email.id},
		label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(email.name))}",
		isAssigned: ${assignedEmails[email.id]==true}
	});
	<c:if test="${email.id==qa_queue.defaultEmail}">
	_defaultTemplateIds[_emailType] ="${status.count-1}";
	</c:if>
</c:forEach>

<c:forEach var="letter" items="${letterTemplates}" varStatus="status">
	letterList.push({
		id: ${letter.id},
		label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(letter.name))}",
		isAssigned: ${assignedLetters[letter.id]==true}
	});
	<c:if test="${letter.id==qa_queue.defaultLetter}">
	_defaultTemplateIds[_letterType] = "${status.count-1}";
	</c:if>
</c:forEach>

<c:forEach var="sms" items="${smsTemplates}" varStatus="status">
	smsList.push({
		id: ${sms.id},
		label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(sms.name))}",
		isAssigned: ${assignedSmss[sms.id]==true}
	});
	<c:if test="${sms.id==qa_queue.defaultSms}">
	_defaultTemplateIds[_smsType] = "${status.count-1}";
	</c:if>
</c:forEach>

<c:forEach var="queue" items="${queuePriorityList}">
_itemPriorityList.push({
	id: ${queue.id},
	version: ${queue.version},
	priority: ${queue.priority},
	newPriority: ${queue.priority}
});
</c:forEach>
</script>
<iframe style="border:none;width:0px;height:0px;display:none" id="codeLookupFrame" name="codeLookupFrame" src="common/blank.html"></iframe>

<div>
<%-- Error handling code --%>
<c:url var="reloadURL" value="/listStrategyTree.action?qa_queueId=${qa_queue.id}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="Queue" />
</tiles:insertTemplate>

<form id="queueForm" name="queueForm" action="<c:url value='/saveQueue.action'/>" method="post" onsubmit="return saveQueueForm(this)">
<input type="hidden" name="method">
<input type="hidden" name="id" value="${qa_queue.id}">
<input type="hidden" name="version" value="${qa_queue.version}">
<input type="hidden" name="strategyId" value="${qa_queue.strategyId}">
<input type="hidden" name="callSuperseded">
<input type="hidden" name="stickyQueue">
<input type="hidden" name="defaultEmail" id="defaultEmail" id value="${esapi:encodeForHTMLAttribute(qa_queue.defaultEmail)}">
<input type="hidden" name="defaultSms" id="defaultSms" value="${esapi:encodeForHTMLAttribute(qa_queue.defaultSms)}">
<input type="hidden" name="defaultLetter" id="defaultLetter" value="${esapi:encodeForHTMLAttribute(qa_queue.defaultLetter)}">
<%-- Queue priority List --%>
<c:set var="queueRelativePriority" value="0"/>
<div id="queuePriorityList" class="priorityListPopupGrid" onmouseup="ignoreEvent(event)" onscroll="repositionTHs(this)">
	<table id="queuePriorityTable" class="mainTable" style="background-color:#ffffff;border-collapse:separate;border:none;" width="100%" border="0" cellspacing="0" cellpadding="5">
		<thead>
		<tr class="tableColumnHeaderRow">
			<th class="centeredTableHeader" nowrap><fmt:message key="fcm.sq.queue.priority.txt"/></th>
			<th class="centeredTableHeader" nowrap><fmt:message key="fcm.sq.queue.queueName.txt"/></th>
			<th class="centeredTableHeader" nowrap><fmt:message key="fcm.sq.queue.strategyName.txt"/></th>
		</tr>
		</thead>
		<tbody id="queuePriorityTableBody">
		<c:forEach var="queue" items="${queuePriorityList}" varStatus="status">
			<c:set var="className" value="dataRow${status.count%2+1}_tableRow"/>
			<c:if test="${qa_queue.id == queue.id}">
				<c:set var="className" value="rowSelected"/>
				<c:set var="queueRelativePriority" value="${status.count}"/>
			</c:if>
			<tr style="cursor:pointer;" class="${className}" onclick="setQueuePriority(this);">
				<td class="imageTableCell" nowrap>${status.count}</td>
				<td class="textTableCell" nowrap>${esapi:encodeForHTML(queue.name)}</td>
				<td class="textTableCell lastCol" nowrap>${esapi:encodeForHTML(queue.strategyName)}</td>
			</tr>
		</c:forEach>
		</tbody>
	</table>
</div>

<%-- start of top/main div/table --%>

<div border="none">

<table id="queueDefinitionTable" class="configurationTable" style="margin-left:5px;width:600px;" cellspacing="0" cellpadding="2" border="0">
    <tr align="left" valign="top" onclick="showDiv($('#generalPropertiesImg')[0], 'generalPropertiesBlock');">
      <td class="configurationTableSection" colspan="2" style="padding:5px;" nowrap>
<!--      	<img id="generalPropertiesImg" src="admin/images/sprite_arrow_down_light.png" align="middle" /> -->
        <span id="generalPropertiesImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06e;"></span>
      	&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.queueDefinition.txt" />
      	<a style="color: white; margin-left:430px;text-decoration:none;border-bottom:none;" onclick="showAlertsInQueue('${qa_queue.id}');return false;">
	        <span class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf186;"></span>
			<span><fmt:message key="fcm.sq.queue.contents.txt"/></span>
   		</a>
	  </td>
    </tr>
	<tr id="generalPropertiesBlock" class="configurationTableDataRow" valign="top">
		<td colspan="2">

		<table class="minimalPadding" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td><fmt:message key="fcm.sq.queue.queueId.txt"/>:</td>
				<td valign="middle">
					${qa_queue.id}
				</td>

			</tr>
			<tr>
				<td><fmt:message key="fcm.sq.queue.name.txt"/>:</td>
				<td valign="middle">
					<input class="famTextEntry" name="name" type="text" value="${esapi:encodeForHTMLAttribute(qa_queue.name)}" size="61" maxLength="50" />
				</td>
			</tr>
			<tr valign="top">
				<td><fmt:message key="fcm.sq.queue.description.txt"/>: </td>
				<td valign="middle">
					<textarea class="famTextEntry" name="description" cols="60" rows="4" wrap="PHYSICAL" onKeyDown="limitChars(this,100);" onKeyUp="limitChars(this,100,true);" >${esapi:encodeForHTML(qa_queue.description)}</textarea>
				</td>
			</tr>
			<tr valign="top">
				<td><fmt:message key="fcm.sq.queue.strategy.txt"/>:</td>
				<c:if test="${not empty qa_queue.strategyName}">
				<td>${esapi:encodeForHTML(qa_queue.strategyName)}</td>
				</c:if>
				<c:if test="${empty qa_queue.strategyName}">
				<td><fmt:message key="fcm.sq.queue.notAssignedToAStrategy.txt"/></td>
				</c:if>
			</tr>
			<%-- Will be false only for the default inbound queue
			<c:if test="${queueRelativePriority > 0}" >--%>
			<tr valign="top">
				<td><fmt:message key="fcm.sq.queue.priority.txt"/>:</td>
				<td>
				<fmt:message key="fcm.sq.queue.of.fmt.txt">
                    <fmt:param>
                    <a style="color:#287EAB;" id="queueRelativePriority" href="javascript:showQueuePriorityList('queuePriorityList');">
                        ${esapi:encodeForHTML(queueRelativePriority)}
                    </a>
                    </fmt:param>
                    <fmt:param>  &nbsp; ${esapi:encodeForHTML(fn:length(queuePriorityList))} </fmt:param>
                </fmt:message>
				</td>
			</tr>
			<%--/c:if--%>
			<tr>
				<td valign="middle"><fmt:message key="fcm.sq.queue.status.txt"/>:</td>
				<td valign="bottom">
					<input name="status" type="radio" value="ACTIVE" /><fmt:message key="fcm.sq.queue.active.txt"/>
					<input name="status" type="radio" value="INACTIVE" /><fmt:message key="fcm.sq.queue.inactive.txt"/>
					<script>
						for(i = 0; i < document.queueForm.status.length; i++)
						{
							rd = document.queueForm.status[i];
							if(rd.value == "${esapi:encodeForJavaScript(fn:trim(qa_queue.status))}".toUpperCase()) rd.checked = true;
						}
					</script>
				</td>
			</tr>
		</table>

		<table class="minimalPadding" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td><fmt:message key="fcm.sq.queue.contactCallingHours.txt"/>:</td>
				<td>
				<select name="callLowerBound" class="famSelect">
					<c:forEach begin="0" end="23" step="1" var="hr">
						<option value="${hr}"> ${hr}:00 </option>
					</c:forEach>
				</select>
				-
				<select name="callUpperBound" class="famSelect">
					<c:forEach begin="0" end="23" step="1" var="hr">
						<option value="${hr}"> ${hr}:00 </option>
					</c:forEach>
				</select>
				<script>
					document.queueForm.callLowerBound.options[${esapi:encodeForJavaScript(qa_queue.callLowerBound)}].selected=true;
					document.queueForm.callUpperBound.options[${esapi:encodeForJavaScript(qa_queue.callUpperBound)}].selected=true;
				</script>
				</td>
			</tr>
			<tr class="configurationTableDataRow">
				<td><fmt:message key="fcm.sq.queue.prioritizeAlertsBy.txt"/>: </td>
				<td>
				<select name="sortField" class="famSelect">
					<option value="FRAUD_SCORE_1" <c:if test="${qa_queue.sortField.equalsIgnoreCase('FRAUD_SCORE_1')}">selected</c:if>><fmt:message key="fcm.sq.queue.score1.txt"/></option>
					<option value="FRAUD_SCORE_2" <c:if test="${qa_queue.sortField.equalsIgnoreCase('FRAUD_SCORE_2')}">selected</c:if>><fmt:message key="fcm.sq.queue.score2.txt"/></option>
					<option value="FRAUD_SCORE_3" <c:if test="${qa_queue.sortField.equalsIgnoreCase('FRAUD_SCORE_3')}">selected</c:if>><fmt:message key="fcm.sq.queue.score3.txt"/></option>
					<option value="FRAUD_SCORE_4" <c:if test="${qa_queue.sortField.equalsIgnoreCase('FRAUD_SCORE_4')}">selected</c:if>><fmt:message key="fcm.sq.queue.score4.txt"/></option>
					<option value="LST_TRANSACTION_AMT" <c:if test="${qa_queue.sortField.equalsIgnoreCase('LST_TRANSACTION_AMT')}">selected</c:if>><fmt:message key="fcm.sq.queue.transactionAmount.txt"/></option>
					<option value="LST_TRANSACTION_TIMESTAMP" <c:if test="${qa_queue.sortField.equalsIgnoreCase('LST_TRANSACTION_TIMESTAMP')}">selected</c:if>><fmt:message key="fcm.sq.queue.lastTransactionDate.txt"/></option>
					<option value="EXPIRATION_TIMESTAMP" <c:if test="${qa_queue.sortField.equalsIgnoreCase('EXPIRATION_TIMESTAMP')}">selected</c:if>><fmt:message key="fcm.sq.queue.expirationTime.txt"/></option>

					<c:forEach var="item" items="${alertSortFields}">
						<option value="${esapi:encodeForHTMLAttribute(item.fieldName)}" <c:if test="${qa_queue.sortField.equalsIgnoreCase(item.fieldName)}">selected</c:if>>${esapi:encodeForHTML(item.fieldDescription)}</option>
					</c:forEach>
				</select>
				<select name="sortOrder" class="famSelect" onchange="">
					<option value="ASC"><fmt:message key="fcm.sq.queue.ascending.txt"/></option>
					<option value="DESC" <c:if test="${qa_queue.sortOrder.equalsIgnoreCase('DESC')}">selected</c:if>><fmt:message key="fcm.sq.queue.descending.txt"/></option>
				</select>
				</td>
			</tr>
			<tr class="configurationTableDataRow">
				<td><fmt:message key="fcm.sq.queue.systemBlockDays.txt"/>: </td>
				<td><input type="text" name="systemBlockDays" id="systemBlockDays" size="3" maxlength="3" value="${esapi:encodeForHTMLAttribute(qa_queue.systemBlockDays)}"/></td>
			</tr>
			<tr class="configurationTableDataRow">
				<td><fmt:message key="fcm.sq.queue.transactionBlockDays.txt"/>: </td>
				<td><input type="text" name="transactionBlockDays" id="transactionBlockDays" size="3" maxlength="3" value="${esapi:encodeForHTMLAttribute(qa_queue.transactionBlockDays)}"/></td>
			</tr>

		</table>
		</td>
	</tr>

<%-- E-mail Assignment Selection --%>

	<tr onclick="showDiv($('#emailAssignmentImg')[0], 'emailAssignmentBlock');dismissPopup('addEmails');">
		<td colspan="2" class="configurationTableSection" style="padding:5px;">
<!--			<img id="emailAssignmentImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="emailAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.EmailAssignment.txt"/>
		</td>
	</tr>

<tr id="emailAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>

	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2" nowrap><br/>
			<a id="addEmailsAnchor" class="menuItemButton" onclick="showDropDownMenu('addEmails',[document.queueForm.assignedEmailsListbox]);return false;" href="#">
				<fmt:message key="fcm.sq.queue.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
			</a>
			&nbsp;
			<a id="removeEmailsAnchor" class="menuItemButton" onclick="moveSelectedOptions(document.queueForm.assignedEmailsListbox,document.queueForm.unassignedEmailsListbox,false,emailList);selectDefaultItem(event,'assignedEmailsListbox');return false;" href="#">
			<fmt:message key="fcm.sq.queue.remove.txt"/>
			</a>
			&nbsp;
			<a id="setDefaultEmailsAnchor" class="menuItemButton" onclick="setAsDefaultItem(event,'assignedEmailsListbox');return false;" href="#">
			<fmt:message key="fcm.sq.queue.setAsDefault.txt"/>
			</a>
		</td>
	</tr>
	<tr class="configurationTableDataRow">
		<td colspan="2">
			<div id="assignedEmailsContainer" style="display:inline">
				<select name="assignedEmailsListbox" class="famSelect" style="width:25em" size="6" multiple >
				</select>
			</div>
			<script>
				loadListboxByAssignment(emailList,'assignedEmailsContainer',true);
			</script>

			<%--<br/>
			[*] indicates default E-mail template--%>
			<br/>
			<b><fmt:message key="fcm.sq.queue.default.txt"/></b>: <label id="defaultEmailDisplay"/>
			<br/>
		</td>
	</tr>
</table>
</td>
</tr>

<%-- Letter Assignment Selection --%>

	<tr onclick="showDiv($('#letterAssignmentImg')[0], 'letterAssignmentBlock');dismissPopup('addLetters');">
		<td colspan="2" class="configurationTableSection" style="padding:5px;">
<!--			<img id="letterAssignmentImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="letterAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.letterAssignment.txt"/>
		</td>
	</tr>

<tr id="letterAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2" nowrap><br/>
			<a id="addLettersAnchor" class="menuItemButton" onclick="showDropDownMenu('addLetters',[document.queueForm.assignedLettersListbox]);return false;" href="#">
				<fmt:message key="fcm.sq.queue.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
			</a>
			&nbsp;
			<a id="removeLettersAnchor" class="menuItemButton" onclick="moveSelectedOptions(document.queueForm.assignedLettersListbox,document.queueForm.unassignedLettersListbox,false,letterList);selectDefaultItem(event,'assignedLettersListbox');return false;" href="#">
			<fmt:message key="fcm.sq.queue.remove.txt"/>
			</a>
			&nbsp;
			<a id="setDefaultLettersAnchor" class="menuItemButton" onclick="setAsDefaultItem(event,'assignedLettersListbox');return false;" href="#">
			<fmt:message key="fcm.sq.queue.setAsDefault.txt"/>
			</a>
		</td>
	</tr>
	<tr class="configurationTableDataRow">
		<td colspan="2">
			<div id="assignedLettersContainer" style="display:inline">
				<select name="assignedLettersListbox" class="famSelect" style="width:25em" size="6" multiple >
				</select>
			</div>
			<script>
				loadListboxByAssignment(letterList,'assignedLettersContainer',true);
			</script>
			<br/>
			<b><fmt:message key="fcm.sq.queue.default.txt"/></b>: <label id="defaultLetterDisplay"/>
			<br/>
		</td>
	</tr>

</table>
</td>
</tr>

<%-- Sms Assignment Selection --%>

	<tr onclick="showDiv($('#smsAssignmentImg')[0], 'smsAssignmentBlock');dismissPopup('addSmss');">
		<td colspan="2" class="configurationTableSection" style="padding:5px;">
<!--			<img id ="smsAssignmentImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="smsAssignmentImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.smsAssignment.txt"/>
		</td>
	</tr>

<tr id="smsAssignmentBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table border="0">

	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2" nowrap><br/>
			<a id="addSmssAnchor" class="menuItemButton" onclick="showDropDownMenu('addSmss',[document.queueForm.assignedSmssListbox]);return false;" href="#">
				<fmt:message key="fcm.sq.queue.add.txt"/>&nbsp;&nbsp;<img width="7" height="4" border="0" src="common/images/menu/dropBlue.gif"/>
			</a>
			&nbsp;
			<a id="removeSmssAnchor" class="menuItemButton" onclick="moveSelectedOptions(document.queueForm.assignedSmssListbox,document.queueForm.unassignedSmssListbox,false,smsList);selectDefaultItem(event,'assignedSmssListbox');return false;" href="#">
			<fmt:message key="fcm.sq.queue.remove.txt"/>
			</a>
			&nbsp;
			<a id="setDefaultSmssAnchor" class="menuItemButton" onclick="setAsDefaultItem(event,'assignedSmssListbox');return false;" href="#">
			<fmt:message key="fcm.sq.queue.setAsDefault.txt"/>
			</a>
		</td>
	</tr>
	<tr class="configurationTableDataRow">
		<td colspan="2">
			<div id="assignedSmssContainer" style="display:inline">
				<select name="assignedSmssListbox" class="famSelect" style="width:25em" size="6" multiple >
				</select>
			</div>
			<script>
				loadListboxByAssignment(smsList,'assignedSmssContainer',true);
			</script>
			<br/>
			<b><fmt:message key="fcm.sq.queue.default.txt"/></b>: <label id="defaultSmsDisplay"/>
			<br/>
		</td>
	</tr>

</table>
</td>
</tr>

<%--WARNING OPTION --%>

	<tr align="left" valign="top" onclick="showDiv($('#highRiskImg')[0], 'highRiskBlock');">
		<td colspan="2" class="configurationTableSection" style="padding:5px;">
<!--			<img id="highRiskImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="highRiskImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.highRiskWarning.txt"/>
		</td>
	</tr>

	<tr id="highRiskBlock" class="configurationTableDataRow" valign="top" style="display:none;">
		<td colspan="2">
		<table border="0">
			<tr class="configurationTableDataRow" valign="top">
				<td colspan="2" align="left" style="padding-bottom:10px;"><b><fmt:message key="fcm.sq.queue.blockGroupCombinations.txt"/>:</b></td>
				<td><b><fmt:message key="fcm.sq.queue.definedCombinations.txt"/>:</b></td>
			</tr>
			<tr class="configurationTableDataRow" valign="top" align="right">
				<td align="left" NOWRAP valign="bottom"width="10%"><fmt:message key="fcm.sq.queue.blockCode.txt"/>:</td>
				<td align="left" width="30%"><select name="blockCodeSelector" id="blockCodeSelector" class="famSelect">
				<c:if test="${systemBlocks!=null || transactionBlocks!=null}"><option value="all" selected><fmt:message key="fcm.sq.queue.allBlocks.txt"/></option></c:if>
				<c:if test="${systemBlocks != null}">
					<c:forEach var="systemBlock" items="${systemBlocks}" varStatus="status">
						<option value="${esapi:encodeForHTMLAttribute(esapi:encodeForJavaScript(systemBlock.blockId))}" id="bc_${status.count}">${esapi:encodeForHTML(systemBlock.blockLabel)}(${esapi:encodeForHTML(systemBlock.blockType)})</option>
					</c:forEach>
				</c:if>
				<c:if test="${transactionBlocks != null}">
					<c:forEach var="transactionBlock" items="${transactionBlocks}" varStatus="status">
						<option value="${esapi:encodeForHTMLAttribute(esapi:encodeForJavaScript(transactionBlock.blockId))}" id="bc_${status.count}">${esapi:encodeForHTML(transactionBlock.blockLabel)}(${esapi:encodeForHTML(transactionBlock.blockType)})</option>
					</c:forEach>
				</c:if>
				</select>
				</td>
				<td align="left" valign="top" rowspan="4">
					<div id="comboContainer" style="display:inline">
						<select name="comboListbox" id="comboListbox" class="famSelect" style="width:25em" size="6" multiple >
						<c:forEach var="combo" items="${qa_queue.warningCombos}">
							<option value="${esapi:encodeForHTMLAttribute(combo.blockId)}~${esapi:encodeForHTMLAttribute(combo.groupCode)}">${esapi:encodeForHTML(combo.blockLabel)}&${esapi:encodeForHTML(combo.groupLabel)}</option>
						</c:forEach>
						</select>
					</div>
				</td>
			</tr>
			<tr class="configurationTableDataRow">
				<td align="left" NOWRAP valign="bottom"><fmt:message key="fcm.sq.queue.groupCode.txt"/>:</td>
				<td align="left"><select name="groupCodeSelector" id="groupCodeSelector" class="famSelect">
				<c:if test="${groupCodes != null}">
					<option value="all" selected><fmt:message key="fcm.sq.queue.allGroups.txt"/></option>
					<c:forEach var="groupCodes" items="${groupCodes}" varStatus="status">
						<option value="${esapi:encodeForHTMLAttribute(esapi:encodeForJavaScript(groupCodes.groupCode))}">${esapi:encodeForHTML(groupCodes.groupCodeDesc)}</option>
					</c:forEach>
				</c:if>
				</select></td>
			</tr>
			<tr>
				<td valign="middle" align="right"colspan="2">
					<a id="addComboAnchor" class="menuItemButton" onclick="addComboToListbox('blockCodeSelector','groupCodeSelector','comboListbox');return false;" href="#">
					<fmt:message key="fcm.sq.queue.add.txt"/>
					</a>&nbsp;
					<a id="removeCombosAnchor" class="menuItemButton" onclick="removeOptions('comboListbox');return false;" href="#"
						<c:if test="${empty qa_queue.warningCombos}">
							disabled
						</c:if>
					>
					<fmt:message key="fcm.sq.queue.remove.txt"/>
					</a>
				</td>
			<tr><td colspan="2">&nbsp;</td></tr>
			<tr class="configurationTableDataRow">
				<td align="left" colspan="3" style="padding-right:0px;"><b><fmt:message key="fcm.sq.queue.warningMsg.txt"/>:</b><br/>
				<input type="text" id="warningMsg" name="warningMsg" class="famTextEntry" maxlength="50" size="103" value="${esapi:encodeForHTMLAttribute(qa_queue.warningMsg)}"></td>
			</tr>
		</table>
		</td>
	</tr>

<%-- Alert Creation and Rerouting --%>

	<tr align="left" valign="top" onclick="showDiv($('#alertCreationImg')[0], 'alertCreationBlock');">
		<td colspan="2" class="configurationTableSection" style="padding:5px;" >
<!--			<img id="alertCreationImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="alertCreationImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.alertCreatingAndRouting.txt"/>
		</td>
	</tr>

<tr id="alertCreationBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:choose>
			<c:when test="${not qa_queue.callSuperseded}">
				<c:set var="checkedFlag" value="checked=\"checked\"" />
			</c:when>
			<c:otherwise>
				<c:set var="checkedFlag" value="" />
			</c:otherwise>
		</c:choose>
		<input name="callSupersededCheckbox" type="checkbox" value="0" ${checkedFlag} />
		<fmt:message key="fcm.sq.queue.SurfaceAlertsOnlyWithinDesignatedCallingHours.txt"/>
	</td>
	</tr>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:set var="checkedFlag" value=""/>
		<c:if test="${qa_queue.stickyQueue}">
			<c:set var="checkedFlag" value="checked=\"checked\""/>
		</c:if>
		<input type="checkbox" name="stickyQueueCheckbox" value="1" ${checkedFlag} />
		<fmt:message key="fcm.sq.queue.AlertsQueueNeverReassigned.txt"/>
		</td>
	</tr>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:set var="checkedFlag" value=""/>
		<c:if test="${qa_queue.routeAlertsInboundAllowed }">
			<c:set var="checkedFlag" value="checked=\"checked\""/>
		</c:if>
<%-- S1139442: NF: Remove the requirement of a reroute queue to be sticky
		<input type="checkbox" name="routeAlertsInboundAllowed" value="1" ${checkedFlag} onclick="setStickySetting(this,document.queueForm.stickyQueueCheckbox)"/>
--%>
		<input type="checkbox" name="routeAlertsInboundAllowed" value="1" ${checkedFlag}/>
		<fmt:message key="fcm.sq.queue.allowAlertToBeReroutedToThisQueue.txt"/>
<%-- 		<script> setStickySetting(document.queueForm.routeAlertsInboundAllowed,document.queueForm.stickyQueueCheckbox) </script> --%>
		</td>
	</tr>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:set var="checkedFlag" value=""/>
		<c:if test="${qa_queue.inbound }">
			<c:set var="checkedFlag" value="checked=\"checked\""/>
		</c:if>
		<input type="checkbox" name="inbound" value="1" ${checkedFlag} />
		<fmt:message key="fcm.sq.queue.markAsInbound.txt"/>
		</td>
	</tr>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:set var="checkedFlag" value=""/>
		<c:if test="${qa_queue.disableForceCheckout }">
			<c:set var="checkedFlag" value="checked=\"checked\""/>
		</c:if>
		<input type="checkbox" name="disableForceCheckout" value="1" ${checkedFlag} />
		<fmt:message key="fcm.sq.queue.disableForceCheckout.txt"/> <br/>
		</td>
	</tr>
</table>
</td>
</tr>

<%-- Assigned Queue Rules --%>

	<tr align="left" valign="top" onclick="showDiv($('#assignedQueueImg')[0], 'assignedQueueBlock');">
		<td colspan="2" class="configurationTableSection" style="padding:5px;">
<!--			<img id="assignedQueueImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="assignedQueueImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.AssignedQueueRules.txt"/>
		</td>
	</tr>

<tr id="assignedQueueBlock" class="configurationTableDataRow" valign="top" style="display:none;">
<td colspan="2">
<table>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:set var="checkedFlag" value=""/>
		<c:if test="${qa_queue.productionRulesAccepted}">
			<c:set var="checkedFlag" value="checked=\"checked\""/>
		</c:if>
		<input name="productionRulesAccepted" type="checkbox" value="1" ${checkedFlag} />
		<fmt:message key="fcm.sq.queue.productionrulesaccepted.txt"/>
		</td>
	</tr>
	<tr class="configurationTableDataRow" valign="top">
		<td colspan="2">
		<c:set var="divHeight" value="100px"/>
		<c:if test="${empty qa_queue.rules}">
			<c:set var="divHeight" value="50px"/>
		</c:if>
		<div class="queueRuleGrid" style="height:${divHeight};width:600px;">
			<table cellpadding="0" cellspacing="0" border="0">
			<c:if test="${not empty qa_queue.rules}">
			<%--	<tr class="tableColumnHeaderRow">
				<th nowrap class="centeredTableHeader"><fmt:message key="fcm.sq.queue.type.txt"/></th>
				<th nowrap class="centeredTableHeader"><fmt:message key="fcm.sq.queue.name.txt"/></th>
				<th nowrap class="centeredTableHeader"><fmt:message key="fcm.sq.queue.deployedDate.txt"/></th>
			</tr>--%>
			<c:forEach var="rule" items="${qa_queue.rules}" varStatus="status">
				<tr>
					<td align="left">
					<img src="images/rules/state${esapi:encodeForHTMLAttribute(rule.workflowState)}.gif" width="16" height="16" border="0">
					</td>
					<td>
					${esapi:encodeForHTML(rule.name)}
					</td>
				</tr>
			</c:forEach>
			</c:if>
			<c:if test="${empty qa_queue.rules}">
			<tr><td>&nbsp;<fmt:message key="fcm.sq.queue.NoRulesAssignedToQueue.txt"/></td></tr>
			</c:if>
			</table>
		</div>
		</td>
	</tr>

</table>
</td>
</tr>

<%-- Call Result Settings Configuration --%>
	<tr align="left" valign="top" onclick="showDiv($('#callResultImg')[0], 'callResultBlock');" >
		<td colspan="2" class="configurationTableSection" style="padding:5px;">
<!--			<img id="callResultImg" src="admin/images/sprite_arrow_right_light.png" align="middle" /> -->
            <span id="callResultImg" class="configurationSectionTwirly sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons" data-sap-ui-icon-content="&#xf06d;"></span>
			&nbsp;&nbsp;<fmt:message key="fcm.sq.queue.callResultSettings.txt"/>
		</td>
	</tr>


<tr id="callResultBlock" class="configurationTableDataRow" valign="top" style="display:none;">
	<td colspan="2">

		<%-- No Contact --%>
		<table width="100%" border="0" cellspacing="0" cellpadding="0">
			<tr align="left">
				<td align="left" class="configurationTableSection2"><input type="checkbox" disabled checked><fmt:message key="fcm.sq.queue.noContact.txt"/></td>
				<td align="right" class="configurationTableSection2"><fmt:message key="fcm.sq.queue.alertClosing.txt"/>:
					<input type="text" class="famTextEntry" name="autoCloseNewAlert" size="3" maxlength="3" value="${esapi:encodeForHTMLAttribute(qa_queue.autoCloseNewAlert)}"> <fmt:message key="fcm.sq.queue.days.txt"/>
				</td>
			</tr>
			<tr><td>&nbsp;</td></tr>
		</table>

		<table id="addCallResultSection" width="100%" border="0" cellspacing="0" cellpadding="0" style="display:none">
			<tr align="left">
				<td align="left" class="configurationTableFooter2" colspan="2">
				<fmt:message key="fcm.sq.queue.addCallResult.txt"/>:
					<select id="availableCallResults" class="famSelect" style="min-width:25em;font-size:10;margin:2px;" onclick="createQCRSection(this);">
						<option><fmt:message key="fcm.sq.queue.selectCallResult.txt"/>&nbsp;&nbsp;</option>
					</select>
				</td>
			</tr>
		</table>
	</td>
</tr>


<%-- end of top main table/div --%>
</table>
</div>

<%-- QCR templates --%>

<jsp:include page="queueCallResult.jsp"/>


<%-- Hidden menus --%>
<%-- Emails --%>
<div id="addEmailsDiv" style="visibility:hidden;position:absolute;z-index:30;">
 	<table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
		<tr>
			<td align="left">
				<div id="unassignedEmailsContainer" style="display:inline">
					<select name="unassignedEmailsListbox" class="famSelect" style="width:25em" size="6" multiple >
					</select>
				</div>
				<script>
					loadListboxByAssignment(emailList,'unassignedEmailsContainer',false);
				</script>
			</td>
		</tr>
		<tr>
			<td align="left">
				<input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onclick="moveSelectedOptions(document.queueForm.unassignedEmailsListbox,document.queueForm.assignedEmailsListbox,true,emailList);hideDropDownMenu('addEmails',[document.queueForm.assignedEmailsListbox]);selectDefaultItem(event,'assignedEmailsListbox');">
				<input id="addEmailsClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onclick="hideDropDownMenu('addEmails',[document.queueForm.assignedEmailsListbox])">
			</td>
		</tr>
	</table>
</div>
<%-- Letters --%>
<div id="addLettersDiv" style="visibility:hidden;position:absolute;z-index:30;">
 	<table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
		<tr>
			<td align="left">
				<div id="unassignedLettersContainer" style="display:inline">
					<select name="unassignedLettersListbox" class="famSelect" style="width:25em" size="6" multiple >
					</select>
				</div>
				<script>
					loadListboxByAssignment(letterList,'unassignedLettersContainer',false);
				</script>
			</td>
		</tr>
		<tr>
			<td align="left">
				<input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onclick="moveSelectedOptions(document.queueForm.unassignedLettersListbox,document.queueForm.assignedLettersListbox,true,letterList);hideDropDownMenu('addLetters',[document.queueForm.assignedLettersListbox]);selectDefaultItem(event,'assignedLettersListbox');">
				<input id="addLettersClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onclick="hideDropDownMenu('addLetters',[document.queueForm.assignedLettersListbox])">
			</td>
		</tr>
	</table>
</div>
<%-- Smss --%>
<div id="addSmssDiv" style="visibility:hidden;position:absolute;z-index:30;">
 	<table class="menuDialog" border="0" cellspacing="0" cellpadding="4">
		<tr>
			<td align="left">
				<div id="unassignedSmssContainer" style="display:inline">
					<select name="unassignedSmssListbox" class="famSelect" style="width:25em" size="6" multiple >
					</select>
				</div>
				<script>
					loadListboxByAssignment(smsList,'unassignedSmssContainer',false);
				</script>
			</td>
		</tr>
		<tr>
			<td align="left">
				<input type="button" value="<fmt:message key="fcm.details.ok.txt"/>" onclick="moveSelectedOptions(document.queueForm.unassignedSmssListbox,document.queueForm.assignedSmssListbox,true,smsList);hideDropDownMenu('addSmss',[document.queueForm.assignedSmssListbox]);selectDefaultItem(event,'assignedSmssListbox');">
				<input id="addSmssClose" type="button" value="<fmt:message key="fcm.details.cancel.txt"/>" onclick="hideDropDownMenu('addSmss',[document.queueForm.assignedSmssListbox])">
			</td>
		</tr>
	</table>
</div>

<script>
$(document).ready(function(){
	populateCallResultsSelection();
	populateSelectedCallResults();
});

	/*
	* Captures mouse clicks on the document and hides the
	* popup window that shows the relative queue priorities
	*
	*/
	window.popupWindowOldEventListener = document.onmouseup;
	if(window.popupWindowOldEventListener != null){
		document.onmouseup = new Function("window.popupWindowOldEventListener();hideQueuePriorityList();");
	}
	else{
		document.onmouseup = hideQueuePriorityList;
	}
	function ignoreEvent(evt)
	{
		if(evt.stopPropagation)
		{
		evt.stopPropagation();
		}
	}
selectDefaultItem(event,'assignedEmailsListbox');
selectDefaultItem(event,'assignedLettersListbox');
selectDefaultItem(event,'assignedSmssListbox');
</script>
<c:if test="${not empty updateQueues && !updateQueues}">
<script type="text/javascript">
$(document).ready(function(){
	setFormsReadOnly();
});
</script>
</c:if>
</form>

<div id="divCodesLookup" style="position:absolute; z-index:2;border: 1px solid #5F9EA0; background-color:white;border:1px solid #42668F;top:0px;display:none">
	<center>
		<table cellpadding="3">
			<tr style="font-weight:bold;background-color:#287eab;color:white;padding:4px;">
				<td id="divCodesLookupTitle"></td>
				<td align="right"><img src="common/images/closeX.gif" onclick="$('#divCodesLookup').hide(); return false" onMouseOver="this.style.cursor='hand';" onMouseOut="this.style.cursor='pointer'"></td>
			</tr>
			<tr>
				<td align="center" colspan="1">
					<select id="selCodes" multiple class="famTextEntry" size="10" style="max-width:500px;" onChange="return maxSel(this,'10');">
					</select>
					<br/>
					<input id="sortByName" type="radio" name="lookupSort" onclick="sortLookupCodesByName()" checked> <label for="sortByName"><fmt:message key="fcm.sq.queue.codesLookup.sortByDescription.txt"/></label>
					<input id="sortByCode" type="radio" name="lookupSort" onclick="sortLookupCodesByCode()"> <label for="sortByCode"><fmt:message key="fcm.sq.queue.codesLookup.sortByCode.txt"/></label>
				</td>
			</tr>
			<tr>
				<td align="center">
				<button class="sapMBarChild sapMBtn sapMBtnBase sasMButton" type="button" onclick="populateCodesSelectionText();$('#divCodesLookup').hide(); return false">
				  <span class="sapMBtnDefault sapMBtnHoverable sapMBtnInner sapMBtnText sapMFocusable sapMIE">
			    	<span class="sapMBtnContent"><fmt:message key='fcm.sq.queue.select.txt'/></span>
			    	<span class="sapMBtnFocusDiv"></span>
			  	  </span>
				</button>
				</td>
			</tr>
		</table>
	</center>
</div>

<script>

$(document).ready(function(){

	$(document).click(function (e){

		var $popup = $("#divCodesLookup:visible");
		if ($popup.length > 0)
		{
			var target = (e && e.target) || (event && event.srcElement);
			if (target.id && target.id.indexOf('Lookup')!=-1)
				return;

			if ($("#divCodesLookup").find(target).length==0)
				$("#divCodesLookup").hide();
		}
	});
});

</script>
</div>