
<%@ page language="java" session="false" contentType="text/html; charset=UTF-8" %>
<%-- this file uses leading tabs; don't insert leading spaces --%>

<%@ include file="/common/taglibsT3.jsp" %>
<style type="text/css">@import "common/styles/cf.css";</style>
<script language="JavaScript" src="admin/scripts/models.js"></script>

<!-- Tree header. -->
<div class="sapUiTreeHeader" id="multiorgHeader" role="heading">
  <div class="sapUiTreeTitle""><fmt:message key='fcm.models.overview.title.txt' /></div>
</div>
<!-- error message -->
   <c:if test="${not empty undefinedLocation}">
	<div class="inlineMessage inlineMessageError">
		<div class="inlineMessageIcon">
			<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf22f;"></span>
		</div>
		<div class="inlineMessageMessage">
				<fmt:message key = "${esapi:encodeForHTML(undefinedLocation)}"/>
		</div>
		<div class="inlineMessageClose">
			<a href="#" title="<fmt:message key="creditfraud.common.systemMessages.close.txt"/>" onclick="this.parentNode.parentNode.style.display='none';">
				<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons;" data-sap-ui-icon-content="&#xf10c;"></span>
			</a>
		</div>
	</div>
</c:if>

<!-- Nested tables with fixed height -->
<table id="overview_table" cellspacing=0 cellpadding=2 border="0"  >
   <tr>
      <td id="navcol" align="left" valign="top" nowrap>

<script language="JavaScript">
//<!--
	
	var _canModify = false;
	<c:if test="${empty updateSystemProps || updateSystemProps}">
	_canModify = true;
	</c:if>
	
	var _canAddModel=${canNewModel};
	
	parent.sas.fscf.getCurrentOverviewToolbar().setContentFor('any', _canModify,_canAddModel);

   // To identify new or modified objects
   var _selectedNode =getCookieForTab("1");
   var _openNode =_selectedNode;   
   
   var _nodeIcon = '';
   var _isSomethingSelected = false;
   var _params = new Array();

   var _scoreResultMap = new Array();
   var _modelScores =new Array();
   var _modelScoreMap=new Array();
   var _scoreResultNodeMap =new Array();

 
 <c:forEach var="modelScore" items="${modelScores}" varStatus="mStatus" >
		<c:set var="currentModelNodeId" value="${modelScore.id}"/>
		var _modelScore=new Object();
		_modelScore.id='${modelScore.id}';
		_modelScore.label='${esapi:encodeForJavaScript(esapi:encodeForHTML(modelScore.label))}';
		_modelScore.canDelete=true;
		<c:if test="${modelScore.id==-1}">
			_modelScore.canDelete=false;
		</c:if>
		_modelScore.prodRulesAssigned=false;
		<c:if test="${modelScore.scoreRules!=null}">
			<c:forEach var="prodRules" items="${modelScore.scoreRules}">	
				<c:if test="${prodRules.RULE_STATE=='Production'}">_modelScore.prodRulesAssigned=true;</c:if>
			</c:forEach>
		</c:if>
				
		var nodeId = '${modelScore.id}';
	   	_nodeIcon = 'model';   
	   	_modelScoreMap[nodeId] = _modelScore;
	   	
      	node = new Node("${esapi:encodeForJavaScript(currentModelNodeId)}","0","model","${esapi:encodeForJavaScript(esapi:encodeForHTML(modelScore.label))}",
                           "<esapi:encodeForJavaScript><fmt:message key='fcm.models.overview.model.txt'/></esapi:encodeForJavaScript>","",
                           "", "", "", 'MODEL');
      	_modelScores.push(node);
         <c:if test="${not empty sa_modelScoreId && modelScore.id == sa_modelScoreId}">
         	_isSomethingSelected = true;
         	_selectedNode = "${esapi:encodeForJavaScript(currentModelNodeId)}";
         	_openNode = "${esapi:encodeForJavaScript(currentModelNodeId)}";
         	parent.sas.fscf.getCurrentDetailToolbar().setContentFor('model', _canModify,_modelScore.canDelete);
        </c:if>
</c:forEach>  
   if(_selectedNode!='')_isSomethingSelected=true;
   
   _modelScoreTree = new Tree("_modelScoreTree", _modelScores, 0, _openNode, _selectedNode, "doMultiOrgAction(\'showDetail\');",
                         false, false, true, "common/images/tree/", "common/images/" );

   
  
   
   // Generic method defined to show selected node
   Tree.showSelectedAdminNode = function(){ _modelScoreTree.showNode();};
     
   
//-->
</script>

 </td>
   </tr>
</table>

<%-- Error handling code --%>
<tiles:insertTemplate template="/admin/adminOverviewErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="treeObj" value="_modelScoreTree" />
	<tiles:putAttribute name="showCommand" value="doMultiOrgAction" />
	<tiles:putAttribute name="showCommandArgs" value="showDetail" />
	<tiles:putAttribute name="window" value="window"/>
</tiles:insertTemplate>
