<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="admin/scripts/users.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<script type="text/javascript" src="admin/scripts/templates.js"></script>
<script type="text/javascript"  src='common/scripts/i18n.js'></script>

<div>
<%-- Error handling code --%>
<c:url var="reloadURL" value="/listTemplateTree.action?treeSelectedMessage=${message.id}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="SMS" />
</tiles:insertTemplate>


<c:choose>
	<c:when test="${message.typeCode == 'SMS'}">
		<c:set var="method" value="saveSMS" />
	</c:when>
	<c:when test="${message.typeCode == 'EML'}">
		<c:set var="method" value="saveEmail" />
	</c:when>
	<c:when test="${message.typeCode == 'LTR'}">
		<c:set var="method" value="saveLetter" />
	</c:when>
</c:choose>

<form id="extTemplateForm" action="${method}.action" method="post">
	<input type="hidden" name="method" value="${method}">

<c:if test="${message != null}">
	<input type="hidden" name="id" value="${message.id}">
	<input type="hidden" name="version" value="${message.version}">
	<input type="hidden" name="oldBusinessUnit" value="${message.oldBusinessUnit}">
</c:if>

<table class="configurationTable" style="width:600px; margin-left:5px" border="0" cellspacing="0" cellpadding="0">
    <tr align="left" valign="top" >
         <td colspan="3" class="configurationTableSectionNoHover" style="padding:5px;">
          <c:choose>
			<c:when test="${message.typeCode == 'SMS'}">
				<fmt:message key="fcm.templates.sms.definition.txt" />
			</c:when>
			<c:when test="${message.typeCode == 'EML'}">
				<fmt:message key="fcm.templates.email.definition.txt" />
			</c:when>
			<c:when test="${message.typeCode == 'LTR'}">
				<fmt:message key="fcm.templates.letter.definition.txt" />
			</c:when>
		  </c:choose>
		 </td>
   </tr>
   <tr class="configurationTableDataRow" ><td colspan="3">&nbsp;</td></tr>
      <tr class="configurationTableDataRow" valign="middle">
         <td nowrap scope="col">
			 <c:choose>
					<c:when test="${message.typeCode == 'SMS'}">
						<fmt:message key="fcm.templates.sms.id.txt" />
					</c:when>
					<c:when test="${message.typeCode == 'EML'}">
						<fmt:message key="fcm.templates.email.id.txt" />
					</c:when>
					<c:when test="${message.typeCode == 'LTR'}">
						<fmt:message key="fcm.templates.letter.id.txt" />
					</c:when>
			</c:choose>
		</td>
         <td  valign="middle" scope="col">${message.id}</td>
         <td>&nbsp;</td>
      <tr class="configurationTableDataRow" valign="middle">
         <td nowrap scope="col">
			 <c:choose>
					<c:when test="${message.typeCode == 'SMS'}">
						<fmt:message key="fcm.templates.sms.name.txt" />
					</c:when>
					<c:when test="${message.typeCode == 'EML'}">
						<fmt:message key="fcm.templates.email.name.txt" />
					</c:when>
					<c:when test="${message.typeCode == 'LTR'}">
						<fmt:message key="fcm.templates.letter.name.txt" />
					</c:when>
			</c:choose>
		</td>
         <td valign="middle" scope="col">
            <input id="name" name="name" type="text" class="famTextEntry"
               value="${esapi:encodeForHTMLAttribute(message.name)}" size="71" maxlength="50" />
         </td>
         <td>&nbsp;</td>
   </tr>
   <tr class="configurationTableDataRow" valign="middle">
      <td><fmt:message key="fcm.details.bu.txt" />: </td>
      <td valign="middle" scope="col"><select name="businessUnit" id="buId" class="famSelect">
         <c:set var="businessUnitExists" value="" />

         <c:forEach var="businessUnit" items="${businessUnits}">
            <c:choose>
            	<c:when test="${message.businessUnit == businessUnit.id}">
            		<c:set var="sltd" value="selected=\"selected\""/>
            		<c:set var="businessUnitExists" value="true" />
            	</c:when>
            	<c:otherwise>
            		<c:set var="sltd" value=""/>
		</c:otherwise>
	    </c:choose>
            <option value="${businessUnit.id}" ${sltd}>${esapi:encodeForHTML(businessUnit.name)}</option>
         </c:forEach>
         <c:if test="${empty businessUnitExists }" >
		 	<option selected="selected" value=""><fmt:message key="fcm.groups.selectBusinessUnit.txt" />&nbsp;&nbsp;</option>
		 </c:if>
        </select>
      </td>
	<td>&nbsp;</td>
    </tr>

      <tr class="configurationTableDataRow" valign="middle">
         <td nowrap scope="col">
			 <c:choose>
					<c:when test="${message.typeCode == 'SMS'}">
						<fmt:message key="fcm.templates.sms.hostKey.txt" />
					</c:when>
					<c:when test="${message.typeCode == 'EML'}">
						<fmt:message key="fcm.templates.email.hostKey.txt" />
					</c:when>
					<c:when test="${message.typeCode == 'LTR'}">
						<fmt:message key="fcm.templates.letter.hostKey.txt" />
					</c:when>
			</c:choose>
		 </td>
         <td valign="middle" scope="col">
            <input id="hostKey" name="hostKey" type="text" class="famTextEntry"
               value="${esapi:encodeForHTMLAttribute(message.hostKey)}" size="71" maxlength="20" />
         </td>
         <td>&nbsp;</td>
   </tr>
   <tr class="configurationTableDataRow"><td colspan="3">&nbsp;</td></tr>
</table>
<c:set var="queuesAssigned">
<c:if test="${fn:length(message.queues)>0}">true</c:if>
</c:set>
<input type="hidden" name="associatedQueues" id="associatedQueues" value="${queuesAssigned}"/>
</form>
</div>
<c:if test="${not empty updateTemplates && !updateTemplates}">
  <script type="text/javascript">
    setFormsReadOnly();
  </script>
</c:if>