<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/common/taglibsT3.jsp"%>


<script type="text/javascript" src="admin/scripts/incrloader.js"></script>
<script type="text/javascript" src="admin/scripts/incrvalidator.js"></script>
<script type="text/javascript" src="admin/scripts/pagination.js"></script>
<script type="text/javascript" src="admin/scripts/sort.js"></script>

<script language="JavaScript" src="admin/scripts/listboxAssignments.js"></script>

<script type="text/javascript" src="common/scripts/jquery.js"></script>
<script type="text/javascript" src="common/scripts/jquery-ui.js"></script>

<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="admin/scripts/users.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>

<c:set var="edit">
	<fmt:message key="fcm.loaders.js.Edit.txt"/>
</c:set>
<c:set var="delete">
	<fmt:message key="fcm.loaders.js.Delete.txt"/>
</c:set>
<c:set var="reset">
	<fmt:message key="fcm.loaders.js.Reset.txt"/>
</c:set>

<script>

$(document).ready(function(){
	$("img[alt='Edit']").attr("alt","${edit}");
	$("img[alt='Delete']").attr("alt","${delete}");
	$("img[alt='Reset']").attr("alt","${reset}");
	$("span[title='Delete']").attr("title","${delete}");
	$("input[name='Delete']").attr("title","${delete}");
});

</script>

<c:set var="form" value="${command}"/>
<c:if test="${empty form.gridContents}">
	<script type="text/javascript" src="admin/scripts/rowCreation.js"></script>
	<script type="text/javascript">

	//Metadata used to add a new row when no records exist
	var metatable =new Object();
	metatable.allowAdd=${metatable.allowAdd};
	metatable.allowEdit=${metatable.allowEdit};
	metatable.allowDelete=${metatable.allowDelete};

	var columns=[];

	<c:forEach var="column" items="${columns}">
		<c:set var="vals" value="${column.name}_VALS"/>
		//${column.name}: ${requestScope[vals]}
		columns.push({
			name:"${column.name}",
			displayName:"${column.displayName}",
			visible:${column.visible},
			displayType:"${column.displayType}",
			maxLength:${column.maxlength},
			isRequired:${column.required},
			type:getType("${column.type}")
		});

		var ${column.name}lovs =[];

		<c:if test="${requestScope[vals]!=null}">
			<c:forEach var="vals" items="${requestScope[vals]}">
				${column.name}lovs.push({
					code:"${vals.code}",
					codeValue:"${vals.codeValue}"
				});
			</c:forEach>
		</c:if>
	</c:forEach>

	</script>
</c:if>

<script>
/* source for the autocomplete input box */
    var availableCodes = [
	""
		<c:forEach var="item" items="${form.availableCodes}">
		, "${esapi:encodeForJavaScript(item)}"
		</c:forEach>
    ];

	var autoCompleteOption = {
		source: function(request, response) {
			var results = $.map(availableCodes, function (tag) {
				if (tag.toLowerCase().indexOf(request.term.toLowerCase()) === 0) {
					return tag;
				}
			});
        	response(results);
        },
		minLength:1,
		delay:0
	};

	function addNewRow(dstTableId)
	{
		addNewRowEx(dstTableId, autoCompleteOption);
	}

    $(document).ready(function(){
	     $("INPUT[auto='true']").autocomplete(autoCompleteOption);
	});
</script>

<style>
/* override the UL style of autocomplete input dropdown */
UL {
	list-style-type: none;
	text-align:left;
	width:200px;
}
</style>

<form action="viewTableContents.action" method="POST">
		<div valign="top" border="0" id="topDiv" name="topDiv" style="width:100%; display:block; margin:0 0 0 0;"> 
		<table border="0" style="width:100%; margin:0 0 0 0; background-color:#e8e8e8; border-bottom:1px solid #cecece" cellpadding="4">
		<TR>
			<c:if test="${not empty form.codes}" >
			   <TD nowrap align="left">
			     <B><fmt:message key="fcm.loaders.filterCriteria.txt"/></B>
				<select id="code" name="code">
<%--				<option>New</option> --%>
				<c:forEach var="item" items="${form.codes}">
					<option value="${esapi:encodeForHTMLAttribute(item)}" <c:if test="${form.selectedCode == item}">SELECTED</c:if>>${esapi:encodeForHTML(item)}</option>
				</c:forEach>
				</select>
			    <button class="sapMBarChild sapMBtn sapMBtnBase sasMButton" type="button" onclick="submitCode('true');">
				    <span class="sapMBtnDefault sapMBtnHoverable sapMBtnInner sapMBtnText sapMFocusable sapMIE">
		    		    <span class="sapMBtnContent"><fmt:message key='fcm.loaders.filter.find.txt'/></span>
		    		    <span class="sapMBtnFocusDiv"></span>
		  		    </span>
			    </button>
			   </TD>
		   </c:if>

		   <c:if test="${not empty form.pageBean && form.pageBean.pageable}">
		   <TD nowrap align="left">
		    	<fmt:message key="fcm.loaders.recordsperpage.txt" />
		    	<input type="text" name="recordsPerPage" size="2" value="${esapi:encodeForHTMLAttribute(form.pageBean.recordsPerPage)}">
			    <button class="sapMBarChild sapMBtn sapMBtnBase sasMButton" type="button" onclick="refreshCount();">
				    <span class="sapMBtnDefault sapMBtnHoverable sapMBtnInner sapMBtnText sapMFocusable sapMIE">
		    		    <span class="sapMBtnContent"><fmt:message key="fcm.details.retrieve.txt" /></span>
		    		    <span class="sapMBtnFocusDiv"></span>
		  		    </span>
			    </button>
		        <input type="hidden" name="currentPage" size="2" value="${esapi:encodeForHTMLAttribute(form.pageBean.currentPage)}">
		     	<input type="hidden" name="totalRecords" size="2" value="${esapi:encodeForHTMLAttribute(form.pageBean.totalRecords)}">
		    	<input type="hidden" name="totalPages" size="2" value="${esapi:encodeForHTMLAttribute(form.pageBean.totalPages)}">
		    	<input type="hidden" name="move" size="2" value="${esapi:encodeForHTMLAttribute(form.pageBean.move)}">
		    </TD>
		   </c:if>
		</TR>
		</table>
		</div>

		<%-- errors
		<logic:messagesPresent>
		  <bean:message key="errors.header" />
		    <table class="errorMessage" cellspacing="0" cellpadding="0" border="0" style="width:95%;" >
		      <html:messages id="error" >
				       	  	<tr align="left">
								<td  rowspan="1" style="padding:0px;vertical-align:left;align=left"><img
									src="common/images/messageError.gif"
									border="0">${esapi:encodeForHTML(error)}
								</td>
							</tr>
		      </html:messages>
			</table>
		    <bean:message key="errors.footer" />
		</logic:messagesPresent>
		--%>
		<%-- Error handling code --%>
		<c:url var="reloadURL" value="/listTableTree.action?treeSelectedItemId=${esapi:encodeForURL(form.node)}" />
		<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
			<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
			<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
			<tiles:putAttribute name="objectTypeName" value="group" />
		</tiles:insertTemplate>

		<%--Table Contents  --%>
		&nbsp;&nbsp;<table border="0" cellspacing="0" cellpadding="0" style="width:95%;" >
			<tr>
				<td valign="top" align="left">
					<c:if test="${not empty form.pageBean && form.pageBean.pageable}">
					    <div align=center>
					    	<%--  indicate required fields with asterisk in the column headers --%>
<!--							<img src="admin/images/arrow-double-left-default.gif" ALT='<fmt:message key="fcm.loaders.first.txt"/>' onclick="getRows('first');"> -->
	                   	 	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons; cursor: pointer" data-sap-ui-icon-content="&#xf044;" onclick="getRows('first');"></span>
<!--							<img src="admin/images/arrow-left-default.gif" ALT='<fmt:message key="fcm.loaders.prev.txt"/>' onclick="getRows('prev');"> -->
	                   	 	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons; cursor: pointer" data-sap-ui-icon-content="&#xf043;" onclick="getRows('prev');"></span>
<!--							<img src="admin/images/arrow-right-default.gif" ALT='<fmt:message key="fcm.loaders.next.txt"/>' onclick="getRows('next');"> -->
	                   	 	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons; cursor: pointer" data-sap-ui-icon-content="&#xf045;" onclick="getRows('next');"></span>
<!--							<img src="admin/images/arrow-double-right-default.gif" ALT='<fmt:message key="fcm.loaders.last.txt"/>' onclick="getRows('last');"> -->
	                   	 	<span class="sapUiBtnIco sapUiBtnIcoL sapUiIcon" style="font-family: sas-icons; cursor: pointer" data-sap-ui-icon-content="&#xf046;" onclick="getRows('last');"></span>
						</div>
						<div align=center>
						    <B>${esapi:encodeForHTML(form.pageBean.currentPage)}</B>&nbsp;&nbsp;<fmt:message key='fcm.loaders.of.txt'/>&nbsp;&nbsp;<B>${esapi:encodeForHTML(form.pageBean.totalPages)}</B>
						</div>
						<div align=center>
						    <fmt:message key='fcm.loaders.totalrecords.txt'/>&nbsp;&nbsp;<B>${esapi:encodeForHTML(form.pageBean.totalRecords)}</B>
						</div>
						<br>
						<div align=center>
						    <fmt:message key='fcm.loaders.asterisk.txt'/><fmt:message key='fcm.loaders.pagesave.txt'/>
						</div>
					</c:if>
					<c:if test="${not empty form.gridContents}">
					    <div align=right style="margin-left:5px;margin-right:5px">
					    	<%--  indicate required fields with asterisk in the column headers --%>
							<span style=color:red align=right><fmt:message key='fcm.loaders.asterisk.txt'/>&nbsp;&nbsp;</span><span style=color:black align=right><fmt:message key='fcm.loaders.required.txt'/></span>
						</div>
					</c:if>
					<table class="mainTable" style="width:100%;" cellpadding="0" cellspacing="0" border="0" style="margin-left:5px;margin-right:5px;">
						<tr align="left" valign="top">
							<td colspan="2" style="padding:0px;">
								<div id="collapseDiv1" style="display:inline">

										<table border="0" cellspacing="0" cellpadding="0" style="width:100%;" >
											<tr>
												<td style="padding:0px;">
													<div id="availableDiv" class="loadersGrid">
													    <%--  Display table name and number of records  --%>
														<tr align='left' valign='top' >
															<td colspan="3" class="configurationTableSectionNoHover" style="padding:5px;">
																${esapi:encodeForHTML(form.displayLabel)}<c:if test="${not empty form.selectedCode}">&nbsp;&nbsp;-&nbsp;&nbsp;${esapi:encodeForHTML(form.selectedCode)}</c:if>
															</td>
															<td align="right" colspan="4" class="configurationTableSectionNoHover" style="padding:5px;">
																<fmt:message key='fcm.loaders.grid.recordCount.txt'/>&nbsp;&nbsp;${esapi:encodeForHTML(form.row_size)}&nbsp;&nbsp;<fmt:message key='fcm.loaders.grid.rows.txt'/>
															</td>
														</tr>
													   <%--  Display records if gridcontents list is available in request --%>

															<sasldr:UpdaterDisplayTag/>

													 </div>
												</td>
											</tr>
										</table>
										<c:if test="${empty form.gridContents}">
											<div align="center" style="margin-top:20px">
												<%--  if no records display this message --%>
												<span id="noRecordsMsg"><fmt:message key="fcm.loaders.noRecordsFound.txt"/></span>
											</div>
										</c:if>
								 </div>
							</td>
						</tr>
					</table>
				</td>
				<td> &nbsp;&nbsp;&nbsp;&nbsp;</td>
			</tr>
		</table>

		<input type="hidden" name="method" value="saveTableContents">
		<input	type="hidden" name="gridId" value="${esapi:encodeForHTMLAttribute(form.gridId)}">
		<input	type="hidden" name="node" value="${esapi:encodeForHTMLAttribute(form.node)}">
		<input	type="hidden" name="tableName" id="tableName" value="${esapi:encodeForHTMLAttribute(form.table_name)}">
		<input	type="hidden" name="label" value="${esapi:encodeForHTMLAttribute(form.label)}">
		<input	type="hidden" name="gridTabName" value="${esapi:encodeForHTMLAttribute(form.table_name)}">
		<input	type="hidden" name="rowSize" value="${esapi:encodeForHTMLAttribute(form.row_size)}">
		<c:choose>
			<c:when test="${not empty form.metatable && form.metatable.allowDelete eq '1'}">
	       		<input	type="hidden" name="allowDelete" value="${esapi:encodeForHTMLAttribute(form.metatable.allowDelete)}">
	       	</c:when>
	       	<c:otherwise>
	       		<input	type="hidden" name="allowDelete" value='0' >
	       	</c:otherwise>
       	</c:choose>

		<c:choose>
			<c:when test="${not empty form.metatable && form.metatable.allowAdd eq '1'}">
	       		<input	type="hidden" name="allowAdd" value="${esapi:encodeForHTMLAttribute(form.metatable.allowAdd)}">
	       	</c:when>
	       	<c:otherwise>
	       		<input	type="hidden" name="allowAdd" value='0' >
	       	</c:otherwise>
       	</c:choose>

       	<c:choose>
			<c:when test="${not empty form.metatable && form.metatable.allowEdit eq '1'}">
	       		<input	type="hidden" name="allowEdit" value="${esapi:encodeForHTMLAttribute(form.metatable.allowEdit)}">
	       	</c:when>
	       	<c:otherwise>
	       		<input	type="hidden" name="allowEdit" value='0' >
	       	</c:otherwise>
       	</c:choose>

		<c:choose>
			<c:when test="${not empty form.pageBean && form.pageBean.pageable}">
	       		<input	type="hidden" name="paged" value="${esapi:encodeForHTMLAttribute(form.pageBean.pageable)}">
	       	</c:when>
	       	<c:otherwise>
	       		<input	type="hidden" name="paged" value='false' >
	       	</c:otherwise>
       	</c:choose>
	    <input	type="hidden" name="pageRefresh" value="">
		<c:if test="${(form.unsavedList || form.invalidRecords) && not empty form.gridContents}" >
			<script>
				updateUnsavedRows('availableTable');
			</script>
		</c:if>
</form>

		<script>
			var lbl = document.forms[0].label.value;

			if(document.forms[0].rowSize.value == 0 && (lbl == "postal_code"))
			{
			 	submitCode('false');
			}

		</script>