<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script type="text/javascript"  src="admin/scripts/users.js"></script>
<script type="text/javascript"  src="admin/scripts/preference.js"></script>

<style type="text/css">@import "common/styles/sasStyles.css";</style>

<fmt:setBundle var="entityDetailsResourceBundle"  scope="request" basename="com.sas.finserv.creditfraud.fcm.util.EntityDetailsResourceBundle" />
<script type="text/javascript"  src="admin/scripts/templates.js" type="text/javascript"></script>

<div>
<%-- Error handling code --%>
<c:url var="reloadURL" value="/listTemplateTree.action?treeSelectedMessage=${message.id}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="Call Script" />
</tiles:insertTemplate>

<form id = "callScriptDefForm" action="saveCallScript.action" method="post" onsubmit="return submitTemplateForm(this);">
<input type="hidden" name="method" value="saveCallScript">
<c:choose>
<c:when test="${message != null}">
<input type="hidden" name="id" value="${message.id}">
<input type="hidden" name="version" value="${message.version}">
<input type="hidden" name="oldBusinessUnit" value="${esapi:encodeForHTMLAttribute(message.oldBusinessUnit)}">
</c:when>
</c:choose>

<table name="callScriptDefinition" class="configurationTable" style="width:600px; margin-left: 5px"
    border="0" cellspacing="0" cellpadding="0">
    <tr align="left" valign="top" >
        <td colspan="3" class="configurationTableSectionNoHover" style="padding:5px;"><fmt:message key="fcm.templates.callScript.definition.txt" /></td>
   </tr>
   <tr class="configurationTableDataRow" ><td colspan="3">&nbsp;</td></tr>
      <tr class="configurationTableDataRow" valign="top">
         <td nowrap scope="col"> <fmt:message key="fcm.templates.callScript.id.txt" /> </td>
         <td  valign="middle" scope="col">${message.id}</td>
         <td>&nbsp;</td>
      </tr><tr class="configurationTableDataRow" ><td colspan="3">&nbsp;</td></tr>
      <tr class="configurationTableDataRow" valign="top">
         <td nowrap scope="col"> <fmt:message key="fcm.templates.callScript.name.txt" /> </td>
         <td valign="middle" scope="col">
            <input id="name" name="name" type="text" class="famTextEntry"
               value="${esapi:encodeForHTMLAttribute(message.name)}" size="71" maxlength="50" />
         </td>
         <td>&nbsp;</td>
   </tr>
   <tr class="configurationTableDataRow" ><td colspan="3">&nbsp;</td></tr>
   <tr class="configurationTableDataRow" valign="top">
      <td><fmt:message key="fcm.details.bu.txt" />: </td>
      <td valign="middle" scope="col"><select name="businessUnit" id="buId" class="famSelect">
         <c:set var="businessUnitExists" value="" />

         <c:forEach var="businessUnit" items="${businessUnits}">
            <c:choose>
            	<c:when test="${message.businessUnit == businessUnit.id}">
            		<c:set var="sltd" value="selected=\"selected\""/>
            		<c:set var="businessUnitExists" value="true" />
            	</c:when>
            	<c:otherwise>
            		<c:set var="sltd" value=""/>
		</c:otherwise>
	    </c:choose>
            <option value="${businessUnit.id}" ${sltd}>${esapi:encodeForHTML(businessUnit.name)}</option>
         </c:forEach>
         <c:if test="${empty businessUnitExists }" >
	 	<option selected="selected" value=""><fmt:message key="fcm.groups.selectBusinessUnit.txt" />&nbsp;&nbsp;</option>
	 </c:if>
        </select><br>&nbsp;
      </td>
	<td>&nbsp;</td>
    </tr>

   <tr class="configurationTableDataRow" valign="top">
     <td nowrap> <fmt:message key="fcm.templates.callScript.insertVariable.txt" /> </td>
     <td colspan="1">
        <select id="insertVariableMenu" class="famSelect" onchange="">
        	<c:forEach var="item" items="${variables}">
        		<c:set var="csValue" value="${item.group}_${item.name}"/>
        		<c:set var="csLabel"><fmt:message key="${item.group}.${item.name}" bundle="${entityDetailsResourceBundle}" /></c:set>
        		<option value="&${esapi:encodeForHTMLAttribute(csValue)}">${esapi:encodeForHTML(csLabel)}</option>
        	</c:forEach>
        </select>
	    <button class="sapMBarChild sapMBtn sapMBtnBase sasMButton" style="vertical-align:bottom" type="button" onclick="insertAtCursor(document.forms[0].text, document.forms[0].insertVariableMenu);">
		  <span class="sapMBtnDefault sapMBtnHoverable sapMBtnInner sapMBtnText sapMFocusable sapMIE">
    		<span class="sapMBtnContent"><fmt:message key="fcm.templates.callScript.insert.txt" /></span>
    		<span class="sapMBtnFocusDiv"></span>
  		  </span>
	    </button>
  		<span class="formFieldDesc"><fmt:message key="fcm.templates.callScript.insertInstruction.fmt.txt" >
    	    <fmt:param><br/></fmt:param>
          </fmt:message>
        </span>
<!--        <br/> <fmt:message key="fcm.templates.callScript.insertInstruction.fmt.txt" >
        	<fmt:param><br/></fmt:param>
              </fmt:message> &nbsp; -->
     </td>
     <td>&nbsp;</td>
   </tr>

   <tr  class="configurationTableDataRow" valign="top">
      <td nowrap> <fmt:message key="fcm.templates.callScript.text.txt" /> </td>
      <td><textarea class="famTextEntry" name="text" cols="100" rows="20" wrap="PHYSICAL"
      		id="text" maxLength="${callScriptMaxSize}"
            onselect="captureCursorPosition(this);"
            onclick="captureCursorPosition(this);"
            ondblclick="captureCursorPosition(this);"
            onkeydown="captureCursorPosition(this);"
            onkeyup="captureCursorPosition(this);">${esapi:encodeForHTML(message.text)}</textarea>
      </td>
      <td>&nbsp;</td>
   </tr>
   <tr class="configurationTableDataRow" ><td colspan="3">&nbsp;</td></tr>

</table>
<c:set var="strategiesAssigned">
<c:if test="${fn:length(message.strategies)>0}">true</c:if>
</c:set>
<input type="hidden" name="associatedStrategies" id="associatedStrategies" value="${strategiesAssigned}"/>


</form>
</div>

<c:if test="${not empty updateTemplates && !updateTemplates}">
  <script language="JavaScript" type="text/javascript">
    setFormsReadOnly();
  </script>
</c:if>
