<%@ page contentType="text/html; charset=UTF-8" %>
<%@ include file="/common/taglibsT3.jsp" %>

<style type="text/css">
@import "admin/styles/preference.css";
</style>

<script language="JavaScript" src="admin/scripts/dynamicRows.js"></script>
<script language="JavaScript" src="admin/scripts/preference.js"></script>
<script type="text/javascript" src="common/scripts/jquery.cascade.js"></script>
<script type="text/javascript" src="common/scripts/jquery.field.js"></script>
<script language="JavaScript" src="admin/scripts/sort.js"></script>
<script language="JavaScript" src="admin/scripts/listboxAssignments.js"></script>
<script language="JavaScript" src="admin/scripts/callResultsConfig.js"></script>

<style type="text/css">@import "common/styles/cf.css";</style>
<style type="text/css">@import "common/styles/sasStyles.css";</style>

<script language="JavaScript" type="text/javascript">
var newCRIndex = 1;

var nameInstruction=trim("<fmt:message key='fcm.preferences.callResults.defaultName.txt'/>");

var callResultTypes = [];
callResultTypes ["UNKNOWN"] = {type:"UNKNOWN", label: "<fmt:message key='fcm.preferences.callResults.type.UNKNOWN.txt'/>", autoCloseDefault: 30, typeUnknown:true, typePositive:false, typeNegative: false};
callResultTypes ["POSITIVE"] = {type:"POSITIVE", label: "<fmt:message key='fcm.preferences.callResults.type.POSITIVE.txt'/>", autoCloseDefault: 30, typeUnknown:false, typePositive:true, typeNegative: false};
callResultTypes ["NEGATIVE"] = {type:"NEGATIVE", label: "<fmt:message key='fcm.preferences.callResults.type.NEGATIVE.txt'/>", autoCloseDefault: 360, typeUnknown:false, typePositive:false, typeNegative: true};

var crs = [];
<c:forEach var="resultSetting" items="${callResults}">
crs.push ({
	id: ${resultSetting.id},
	type: "${esapi:encodeForJavaScript(resultSetting.type)}",
	name: "${esapi:encodeForJavaScript(resultSetting.callResult)}",
	typeUnknown: ${resultSetting.typeUnknown},
	typePositive: ${resultSetting.typePositive},
	typeNegative: ${resultSetting.typeNegative},
	isDeleted: false
});
</c:forEach>

var crSettings = ${initCallResultSettings_JSON};

var crUsageCounts = {};
<c:forEach var="usage" items="${usageCounts}">
crUsageCounts["${usage.resultId}"] = {
			id: "${usage.resultId}",
			alertCount: ${usage.alertCount},
			strategyCount: ${usage.strategyCount},
			queueCount: ${usage.queueCount},
			details: []
		};
</c:forEach>

<c:forEach var="usage" items="${usageDetails}">
crUsageCounts["${usage.resultId}"].details.push( {
			businessUnitName: "${esapi:encodeForJavaScript(usage.businessUnitName)}",
			strategyName: "${esapi:encodeForJavaScript(usage.strategyName)}",
			queueName: "${esapi:encodeForJavaScript(usage.queueName)}"
		});
</c:forEach>

<%-- SYSTEM BLOCKS --%>
var sysBlocksByCallResult = {};
<c:forEach var="rs" items="${callResults}">
	sysBlocksByCallResult["${rs.id}"] = [];
	<c:forEach var="systemBlock" items="${systemBlocks}">
		<c:set var="sysBlockAssigned" value="false"/>
		<c:set var="index" value="cr${rs.id}"/>
		<c:forEach var="sysBlock" items="${initCallResultSettings_Map[index].systemBlocks}">
			<c:if test="${fn:trim(sysBlock.blockCode) == systemBlock.blockCode}">
			<c:set var="sysBlockAssigned" value="true"/>
			</c:if>
		</c:forEach>
		sysBlocksByCallResult["${rs.id}"].push({
			id: "${esapi:encodeForJavaScript(systemBlock.blockCode)}",
			label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(systemBlock.blockLabel))}",
			isAssigned: ${sysBlockAssigned},
			isInitAssigned: ${sysBlockAssigned}
		});
	</c:forEach>
</c:forEach>

<%-- Transaction BLOCKS --%>
var txnBlocksByCallResult = {};
<c:forEach var="rs" items="${callResults}">
	txnBlocksByCallResult["${rs.id}"] = [];
	<c:forEach var="transactionBlock" items="${transactionBlocks}">
		<c:set var="txnBlockAssigned" value="false"/>
		<c:set var="index" value="cr${rs.id}"/>
		<c:forEach var="txnBlock" items="${initCallResultSettings_Map[index].transactionBlocks}">
			<c:if test="${fn:trim(txnBlock.blockCode) == transactionBlock.blockCode}">
			<c:set var="txnBlockAssigned" value="true"/>
			</c:if>
		</c:forEach>
		txnBlocksByCallResult["${rs.id}"].push({
			id: "${esapi:encodeForJavaScript(transactionBlock.blockCode)}",
			label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(transactionBlock.blockLabel))}",
			isAssigned: ${txnBlockAssigned},
			isInitAssigned: ${txnBlockAssigned}
		});
	</c:forEach>
</c:forEach>

var sysBlocks = [];
<c:forEach var="systemBlock" items="${systemBlocks}">
	sysBlocks.push({
		id: "${esapi:encodeForJavaScript(systemBlock.blockCode)}",
		label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(systemBlock.blockLabel))}",
		isAssigned: false
	});
</c:forEach>


<%-- Transaction BLOCKS --%>
var txnBlocks = [];
<c:forEach var="transactionBlock" items="${transactionBlocks}">
	txnBlocks.push({
		id: "${esapi:encodeForJavaScript(transactionBlock.blockCode)}",
		label: "${esapi:encodeForJavaScript(esapi:encodeForHTML(transactionBlock.blockLabel))}",
		isAssigned: false
	});
</c:forEach>

</script>

<div id="callResultsContentDiv">
<%-- TODO: Error handling code --%>
<c:url var="reloadURL" value="/viewPreferencesTree.action?treeSelectedItemId=${esapi:encodeForURL(callResultsCfgNodeId)}" />
<tiles:insertTemplate template="/admin/adminDetailErrorHandlingT3.jsp" flush="true">
	<tiles:putAttribute name="reloadURL" value="${reloadURL}" />
	<tiles:putAttribute name="refreshURL" value="${reloadURL}&refresh=true" />
	<tiles:putAttribute name="objectTypeName" value="Call Results Configuration" />
</tiles:insertTemplate>

<form id="callResultsForm" name="callResultsForm" action="<c:url value='/saveCallResultsConfig.action'/>" method="post"  onsubmit="return saveCallResultsForm(this)">

<input type="hidden" name="method" value="saveCallResults">

<!-- main content header -->
<table class="mainTable minWidthTable"  cellpadding="0" cellspacing="0" border="0" style="margin: 5px">

	<tr align="left" valign="top" >
		<td colspan="2" class="configurationTableSectionNoHover" style="padding:5px;"><fmt:message key="fcm.preferences.callResults.configuration.txt" /></td>
	</tr>

	<tr>
		<td colspan="2" style="padding: 0px;" >
			<!--
			<div id="callResultsDiv" class="preferencesGrid">
			</div>
			-->
			<!-- main content header -->
			<table id="callResultsTable"  width="100%" cellspacing="0"  cellpadding="0"  class="minWidthTable"  style="border: none; border-collapse: separate;">
				<thead>
					<tr class="tableColumnHeaderRow">
						<th nowrap width="4%" class="centeredTableHeader" style="border-top: none; font-size:0.7rem"><fmt:message key="fcm.preferences.callResults.order.header.title"/></th>
						<th nowrap width="*" class="tableHeader" style="border-top: none; font-size:0.7rem">&nbsp;
							<fmt:message key="fcm.preferences.callResults.name.header.title" />
							<img src="admin/images/WarningStatus.gif" style="vertical-align:bottom;" width="11" height="11" title="<fmt:message key='fcm.preferences.callResults.editNameWarning.txt'/>" >
						</th>
						<th nowrap width="15%" class="tableHeader" style="border-top: none; font-size:0.7rem">&nbsp;<fmt:message key="fcm.preferences.callResults.type.header.title" />&nbsp;</th>
						<th nowrap width="10%" class="tableHeader" style="border-top: none; font-size:0.7rem">&nbsp;<fmt:message key="fcm.preferences.callResults.autoClose.header.title" />&nbsp;</th>
						<th nowrap width="10%" class="tableHeader" style="border-top: none; font-size:0.7rem"> <fmt:message key="fcm.preferences.callResults.newQueueDefault.header.title"/> </th>
						<th nowrap width="20%" class="tableHeader" style="border-top: none; font-size:0.7rem">&nbsp;<fmt:message key="fcm.preferences.callResults.status.header.title" />&nbsp;</th>
						<th nowrap width="6%" class="tableHeader" style="border-top: none; border-right: none; font-size:0.7rem">&nbsp;<fmt:message key="fcm.preferences.callResults.action.header.title" />&nbsp;</th>
					</tr>
				</thead>

				<tbody id="callResultsTableBody">
				</tbody>

				<tfoot>
					<tr class="tableColumnHeaderRow">

						<td nowrap colspan="7" class="tableHeader" style="border-top: none; font-size:0.88rem">&nbsp;<fmt:message key="fcm.preferences.callResults.addCallResult.txt"/>:
							<select id="availableCallResults" class="famSelect" style="width:24em;font-size:0.88rem;margin:2px;" onclick="createCallResult(this);">
								<option><fmt:message key="fcm.preferences.callResults.selectType.txt"/></option>
								<option value="UNKNOWN"><fmt:message key="fcm.preferences.callResults.type.UNKNOWN.txt"/></option>
								<option value="POSITIVE"><fmt:message key="fcm.preferences.callResults.type.POSITIVE.txt"/></option>
								<option value="NEGATIVE"><fmt:message key="fcm.preferences.callResults.type.NEGATIVE.txt"/></option>
							</select>
							<input type="hidden" name="deletions" value=""/>
						</td>
					</tr>
				</tfoot>
			</table>

			<%-- end main content --%>

			<%-- end main content -- up/down and content --%>

		</td>
	</tr>
</table>
<!-- end main content header -->

</form>
</div>



<div id="infoPop" class="infoPop">
	<div style="text-align:left;"></div>
	<ul style="text-align:left">
	</ul>
</div>

<%-- CR templates --%>

<jsp:include page="callResultsInit.jsp"/>

<script language="JavaScript" type="text/javascript">
$(document).ready(function(){
	populateCallResults();
});

</script>

<c:if test="${not empty updateAdmins && !updateAdmins}">
	<script language="JavaScript" type="text/javascript">
	$(document).ready(function(){
			setFormsReadOnly();
	});
  	</script>
</c:if>