/*
 +-------------+----------------------------------------------------------------+
 | PRODUCT:    | SAS Fraud Management
 | FILE:       | bat_run_job2.sas
 | DESCRIPTION:| Lookup job.  Calls run job macro (fsmcm_run_job) which
 |             | generates a script to run the main macro.
 +------------------------------------------------------------------------------+
 | USAGE:      | Called by bat_run_job.sh and bat_scan_log2.sh
 +------------------------------------------------------------------------------+
 | COMMENTS:   | Calls %fsmcm_run_job
 +-------------+----------------------------------------------------------------+
 */

/*-------------------------------------------------------------------
 * Copyright (c) 2016 by SAS Institute Inc., Cary, NC 27513 USA
 *  ---All Rights Reserved.
 *-------------------------------------------------------------------*/

%global
   job_id
   script_job_id     /* bat_run_job.sh -j parameter (job ID or alias) */
   script_pid        /* bat_run_job.sh pid=$$ */
   target_db
   job_autoexec
   implement_root
   ;

%put;
%put NOTE: sysparm=&sysparm;
%put;

%let this_job_id = %scan(%substr(&sysparm,%eval(%index(&sysparm,job=)+4)),1,%str( ));

%let sasroot = %sysfunc(sysget(SASROOT));

%macro fsmcm_prep_for_job;
   %if &this_job_id eq 2 %then
   %do;
      %let script_job_id = %scan(%substr(&sysparm,%eval(%index(&sysparm,jidp=)+5)),1,%str( ));
      %let script_pid = %scan(%substr(&sysparm,%eval(%index(&sysparm,pidp=)+5)),1,%str( ));
      %let job_id = &this_job_id;
      %let target_db = %upcase(%scan(%substr(&sysparm,%eval(%index(&sysparm,db=)+3)),1,%str( )));
   %end;
   %else
   %do;
      %let script_job_id = &this_job_id;
      %let script_pid = %scan(%substr(&sysparm,%eval(%index(&sysparm,pid=)+4)),1,%str( ));
      %let anyalpha = %sysfunc(anyalpha(&this_job_id));

      filename xml_dat "&sasroot/misc/fsmcm/data/fsm_job.xml";
      libname  xml_dat xml access=READONLY;

      %let job_id =;

      data _null_;
       set xml_dat.fsm_job
        %if &anyalpha gt 0 %then
        %do;
           (where=(upcase(job_alias) = "%upcase(&script_job_id)"));
        %end;
        %else
        %do;
           (where=(job_id = &script_job_id));
        %end;
        if index(job_dvds,"fsmmeh") then
          job_target_db = 'MEH';
        else
          job_target_db = 'SOR';
        putlog job_target_db=;
        putlog job_autoexec=;
        call symputx('target_db',job_target_db);
        call symputx('job_id',job_id);
        call symputx('job_autoexec',job_autoexec);
       run;

      %if &job_id eq  %then
      %do;
         %put ERROR: Could not locate job &this_job_id.;
         endsas;
      %end;

      %if %upcase(&target_db) = MEH %then
         %let implement_root = %sysfunc(sysget(SASOSE_IMPLEMENT_HOME));
      %else
      %if %upcase(&target_db) = SOR %then
         %let implement_root = %sysfunc(sysget(SASFMCP_IMPLEMENT_HOME));
   %end;

   %if %upcase(&target_db) = MEH %then
      %let dbtype = %sysfunc(sysget(mehdbtype));
   %else
   %if %upcase(&target_db) = SOR %then
      %let dbtype = %sysfunc(sysget(sordbtype));

   %put &=dbtype;

   %if %upcase(&dbtype) = ORACLE %then
   %do;
      options set=NLS_LANG=american_america.al32utf8;
   %end;
   %else
   %if %upcase(&dbtype) = DB2 %then
   %do;
      options set=DB2CODEPAGE=1208;
   %end;
%mend fsmcm_prep_for_job;

%fsmcm_prep_for_job

%sysfunc(ifc(&job_id ne 2, %include "&job_autoexec";, ));

%macro fsmcm_chk4_g;
   %if (%index(%quote(&sysparm),BATCHINIT) gt 0) %then
   %do;
      /*-------------------------------
       * remove BATCHINIT from sysparm
       *-------------------------------*/
      data _null_;
        retain sysp "&sysparm";
        start = index(upcase(sysp),'BATCHINIT');
        sysp = substr(sysp,1,start-1)||substr(sysp,start+9);
        putlog 'SYSPARM after removing BATCHINIT: ' sysp=;
        call symput('sysparm',trim(sysp));
        stop;
       run;
   %end;

   %if %upcase(&bat_db_engine) eq ORACLE %then
   %do;
      /*------------------------------------------------------------------
       * Set oracle_extra_options to blank so the %fsmcm_run_job libnames
       * won't fail if they have that macro variable in their opts.
       *------------------------------------------------------------------*/
      %global oracle_extra_options
              oracle_extra_options_loaded;
      %let oracle_extra_options = ;
      %let oracle_extra_options_loaded = 0;
   %end;
%mend fsmcm_chk4_g;

%fsmcm_chk4_g;

%fsmcm_run_job;