/*
 +-------------+----------------------------------------------------------------+
 | PRODUCT:    | SAS Fraud Management
 | FILE:       | bat_job_sysin.sas
 | DESCRIPTION:| Common sysin for running batch jobs
 +------------------------------------------------------------------------------+
 | USAGE:      | Called by shell script generated by bat_run_job2.sas
 |             | (calls fsmcm_run_job which calls fsmcm_gen_submit_script)
 +------------------------------------------------------------------------------+
 | COMMENTS:   |
 +-------------+----------------------------------------------------------------+
 */

/*-------------------------------------------------------------------
 * Copyright (c) 2016 by SAS Institute Inc., Cary, NC 27513 USA
 *  ---All Rights Reserved.
 *-------------------------------------------------------------------*/

options mprint symbolgen;

proc options option=encoding;
 run;

%global
   job_id
   target_db
   script_pid        /* bat_run_job.sh pid=$$ */
   script_job_id     /* bat_run_job.sh -j parameter (job ID or alias) */
   macro2call
   dvds
   job_check4_parameter
   job_single_word_parameter_list
   sasroot
   implement_root
   insert_method
   bat_abort
   ;

%let bat_abort = N;
%let dvds=;
%let job_check4_parameter=;
%let job_single_word_parameter_list=;
   
%let insert_method = APPEND;

%put NOTE: Submitted job: &sysjobid;

%put NOTE: sysparm=&sysparm;


%macro fsmcm_chk4_g;
   %let key = %index(&sysparm,db=);
   %if &key gt 0 %then
      %let target_db = %upcase(%scan(%substr(&sysparm,%eval(&key+3)),1,%str( )));

   %if %upcase(&target_db) = MEH %then
      %let dbtype = %sysfunc(sysget(mehdbtype));
   %else
   %if %upcase(&target_db) = SOR %then
      %let dbtype = %sysfunc(sysget(sordbtype));

   %put &=dbtype;

   %if %upcase(&dbtype) = ORACLE %then
   %do;
      options set=NLS_LANG=american_america.al32utf8;
   %end;
   %else
   %if %upcase(&dbtype) = DB2 %then
   %do;
      options set=DB2CODEPAGE=1208;
   %end;

   %let key = %index(&sysparm,mm=);
   %if &key gt 0 %then
      %let macro2call = %scan(%substr(&sysparm,%eval(&key+3)),1,%str( ));

   %let key = %index(&sysparm,job=);
   %if &key gt 0 %then
      %let job_id = %scan(%substr(&sysparm,%eval(&key+4)),1,%str( ));

   %if &job_id eq 2 %then
   %do;
      %let script_job_id = %scan(%substr(&sysparm,%eval(%index(&sysparm,jidp=)+5)),1,%str( ));
      %let script_pid = %scan(%substr(&sysparm,%eval(%index(&sysparm,pidp=)+5)),1,%str( ));
   %end;
   %else
   %do;
      %let script_job_id = &job_id;
      %let key = %index(&sysparm,jidn=);
      %if &key gt 0 %then
         %let job_id = %scan(%substr(&sysparm,%eval(&key+5)),1,%str( ));
      %let script_pid = %scan(%substr(&sysparm,%eval(%index(&sysparm,pid=)+4)),1,%str( ));
   %end;

   %let key = %index(&sysparm,dv=);
   %if &key gt 0 %then
      %let dvds = %scan(%substr(&sysparm,%eval(&key+3)),1,%str( ));

   %let key = %index(&sysparm,job_check4_parameter=);
   %if &key gt 0 %then
      %let job_check4_parameter = %scan(%substr(&sysparm,%eval(&key+21)),1,%str( ));

   %let key = %index(&sysparm,job_single_word_parameter_list=);
   %if &key gt 0 %then
      %let job_single_word_parameter_list = %scan(%substr(&sysparm,%eval(&key+31)),1,%str( ));

   %if %upcase(&bat_db_engine) eq ORACLE %then
   %do;
      /*------------------------------------------------------------------
       * Set oracle_extra_options to blank so the job libnames won't fail
       * if they have that macro variable in their opts.
       *------------------------------------------------------------------*/
      %global oracle_extra_options
              oracle_extra_options_loaded;
      %let oracle_extra_options = ;
      %let oracle_extra_options_loaded = 0;
   %end;
%mend fsmcm_chk4_g;

%fsmcm_chk4_g;


%put NOTE: target_db=&target_db main macro=&macro2call;

%macro fsmcm_parm_check;
   %local
      already_exec
      ;

   %if &target_db ne SOR and &target_db ne MEH %then
   %do;
      %put ERROR: Target database acronym not found in sysparm. db=&target_db mm=&macro2call;
      endsas;
   %end;

   %if %length(&macro2call) eq 0 %then
   %do;
      %put ERROR: Macro to call was not found in sysparm. sysparm=&sysparm;
      endsas;
   %end;

   /*------------------------------------------------------------
    * In fsmcm_run_job.sas we delimited lists with a period, now
    * change them back since we've parsed them from sysparm.
    *------------------------------------------------------------*/
   data _null_;
     string = translate("&job_single_word_parameter_list",' ','.');
     if string ne ' ' then
        call symputx('job_single_word_parameter_list',string);
     stop;
    run;

   /*--------------------------------------------
    * Job 2 is the scan log job.
    * If this isn't job 2 then verify again that
    * the job is not currently executing.
    *--------------------------------------------*/
   %if &job_id ne 2 %then
   %do;
      %let already_exec = N;

      %fsmcm_check4_job(found=already_exec);

      %if &already_exec eq Y %then
      %do;
         %put ERROR: job &job_id for database &target_db is currently executing.;
         %abort;
      %end;
   %end;

   /*------------------------------------------------------------
    * In fsmcm_run_job.sas we delimited lists with a period, now
    * change them back since we've parsed them from sysparm.
    *------------------------------------------------------------*/
   %let dvd_string=;

   data _null_;
     string = translate("&dvds",' ','.');
     if string ne ' ' then
        call symputx('dvd_string',string);
     stop;
    run;

   /*----------------------------------------------
    * Create compiled macro catalog concatenation.
    *----------------------------------------------*/
   %if %length(&dvd_string) gt 0 %then
      %fsmcm_def_sasmstore(dvds=&dvd_string,from=%str(&sasroot/cmacros));
%mend fsmcm_parm_check;

%fsmcm_parm_check;


%let wrkpath = %sysfunc(pathname(work));
x "cd &wrkpath";

%put _global_;

%macro fsmcm_echo_env;
   data _null_;
     length envvar $1024;
     envvar = sysget('SASCFGPATH');
     putlog 'SASCFGPATH=' ENVVAR;
     envlength = envlen('LIBPATH');
     if envlength ne -1 then
     do;
        envvar = sysget('LIBPATH');
        putlog 'LIBPATH=' ENVVAR;
     end;
     envlength = envlen('LD_LIBRARY_PATH');   /*Oracle SOR/MEH on LAX*/
     if envlength ne -1 then
     do;
        envvar = sysget('LD_LIBRARY_PATH');
        putlog 'LD_LIBRARY_PATH=' ENVVAR;
     end;

     envvar = sysget('PATH');
     putlog 'PATH=' ENVVAR;
     envvar = sysget('LANG');
     putlog 'LANG=' ENVVAR;

     stop;
    run;
%mend fsmcm_echo_env;

%fsmcm_echo_env;

/* for file names related to bulkload=yes */
%let job_start_dt_prefix=;

%fsmcm_get_job_start_dt_prefix;

/*----------------------------------
 * Call the main macro for this job
 * (JOB_MAIN_MACRO in fsm_job.xml)
 *----------------------------------*/
%&macro2call;

/*----------------------------------------------------------------------
 * If SAS Fraud Management created an error (%put one to the log) then
 * SYSCC might still be zero and the shell script might also return
 * zero.  In this case tell SAS to return an error return code so the
 * shell script will also return it.  For example after running a job
 * with an invalid table parameter value:
 * $ bat_run_job.sh -j 9000 -s "TAB=ZZZZ"
 * $ echo $?
 * 4
 *----------------------------------------------------------------------*/
 
%macro fsmcm_chk4_abort;
   %if &bat_abort eq Y %then
   %do;
      %if &syscc eq 0 %then
         %abort return;
   %end;
%mend fsmcm_chk4_abort;

%fsmcm_chk4_abort