

/*-------------------------------------------------------------------
 * COPYRIGHT (C) 2006-2009 BY SAS INSTITUTE INC.,CARY NC
 *
 * Name:    A.sas
 * Purpose: Generated rule code for SAS Fraud Management engines
 * Usage:   Generated from the webapp and included into engine at run time
 *
 * Build Package ID: 0
 * Rules Built By:   SAS Institute Inc.
 * Rules Build Date: Tue Apr 09 13:55:00 EDT 2024
 *
 * SDSBuild Version: 602001.1.69.20240405150723_f0rapt62_pp
 * WebMacro Version: 6.2.20240618
 *
 * Note: This code must be included before the main engine DATA step.
 *
 *-------------------------------------------------------------------*/

/* Define miscellaneous globals used by many */
%global RPT_SOR_ROOT;
%let    RPT_SOR_ROOT = _A;

%global RPT_PACKAGE_ROOT;
%let    RPT_PACKAGE_ROOT = _A;

%global RPT_PACKAGE_ROOT_ID;
%let    RPT_PACKAGE_ROOT_ID = 1;

/* TripWire */
%global RPT_PACKAGE_COUNT;
%let    RPT_PACKAGE_COUNT = %eval(&RPT_PACKAGE_COUNT+1);

%global RPT_A_MsgAPIVersion;
%let RPT_A_MsgAPIVersion = M060100;

%global RPT_OSE_A_Build_num;
%let RPT_OSE_A_Build_num = 0;

%global RUL_A_GENERATED_BY_VERSION;
%let    RUL_A_GENERATED_BY_VERSION = 6.2.20240618;

%global RUL_USE_BUSINESS_NAMES;
%let    RUL_USE_BUSINESS_NAMES = 0 ;

%global RUL_IS_PRODUCTION_ENGINE;
%let    RUL_IS_PRODUCTION_ENGINE = %eval(not &RUL_USE_BUSINESS_NAMES);

%global RUL_MAX_RULE_COUNT;
%let    RUL_MAX_RULE_COUNT = 6000;

%global RUL_MAX_RULE_CODE_SIZE;   %* S1123249;
%let    RUL_MAX_RULE_CODE_SIZE = %qcmpres(030000); %* S1123249;

%global RUL_VNN_MAX_DATA_LENGTH;
%let    RUL_VNN_MAX_DATA_LENGTH = 22000;

%global RUL_ALERT_TYPE_CODES;
%let    RUL_ALERT_TYPE_CODES = %qcmpres(
        A C X );
%global RUL_ALERT_TYPE_SNAMS;
%let    RUL_ALERT_TYPE_SNAMS = %qcmpres(
        ACCT CARD CUST );
%global RUL_ALERT_TYPE_LNAMS;
%let    RUL_ALERT_TYPE_LNAMS = %qcmpres(
        ACCOUNT CARD CUSTOMER );
%global RUL_ALERT_TYPE_DESCS;
%let    RUL_ALERT_TYPE_DESCS = %qcmpres(
        Account!Number Card!Number Customer!Number );
%global RUL_ALERT_TYPE_MKEYS;
%let    RUL_ALERT_TYPE_MKEYS = %qcmpres(
        aqo_acct_num hqo_card_num xqo_cust_num );
%global RUL_ALERT_TYPE_PVALS;  %* S0791212;
%let    RUL_ALERT_TYPE_PVALS = %qcmpres(
        "" aqo_acct_num "" );
%global RUL_ALERT_TYPE_PTYPS;  %* S0791212;
%let    RUL_ALERT_TYPE_PTYPS = %qcmpres(
        . A . );
%global RUL_ALERT_TYPE_CVALS;  %* S0791212;
%let    RUL_ALERT_TYPE_CVALS = %qcmpres(
        xqo_cust_num xqo_cust_num xqo_cust_num );
%global RUL_ALERT_TYPE_CTYPS;  %* S0791212;
%let    RUL_ALERT_TYPE_CTYPS = %qcmpres(
        X X X );

%global rul_display_formats;
%let    rul_display_formats = %qcmpres(
        DOLLAR15.2 DATE9. DATETIME19. BEST. TIME. );

%global rul_use_missing_concat_keys;
%let    rul_use_missing_concat_keys = %qcmpres(0);

%global age_transcode_to_utf8;
%let    age_transcode_to_utf8 = 1;

%global AGE_MAX_ALERT_VARIABLE_DATA_SIZE;
%let    AGE_MAX_ALERT_VARIABLE_DATA_SIZE = %sysfunc(ifc(&sysscp eq OS,0,
        %eval(0+0)));
%put NOTE: AGE_MAX_ALERT_VARIABLE_DATA_SIZE=&age_max_alert_variable_data_size;

%global RUL_HIGHLIGHT_ALERT_TYPE_CODE;
%let    RUL_HIGHLIGHT_ALERT_TYPE_CODE = %qcmpres( );

%global RUL_ENABLE_XAMS;
%let    RUL_ENABLE_XAMS = %qcmpres(1);

%global RUL_Max_Highlights_Per_Rule;
%let    RUL_Max_Highlights_Per_Rule = 0;
%global RUL_Max_Highlight_Expr_Length;
%let    RUL_Max_Highlight_Expr_Length = 1;

%global RUL_REALTIME_DATA_OFFSET;
%let    RUL_REALTIME_DATA_OFFSET = 8 * 750  * 1;

%global RUL_QUEUED_DATA_OFFSET;
%let    RUL_QUEUED_DATA_OFFSET = 8 * 750  * 2;

%global RUL_Tripwire_Offset;
%let    RUL_Tripwire_Offset = 8 * 750  * 3;

%global RPT_PII_CAT_FORMAT;
%let RPT_PII_CAT_FORMAT=$dataMaskAll;

%global RPT_PII_PIN_FORMAT;
%let RPT_PII_PIN_FORMAT= $DataMaskAll;

%global RPT_PII_DOB_FORMAT;
%let RPT_PII_DOB_FORMAT= $DataMaskDateYear;

%global RPT_PII_EML_FORMAT;
%let RPT_PII_EML_FORMAT= $DataMaskEmailDomain;

%global RPT_PII_PHN_FORMAT;
%let RPT_PII_PHN_FORMAT= $DataMaskStart;

%global RPT_PII_ID_FORMAT;
%let RPT_PII_ID_FORMAT= $DataMaskStart;


/*-------------------------------------------------------------------*/
/* Define expressions for detecting batch headers and trailers       */
/*                                                                   */
%global RUL_BATCH_KEYS;
%let    RUL_BATCH_KEYS = %qcmpres(taq_batch_id );
%global RUL_BATCH_HEADER_1;
%UTL_Set_Macro_Variable(RUL_BATCH_HEADER_1);
CARDS4;
not missing(taq_batch_id) and tab_rec_type='H'

;;;;
;;;;
run;
%global RUL_BATCH_TRAILER_1;
%UTL_Set_Macro_Variable(RUL_BATCH_TRAILER_1);
CARDS4;
not missing(taq_batch_id) and tab_rec_type='C'

;;;;
;;;;
run;



/*-------------------------------------------------------------------*/
/* Define lookup list for OSE via libname                            */
/* (AGE uses direct assignment to global in submitted code)          */
/*                                                                   */
%global OSE_LOOKUP_LIST_LOCATION;
%let OSE_LOOKUP_LIST_LOCATION = %sysfunc(pathname(LRULES));


/*-------------------------------------------------------------------*/
/* Create entries for the MO Nodes in this deployment                */
/*                                                                   */
%RUL_Capture_Code(WORK.MULTIORG_DICTIONARY.NODES.SOURCE,
                  mod=mod);
CARDS4;
       0 V100        1 A      GLOBAL          
       0 V100        2 AA     CREDIT          

;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Define models used for execution or to read old signatures        */
/*                                                                   */
%RUL_Capture_Code(WORK.MODEL_DICTIONARY.SCORES.SOURCE,
                  mod=mod);
CARDS4;

;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Define macro to ensure multi-org level is supported               */
/*                                                                   */
%macro OSE_Check_MultiOrgVersion_A;
	
%mend;



/*-------------------------------------------------------------------*/
/* Create entries that define components                             */
/*                                                                   */
%RUL_Capture_Code(WORK.MSG_API_DICTIONARY.COMPONENTS.SOURCE,
                  mod=mod);
CARDS4;

smh_acct_type BR  AQO AQB AQR 
smh_acct_type CC  AQO AQC 
smh_acct_type CS  AQO AQD 
smh_acct_type LC  AQO AQL 
smh_acct_type MA  AQM 
smh_acct_type NA  
smh_acct_type SL  AQO AQS 
smh_activity_detail1 DBA  DBA 
smh_activity_detail1 DCB  DCB 
smh_activity_detail1 DCC  DCC 
smh_activity_detail1 DCH  DCH 
smh_activity_detail1 DCQ  DCQ 
smh_activity_detail1 DEE  DEE 
smh_activity_detail1 DMX  DMX 
smh_activity_detail1 DNA  DNA 
smh_activity_detail1 DNC  DNC 
smh_activity_detail1 DNO  DNO 
smh_activity_detail1 DNP  DNP 
smh_activity_detail1 DNR  DNR 
smh_activity_detail1 DNS  DNS 
smh_activity_detail1 DNU  DNU 
smh_activity_detail1 DNX  DNX 
smh_activity_detail1 DPD  DPD 
smh_activity_detail1 DPP  DPP 
smh_activity_detail1 DUA  DUA 
smh_activity_detail1 DUS  DUS 
smh_activity_detail1 NAP  
smh_activity_detail2 DBA  DBA 
smh_activity_detail2 DCB  DCB 
smh_activity_detail2 DCC  DCC 
smh_activity_detail2 DCH  DCH 
smh_activity_detail2 DCQ  DCQ 
smh_activity_detail2 DEE  DEE 
smh_activity_detail2 DMX  DMX 
smh_activity_detail2 DNA  DNA 
smh_activity_detail2 DNC  DNC 
smh_activity_detail2 DNO  DNO 
smh_activity_detail2 DNP  DNP 
smh_activity_detail2 DNR  DNR 
smh_activity_detail2 DNS  DNS 
smh_activity_detail2 DNU  DNU 
smh_activity_detail2 DNX  DNX 
smh_activity_detail2 DPD  DPD 
smh_activity_detail2 DPP  DPP 
smh_activity_detail2 DUA  DUA 
smh_activity_detail2 DUS  DUS 
smh_activity_detail2 NAP  
smh_activity_detail3 DBA  DBA 
smh_activity_detail3 DCB  DCB 
smh_activity_detail3 DCC  DCC 
smh_activity_detail3 DCH  DCH 
smh_activity_detail3 DCQ  DCQ 
smh_activity_detail3 DEE  DEE 
smh_activity_detail3 DMX  DMX 
smh_activity_detail3 DNA  DNA 
smh_activity_detail3 DNC  DNC 
smh_activity_detail3 DNO  DNO 
smh_activity_detail3 DNP  DNP 
smh_activity_detail3 DNR  DNR 
smh_activity_detail3 DNS  DNS 
smh_activity_detail3 DNU  DNU 
smh_activity_detail3 DNX  DNX 
smh_activity_detail3 DPD  DPD 
smh_activity_detail3 DPP  DPP 
smh_activity_detail3 DUA  DUA 
smh_activity_detail3 DUS  DUS 
smh_activity_detail3 NAP  
smh_activity_type AB  TAQ TAB 
smh_activity_type AE  TAQ TAE TPP 
smh_activity_type BF  TBT TPP 
smh_activity_type CA  TCA 
smh_activity_type CK  TCK TPP 
smh_activity_type CP  TCP 
smh_activity_type CW  TCW TPP 
smh_activity_type DP  TDP TPP 
smh_activity_type FM  TCM 
smh_activity_type M2  TMI TMR TMC 
smh_activity_type M3  TMI TMC 
smh_activity_type MB  TMB 
smh_activity_type MC  TMC 
smh_activity_type MD  TMD 
smh_activity_type ME  TME 
smh_activity_type MI  TMI 
smh_activity_type ML  TML 
smh_activity_type MM  TMM 
smh_activity_type MO  TMO 
smh_activity_type MP  TMP 
smh_activity_type MR  TMR 
smh_activity_type MS  TMS 
smh_activity_type MT  TMT 
smh_activity_type NM  TNG 
smh_activity_type SH  TSH TPP 
smh_activity_type ST  TST TSR 
smh_activity_type UK  
smh_authenticate_mtd BT  UBT 
smh_authenticate_mtd CD  UCM 
smh_authenticate_mtd CP  UCM UCC 
smh_authenticate_mtd NA  
smh_authenticate_mtd NC  UNM 
smh_authenticate_mtd UK  
smh_channel_type B  HQO HBP 
smh_channel_type C  HQO HCT 
smh_channel_type D  HQO HCT HOB HDF 
smh_channel_type E  HQO HCT HOB 
smh_channel_type F  HFC 
smh_channel_type H  HQO HBB 
smh_channel_type M  HQO HCP 
smh_channel_type N  
smh_channel_type O  HQO HOB 
smh_channel_type P  HQO HPB 
smh_channel_type R  HQO HOT 
smh_channel_type S  HDF HQM 
smh_channel_type T  HQM 
smh_channel_type U  HQO 
smh_channel_type W  HQO HOB HDF 
smh_cust_type B  XQO 
smh_cust_type I  XQO 
smh_cust_type N  
smh_tran_type CMD  SMH SCC L## 
smh_tran_type DMA  SMH SRP SDA 
smh_tran_type MON  SMH 
smh_tran_type TRX  SMH SRP SUS SMC RRR RQO RUA ROB RDK RUR RRF CMX CQV 
                   ZMD Z## L## CQF WAX RUX 
;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Create entries that define template field metadata                */
/*                                                                   */
%RUL_Capture_Code(WORK.MSG_API_DICTIONARY.TEMPLATE_FIELDS.SOURCE);
CARDS4;

C.           L##l##_content_id_version          116  12$char12.   $char12.   2  
C.           L##l##_lookup_key                    8 100$char100.  $char100.  2  
C.           L##l##_seg_id_version                0   8$char8.    $char8.    2  
C.           L##l##_variable_data_length        108   8Z8.        8.         7  
C.           Z##z##_content_id_version          125  12$char12.   $char12.   2  
C.           Z##z##_content_length              117   8Z8.        8.         7  
C.           Z##z##_lookup_key                    8 100$char100.  $char100.  2  
C.           Z##z##_persist_ind                 108   1$char1.    $char1.    2  
C.           Z##z##_seg_id_version                0   8$char8.    $char8.    2  
C.           Z##z##_variable_data_length        109   8Z8.        8.         7  
C.           Z##z##_xref_01                     137  40$char40.   $char40.   2  
C.           Z##z##_xref_02                     177  40$char40.   $char40.   2  
T.           I##i##_build_num                    16   8Z8.        8.         7  
T.           I##i##_execution_build_num          24   8Z8.        8.         7  
T.           I##i##_seg_id_version                0   8$char8.    $char8.    2  
T.           I##i##_variable_data_length          8   8Z8.        8.         7  
T.           O##o##_build_num                    16   8Z8.        8.         7  
T.           O##o##_execution_build_num          24   8Z8.        8.         7  
T.           O##o##_seg_id_version                0   8$char8.    $char8.    2  
T.           O##o##_variable_data_length          8   8Z8.        8.         7  
T.           V##v##_build_num                   117   8Z8.        8.         7  
T.           V##v##_lookup_key                    8 100$char100.  $char100.  2  
T.           V##v##_persist_ind                 108   1$char1.    $char1.    2  
T.           V##v##_seg_id_version                0   8$char8.    $char8.    2  
T.           V##v##_variable_data_length        109   8Z8.        8.         7  
;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Create entries that define field metadata                         */
/*                                                                   */
%RUL_Capture_Code(WORK.MSG_API_DICTIONARY.FIELDS.SOURCE,
                  mod=mod);
CARDS4;

..           SMHsmh_seg_id_version                0   8$char8.    $char8.    2 0
..           SMHsmh_msg_version                   8   8$char8.    $char8.    2 0
..           SMHsmh_tran_type                    16   3$char3.    $char3.    2 0
..           SMHsmh_cust_type                    19   1$char1.    $char1.    2 0
..           SMHsmh_acct_type                    20   2$char2.    $char2.    2 0
..           SMHsmh_authenticate_mtd             22   2$char2.    $char2.    2 0
..           SMHsmh_channel_type                 24   1$char1.    $char1.    2 0
..           SMHsmh_activity_type                25   2$char2.    $char2.    2 0
..           SMHsmh_activity_detail1             27   3$char3.    $char3.    2 0
..           SMHsmh_activity_detail2             30   3$char3.    $char3.    2 0
..           SMHsmh_activity_detail3             33   3$char3.    $char3.    2 0
..           SMHsmh_client_tran_type             36  10$char10.   $char10.   2 0
..           SMHsmh_priority                     46   1$char1.    $char1.    2 0
..           SMHsmh_msg_type                     47   1$char1.    $char1.    2 0
..           SMHsmh_resp_req                     48   1$char1.    $char1.    2 0
..           SMHsmh_sdd_ind                      49   1$char1.    $char1.    2 0
..           SMHsmh_source                       50   8$char8.    $char8.    2 0
..           SMHsmh_dest                         58   8$char8.    $char8.    2 0
..           SMHsmh_rtn_code                     66   2$char2.    $char2.    2 0
..           SMHsmh_reason_code                  68   4$char4.    $char4.    2 0
..           SMHsmh_info1_code                   72   4$char4.    $char4.    2 0
..           SMHsmh_info2_code                   76   4$char4.    $char4.    2 0
..           SMHsmh_multi_org_name               80  16$char16.   $char16.   2 0
..           SMHsmh_multi_org_node_key           96   6$char6.    $char6.    2 0
..           SMHsmh_multi_org_id                102   4Z4.        4.         7 0
..           SMHsmh_multi_org_version           106   4$char4.    $char4.    2 0
..           SMHsmh_build_num                   110   8Z8.        8.         7 0
..           SCCscc_seg_id_version                0   8$char8.    $char8.    2 0
..           SCCscc_cmd_code                      8   4Z4.        4.         7 0
..           SCCscc_cmd_info                     12 125$char125.  $char125.  2 0
..           SRPsrp_seg_id_version                0   8$char8.    $char8.    2 0
..           SRPsrp_hops                          8   2S370FIB2.0 S370FIB2.0 7 1
..           SRPsrp_hop1_src                     10   8$char8.    $char8.    2 0
..           SRPsrp_hop1_dest                    18   8$char8.    $char8.    2 0
..           SRPsrp_hop1_stime                   26   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_hop1_etime                   34   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_hop2_src                     42   8$char8.    $char8.    2 0
..           SRPsrp_hop2_dest                    50   8$char8.    $char8.    2 0
..           SRPsrp_hop2_stime                   58   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_hop2_etime                   66   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_hop3_src                     74   8$char8.    $char8.    2 0
..           SRPsrp_hop3_dest                    82   8$char8.    $char8.    2 0
..           SRPsrp_hop3_stime                   90   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_hop3_etime                   98   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_1                 106   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_2                 114   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_3                 122   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_4                 130   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_5                 138   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_6                 146   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_7                 154   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_8                 162   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_9                 170   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_10                178   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_11                186   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_12                194   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_13                202   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_14                210   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_15                218   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_16                226   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_17                234   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_18                242   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_19                250   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_20                258   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_21                266   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_22                274   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_23                282   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_timestamp_24                290   8S370FIB8.0 S370FIB8.0 6 1
..           SRPsrp_rule_overtime               298 750$char750.  $char750.  2 1
..           SUSsus_seg_id_version                0   8$char8.    $char8.    2 0
..           SUSsus_mqe_adr_1                     8   4$char4.    $char4.    2 0
..           SUSsus_wait_reqid_1                 12   8$char8.    $char8.    2 0
..           SUSsus_oiva_adr_1                   20   4$char4.    $char4.    2 0
..           SUSsus_driver_adr_1                 24   4$char4.    $char4.    2 0
..           SUSsus_mqe_adr_2                    28   4$char4.    $char4.    2 0
..           SUSsus_wait_reqid_2                 32   8$char8.    $char8.    2 0
..           SUSsus_oiva_adr_2                   40   4$char4.    $char4.    2 0
..           SUSsus_driver_adr_2                 44   4$char4.    $char4.    2 0
..           SMCsmc_seg_id_version                0   8$char8.    $char8.    2 0
..           SMCsmc_usc_inst_id                   8  10Z10.       10.        7 0
..           SMCsmc_msg_cnt                      18   8Z8.        8.         7 0
..           SMCsmc_msg_cnt2                     26   8Z8.        8.         7 0
..           SMCsmc_sendcnt_ind                  34   1$char1.    $char1.    2 0
..           SMCsmc_ind2                         35   1$char1.    $char1.    2 0
..           SMCsmc_ind3                         36   1$char1.    $char1.    2 0
..           SMCsmc_ind4                         37   1$char1.    $char1.    2 0
..           RRRrrr_seg_id_version                0   8$char8.    $char8.    2 0
..           RRRrrr_service                       8   4$char4.    $char4.    2 0
..           RRRrrr_model_package_id             12   8$char8.    $char8.    2 0
..           RRRrrr_release_version              20   4$char4.    $char4.    2 0
..           RRRrrr_model_id_1                   24   8$char8.    $char8.    2 0
..           RRRrrr_model_version_1              32   4$char4.    $char4.    2 0
..           RRRrrr_score_1                      36   3Z3.        3.         7 0
..           RRRrrr_sup_score_1                  39   3Z3.        3.         7 0
..           RRRrrr_model_trace_1                42   4$char4.    $char4.    2 0
..           RRRrrr_risk_reason1_1               46   4Z4.        4.         7 0
..           RRRrrr_risk_reason2_1               50   4Z4.        4.         7 0
..           RRRrrr_risk_reason3_1               54   4Z4.        4.         7 0
..           RRRrrr_oper_reason1_1               58   4Z4.        4.         7 0
..           RRRrrr_oper_reason2_1               62   4Z4.        4.         7 0
..           RRRrrr_oper_reason3_1               66   4Z4.        4.         7 0
..           RRRrrr_model_id_2                   70   8$char8.    $char8.    2 0
..           RRRrrr_model_version_2              78   4$char4.    $char4.    2 0
..           RRRrrr_score_2                      82   3Z3.        3.         7 0
..           RRRrrr_sup_score_2                  85   3Z3.        3.         7 0
..           RRRrrr_model_trace_2                88   4$char4.    $char4.    2 0
..           RRRrrr_risk_reason1_2               92   4Z4.        4.         7 0
..           RRRrrr_risk_reason2_2               96   4Z4.        4.         7 0
..           RRRrrr_risk_reason3_2              100   4Z4.        4.         7 0
..           RRRrrr_oper_reason1_2              104   4Z4.        4.         7 0
..           RRRrrr_oper_reason2_2              108   4Z4.        4.         7 0
..           RRRrrr_oper_reason3_2              112   4Z4.        4.         7 0
..           RRRrrr_model_id_3                  116   8$char8.    $char8.    2 0
..           RRRrrr_model_version_3             124   4$char4.    $char4.    2 0
..           RRRrrr_score_3                     128   3Z3.        3.         7 0
..           RRRrrr_sup_score_3                 131   3Z3.        3.         7 0
..           RRRrrr_model_trace_3               134   4$char4.    $char4.    2 0
..           RRRrrr_risk_reason1_3              138   4Z4.        4.         7 0
..           RRRrrr_risk_reason2_3              142   4Z4.        4.         7 0
..           RRRrrr_risk_reason3_3              146   4Z4.        4.         7 0
..           RRRrrr_oper_reason1_3              150   4Z4.        4.         7 0
..           RRRrrr_oper_reason2_3              154   4Z4.        4.         7 0
..           RRRrrr_oper_reason3_3              158   4Z4.        4.         7 0
..           RRRrrr_model_id_4                  162   8$char8.    $char8.    2 0
..           RRRrrr_model_version_4             170   4$char4.    $char4.    2 0
..           RRRrrr_score_4                     174   3Z3.        3.         7 0
..           RRRrrr_sup_score_4                 177   3Z3.        3.         7 0
..           RRRrrr_model_trace_4               180   4$char4.    $char4.    2 0
..           RRRrrr_risk_reason1_4              184   4Z4.        4.         7 0
..           RRRrrr_risk_reason2_4              188   4Z4.        4.         7 0
..           RRRrrr_risk_reason3_4              192   4Z4.        4.         7 0
..           RRRrrr_oper_reason1_4              196   4Z4.        4.         7 0
..           RRRrrr_oper_reason2_4              200   4Z4.        4.         7 0
..           RRRrrr_oper_reason3_4              204   4Z4.        4.         7 0
..           RRRrrr_prelim_dec_code             208   1$char1.    $char1.    2 0
..           RRRrrr_action_info                 209   4$char4.    $char4.    2 0
..           RRRrrr_dnd_date                    213   8YYMMDDN8.  YYMMDD8.   5 0
..           RRRrrr_dnd_time                    221   8time8.     time8.     8 0
..           RRRrrr_action_until_date           229   8YYMMDDN8.  YYMMDD8.   5 0
..           RRRrrr_action_until_time           237   8time8.     time8.     8 0
..           RRRrrr_count                       245   2$char2.    $char2.    2 0
..           RRRrrr_action_code                 247   1$char1.    $char1.    2 0
..           RRRrrr_script_1                    248   4$char4.    $char4.    2 0
..           RRRrrr_script_2                    252   4$char4.    $char4.    2 0
..           RRRrrr_script_3                    256   4$char4.    $char4.    2 0
..           RRRrrr_script_4                    260   4$char4.    $char4.    2 0
..           RRRrrr_unused                      264   1$char1.    $char1.    2 0
..           RRRrrr_sys_rtn_code                265   4$char4.    $char4.    2 0
..           RRRrrr_sys_err_code                269   4$char4.    $char4.    2 0
..           RRRrrr_sys_err_info1               273   4$char4.    $char4.    2 0
..           RRRrrr_sys_err_info2               277   4$char4.    $char4.    2 0
..           RRRrrr_mod_rtn_code                281   4$char4.    $char4.    2 0
..           RRRrrr_mod_err_code                285   4$char4.    $char4.    2 0
..           RRRrrr_mod_err_info1               289   4$char4.    $char4.    2 0
..           RRRrrr_mod_err_info2               293   4$char4.    $char4.    2 0
..           RRRrrr_process_ind                 297   1$char1.    $char1.    2 0
..           RRRrrr_prelim_dec_until_date       298   8YYMMDDN8.  YYMMDD8.   5 0
..           RRRrrr_prelim_dec_until_time       306   8time8.     time8.     8 0
..           RRRrrr_prelim_dec_info             314   4$char4.    $char4.    2 0
..           RRRrrr_mod_rtn_code_2              318   4$char4.    $char4.    2 0
..           RRRrrr_mod_rtn_code_3              322   4$char4.    $char4.    2 0
..           RRRrrr_mod_rtn_code_4              326   4$char4.    $char4.    2 0
..           RRRrrr_mod_err_code_2              330   4$char4.    $char4.    2 0
..           RRRrrr_mod_err_code_3              334   4$char4.    $char4.    2 0
..           RRRrrr_mod_err_code_4              338   4$char4.    $char4.    2 0
..           RRRrrr_model_score_1               342   1$char1.    $char1.    2 0
..           RRRrrr_model_score_2               343   1$char1.    $char1.    2 0
..           RRRrrr_model_score_3               344   1$char1.    $char1.    2 0
..           RRRrrr_model_score_4               345   1$char1.    $char1.    2 0
..           RQOrqo_seg_id_version                0   8$char8.    $char8.    2 0
..           RQOrqo_tran_date                     8   8YYMMDDN8.  YYMMDD8.   5 0
..           RQOrqo_tran_time                    16  11time11.2   time11.2   8 0
..           RQOrqo_tran_utc_flag                27   1$char1.    $char1.    2 0
..           RQOrqo_proc_utc_datetime            28  13Z13.2      13.2       6 0
..           RQOrqo_tran_date_alt                41   8YYMMDDN8.  YYMMDD8.   5 0
..           RQOrqo_tran_time_alt                49  11time11.2   time11.2   8 0
..           RQOrqo_tran_date_client             60   8YYMMDDN8.  YYMMDD8.   5 0
..           RQOrqo_tran_time_client             68  11time11.2   time11.2   8 0
..           XQOxqo_seg_id_version                0   8$char8.    $char8.    2 0
..           XQOxqo_cust_num                      8  50$char50.   $char50.   230
..           XQOxqo_cust_rand_dig                58   3Z3.        3.         7 0
..           XQOxqo_sas_cust_rand_dig            61   3Z3.        3.         7 0
..           XQOxqo_language                     64   3$char3.    $char3.    2 0
..           XQOxqo_cust_type                    67   1$char1.    $char1.    2 0
..           XQOxqo_cust_name                    68 100$char100.  $char100.  2 0
..           XQOxqo_limit_type                  168   3$char3.    $char3.    2 0
..           XQOxqo_limit_sub_type              171   4$char4.    $char4.    2 0
..           XQOxqo_limit_amt                   175  22e22.       e22.       4 0
..           XQOxqo_limit_curr_code             197   3$char3.    $char3.    2 0
..           XQOxqo_limit_curr_conv_rate        200  22e22.       e22.       7 0
..           XQOxqo_limit_cnt                   222   3Z3.        3.         7 0
..           XQOxqo_cust_post_code              225  15$char15.   $char15.   2 0
..           XQOxqo_cust_cntry_code             240   3$char3.    $char3.    2 0
..           XQOxqo_cust_city                   243  60$char60.   $char60.   2 0
..           XQOxqo_phone                       303  15$char15.   $char15.   2 0
..           XQOxqo_address                     318 100$char100.  $char100.  2 0
..           XQOxqo_cust_birth_dt               418   8YYMMDDN8.  YYMMDD8.   5 0
..           XQOxqo_emp_flg                     426   1$char1.    $char1.    2 0
..           XQOxqo_cust_gmt_offset             427   3Z3.        3.         7 0
..           AQOaqo_seg_id_version                0   8$char8.    $char8.    2 0
..           AQOaqo_acct_num                      8  34$char34.   $char34.   230
..           AQOaqo_acct_rand_dig                42   3Z3.        3.         7 0
..           AQOaqo_sas_acct_rand_dig            45   3Z3.        3.         7 0
..           AQOaqo_billing_curr_code            48   3$char3.    $char3.    2 0
..           AQOaqo_bill_curr_conv_rate          51  22e22.       e22.       7 0
..           AQOaqo_branch_id                    73  15$char15.   $char15.   2 0
..           AQOaqo_limit_type                   88   3$char3.    $char3.    2 0
..           AQOaqo_limit_sub_type               91   4$char4.    $char4.    2 0
..           AQOaqo_limit_amt                    95  22e22.       e22.       4 0
..           AQOaqo_limit_curr_code             117   3$char3.    $char3.    2 0
..           AQOaqo_limit_curr_conv_rate        120  22e22.       e22.       7 0
..           AQOaqo_limit_cnt                   142   3Z3.        3.         7 0
..           AQOaqo_acct_post_code              145  15$char15.   $char15.   2 0
..           AQOaqo_acct_cntry_code             160   3$char3.    $char3.    2 0
..           AQOaqo_port_hier_1                 163   4$char4.    $char4.    2 0
..           AQOaqo_port_hier_2                 167   4$char4.    $char4.    2 0
..           AQOaqo_port_ind                    171   1$char1.    $char1.    2 0
..           AQCaqc_seg_id_version                0   8$char8.    $char8.    2 0
..           AQCaqc_credit_limit                  8  22e22.       e22.       4 0
..           AQCaqc_cash_limit                   30  22e22.       e22.       4 0
..           AQCaqc_client_limit                 52  22e22.       e22.       4 0
..           AQCaqc_open_to_buy                  74  22e22.       e22.       4 0
..           AQCaqc_bal                          96  22e22.       e22.       4 0
..           AQCaqc_cash_bal                    118  22e22.       e22.       4 0
..           AQCaqc_delq_days                   140   3$char3.    $char3.    2 0
..           AQDaqd_seg_id_version                0   8$char8.    $char8.    2 0
..           AQDaqd_avail_bal                     8  22e22.       e22.       4 0
..           AQDaqd_bal2_type                    30   2$char2.    $char2.    2 0
..           AQDaqd_bal2_amt                     32  22e22.       e22.       4 0
..           AQDaqd_bal3_type                    54   2$char2.    $char2.    2 0
..           AQDaqd_bal3_amt                     56  22e22.       e22.       4 0
..           AQDaqd_ovdf_limit                   78  22e22.       e22.       4 0
..           AQDaqd_acct_relationship           100   1$char1.    $char1.    2 0
..           AQSaqs_seg_id_version                0   8$char8.    $char8.    2 0
..           AQSaqs_principal_bal                 8  22e22.       e22.       4 0
..           AQLaql_seg_id_version                0   8$char8.    $char8.    2 0
..           AQLaql_remain_loc                    8  22e22.       e22.       4 0
..           AQLaql_principal_bal                30  22e22.       e22.       4 0
..           AQBaqb_seg_id_version                0   8$char8.    $char8.    2 0
..           AQBaqb_missing_opt_doc_ind           8   1$char1.    $char1.    2 0
..           AQBaqb_prm_sv_ty_cd                  9   1$char1.    $char1.    2 0
..           AQBaqb_sole_ownrsh_agrm_cde         10   2$char2.    $char2.    2 0
..           AQBaqb_brth_yrmth                   12   6YYMMN6.    YYMMN6.    5 0
..           AQBaqb_pac_open_dt                  18   8YYMMDDN8.  YYMMDD8.   5 0
..           AQBaqb_invst_obj_ind                26   1$char1.    $char1.    2 0
..           AQBaqb_inv_risk_code                27   1$char1.    $char1.    2 0
..           AQBaqb_cntry_resid                  28   3$char3.    $char3.    2 0
..           AQBaqb_total_assets_amt             31  22e22.       e22.       7 0
..           AQBaqb_total_liablties_amt          53  22e22.       e22.       7 0
..           AQBaqb_nra_ind                      75   1$char1.    $char1.    2 0
..           AQBaqb_disc_acct_ind                76   1$char1.    $char1.    2 0
..           AQBaqb_frgn_addr_ind                77   1$char1.    $char1.    2 0
..           AQBaqb_hypth_agr_ind                78   1$char1.    $char1.    2 0
..           AQBaqb_mf_dvd_trt                   79   1$char1.    $char1.    2 0
..           AQBaqb_gen_restr_ind                80   1$char1.    $char1.    2 0
..           AQBaqb_missg_na_ind                 81   1$char1.    $char1.    2 0
..           AQBaqb_poa_trt                      82   1$char1.    $char1.    2 0
..           AQBaqb_conf_acct_ind                83   1$char1.    $char1.    2 0
..           AQBaqb_529_acct_ind                 84   1$char1.    $char1.    2 0
..           AQBaqb_empl_stock_opt_ind           85   1$char1.    $char1.    2 0
..           AQBaqb_ivtmho_cd                    86   1$char1.    $char1.    2 0
..           AQBaqb_lqdnd_tmho_cd                87   1$char1.    $char1.    2 0
..           AQBaqb_client_age                   88   3$char3.    $char3.    2 0
..           AQBaqb_beneficial_owner_acct        91   1$char1.    $char1.    2 0
..           AQRaqr_seg_id_version                0   8$char8.    $char8.    2 0
..           AQRaqr_client_id                     8  20$char20.   $char20.   2 0
..           AQRaqr_lgl_enty_cd                  28   4$char4.    $char4.    2 0
..           AQRaqr_primry_acct_no               32  20$char20.   $char20.   2 0
..           AQRaqr_acct_no_prefix               52   3$char3.    $char3.    2 0
..           AQRaqr_orig_cust_acct_no            55  34$char34.   $char34.   2 0
..           AQRaqr_spa_ind                      89   1$char1.    $char1.    2 0
..           AQRaqr_pia_ind                      90   1$char1.    $char1.    2 0
..           AQRaqr_mfa_trt                      91   1$char1.    $char1.    2 0
..           AQRaqr_msp_trt                      92   1$char1.    $char1.    2 0
..           AQRaqr_consult_ind                  93   1$char1.    $char1.    2 0
..           AQRaqr_intl_ham_ind                 94   1$char1.    $char1.    2 0
..           AQRaqr_mail_service_ind             95   3$char3.    $char3.    2 0
..           AQRaqr_is_asset_power               98   1$char1.    $char1.    2 0
..           AQRaqr_emp_in_assoc_bkr_ind         99   1$char1.    $char1.    2 0
..           AQRaqr_cmp_ac_emp_rel_cd           100   1$char1.    $char1.    2 0
..           AQRaqr_emp_asso_ind                101   1$char1.    $char1.    2 0
..           AQRaqr_fa_related_ind              102   1$char1.    $char1.    2 0
..           AQRaqr_cli_sfpf_cd                 103   1$char1.    $char1.    2 0
..           AQRaqr_rltd_pty_ind                104   1$char1.    $char1.    2 0
..           AQMaqm_seg_id_version                0   8$char8.    $char8.    2 0
..           AQMaqm_mer_id                        8  15$char15.   $char15.   2 0
..           AQMaqm_mer_mcc                      23   4$char4.    $char4.    2 0
..           AQMaqm_term_name                    27  40$char40.   $char40.   2 0
..           AQMaqm_acq_id                       67  11$char11.   $char11.   2 0
..           AQMaqm_mer_rand_dig                 78   3Z3.        3.         7 0
..           AQMaqm_sas_mer_rand_dig             81   3Z3.        3.         7 0
..           UCMucm_seg_id_version                0   8$char8.    $char8.    2 0
..           UCMucm_card_present                  8   1$char1.    $char1.    2 0
..           UCMucm_cat                           9   1$char1.    $char1.    2 0
..           UCMucm_term_pan_entry_cap           10   1$char1.    $char1.    2 0
..           UCMucm_term_pin_entry_cap           11   1$char1.    $char1.    2 0
..           UCMucm_pos                          12   2$char2.    $char2.    2 0
..           UCMucm_cust_present                 14   1$char1.    $char1.    2 0
..           UCMucm_cvv_cvc                      15   1$char1.    $char1.    2 0
..           UCMucm_cvv2_psnt                    16   1$char1.    $char1.    2 0
..           UCMucm_cvv2_resp                    17   1$char1.    $char1.    2 0
..           UCMucm_avs_resp                     18   1$char1.    $char1.    2 0
..           UCMucm_avs_post_code                19  15$char15.   $char15.   2 0
..           UCMucm_pin_vrfy                     34   1$char1.    $char1.    2 0
..           UCMucm_msg_exp_date                 35   8YYMMDDN8.  YYMMDD8.   5 0
..           UCMucm_card_exp_date                43   8YYMMDDN8.  YYMMDD8.   5 0
..           UCMucm_scheme                       51   1$char1.    $char1.    2 0
..           UCMucm_source                       52   1$char1.    $char1.    2 0
..           UCMucm_track1_present               53   1$char1.    $char1.    2 0
..           UCMucm_track2_present               54   1$char1.    $char1.    2 0
..           UCMucm_ch_evrfy                     55   1$char1.    $char1.    2 0
..           UCMucm_acs_refer_code               56   2$char2.    $char2.    2 0
..           UCMucm_bio_verify                   58   1$char1.    $char1.    2 0
..           UCCucc_seg_id_version                0   8$char8.    $char8.    2 0
..           UCCucc_chip_data_status              8   1$char1.    $char1.    2 0
..           UCCucc_chip_data_scheme              9   1$char1.    $char1.    2 0
..           UCCucc_arqc_valid                   10   1$char1.    $char1.    2 0
..           UCCucc_atc_card                     11   4$char4.    $char4.    2 0
..           UCCucc_atc_host                     15   4$char4.    $char4.    2 0
..           UCCucc_lo_atc                       19   4$char4.    $char4.    2 0
..           UCCucc_ol_limit_host                23   2$char2.    $char2.    2 0
..           UCCucc_tvr                          25  40$char40.   $char40.   2 0
..           UCCucc_cvr                          65  48$char48.   $char48.   2 0
..           UCCucc_aip                         113   8$char8.    $char8.    2 0
..           UCCucc_tcp                         121  24$char24.   $char24.   2 0
..           UCCucc_chip_cond_code              145   1$char1.    $char1.    2 0
..           UNMunm_seg_id_version                0   8$char8.    $char8.    2 0
..           UNMunm_auth_mtd1                     8   1$char1.    $char1.    2 0
..           UNMunm_auth_result1                  9   1$char1.    $char1.    2 0
..           UNMunm_auth_mtd2                    10   1$char1.    $char1.    2 0
..           UNMunm_auth_result2                 11   1$char1.    $char1.    2 0
..           UNMunm_auth_mtd3                    12   1$char1.    $char1.    2 0
..           UNMunm_auth_result3                 13   1$char1.    $char1.    2 0
..           UNMunm_highest_sec_lvl              14   1$char1.    $char1.    2 0
..           UNMunm_num_fail                     15   1$char1.    $char1.    2 0
..           UNMunm_cust_doc_type                16  20$char20.   $char20.   2 0
..           UNMunm_cust_doc_num                 36  30$char30.   $char30.   2 0
..           UNMunm_cust_doc_issue_date          66   8YYMMDDN8.  YYMMDD8.   5 0
..           UNMunm_cust_doc_expiry_date         74   8YYMMDDN8.  YYMMDD8.   5 0
..           UBTubt_seg_id_version                0   8$char8.    $char8.    2 0
..           UBTubt_order_enter_by                8  20$char20.   $char20.   2 0
..           UBTubt_apv_mgr_nm_ind               28   1$char1.    $char1.    2 0
..           UBTubt_mgr_init                     29   5$char5.    $char5.    2 0
..           HQOhqo_seg_id_version                0   8$char8.    $char8.    2 0
..           HQOhqo_card_num                      8  20$char20.   $char20.   230
..           HQOhqo_entity_use_card              28   1$char1.    $char1.    2 0
..           HQOhqo_card_rand_dig                29   3Z3.        3.         7 0
..           HQOhqo_sas_card_rand_dig            32   3Z3.        3.         7 0
..           HQOhqo_ob_userid                    35  50$char50.   $char50.   230
..           HQOhqo_entity_use_ob_userid         85   1$char1.    $char1.    2 0
..           HQOhqo_ob_userid_rand_dig           86   3Z3.        3.         7 0
..           HQOhqo_sas_obuserid_rand_dig        89   3Z3.        3.         7 0
..           HQOhqo_pb_userid                    92  50$char50.   $char50.   230
..           HQOhqo_entity_use_pb_userid        142   1$char1.    $char1.    2 0
..           HQOhqo_pb_userid_rand_dig          143   3Z3.        3.         7 0
..           HQOhqo_sas_pbuserid_rand_dig       146   3Z3.        3.         7 0
..           HQOhqo_device_id                   149 100$char100.  $char100.  230
..           HQOhqo_device_id_type              249  10$char10.   $char10.   2 0
..           HQOhqo_device_id_rand_dig          259   3Z3.        3.         7 0
..           HQOhqo_sas_deviceid_rand_dig       262   3Z3.        3.         7 0
..           HQOhqo_limit_type                  265   3$char3.    $char3.    2 0
..           HQOhqo_limit_sub_type              268   4$char4.    $char4.    2 0
..           HQOhqo_limit_amt                   272  22e22.       e22.       4 0
..           HQOhqo_limit_curr_code             294   3$char3.    $char3.    2 0
..           HQOhqo_limit_curr_conv_rate        297  22e22.       e22.       7 0
..           HQOhqo_limit_cnt                   319   3Z3.        3.         7 0
..           HQOhqo_msg_type                    322  10$char10.   $char10.   2 0
..           HCThct_seg_id_version                0   8$char8.    $char8.    2 0
..           HCThct_seq_num                       8   3$char3.    $char3.    2 0
..           HCThct_card_purpose                 11   1$char1.    $char1.    2 0
..           HCThct_ch_post_code                 12  15$char15.   $char15.   2 0
..           HCThct_ch_cntry_code                27   3$char3.    $char3.    2 0
..           HCThct_media                        30   1$char1.    $char1.    2 0
..           HCThct_which_card                   31   2$char2.    $char2.    2 0
..           HCThct_onus_flag                    33   1$char1.    $char1.    2 0
..           HCThct_asso_dec_code                34   6$char6.    $char6.    2 0
..           HCThct_xmit_datetime                40  14$char14.   $char14.   2 0
..           HCThct_term_owner_id                54  15$char15.   $char15.   2 0
..           HCThct_mer_mcc                      69   4$char4.    $char4.    2 0
..           HCThct_term_id                      73   8$char8.    $char8.    2 0
..           HCThct_client_term_cat              81   4$char4.    $char4.    2 0
..           HCThct_term_owner_name              85  40$char40.   $char40.   2 0
..           HCThct_term_city                   125  60$char60.   $char60.   2 0
..           HCThct_term_state                  185   3$char3.    $char3.    2 0
..           HCThct_term_post_code              188  15$char15.   $char15.   2 0
..           HCThct_term_cntry_code             203   3$char3.    $char3.    2 0
..           HCThct_term_owner_name_lcl         206 100$utf8X100. $utf8X100. 2 0
..           HCThct_acq_cntry_code              306   3$char3.    $char3.    2 0
..           HCThct_acq_id                      309  11$char11.   $char11.   2 0
..           HOBhob_seg_id_version                0   8$char8.    $char8.    2 0
..           HOBhob_ip_address                    8  23$char23.   $char23.   2 0
..           HOBhob_ip_address_v6                31  39$char39.   $char39.   2 0
..           HOBhob_ip_cntry_code                70   3$char3.    $char3.    2 0
..           HOBhob_ip_city                      73  60$char60.   $char60.   2 0
..           HOBhob_ip_post_code                133  15$char15.   $char15.   2 0
..           HOBhob_ip_latitude                 148  22e22.       e22.       7 0
..           HOBhob_ip_longitude                170  22e22.       e22.       7 0
..           HOBhob_ip_isp                      192  40$char40.   $char40.   2 0
..           HOBhob_session_id                  232 100$char100.  $char100.  2 0
..           HOBhob_logon_date                  332   8YYMMDDN8.  YYMMDD8.   5 0
..           HOBhob_logon_time                  340  11time11.2   time11.2   8 0
..           HOBhob_device                      351   1$char1.    $char1.    2 0
..           HOBhob_match_ind                   352   1$char1.    $char1.    2 0
..           HOBhob_website_name                353  38$char38.   $char38.   2 0
..           HOBhob_webpage_code                391   8$char8.    $char8.    2 0
..           HDFhdf_seg_id_version                0   8$char8.    $char8.    2 0
..           HDFhdf_javascript_enable             8   1$char1.    $char1.    2 0
..           HDFhdf_dev_fp_type                   9   2$char2.    $char2.    2 0
..           HDFhdf_dev_fp_val                   11  80$char80.   $char80.   2 0
..           HDFhdf_dev_ip_address               91  23$char23.   $char23.   2 0
..           HDFhdf_dev_ip_address_v6           114  39$char39.   $char39.   2 0
..           HDFhdf_dev_lang_cd                 153   6$char6.    $char6.    2 0
..           HDFhdf_dev_country_cd              159   3$char3.    $char3.    2 0
..           HDFhdf_dev_date                    162   8YYMMDDN8.  YYMMDD8.   5 0
..           HDFhdf_dev_time                    170   8time8.     time8.     8 0
..           HDFhdf_dev_time_offset             178   3Z3.        3.         7 0
..           HDFhdf_dev_dst_ind                 181   1$char1.    $char1.    2 0
..           HDFhdf_dev_dst_act                 182   1$char1.    $char1.    2 0
..           HDFhdf_dev_cpu                     183  30$char30.   $char30.   2 0
..           HDFhdf_dev_screen_width            213   4Z4.        4.         7 0
..           HDFhdf_dev_screen_height           217   4Z4.        4.         7 0
..           HDFhdf_dev_screen_color            221   3Z3.        3.         7 0
..           HDFhdf_bwsr_os                     224   8$char8.    $char8.    2 0
..           HDFhdf_bwsr_type                   232   8$char8.    $char8.    2 0
..           HDFhdf_http_accept                 240 150$char150.  $char150.  2 0
..           HDFhdf_http_accept_encod           390  40$char40.   $char40.   2 0
..           HDFhdf_http_accept_charset         430  60$char60.   $char60.   2 0
..           HDFhdf_http_accept_lang            490  30$char30.   $char30.   2 0
..           HDFhdf_http_user_agent             520 300$char300.  $char300.  2 0
..           HDFhdf_http_referer                820 100$char100.  $char100.  2 0
..           HDFhdf_bwsr_cookie_enabled         920   1$char1.    $char1.    2 0
..           HDFhdf_server_date                 921   8YYMMDDN8.  YYMMDD8.   5 0
..           HDFhdf_server_time                 929   8time8.     time8.     8 0
..           HDFhdf_mac_addr                    937  17$char17.   $char17.   2 0
..           HPBhpb_seg_id_version                0   8$char8.    $char8.    2 0
..           HPBhpb_type                          8   1$char1.    $char1.    2 0
..           HPBhpb_id                            9  12$char12.   $char12.   2 0
..           HPBhpb_appl_type                    21   1$char1.    $char1.    2 0
..           HPBhpb_language                     22   3$char3.    $char3.    2 0
..           HPBhpb_ani_cntry_code               25   3$char3.    $char3.    2 0
..           HPBhpb_ani_num                      28  32$char32.   $char32.   240
..           HPBhpb_ani_hit_ind                  60   1$char1.    $char1.    2 0
..           HPBhpb_match_ind                    61   1$char1.    $char1.    2 0
..           HPBhpb_call_dnis                    62  10$char10.   $char10.   2 0
..           HPBhpb_staff_id                     72  10$char10.   $char10.   2 0
..           HBBhbb_seg_id_version                0   8$char8.    $char8.    2 0
..           HBBhbb_branch_id                     8   8$char8.    $char8.    2 0
..           HBBhbb_branch_name                  16  20$char20.   $char20.   2 0
..           HBBhbb_branch_state                 36   3$char3.    $char3.    2 0
..           HBBhbb_branch_post_code             39  15$char15.   $char15.   2 0
..           HBBhbb_branch_cntry_code            54   3$char3.    $char3.    2 0
..           HBBhbb_staff_id                     57  10$char10.   $char10.   2 0
..           HBBhbb_work_station_id              67  10$char10.   $char10.   2 0
..           HCPhcp_seg_id_version                0   8$char8.    $char8.    2 0
..           HCPhcp_type                          8   1$char1.    $char1.    2 0
..           HCPhcp_date                          9   8YYMMDDN8.  YYMMDD8.   5 0
..           HBPhbp_seg_id_version                0   8$char8.    $char8.    2 0
..           HBPhbp_type                          8   1$char1.    $char1.    2 0
..           HBPhbp_application                   9   1$char1.    $char1.    2 0
..           HBPhbp_date                         10   8YYMMDDN8.  YYMMDD8.   5 0
..           HBPhbp_staff_id                     18  10$char10.   $char10.   2 0
..           HBPhbp_work_station_id              28  10$char10.   $char10.   2 0
..           HOThot_seg_id_version                0   8$char8.    $char8.    2 0
..           HOThot_channel_name                  8  15$char15.   $char15.   2 0
..           HOThot_description                  23  30$char30.   $char30.   2 0
..           HFChfc_seg_id_version                0   8$char8.    $char8.    2 0
..           HFChfc_na_office_no                  8   4$char4.    $char4.    2 0
..           HFChfc_na_fc_no                     12   5$char5.    $char5.    2 0
..           HFChfc_fc_psn_no                    17  10$char10.   $char10.   2 0
..           HFChfc_wc_cd                        27   3$char3.    $char3.    2 0
..           HFChfc_rgn_no                       30   6$char6.    $char6.    2 0
..           HFChfc_fc_st_rgr_ind                36   1$char1.    $char1.    2 0
..           HFChfc_mgt_prnt_cd                  37   6$char6.    $char6.    2 0
..           HFChfc_cntry_cd                     43   3$char3.    $char3.    2 0
..           HFChfc_from_date                    46   8YYMMDDN8.  YYMMDD8.   5 0
..           HFChfc_to_date                      54   8YYMMDDN8.  YYMMDD8.   5 0
..           HFChfc_iso_cntry_cd                 62   3$char3.    $char3.    2 0
..           HFChfc_orig_main_ofc_no             65   4$char4.    $char4.    2 0
..           HFChfc_orig_fc_no                   69   5$char5.    $char5.    2 0
..           HQMhqm_seg_id_version                0   8$char8.    $char8.    2 0
..           HQMhqm_payment_method                8   1$char1.    $char1.    2 0
..           HQMhqm_payment_id                    9  80$char80.   $char80.   2 0
..           HQMhqm_sub_channel                  89   1$char1.    $char1.    2 0
..           HQMhqm_sub_channel_id               90  20$char20.   $char20.   2 0
..           HQMhqm_payment_media               110   1$char1.    $char1.    2 0
..           HQMhqm_onus_flag                   111   1$char1.    $char1.    2 0
..           HQMhqm_term_id                     112   8$char8.    $char8.    2 0
..           HQMhqm_term_city                   120  60$char60.   $char60.   2 0
..           HQMhqm_term_state                  180   3$char3.    $char3.    2 0
..           HQMhqm_term_post_code              183  15$char15.   $char15.   2 0
..           HQMhqm_term_cntry_code             198   3$char3.    $char3.    2 0
..           TCAtca_seg_id_version                0   8$char8.    $char8.    2 0
..           TCAtca_merch_amt                     8  22e22.       e22.       4 0
..           TCAtca_merch_curr_code              30   3$char3.    $char3.    2 0
..           TCAtca_client_amt                   33  22e22.       e22.       4 0
..           TCAtca_client_curr_code             55   3$char3.    $char3.    2 0
..           TCAtca_mod_amt                      58  22e22.       e22.       4 0
..           TCAtca_tran_type                    80   1$char1.    $char1.    2 0
..           TCAtca_client_tran_type             81   2$char2.    $char2.    2 0
..           TCAtca_auth_sys_dec                 83   1$char1.    $char1.    2 0
..           TCAtca_auth_sys_info                84   4$char4.    $char4.    2 0
..           TCAtca_reversal_ind                 88   1$char1.    $char1.    2 0
..           TCAtca_stand_in_ind                 89   1$char1.    $char1.    2 0
..           TCAtca_inst_credit_ind              90   1$char1.    $char1.    2 0
..           TCAtca_cash_back_amt                91  22e22.       e22.       4 0
..           TCAtca_ref_num                     113  30$char30.   $char30.   2 0
..           TCPtcp_seg_id_version                0   8$char8.    $char8.    2 0
..           TCPtcp_billing_amt                   8  22e22.       e22.       4 0
..           TCPtcp_merch_amt                    30  22e22.       e22.       4 0
..           TCPtcp_merch_curr_code              52   3$char3.    $char3.    2 0
..           TCPtcp_client_amt                   55  22e22.       e22.       4 0
..           TCPtcp_client_curr_code             77   3$char3.    $char3.    2 0
..           TCPtcp_mod_amt                      80  22e22.       e22.       4 0
..           TCPtcp_tran_type                   102   1$char1.    $char1.    2 0
..           TCPtcp_client_tran_type            103   2$char2.    $char2.    2 0
..           TCPtcp_auth_ind                    105   1$char1.    $char1.    2 0
..           TCPtcp_purchase_date               106   8YYMMDDN8.  YYMMDD8.   5 0
..           TCPtcp_purchase_time               114  11time11.2   time11.2   8 0
..           TCPtcp_purchase_utc_flag           125   1$char1.    $char1.    2 0
..           TCPtcp_cash_back_amt               126  22e22.       e22.       4 0
..           TCPtcp_reversal_ind                148   1$char1.    $char1.    2 0
..           TCPtcp_stand_in_ind                149   1$char1.    $char1.    2 0
..           TCPtcp_inst_credit_ind             150   1$char1.    $char1.    2 0
..           TCPtcp_auth_ref_number             151  30$char30.   $char30.   2 0
..           TCPtcp_post_ref_number             181  30$char30.   $char30.   2 0
..           TCMtcm_seg_id_version                0   8$char8.    $char8.    2 0
..           TCMtcm_mer_amt                       8  22e22.       e22.       4 0
..           TCMtcm_mer_curr_code                30   3$char3.    $char3.    2 0
..           TCMtcm_mod_amt                      33  22e22.       e22.       4 0
..           TCMtcm_inst_credit_ind              55   1$char1.    $char1.    2 0
..           TCMtcm_cash_back_amt                56  22e22.       e22.       4 0
..           TCMtcm_client_tran_type             78   2$char2.    $char2.    2 0
..           TCMtcm_store_id                     80  10$char10.   $char10.   2 0
..           TCMtcm_purchase_dept                90  10$char10.   $char10.   2 0
..           TCMtcm_item_code                   100  15$char15.   $char15.   2 0
..           TCMtcm_item_count                  115   4$char4.    $char4.    2 0
..           TCMtcm_shipping_address            119 100$char100.  $char100.  2 0
..           TCMtcm_shipping_city               219  60$char60.   $char60.   2 0
..           TCMtcm_shipping_state              279   3$char3.    $char3.    2 0
..           TCMtcm_shipping_post_code          282  15$char15.   $char15.   2 0
..           TCMtcm_shipping_cntry_code         297   3$char3.    $char3.    2 0
..           TCMtcm_billing_address             300 100$char100.  $char100.  2 0
..           TCMtcm_billing_city                400  60$char60.   $char60.   2 0
..           TCMtcm_billing_state               460   3$char3.    $char3.    2 0
..           TCMtcm_billing_post_code           463  15$char15.   $char15.   2 0
..           TCMtcm_billing_cntry_code          478   3$char3.    $char3.    2 0
..           TCMtcm_reversal_ind                481   1$char1.    $char1.    2 0
..           TCMtcm_stand_in_ind                482   1$char1.    $char1.    2 0
..           TCMtcm_ref_num                     483  30$char30.   $char30.   2 0
..           TCMtcm_3d_secure                   513   1$char1.    $char1.    2 0
..           TSHtsh_seg_id_version                0   8$char8.    $char8.    2 0
..           TSHtsh_tran_type                     8   1$char1.    $char1.    2 0
..           TSHtsh_ref_num                       9  30$char30.   $char30.   2 0
..           TSHtsh_tran_status                  39   1$char1.    $char1.    2 0
..           TSHtsh_status_reason                40   5$char5.    $char5.    2 0
..           TSHtsh_revision_code                45   1$char1.    $char1.    2 0
..           TSHtsh_amount_type                  46   1$char1.    $char1.    2 0
..           TSHtsh_billing_amt                  47  22e22.       e22.       4 0
..           TSHtsh_client_amt                   69  22e22.       e22.       4 0
..           TSHtsh_client_curr_code             91   3$char3.    $char3.    2 0
..           TSHtsh_mod_amt                      94  22e22.       e22.       4 0
..           TSHtsh_sch_start_date              116   8YYMMDDN8.  YYMMDD8.   5 0
..           TSHtsh_sch_end_date                124   8YYMMDDN8.  YYMMDD8.   5 0
..           TSHtsh_recurr_freq                 132   1$char1.    $char1.    2 0
..           TSHtsh_self_acct_ind               133   1$char1.    $char1.    2 0
..           TSHtsh_bill_cat                    134   2$char2.    $char2.    2 0
..           TSHtsh_bill_sub_cat                136   4$char4.    $char4.    2 0
..           TSHtsh_bill_psnt_ind               140   1$char1.    $char1.    2 0
..           TSHtsh_billing_ref_num             141  20$char20.   $char20.   2 0
..           TBTtbt_seg_id_version                0   8$char8.    $char8.    2 0
..           TBTtbt_tran_type                     8   1$char1.    $char1.    2 0
..           TBTtbt_ref_num                       9  40$char40.   $char40.   2 0
..           TBTtbt_description                  49  40$char40.   $char40.   2 0
..           TBTtbt_tran_status                  89   1$char1.    $char1.    2 0
..           TBTtbt_status_reason                90   5$char5.    $char5.    2 0
..           TBTtbt_revision_code                95   1$char1.    $char1.    2 0
..           TBTtbt_billing_amt                  96  22e22.       e22.       4 0
..           TBTtbt_tran_amt                    118  22e22.       e22.       4 0
..           TBTtbt_tran_curr_code              140   3$char3.    $char3.    2 0
..           TBTtbt_mod_amt                     143  22e22.       e22.       4 0
..           TBTtbt_sch_flag                    165   1$char1.    $char1.    2 0
..           TBTtbt_sch_ref_num                 166  30$char30.   $char30.   2 0
..           TBTtbt_direct_debt_ind             196   1$char1.    $char1.    2 0
..           TBTtbt_self_acct_ind               197   1$char1.    $char1.    2 0
..           TBTtbt_bill_cat                    198   2$char2.    $char2.    2 0
..           TBTtbt_bill_sub_cat                200   4$char4.    $char4.    2 0
..           TBTtbt_bill_psnt_ind               204   1$char1.    $char1.    2 0
..           TBTtbt_billing_ref_num             205  80$char80.   $char80.   2 0
..           TBTtbt_group_id                    285  30$char30.   $char30.   2 0
..           TBTtbt_group_amt                   315  22e22.       e22.       4 0
..           TBTtbt_group_cnt                   337   5Z5.        5.         7 0
..           TBTtbt_group_item_id               342   5Z5.        5.         7 0
..           TCKtck_seg_id_version                0   8$char8.    $char8.    2 0
..           TCKtck_tran_status                   8   1$char1.    $char1.    2 0
..           TCKtck_status_reason                 9   5$char5.    $char5.    2 0
..           TCKtck_ref_num                      14  30$char30.   $char30.   2 0
..           TCKtck_billing_amt                  44  22e22.       e22.       4 0
..           TCKtck_client_amt                   66  22e22.       e22.       4 0
..           TCKtck_client_curr_code             88   3$char3.    $char3.    2 0
..           TCKtck_mod_amt                      91  22e22.       e22.       4 0
..           TDPtdp_seg_id_version                0   8$char8.    $char8.    2 0
..           TDPtdp_billing_amt                   8  22e22.       e22.       4 0
..           TDPtdp_client_amt                   30  22e22.       e22.       4 0
..           TDPtdp_client_curr_code             52   3$char3.    $char3.    2 0
..           TDPtdp_mod_amt                      55  22e22.       e22.       4 0
..           TDPtdp_client_cash_amt              77  22e22.       e22.       4 0
..           TDPtdp_mod_cash_amt                 99  22e22.       e22.       4 0
..           TDPtdp_type                        121   1$char1.    $char1.    2 0
..           TDPtdp_client_type                 122   4$char4.    $char4.    2 0
..           TDPtdp_sch_ind                     126   1$char1.    $char1.    2 0
..           TDPtdp_sch_ref_num                 127  30$char30.   $char30.   2 0
..           TDPtdp_self_acct_ind               157   1$char1.    $char1.    2 0
..           TDPtdp_min_due                     158  22e22.       e22.       4 0
..           TDPtdp_ref_num                     180  30$char30.   $char30.   2 0
..           TDPtdp_reversal_ind                210   1$char1.    $char1.    2 0
..           TDPtdp_reversal_reason             211   2$char2.    $char2.    2 0
..           TDPtdp_batch_ind                   213   1$char1.    $char1.    2 0
..           TDPtdp_batch_cnt                   214   4Z4.        4.         7 0
..           TDPtdp_batch_id                    218  20$char20.   $char20.   2 0
..           TCWtcw_seg_id_version                0   8$char8.    $char8.    2 0
..           TCWtcw_billing_amt                   8  22e22.       e22.       4 0
..           TCWtcw_client_amt                   30  22e22.       e22.       4 0
..           TCWtcw_client_curr_code             52   3$char3.    $char3.    2 0
..           TCWtcw_mod_amt                      55  22e22.       e22.       4 0
..           TCWtcw_tran_amt                     77  22e22.       e22.       4 0
..           TCWtcw_curr_code                    99   3$char3.    $char3.    2 0
..           TCWtcw_cash_form                   102   1$char1.    $char1.    2 0
..           TCWtcw_chk_num                     103  20$char20.   $char20.   2 0
..           TCWtcw_reversal_ind                123   1$char1.    $char1.    2 0
..           TCWtcw_reversal_reason             124   2$char2.    $char2.    2 0
..           TCWtcw_ref_num                     126  30$char30.   $char30.   2 0
..           TAQtaq_seg_id_version                0   8$char8.    $char8.    2 0
..           TAQtaq_batch_id                      8  34$char34.   $char34.   2 0
..           TAQtaq_file_id                      42  34$char34.   $char34.   2 0
..           TAQtaq_batch_type                   76   4$char4.    $char4.    2 0
..           TAQtaq_batch_category               80  10$char10.   $char10.   2 0
..           TABtab_seg_id_version                0   8$char8.    $char8.    2 0
..           TABtab_rec_type                      8   1$char1.    $char1.    2 0
..           TABtab_originator_name               9  23$char23.   $char23.   2 0
..           TABtab_originator_id                32  10$char10.   $char10.   2 0
..           TABtab_svc_class_code               42   3$char3.    $char3.    2 0
..           TABtab_sec                          45   3$char3.    $char3.    2 0
..           TABtab_enty_desc                    48  10$char10.   $char10.   2 0
..           TABtab_desc_date                    58   8YYMMDDN8.  YYMMDD8.   5 0
..           TABtab_eff_date                     66   8YYMMDDN8.  YYMMDD8.   5 0
..           TABtab_text                         74  20$char20.   $char20.   2 0
..           TABtab_odfi                         94   9$char9.    $char9.    2 0
..           TABtab_batch_number                103   7Z7.        7.         7 0
..           TABtab_entry_count                 110   6Z6.        6.         7 0
..           TABtab_total_debit                 116  22e22.       e22.       4 0
..           TABtab_total_credit                138  22e22.       e22.       4 0
..           TABtab_immedidate_origin           160  10$char10.   $char10.   2 0
..           TABtab_create_date                 170   8YYMMDDN8.  YYMMDD8.   5 0
..           TABtab_create_time                 178   8time8.     time8.     8 0
..           TABtab_file_id_mod                 186   1$char1.    $char1.    2 0
..           TABtab_file_ref                    187   8$char8.    $char8.    2 0
..           TABtab_app_req_ind                 195   1$char1.    $char1.    2 0
..           TABtab_status                      196   1$char1.    $char1.    2 0
..           TABtab_creator_userid              197  50$char50.   $char50.   2 0
..           TAEtae_seg_id_version                0   8$char8.    $char8.    2 0
..           TAEtae_client_amt                    8  22e22.       e22.       4 0
..           TAEtae_client_curr_code             30   3$char3.    $char3.    2 0
..           TAEtae_mod_amt                      33  22e22.       e22.       4 0
..           TAEtae_tran_code                    55   2$char2.    $char2.    2 0
..           TAEtae_sec                          57   3$char3.    $char3.    2 0
..           TAEtae_trace_number                 60  20$char20.   $char20.   2 0
..           TAEtae_addenda_ind                  80   1$char1.    $char1.    2 0
..           TAEtae_addenda1_type                81   2$char2.    $char2.    2 0
..           TAEtae_addenda1                     83  80$char80.   $char80.   2 0
..           TAEtae_addenda2_type               163   2$char2.    $char2.    2 0
..           TAEtae_addenda2                    165  80$char80.   $char80.   2 0
..           TPPtpp_seg_id_version                0   8$char8.    $char8.    2 0
..           TPPtpp_payee_payer_ind               8   1$char1.    $char1.    2 0
..           TPPtpp_entity_type                   9   1$char1.    $char1.    2 0
..           TPPtpp_num                          10  25$char25.   $char25.   230
..           TPPtpp_name                         35  80$char80.   $char80.   2 0
..           TPPtpp_phone                       115  15$char15.   $char15.   2 0
..           TPPtpp_email                       130  80$char80.   $char80.   2 0
..           TPPtpp_social_net                  210   2$char2.    $char2.    2 0
..           TPPtpp_social_net_id               212  80$char80.   $char80.   2 0
..           TPPtpp_cntry_code                  292   3$char3.    $char3.    2 0
..           TPPtpp_city                        295  60$char60.   $char60.   2 0
..           TPPtpp_state                       355   3$char3.    $char3.    2 0
..           TPPtpp_post_code                   358  15$char15.   $char15.   2 0
..           TPPtpp_bank_type                   373   1$char1.    $char1.    2 0
..           TPPtpp_acct_type                   374   2$char2.    $char2.    2 0
..           TPPtpp_acct_sub_type               376   1$char1.    $char1.    2 0
..           TPPtpp_bank_cntry_code             377   3$char3.    $char3.    2 0
..           TPPtpp_bank_city                   380  60$char60.   $char60.   2 0
..           TPPtpp_bank_state                  440   3$char3.    $char3.    2 0
..           TPPtpp_bank_post_code              443  15$char15.   $char15.   2 0
..           TPPtpp_bank_num                    458  15$char15.   $char15.   2 0
..           TPPtpp_bank_name                   473  90$utf8x90.  $utf8x90.  2 0
..           TPPtpp_branch_id                   563  10$char10.   $char10.   2 0
..           TPPtpp_acct_num                    573  34$char34.   $char34.   230
..           TPPtpp_curr_code                   607   3$char3.    $char3.    2 0
..           TPPtpp_tran_amt                    610  22e22.       e22.       4 0
..           TPPtpp_bal                         632  22e22.       e22.       4 0
..           TPPtpp_description                 654 100$char100.  $char100.  2 0
..           TPPtpp_address                     754  80$char80.   $char80.   2 0
..           TNGtng_seg_id_version                0   8$char8.    $char8.    2 0
..           TNGtng_tran_type                     8   2$char2.    $char2.    2 0
..           TNGtng_entity                       10   1$char1.    $char1.    2 0
..           TNGtng_details_ind                  11   1$char1.    $char1.    2 0
..           TNGtng_category                     12   1$char1.    $char1.    2 0
..           TNGtng_tran_status                  13   1$char1.    $char1.    2 0
..           TNGtng_status_reason                14   5$char5.    $char5.    2 0
..           TNGtng_sub_tran_type                19   8$char8.    $char8.    2 0
..           TNGtng_eff_date                     27   8YYMMDDN8.  YYMMDD8.   5 0
..           TNGtng_exp_date                     35   8YYMMDDN8.  YYMMDD8.   5 0
..           TMItmi_seg_id_version                0   8$char8.    $char8.    2 0
..           TMItmi_dob                           8   4$char4.    $char4.    210
..           TMItmi_emp_type                     12   1$char1.    $char1.    2 0
..           TMItmi_cust_income                  13  22e22.       e22.       4 0
..           TMItmi_cust_status                  35   1$char1.    $char1.    2 0
..           TMItmi_status_date                  36   8YYMMDDN8.  YYMMDD8.   5 0
..           TMItmi_init_flag                    44   1$char1.    $char1.    2 0
..           TMItmi_cust_since_date              45   8YYMMDDN8.  YYMMDD8.   5 0
..           TMItmi_cust_cntry_code              53   3$char3.    $char3.    2 0
..           TMItmi_cust_city                    56  60$char60.   $char60.   2 0
..           TMItmi_cust_post_code              116  15$char15.   $char15.   2 0
..           TMItmi_orig_ani_cntry_code         131   3$char3.    $char3.    2 0
..           TMItmi_orig_ani                    134  32$char32.   $char32.   240
..           TMItmi_xfr_cust_date               166   8YYMMDDN8.  YYMMDD8.   5 0
..           TMItmi_xfr_cust                    174  34$char34.   $char34.   230
..           TMItmi_vip_flag                    208   1$char1.    $char1.    2 0
..           TMItmi_staff_ind                   209   1$char1.    $char1.    2 0
..           TMBtmb_seg_id_version                0   8$char8.    $char8.    2 0
..           TMBtmb_business_open_yr              8   4$char4.    $char4.    2 0
..           TMBtmb_business_type                12   1$char1.    $char1.    2 0
..           TMBtmb_business_size                13   1$char1.    $char1.    2 0
..           TMBtmb_customer_status              14   1$char1.    $char1.    2 0
..           TMBtmb_cust_since_date              15   8YYMMDDN8.  YYMMDD8.   5 0
..           TMBtmb_cust_cntry_code              23   3$char3.    $char3.    2 0
..           TMBtmb_cust_city                    26  60$char60.   $char60.   2 0
..           TMBtmb_cust_post_code               86  15$char15.   $char15.   2 0
..           TMBtmb_cust_status                 101   1$char1.    $char1.    2 0
..           TMBtmb_status_date                 102   8YYMMDDN8.  YYMMDD8.   5 0
..           TMBtmb_init_flag                   110   1$char1.    $char1.    2 0
..           TMBtmb_xfr_cust_date               111   8YYMMDDN8.  YYMMDD8.   5 0
..           TMBtmb_xfr_cust                    119  34$char34.   $char34.   230
..           TMRtmr_seg_id_version                0   8$char8.    $char8.    2 0
..           TMRtmr_open_date                     8   8YYMMDDN8.  YYMMDD8.   5 0
..           TMRtmr_num_card                     16   3$char3.    $char3.    2 0
..           TMRtmr_client_acct_type             19   3$char3.    $char3.    2 0
..           TMRtmr_acct_status                  22   1$char1.    $char1.    2 0
..           TMRtmr_status_date                  23   8YYMMDDN8.  YYMMDD8.   5 0
..           TMRtmr_init_flag                    31   1$char1.    $char1.    2 0
..           TMRtmr_prom_incent_pgm              32   4$char4.    $char4.    2 0
..           TMRtmr_owner_type                   36   1$char1.    $char1.    2 0
..           TMRtmr_xfr_acct_date                37   8YYMMDDN8.  YYMMDD8.   5 0
..           TMRtmr_xfr_acct                     45  20$char20.   $char20.   230
..           TMRtmr_cl_change_date               65   8YYMMDDN8.  YYMMDD8.   5 0
..           TMRtmr_cyc_delq                     73   3$char3.    $char3.    2 0
..           TMRtmr_ever_delq                    76   1$char1.    $char1.    2 0
..           TMRtmr_nsf                          77   3Z3.        3.         7 0
..           TMRtmr_cum_cyc_delq                 80   3Z3.        3.         7 0
..           TMRtmr_pymt_due                     83  22e22.       e22.       4 0
..           TMDtmd_seg_id_version                0   8$char8.    $char8.    2 0
..           TMDtmd_type                          8   1$char1.    $char1.    2 0
..           TMDtmd_open_date                     9   8YYMMDDN8.  YYMMDD8.   5 0
..           TMDtmd_num_card                     17   3$char3.    $char3.    2 0
..           TMDtmd_client_acct_type             20   3$char3.    $char3.    2 0
..           TMDtmd_acct_status                  23   1$char1.    $char1.    2 0
..           TMDtmd_status_date                  24   8YYMMDDN8.  YYMMDD8.   5 0
..           TMDtmd_init_flag                    32   1$char1.    $char1.    2 0
..           TMDtmd_prom_incent_pgm              33   4$char4.    $char4.    2 0
..           TMDtmd_owner_type                   37   1$char1.    $char1.    2 0
..           TMDtmd_xfr_acct_date                38   8YYMMDDN8.  YYMMDD8.   5 0
..           TMDtmd_xfr_acct                     46  20$char20.   $char20.   230
..           TMDtmd_amt_dpst_lmth                66  22e22.       e22.       4 0
..           TMDtmd_amt_debit_lmth               88  22e22.       e22.       4 0
..           TMDtmd_card_debit_lmth             110  22e22.       e22.       4 0
..           TMDtmd_allow_ovdf_flag             132   1$char1.    $char1.    2 0
..           TMDtmd_direct_dpst_flag            133   1$char1.    $char1.    2 0
..           TMStms_seg_id_version                0   8$char8.    $char8.    2 0
..           TMStms_orig_date                     8   8YYMMDDN8.  YYMMDD8.   5 0
..           TMStms_type                         16   1$char1.    $char1.    2 0
..           TMStms_client_acct_type             17   3$char3.    $char3.    2 0
..           TMStms_status                       20   1$char1.    $char1.    2 0
..           TMStms_status_date                  21   8YYMMDDN8.  YYMMDD8.   5 0
..           TMStms_term                         29   3Z3.        3.         7 0
..           TMStms_mat_date                     32   8YYMMDDN8.  YYMMDD8.   5 0
..           TMStms_pmt_sch                      40   1$char1.    $char1.    2 0
..           TMStms_pmt_amt                      41  22e22.       e22.       4 0
..           TMStms_org_amt                      63  22e22.       e22.       4 0
..           TMStms_org_ltv                      85   3Z3.        3.         7 0
..           TMStms_init_flag                    88   1$char1.    $char1.    2 0
..           TMStms_xfr_acct_date                89   8YYMMDDN8.  YYMMDD8.   5 0
..           TMStms_xfr_acct                     97  34$char34.   $char34.   230
..           TMStms_pmt_hist                    131  12$char12.   $char12.   2 0
..           TMLtml_seg_id_version                0   8$char8.    $char8.    2 0
..           TMLtml_open_date                     8   8YYMMDDN8.  YYMMDD8.   5 0
..           TMLtml_loc_amt                      16  22e22.       e22.       4 0
..           TMLtml_exp_date                     38   8YYMMDDN8.  YYMMDD8.   5 0
..           TMLtml_client_acct_type             46   3$char3.    $char3.    2 0
..           TMLtml_status                       49   1$char1.    $char1.    2 0
..           TMLtml_status_date                  50   8YYMMDDN8.  YYMMDD8.   5 0
..           TMLtml_util_pct                     58   3Z3.        3.         7 0
..           TMLtml_init_flag                    61   1$char1.    $char1.    2 0
..           TMLtml_xfr_acct_date                62   8YYMMDDN8.  YYMMDD8.   5 0
..           TMLtml_xfr_acct                     70  34$char34.   $char34.   230
..           TMLtml_pmt_hist                    104  12$char12.   $char12.   2 0
..           TMCtmc_seg_id_version                0   8$char8.    $char8.    2 0
..           TMCtmc_ch_cntry_code                 8   3$char3.    $char3.    2 0
..           TMCtmc_ch_post_code                 11  15$char15.   $char15.   2 0
..           TMCtmc_which_card                   26   2$char2.    $char2.    2 0
..           TMCtmc_appl_src                     28   1$char1.    $char1.    2 0
..           TMCtmc_iss_date                     29   8YYMMDDN8.  YYMMDD8.   5 0
..           TMCtmc_exp_date                     37   8YYMMDDN8.  YYMMDD8.   5 0
..           TMCtmc_lst_exp_date                 45   8YYMMDDN8.  YYMMDD8.   5 0
..           TMCtmc_iss_type                     53   2$char2.    $char2.    2 0
..           TMCtmc_media                        55   1$char1.    $char1.    2 0
..           TMCtmc_card_use                     56   1$char1.    $char1.    2 0
..           TMCtmc_card_type                    57   1$char1.    $char1.    2 0
..           TMCtmc_card_status                  58   1$char1.    $char1.    2 0
..           TMCtmc_status_date                  59   8YYMMDDN8.  YYMMDD8.   5 0
..           TMCtmc_init_flag                    67   1$char1.    $char1.    2 0
..           TMCtmc_xfr_card                     68  20$char20.   $char20.   230
..           TMCtmc_xfr_card_date                88   8YYMMDDN8.  YYMMDD8.   5 0
..           TMOtmo_seg_id_version                0   8$char8.    $char8.    2 0
..           TMOtmo_reg_date                      8   8YYMMDDN8.  YYMMDD8.   5 0
..           TMOtmo_user_status                  16   1$char1.    $char1.    2 0
..           TMOtmo_status_date                  17   8YYMMDDN8.  YYMMDD8.   5 0
..           TMOtmo_init_flag                    25   1$char1.    $char1.    2 0
..           TMOtmo_xfr_user_date                26   8YYMMDDN8.  YYMMDD8.   5 0
..           TMOtmo_xfr_user                     34  50$char50.   $char50.   230
..           TMOtmo_ip_address_num               84   2Z2.        2.         7 0
..           TMOtmo_user_type                    86   5$char5.    $char5.    2 0
..           TMOtmo_user_config1                 91  10$char10.   $char10.   2 0
..           TMOtmo_user_config2                101  10$char10.   $char10.   2 0
..           TMOtmo_user_config3                111  10$char10.   $char10.   2 0
..           TMPtmp_seg_id_version                0   8$char8.    $char8.    2 0
..           TMPtmp_reg_date                      8   8YYMMDDN8.  YYMMDD8.   5 0
..           TMPtmp_user_status                  16   1$char1.    $char1.    2 0
..           TMPtmp_status_date                  17   8YYMMDDN8.  YYMMDD8.   5 0
..           TMPtmp_init_flag                    25   1$char1.    $char1.    2 0
..           TMPtmp_xfr_user_date                26   8YYMMDDN8.  YYMMDD8.   5 0
..           TMPtmp_xfr_user                     34  50$char50.   $char50.   230
..           TMPtmp_phone_cnt                    84   2Z2.        2.         7 0
..           TMEtme_seg_id_version                0   8$char8.    $char8.    2 0
..           TMEtme_staff_id                      8  10$char10.   $char10.   2 0
..           TMEtme_staff_dob                    18   4$char4.    $char4.    2 0
..           TMEtme_staff_emp_type               22   1$char1.    $char1.    2 0
..           TMEtme_client_job_title             23   8$char8.    $char8.    2 0
..           TMEtme_department                   31   2$char2.    $char2.    2 0
..           TMEtme_privilege_level              33   1$char1.    $char1.    2 0
..           TMEtme_super_staff_id               34  10$char10.   $char10.   2 0
..           TMEtme_prev_staff_id                44  10$char10.   $char10.   2 0
..           TMEtme_staff_user_id                54  32$char32.   $char32.   2 0
..           TMEtme_staff_status                 86   1$char1.    $char1.    2 0
..           TMEtme_staff_status_date            87   8YYMMDDN8.  YYMMDD8.   5 0
..           TMEtme_init_flag                    95   1$char1.    $char1.    2 0
..           TMEtme_staff_since_date             96   8YYMMDDN8.  YYMMDD8.   5 0
..           TMEtme_staff_cntry_code            104   3$char3.    $char3.    2 0
..           TMEtme_staff_city                  107  60$char60.   $char60.   2 0
..           TMEtme_staff_post_code             167  15$char15.   $char15.   2 0
..           TMEtme_branch_id                   182   8$char8.    $char8.    2 0
..           TMEtme_branch_name                 190  20$char20.   $char20.   2 0
..           TMEtme_branch_state                210   3$char3.    $char3.    2 0
..           TMEtme_branch_post_code            213  15$char15.   $char15.   2 0
..           TMEtme_branch_cntry_code           228   3$char3.    $char3.    2 0
..           TMEtme_work_station_id             231  10$char10.   $char10.   2 0
..           TMEtme_client_ind                  241   1$char1.    $char1.    2 0
..           TMEtme_staff_cust_num              242  34$char34.   $char34.   2 0
..           TMEtme_staff_acct_num_1            276  34$char34.   $char34.   2 0
..           TMEtme_staff_acct_num_2            310  34$char34.   $char34.   2 0
..           TSTtst_seg_id_version                0   8$char8.    $char8.    2 0
..           TSTtst_trds_acct_no                  8  20$char20.   $char20.   2 0
..           TSTtst_unq_trade_id                 28  16Z16.       16.        7 0
..           TSTtst_trade_status                 44   1$char1.    $char1.    2 0
..           TSTtst_trade_seq_no                 45   9$char9.    $char9.    2 0
..           TSTtst_sec_no                       54   5$char5.    $char5.    2 0
..           TSTtst_trade_dt                     59   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_settlement_dt                67   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_trade_asof_dt                75   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_prv_buy_trd_dt               83   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_buy_sell_ind                 91   1$char1.    $char1.    2 0
..           TSTtst_short_ind                    92   1$char1.    $char1.    2 0
..           TSTtst_sol_unsol_ind                93   1$char1.    $char1.    2 0
..           TSTtst_fc_executed_ind              94   1$char1.    $char1.    2 0
..           TSTtst_client_entered_cd            95   1$char1.    $char1.    2 0
..           TSTtst_put_call_ind                 96   1$char1.    $char1.    2 0
..           TSTtst_cover_uncover_ind            97   1$char1.    $char1.    2 0
..           TSTtst_open_close_ind               98   1$char1.    $char1.    2 0
..           TSTtst_opt_asgn_exer_ind            99   1$char1.    $char1.    2 0
..           TSTtst_nkd_cash_cl_ind             100   1$char1.    $char1.    2 0
..           TSTtst_opt_1st_index_trade         101   1$char1.    $char1.    2 0
..           TSTtst_opt_ooc_vltn_ind            102   1$char1.    $char1.    2 0
..           TSTtst_disc_exercised_ind          103   1$char1.    $char1.    2 0
..           TSTtst_bluesky_ind                 104   1$char1.    $char1.    2 0
..           TSTtst_fgn_curr_prefix_ind         105   1$char1.    $char1.    2 0
..           TSTtst_fgn_curr_cd                 106   3$char3.    $char3.    2 0
..           TSTtst_ord_exe_ts                  109  11time11.2   time11.2   8 0
..           TSTtst_ord_ort_ts                  120  11time11.2   time11.2   8 0
..           TSTtst_ord_mf_dop                  131   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_ord_mf_lth_ind              139   1$char1.    $char1.    2 0
..           TSTtst_mf_reason_sale              140  15$char15.   $char15.   2 0
..           TSTtst_trade_qty                   155  22e22.       e22.       7 0
..           TSTtst_trade_unit_price            177  22e22.       e22.       7 0
..           TSTtst_trade_principal             199  22e22.       e22.       7 0
..           TSTtst_tot_cost_proceed            221  22e22.       e22.       7 0
..           TSTtst_trade_commission            243  22e22.       e22.       7 0
..           TSTtst_trade_fc_credit             265  22e22.       e22.       7 0
..           TSTtst_trade_std_commission        287  22e22.       e22.       7 0
..           TSTtst_strike_price                309  22e22.       e22.       7 0
..           TSTtst_ticker_symbol               331  20$char20.   $char20.   2 0
..           TSTtst_iss_id                      351  16$char16.   $char16.   2 0
..           TSTtst_sec_type                    367   1$char1.    $char1.    2 0
..           TSTtst_sec_subtype                 368   1$char1.    $char1.    2 0
..           TSTtst_cntry_of_rgtrn_cd           369   2$char2.    $char2.    2 0
..           TSTtst_ctry_of_origin              371   3$char3.    $char3.    2 0
..           TSTtst_exch_loc_cde                374   4$char4.    $char4.    2 0
..           TSTtst_mrst_byslhl_rcm_cd          378   5$char5.    $char5.    2 0
..           TSTtst_sp_byslhl_rcm_cd            383   5$char5.    $char5.    2 0
..           TSTtst_pds_code                    388   3$char3.    $char3.    2 0
..           TSTtst_review_cd                   391   1$char1.    $char1.    2 0
..           TSTtst_offshore_ind                392   1$char1.    $char1.    2 0
..           TSTtst_prfrd_sec_ind               393   1$char1.    $char1.    2 0
..           TSTtst_strcd_by_sec_ind            394   1$char1.    $char1.    2 0
..           TSTtst_strcd_by_pdcd_ind           395   1$char1.    $char1.    2 0
..           TSTtst_emer_mkt_sec_ind            396   1$char1.    $char1.    2 0
..           TSTtst_high_yield_ind              397   1$char1.    $char1.    2 0
..           TSTtst_cefnd_hl_ind                398   1$char1.    $char1.    2 0
..           TSTtst_inception_dt                399   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_undrly_sec                  407   5$char5.    $char5.    2 0
..           TSTtst_undrly_sec_type             412   1$char1.    $char1.    2 0
..           TSTtst_undrly_pds_cl_cd            413   3$char3.    $char3.    2 0
..           TSTtst_undrly_cls_px               416  22e22.       e22.       7 0
..           TSTtst_undrly_sec_instrcd_id       438   1$char1.    $char1.    2 0
..           TSTtst_fcy_to_dol_ex_rt            439  22e22.       e22.       7 0
..           TSTtst_us_cy_to_fx_rt              461  22e22.       e22.       7 0
..           TSTtst_mdy_rtg_cd                  483   6$char6.    $char6.    2 0
..           TSTtst_sp_rtg_cd                   489   5$char5.    $char5.    2 0
..           TSTtst_close_price_amt             494  22e22.       e22.       7 0
..           TSTtst_expiration_date             516   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_mdy_sdbt_rtg_cd             524   6$char6.    $char6.    2 0
..           TSTtst_rst_catg_cd                 530  20$char20.   $char20.   2 0
..           TSTtst_trade_cash_margin_ind       550   1$char1.    $char1.    2 0
..           TSTtst_gtc_ind                     551   1$char1.    $char1.    2 0
..           TSTtst_base_or_buy_curr            552   3$char3.    $char3.    2 0
..           TSTtst_prncpl_sell_amt             555  22e22.       e22.       7 0
..           TSTtst_prncpl_buy_amt              577  22e22.       e22.       7 0
..           TSTtst_exch_rt_buy_curr_usd        599  22e22.       e22.       7 0
..           TSTtst_exch_rt_sell_curr_usd       621  22e22.       e22.       7 0
..           TSTtst_maturity_dt                 643   8YYMMDDN8.  YYMMDD8.   5 0
..           TSTtst_ric_code                    651  24$char24.   $char24.   2 0
..           TSTtst_osys_id                     675   4$char4.    $char4.    2 0
..           TSTtst_order_type_cd               679   1$char1.    $char1.    2 0
..           TSRtsr_seg_id_version                0   8$char8.    $char8.    2 0
..           TSRtsr_comm_penalty_ind              8   1$char1.    $char1.    2 0
..           TSRtsr_handle_fee_cd                 9   1$char1.    $char1.    2 0
..           TSRtsr_tdc_ty_cd                    10   3$char3.    $char3.    2 0
..           TSRtsr_orig_exch_cd                 13   2$char2.    $char2.    2 0
..           TSRtsr_neg_rate                     15  10Z10.4      10.        7 0
..           TSRtsr_neg_rate_ind                 25   1$char1.    $char1.    2 0
..           TSRtsr_split_code                   26   1$char1.    $char1.    2 0
..           TSRtsr_pool_code                    27   1$char1.    $char1.    2 0
..           TSRtsr_category_cd                  28   1$char1.    $char1.    2 0
..           TSRtsr_asset_lvl1_cd                29   1$char1.    $char1.    2 0
..           TSRtsr_asset_lvl2_cd                30   2$char2.    $char2.    2 0
..           TSRtsr_prod_cd                      32   4$char4.    $char4.    2 0
..           TSRtsr_90_dy_ext_rvw_ind            36   1$char1.    $char1.    2 0
..           TSRtsr_bkr_mkt_mkr_ind              37   1$char1.    $char1.    2 0
..           TSRtsr_bkri_xclsn_ind               38   1$char1.    $char1.    2 0
..           TSRtsr_altr_invst_ind               39   1$char1.    $char1.    2 0
..           TSRtsr_dsp_lmf_ind                  40   1$char1.    $char1.    2 0
..           TSRtsr_undrly_review_cd             41   1$char1.    $char1.    2 0
..           TSRtsr_und_undrv_sol_aprv_id        42   1$char1.    $char1.    2 0
..           TSRtsr_undrly_cef_sol_apr_id        43   1$char1.    $char1.    2 0
..           TSRtsr_orig_trade_id                44  16Z16.       16.        7 0
..           TSRtsr_capc_ind                     60   1$char1.    $char1.    2 0
..           TMMtmm_seg_id_version                0   8$char8.    $char8.    2 0
..           TMMtmm_term_owner_open_date          8   8YYMMDDN8.  YYMMDD8.   5 0
..           TMMtmm_term_owner_agrmt_date        16   8YYMMDDN8.  YYMMDD8.   5 0
..           TMMtmm_agrmt_mcc                    24   4$char4.    $char4.    2 0
..           TMMtmm_client_type                  28  40$char40.   $char40.   2 0
..           TMMtmm_tax_id                       68  15$char15.   $char15.   230
..           TMMtmm_mer_limit_type_1             83   3$char3.    $char3.    2 0
..           TMMtmm_mer_limit_1                  86  22e22.       e22.       4 0
..           TMMtmm_mer_limit_type_2            108   3$char3.    $char3.    2 0
..           TMMtmm_mer_limit_2                 111  22e22.       e22.       4 0
..           TMMtmm_num_locations               133   4$char4.    $char4.    2 0
..           TMMtmm_mer_type                    137   1$char1.    $char1.    2 0
..           TMTtmt_seg_id_version                0   8$char8.    $char8.    2 0
..           TMTtmt_term_id                       8   8$char8.    $char8.    2 0
..           TMTtmt_term_city                    16  60$char60.   $char60.   2 0
..           TMTtmt_term_state                   76   3$char3.    $char3.    2 0
..           TMTtmt_term_post_code               79  15$char15.   $char15.   2 0
..           TMTtmt_term_cntry_code              94   3$char3.    $char3.    2 0
..           TMTtmt_term_model                   97  20$char20.   $char20.   2 0
..           TMTtmt_term_soft_ver               117  10$char10.   $char10.   2 0
..           TMTtmt_term_install_date           127   8YYMMDDN8.  YYMMDD8.   5 0
..           TMTtmt_term_pan_entry_cap          135   1$char1.    $char1.    2 0
..           TMTtmt_term_pin_entry_cap          136   1$char1.    $char1.    2 0
..           TMTtmt_term_mcc                    137   4$char4.    $char4.    2 0
..           TMTtmt_term_client_type            141  40$char40.   $char40.   2 0
..           DNAdna_seg_id_version                0   8$char8.    $char8.    2 0
..           DNAdna_new_city                      8  60$char60.   $char60.   2 0
..           DNAdna_old_city                     68  60$char60.   $char60.   2 0
..           DNAdna_new_state                   128   3$char3.    $char3.    2 0
..           DNAdna_old_state                   131   3$char3.    $char3.    2 0
..           DNAdna_new_cntry                   134   3$char3.    $char3.    2 0
..           DNAdna_old_cntry                   137   3$char3.    $char3.    2 0
..           DNAdna_new_post_code               140  15$char15.   $char15.   2 0
..           DNAdna_old_post_code               155  15$char15.   $char15.   2 0
..           DNAdna_prev_change_src             170   1$char1.    $char1.    2 0
..           DNPdnp_seg_id_version                0   8$char8.    $char8.    2 0
..           DNPdnp_new_cntry_code                8   3$char3.    $char3.    2 0
..           DNPdnp_new_ps                       11  13$char13.   $char13.   240
..           DNPdnp_old_cntry_code               24   3$char3.    $char3.    2 0
..           DNPdnp_old_ps                       27  13$char13.   $char13.   240
..           DNCdnc_seg_id_version                0   8$char8.    $char8.    2 0
..           DNCdnc_new_limit                     8  22e22.       e22.       4 0
..           DNCdnc_old_limit                    30  22e22.       e22.       4 0
..           DNCdnc_tmp_chg_ind                  52   1$char1.    $char1.    2 0
..           DNCdnc_tmp_chg_exp_dt               53   8YYMMDDN8.  YYMMDD8.   5 0
..           DNUdnu_seg_id_version                0   8$char8.    $char8.    2 0
..           DNUdnu_u_ind1                        8   1$char1.    $char1.    2 0
..           DNUdnu_u_ind2                        9   1$char1.    $char1.    2 0
..           DNUdnu_u_ind3                       10   1$char1.    $char1.    2 0
..           DNUdnu_u_ind4                       11   1$char1.    $char1.    2 0
..           DNUdnu_u_string1                    12  40$char40.   $char40.   2 0
..           DNUdnu_u_string2                    52  40$char40.   $char40.   2 0
..           DNUdnu_u_string3                    92  40$char40.   $char40.   2 0
..           DNUdnu_u_string4                   132  40$char40.   $char40.   2 0
..           DNUdnu_u_amt1                      172  22e22.       e22.       4 0
..           DNUdnu_u_amt2                      194  22e22.       e22.       4 0
..           DNUdnu_u_amt3                      216  22e22.       e22.       4 0
..           DNUdnu_u_amt4                      238  22e22.       e22.       4 0
..           DNUdnu_cust_doc_type               260  20$char20.   $char20.   2 0
..           DNUdnu_cust_doc_num                280  30$char30.   $char30.   2 0
..           DNUdnu_cust_doc_issue_date         310   8YYMMDDN8.  YYMMDD8.   5 0
..           DNUdnu_cust_doc_expiry_date        318   8YYMMDDN8.  YYMMDD8.   5 0
..           DNRdnr_seg_id_version                0   8$char8.    $char8.    2 0
..           DNRdnr_card_type                     8   3$char3.    $char3.    2 0
..           DNRdnr_reissue_type                 11   2$char2.    $char2.    2 0
..           DNSdns_seg_id_version                0   8$char8.    $char8.    2 0
..           DNSdns_u_ind1                        8   1$char1.    $char1.    2 0
..           DNSdns_u_ind2                        9   1$char1.    $char1.    2 0
..           DNSdns_u_string1_old                10  40$char40.   $char40.   230
..           DNSdns_u_string1_new                50  40$char40.   $char40.   230
..           DNSdns_u_string2_old                90  40$char40.   $char40.   230
..           DNSdns_u_string2_new               130  40$char40.   $char40.   230
..           DNOdno_seg_id_version                0   8$char8.    $char8.    2 0
..           DNOdno_last_active_date              8   8$char8.    $char8.    2 0
..           DNOdno_new_act_flag                 16   1$char1.    $char1.    2 0
..           DNOdno_old_act_flag                 17   1$char1.    $char1.    2 0
..           DNXdnx_seg_id_version                0   8$char8.    $char8.    2 0
..           DNXdnx_action                        8   1$char1.    $char1.    2 0
..           DNXdnx_entity_type                   9   1$char1.    $char1.    2 0
..           DNXdnx_entity_id                    10   2$char2.    $char2.    2 0
..           DNXdnx_trf_from_entity_key          12 100$char100.  $char100.  2 0
..           DNXdnx_trf_to_entity_key           112 100$char100.  $char100.  2 0
..           DNXdnx_xfer_reason                 212   2$char2.    $char2.    2 0
..           DCBdcb_seg_id_version                0   8$char8.    $char8.    2 0
..           DCBdcb_cb_score                      8   4Z4.        4.         7 0
..           DCBdcb_num_opn_trd                  12   3Z3.        3.         7 0
..           DCBdcb_inq_6m                       15   2Z2.        2.         7 0
..           DCBdcb_inq_12m                      17   2Z2.        2.         7 0
..           DCBdcb_age_oldest                   19   3Z3.        3.         7 0
..           DCBdcb_age_newest                   22   3Z3.        3.         7 0
..           DCBdcb_lst_updt_dt                  25   8YYMMDDN8.  YYMMDD8.   5 0
..           DCBdcb_dispute_ind                  33   1$char1.    $char1.    2 0
..           DCBdcb_fraud_flag                   34   1$char1.    $char1.    2 0
..           DCCdcc_seg_id_version                0   8$char8.    $char8.    2 0
..           DCCdcc_prin_bal                      8  22e22.       e22.       4 0
..           DCCdcc_merch_amount                 30  22e22.       e22.       4 0
..           DCCdcc_cyc_merch_num                52   3Z3.        3.         7 0
..           DCCdcc_cash_amount                  55  22e22.       e22.       4 0
..           DCCdcc_cyc_cash_num                 77   3Z3.        3.         7 0
..           DCCdcc_cyc_int_amt                  80  22e22.       e22.       4 0
..           DCCdcc_cyc_overlimit_fee           102  22e22.       e22.       4 0
..           DCCdcc_cyc_late_fee                124  22e22.       e22.       4 0
..           DCCdcc_cash_fee                    146  22e22.       e22.       4 0
..           DCCdcc_other_fee                   168  22e22.       e22.       4 0
..           DCCdcc_nsf_num                     190   3Z3.        3.         7 0
..           DCCdcc_bal_tfr_amt                 193  22e22.       e22.       4 0
..           DCCdcc_bal_tfr_num                 215   2Z2.        2.         7 0
..           DCCdcc_conv_check_amt              217  22e22.       e22.       4 0
..           DCCdcc_conv_check_num              239   2Z2.        2.         7 0
..           DCCdcc_return_amt                  241  22e22.       e22.       4 0
..           DCCdcc_return_num                  263   3Z3.        3.         7 0
..           DCCdcc_min_due                     266  22e22.       e22.       4 0
..           DCCdcc_pymt_due_date               288   8YYMMDDN8.  YYMMDD8.   5 0
..           DCCdcc_pymt_amt                    296  22e22.       e22.       4 0
..           DCCdcc_pymt_num                    318   3Z3.        3.         7 0
..           DCCdcc_activity_hist               321  12$char12.   $char12.   2 0
..           DCCdcc_delq_hist                   333  12$char12.   $char12.   2 0
..           DCCdcc_1cyc_delq_amt               345  22e22.       e22.       4 0
..           DCCdcc_2cyc_delq_amt               367  22e22.       e22.       4 0
..           DCCdcc_3cyc_delq_amt               389  22e22.       e22.       4 0
..           DCCdcc_4p_cyc_delq_amt             411  22e22.       e22.       4 0
..           DCCdcc_chg_off_amt                 433  22e22.       e22.       4 0
..           DCCdcc_chg_off_date                455   8YYMMDDN8.  YYMMDD8.   5 0
..           DCCdcc_bk_amt                      463  22e22.       e22.       4 0
..           DCCdcc_bk_date                     485   8YYMMDDN8.  YYMMDD8.   5 0
..           DCCdcc_filler                      493  29$char29.   $char29.   2 0
..           DCQdcq_seg_id_version                0   8$char8.    $char8.    2 0
..           DCQdcq_chk_num                       8  20$char20.   $char20.   2 0
..           DCQdcq_micr_line                    28  50$char50.   $char50.   2 0
..           DCQdcq_onus_flag                    78   1$char1.    $char1.    2 0
..           DCQdcq_present_channel              79   1$char1.    $char1.    2 0
..           DCQdcq_deposit_batch_id             80  10$char10.   $char10.   2 0
..           DCQdcq_present_date                 90   8YYMMDDN8.  YYMMDD8.   5 0
..           DCQdcq_present_post_code            98  15$char15.   $char15.   2 0
..           DCQdcq_present_cntry_code          113   3$char3.    $char3.    2 0
..           DCQdcq_present_bank_num            116  15$char15.   $char15.   2 0
..           DCQdcq_present_staff_id            131  10$char10.   $char10.   2 0
..           DCQdcq_clearance_days              141   3Z3.        3.         7 0
..           DCQdcq_special_ind                 144   1$char1.    $char1.    2 0
..           DCQdcq_special_reason1             145   2$char2.    $char2.    2 0
..           DCQdcq_special_reason2             147   2$char2.    $char2.    2 0
..           DCQdcq_special_reason3             149   2$char2.    $char2.    2 0
..           DBAdba_seg_id_version                0   8$char8.    $char8.    2 0
..           DBAdba_entry_method                  8   1$char1.    $char1.    2 0
..           DBAdba_template_id                   9  15$char15.   $char15.   2 0
..           DBAdba_template_name                24  30$char30.   $char30.   2 0
..           DBAdba_templt_create_user           54  50$char50.   $char50.   2 0
..           DBAdba_template_create_date        104   8YYMMDDN8.  YYMMDD8.   5 0
..           DBAdba_template_create_time        112   8time8.     time8.     8 0
..           DBAdba_templt_last_edit_user       120  50$char50.   $char50.   2 0
..           DBAdba_templt_last_edit_date       170   8YYMMDDN8.  YYMMDD8.   5 0
..           DBAdba_templt_last_edit_time       178   8time8.     time8.     8 0
..           DBAdba_templt_approval_user        186  50$char50.   $char50.   2 0
..           DBAdba_templt_approval_date        236   8YYMMDDN8.  YYMMDD8.   5 0
..           DBAdba_templt_approval_time        244   8time8.     time8.     8 0
..           DBAdba_create_userid               252  50$char50.   $char50.   2 0
..           DBAdba_create_date                 302   8YYMMDDN8.  YYMMDD8.   5 0
..           DBAdba_create_time                 310   8time8.     time8.     8 0
..           DBAdba_approval_type_req           318   1$char1.    $char1.    2 0
..           DBAdba_approval_userid1            319  50$char50.   $char50.   2 0
..           DBAdba_approval_userid2            369  50$char50.   $char50.   2 0
..           DBAdba_approval_date               419   8YYMMDDN8.  YYMMDD8.   5 0
..           DBAdba_approval_time               427   8time8.     time8.     8 0
..           DMXdmx_seg_id_version                0   8$char8.    $char8.    2 0
..           DMXdmx_n3_01_tag                     8   2$char2.    $char2.    2 0
..           DMXdmx_n3_01                        10   3Z3.        3.         7 0
..           DMXdmx_n3_02_tag                    13   2$char2.    $char2.    2 0
..           DMXdmx_n3_02                        15   3Z3.        3.         7 0
..           DMXdmx_n3_03_tag                    18   2$char2.    $char2.    2 0
..           DMXdmx_n3_03                        20   3Z3.        3.         7 0
..           DMXdmx_n8_01_tag                    23   2$char2.    $char2.    2 0
..           DMXdmx_n8_01                        25   8Z8.        8.         7 0
..           DMXdmx_n8_02_tag                    33   2$char2.    $char2.    2 0
..           DMXdmx_n8_02                        35   8Z8.        8.         7 0
..           DMXdmx_n8_03_tag                    43   2$char2.    $char2.    2 0
..           DMXdmx_n8_03                        45   8Z8.        8.         7 0
..           DMXdmx_n22_01_tag                   53   2$char2.    $char2.    2 0
..           DMXdmx_n22_01                       55  22e22.       e22.       7 0
..           DMXdmx_n22_02_tag                   77   2$char2.    $char2.    2 0
..           DMXdmx_n22_02                       79  22e22.       e22.       7 0
..           DMXdmx_n22_03_tag                  101   2$char2.    $char2.    2 0
..           DMXdmx_n22_03                      103  22e22.       e22.       7 0
..           DMXdmx_datetime_01_tag             125   2$char2.    $char2.    2 0
..           DMXdmx_date_01                     127   8YYMMDDN8.  YYMMDD8.   5 0
..           DMXdmx_time_01                     135  11time11.2   time11.2   8 0
..           DMXdmx_datetime_02_tag             146   2$char2.    $char2.    2 0
..           DMXdmx_date_02                     148   8YYMMDDN8.  YYMMDD8.   5 0
..           DMXdmx_time_02                     156  11time11.2   time11.2   8 0
..           DMXdmx_datetime_03_tag             167   2$char2.    $char2.    2 0
..           DMXdmx_date_03                     169   8YYMMDDN8.  YYMMDD8.   5 0
..           DMXdmx_time_03                     177  11time11.2   time11.2   8 0
..           DMXdmx_ind_01_tag                  188   2$char2.    $char2.    2 0
..           DMXdmx_ind_01                      190   1$char1.    $char1.    2 0
..           DMXdmx_ind_02_tag                  191   2$char2.    $char2.    2 0
..           DMXdmx_ind_02                      193   1$char1.    $char1.    2 0
..           DMXdmx_ind_03_tag                  194   2$char2.    $char2.    2 0
..           DMXdmx_ind_03                      196   1$char1.    $char1.    2 0
..           DMXdmx_ind_04_tag                  197   2$char2.    $char2.    2 0
..           DMXdmx_ind_04                      199   1$char1.    $char1.    2 0
..           DMXdmx_ind_05_tag                  200   2$char2.    $char2.    2 0
..           DMXdmx_ind_05                      202   1$char1.    $char1.    2 0
..           DMXdmx_2byte_string_01_tag         203   2$char2.    $char2.    2 0
..           DMXdmx_2byte_string_01             205   2$char2.    $char2.    2 0
..           DMXdmx_2byte_string_02_tag         207   2$char2.    $char2.    2 0
..           DMXdmx_2byte_string_02             209   2$char2.    $char2.    2 0
..           DMXdmx_2byte_string_03_tag         211   2$char2.    $char2.    2 0
..           DMXdmx_2byte_string_03             213   2$char2.    $char2.    2 0
..           DMXdmx_3byte_string_01_tag         215   2$char2.    $char2.    2 0
..           DMXdmx_3byte_string_01             217   3$char3.    $char3.    2 0
..           DMXdmx_3byte_string_02_tag         220   2$char2.    $char2.    2 0
..           DMXdmx_3byte_string_02             222   3$char3.    $char3.    2 0
..           DMXdmx_3byte_string_03_tag         225   2$char2.    $char2.    2 0
..           DMXdmx_3byte_string_03             227   3$char3.    $char3.    2 0
..           DMXdmx_5byte_string_01_tag         230   2$char2.    $char2.    2 0
..           DMXdmx_5byte_string_01             232   5$char5.    $char5.    2 0
..           DMXdmx_5byte_string_02_tag         237   2$char2.    $char2.    2 0
..           DMXdmx_5byte_string_02             239   5$char5.    $char5.    2 0
..           DMXdmx_10byte_string_01_tag        244   2$char2.    $char2.    2 0
..           DMXdmx_10byte_string_01            246  10$char10.   $char10.   2 0
..           DMXdmx_10byte_string_02_tag        256   2$char2.    $char2.    2 0
..           DMXdmx_10byte_string_02            258  10$char10.   $char10.   2 0
..           DEEdee_seg_id_version                0   8$char8.    $char8.    2 0
..           DEEdee_entity_id_1                   8  20$char20.   $char20.   2 0
..           DEEdee_entity_id_1_tag              28  10$char10.   $char10.   2 0
..           DEEdee_entity_1_rand_dig            38   3Z3.        3.         7 0
..           DEEdee_sas_entity_1_rand_dig        41   3Z3.        3.         7 0
..           DEEdee_entity_id_2                  44  40$char40.   $char40.   2 0
..           DEEdee_entity_id_2_tag              84  10$char10.   $char10.   2 0
..           DEEdee_entity_2_rand_dig            94   3Z3.        3.         7 0
..           DEEdee_sas_entity_2_rand_dig        97   3Z3.        3.         7 0
..           DEEdee_entity_id_3                 100  40$char40.   $char40.   2 0
..           DEEdee_entity_id_3_tag             140  10$char10.   $char10.   2 0
..           DEEdee_entity_3_rand_dig           150   3Z3.        3.         7 0
..           DEEdee_sas_entity_3_rand_dig       153   3Z3.        3.         7 0
..           DEEdee_entity_id_4                 156  60$char60.   $char60.   2 0
..           DEEdee_entity_id_4_tag             216  10$char10.   $char10.   2 0
..           DEEdee_entity_4_rand_dig           226   3Z3.        3.         7 0
..           DEEdee_sas_entity_4_rand_dig       229   3Z3.        3.         7 0
..           DEEdee_entity_id_5                 232  60$char60.   $char60.   2 0
..           DEEdee_entity_id_5_tag             292  10$char10.   $char10.   2 0
..           DEEdee_entity_5_rand_dig           302   3Z3.        3.         7 0
..           DEEdee_sas_entity_5_rand_dig       305   3Z3.        3.         7 0
..           DEEdee_entity_id_6                 308  80$char80.   $char80.   2 0
..           DEEdee_entity_id_6_tag             388  10$char10.   $char10.   2 0
..           DEEdee_entity_6_rand_dig           398   3Z3.        3.         7 0
..           DEEdee_sas_entity_6_rand_dig       401   3Z3.        3.         7 0
..           DPDdpd_seg_id_version                0   8$char8.    $char8.    2 0
..           DPDdpd_n3_01_tag                     8   2$char2.    $char2.    2 0
..           DPDdpd_n3_01                        10   3Z3.        3.         7 0
..           DPDdpd_n3_02_tag                    13   2$char2.    $char2.    2 0
..           DPDdpd_n3_02                        15   3Z3.        3.         7 0
..           DPDdpd_n3_03_tag                    18   2$char2.    $char2.    2 0
..           DPDdpd_n3_03                        20   3Z3.        3.         7 0
..           DPDdpd_n22_01_tag                   23   2$char2.    $char2.    2 0
..           DPDdpd_n22_01                       25  22e22.       e22.       7 0
..           DPDdpd_n22_02_tag                   47   2$char2.    $char2.    2 0
..           DPDdpd_n22_02                       49  22e22.       e22.       7 0
..           DPDdpd_n22_03_tag                   71   2$char2.    $char2.    2 0
..           DPDdpd_n22_03                       73  22e22.       e22.       7 0
..           DPDdpd_n22_04_tag                   95   2$char2.    $char2.    2 0
..           DPDdpd_n22_04                       97  22e22.       e22.       7 0
..           DPDdpd_n22_05_tag                  119   2$char2.    $char2.    2 0
..           DPDdpd_n22_05                      121  22e22.       e22.       7 0
..           DPDdpd_datetime_01_tag             143   2$char2.    $char2.    2 0
..           DPDdpd_date_01                     145   8YYMMDDN8.  YYMMDD8.   5 0
..           DPDdpd_time_01                     153  11time11.2   time11.2   8 0
..           DPDdpd_datetime_02_tag             164   2$char2.    $char2.    2 0
..           DPDdpd_date_02                     166   8YYMMDDN8.  YYMMDD8.   5 0
..           DPDdpd_time_02                     174  11time11.2   time11.2   8 0
..           DPDdpd_datetime_03_tag             185   2$char2.    $char2.    2 0
..           DPDdpd_date_03                     187   8YYMMDDN8.  YYMMDD8.   5 0
..           DPDdpd_time_03                     195  11time11.2   time11.2   8 0
..           DPDdpd_3byte_string_01_tag         206   2$char2.    $char2.    2 0
..           DPDdpd_3byte_string_01             208   3$char3.    $char3.    2 0
..           DPDdpd_3byte_string_02_tag         211   2$char2.    $char2.    2 0
..           DPDdpd_3byte_string_02             213   3$char3.    $char3.    2 0
..           DPDdpd_3byte_string_03_tag         216   2$char2.    $char2.    2 0
..           DPDdpd_3byte_string_03             218   3$char3.    $char3.    2 0
..           DPDdpd_5byte_string_01_tag         221   2$char2.    $char2.    2 0
..           DPDdpd_5byte_string_01             223   5$char5.    $char5.    2 0
..           DPDdpd_5byte_string_02_tag         228   2$char2.    $char2.    2 0
..           DPDdpd_5byte_string_02             230   5$char5.    $char5.    2 0
..           DPDdpd_10byte_string_01_tag        235   2$char2.    $char2.    2 0
..           DPDdpd_10byte_string_01            237  10$char10.   $char10.   2 0
..           DPDdpd_10byte_string_02_tag        247   2$char2.    $char2.    2 0
..           DPDdpd_10byte_string_02            249  10$char10.   $char10.   2 0
..           DPPdpp_seg_id_version                0   8$char8.    $char8.    2 0
..           DPPdpp_entity_type                   8   1$char1.    $char1.    2 0
..           DPPdpp_num                           9  25$char25.   $char25.   230
..           DPPdpp_name                         34  80$char80.   $char80.   2 0
..           DPPdpp_phone                       114  15$char15.   $char15.   2 0
..           DPPdpp_email                       129  80$char80.   $char80.   2 0
..           DPPdpp_social_net                  209   2$char2.    $char2.    2 0
..           DPPdpp_social_net_id               211  80$char80.   $char80.   2 0
..           DPPdpp_cntry_code                  291   3$char3.    $char3.    2 0
..           DPPdpp_city                        294  60$char60.   $char60.   2 0
..           DPPdpp_state                       354   3$char3.    $char3.    2 0
..           DPPdpp_post_code                   357  15$char15.   $char15.   2 0
..           DPPdpp_bank_type                   372   1$char1.    $char1.    2 0
..           DPPdpp_acct_type                   373   2$char2.    $char2.    2 0
..           DPPdpp_acct_sub_type               375   1$char1.    $char1.    2 0
..           DPPdpp_bank_cntry_code             376   3$char3.    $char3.    2 0
..           DPPdpp_bank_num                    379  15$char15.   $char15.   2 0
..           DPPdpp_bank_name                   394  90$utf8x90.  $utf8x90.  2 0
..           DPPdpp_branch_id                   484  10$char10.   $char10.   2 0
..           DPPdpp_acct_num                    494  34$char34.   $char34.   230
..           DPPdpp_curr_code                   528   3$char3.    $char3.    2 0
..           DPPdpp_description                 531 100$char100.  $char100.  2 0
..           DPPdpp_address                     631  80$char80.   $char80.   2 0
..           DUAdua_seg_id_version                0   8$char8.    $char8.    2 0
..           DUAdua_numeric_001                   8   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_002                  16   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_003                  24   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_004                  32   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_005                  40   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_006                  48   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_007                  56   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_008                  64   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_009                  72   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_010                  80   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_011                  88   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_012                  96   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_013                 104   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_014                 112   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_015                 120   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_016                 128   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_017                 136   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_018                 144   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_019                 152   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_020                 160   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_021                 168   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_022                 176   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_023                 184   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_024                 192   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_025                 200   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_026                 208   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_027                 216   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_028                 224   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_029                 232   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_numeric_030                 240   8IEEE8.0    IEEE8.0    7 0
..           DUAdua_8byte_string_001            248   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_002            256   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_003            264   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_004            272   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_005            280   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_006            288   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_007            296   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_008            304   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_009            312   8$char8.    $char8.    2 0
..           DUAdua_8byte_string_010            320   8$char8.    $char8.    2 0
..           DUAdua_10byte_string_001           328  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_002           338  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_003           348  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_004           358  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_005           368  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_006           378  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_007           388  10$char10.   $char10.   2 0
..           DUAdua_10byte_string_008           398  10$char10.   $char10.   2 0
..           DUAdua_20byte_string_001           408  20$char20.   $char20.   2 0
..           DUAdua_20byte_string_002           428  20$char20.   $char20.   2 0
..           DUAdua_20byte_string_003           448  20$char20.   $char20.   2 0
..           DUAdua_20byte_string_004           468  20$char20.   $char20.   2 0
..           DUAdua_20byte_string_005           488  20$char20.   $char20.   2 0
..           DUAdua_40byte_string_001           508  40$char40.   $char40.   2 0
..           DUAdua_40byte_string_002           548  40$char40.   $char40.   2 0
..           DUAdua_40byte_string_003           588  40$char40.   $char40.   2 0
..           DUAdua_40byte_string_004           628  40$char40.   $char40.   2 0
..           DUAdua_40byte_string_005           668  40$char40.   $char40.   2 0
..           DUAdua_80byte_string_001           708  80$char80.   $char80.   2 0
..           DUAdua_80byte_string_002           788  80$char80.   $char80.   2 0
..           DUAdua_80byte_string_003           868  80$char80.   $char80.   2 0
..           DUAdua_80byte_string_004           948  80$char80.   $char80.   2 0
..           DUAdua_80byte_string_005          1028  80$char80.   $char80.   2 0
..           DUSdus_seg_id_version                0   8$char8.    $char8.    2 0
..           DUSdus_acct_type                     8   2$char2.    $char2.    2 0
..           DUSdus_auth_sys_dec                 10   1$char1.    $char1.    2 0
..           DUSdus_fraud_score                  11   4$char4.    $char4.    2 0
..           DUSdus_ch_post_code                 15  15$char15.   $char15.   2 0
..           DUSdus_ch_cntry_code                30   3$char3.    $char3.    2 0
..           DUSdus_avail_balance                33  22e22.       e22.       4 0
..           DUSdus_acct_limit_type_1            55   1$char1.    $char1.    2 0
..           DUSdus_acct_limit_1                 56  22e22.       e22.       4 0
..           DUSdus_acct_limit_type_2            78   1$char1.    $char1.    2 0
..           DUSdus_acct_limit_2                 79  22e22.       e22.       4 0
..           DUSdus_block_ind                   101   1$char1.    $char1.    2 0
..           DCHdch_seg_id_version                0   8$char8.    $char8.    2 0
..           DCHdch_ref_num                       8  30$char30.   $char30.   2 0
..           DCHdch_purchase_date                38   8YYMMDDN8.  YYMMDD8.   5 0
..           DCHdch_purchase_time                46  11time11.2   time11.2   8 0
..           DCHdch_mer_amt                      57  22e22.       e22.       4 0
..           DCHdch_mer_curr_code                79   3$char3.    $char3.    2 0
..           DCHdch_payment_method               82   1$char1.    $char1.    2 0
..           DCHdch_payment_id                   83  80$char80.   $char80.   230
..           DCHdch_misc_data                   163 100$char100.  $char100.  2 0
..           RUArua_seg_id_version                0   8$char8.    $char8.    2 0
..           RUArua_numeric_001                   8   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_002                  16   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_003                  24   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_004                  32   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_005                  40   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_006                  48   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_007                  56   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_008                  64   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_009                  72   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_010                  80   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_011                  88   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_012                  96   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_013                 104   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_014                 112   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_015                 120   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_016                 128   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_017                 136   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_018                 144   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_019                 152   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_020                 160   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_021                 168   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_022                 176   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_023                 184   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_024                 192   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_025                 200   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_026                 208   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_027                 216   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_028                 224   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_029                 232   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_030                 240   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_031                 248   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_032                 256   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_033                 264   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_034                 272   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_035                 280   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_036                 288   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_037                 296   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_038                 304   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_039                 312   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_040                 320   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_041                 328   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_042                 336   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_043                 344   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_044                 352   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_045                 360   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_046                 368   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_047                 376   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_048                 384   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_049                 392   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_050                 400   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_051                 408   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_052                 416   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_053                 424   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_054                 432   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_055                 440   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_056                 448   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_057                 456   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_058                 464   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_059                 472   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_060                 480   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_061                 488   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_062                 496   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_063                 504   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_064                 512   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_065                 520   8IEEE8.0    IEEE8.0    7 0
..           RUArua_numeric_066                 528   8IEEE8.0    IEEE8.0    7 0
..           RUArua_ind_001                     536   1$char1.    $char1.    2 0
..           RUArua_ind_002                     537   1$char1.    $char1.    2 0
..           RUArua_ind_003                     538   1$char1.    $char1.    2 0
..           RUArua_ind_004                     539   1$char1.    $char1.    2 0
..           RUArua_ind_005                     540   1$char1.    $char1.    2 0
..           RUArua_ind_006                     541   1$char1.    $char1.    2 0
..           RUArua_ind_007                     542   1$char1.    $char1.    2 0
..           RUArua_ind_008                     543   1$char1.    $char1.    2 0
..           RUArua_ind_009                     544   1$char1.    $char1.    2 0
..           RUArua_ind_010                     545   1$char1.    $char1.    2 0
..           RUArua_ind_011                     546   1$char1.    $char1.    2 0
..           RUArua_ind_012                     547   1$char1.    $char1.    2 0
..           RUArua_ind_013                     548   1$char1.    $char1.    2 0
..           RUArua_ind_014                     549   1$char1.    $char1.    2 0
..           RUArua_ind_015                     550   1$char1.    $char1.    2 0
..           RUArua_ind_016                     551   1$char1.    $char1.    2 0
..           RUArua_ind_017                     552   1$char1.    $char1.    2 0
..           RUArua_ind_018                     553   1$char1.    $char1.    2 0
..           RUArua_ind_019                     554   1$char1.    $char1.    2 0
..           RUArua_ind_020                     555   1$char1.    $char1.    2 0
..           RUArua_ind_021                     556   1$char1.    $char1.    2 0
..           RUArua_ind_022                     557   1$char1.    $char1.    2 0
..           RUArua_ind_023                     558   1$char1.    $char1.    2 0
..           RUArua_ind_024                     559   1$char1.    $char1.    2 0
..           RUArua_ind_025                     560   1$char1.    $char1.    2 0
..           RUArua_ind_026                     561   1$char1.    $char1.    2 0
..           RUArua_ind_027                     562   1$char1.    $char1.    2 0
..           RUArua_ind_028                     563   1$char1.    $char1.    2 0
..           RUArua_ind_029                     564   1$char1.    $char1.    2 0
..           RUArua_ind_030                     565   1$char1.    $char1.    2 0
..           RUArua_ind_031                     566   1$char1.    $char1.    2 0
..           RUArua_ind_032                     567   1$char1.    $char1.    2 0
..           RUArua_2byte_string_001            568   2$char2.    $char2.    2 0
..           RUArua_2byte_string_002            570   2$char2.    $char2.    2 0
..           RUArua_2byte_string_003            572   2$char2.    $char2.    2 0
..           RUArua_2byte_string_004            574   2$char2.    $char2.    2 0
..           RUArua_2byte_string_005            576   2$char2.    $char2.    2 0
..           RUArua_2byte_string_006            578   2$char2.    $char2.    2 0
..           RUArua_2byte_string_007            580   2$char2.    $char2.    2 0
..           RUArua_2byte_string_008            582   2$char2.    $char2.    2 0
..           RUArua_3byte_string_001            584   3$char3.    $char3.    2 0
..           RUArua_3byte_string_002            587   3$char3.    $char3.    2 0
..           RUArua_3byte_string_003            590   3$char3.    $char3.    2 0
..           RUArua_3byte_string_004            593   3$char3.    $char3.    2 0
..           RUArua_3byte_string_005            596   3$char3.    $char3.    2 0
..           RUArua_3byte_string_006            599   3$char3.    $char3.    2 0
..           RUArua_3byte_string_007            602   3$char3.    $char3.    2 0
..           RUArua_3byte_string_008            605   3$char3.    $char3.    2 0
..           RUArua_4byte_string_001            608   4$char4.    $char4.    2 0
..           RUArua_4byte_string_002            612   4$char4.    $char4.    2 0
..           RUArua_4byte_string_003            616   4$char4.    $char4.    2 0
..           RUArua_4byte_string_004            620   4$char4.    $char4.    2 0
..           RUArua_8byte_string_001            624   8$char8.    $char8.    2 0
..           RUArua_8byte_string_002            632   8$char8.    $char8.    2 0
..           RUArua_8byte_string_003            640   8$char8.    $char8.    2 0
..           RUArua_10byte_string_001           648  10$char10.   $char10.   2 0
..           RUArua_10byte_string_002           658  10$char10.   $char10.   2 0
..           RUArua_10byte_string_003           668  10$char10.   $char10.   2 0
..           RUArua_10byte_string_004           678  10$char10.   $char10.   2 0
..           RUArua_10byte_string_005           688  10$char10.   $char10.   2 0
..           RUArua_10byte_string_006           698  10$char10.   $char10.   2 0
..           RUArua_10byte_string_007           708  10$char10.   $char10.   2 0
..           RUArua_10byte_string_008           718  10$char10.   $char10.   2 0
..           RUArua_20byte_string_001           728  20$char20.   $char20.   2 0
..           RUArua_20byte_string_002           748  20$char20.   $char20.   2 0
..           RUArua_20byte_string_003           768  20$char20.   $char20.   2 0
..           RUArua_20byte_string_004           788  20$char20.   $char20.   2 0
..           RUArua_20byte_string_005           808  20$char20.   $char20.   2 0
..           RUArua_30byte_string_001           828  30$char30.   $char30.   2 0
..           RUArua_30byte_string_002           858  30$char30.   $char30.   2 0
..           RUArua_80byte_nls_string_001       888  80$utf8x80.  $utf8x80.  2 0
..           RUArua_80byte_nls_string_002       968  80$utf8x80.  $utf8x80.  2 0
..           RUArua_80byte_nls_string_003      1048  80$utf8x80.  $utf8x80.  2 0
..           ROBrob_seg_id_version                0   8$char8.    $char8.    2 0
..           ROBrob_score_1                       8   3Z3.        3.         7 0
..           ROBrob_sup_score_1                  11   3Z3.        3.         7 0
..           ROBrob_score_2                      14   3Z3.        3.         7 0
..           ROBrob_sup_score_2                  17   3Z3.        3.         7 0
..           ROBrob_score_3                      20   3Z3.        3.         7 0
..           ROBrob_sup_score_3                  23   3Z3.        3.         7 0
..           ROBrob_score_4                      26   3Z3.        3.         7 0
..           ROBrob_sup_score_4                  29   3Z3.        3.         7 0
..           ROBrob_dec_code                     32   1$char1.    $char1.    2 0
..           ROBrob_time                         33  11TIME11.2   TIME11.2   8 0
..           ROBrob_date                         44   8YYMMDDN8.  YYMMDD8.   5 0
..           ROBrob_prelim_dec_code              52   1$char1.    $char1.    2 0
..           ROBrob_action_info                  53   4$char4.    $char4.    2 0
..           ROBrob_dnd_date                     57   8YYMMDDN8.  YYMMDD8.   5 0
..           ROBrob_dnd_time                     65   8time8.     time8.     8 0
..           ROBrob_action_until_date            73   8YYMMDDN8.  YYMMDD8.   5 0
..           ROBrob_action_until_time            81   8time8.     time8.     8 0
..           ROBrob_count                        89   4$char4.    $char4.    2 0
..           ROBrob_action_code                  93   1$char1.    $char1.    2 0
..           ROBrob_cust_ind                     94   1$char1.    $char1.    2 0
..           ROBrob_prelim_dec_until_date        95   8YYMMDDN8.  YYMMDD8.   5 0
..           ROBrob_prelim_dec_until_time       103   8time8.     time8.     8 0
..           ROBrob_prelim_dec_info             111   4$char4.    $char4.    2 0
..           RDKrdk_seg_id_version                0   8$char8.    $char8.    2 0
..           RDKrdk_cpp_ent1_id                   8   4$char4.    $char4.    2 0
..           RDKrdk_cpp_ent1_frd_rate            12  10e10.       e10.       7 0
..           RDKrdk_cpp_ent1_frd_pt              22   1$char1.    $char1.    2 0
..           RDKrdk_cpp_ent1_score               23   3Z3.        3.         7 0
..           RDKrdk_cpp_ent2_id                  26   4$char4.    $char4.    2 0
..           RDKrdk_cpp_ent2_frd_rate            30  10e10.       e10.       7 0
..           RDKrdk_cpp_ent2_frd_pt              40   1$char1.    $char1.    2 0
..           RDKrdk_cpp_ent2_score               41   3Z3.        3.         7 0
..           RDKrdk_cpp_ent3_id                  44   4$char4.    $char4.    2 0
..           RDKrdk_cpp_ent3_frd_rate            48  10e10.       e10.       7 0
..           RDKrdk_cpp_ent3_frd_pt              58   1$char1.    $char1.    2 0
..           RDKrdk_cpp_ent3_score               59   3Z3.        3.         7 0
..           RDKrdk_cpp_exp_date_prx             62   8YYMMDDN8.  YYMMDD8.   5 0
..           RDKrdk_cpp_list_date                70   8YYMMDDN8.  YYMMDD8.   5 0
..           RDKrdk_cpp_list_time                78  11time11.2   time11.2   8 0
..           RDKrdk_dec_key_1                    89 200$char200.  $char200.  2 0
..           RURrur_seg_id_version                0   8$char8.    $char8.    2 0
..           RURrur_numeric_001                   8   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_002                  16   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_003                  24   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_004                  32   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_005                  40   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_006                  48   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_007                  56   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_008                  64   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_009                  72   8IEEE8.0    IEEE8.0    7 0
..           RURrur_numeric_010                  80   8IEEE8.0    IEEE8.0    7 0
..           RURrur_ind_001                      88   1$char1.    $char1.    2 0
..           RURrur_ind_002                      89   1$char1.    $char1.    2 0
..           RURrur_ind_003                      90   1$char1.    $char1.    2 0
..           RURrur_ind_004                      91   1$char1.    $char1.    2 0
..           RURrur_ind_005                      92   1$char1.    $char1.    2 0
..           RURrur_ind_006                      93   1$char1.    $char1.    2 0
..           RURrur_ind_007                      94   1$char1.    $char1.    2 0
..           RURrur_ind_008                      95   1$char1.    $char1.    2 0
..           RURrur_ind_009                      96   1$char1.    $char1.    2 0
..           RURrur_ind_010                      97   1$char1.    $char1.    2 0
..           RURrur_4byte_string_001             98   4$char4.    $char4.    2 0
..           RURrur_4byte_string_002            102   4$char4.    $char4.    2 0
..           RURrur_4byte_string_003            106   4$char4.    $char4.    2 0
..           RURrur_4byte_string_004            110   4$char4.    $char4.    2 0
..           RURrur_4byte_string_005            114   4$char4.    $char4.    2 0
..           RURrur_4byte_string_006            118   4$char4.    $char4.    2 0
..           RURrur_4byte_string_007            122   4$char4.    $char4.    2 0
..           RURrur_4byte_string_008            126   4$char4.    $char4.    2 0
..           RURrur_4byte_string_009            130   4$char4.    $char4.    2 0
..           RURrur_4byte_string_010            134   4$char4.    $char4.    2 0
..           RURrur_8byte_string_001            138   8$char8.    $char8.    2 0
..           RURrur_8byte_string_002            146   8$char8.    $char8.    2 0
..           RURrur_8byte_string_003            154   8$char8.    $char8.    2 0
..           RURrur_8byte_string_004            162   8$char8.    $char8.    2 0
..           RURrur_30byte_string_001           170  30$char30.   $char30.   2 0
..           RURrur_30byte_string_002           200  30$char30.   $char30.   2 0
..           RURrur_30byte_string_003           230  30$char30.   $char30.   2 0
..           RURrur_30byte_string_004           260  30$char30.   $char30.   2 0
..           RRFrrf_seg_id_version                0   8$char8.    $char8.    2 0
..           RRFrrf_rule_data                     83000$char3000. $char3000. 2 1
..           RRFrrf_build_num                  3008   8Z8.        8.         7 0
..           RRFrrf_rule_id                    3016   7Z7.        7.         7 0
..           RRFrrf_rule_version               3023   4Z4.        4.         7 0
..           RRFrrf_exit_rules_slot_id         3027   4Z4.        4.         7 0
..           RRFrrf_ignore_recommendation      3031   1$char1.    $char1.    2 0
..           RRFrrf_exit_queue_rules_slot_id   3032   4Z4.        4.         7 0
..           RRFrrf_close_alert_a_ind          3036   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_b_ind          3037   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_c_ind          3038   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_d_ind          3039   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_h_ind          3040   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_m_ind          3041   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_o_ind          3042   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_p_ind          3043   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_r_ind          3044   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_t_ind          3045   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_x_ind          3046   1$char1.    $char1.    2 0
..           RRFrrf_close_alert_w_ind          3047   1$char1.    $char1.    2 0
..           CMXcmx_seg_id_version                0   8$CHAR8.    $CHAR8.    2 0
..           CMXcmx_tran_id                       8  16Z16.       16.        7 0
..           CMXcmx_client_amt                   24   8IEEE8.0    IEEE8.0    4 1
..           CMXcmx_mod_amt                      32   8IEEE8.0    IEEE8.0    4 1
..           CMXcmx_lstupdt_user                 40  60$char60.   $char60.   2 0
..           CMXcmx_lstupdt_timestamp           100   8IEEE8.0    IEEE8.0    6 1
..           CMXcmx_create_user                 108  60$char60.   $char60.   2 0
..           CMXcmx_create_timestamp            168   8IEEE8.0    IEEE8.0    6 1
..           CQVcqv_seg_id_version                0   8$char8.    $char8.    2 0
..           CQVcqv_variable_data_length          8   8Z8.        8.         7 0
..           ZMDzmd_seg_id_version                0   8$char8.    $char8.    2 0
..           ZMDzmd_sector01                      8 150$char150.  $char150.  2 0
..           ZMDzmd_sector02                    158 150$char150.  $char150.  2 0
..           ZMDzmd_sector03                    308 150$char150.  $char150.  2 0
..           ZMDzmd_sector04                    458 150$char150.  $char150.  2 0
..           ZMDzmd_selected_pckg_1             608  12$char12.   $char12.   2 0
;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Create entries that define template segment metadata              */
/*                                                                   */
%RUL_Capture_Code(WORK.MSG_API_DICTIONARY.TEMPLATE_SEGMENTS.SOURCE);
CARDS4;
T.            I## . 1400##00     32 r r  87   32
C.            Z## . 1101##01    217 . u 157  217
C.            L## . 1201##00    128 . r 192  128
T.            V## . 1007##00    125 . u 227  125

;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Create entries that define segment metadata                       */
/*                                                                   */
%RUL_Capture_Code(WORK.MSG_API_DICTIONARY.SEGMENTS.SOURCE,
                  cont=Y, /* S0729314 */
                  mod=mod);
CARDS4;
..            SMH . 00000004    118 U R   1
..            SCC . 00000500    137 U U   2
..            SRP . 00000203   1048 . U   3
..            SDA . 00000400    106 . .   4
..            SUS . 00000300     48 . S   5
..            SMC . 00000600     38 . S   6
..            RRR . 01000005    346 W U   7
..            RQO . 01001004     79 R R   8
..            XQO . 01101004    430 R R   9
..            AQO . 01200004    172 R R  10
..            AQC . 01201002    143 R R  11
..            AQD . 01202002    101 R R  12
..            AQS . 01203001     30 R R  13
..            AQL . 01204001     52 R R  14
..            AQB . 01205001     92 R R  15
..            AQR . 01206000    105 R R  16
..            AQM . 01207000     84 R R  17
..            UCM . 01301004     59 R R  18
..            UCC . 01302001    146 R R  19
..            UNM . 01303002     82 R R  20
..            UBT . 01304000     34 R R  21
..            HQO . 01401003    332 R R  22
..            HCT . 01402002    320 R R  23
..            HOB . 01403004    399 R R  24
..            HDF . 01403102    954 R R  25
..            HPB . 01404002     82 R R  26
..            HBB . 01405002     77 R R  27
..            HCP . 01406001     17 R R  28
..            HBP . 01407001     38 R R  29
..            HOT . 01408001     53 R R  30
..            HFC . 01409000     74 R R  31
..            HQM . 01410001    201 R R  32
..            TCA . 01501001    143 R R  33
..            TCP . 01501101    211 R R  34
..            TCM . 01501201    514 R R  35
..            TSH . 01502001    161 R R  36
..            TBT . 01502103    347 R R  37
..            TCK . 01502202    113 R R  38
..            TDP . 01502304    238 R R  39
..            TCW . 01502403    156 R R  40
..            TAQ . 01503001     90 R R  41
..            TAB . 01503102    247 R R  42
..            TAE . 01503201    245 R R  43
..            TPP . 01504004    834 R R  44
..            TNG . 01505002     43 R R  45
..            TMI . 01508003    210 R R  46
..            TMB . 01508103    153 R R  47
..            TMR . 01508201    105 R R  48
..            TMD . 01508301    134 R R  49
..            TMS . 01508402    143 R R  50
..            TML . 01508502    116 R R  51
..            TMC . 01508602     96 R R  52
..            TMO . 01508704    121 R R  53
..            TMP . 01508802     86 R R  54
..            TME . 01508902    344 R R  55
..            TST . 01509001    680 R R  56
..            TSR . 01509101     61 R R  57
..            TMM . 01509201    138 R R  58
..            TMT . 01509403    181 R R  59
..            DNA . 01600102    171 R R  60
..            DNP . 01600201     40 R R  61
..            DNC . 01600301     61 R R  62
..            DNU . 01600402    326 R R  63
..            DNR . 01600501     13 R R  64
..            DNS . 01600601    170 R R  65
..            DNO . 01600701     18 R R  66
..            DNX . 01600802    214 R R  67
..            DCB . 01600902     35 R R  68
..            DCC . 01605001    522 R R  69
..            DCQ . 01606004    151 R R  70
..            DBA . 01606502    435 R R  71
..            DMX . 01609901    268 R R  72
..            DEE . 01610001    404 R R  73
..            DPD . 01611001    259 R R  74
..            DPP . 01612002    711 R R  75
..            DUA . 01614001   1108 R R  76
..            DUS . 01620001    102 R R  77
..            DCH . 01621000    263 R R  78
..            RUA . 01071003   1128 R R  79
..            ROB . 01072001    115 R R  80
..            RDK . 01072501    289 U U  81
..            RUR . 01073002    290 U U  82
..            RRF . 01074003   3048 . U  83
..            CMX . 01077005    176 . R  84
..            CQV . 01078000     16 . U  85   16
..            ZMD . 01075001    620 . U  86
..            CQF . 01076001   1592 . . 262
..            WAX . 13010004    320 . . 263
..            RUX . 13020002    149 . . 264

;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Declare perishable variable info in arrays                        */
/*                                                                   */
/* These statements declare arrays of perishable variable            */
/* information.  See %OSE_Init_Expire_Perishable_Vars for details.   */
/*                                                                   */
%RUL_Capture_Code(WORK.PVARDCL.DECLARE_PERISHABLE_VAR_ARRAYS.SOURCE,
                  mod=mod);
CARDS4;
 


 


 

 
;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Map user-specified names of user variables to uservar colnames    */
/*                                                                   */
/* These statements construct SAS format $UVARNAM that maps          */
/* user-specified ("friendly" or "meaningful") names for uservar     */
/* variables to column names and vice versa.  The code is %include'd */
/* later in macro %CMN_Environment_Initialization to create the      */
/* format definition.  The format is used to substitute the actual   */
/* column name for the user name in %GET/%SET macros in rule code.   */
/*                                                                   */
%RUL_Capture_Code(WORK.UVARMAP.USER_VARIABLE_NAMES_MAPPING.SOURCE,
                  mod=mod);

CARDS4;
 
;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Map multiorg + segment position number to key variable names      */
/*                                                                   */
%RUL_Capture_Code(WORK.USEGMAP.USER_SEGMENT_KEYS_MAPPING.SOURCE,
                  mod=mod);
CARDS4;

;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Map multiorg + segment position number to key variable formats    */
/*                                                                   */
%RUL_Capture_Code(WORK.USEGMAP.USER_SEGMENT_KEY_FMTS_MAPPING.SOURCE,
                  mod=mod);
CARDS4;

;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Map multiorg + segment position number to lists of defined vars   */
/*                                                                   */
%RUL_Capture_Code(WORK.USEGMAP.USER_SEGMENT_VARS_MAPPING.SOURCE,
                  mod=mod);
CARDS4;

;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Map multiorg + segment position number to lists of var formats    */
/*                                                                   */
%RUL_Capture_Code(WORK.USEGMAP.USER_SEGMENT_VAR_FMTS_MAPPING.SOURCE,
                  mod=mod);
CARDS4;

;;;;
;;;;
run;


/*-------------------------------------------------------------------*/
/* Collect OSE lookup list info in catalog entry                     */
/*                                                                   */
/* "CARDS4" input cannot be included in a macro so these statements  */
/* are captured here to define the lookup lists but are processed    */
/* later by %CMN_SETUP_LOOKUP_LISTS which is invoked by macro        */
/* %OSE_ENVIRONMENT_INITIALIZATION.  The actual hash objects are     */
/* loaded during the DATA step in %CMN_LOAD_LOOKUP_LISTS which is    */
/* invoked by %OSE_RULE_INITIALIZATION.                              */
/*                                                                   */
%RUL_Capture_Code(WORK.OSELIST.OSE_LOOKUP_LISTS.SOURCE,
                  mod=mod);
CARDS4;

;;;;
;;;;
run;

/*-------------------------------------------------------------------*/
/* Collect all rule source code in catalog entries                   */
/*                                                                   */
/* "CARDS4" input cannot be included in a macro so these statements  */
/* are captured here to pass rule code to the OSE.  The statements   */
/* are %INCLUDEd with SOURCE2 so any messages have correct line      */
/* numbers.                                                          */
/*                                                                   */
%RUL_Capture_Code(WORK.ARULCAT.OSE_User_Rule_Execution_A.SOURCE);
CARDS4;
   * Rules may use landlord multiorg, so we filter to tenant multiorg here;
   if (SMH_Multi_Org_Node_Key EQ: "A") then
   do;
      RRF_build_num = &RPT_OSE_A_Build_Num;

      %let RPT_SOR_ROOT = _A;
      %let RPT_PACKAGE_ROOT = _A;
      %CMN_Set_Lookup_List_Var_Names(OSE);
      
   end;
;;;;
;;;;
run;

%RUL_Capture_Code(WORK.ARULCAT.OSE_Auth_Rule_Execution_A.SOURCE);
CARDS4;
   * Rules may use landlord multiorg, so we filter to tenant multiorg here;
   if (SMH_Multi_Org_Node_Key EQ: "A") then
   do;
      %let RPT_SOR_ROOT = _A;
      %let RPT_PACKAGE_ROOT = _A;
      %CMN_Set_Lookup_List_Var_Names(OSE);
      
   end;
;;;;
;;;;
run;

%RUL_Capture_Code(WORK.QRULCAT.AGE_Queue_Rule_Execution.SOURCE);
CARDS4;
   %let RPT_SOR_ROOT = _A;
   %let RPT_PACKAGE_ROOT = _A;
   %CMN_Set_Lookup_List_Var_Names(OSE);
   
;;;;
;;;;
run;




/*-------------------------------------------------------------------*/
/* Global macro var definitions moved to here from batch process     */
/* section to be available for hasanyrulefired checking              */
/*                                                                   */
%global rul_var_rule_id_list;
%let    rul_var_rule_id_list = %qcmpres();
%global rul_auth_rule_id_list;
%let    rul_auth_rule_id_list = %qcmpres();
%global rul_queue_rule_id_list;
%let    rul_queue_rule_id_list = %qcmpres();

/* TripWire         */
%global rpt_ose_rule_cnt;
%let rpt_ose_rule_cnt= %eval(&rpt_ose_rule_cnt
                           + 0
                           + 0
                           + 0
                             );

/*-------------------------------------------------------------------*/
/* Now define macros that %include rule code from catalog entries    */
/*                                                                   */
filename ARULCAT catalog "WORK.ARULCAT";

%macro OSE_User_Rule_Execution_A;
%include ARULCAT(OSE_User_Rule_Execution_A.SOURCE) / source2;
%mend;

%macro OSE_Auth_Rule_Execution_A;
%include ARULCAT(OSE_Auth_Rule_Execution_A.SOURCE) / source2;
%mend;

filename QRULCAT catalog "WORK.QRULCAT";

%macro AGE_Queue_Rule_Execution;
   %include QRULCAT(AGE_Queue_Rule_Execution.SOURCE) / source2;
%mend;





/*-------------------------------------------------------------------*/
/* One time initialization done before entering the transaction      */
/* processing loop                                                   */
%macro AGE_RuleFired_Definitions;
   %global RUL_Rule_IDs_Var_TEST_A;
   %global RUL_Rule_IDs_Var_PROD_A;
   %global RUL_Rule_IDs_Auth_TEST_A;
   %global RUL_Rule_IDs_Auth_PROD_A;
   %global RUL_Rule_IDs_Queue_TEST_A;
   %global RUL_Rule_IDs_Queue_PROD_A;
   %let RPT_SOR_ROOT = _A;
   %let RPT_PACKAGE_ROOT = _A;
   
   
   
%mend;


%macro OSE_RuleFired_Definitions_A;
   %global RUL_Rule_IDs_Var_TEST_A;
   %global RUL_Rule_IDs_Var_PROD_A;
   %global RUL_Rule_IDs_Auth_TEST_A;
   %global RUL_Rule_IDs_Auth_PROD_A;
   %let RPT_SOR_ROOT = _A;
   %let RPT_PACKAGE_ROOT = _A;
   
   
%mend;

/* TripWire */
%macro OSE_Create_RuleInfo_A;
   %let RPT_SOR_ROOT = _A;
   %let RPT_PACKAGE_ROOT = _A;
   
   
   
%mend;

/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/
/* Begin batch process information (ignored by online engines)       */
/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/

/*-------------------------------------------------------------------*/
/* Specify which rules to process for estimation/rule testing        */
/*                                                                   */
%global rul_interesting_rule_id_list;
%let    rul_interesting_rule_id_list = %qcmpres();
%global rul_interesting_rule_ver_list;
%let    rul_interesting_rule_ver_list = %qcmpres();



%global rul_var_rule_version_list;
%let    rul_var_rule_version_list = %qcmpres();
%global rul_auth_rule_version_list;
%let    rul_auth_rule_version_list = %qcmpres();
%global rul_queue_rule_version_list;
%let    rul_queue_rule_version_list = %qcmpres();



/*-------------------------------------------------------------------*/
/* Specify which tables to read for estimation/rule testing          */
/*                                                                   */
%global rul_table_names;
%let    rul_table_names = %qcmpres();
%global rul_date_range_table;
%let    rul_date_range_table = %qcmpres();



/*-------------------------------------------------------------------*/
/* Specify which rows to read for estimation/rule testing            */
/*                                                                   */
%global rul_obs_count;
%let    rul_obs_count = ;
%global rul_early_date;
%let    rul_early_date = ;
%global rul_late_date;
%let    rul_late_date = ;
%global rul_priming_date;
%let    rul_priming_date = ;
%global rul_account_prefix;
%let    rul_account_prefix = '';
%global rul_where_clause;
%let    rul_where_clause = ;
%global rul_multi_org_node_keys;
%let    rul_multi_org_node_keys = %qcmpres();
%global rul_combined_component_fields ;
%let    rul_combined_component_fields = ;




/*-------------------------------------------------------------------*/
/* Specify which columns to process for estimation/rule testing      */
/*                                                                   */
%global rul_vars_to_read_from_input;
%let    rul_vars_to_read_from_input = %qcmpres();

%global rul_additional_vars_to_pass_cnt;
%let    rul_additional_vars_to_pass_cnt = 0;

%global rul_additional_vars_to_archive;
%let    rul_additional_vars_to_archive = %qcmpres();





/*-------------------------------------------------------------------*/
/* Specify performance-related values for estimation/rule testing    */
/*                                                                   */
%global RUL_Pipe_Results_To_Summary; %* S0838078;
%let    RUL_Pipe_Results_To_Summary = ;
%global RUL_MEH_In_Memory;
%let    RUL_MEH_In_Memory = ;
%global EST_Sort_In_SAS;
%let    EST_Sort_In_SAS = ;
%global RUL_Estimation_Sample;
%let    RUL_Estimation_Sample = '';
%global EST_Max_Thread_Count;
%let    EST_Max_Thread_Count = 6;
%global RUL_Max_Alert_Entity_Length;
%let    RUL_Max_Alert_Entity_Length = 100;
%global EST_Thread_Work_Areas;
%UTL_Set_Macro_Variable(EST_Thread_Work_Areas);
CARDS4;
 

;;;;
;;;;
run;


%global RUL_Use_Sim_Meh_Ind;
%let    RUL_Use_Sim_Meh_Ind = ;

%global RUL_uv_variables_of_interest;
%let    RUL_uv_variables_of_interest = ;

%global RUL_clientInputVars_of_interest;
%let    RUL_clientInputVars_of_interest = ;

%global RUL_useTransactionFiredBits;
%let    RUL_useTransactionFiredBits = ;

%global RUL_buildNumsOfInterest;
%let    RUL_buildNumsOfInterest = ;

/*-------------------------------------------------------------------*/
/* Specify how to extact Vxx and Ixx during estimation/rule testing  */
/*                                                                   */

%global uv_segs_of_interest;     /* set by java codegen:uv_select_list*/
%global client_segs_of_interest; /* set by java codegen:uv_select_list*/

%global RUL_Join_VXX_Table;      /* set by java codegen:uv_select_list*/
%global RUL_Join_IXX_Table;      /* set by java codegen:uv_select_list*/

%macro uv_select_List();
%mend;


%macro uv_select_by_fieldname();

%mend;


%macro uv_extract_bizname();
%do;
%end;
%mend;



/*-------------------------------------------------------------------*/
/* Control nature of estimation/rule testing results                 */
/*                                                                   */
%RUL_Capture_Code(WORK.JOBCAT.JOB_Header.SOURCE);
CARDS4;


;;;;
;;;;
run;
%RUL_Capture_Code(WORK.JOBCAT.JOB_Trailer.SOURCE);
CARDS4;


;;;;
;;;;
run;
%global rul_user_id;
%UTL_Set_Macro_Variable(rul_user_id); %* S1034379;
CARDS4;
SASxInstitutexIncx_53415320496E7374697475746520496E632E

;;;;
;;;;
run;
%global est_estimate_id;
%let    est_estimate_id = ;
%global est_estimate_table;
%let    est_estimate_table = ;
%global EST_Max_Fired_Transactions;
%let    EST_Max_Fired_Transactions = ;
%global EST_Tran_Status_Report_Seconds;
%let    EST_Tran_Status_Report_Seconds = 60;
%global EST_Max_Estimation_Log_Lines;
%let    EST_Max_Estimation_Log_Lines = 32760;
%global EST_No_Recontact_Days;
%let    EST_No_Recontact_Days = ;
%global EST_Dampen_Firings_Ind;
%let    EST_Dampen_Firings_Ind = ;
%global EST_Report_Per_Rule_Ind;
%let    EST_Report_Per_Rule_Ind = ;
%global EST_Report_Per_Fraud_Type_Ind;
%let    EST_Report_Per_Fraud_Type_Ind = ;
%global EST_Report_Total_Counts_Ind;
%let    EST_Report_Total_Counts_Ind = ;
%global EST_Report_Redist_Alerts_Ind;
%let    EST_Report_Redist_Alerts_Ind = ;
%global EST_Requested_Per_Key_Types;
%let    EST_Requested_Per_Key_Types = ;

%global EST_Allow_DBSlice; %* S1020338;
%let    EST_Allow_DBSlice = 1; %* S1020338;

%global EST_Archive_rules;
%let    EST_Archive_rules = ;

%global RUL_Max_Notes_Per_Rule;
%let    RUL_Max_Notes_Per_Rule = 0;
%global RUL_Max_Note_Text_Length;
%let    RUL_Max_Note_Text_Length = 1;
%global RUL_Max_Highlights_From_Exprs;
%let    RUL_Max_Highlights_From_Exprs = 0;

%global RUL_Highlight_Results_Columns; %* S0870853;
%let    RUL_Highlight_Results_Columns = %cmpres(
        aqo_acct_num rqo_tran_date rqo_tran_time );

%global RUL_Debug_Flag;
%let    RUL_Debug_Flag = %sysfunc(max(0&rul_debug_flag,0));

%global RUL_MAINFRAME_ENCODING;
%let RUL_MAINFRAME_ENCODING = EBCDIC1047; 

/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/
/* End batch process information                                     */
/*-------------------------------------------------------------------*/
/*-------------------------------------------------------------------*/


        %put NOTE: No post-deployment user exit; 



/* Ended encoding ISO8859_1 */

