#!/bin/bash
# $Id: wipeout.sh,v 1.1.2.4 2017/07/12 17:54:43 prsurt Exp $

echo "**************************************************************************"
echo "       !!!!!!!!!!!!!!!!!!!!!! WARNING !!!!!!!!!!!!!!!!!!!!!!              "
echo "This script will delete all indexes and mappings/templates from the "
echo "ElasticSearch Cluster related to Transaction Analysis Server."
echo "It will also delete the checkpoint file in the analysis directory (state.json)." 
echo "Please backup the file if needed!"
echo "**************************************************************************"
if [[ "$1" = "" ]]
then
 echo "Usage: wipeout.sh <elasticsearch ipv4 address> <elasticsearch web port> (default 9200)"
 exit 1
fi
if [[ "$2" = "" ]]
then
 echo "Usage: wipeout.sh <elasticsearch ipv4 address> <elasticsearch web port> (default 9200)"
 exit 1
fi
read -p "Are you sure you want DELETE all data?[Yy/Nn]" -n 1 -r
echo    # (optional) move to a new line
if [[ ! $REPLY =~ ^[Yy]$ ]]
then
    [[ "$0" = "$BASH_SOURCE" ]] && exit 1 || return 1 # handle exits from shell or function but don't exit interactive shell
fi
curl -X PUT -H "Content-Type: application/json"  "http://$1:$2/_cluster/settings" -d '{  "transient": {  "action.destructive_requires_name":false  }}'
curl -X DELETE -H "Cache-Control: no-cache"  "http://$1:$2/_template/esdb*"
curl -X DELETE -H "Cache-Control: no-cache"  "http://$1:$2/esdb*"

PROGRAM_NAME="$0"
typeset BIN=$(dirname "$PROGRAM_NAME")
statefileline=$(grep -P '^(?=[\s]*+[^#])[^#]*(explore.statefile.location.txt)' $BIN/../etc/tas.properties | tail -1)
statefileline=$(echo $statefileline | tr -d [:space:])
statefile="${statefileline#*=}"

if [ -f "$statefile" ] ;  then
  echo "rm -fr ${statefile}"
  rm -fr ${statefile}
else
  echo "The explore.statefile.location.txt entry is missing in tas.properties or does not point to a file"
fi
