<%@ page contentType="text/html; charset=utf-8" %>
<%@ page language="java" %>
<%@ page errorPage="/errorPage.jsp" %>
<% try { // START: DEBUG %>
<%@ taglib uri="/WEB-INF/struts-tiles.tld" prefix="tiles" %>
<%@ page import="com.sas.apps.citation.view.beans.PagePropertyBean"%>
<%@ page import="com.sas.apps.citation.view.util.PageErrorProcessor" %>
<%@ page import="com.sas.apps.citation.view.help.HelpUtils" %>
<%@ page import="com.sas.apps.citation.view.tbeans.html.CitationButton" %>
<%@ page import="com.sas.apps.citation.view.beans.ReportPropertiesFormBean" %>
<%@ page import="com.sas.apps.citation.controller.action.CitationDialogAction" %>
<%@ page import="com.sas.apps.citation.view.util.ViewUtils" %>

<script type="text/javascript"> /*<![CDATA[*/
wrsRequire("citation_button", SCRIPT_DIR, "reportPropertiesDialogContent.jsp");
wrsRequire("citation_fontPicker", SCRIPT_DIR, "reportPropertiesDialogContent.jsp");
/*]]>*/ </script>
<%
    Object rc = request.getAttribute(CitationDialogAction.RESULT_CODE_KEY);
    Object cmdKey = request.getAttribute(CitationDialogAction.DIALOG_CMD_KEY);
    if( CitationDialogAction.RC_SUCCESS.equals(rc)
        && CitationDialogAction.CMD_OK_DIALOG_KEY.equals(cmdKey))
    { %>
<script type="text/javascript"> /*<![CDATA[*/
var winOpener = self.opener;  <%-- close the dialog since the commit was successful --%>
if( winOpener != null && winOpener.cwDialogManager != null) {
  winOpener.cwDialogManager.closeDialogWindow( self ); <%-- op succeeded so close the dialog and dispatch WINDOW_CLOSING & WINDOW_CLOSED events --%>
} else {
  cwDialogManager.closeDialogWindow( self );
}
/*]]>*/ </script>
<%       // Nothing left to do so everything else is a waste of time.
         // exit out of service() method. 
         return; 
    }

CitationButton okButton = CitationButton.createStandaloneButton(request, "okButton",
    PagePropertyBean.getLabelWithMnemonic(pageContext,"ok.button.txt"),
    "g_reportPropertiesDialog.onOkClick();");
request.setAttribute(CitationButton.OK_DIALOG_BUTTON, okButton);

CitationButton cancelButton = CitationButton.createStandaloneButton(request, "cancelButton",
    PagePropertyBean.getLabelWithMnemonic(pageContext,"cancel.button.txt"),
    "cwDialogManager.cancelSelf();");
request.setAttribute(CitationButton.CANCEL_DIALOG_BUTTON, cancelButton);

HelpUtils.createHelpButton(request, HelpUtils.HELP_REPORT_PROPERTIES_GENERAL);

// ++++++++++++++++++++ construct tabs ++++++++++++++++++++
CitationButton generalTabButton = CitationButton.createStandaloneDialogTab(
    request,
    "generalTab",
    PagePropertyBean.getLabelWithMnemonic(pageContext,"properties.dialog.tab.general.txt"),
    "changeTabs(event, 'general', 2);",
    false);         // not active

// ++++++++++++++++++++ construct tabs ++++++++++++++++++++
CitationButton formatTabButton = CitationButton.createStandaloneDialogTab(
    request,
    "formatTab",
    PagePropertyBean.getLabelWithMnemonic(pageContext,"properties.dialog.tab.format.txt"),
    "changeTabs(event, 'format', 2);",
    false);          // not active

%>

<jsp:useBean id="dialogTabsMenu" class="com.sas.apps.citation.view.tbeans.html.menubar.CitationTabsMenu" scope="request"/>
<jsp:useBean id="reportPropertiesForm" class="com.sas.apps.citation.view.beans.ReportPropertiesFormBean" scope="session" />

<%
dialogTabsMenu.add(generalTabButton);
dialogTabsMenu.add(formatTabButton);
dialogTabsMenu.setActiveTab(generalTabButton);
%>
<script type="text/javascript"> /*<![CDATA[*/
// XXXXXXXXXXXXXXXXXXXXXXXXX REPORT PROPERTIES SPECIFIC SCRIPT XXXXXXXXXXXXXXXXXXXXXXXXX

//boolean that indicates whether OK to submit form. Set this flag immediately
//after form is submitted to prevent any subsequent submits while the submit is
//being processed
ReportPropertiesDialog.prototype._isOkToSubmit = true;

ReportPropertiesDialog.prototype.onOkClick = function()
{
    if (!this._isOkToSubmit) {
        return;
    }
    this._isOkToSubmit = false;
    copyCustomColorsToForm();
    this.submit();
}
ReportPropertiesDialog.prototype.submit = function()
{
    var objForm = this.getForm();
    if (objForm != null) {
        objForm.submit();
    }
}
ReportPropertiesDialog.prototype.getForm = function()
{
    return document.forms[this._masterFormName];
}
ReportPropertiesDialog.prototype.getDisplayFilterInfoCheckbox = function()
{
    <%-- 
    TODO store the id on dlg instance during normal markup generation so that
    this script can be moved to a separate js file.
    --%>
    return document.getElementById("displayFilterInfoChecked");
}
ReportPropertiesDialog.prototype.getStyleSchemeSelector = function()
{
    <%-- 
    TODO store the id on dlg instance during normal markup generation so that
    this script can be moved to a separate js file.
    --%>
    return document.getElementById("StyleItems");
}
ReportPropertiesDialog.prototype.onStyleSchemeChange = function()
{
    <%-- 
    TODO store the msg on dlg instance during normal markup generation so that
    this script can be moved to a separate js file.
    --%>
    var styleSchemeSelector = this.getStyleSchemeSelector(); 
    var confirmAnswer;
    if(styleSchemeSelector.options[this.previousSelectedStyleSchemeIndex].value == '<%=ReportPropertiesFormBean.CUSTOM_STYLE_SCHEME_IDENTIFIER%>')
        confirmAnswer = confirm('<%=ViewUtils.escapeForJavaScript(PagePropertyBean.getMessage(pageContext,"properties.dialog.custom.style.change.confirm.txt"))%>');
    else
        confirmAnswer = confirm('<%=PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getMessage(pageContext,"properties.dialog.style.change.confirm.txt"))%>');
    if(!confirmAnswer)
    {
        //recover previous selection if possible
        var previousSelectedIndex = this.previousSelectedStyleSchemeIndex;
        if (previousSelectedIndex == null 
            || previousSelectedIndex < 0
            || previousSelectedIndex >= styleSchemeSelector.options.length)
        {
            previousSelectedIndex = 0;
        }
        styleSchemeSelector.selectedIndex = previousSelectedIndex;
        return;
    }
    //display defaults for new selection
    this.previousSelectedStyleSchemeIndex = styleSchemeSelector.selectedIndex;
    displayDefaultFilterStyles(styleSchemeSelector.selectedIndex);
}
ReportPropertiesDialog.prototype.onDialogLoaded = function()
{
    var styleSchemeSelector = this.getStyleSchemeSelector(); 
    this.previousSelectedStyleSchemeIndex = styleSchemeSelector.selectedIndex;    
    
    <%--
    //ensure the default filter styles for initially selected style scheme are
    //shown if the display filter option is not selected. If the display filter
    //option is checked, we honor the filter styles that have been chosen.
    --%>  
    var displayFilterCb = this.getDisplayFilterInfoCheckbox();
    if (!displayFilterCb.checked)
    {
        displayDefaultFilterStyles(styleSchemeSelector.selectedIndex);
    }
}
function ReportPropertiesDialog() { }

var g_reportPropertiesDialog = new ReportPropertiesDialog();
g_reportPropertiesDialog._masterFormName = "reportPropertiesForm";

function onReportPropertiesDialogLoaded()
{
    g_reportPropertiesDialog.onDialogLoaded();
}

dojo.addOnLoad(onReportPropertiesDialogLoaded);

function changeTabs(event, tab, numItems) 
{
    var whichTab = '';
    var helpLink;
    if (tab.match(/^general$/)) {
        findDOM('formatTabBody').style.display='none';
        findDOM('generalTabBody').style.display='block';
        helpLink = '<%=HelpUtils.getHelpTopicPath(request,HelpUtils.HELP_REPORT_PROPERTIES_GENERAL) %>';
    } else if (tab.match(/^format$/)) {
        findDOM('formatTabBody').style.display='block';
        findDOM('generalTabBody').style.display='none';
        helpLink = '<%=HelpUtils.getHelpTopicPath(request,HelpUtils.HELP_REPORT_PROPERTIES_FORMAT) %>';
        var filterTextColorObj = sas_getJavaScriptObject("filterTextColor");
        if(filterTextColorObj)
        {
            if(findDOM('displayFilterInfoChecked').checked == false)
            {        
                filterTextColorObj.disable();
                showDebugMsgs("changeTabs", "Filter text color picker disabled");
            }
            else
            {
                filterTextColorObj.enable();
                showDebugMsgs("changeTabs", "Filter text color picker enabled");            
            }
        }
        var customColorPickerObj = sas_getJavaScriptObject("customColorPicker");
        if(customColorPickerObj)
        {  
            if(findDOM('defaultColorRadio').checked == true)
            {        
                customColorPickerObj.disable();
                showDebugMsgs("changeTabs", "Graph custom color picker disabled");
            }
            else
            {
                customColorPickerObj.enable();
                showDebugMsgs("changeTabs", "Graph custom color picker enabled");            
            }
        }              
    }
    var helpButton = findDOM('helpButton');
    if (helpButton != null) {
        helpButton.onclick = function(evt) {
          if (cwOpenHelpDocDialog != null) {
          	cwOpenHelpDocDialog(evt, helpLink);
          }
        }
    }
}

    function defaultColorSquareSelected(element)
    {
      findDOM('defaultColorRadio').checked = true;
      defaultClicked()      
    }

    var selectedColorId = null;
    function customColorSquareSelected(element)
    {
      resetBorders();
      selectedColorId = element.id; // remember the last user picked color square
      element.style.borderStyle = 'solid';
      var customColorPickerObj = sas_getJavaScriptObject("customColorPicker");
      if(customColorPickerObj)
      {  
          customColorPickerObj.setSelectedItem(convertRGB(element.style.backgroundColor));
          showDebugMsgs("customColorSquareSelected", "Graph color picker color set: " + convertRGB(element.style.backgroundColor));
      }                  
      
      findDOM('customColorRadio').checked = true;
      customClicked();  
    }
    
    function showColorSquareSelected()
    {
      resetBorders();
      if(selectedColorId == null) // none has been previously picked show the first custom color as 'selected'
        selectedColorId = 'customColor1';
      // get 'selected' element
      var selectedElement = findDOM(selectedColorId);
      if(selectedElement != null)
      {
        selectedElement.style.borderStyle = 'solid';
        var customColorPickerObj = sas_getJavaScriptObject("customColorPicker");
        if(customColorPickerObj)
        {  
            customColorPickerObj.setSelectedItem(convertRGB(selectedElement.style.backgroundColor));
            showDebugMsgs("defaultClicked", "Graph color picker color set: " + convertRGB(selectedElement.style.backgroundColor));
        }           
      } 
    }
    
    function colorPicked()
    {
      if(selectedColorId != null)
      {
        var customColorPickerObj = sas_getJavaScriptObject("customColorPicker");
        if(customColorPickerObj)
        {  
            findDOM(selectedColorId).style.backgroundColor = customColorPickerObj.getSelectedItem();
            showDebugMsgs("colorPicked", "Graph color picker color get: " + customColorPickerObj.getSelectedItem());
        }         
      }
    }    
    
    function resetBorders()
    {
      var colorIdName = "customColor";
      for(index = 1; index <= 12; index++)
      {
        findDOM(colorIdName + index).style.borderStyle = "inset"
      }
    }
    
    function defaultClicked()  // disable custom
    {
      resetBorders(); // clear the selected custom color
      
      //for(var index = 1; index <= 12; index++)
      //{
      //  findDOM("customColor" + index).disabled = true;
      //  findDOM("customColor" + index).style.opacity = ".50";
      //  findDOM("customColor" + index).style.filter = "alpha(opacity=50)";  
      //  findDOM("defaultColor" + index).style.opacity = "1.0";
      //  findDOM("defaultColor" + index).style.filter = "alpha(opacity=100)";              
      //}
      
      var customColorPickerObj = sas_getJavaScriptObject("customColorPicker");
      if(customColorPickerObj)
      {  
          customColorPickerObj.disable();
          showDebugMsgs("defaultClicked", "Graph color picker disabled: ");
      }    
      
    }
    
    function customClicked()  // disable default
    {
      //for(var index = 1; index <= 12; index++)
      //{
      //  findDOM("customColor" + index).disabled = false;
      //  findDOM("customColor" + index).style.opacity = "1.0";
      //  findDOM("customColor" + index).style.filter = "alpha(opacity=100)"; 
      //  findDOM("defaultColor" + index).style.opacity = ".50";
      //  findDOM("defaultColor" + index).style.filter = "alpha(opacity=50)";               
      //}  
      
      var customColorPickerObj = sas_getJavaScriptObject("customColorPicker");
      if(customColorPickerObj)
      {  
          customColorPickerObj.enable();
          showDebugMsgs("defaultClicked", "Graph color picker enabled: ");
      }          
      
      showColorSquareSelected();       
    }    
    
    function copyCustomColorsToForm()
    {
      var theForm = document.forms['reportPropertiesForm'];
      for(var index = 1; index <= 12; index++)
      {
        showDebugMsgs("copyCustomColorsToForm", "Custom color " + index + ": " + findDOM("customColor" + index).style.backgroundColor);
        findDOM("hiddenColor" + index).value = convertRGB(findDOM("customColor" + index).style.backgroundColor);
      }         

    }
    
    function getNewDefaultColors()
    {
        var returnValue = true;
        var sessionTimeout = false;
        
        var index = document.forms['reportPropertiesForm'].styleSchemeIdentifier.selectedIndex;
        var newReportStyle = (document.forms['reportPropertiesForm'].styleSchemeIdentifier.options[index].value);    
        if(newReportStyle != '') 
        {
            dojo.io.bind({
                method: "POST",
                url: "getNewDefaultColors.do?APPLY_CMD_TYPE=GET_DEFAULT_COLORS&REPORT_STYLE=" + newReportStyle
                     + "&session=required",
                load: function(type, data, xhr){
                          if (handleSessionTimeout(data)) {
                             sessionTimeout = true;
                             return;
                          } else {
                             returnValue = getNewDefaultColorsCallback(type, data, xhr);
                          }
                       },
                mimetype: "text/plain"
            });
        } 
        if (sessionTimeout) return;
    }

    function getNewDefaultColorsCallback(type, data, xhr)
    {    
        var returnValue = true;
        var jsonObj = eval('(' + data + ')');
        showDebugMsgs("getNewDefaultColorsCallback", "JSON object new default color 1: " + jsonObj.defaultColor1);
        if(jsonObj.newDefaultColor1 != null) // success
        {   // if the first custom color square is the same as the first default color square 
            // (then it has not been modified) so copy the new style's default color to the 
            // first custom color square. repeat.
            if(findDOM("customColor1").style.backgroundColor == findDOM("defaultColor1").style.backgroundColor)
              findDOM("customColor1").style.backgroundColor = jsonObj.newDefaultColor1;
            if(findDOM("customColor2").style.backgroundColor == findDOM("defaultColor2").style.backgroundColor)
              findDOM("customColor2").style.backgroundColor = jsonObj.newDefaultColor2;
            if(findDOM("customColor3").style.backgroundColor == findDOM("defaultColor3").style.backgroundColor)
              findDOM("customColor3").style.backgroundColor = jsonObj.newDefaultColor3;
            if(findDOM("customColor4").style.backgroundColor == findDOM("defaultColor4").style.backgroundColor)
              findDOM("customColor4").style.backgroundColor = jsonObj.newDefaultColor4;
            if(findDOM("customColor5").style.backgroundColor == findDOM("defaultColor5").style.backgroundColor)
              findDOM("customColor5").style.backgroundColor = jsonObj.newDefaultColor5;
            if(findDOM("customColor6").style.backgroundColor == findDOM("defaultColor6").style.backgroundColor)
              findDOM("customColor6").style.backgroundColor = jsonObj.newDefaultColor6;
            if(findDOM("customColor7").style.backgroundColor == findDOM("defaultColor7").style.backgroundColor)
              findDOM("customColor7").style.backgroundColor = jsonObj.newDefaultColor7;
            if(findDOM("customColor8").style.backgroundColor == findDOM("defaultColor8").style.backgroundColor)
              findDOM("customColor8").style.backgroundColor = jsonObj.newDefaultColor8;
            if(findDOM("customColor9").style.backgroundColor == findDOM("defaultColor9").style.backgroundColor)
              findDOM("customColor9").style.backgroundColor = jsonObj.newDefaultColor9;
            if(findDOM("customColor10").style.backgroundColor == findDOM("defaultColor10").style.backgroundColor)
              findDOM("customColor10").style.backgroundColor = jsonObj.newDefaultColor10;
            if(findDOM("customColor11").style.backgroundColor == findDOM("defaultColor11").style.backgroundColor)
              findDOM("customColor11").style.backgroundColor = jsonObj.newDefaultColor11;
            if(findDOM("customColor12").style.backgroundColor == findDOM("defaultColor12").style.backgroundColor)
              findDOM("customColor12").style.backgroundColor = jsonObj.newDefaultColor12;
              
            // copy the new style's default colors to the default color squares.             
            findDOM("defaultColor1").style.backgroundColor = jsonObj.newDefaultColor1;
            findDOM("defaultColor2").style.backgroundColor = jsonObj.newDefaultColor2;
            findDOM("defaultColor3").style.backgroundColor = jsonObj.newDefaultColor3;
            findDOM("defaultColor4").style.backgroundColor = jsonObj.newDefaultColor4;
            findDOM("defaultColor5").style.backgroundColor = jsonObj.newDefaultColor5;
            findDOM("defaultColor6").style.backgroundColor = jsonObj.newDefaultColor6;
            findDOM("defaultColor7").style.backgroundColor = jsonObj.newDefaultColor7;
            findDOM("defaultColor8").style.backgroundColor = jsonObj.newDefaultColor8;
            findDOM("defaultColor9").style.backgroundColor = jsonObj.newDefaultColor9;
            findDOM("defaultColor10").style.backgroundColor = jsonObj.newDefaultColor10;
            findDOM("defaultColor11").style.backgroundColor = jsonObj.newDefaultColor11;
            findDOM("defaultColor12").style.backgroundColor = jsonObj.newDefaultColor12; 
            
            showDebugMsgs("getNewDefaultColorsCallback", "Received new default colors successfully.");
        }
        else
            showDebugMsgs("getNewDefaultColorsCallback", "Nothing returned from getNewDefaultColorsReturn.");
           
        return(returnValue);
    }  
    
    // used to convert Firefox element.style.backgroundColor from "rgb(255,0,0)" format to "#ff0000"
    function convertRGB(colorStr) 
    {
        if(colorStr.substring(0, 3) == 'rgb')
        {
            colorStr = colorStr.replace(/rgb\(|\)/g, "")
            colorStr = colorStr.split(",");
            // convert from base 10 to hex and make lower case
            colorStr[0] = parseInt(colorStr[0], 10).toString(16).toLowerCase();
            colorStr[1] = parseInt(colorStr[1], 10).toString(16).toLowerCase();
            colorStr[2] = parseInt(colorStr[2], 10).toString(16).toLowerCase();
            // if single digit then left hand fill with zero
            colorStr[0] = (colorStr[0].length == 1) ? '0' + colorStr[0] : colorStr[0];
            colorStr[1] = (colorStr[1].length == 1) ? '0' + colorStr[1] : colorStr[1];
            colorStr[2] = (colorStr[2].length == 1) ? '0' + colorStr[2] : colorStr[2];
            // combine the hex chars with a leading pound sign
            return ('#' + colorStr.join(""));
        }
        return(colorStr);
    }
                 
    function initializeDialog()
    {
        findDOM("defaultColor1").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[0]%>';
        findDOM("defaultColor2").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[1]%>';
        findDOM("defaultColor3").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[2]%>';
        findDOM("defaultColor4").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[3]%>';
        findDOM("defaultColor5").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[4]%>';
        findDOM("defaultColor6").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[5]%>';
        findDOM("defaultColor7").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[6]%>';
        findDOM("defaultColor8").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[7]%>';
        findDOM("defaultColor9").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[8]%>';
        findDOM("defaultColor10").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[9]%>';
        findDOM("defaultColor11").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[10]%>';
        findDOM("defaultColor12").style.backgroundColor = '<%=reportPropertiesForm.getDefaultGraphColors()[11]%>';
        
        findDOM("customColor1").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[0]%>';
        findDOM("customColor2").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[1]%>';
        findDOM("customColor3").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[2]%>';
        findDOM("customColor4").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[3]%>';
        findDOM("customColor5").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[4]%>';
        findDOM("customColor6").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[5]%>';
        findDOM("customColor7").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[6]%>';
        findDOM("customColor8").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[7]%>';
        findDOM("customColor9").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[8]%>';
        findDOM("customColor10").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[9]%>';
        findDOM("customColor11").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[10]%>';
        findDOM("customColor12").style.backgroundColor = '<%=reportPropertiesForm.getCustomGraphColors()[11]%>';        
    
        <%
          if(reportPropertiesForm.getColorType().equalsIgnoreCase(ReportPropertiesFormBean.DEFAULT_COLORS))
          {        
        %>
            defaultClicked();
        <%
          }
          else
          {
        %>
            customClicked();
            showColorSquareSelected();
        <%
          }
        %>                
    }
    
    dojo.addOnLoad(initializeDialog);

// XXXXXXXXXXXXXXXXXXXXXXXXX (END) REPORT PROPERTIES SPECIFIC SCRIPT XXXXXXXXXXXXXXXXXXXXXXXXX
/*]]>*/ </script>

<div style="width: 100%; height: 100%; padding: 20px 10px 0px 10px;">

<tiles:insert definition="dialogTabsLayout">
    <tiles:put name="dialogTabsContent" value="/tiles-components/reportPropertiesDialogTabContent.jsp"/>
</tiles:insert>

</div>
<% } catch (Exception ex) {
    PageErrorProcessor.setJspError(ex, pageContext, out);
} // END: DEBUG %>
