<%@ page contentType="text/html; charset=utf-8" %>
<%@ page language="java" %>
<%@ page errorPage="/errorPage.jsp" %>
<%@ taglib uri="/WEB-INF/citation.tld" prefix="citation" %>

<%@ page import="com.sas.apps.citation.controller.action.CitationDialogAction" %>

<%@ page import="com.sas.apps.citation.util.PropertyHelper" %>
<%@ page import="com.sas.apps.citation.view.tbeans.html.CitationButton" %>
<%@ page import="com.sas.apps.citation.view.beans.PagePropertyBean" %>
<%@ page import="com.sas.apps.citation.view.help.HelpUtils" %>
<%@ page import="com.sas.apps.citation.util.CommonUtils" %>
<%@ page import="com.sas.servlet.tbeans.html.TabMenu" %>
<%@ page import="com.sas.servlet.tbeans.html.TabButton" %>

<%@page import="com.sas.apps.citation.view.tbeans.html.richtexteditor.RichTextEditorWRS" %>
<%@page import="com.sas.apps.citation.view.tbeans.html.richtexteditor.RichTextEditFieldWRS" %>

<%@ page import="com.sas.text.Message" %>
<%@ page import="com.sas.util.Strings" %>
<%@ page import="com.sas.apps.citation.view.beans.reportlinking.BuilderReportLinkingDialogFormBean" %>               
<%@ page import="com.sas.apps.citation.view.beans.reportbuilder.AbstractBuilderHeaderFooterDialogFormBean" %>

<%@page import="com.sas.servlet.tbeans.FontPickerKeysInterface" %>
<%@page import="com.sas.servlet.tbeans.html.*" %>
<%@page import="com.sas.servlet.tbeans.form.html.TextEntry" %>
<%@page import="com.sas.servlet.tbeans.util.validators.HexColorStringValidator" %>
<%@page import="com.sas.servlet.tbeans.models.*" %>
<%@page import="com.sas.servlet.tbeans.StyleInfo" %>
<%@page import="com.sas.apps.citation.view.util.ThemeUtils" %>
<%@page import="java.util.HashMap" %>

<% try { // START: DEBUG %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-tiles.tld" prefix="tiles" %>
<%@ taglib uri="/WEB-INF/citation.tld" prefix="citation" %>
<html:xhtml />
<%
// if OK was successful then close window
String dlgCmd = (String) request.getAttribute(CitationDialogAction.DIALOG_CMD_KEY);
if ( CitationDialogAction.CMD_OK_DIALOG_KEY.equals(dlgCmd) ) {
%>
  <script type="text/javascript"> /*<![CDATA[*/
  function closeSelf()
  {
      var winOpener = self.opener;
      if (winOpener != null) {
          if (winOpener.cwDialogManager != null) {
              winOpener.cwDialogManager.closeDialogWindow( self ); <%-- op succeeded so close the dialog and dispatch WINDOW_CLOSING & WINDOW_CLOSED events --%>
          }
      } else {
          cwDialogManager.closeDialogWindow( self );
      }
  }

  closeSelf();
  
  
   /*]]>*/ </script>
<%
    return; //fast return from service method
}

%>
<jsp:useBean id="builderHeaderDialogForm" class="com.sas.apps.citation.view.beans.reportbuilder.BuilderHeaderDialogFormBean" scope="session" />
<jsp:useBean id="builderFooterDialogForm" class="com.sas.apps.citation.view.beans.reportbuilder.BuilderFooterDialogFormBean" scope="session" />

<%
boolean showDebugControls = PropertyHelper.getPropertyAsBool("wrs.editText.debugDialog", false); // (brcarb)
//boolean showDebugControls = false;
String formAction = (String)request.getAttribute("FORM_ACTION");
String formToUse = (formAction.equals("builderHeader.do")) ? "builderHeaderDialogForm" : "builderFooterDialogForm";
// Get whichever form bean is being used, header or footer:
AbstractBuilderHeaderFooterDialogFormBean formBean = builderHeaderDialogForm;
if ("builderFooterDialogForm".equals(formToUse)) {
   formBean = builderFooterDialogForm;
}


CitationButton okButton = CitationButton.createStandaloneButton(request, "okButton",
    PagePropertyBean.getLabelWithMnemonic(pageContext,"ok.button.txt"),
    "onClickButtonOk(event)");
request.setAttribute(CitationButton.OK_DIALOG_BUTTON, okButton);

CitationButton cancelButton = CitationButton.createStandaloneButton(request, "cancelButton",
    PagePropertyBean.getLabelWithMnemonic(pageContext,"cancel.button.txt"),
    "cwDialogManager.cancelSelf();");
request.setAttribute(CitationButton.CANCEL_DIALOG_BUTTON, cancelButton);

int helpTopic = (formAction.equals("builderHeader.do")) ?
  HelpUtils.HELP_BUILDER_SECTION_HEADER : HelpUtils.HELP_BUILDER_SECTION_FOOTER;
HelpUtils.createHelpButton(request, helpTopic);

String textEditVar = null;  // These must be declared before the form tag
String editorVar = null;
String msgCannotInsertDynamic = null;
String msgMultiParaStyleChange = null;
String overrideColor = null;
String overrideBackgroundColor = null;

String msgNoTextSelected = null;
String msgTooltipHyperlink = null;
String msgLinkNothingSelected = null;
String msgLinkCannotCreate = null;
String msgLinkMultipleSelect = null;
String initialSelection = null;
            
String bannerAlignLeftTooltip = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "style.align.left.txt"));
String bannerAlignCenterTooltip = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "style.align.center.txt"));
String bannerAlignRightTooltip = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "style.align.right.txt"));
String imageHyperlinkTooltip = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "hyperlink.txt"));
String widthLabel = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.width.label.txt"));
String percentText = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.percent.txt"));
String leftContentText = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.left.content.fmt.txt"));
String middleContentText = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.middle.content.fmt.txt"));
String rightContentText = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.right.content.fmt.txt"));
String msgInvalidWidth = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.invalid.width.error.txt"));
String msgInvalidWidthSum = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "builder.headerfooter.invalid.width.sum.error.txt"));

// Get the initially-selected option for the left, middle and right Content combo boxes (HTML select),
// which will be "OPTION_NONE", "OPTION_TEXT" or the URL of an image (e.g., starts with SBIP:...)
String leftContentOption = formBean.getLeftContentOption();
String middleContentOption = formBean.getMiddleContentOption();
String rightContentOption = formBean.getRightContentOption(); 

// Get the initial widths for the left, middle and right content, which must sum to 100%
String leftWidth = formBean.getLeftWidth();
String middleWidth = formBean.getMiddleWidth();
String rightWidth = formBean.getRightWidth();

// Get the initial HTML content for the RichTextEditorWRS for each possible position:
String leftInitialHtml = formBean.getLeftEncodedHtml();
String middleInitialHtml = formBean.getMiddleEncodedHtml();
String rightInitialHtml = formBean.getRightEncodedHtml();

// Get initial full URL for selected images (e.g. starts with HTTP://..., not SBIP:...)
String leftInitialImageUrl = formBean.getBrowserUrlForLeftImage();
String middleInitialImageUrl = formBean.getBrowserUrlForMiddleImage();
String rightInitialImageUrl = formBean.getBrowserUrlForRightImage();

// Get the inital image alignments for left/middle/right content
String leftImageAlignment = formBean.getLeftImageAlignment();
String middleImageAlignment = formBean.getMiddleImageAlignment();
String rightImageAlignment = formBean.getRightImageAlignment();

// Get initial image links
String leftImageLink = formBean.getLeftImageLink();
String middleImageLink = formBean.getMiddleImageLink();
String rightImageLink = formBean.getRightImageLink();

// Get initial image tooltips
String leftImageTooltip = formBean.getLeftImageTooltip();
String middleImageTooltip = formBean.getMiddleImageTooltip();
String rightImageTooltip = formBean.getRightImageTooltip();

// Get initial image use current window
boolean leftImageUseCurrentWindow = formBean.getLeftImageUseCurrentWindow();
boolean middleImageUseCurrentWindow = formBean.getMiddleImageUseCurrentWindow();
boolean rightImageUseCurrentWindow = formBean.getRightImageUseCurrentWindow();

// (brcarb) This property is false if using WRS 4.4  square-bracketed dynamic items in the dialog,
// true if using old-style special SPANs to representing dynamic items: 
boolean useLegacyDynamicItems = formBean.getUseLegacyDynamicItems();

// Try and figure out if each link is a web link or report link
String leftImageLinkType = null;
if(leftImageLink != null)
    leftImageLinkType = formBean.isWebUrl(leftImageLink) ? 
        BuilderReportLinkingDialogFormBean.WEB_SITE_STR : BuilderReportLinkingDialogFormBean.ANOTHER_REPORT_STR;
String middleImageLinkType = null;
if(middleImageLink != null)
    middleImageLinkType = formBean.isWebUrl(middleImageLink) ? 
        BuilderReportLinkingDialogFormBean.WEB_SITE_STR : BuilderReportLinkingDialogFormBean.ANOTHER_REPORT_STR;    
String rightImageLinkType = null;
if(rightImageLink != null)
    rightImageLinkType = formBean.isWebUrl(rightImageLink) ? 
        BuilderReportLinkingDialogFormBean.WEB_SITE_STR : BuilderReportLinkingDialogFormBean.ANOTHER_REPORT_STR;       
%>

<style type="text/css">

    #tabMenuDiv {
        width:98%;
    }
    
    #contentTemplateDiv {
        width:98%;
        border-left:solid 1px #888888;
        border-right:solid 1px #888888;
        border-bottom:solid 1px #888888;
    }
    
    #contentChooserTable {
        width:98%;
        padding-left:8px;
        padding-top:8px;
    }
    
    #contentImageAlignmentDiv {
        padding-top:8px;
    }
    
</style>

<script type="text/javascript" src="scripts/citation_RichEditor.js"></script>

<citation:form action="<%= formAction %>">


  <html:hidden property="<%=CitationDialogAction.DIALOG_CMD_KEY %>" styleId="<%=CitationDialogAction.DIALOG_CMD_KEY %>" value="<%=CitationDialogAction.CMD_OK_DIALOG_KEY %>"/>
  <html:hidden styleId="bannerAlignment" property="bannerImageAlignment"/>
  <html:hidden styleId="bandTextHidden" property="text"/>
  <html:hidden styleId="leftContentOptionHidden" property="leftContentOption"/>
  <html:hidden styleId="middleContentOptionHidden" property="middleContentOption"/>
  <html:hidden styleId="rightContentOptionHidden" property="rightContentOption"/>
  <html:hidden styleId="leftWidthHidden" property="leftWidth"/>
  <html:hidden styleId="middleWidthHidden" property="middleWidth"/>  
  <html:hidden styleId="rightWidthHidden" property="rightWidth"/>
  <html:hidden styleId="leftHtmlHidden" property="leftHtml"/>
  <html:hidden styleId="middleHtmlHidden" property="middleHtml"/>
  <html:hidden styleId="rightHtmlHidden" property="rightHtml"/>
  <html:hidden styleId="leftImageAlignmentHidden" property="leftImageAlignment"/>
  <html:hidden styleId="middleImageAlignmentHidden" property="middleImageAlignment"/>
  <html:hidden styleId="rightImageAlignmentHidden" property="rightImageAlignment"/>
  <html:hidden styleId="leftImageLinkHidden" property="leftImageLink"/>
  <html:hidden styleId="middleImageLinkHidden" property="middleImageLink"/>
  <html:hidden styleId="rightImageLinkHidden" property="rightImageLink"/>  
  <html:hidden styleId="leftImageTooltipHidden" property="leftImageTooltip"/>
  <html:hidden styleId="middleImageTooltipHidden" property="middleImageTooltip"/>
  <html:hidden styleId="rightImageTooltipHidden" property="rightImageTooltip"/>    
  <html:hidden styleId="leftImageUseCurrentWindowHidden" property="leftImageUseCurrentWindow"/>
  <html:hidden styleId="middleImageUseCurrentWindowHidden" property="middleImageUseCurrentWindow"/>
  <html:hidden styleId="rightImageUseCurrentWindowHidden" property="rightImageUseCurrentWindow"/>   
  
  
<div id="dialogContainer" style="width:100%; padding:8px;">  

    <div id="bannerImageDiv" style="width:100%">


        <!-- Layout table for top full-width banner image controls and thumbnail -->
            
        <table style="width:100%;padding:8px;" border="0" cellpadding="0" cellspacing="0" summary="">
            <tr>
                <th align="left" class="header" style="width:25%;padding-top:0px;padding-bottom:0px;">
                    <label for="bannerImage"
                           accesskey='<%= PagePropertyBean.getMnemonic(pageContext,
                                                                   "builder.headerfooter.banner.label.txt") %>' >
                       <%= PagePropertyBean.getLabelWithMnemonic(pageContext, "builder.headerfooter.banner.label.txt") %>
                    </label>
                </th>
                <td width="60%" align="left" style="padding-top:0px;padding-bottom:0px;">
                    <html:select style="width: 100%"
                                property="bannerImage"
                                styleClass="dropdown"
                                styleId="bannerImage" onchange='javascript:onImageChange()'>
                        <html:option value="None" key="none.txt">
                        </html:option>
                        <html:optionsCollection property="bannerImages"/>
                    </html:select>
                </td>
                <td class="buttonSpacer" style="padding-top:0px;padding-bottom:0px;">&nbsp;</td>
                <td style="width:50px; text-align:right; vertical-align:top;padding-top:0px;padding-bottom:0px;">
                    <table id="alignBody" border="0" cellpadding="0" cellspacing="0" width="100%" summary="" >
                     <tr>
                            <td class="fontPickerAlignLeftButton">
                                <button id="banner_align_left_button" class="imageButton" onclick="setBannerAlignment('left');" title="<%=bannerAlignLeftTooltip%>" type="button">
                                    <div id="banner_align_left_div" class="imageSelectedStyle">
                                        <img id="banner_align_left_img" class="imageButton" border="0" alt="<%=bannerAlignLeftTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_Align_Left_Text")%>' />
                                    </div>
                                </button>
                            </td>
                            <td class="fontPickerAlignCenterButton">
                                <button id="banner_align_center_button" class="imageButton" onclick="setBannerAlignment('center');" title ="<%=bannerAlignCenterTooltip%>" type="button">
                                    <div id="banner_align_center_div" class="imageStyle">
                                        <img id="banner_align_center_img" class="imageButton" border="0" alt="<%=bannerAlignCenterTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_Align_Center_Text")%>' />
                                    </div>
                                </button>
                            </td>
                            <td class="fontPickerAlignRightButton">
                                <button id="banner_align_right_button" class="imageButton" onclick="setBannerAlignment('right');" title ="<%=bannerAlignRightTooltip%>" type="button">
                                    <div id="banner_align_right_div" class="imageStyle">
                                        <img id="banner_align_right_img" class="imageButton" border="0" alt="<%=bannerAlignRightTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_Align_Right_Text")%>' />
                                    </div>
                                </button>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="4" style="padding-top:0px;padding-bottom:0px;width:100%;">

                <!-- Banner thumbnail -->
             <%
                boolean showImageThumbnailContainer =
                     !CommonUtils.isEmptyOrWhiteSpace(formBean.getBrowserUrlForSelectedImageThumbnail());
             %>
                    <div id="selectedImageThumbnailContainer" style="width:100%;">
                        <div id="thumbnailContainer_imageSelected" align="center" style="display:<%=(showImageThumbnailContainer ? "block" : "none")%>;">
                            <img src="<%=formBean.getBrowserUrlForSelectedImageThumbnail()%>"
                                        id="thumbnailImageElement" alt="" style="border: 1px solid #919190;"
                                        />
                        </div>
                    </div>
                </td>
            </tr>
        </table>
            
    </div>  <!-- end bannerImageDiv -->
    
    <!-- Start of Content Template, the container for tabs, width/conains controls, and rich text editor or image preview area -->
    
    <div  id="tabMenuDiv">
    

<%
    TabMenu tabMenu = new TabMenu();
    tabMenu.setId("contentTabsMenu");

    TabButton leftTabButton = new TabButton();
    leftTabButton.setId("leftTabButton");
    String formattedLeftContent = Strings.replace(leftContentText, 0, -1, "{0}", leftWidth);
    leftTabButton.setLabel(formattedLeftContent);
    leftTabButton.setOnClick("onClickTabButton('left')");

    TabButton middleTabButton = new TabButton();
    middleTabButton.setId("middleTabButton");
    String formattedMiddleContent = Strings.replace(middleContentText, 0, -1, "{0}", middleWidth);
    middleTabButton.setLabel(formattedMiddleContent);
    middleTabButton.setOnClick("onClickTabButton('middle')");
    
    TabButton rightTabButton = new TabButton();
    rightTabButton.setId("rightTabButton");
    String formattedRightContent = Strings.replace(rightContentText, 0, -1, "{0}", rightWidth);
    rightTabButton.setLabel(formattedRightContent);
    rightTabButton.setOnClick("onClickTabButton('right')");
    
    tabMenu.add(leftTabButton);
    tabMenu.add(middleTabButton);
    tabMenu.add(rightTabButton);        
    
    tabMenu.setActiveTab(middleTabButton);  // Always start with middle tab selected  
    
    tabMenu.setLook(TabMenu.DEFAULT_TAB_LOOK);

    tabMenu.setRequest(request);
    tabMenu.setResponse(response); 
    tabMenu.write(out);


%>
    </div>
    <div  id="contentTemplateDiv">
        <table id="contentChooserTable" border="0" cellpadding="0" cellspacing="0" summary="">
            <tr>
                <td class="header"><%=widthLabel %></td>
                <td><input id="inputTextWidth" value="<%=middleWidth%>" type="text" style="width:30px;" maxlength="3" onkeypress="allowNumericOnly(event)" onkeyup="onKeyUpWidthText(event)" />&nbsp;<%=percentText%></td>
                <td>&nbsp;</td>
                <td class="header">
                    <label for="contentCombo"
                           accesskey='<%= PagePropertyBean.getMnemonic(pageContext,
                                                                   "builder.headerfooter.content.label.txt") %>' >
                       <%= PagePropertyBean.getLabelWithMnemonic(pageContext, "builder.headerfooter.content.label.txt") %>
                    </label>
                </td>
                <td style="width:350px;">
                    <html:select style="width:100%"
                                    property="middleContentOption"
                                    styleClass="dropdown"
                                    styleId="contentCombo" onchange="onChangeContentCombo(event)" >
                        <html:optionsCollection property="contentOptions"/>
                    </html:select>
                </td>
                <td style="width:50px; text-align:right; vertical-align:top;padding-top:0px;padding-bottom:0px;">
                    
                    <!-- image alignment buttons, only visible when content is image -->
                    
                    <div id="contentImageAlignmentDiv" style="visibility:hidden;">
                        <table id="contentImageAlignTable" border="0" cellpadding="0" cellspacing="0" width="100%" summary="" >
                            <tr>
                                <td class="fontPickerAlignLeftButton">
                                    <button id="contentImageAlignLeftButton" class="imageButton" onclick="setContentImageAlign('left');" title="<%=bannerAlignLeftTooltip%>" type="button">
                                        <div id="contentImageAlignLeftDiv" class="imageStyle">
                                            <img id="contentImageAlignLeftImg" class="imageButton" border="0" alt="<%=bannerAlignLeftTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_Align_Left_Text")%>' />
                                        </div>
                                    </button>
                                </td>
                                <td class="fontPickerAlignCenterButton">
                                    <button id="contentImageAlignCenterButton" class="imageButton" onclick="setContentImageAlign('center');;" title ="<%=bannerAlignCenterTooltip%>" type="button">
                                        <div id="contentImageAlignCenterDiv" class="imageSelectedStyle">
                                            <img id="contentImageAlignCenterImg" class="imageButton" border="0" alt="<%=bannerAlignCenterTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_Align_Center_Text")%>' />
                                        </div>
                                    </button>
                                </td>
                                <td class="fontPickerAlignRightButton">
                                    <button id="contentImageAlignRightButton" class="imageButton" onclick="setContentImageAlign('right');" title ="<%=bannerAlignRightTooltip%>" type="button">
                                        <div id="contentImageAlignRightDiv" class="imageStyle">
                                            <img id="contentImageAlignRightImg" class="imageButton" border="0" alt="<%=bannerAlignRightTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_Align_Right_Text")%>' />
                                        </div>
                                    </button>
                                </td>
                                <td>
                                    <button id="imageHyperlinkButton" class="imageButton" onclick="WRS_onWaitCreateImageHyperLink();" title ="<%=imageHyperlinkTooltip%>" type="button">
                                        <div id="imageHyperlinkDiv" class="imageStyle">
                                            <img id="imageHyperlinkImg" class="imageButton" border="0" alt="<%=imageHyperlinkTooltip%>" src='<%=ThemeUtils.getImageSourceURL(request,"wrs_hyperlink")%>' />
                                        </div>
                                    </button>
                                </td>                                
                            </tr>
                        </table>
                    </div>
                    
                </td>
            </tr>
        </table>

        <!-- Rich text editor and dynamic text subpane, only shown when content is text -->

        <div id="richTextDiv" style="width:100%;padding-top:6px;">

            <table style="width:98%;padding:8px;padding-right:0px;" border="0" cellpadding="0" cellspacing="0" summary="">
                <tr>
                    <td style="padding-top:2px;padding-bottom:0px;">
<%
            // Get the localized messages that will be needed by the JavaScript rich text editor extension for WRS:
            msgCannotInsertDynamic = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "error.dynamic.text.cannot.insert.txt"));
            msgNoTextSelected = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "style.noTextSelected.txt"));
            msgTooltipHyperlink = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "hyperlink.txt"));
            msgLinkNothingSelected = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "error.text.hyperlink.nothing.selected.txt"));
            msgLinkCannotCreate = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "error.text.hyperlink.cannot.create.txt"));
            msgLinkMultipleSelect = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "error.text.hyperlink.multiple.select.txt"));
            initialSelection = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "none.txt"));

            // Get message needed by JavaScript in RichTextEditFieldWRS component:
            msgMultiParaStyleChange = PagePropertyBean.escapeQuotesOnly(PagePropertyBean.getLabel(pageContext, "error.richtexteditfield.multi.para.style.change.txt"));

            // Get the strings representing the default text and background color
            overrideColor = formBean.getAutomaticColorOverride();
            overrideBackgroundColor = formBean.getAutomaticBackgroundColorOverride();

            // Instantiate a RichTextEditorWRS with a JavaScript citation_RichTextEditor class instance
            // variable named "headerFooterEditor":
            RichTextEditorWRS richTextEditor = new RichTextEditorWRS("headerFooterEditor");
            richTextEditor.setRequest(request);
            richTextEditor.setResponse(response);
            // Get the FontPicker sub-component and RichTextEditFieldWRS subcomponent:
            FontPicker fontPicker = richTextEditor.getFontPicker();
            RichTextEditFieldWRS textEdit  = richTextEditor.getRichTextEditField();

            StyleInfo textEditStyleInfo = new StyleInfo();
            textEditStyleInfo.setStyle("width:100%;");
            textEdit.setStyleInfo(textEditStyleInfo);

            // Set the temporary initial HTML content (just an empty P element).  Actual HTML passed in will be set later.
            String defaultFontFamily = formBean.getTextFontName();  // S0664251
            if (null == defaultFontFamily || defaultFontFamily.length() < 1)
            {
                defaultFontFamily = "Arial";    // Last resort
            }
            String initialHtml = "<html><body style=\"font-family:" + defaultFontFamily + "; font-size:11pt; font-weight:normal; font-style:normal; text-decoration:none; text-align:left; background-color:transparent; color:black\"><P style=\"margin:0px;\">&nbsp;</P></body></html>";
            // Set the initial HTML content that will be passed in the
            // JavaScript constructor for the citation_RichTextEditField object.
            textEdit.setInitialHtml(initialHtml);
            
            // WRS 4.3 hotfix (for EBI) 
        // For WRS, font picker template has Link image at the right end:
        fontPicker.setTemplateKey("wrs_RTE_Font_Picker");
        HashMap dictionary = fontPicker.getTemplateDictionary();
        if (dictionary == null)
        {
            fontPicker.setTemplateDictionary(new HashMap());
        dictionary = fontPicker.getTemplateDictionary();
        }
        dictionary.put("WRS_FONTPICKER_HYPERLINK_IMAGE",ThemeUtils.getImageSourceURL(request, "wrs_hyperlink"));
        // end of WRS 4.3 hotfix (for EBI)             

            // Initialize font picker model with the WRS-specific font names and point sizes.
            FontPickerModel fontPickerModel = (FontPickerModel) fontPicker.getModel();
            ItemInterface[] fontNameItems = formBean.getFontNameArray(pageContext);
            fontPickerModel.setFontNames(fontNameItems);
            ItemInterface[] fontSizeItems = formBean.getFontSizeArray(pageContext);
            fontPickerModel.setFontSizes(fontSizeItems);

            // Set available colors on the font picker model
            ItemInterface[] foregroundColorItems = formBean.getForegroundColorArray(pageContext);
            fontPickerModel.setForegroundColors(foregroundColorItems);
            ItemInterface[] backgroundColorItems = formBean.getBackgroundColorArray(pageContext);
            fontPickerModel.setBackgroundColors(backgroundColorItems);

            // Enable the display of "Automatic" in the drop-down palette
            // as a choice in the dropdown list:
            ColorPicker foregroundColorPicker = (ColorPicker) fontPicker.getComponent(FontPickerKeysInterface.FONTPICKER_FOREGROUND_COLOR_COMPONENT);
            foregroundColorPicker.setAutomaticVisible(true);
            foregroundColorPicker.setAutomaticColor(overrideColor, false);
            
            String errorMessage = PagePropertyBean.getLabel(pageContext, "colorpicker.color.value.error.txt"); /* I18nOK:LINE */
            
            TextEntry foregroundTextEntry = ((TextEntry)foregroundColorPicker.getComponent("PALETTE_CUSTOM_COMPONENT")); /* I18nOK:LINE */
            HexColorStringValidator foregroundValidator = ((HexColorStringValidator)foregroundTextEntry.getValidator());
            foregroundValidator.setValidationMessage(new Message(errorMessage, 0));                 
            foregroundColorPicker.setAllowCustomEntry(true);
            
            String foregroundColorPickerTooltip = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "colorpicker.tooltip.txt"));
            foregroundColorPicker.setTitle(foregroundColorPickerTooltip);
            
            ColorPicker backgroundColorPicker = (ColorPicker) fontPicker.getComponent(FontPickerKeysInterface.FONTPICKER_BACKGROUND_COLOR_COMPONENT);
            backgroundColorPicker.setAutomaticVisible(true);
            backgroundColorPicker.setAutomaticColor(overrideBackgroundColor, false);
            String backgroundColorPickerTooltip = PagePropertyBean.escapeQuotes(PagePropertyBean.getLabel(pageContext, "colorpicker.background.tooltip.txt"));
            backgroundColorPicker.setTitle(backgroundColorPickerTooltip);
            
            TextEntry backgroundTextEntry = ((TextEntry)backgroundColorPicker.getComponent("PALETTE_CUSTOM_COMPONENT")); /* I18nOK:LINE */
            HexColorStringValidator backgroundValidator = ((HexColorStringValidator)backgroundTextEntry.getValidator());
            backgroundValidator.setValidationMessage(new Message(errorMessage, 0));             
            backgroundColorPicker.setAllowCustomEntry(true);

            // Render the composite RichTextEditorWRS:
            richTextEditor.write(out);

            // Get the names of the JavaScript citation_RichTextEditField instance variable
            // and the citation_RichTextEditor instance variable that owns it:
            textEditVar = richTextEditor.getJavaScriptTextEditObjectName();
            editorVar = richTextEditor.getJavaScriptObjectName();  // same as id, "headerFooterEditor"

%>
                    </td>
                </tr>
                <tr>
                    <td style="padding-top:6px;padding-bottom:4px;">
                        <table style="width:100%" border="0" cellpadding="0" cellspacing="0" summary="">
                        
                            <tr>
                                <td class="header" style="width:30%;">
                                    <label for="dynamicText"
                                                accesskey='<%= PagePropertyBean.getMnemonic(pageContext, "dynamic.text.insertdynamic.label.txt") %>' >
                                                <%= PagePropertyBean.getLabelWithMnemonic(pageContext, "dynamic.text.insertdynamic.label.txt") %>
                                    </label>
                                </td>
                                <td style="width:55%">
                                </td>
                                <td style="padding-left:8px">
                                </td>
                            </tr>                        
                            
                            <!-- ******************************************************************
                            <tr>
                                <td class="header" style="width:30%;">
                                    <label for="measure"
                                        accesskey='<%= PagePropertyBean.getMnemonic(pageContext, "dynamic.text.measure.label.txt") %>' >
                                        <%= PagePropertyBean.getLabelWithMnemonic(pageContext, "dynamic.text.measure.label.txt") %>
                                    </label>
                                </td>
                                <td style="width:55%">
                                    <html:select style="width: 100%" property="measure" styleClass="dropdown" styleId="measure">
                                        <html:optionsCollection property="measures"/>
                                    </html:select>
                                </td>
                                <td style="padding-left:8px">
                                <%
                                    CitationButton measureButton = CitationButton.createStandaloneButton(request, "measureButton",
                                        PagePropertyBean.getLabelWithMnemonic(pageContext,"insert.label.txt"),
                                        "javascript:WRS_onInsertDynamicText(findDOM('measure'),9);");
                                    measureButton.setPlainButtonText(true);
                                    measureButton.setAccessKey(PagePropertyBean.getMnemonic(pageContext,"insert.label.txt"));
                                    measureButton.setAlternateText(PagePropertyBean.getLabel(pageContext,"insert.label.txt"));
                                    measureButton.write(out);
                                %>
                                </td>
                                <script type="text/javascript">
                                    setButtonState(null, 'measureButton', setButtonState.DISABLED);
                                </script>                                
                            </tr>      
                            ******************************************************************* -->
                            
                            <tr>
                                <td class="header" style="width:30%;">
                                    <label for="prompt"
                                        accesskey='<%= PagePropertyBean.getMnemonic(pageContext, "dynamic.text.prompt.label.txt") %>' >
                                        <%= PagePropertyBean.getLabelWithMnemonic(pageContext, "dynamic.text.prompt.label.txt") %>
                                    </label>
                                </td>
                                <td style="width:55%">
                                    <html:select style="width: 100%" property="prompt" styleClass="dropdown" styleId="prompt">
                                        <html:optionsCollection property="prompts"/>
                                    </html:select>
                                </td>
                                <td style="padding-left:8px">
                                <%
                                    CitationButton promptButton = CitationButton.createStandaloneButton(request, "promptButton",
                                        PagePropertyBean.getLabelWithMnemonic(pageContext,"insert.label.txt"),
                                        "javascript:WRS_onInsertDynamicText(findDOM('prompt'),8);");
                                    promptButton.setPlainButtonText(true);
                                    promptButton.setAccessKey(PagePropertyBean.getMnemonic(pageContext,"insert.label.txt"));
                                    promptButton.setAlternateText(PagePropertyBean.getLabel(pageContext,"insert.label.txt"));
                                    promptButton.write(out);
                                %>
                                </td>
                                <script type="text/javascript">
                                    setButtonState(null, 'promptButton', setButtonState.DISABLED);
                                </script>                                
                            </tr>      
                            
                            <tr>
                                <td class="header" style="width:30%;">
                                    <label for="dynamicText"
                                                accesskey='<%= PagePropertyBean.getMnemonic(pageContext, "builder.headerfooter.other.label.txt") %>' >
                                                <%= PagePropertyBean.getLabelWithMnemonic(pageContext, "builder.headerfooter.other.label.txt") %>
                                    </label>
                                </td>
                                <td style="width:55%">
                                    <html:select style="width: 100%" property="dynamicText" styleClass="dropdown" styleId="dynamicText">
                                        <html:optionsCollection property="dynamicTexts"/>
                                    </html:select>
                                </td>
                                <td style="padding-left:8px">
                                <%
                                    CitationButton insertButton = CitationButton.createStandaloneButton(request, "dynamicTextButton",
                                        PagePropertyBean.getLabelWithMnemonic(pageContext,"builder.headerfooter.insert.txt"),
                                        "javascript:onInsertDynamicText(findDOM('dynamicText'));");
                                    insertButton.setAccessKey(PagePropertyBean.getMnemonic(pageContext,"builder.headerfooter.insert.txt"));
                                    insertButton.setAlternateText(PagePropertyBean.getLabel(pageContext,"insert.label.txt"));
                                    insertButton.write(out);
                                %>
                                </td>
                            </tr>                                                                                                    
                            
                        </table>
                    </td>
                </tr>

            </table>


        </div> <!-- end of richTextDiv -->
        
        <!-- content image preview and alignment subpane, only visible when content is image -->
        
        <div id="contentImageDiv" style="display:none">
            <div id="contentImageThumbnailContainer" style="width:100%;">
                <div id="contentThumbnailContainer_imageSelected" align="center">
                    <img id="contentThumbnailImageElement" src="<%=middleInitialImageUrl%>" alt="" style="border: 1px solid #919190;" />
                </div>
            </div>
        </div> <!-- end of contentImageDiv -->
        
    </div> <!-- end of contentTemplateDiv -->

    <!-- Layout table for horizontal line checkbox -->
            
    <table style="width:98%;padding:8px;padding-right:0px;" border="0" cellpadding="0" cellspacing="0" summary="">
        <tr>
            <td class="dialogHeaderNormal">
<%
      // set up the divider message and access key based on the form action - header vs. footer
      String dividerMessage = PagePropertyBean.getLabelWithMnemonic(pageContext, "style.divider.footer.label.txt");
      String accessKey = PagePropertyBean.getMnemonic(pageContext, "style.divider.footer.label.txt");
      if (((String)request.getAttribute("FORM_ACTION")).equals("builderHeader.do"))  
      {
          dividerMessage = PagePropertyBean.getLabelWithMnemonic(pageContext, "style.divider.header.label.txt");
          accessKey = PagePropertyBean.getMnemonic(pageContext, "style.divider.header.label.txt");
      }
%>

                <html:checkbox styleId="dividerCheckbox" property="divider"  value="true" accesskey="<%=accessKey%>" >
                    <span class="label">
                        <label for="dividerCheckbox"><%= dividerMessage %></label>
                    </span>
                </html:checkbox>
            </td>
        </tr>
    </table>


</div> <!-- end of dialogContainer -->



</citation:form>


<script type="text/javascript"> /*<![CDATA[*/

// Instantiate a citation_RichEditor that will contain citation_RichTextEditor,
// and provide added WRS-specific functionality.
g_RichEditor = new citation_RichEditor("<%=editorVar%>", true); // Is for header or footer

g_RichEditor.setJspString("style.noTextSelected.txt", "<%=msgNoTextSelected%>");
g_RichEditor.setJspString("error.dynamic.text.cannot.insert.txt", "<%=msgCannotInsertDynamic%>");
g_RichEditor.setJspString("error.text.hyperlink.nothing.selected.txt", "<%=msgLinkNothingSelected%>");
g_RichEditor.setJspString("error.text.hyperlink.cannot.create.txt", "<%=msgLinkCannotCreate%>");
g_RichEditor.setJspString("error.text.hyperlink.multiple.select.txt", "<%=msgLinkMultipleSelect%>");
g_RichEditor.setJspString("error.richtexteditfield.multi.para.style.change.txt", "<%=msgMultiParaStyleChange%>");
g_RichEditor.setJspString("msgTooltipHyperlink", "<%=msgTooltipHyperlink%>");
g_RichEditor.setJspString("overrideColor", "<%=overrideColor%>");
g_RichEditor.setJspString("overrideBackgroundColor", "<%=overrideBackgroundColor%>");
g_RichEditor.setJspString("initialSelection", "<%=initialSelection %>");

g_RichEditor.setJspString("CitationDialogAction.DIALOG_CMD_KEY", "<%=CitationDialogAction.DIALOG_CMD_KEY%>");
g_RichEditor.setJspString("CitationDialogAction.CMD_APPLY_DIALOG_KEY", "<%=CitationDialogAction.CMD_APPLY_DIALOG_KEY%>");
g_RichEditor.setJspString("CitationDialogAction.CMD_OK_DIALOG_KEY", "<%=CitationDialogAction.CMD_OK_DIALOG_KEY%>");

g_RichEditor.setJspString("formAction", "<%= formAction %>");


// Set up "after advice" hook to initialize the citation_RichEditor when
// the citation_RichTextEditor is done initializing:
dojo.event.kwConnect({srcObj:<%=textEditVar%>, srcFunc:"waitBodyReady", targetObj:g_RichEditor, targetFunc:"onEditFieldInitialized"});

// Performs the inverse function to CommonUtils.htmlEncode(String s)
// and also converts encoded quotes.
function WRS_htmlDecode(str) {
    value = str;
    value = value.replace(/&lt;/g,"<");
    value = value.replace(/&gt;/g,">");
    value = value.replace(/&#40;/g,"(");
    value = value.replace(/&#41;/g,")");
    value = value.replace(/&#35;/g,"#");
    value = value.replace(/&quot;/g,'"');
    value = value.replace(/&amp;/g,"&");
    return value;
}

// Set the actual initial HTML on the RichTextEditorWRS after it has been fully initialized and is ready
function WRS_waitForInitialized() {
    g_countWaitForInitialized +=1;
    if (g_countWaitForInitialized > 16) // Give IE 4 seconds max to get its act together
    {
        alert("ERROR: Unable to initialize RTE in builderHeaderFooterDialogContent");
    }
    else {  // Normal
        if (g_RichEditor.initialized) { // Is ready?
            selectTab("middle");    // Always show the middle tab initially
        }
        else
        {
            setTimeout("WRS_waitForInitialized();", 250);   // Try again in 250 ms
        }
    }
}


var g_countWaitForInitialized = 0;
setTimeout("WRS_waitForInitialized();", 250); 

//  (brcarb) Used by citation_RichEditor.js to decide how to generate dynamic items:
var g_useLegacyDynamicItems = <%=useLegacyDynamicItems%>;	// false if using square bracketd dynamic items

// Variables for width of left/middle/right content area:
var g_leftWidthStr = '<%=leftWidth%>';
var g_middleWidthStr = '<%=middleWidth%>';
var g_rightWidthStr = '<%=rightWidth%>';

// Variables to track type of content selected for left/middle/right
var g_leftContentOption = "<%=leftContentOption%>";  // "OPTION_NONE", "OPTION_TEXT", or a URL for an image
var g_middleContentOption = "<%=middleContentOption%>";
var g_rightContentOption = "<%=rightContentOption%>";

// Variables for left/middle/right text content initialization and temporary storage when switch RTE content:
var g_leftHtmlText = '<%=leftInitialHtml%>';    // Encoded left HTML content
var g_middleHtmlText = '<%=middleInitialHtml%>';
var g_rightHtmlText = '<%=rightInitialHtml%>';

// Variables for image alignment within left/middle/right content area
var g_leftImageAlignment = '<%=leftImageAlignment%>';
var g_middleImageAlignment = '<%=middleImageAlignment%>';
var g_rightImageAlignment = '<%=rightImageAlignment%>';

//Variables for full URL of images (e.g. "htttp;...", not just "SBIP:..." as for contentOptions above
var g_leftImageUrl = "<%=leftInitialImageUrl%>"; 
var g_middleImageUrl = "<%=middleInitialImageUrl%>";
var g_rightImageUrl = "<%=rightInitialImageUrl%>";

// Variables for the image link actions (which come from the image link dialog)
var g_leftImageLink = "<%=leftImageLink%>";
var g_middleImageLink = "<%=middleImageLink%>";
var g_rightImageLink = "<%=rightImageLink%>";

if(g_leftImageLink == "null") g_leftImageLink = null;
if(g_middleImageLink == "null") g_middleImageLink = null;
if(g_rightImageLink == "null") g_rightImageLink = null;

// Variables for the image link tooltips (which come from the image link dialog)
var g_leftImageTooltip = "<%=leftImageTooltip%>";
var g_middleImageTooltip = "<%=middleImageTooltip%>";
var g_rightImageTooltip = "<%=rightImageTooltip%>";

if(g_leftImageTooltip == "null") g_leftImageTooltip = null;
if(g_middleImageTooltip == "null") g_middleImageTooltip = null;
if(g_rightImageTooltip == "null") g_rightImageTooltip = null;

// Variables for the image link use current window checkbox (which come from the image link dialog)
var g_leftImageUseCurrentWindow = "<%=leftImageUseCurrentWindow%>";
var g_middleImageUseCurrentWindow = "<%=middleImageUseCurrentWindow%>";
var g_rightImageUseCurrentWindow = "<%=rightImageUseCurrentWindow%>";

//if(g_leftImageUseCurrentWindow == "null") g_leftImageUseCurrentWindow = null;
//if(g_middleImageUseCurrentWindow == "null") g_middleImageUseCurrentWindow = null;
//if(g_rightImageUseCurrentWindow == "null") g_rightImageUseCurrentWindow = null;

// Variable for the image link type (which come from the image link dialog)
var g_leftImageLinkType = "<%=leftImageLinkType%>";
var g_middleImageLinkType = "<%=middleImageLinkType%>";
var g_rightImageLinkType = "<%=rightImageLinkType%>";

// variables for dialog state management:
var g_leftMiddleRight = "middle";   // which tab is currently active, "left", "middle" or "right"
var g_contentKind = "none";   // which content preview state is currenlty visible,, "none", "text" or "image"

var g_errorMessageWidth = "<%=msgInvalidWidth%>";  
var g_errorMessageSumWidths = "<%=msgInvalidWidthSum%>";

// Remove the encoding from the initial HTML:
g_leftHtmlText = WRS_htmlDecode(g_leftHtmlText);
g_middleHtmlText = WRS_htmlDecode(g_middleHtmlText);
g_rightHtmlText = WRS_htmlDecode(g_rightHtmlText);

// Variables for left/middle/right text content, cleaned up and ready to send to server
// (initialized in case no changes are made):
var g_leftOutputHtmlText = g_leftHtmlText;  // use decoded initial value
var g_middleOutputHtmlText = g_middleHtmlText;
var g_rightOutputHtmlText = g_rightHtmlText;

function saveRTEText() {
    var textEdit = g_RichEditor.textEdit;
    if ("left" == g_leftMiddleRight) {
        g_leftHtmlText = textEdit.getHtml();    // Save "raw" HTML from the RTE (for switching)
        g_leftOutputHtmlText = WRS_getResultHtml();  // Save corrected HTML from RTE (for sending to server)
    }
    else if ("middle" == g_leftMiddleRight) {
        g_middleHtmlText = textEdit.getHtml();
        g_middleOutputHtmlText = WRS_getResultHtml();
    }
    else if ("right" == g_leftMiddleRight) {
        g_rightHtmlText = textEdit.getHtml();
        g_rightOutputHtmlText = WRS_getResultHtml();
    }
}


// Save the current content selections (width, contentOption, rich text, 
// image, image alignment) to the appropriate gloabal vars
function saveContent()
{
    saveRTEText();
    var inputTextWidth = dojo.byId("inputTextWidth");
    var widthStr = inputTextWidth.value;
    var contentCombo = dojo.byId("contentCombo");
    var itemIndex = contentCombo.selectedIndex;
    if ("left" == g_leftMiddleRight) {
        g_leftWidthStr = widthStr;
        g_leftContentOption = contentCombo.options[itemIndex].value;
        // TODO: Save the imageAlignment too
    }
    else if ("middle" == g_leftMiddleRight) {
        g_middleWidthStr = widthStr;
        g_middleContentOption = contentCombo.options[itemIndex].value;
    }
    else if ("right" == g_leftMiddleRight) {
        g_rightWidthStr = widthStr;
        g_rightContentOption = contentCombo.options[itemIndex].value;
    }
    
}

// tab is "left", "middle", or "right"
function selectTab(tab)
{
    var textEdit = g_RichEditor.textEdit;
    var inputTextWidth = dojo.byId("inputTextWidth");
    var contentCombo = dojo.byId("contentCombo");
    var contentThumbnailImageElement = dojo.byId("contentThumbnailImageElement");
    var itemIndex; 
    var widthStr;   // e.g., "100"
    var contentOption;  // "OPTION_NONE", "OPTION_TEXT", or URL (e.g. "SBIP:...")
    var htmlText;   // for the RTE
    var imageUrl;   // actual image URL (starting with "http:...")
    var imageAlignment; // "left", "center" or "right"

    g_leftMiddleRight = tab;   // new tab 
    // Retrieve the prior state info about the new tab:
    if ("left" == tab) {
        widthStr = g_leftWidthStr;
        contentOption = g_leftContentOption;
        htmlText = g_leftHtmlText;
        imageUrl = g_leftImageUrl;
        imageAlignment = g_leftImageAlignment;
    }
    if ("middle" == tab) {
        widthStr = g_middleWidthStr;
        contentOption = g_middleContentOption;
        htmlText = g_middleHtmlText;
        imageUrl = g_middleImageUrl;
        imageAlignment = g_middleImageAlignment;
    }
    else if ("right" == tab) {
        widthStr = g_rightWidthStr;
        contentOption = g_rightContentOption;
        htmlText = g_rightHtmlText;
        imageUrl = g_rightImageUrl;
        imageAlignment = g_rightImageAlignment;
        
    }
    // Set the controls to the new values:
    inputTextWidth.value = widthStr;
    
    
    // Set the correct selection in the Content combo:    
    itemIndex = findIndexForOption(contentCombo, contentOption);
    itemIndex = (itemIndex >=0) ? itemIndex : 0;
    contentCombo.selectedIndex = itemIndex;
    
    // Show the correct container for the selected content option:
    var contentKind = "image";  // assume for now    
    if ("OPTION_TEXT" == contentOption) {
        contentKind = "text";
    }
    else if ("OPTION_NONE" == contentOption) {
        contentKind = "none";
    }
    selectContentKind(contentKind);
    
    // Install the correct content for the selected content container'a controls
    if ("OPTION_TEXT" == contentOption) {
        textEdit.setInitialBodyHtml(htmlText);  // Install the RTE text
    }
    else if ("OPTION_NONE" != contentOption)  { // Is an image?
        if (imageUrl && imageUrl.length > 0) {   // Have successfully fetched the full URL already?
            contentThumbnailImageElement.src = imageUrl;
        }
        else { // Was unsuccessful previously getting image, try again
            requestContentImage(contentOption);
        }
        setContentImageAlign(imageAlignment);
    }
    
    
    if ("text" != contentKind) {
        inputTextWidth.focus();
    }
    else {  // is text
        // (S0619502) textEdit.focus();
        setTimeout("onTimeoutEndSetFocus();", 500); // Need delay for IE        
    }
    
}

// Returns the index for the option of the given select element that matches the given value,
// or -1 if none.
function findIndexForOption(comboElem, value)
{
    var options = comboElem.options;
    for (var index=0; index<options.length; index++)
    {
        if (options[index].value == value) {
            return index;    
        }
    }
    return -1;
}

// tab is "left", "middle" or "right"
function onClickTabButton(tab)
{
    saveContent();
    selectTab(tab);
}

// contentKind is "none", "text" or "image"
function selectContentKind(contentKind) {
    var contentImageDiv = dojo.byId("contentImageDiv");   
    var richTextDiv = dojo.byId("richTextDiv");
    var contentImageAlignmentDiv = dojo.byId("contentImageAlignmentDiv");
    if ("image" == contentKind) { 
        wrsShowElement(richTextDiv, false);
        wrsShowElement(contentImageDiv, true);
        contentImageAlignmentDiv.style.visibility="visible";
        g_contentKind = "image";
    }
    else if ("text" == contentKind) { 
        wrsShowElement(richTextDiv, true);
        wrsShowElement(contentImageDiv, false);
        contentImageAlignmentDiv.style.visibility="hidden";
        g_contentKind = "text";
    }
    else {  // Is none
        wrsShowElement(richTextDiv, false);
        wrsShowElement(contentImageDiv, false);
        contentImageAlignmentDiv.style.visibility="hidden";
        g_contentKind = "none";
    }
    
}

function onChangeContentCombo(event) {
    var contentCombo = dojo.byId("contentCombo");
    if ("text" == g_contentKind) { // Currently showing RTE?
        saveRTEText();
    }
    
    var itemIndex = contentCombo.selectedIndex;
    var contentKind = "none";   // assume
    if (itemIndex > 1) {  // Is an image    
        contentKind = "image";
        var contentOption = contentCombo.options[itemIndex].value;
        requestContentImage(contentOption);
    }
    else if (1 == itemIndex) {    // Is text
        contentKind = "text"
    }
     // Must select before changing text content (if applicable),
     // because you can't set the focus to a non-visible component.
    selectContentKind(contentKind);
    if ("text" == contentKind) {
        var htmlText = g_middleHtmlText;    // Assume
        if ("left" == g_leftMiddleRight) {
            htmlText =  g_leftHtmlText;
        }
        else if ("right" == g_leftMiddleRight) {
            htmlText =  g_rightHtmlText;
        }
        var textEdit = g_RichEditor.textEdit;
        textEdit.setInitialBodyHtml(htmlText);  // Install the RTE text
        //textEdit.focus();
        setTimeout("onTimeoutEndSetFocus();", 500); // Need delay for IE
    }
    else if ("image" == contentKind) {  // S0620245
        var imageAlign = g_middleImageAlignment;    // Assume
        if ("left" == g_leftMiddleRight) {
            imageAlign = g_leftImageAlignment;
        }
        else if ("right" == g_leftMiddleRight) {
            imageAlign = g_rightImageAlignment;    
        }
        setContentImageAlign(imageAlign);    // Adjust the alignment of the image and select the image button
    }
}

// (S0615010) Needed to work around IE problem with not taking focus:
function onTimeoutEndSetFocus() {
    var textEdit = g_RichEditor.textEdit;
    textEdit.focus();
    //textEdit.getSelectionRange();
    textEdit.selectionChanged(); //S0619492    
    g_RichEditor.textEdit.focus();
}

function onKeyUpWidthText(event)
{
    var inputTextWidth = dojo.byId("inputTextWidth");
    var value = inputTextWidth.value;
    updateTabLabelPercent(g_leftMiddleRight, value);
}

// tab is "left", "middle" or "right". 
function updateTabLabelPercent(tab, widthValueStr) {
    var tabLabelElem;
    var tabLabel;
    if ("left" == tab) {
        tabLabelElem = dojo.byId("leftTabButton_label");
        tabLabel = "<%= leftContentText %>";
    }
    else if ("right" == tab) {
        tabLabelElem = dojo.byId("rightTabButton_label");
        tabLabel = "<%= rightContentText %>";
    }
    else {
        tabLabelElem = dojo.byId("middleTabButton_label");
        tabLabel = "<%= middleContentText %>";
    }
    tabLabelElem.innerHTML = tabLabel.replace(/\{0\}/i, widthValueStr);
    
}


// Returns int width value, 0-100 for given input element, or -1 if error
// (with error message already displayed, and focus set to the offending element)
// Note that we can't validate widths on change of tab because TabMenu 
// uncondtionally changes tabs on click and that event cannot be stopped.
function parseContentWidth(widthStr) {
    var iVal = -1;
    var value = widthStr.replace(/\s/g, "");  // trim blanks
    //iVal = value.search(/^\d+$/g);
    if (value.search(/^\d+$/g) >= 0) {   // Contains only digits?
        iVal = parseInt(value);
        if (iVal < 0 || iVal > 100) {
            iVal = -1;  // error    
        }
    }
    if (iVal < 0)  {
        alert(g_errorMessageWidth);
    }
    return iVal;
}


// Set alignment property for the content image and show the 
//corresponding alignment button as selected
// value is 'left", "center" (not middle!) or "right"
function setContentImageAlign(value)
{
    if ("left" == g_leftMiddleRight) {
        g_leftImageAlignment = value;       
    }
    else if ("middle" == g_leftMiddleRight) {
        g_middleImageAlignment = value;       
    }
    else if ("right" == g_leftMiddleRight) {
        g_rightImageAlignment = value;       
    }
    var contentImageAlignLeftDiv = dojo.byId("contentImageAlignLeftDiv");
    var contentImageAlignCenterDiv = dojo.byId("contentImageAlignCenterDiv");   // Note: center, not middle!
    var contentImageAlignRightDiv = dojo.byId("contentImageAlignRightDiv");
    
    // Show the image buttons as selected or not
    contentImageAlignLeftDiv.className = ("left" == value) ? "imageSelectedStyle" : "imageStyle";
    contentImageAlignCenterDiv.className = ("center" == value) ? "imageSelectedStyle" : "imageStyle";
    contentImageAlignRightDiv.className = ("right" == value) ? "imageSelectedStyle" : "imageStyle";
    
    // Set the alignment in the preview:
    var contentThumbnailDiv = dojo.byId("contentThumbnailContainer_imageSelected");
    contentThumbnailDiv.align = value;
}

// contentOption is the URL string representing the Citation URL (i.e, starts with "HBIP:...")
// Make an AJAC call to get the actual full URL
function requestContentImage(contentOption) {
    var dialogCommandFormField = findDOM(g_RichEditor.getJspString("CitationDialogAction.DIALOG_CMD_KEY"));
    dialogCommandFormField.value = g_RichEditor.getJspString("CitationDialogAction.CMD_APPLY_DIALOG_KEY");
    // Get the selected image info:
    var objForm = document.forms['builderHeaderFooterForm'];
    // Make AJAX call to the Image utility to get the equivalent URL needed:
    var requestUrlStr = "builderBrowseImageRespositoryApplyCommand.do?dialogCommand=applyDialog&applyCommand=processThumbnailRequest&selectedImageForThumbnailUrl="+contentOption;
    dojo.io.bind({
            method: "POST",
            url: requestUrlStr,
            handle: function(type, data, evt){onContentImageResponse(type, data, evt);},
            formNode: objForm,
            mimetype: "text/plain"
    });
}

// Process server response for AJAX request for image
function onContentImageResponse(type, data, evt) {
    if (data != null)  {
        var contentThumbnailImageElement = dojo.byId("contentThumbnailImageElement");
        if (contentThumbnailImageElement) {
            if ("" != data) {   // Successful?
                // Save the actual, full URL (i.e., starts with "http:..."):
                contentThumbnailImageElement.src=data;
                if ("left" == g_leftMiddleRight) {
                    g_leftImageUrl = data;
                }
                else if ("right" == g_leftMiddleRight) {
                    g_rightImageUrl = data;
                }
                else {
                    g_middleImageUrl = data;
                }
            }
        }
    }
    var dialogCommandFormField = findDOM(g_RichEditor.getJspString("CitationDialogAction.DIALOG_CMD_KEY"));
    dialogCommandFormField.value = g_RichEditor.getJspString("CitationDialogAction.CMD_OK_DIALOG_KEY");
}


// Validate the values in the controls, and if OK, copy the formatted results
// into the hidden elements and return true.  If invalid, give error message and return false.
function validateValues() {
    var iLeftWidth = parseContentWidth(g_leftWidthStr);
    if (iLeftWidth < 0) {   // Invalid width (message already vien)
        return false;
    }
    var iMiddleWidth = parseContentWidth(g_middleWidthStr);
    if (iMiddleWidth < 0) {
        return false;
    }
    var iRightWidth = parseContentWidth(g_rightWidthStr);
    if (iRightWidth < 0) {
        return false;
    }
    //alert("In validateValues, iLeftWidth="+iLeftWidth+", iMiddleWidth="+iMiddleWidth+", iRightWidth="+iRightWidth);
    var iSum = iLeftWidth + iMiddleWidth + iRightWidth;
    if (100 != iSum)
    {
        alert(g_errorMessageSumWidths);
        return false;
    }
    
    // Validated OK.  Copy formatted values to the hidden elements to be submitted to the server:
    var leftContentOptionHidden = dojo.byId("leftContentOptionHidden");
    leftContentOptionHidden.value = g_leftContentOption;
    var middleContentOptionHidden = dojo.byId("middleContentOptionHidden");
    middleContentOptionHidden.value = g_middleContentOption;
    var rightContentOptionHidden = dojo.byId("rightContentOptionHidden");
    rightContentOptionHidden.value = g_rightContentOption;
    
    var leftWidthHidden = dojo.byId("leftWidthHidden");
    leftWidthHidden.value = ""+iLeftWidth;
    var middleWidthHidden = dojo.byId("middleWidthHidden");
    middleWidthHidden.value = ""+iMiddleWidth;
    var rightWidthHidden = dojo.byId("rightWidthHidden");
    rightWidthHidden.value = ""+iRightWidth;
    
    // Keep the HTML text only if "Text" was chosen from the corresponding combo box for content:
    var leftHtmlHidden = dojo.byId("leftHtmlHidden");
    leftHtmlHidden.value = ("OPTION_TEXT" == g_leftContentOption) ? g_leftOutputHtmlText : "";
    var middleHtmlHidden = dojo.byId("middleHtmlHidden");
    middleHtmlHidden.value = ("OPTION_TEXT" == g_middleContentOption) ? g_middleOutputHtmlText : "";
    var rightHtmlHidden = dojo.byId("rightHtmlHidden");
    rightHtmlHidden.value = ("OPTION_TEXT" == g_rightContentOption) ? g_rightOutputHtmlText : "";
    
    var leftImageAlignmentHidden = dojo.byId("leftImageAlignmentHidden");
    leftImageAlignmentHidden.value = g_leftImageAlignment;
    var middleImageAlignmentHidden = dojo.byId("middleImageAlignmentHidden");
    middleImageAlignmentHidden.value = g_middleImageAlignment;
    var rightImageAlignmentHidden = dojo.byId("rightImageAlignmentHidden");
    rightImageAlignmentHidden.value = g_rightImageAlignment;

    // Keep the image link(s) only if "Text" was not chosen from the corresponding combo box for content:
    if(g_leftImageLink != "null" && g_leftImageLink != null) {
        var leftImageLinkHidden = dojo.byId("leftImageLinkHidden");
        leftImageLinkHidden.value = ("OPTION_TEXT" == g_leftContentOption) ? "" : g_leftImageLink;
    }
    if(g_middleImageLink != "null" && g_middleImageLink != null) {
        var middleImageLinkHidden = dojo.byId("middleImageLinkHidden");
        middleImageLinkHidden.value = ("OPTION_TEXT" == g_middleContentOption) ? "" : g_middleImageLink;
    }
    if(g_rightImageLink != "null" && g_rightImageLink != null) {
        var rightImageLinkHidden = dojo.byId("rightImageLinkHidden");
        rightImageLinkHidden.value = ("OPTION_TEXT" == g_rightContentOption) ? "" : g_rightImageLink;
    }
    
    // Keep the image tooltip(s) only if "Text" was not chosen from the corresponding combo box for content:
    if(g_leftImageTooltip != "null" && g_leftImageTooltip != null) {
        var leftImageTooltipHidden = dojo.byId("leftImageTooltipHidden");
        leftImageTooltipHidden.value = ("OPTION_TEXT" == g_leftContentOption) ? "" : g_leftImageTooltip;
    }
    if(g_middleImageTooltip != "null" && g_middleImageTooltip != null) {
        var middleImageTooltipHidden = dojo.byId("middleImageTooltipHidden");
        middleImageTooltipHidden.value = ("OPTION_TEXT" == g_middleContentOption) ? "" : g_middleImageTooltip;
    }
    if(g_rightImageTooltip != "null" && g_rightImageTooltip != null) {
        var rightImageTooltipHidden = dojo.byId("rightImageTooltipHidden");
        rightImageTooltipHidden.value = ("OPTION_TEXT" == g_rightContentOption) ? "" : g_rightImageTooltip;    
    }
 
    // Keep the image use current window(s) only if "Text" was not chosen from the corresponding combo box for content:
    if(g_leftImageUseCurrentWindow != "null" && g_leftImageUseCurrentWindow != null) {
        var leftImageUseCurrentWindowHidden = dojo.byId("leftImageUseCurrentWindowHidden");
        leftImageUseCurrentWindowHidden.value = g_leftImageUseCurrentWindow;
    }
    if(g_middleImageUseCurrentWindow != "null" && g_middleImageUseCurrentWindow != null) {
        var middleImageUseCurrentWindowHidden = dojo.byId("middleImageUseCurrentWindowHidden");
        middleImageUseCurrentWindowHidden.value = g_middleImageUseCurrentWindow;
    }
    if(g_rightImageUseCurrentWindow != "null" && g_rightImageUseCurrentWindow != null) {
        var rightImageUseCurrentWindowHidden = dojo.byId("rightImageUseCurrentWindowHidden");
        rightImageUseCurrentWindowHidden.value = g_rightImageUseCurrentWindow;    
    }
       
    return true;
}

function onClickButtonOk(event)
{
    saveContent();
    if (validateValues()) {
            dialogSubmit();
    }
}

function dialogSubmit() {
    var theForm = document.forms['<%= formToUse %>'];
      
    <%
    if (showDebugControls) {
        %>
        var theHtml = null;
        var which="";
        if ("left" == g_leftMiddleRight && "OPTION_TEXT" == g_leftContentOption) {
            which = "left";
            theHtml = dojo.byId("leftHtmlHidden").value
        }
        else if ("middle" == g_leftMiddleRight && "OPTION_TEXT" == g_middleContentOption) {
            theHtml = dojo.byId("middleHtmlHidden").value
            which = "middle";
        }
        else if ("right" == g_leftMiddleRight && "OPTION_TEXT" == g_rightContentOption) {
            which = "right";
            theHtml = dojo.byId("rightHtmlHidden").value
        }
        if (theHtml) {
            alert("In dialogSubmit(), "+which+" HTML="+theHtml);
        }
        
        <%
    } // end if showDebugControls
    %>
    eventNotify(theForm,'submit',false);
    theForm.submit();
}

// Added for WRS 4.3 hotfix:

// Note: This is a function, not a method:
// Event handler for image Hyperlink click.
// Added for WRS 4.3 hotfix
function WRS_onWaitCreateImageHyperLink() 
{
    //alert("In WRS_onWaitCreateImageHyperLink()");
    //S0503903: Don't set focus, it messes up IE selection in some cases:
    //g_RichEditor.textEdit.focus();  // Restore the selection in the text edit field
    // Note: must wait a while to have selection object updated in text edit element:
    setTimeout('onClickImageHyperlink()', 50);
    return false;
}

// Method citation_RichEditor.onClickImageHyperlink()
// Process click (or Enter) on Hyperlink button in extended FontPicker toolbar.
// Note that there is no evt arg passed.
function onClickImageHyperlink() 
{
    // alert("In onClickImageHyperlink()");
    
    var params = '';
    var imageLink = '';
    var imageTooltip = '';
    var linkType = '';
    var useCurrentWindow = '';
    var linked = false;
    // figure out which tab is selected and then pull any previous selected image and tooltip
    if("left" == g_leftMiddleRight) {
        if(g_leftImageLink != null && g_leftImageLink != '')
        {
            imageLink = g_leftImageLink;
            imageTooltip = g_leftImageTooltip;  
            linkType = g_leftImageLinkType; 
            linked = true;   
            useCurrentWindow = g_leftImageUseCurrentWindow;
        }
    }
    else if("middle" == g_leftMiddleRight) {
        if(g_middleImageLink != null && g_middleImageLink != '')
        {
            imageLink = g_middleImageLink;
            imageTooltip = g_middleImageTooltip;  
            linkType = g_middleImageLinkType; 
            linked = true;   
            useCurrentWindow = g_middleImageUseCurrentWindow;  
        }    
    }
    else if("right" == g_leftMiddleRight) {
        if(g_rightImageLink != null && g_rightImageLink != '')
        {
            imageLink = g_rightImageLink;
            imageTooltip = g_rightImageTooltip;  
            linkType = g_rightImageLinkType;  
            linked = true;   
            useCurrentWindow = g_rightImageUseCurrentWindow; 
        }    
    }
    
    // alert("In onClickImageHyperlink() linked: " + linked + " image link: " + imageLink + " tooltip: " + imageTooltip + " useCurrentWindow: " + useCurrentWindow + " link type: " + linkType);
    
    var params = '&forImageLink=true&fromHeaderFooter=true&';
    if(linked == true)
    {
        params += 'linked=' + linked + '&linkType=' + linkType + '&tooltipText=' + encodeURI(imageTooltip) + '&useCurrentWindow=' + useCurrentWindow;   
        if(linkType == 'ANOTHER_REPORT')
            params += '&reportUrl=' + encodeURIComponent(imageLink);
        else
            params += '&webUrl=' + encodeURIComponent(imageLink);   
    }         

    // S0481095: Following 3 lines commented out due to CDD change:
    //if (this.textEdit.isBrowserIE) {
    //    this.textEdit.focusBookmark = this.textEdit.selectionRange.getBookmark();  // Save current selection
    //}
    var winHandle = cwDialogManager.openDialog(
            'builderTextLinking.do?dialogCommand=openDialog' + params, //dlgUrl
            cwDialogManager.BUILDER_TEXT_LINK, // dlgName
            cwDialogManager.BUILDER_TEXT_LINK, // dlgFeatures
            true,  // bReplaceUrl
            true,  // bModal
            true,  // bReplaceIfOpen
            null,  // onDialogClosingFunc
            null,  // onDlgClosedFunc
            function (status, newDlg) { // Callback function when dialog exists
                    showDebugMsgs("onClickImageHyperlink", "In callback, status="+status);
                    if ('ready' == status || 'exists' == status) {  // normal
                        // ************** IMPORTANT NOTE!!! **************
                        // *** Do *NOT* attempt to replace the following lines with
                        // *** "equivalent" calls to registerEventHandler() or dojo.event.connect()!
                        // *** They will not work (because they do "closure magic" that assumes
                        // *** the handler node is in the same window as this one, which it is not)!
                        // ************************************************
                        if (newDlg.dlgWindow.addEventListener) {  // DOM way
                            newDlg.dlgWindow.addEventListener("unload", function(){WRS_processImageLink(newDlg.dlgWindow);}, false);
                        }
                        else if (newDlg.dlgWindow.attachEvent) { // IE way
                            newDlg.dlgWindow.attachEvent( "onunload", function(){WRS_processImageLink(newDlg.dlgWindow);});
                        }
                        // *** See note above!
                    }
                }
            );
    return;
}

// callback function to handle creation of hyperlink, after the dialog
// for setting the hyperlink values is closing
// linkElem is null if no existing <a>
function WRS_processImageLink(linkingDialog) 
{
    if (linkingDialog && ! linkingDialog.g_okInReportLinking) {  // (S0478574) was linkind dialog just canceled?
        return false
    }
    var form = linkingDialog.window.document.forms['buildReportLinkDialogForm'];
    if (form == null) return;
    if (form.elements['linked'].checked == false)
    {
        if(g_leftMiddleRight == "left")
        {
            g_leftImageLink = "";
            g_leftImageTooltip = "";
            g_leftImageLinkType = "";
            g_leftImageUseCurrentWindow = false;
        }
        else
        if(g_leftMiddleRight == "middle")
        {
            g_middleImageLink = "";
            g_middleImageTooltip = "";
            g_middleImageLinkType = "";
            g_middleImageUseCurrentWindow = false;
        }
        else
        if(g_leftMiddleRight == "right")
        {
            g_rightImageLink = ""; 
            g_rightImageTooltip = ""; 
            g_rightImageLinkType = "";
            g_rightImageUseCurrentWindow = false;  
        }    
        return;
    }
    var linkTypeRadio = form.elements['linkType'];
    var tooltip = form.elements['tooltip'].value;
    var destination = '';
    var linkType = 'WEB_SITE';
    if (linkTypeRadio[0].checked == true) {
        destination = form.elements['reportUrl'].value;
        linkType = 'ANOTHER_REPORT';
    } else if (linkTypeRadio[1].checked == true) {
        destination = form.elements['webUrl'].value;
        linkType = 'WEB_SITE';
    }
    
    var useCurrentWindow = form.elements['useCurrentWindow'].checked;
    
    // alert("In WRS_processImageLink() useCurrentWindow: " + useCurrentWindow);
    
    // var newHtml = '<a href=\"\" linkType=\"' + linkType + '\" destination=\"' + destination + '\" title=\"' + tooltip + '\">' + linkText + '</A>';
    
    if(g_leftMiddleRight == "left")
    {
        g_leftImageLink = destination;
        g_leftImageTooltip = tooltip;
        g_leftImageLinkType = linkType;
        g_leftImageUseCurrentWindow = useCurrentWindow;
    }
    else
    if(g_leftMiddleRight == "middle")
    {
        g_middleImageLink = destination;
        g_middleImageTooltip = tooltip;
        g_middleImageLinkType = linkType;
        g_middleImageUseCurrentWindow = useCurrentWindow;
    }
    else
    if(g_leftMiddleRight == "right")
    {
        g_rightImageLink = destination; 
        g_rightImageTooltip = tooltip; 
        g_rightImageLinkType = linkType; 
        g_rightImageUseCurrentWindow = useCurrentWindow;
    }
    
    // alert("In WRS_processImageLink()  image link: " + destination + " tooltip: " + tooltip + " link type: " + linkType + " use current window: " + useCurrentWindow);
}

// End of WRS 4.3 hotfix 


 /*]]>*/ </script>



<!-- Begin of Optional Debug Controls -->
<%
  if (showDebugControls)
  {
%>

<style type="text/css">

#debugHead {
  margin-top:0px;
  margin-bottom:0px;
}
#debugForm {
  margin-top:0px;
  margin-bottom:0px;
}
#selectedStyleDiv, #showSelectionDiv {
  background-color: lightgrey;
  font-family: Courier New;
  font-size: 8 pt;
}
#allHtmlDiv{
  border: solid 1px black;
  font-family: Courier New;
  font-size: 8 pt;
}

</style>

<hr/>

<h3 id="debugHead">Test and Debug Controls (4.3)</h3>
<form id="debugForm" name="debugForm" action="#">
  <input id="buttonInsertHtml" type="button" onclick="onButtonInsertHtml();" value="Insert HTML..." />
  <input id="buttonAllHtml" type="button" onclick="onButtonAllHtml();" value="Show all HTML" />
  <input id="buttonClearBodyHtml" type="button" onclick="onButtonClearBody();" value="Clear BODY HTML" />
  <input id="buttonShowStyle" type="button" onclick="onButtonShowStyle();" value="Show style" />
  <input id="buttonShowSelection" type="button" onclick="onButtonShowSelection();" value="Show selection" />
  <input id="buttonTest" type="button" onclick="onButtonTest();" value="Test" />
  <input type="text" />
</form>

<div id="selectedStyleDiv">
  Style:
</div>

<div id="allHtmlDiv">
</div>

<div id="showSelectionDiv">
  Selection:
</div>

<%
  } // end if showDebugControls
%>
<!-- End of Debug Controls -->


<% } catch (Exception ex) {
    com.sas.apps.citation.view.util.PageErrorProcessor.setJspError(ex, pageContext, out);
} // END: DEBUG %>


